// ATS External Interface Structures, Error Codes, and Function Prototypes

typedef struct {
                CHAR          HolidayDate[11];
                BYTE          Format;
                CHAR          Description[32];
                } ATS_HOLIDAY_DATA, *pATS_HOLIDAY_DATA;
                      
typedef struct {
                CHAR          TaskName[13];
                long          MinRC;
                long          MaxRC;
                } ATS_JOB_EVENT_DATA;
                
typedef struct {
                CHAR          BaseDate[11];
                CHAR          BaseTime[9];
                long          Interval;
                BYTE          IntervalType;
                } ATS_PERIODIC_EVENT_DATA;
                
typedef struct {
                CHAR          FileName[CCHMAXPATH];
                BYTE          ChangeCriteria;
                SHORT         AvailabilityOptions;
                } ATS_FILE_EVENT_DATA;
                               
typedef struct {
                CHAR          EventName[13];
                CHAR          Description[100];
                BYTE          EventType;
                BOOL          ResetOnRun;
                union {
                  ATS_JOB_EVENT_DATA      JobTerm;
                  ATS_PERIODIC_EVENT_DATA Periodic;
                  ATS_FILE_EVENT_DATA     File;
                  } Detail;
                } ATS_EVENT_DATA, *pATS_EVENT_DATA;
   
typedef struct {
                CHAR          TaskName[13];
                CHAR          EventName[13];
                } ATS_LINK_DATA, *pATS_LINK_DATA;
                
typedef struct {
                CHAR          Months[37];
                CHAR          DOW[8];
                CHAR          DOM[32];
                CHAR          SDOM[6];
                int           SDOMDate;            // Not used yet
                } WHEN_TO_RUN, *pWHEN_TO_RUN;
                               
typedef struct {
                CHAR          QName[13];
                CHAR          Description[100];
                BOOL          QBlocked;
                long          Initiators;
                CHAR          StartDate[11];
                CHAR          EndDate[11];
                CHAR          StartTime[9];
                CHAR          EndTime[9];
                BYTE          PriorityGroup;
                long          PriorityDelta;
                WHEN_TO_RUN   WhenToRun;
                struct  {
                  BOOL        pPC;
                  BOOL        pPD;
                  BOOL        pB ;
                  BOOL        pMC;
                  BOOL        pD1;
                  BOOL        pD2;
                  BOOL        pT1;
                  BOOL        pT2;
                  BOOL        pD ;
                  BOOL        pMO;
                  BOOL        pDW;
                  BOOL        pDM;
                  BOOL        pSD;
                        } UpdateFields;
                } ATS_JOBQ_DATA, *pATS_JOBQ_DATA;
                
typedef struct {
                CHAR          TaskName[13];
                CHAR          Description[100];
                long          MaxConcurOccur;
                CHAR          StartDate[11];
                CHAR          EndDate[11];
                CHAR          StartTime[9];
                CHAR          EndTime[9];
                CHAR          PgmName[CCHMAXPATH];
                CHAR          PgmParms[CCHMAXPATH];
                CHAR          PgmWrkDir[CCHMAXPATH];
                BYTE          SingleRecurring;
                long          MaxOnQCnt;
                char          SessionType;
                CHAR          QName[13];
                long          PriorityInQ;
                WHEN_TO_RUN   WhenToRun;
                BOOL          Independent;
                BOOL          CommandFile;
                BOOL          Background;
                CHAR          EventName[5][13];
                struct  {
                  BOOL        pPN;
                  BOOL        pP ;
                  BOOL        pW ;
                  BOOL        pSR;
                  BOOL        pMC;
                  BOOL        pOQ;
                  BOOL        pD1;
                  BOOL        pD2;
                  BOOL        pT1;
                  BOOL        pT2;
                  BOOL        pS ;
                  BOOL        pQ ;
                  BOOL        pQP;
                  BOOL        pD ;
                  BOOL        pMO;
                  BOOL        pDW;
                  BOOL        pDM;
                  BOOL        pSD;
                  BOOL        pI ;
                  BOOL        pC ;
                  BOOL        pB ;
                  BOOL        pE1;
                  BOOL        pE2;
                  BOOL        pE3;
                  BOOL        pE4;
                  BOOL        pE5;
                        } UpdateFields;
                } ATS_TASK_DATA, *pATS_TASK_DATA;
                
typedef struct {
                CHAR          QName[13];
                BYTE          BlockState;
                } ATS_BLOCK_JOBQ_DATA, *pATS_BLOCK_JOBQ_DATA;
                               
typedef struct {
                CHAR          QName[13];
                CHAR          TaskName[13];
                } ATS_FLUSH_JOBQ_DATA, *pATS_FLUSH_JOBQ_DATA;
                               
                
// Periodic Event Intervals
#define SECONDS                                     'S'
#define MINUTES                                     'M'
#define HOURS                                       'H'
#define DAYS                                        'D'
#define WEEKS                                       'W'

// Change Criteria

#define ATS_FILE_EVENT_DATE                         0x0001
#define ATS_FILE_EVENT_TIME                         0x0002
#define ATS_FILE_EVENT_SIZE                         0x0004
#define ATS_FILE_EVENT_RO                           0x0008
#define ATS_FILE_EVENT_HIDDEN                       0x0010
#define ATS_FILE_EVENT_SYSTEM                       0x0020
#define ATS_FILE_EVENT_ARCHIVED                     0x0040

// Availabiltity Options

#define ATS_OPEN_FOR_READ                           618
#define ATS_OPEN_FOR_WRITE                          619
#define ATS_OPEN_FOR_READ_AND_WRITE                 620
#define ATS_DONT_OPEN                               621

// ATS Signal and Reset Action Codes

#define ATS_RESET_TASK                              4 
#define ATS_RESET_EVENT                             5
#define ATS_RESET_LINK                              6
#define ATS_SIGNAL_TASK                             7
#define ATS_SIGNAL_EVENT                            8
#define ATS_SIGNAL_LINK                             9

// ATS Return Codes
                                                   
#ifndef ATS_H
   #define ATS_SUCCESSFUL                            0
#endif
#define ATS_WARN_FILE_NOT_FOUND                      1
#define ATS_ERR_OPENING_QUEUE                      -40
#define ATS_ERR_ALLOC_SHARED_MEMORY                -41
#define ATS_ERR_GIVE_SHARED_MEMORY                 -42
#define ATS_ERR_CLOSING_QUEUE                      -43
#define ATS_ERR_WRITING_QUEUE                      -44
#define ATS_ERR_NO_TEXT                            -45

#define ATS_ERR_EVENT_NAME_MISSING                 -51
#define ATS_ERR_EVENT_NAME_TOO_LONG                -52
#define ATS_NOT_ACTIVE                             -53
#define ATS_ERR_TESTING_FOR_ATS                    -54
#define ATS_ERR_LOG_TEXT_MISSING                   -55
#define ATS_ERR_LOG_TEXT_TOO_LONG                  -56
#define ATS_ERR_LINK_NOT_DEFINED                   -57
#define ATS_ERR_LINK_ALREADY_DEFINED               -58
#define ATS_ERR_TASK_NAME_MISSING                  -59
#define ATS_ERR_TASK_NAME_TOO_LONG                 -60
#define ATS_ERR_ACTION_CODE_MISSING                -61
#define ATS_ERR_JOBQ_NAME_TOO_LONG                 -62
#define ATS_ERR_INVALID_ACTION_CODE                -63
#define ATS_ERR_INVALID_STRING_PARM_VALUE          -64
#define ATS_ERR_JOBQ_NAME_MISSING                  -65
#define ATS_ERR_DUPLICATE_JOBQ                     -66
#define ATS_ERR_INVALID_PRIORITY_CLASS             -67
#define ATS_ERR_JOBQ_NOT_DEFINED                   -68
#define ATS_ERR_JOBQ_DOES_NOT_EXIST                -69
#define ATS_ERR_JOBQ_HAS_TASKS_DEFINED_TO_IT       -70
#define ATS_ERR_INVALID_INTERVAL_TYPE              -71

#define ATS_ERR_NOT_ENOUGH_PARMS                   -75
#define ATS_ERR_INVALID_DATE                       -76
#define ATS_ERR_DUPLICATE_DATE                     -77
#define ATS_ERR_HOLIDAY_NOT_DEFINED                -78
#define ATS_ERR_INVALID_EVENT_TYPE                 -79
#define ATS_ERR_INVALID_CHANGE_CRITERIA            -80
#define ATS_ERR_INVALID_AVAILABILITY_OPTION        -81
#define ATS_ERR_INVALID_RESET_ON_RUN_VALUE         -82
#define ATS_ERR_DUPLICATE_EVENT                    -83
#define ATS_ERR_TASK_DOES_NOT_EXIST                -84
#define ATS_ERR_INVALID_TIME                       -85
#define ATS_ERR_EVENT_NOT_DEFINED                  -86
#define ATS_ERR_TASK_IS_A_DEPENDENCY               -87
#define ATS_ERR_TASK_NOT_DEFINED                   -88
#define ATS_ERR_DUPLICATE_TASK                     -89
#define ATS_ERR_INVALID_PARM                       -90
#define ATS_ERR_PARM_OUT_OF_RANGE                  -91
#define ATS_ERR_PROGRAM_NAME_MISSING               -92
#define ATS_ERR_PROGRAM_DOES_NOT_EXIST             -93
#define ATS_ERR_DIRECTORY_DOES_NOT_EXIST           -94
#define ATS_ERR_INVALID_PARM_VALUE                 -95
#define ATS_ERR_INVALID_SESSION_TYPE               -96
#define ATS_ERR_QUEUE_NAME_MISSING                 -97
#define ATS_ERR_QUEUE_DOES_NOT_EXIST               -98
#define ATS_ERR_INVALID_PARM_STRING_LENGTH         -99

// API Prototypes

LONG     APIENTRY ATSStop                    (ULONG priority);
LONG     APIENTRY ATSAddToLog                (char *LogText, ULONG priority);
LONG     APIENTRY ATSSignalEvent             (short Action, char Name1[], char Name2[], ULONG priority);
LONG     APIENTRY ATSResetEvent              (short Action, char Name1[], char Name2[], ULONG priority);
LONG     APIENTRY ATSAddHoliday              (pATS_HOLIDAY_DATA pHolidayData, ULONG priority);
LONG     APIENTRY ATSAddEvent                (pATS_EVENT_DATA pEventData, ULONG priority);
LONG     APIENTRY ATSAddTask                 (pATS_TASK_DATA pTaskData, ULONG priority);
LONG     APIENTRY ATSAddJobQueue             (pATS_JOBQ_DATA pJobQData, ULONG priority);
LONG     APIENTRY ATSAddTaskEventLink        (pATS_LINK_DATA pLinkData, ULONG priority);
LONG     APIENTRY ATSRemoveHoliday           (pATS_HOLIDAY_DATA pHolidayData, ULONG priority);
LONG     APIENTRY ATSRemoveEvent             (PCHAR EventName, ULONG priority);
LONG     APIENTRY ATSRemoveTask              (PCHAR TaskName, ULONG priority);
LONG     APIENTRY ATSRemoveJobQueue          (PCHAR JobQName, ULONG priority);
LONG     APIENTRY ATSRemoveTaskEventLink     (pATS_LINK_DATA pLinkData, ULONG priority);
LONG     APIENTRY ATSModifyTask              (pATS_TASK_DATA pTaskData, ULONG priority);
LONG     APIENTRY ATSModifyJobQueue          (pATS_JOBQ_DATA pJobQData, ULONG priority);
LONG     APIENTRY ATSInitJobQueueData        (pATS_JOBQ_DATA pJobQData);
LONG     APIENTRY ATSInitTaskData            (pATS_TASK_DATA pTaskData);
LONG     APIENTRY ATSBlockJobQueue           (pATS_BLOCK_JOBQ_DATA, ULONG priority);
LONG     APIENTRY ATSFlushQueue              (pATS_FLUSH_JOBQ_DATA pFlushQData, ULONG priority);
LONG     APIENTRY ATSFlushTask               (pATS_FLUSH_JOBQ_DATA pFlushQData, ULONG priority);
LONG     APIENTRY ATSIsDateBusinessDay       (PCHAR DateString);
LONG     APIENTRY ATSQueryActiveTaskCount    (void);
void     APIENTRY PrintATSAPIErrMsg          (LONG rc);
           
