; FILE:       STOCKS.SC
; Version:   6.0a
; Date:       09 April, 1995  
;
;
; This is the main script for the STOCKS application. This script
; controls the Main menu for the application. Note that each Main
; menu item calls a single procedure when selected. The source code
; for each procedure is stored in a script file with the name of
; the Main menu selection that calls it.  In actual practice, all
; of the procedures are written to a library, which is the AUTOLIB
; for the application.

PROC DoActivity()
CANVAS OFF
CLEARALL CLEAR                 ; Clear all tables on canvas and workspaces
PAINTCANVAS ATTRIBUTE 31 0,0,24,79
STYLE ATTRIBUTE 30
@4,0
TEXT
ͻ
  STOCKS APPLICATION  MAIN MENU  
Ķ
  BOARD            The table of stocks shown with realtime updates.          
͹
  PORTFOLIO        Stock market activity in realtime for a single portfolio. 
͹
  HOLDINGS         Watches stock market activity in all your portfolio.      
͹
  TICKERTAPE       Ticker tape showing the latest prices for all the stocks. 
͹
  GRAPHS           Watch realtime graphs of your portfolio.                  
͹
  EXIT             Exit Stocks Application and return to Paradox.            
ͼ
ENDTEXT
PAINTCANVAS ATTRIBUTE 78 5,7,5,24              ; Paint "Stock Application"
PAINTCANVAS ATTRIBUTE 14 5,57,5,65             ; Paint "Main Menu"
CANVAS ON

STYLE
  SHOWMENU "Board"      : "See RealTime Price Feed",
           "Portfolio"  : "Track Progress of a Specific Portfolio",
           "Holdings"   : "Track Aggregate Holdings",
           "TickerTape" : "Watch the ticker tape",
           "Graphs"     : "See RealTime graph of your portfolio",
           "Exit"       : "Leave Portfolio Management System"
  TO Activity
  SWITCH
    CASE (Activity = "Exit" or Activity = "Esc"):
         RETURN FALSE                ;stop execution of the main loop (below)
    CASE (Activity = "Board"):
         SeeBoard()
    CASE (Activity = "Portfolio"):
         Specificport()
    CASE (Activity = "TickerTape"):
         DoTicker()
    CASE (Activity = "Holdings"):
         PortAggr()
    CASE (Activity = "Graphs"):
         DoGraph()
  ENDSWITCH
  RETURN TRUE                        ;show the Main menu again
ENDPROC

; Since DoActivity has been made into a procedure, and all procedures
; are in the AUTOLIB procedure library, the entire script
; to play the application consists of:

AutoLib = "Paradox"
IF (NOT IsFile("Paradox.lib"))
  THEN RETURN "Please play the MKLIB script to create the application library"
ENDIF

WHILE (DoActivity())                 ;repeat until DoActivity() returns FALSE
ENDWHILE
