; File:         GRAPHS.SC
; Version:     6.0a
; Date:         9 April, 1995  

; This script defines the procedures that display different type of graphs.
; DoGraph is the controlling procedure.

PROC GraphMenu ()
  PAINTCANVAS ATTRIBUTE 31 0,0,24,79
  STYLE ATTRIBUTE 30
  @5,0
TEXT
ͻ
  STOCKS APPLICATION  GRAPH MENU  
Ķ
  StockPrices            Current, low, high prices in "High Tech" portfolio. 
͹
  PortfolioComposition   "High Tech" stocks' contribution to portfolio value.
͹
  StockOwned             Number of shares of stock owned, by portfolio.      
͹
  PortfolioValue         Total value of each portfolio.                      
͹
  MainMenu               Exit Graph Menu and return to MainMenu.             
ͼ
ENDTEXT
  PAINTCANVAS ATTRIBUTE 78 6,7,6,24
  PAINTCANVAS ATTRIBUTE 94 6,61,6,70
  STYLE
ENDPROC

PROC SaveOldGraph(Mode)
Private Mode
IF Mode = "Begin" THEN
  IF not isfile("ZZZZGR1.G") THEN
    MENU {Image} {Graph} {Save} {ZZZZGR1}
  ENDIF
  Startgraph = True
ELSE
  MENU {Image} {Graph} {Load} {ZZZZGR1}
  RUN NOREFRESH "Erase ZZZZGR1.G"               ; Run with NoReFresh
Endif
EndProc

PROC CLOSED DoGraph()
  CURSOR OFF
  StartGraph = False
  WHILE (True)
    CANVAS OFF                      ; Turn Canvas OFF to prevent flashing
    CLEAR RESET
    GraphMenu()                     ; Print Main graph Menu box
    CANVAS ON                       ; Turn Canvas back on with menu selection

    SHOWMENU
      "StockPrices" :
        "Current, low, and high prices for High Tech portfolio stocks",
      "PortfolioComposition" :
        "Pie chart showing High Tech stocks contributions to portfolio value",
      "StocksOwned" :
        "Number of shares of each stock owned, by portfolio",
      "PortfolioValue" :
        "Total value of all portfolios",
      "MainMenu" :
        "Exit Graph Menu and return to Main Menu"
      to GraphChoice

    SWITCH
      CASE GraphChoice = "MainMenu" OR GraphChoice = "Esc" :
        IF StartGraph THEN
           SaveOldGraph("End")
        ENDIF
        CANVAS OFF
        RETURN
        CANVAS ON
      CASE GraphChoice = "StockPrices" :
        SaveOldGraph("Begin")
        STYLE ATTRIBUTE 31
        @ 19, 1 ?? Format ("W78,AC","Query in progress, one moment please....")
        STYLE
        Graph1()
      CASE GraphChoice = "PortfolioComposition" :
        SaveOldGraph("Begin")
        STYLE ATTRIBUTE 31
        @ 19, 1 ?? Format ("W78,AC","Query in progress, one moment please....")
        STYLE
        Graph4()
      CASE GraphChoice = "StocksOwned" :
        SaveOldGraph("Begin")
        STYLE ATTRIBUTE 31
        @ 19, 1 ?? Format ("W78,AC","Query in progress, one moment please....")
        STYLE
        Graph3()
      CASE GraphChoice = "PortfolioValue" :
        SaveOldGraph("Begin")
        STYLE ATTRIBUTE 31
        @ 19, 1 ?? Format ("W78,AC","Query in progress, one moment please....")
        STYLE
        Graph2()
    ENDSWITCH
  ENDWHILE
ENDPROC

PROC CLOSED Graph1 ()               ; Graph for Stockprices Menu
  PRIVATE Qorder
  ; Graph #1: Low,High,current (Bar,Marker,and Over-ride)   graph1.g
  MENU {Image} {Graph} {Load} {Graph1}      ; Load in the Customize graph
  CLEARALL                          ; Clearall table on workspace

  Qorder = QueryOrder()             ; Save old QueryOrder to restore later
  IF Qorder = "TableOrder" THEN
    SETQUERYORDER IMAGEORDER        ; Set new QueryOrder to ImageOrder
  ENDIF

  QUERY

   Price |   TICKER   | PRICE  |  LOW   |  HIGH  |
         | Check _Tic | Check  | Check  | Check  |

   Holding | PORTFOLIO | SYMBOL |
           | High Tech | _Tic   |

  ENDQUERY
  WHILE NOT CharWaiting()
    DO_IT!
    MOVETO [Price]                  ; Moveto a numeric field for graph
    GraphKey                        ; Graph_it!
  ENDWHILE
  G = GetChar()                     ; Gobble up the keystroke

  IF Qorder = "TableOrder" THEN
    SETQUERYORDER TABLEORDER        ; Restore back the old QueryOrder
  ENDIF
  CLEARALL                          ; Clear all tables on workspace
ENDPROC

PROC CLOSED Graph2 ()        ; Graph for PortfolioValue Menu
;Graph #2: Total value of each portfolio (3-D Bar)   graph2.g
MENU {Image} {Graph} {Load} {Graph2}      ; Load Customize graph
WHILE NOT CharWaiting()
  CLEARALL                          ; Clearall Table on workspace
  PortPric()                        ; Do a first query to get share price from Holding.sc
  DO_IT!
  CLEARALL                          ; Clear workspace
  PortSum()                         ; Do a second query for total in each portfolio
  DO_IT!
  MOVETO [Total Share Price]        ; Moveto Numeric field for grah
  GraphKey                          ; Graph_It!
ENDWHILE
G = GetChar()
CLEARALL
ENDPROC

PROC CLOSED Graph3 ()               ; Graph for StocksOwned Menu
  PRIVATE Qorder
  ; Graph #3: Using CrossTab Table to graph (Stacked Bar)  graph3.g
  MENU {Image} {Graph} {Load} {Graph3}      ; Load Customize graph
  CLEARALL                          ; Clearall table on workspace

  Qorder = QueryOrder()             ; Save old QueryOrder to restore later
  IF Qorder = "TableOrder" THEN
    SETQUERYORDER IMAGEORDER        ; Set new QueryOrder to ImageOrder
  ENDIF

  QUERY

   Holding | SYMBOL | PORTFOLIO | SHARES |
           | Check  | Check     | Check  |

  ENDQUERY
  DO_IT!

  MOVETO [Symbol]                   ; Move to Alpha field for crosstab
  CROSSTABKEY                       ; Do a sum CrossTab by default
  GraphKey                          ; Graph it
  G = GetChar()                     ; Gobble up the keystroke

  IF Qorder = "TableOrder" THEN
    SETQUERYORDER TABLEORDER        ; Restore back the old QueryOrder
  ENDIF
  CLEARALL
ENDPROC

PROC CLOSED Graph4 ()               ; Graph for PortfolioComposition Menu
  ; Graph #4: Stock Contribution  (Pie chart)   graph4.g
  MENU {Image} {Graph} {Load} {Graph4}      ; Load Customize graph
  CLEARALL                          ; Clearall table on workspace
  QUERY

   Price |   TICKER   | PRICE |
         | Check _tic | _p    |

   Holding | PORTFOLIO | SYMBOL |             SHARES             |
           | High Tech | _tic   | _SH,CALC _SH*_P AS Total Value |

  ENDQUERY
  WHILE NOT CharWaiting()
    DO_IT!
    MOVETO [Total Value]            ; Move to numeric field for graph
    GraphKey                        ; Graph_it!
  ENDWHILE
  G = GetChar()                     ; Gobble up the keystroke
  CLEARALL                          ; clear all table on workspace
ENDPROC
