//***************************************************************************
//*                                                                         *
//* Interactive 3D Tool Kit I3D v2.1                                        *
//*                                                                         *
//* Functions for drawing in VGA mode 0x13 (320x200x256)                    *
//*                                                                         *
//* (c) 1993-95 Jim O'Keane                                                 *
//* All Rights Reserved Worldwide                                           *
//*                                                                         *
//***************************************************************************

#ifndef _VGA_DRAW_H

#define _VGA_DRAW_H

#if defined ( __cplusplus )
  extern "C" {
#endif

// Bios Mode 0x13 VGA
#define SCREEN_WIDTH  320
#define SCREEN_HEIGHT 200

// Wait for vertical blanking interval
void wait_vbi(void);

// set clipping rectangle
void set_clip_rect(long min_x, long min_y,long max_x, long max_y);

// Set the off-screen buffer to buf
BYTE * set_screen_buf(BYTE *buf);

// Set the off-screen buffer dimensions
long set_screen_buf_size(long width,long height);

// Put a pixel into the off-screen buffer at (x,y) in color
void put_pix(long x, long y, long color);

void nc_put_pix(long x, long y, long color);

// Return color of pixel at (x,y)
long get_pix(long x, long y);

long nc_get_pix(long x, long y);

// Clear off-screen buffer to color
void clear_screen_buf(long color);

// Clear lines in off-screen buffer from start to end to color
void clear_screen_lines(long color,long start,long end);

// Copy off-screen buffer to VGA memory REAL fast!
void update_screen(void);

// Zoom 2x a rect
void scaleup_rect(long ulx, long uly, long width, long height);

// Copy a portion of off-screen buffer to VGA memory fast!
void update_rect(long ulx, long uly, long width, long height);

// Draw a solid colored rect in off-screen color
void draw_rect(long ulx, long uly, long width, long height,
                     long color);

void nc_draw_rect(long ulx, long uly, long width, long height,
                        long color);

// Draw a line in off-screen buffer in color
void draw_line(long x1, long y1,long x2, long y2,long color);

void nc_draw_line(long x1, long y1, long x2, long y2, long color);

// Draw a circle in off-screen buffer with edge and fill
// if edge = -1 then no edge drawn, if fill = -1 then no fill drawn
void draw_circle(long xc, long yc, long r,long edge, long fill);

// Draw a concave or convex polygon in off-screen buffer with edge and fill
// if edge = -1 then no edge drawn, if fill = -1 then no fill drawn
void draw_polygon(short nvert, POINT *point, long edge, long fill);

// Put image in buf to off-screen buffer at x,y
void put_image(BYTE *buf, long x, long y, long w, long h);

void nc_put_image(BYTE *buf, long x, long y, long w, long h);

// Get image into buf from off-screen buffer at x,y
void get_image(BYTE *buf, long x, long y, long w, long h);

// Put image in buf to off-screen buffer at x,y with color 0 transparent
void put_trans_image(BYTE *buf, long x, long y, long w, long h);

void nc_put_trans_image(BYTE *buf, long x, long y, long w, long h);

// Fire up VGA mode 0x13 320x200 256 colors
void init_graphics(void);

// Return to previous video mode, free memory
void exit_graphics(void);

// Get the VGA palette
void get_vga_palette_256(DACPAL256 *PalBuf);

// Set the VGA palette
void set_vga_palette_256(DACPAL256 *PalBuf);

// Set the current text font parameters
void text_font(long width, long height, long space, BYTE *font_ptr);

// Set the current text colors
void text_color(long forecolor, long backcolor, long transparent);

// Draw some text in the off-screen buffer
void text_xy(long x, long y, char * text);

// Fade palette in from black
void vga_palette_fadein(DACPAL256 *pal);

// Fade palette out to black
void vga_palette_fadeout(DACPAL256 *pal);

// Test the various feaures...
void test_draw(void);

#if defined ( __cplusplus )
  }
#endif


#endif
