@echo off

if "%1" == "" goto USAGE
if "%2" == "" goto USAGE
if not exist %1:\%2\harpoon2.exe goto NOEXE

echo Installing update files to %1:\%2 ...
xcopy h2dptch2.* %1:\%2 /v
copy  patch.exe %1:\%2 /v
cd %1:\%2
%1:
echo Executing Update Process...
patch h2dptch2
echo  Relocating Video Files...
md video
copy resource\h-air5.ani    video
copy resource\h-land2.ani   video
copy resource\h-ship6.ani   video
copy resource\h-ship11.ani  video
copy resource\l-air2.ani    video
copy resource\l-ship2.ani   video
if not exist %1:\%2\video\l-ship2.ani goto NOCOPY
del resource\h-air5.ani  
del resource\h-land2.ani 
del resource\h-ship6.ani 
del resource\h-ship11.ani
del resource\l-air2.ani  
del resource\l-ship2.ani 
echo Cleaning Up...
del h2dptch2.*
del patch.exe

goto END

:USAGE

echo Usage : install drive dir 
echo         where drive is the letter of the drive to which Harpoon II
echo         was installed and dir is the drive:path into which 
echo         Harpoon II was installed
echo         example : if Harpoon II was installed to C:\GAMES\HARPOON2 type
echo.
echo                   Install C GAMES\HARPOON2
echo.
echo         Note : There is a space between "C" and "GAMES\HARPOON2"

goto END

:NOCOPY

echo Warning! Not all video files were relocated
echo In order to ensure proper Harpoon II video playback, either :
echo a)  manually relocate all .ani files  except h2title.ani from 
echo     %1:%2\resource to %1:%2\video 
echo OR
echo b)  manually alter your harpoon2.ini file so that the AnimDir
echo     entry is the path to the current location of the .ani files,
echo     usually %1:%2\resource, and delete the contents of the 
echo     %1:%2\video directory.
echo All other portions of the update process completed successfully.

goto END

:NOEXE
echo  Harpoon II not found in %1

:END
