(perm-space)

(select platform
	('SGI (let ((cwd (get_cwd)))
		(chdir (getenv "HOME"))
		(system "ls")
		(print (concatenate 'string "tar -xvf " cwd "/linux/boink.tar"))
		(system (concatenate 'string "cd ~/ ; tar -xvf " cwd "/linux/boink.tar"))
		(print "Type cd ~/boink ; boink <ENTER> to begin")
		(quit)))
	('LINUX (let ((cwd (get_cwd)))
		  (chdir (getenv "HOME"))
		  (system "ls")
		  (print (concatenate 'string "tar -xvf " cwd "/linux/boink.tar"))
		  (system (concatenate 'string "cd ~/ ; tar -xvf " cwd "/linux/boink.tar"))
		  (print "Type cd ~/boink ; boink <ENTER> to begin")
		  (quit))))



(do ((ok nil nil))
    ((eq ok T) nil)
    (select 0      ;  (nice_menu "BOINK" "Select language" '("English" "Espanol" "Frances" "Deutch")) 
	    (-1 (quit))                    ;; can't ask to quit, because we don't know the language yet
	    (0 (setq lang 'english)
	       (setq title       "Boink Installation")
	       (setq path-prompt "Enter path to install to")
	       (setq bad-path  '("You entered a bad path name"
				 "Press any key to re-enter, ESC to quit"))
	       (setq quit-title  "Quit?")
	       (setq yes-key     "Y")
	       (setq no-key      "N")
	       (setq quit-msg    "Do you you want to quit? (Y/N)")
	       (setq make-dir?  '("Directory does not exsist."
				  "Do you want to create it? (Y/N)"))
	       (setq mkdir-failed "Unable to create directory, retry? (Y/N)")
	       (setq nospace-dos  '("Not enough disk space available for this drive"
				    "You need at least 6.5MB free"
				    "Would you like to try another drive? (Y/N)"))
	       (setq next-disk  '("Insert this disk into disk drive and press SPACE BAR"
				  "to continue.  Press ESC to quit."))
	       (setq copy-title  "Copying files")
	       (setq start-msg   "Type dstorm <ENTER> to begin")
	       (setq ok T)
	       )
	

	    (1 (setq lang 'spanish)
	       (setq title      "BOINK Installacion")           ;; translate
	       (setq path-promt "entre el path a installar")   ;; translate  -- total guess here :)
	       (setq yes-key    "S")
	       (setq no-key     "N")
	       (setq quit-msg   "Quieres exitar? (S/N)"))

	    (2 (setq lang 'french)
	       (setq title      "BOINK Installation")           ;; translate
	       (setq path-promt "Enter path to install to"))    ;; translate

	    (3 (setq lang 'german)
	       (setq title      "BOINK Installation")           ;; translate
	       (setq path-promt "Enter path to install to"))    ;; translate
	    ))


(defun quit-install ()
  (if (show_yes_no quit-title quit-msg yes-key no-key)
      (quit)))

(defun slash () 
  (select platform
	  ('WATCOM   "\\")
	  ('UNIX "/")))


(defun append-slash (path)
  (if (equal (schar path (- (length path) 1)) (schar (slash) 0))
      path
    (concatenate 'string path (slash))))

(defun hack-string (x1 x2 st)
  (if (<= x1 x2)
      (cons (schar st x1) (hack-string (+ x1 1) x2 st))
    nil))

(defun remove-slash (path)
  (if (equal (schar path (- (length path) 1)) (schar (slash) 0))
      (concatenate 'string (hack-string 0 (- (length path) 2) path))
   path))


(defun copy-file (disk-name path)
  (do ((ok nil nil))
      ((eq ok T) nil)
      (if (file_exsist (concatenate 'string disk-name ".dat"))
	  (if (nice_copy copy-title (concatenate 'string disk-name ".dat") (concatenate 'string path disk-name ".exe"))
	      (setq ok T))                     

	(if (not (show_yes_no title (cons disk-name next-disk) " " ESC_string))
	    (quit))))
  T)


(defun install (path)  
  (select platform
	  ('WATCOM 
	   (if (< (K_avail path) 10500)     ; need ~8MB for game and and ~2.5MB extra for install
	       (if (show_yes_no title (cons install-path nospace-dos) yes-key no-key)
		   nil
		 (quit))
	     (if (and (copy-file "disk1" path)
		      (copy-file "disk2" path)
		     (progn
		   (go_there path)
		   (system "disk1.exe")
		   (system "del disk1.exe")
		   (system "disk2.exe")
		   (system "del disk2.exe")
		   T)
	       nil)))
	  ('UNIX 
	   (print (K_avail path))
	   (if (< (K_avail path) 8500)
	       (if (show_yes_no title (cons install-path nospace-unix) yes-key no-key)
		   nil
		 (quit))
	     (let ((cur-dir (get_cwd)))
	       (system (concatenate 'string "cd " path))
	       (system (concatenate 'string "tar -xvf " cur-dir " BOINK.tar"))
	       T)))))
		 
		       
	  

(defun lstring (x st)
  (if (< x (length st))
      (progn (print (schar st x))
	     (lstring (+ x 1) st))))

(defun go_there (path)
  (select platform
	  ('WATCOM 
	   (if (and (< 2 (length path)) (eq (schar path 1) #\:))
		       (system (concatenate 'string (list (schar path 0) #\:))))
		   (chdir (remove-slash path)))
	  ('UNIX (chdir path))))



(defun mkdir (path)
  (select platform
	  ('WATCOM  (make_dir path))
	  ('UNIX   
	   (print (remove-slash path))
	   (make_dir path))))


  (do ((ok nil nil))
      ((eq ok T) nil)
      (let ((install-path (append-slash (nice_input title path-prompt
						    (select platform
							    ('WATCOM "c:\\BOINK")
							    ('UNIX  "~/BOINK"))))))
	(if (not install-path) (quit-install)   
	  (if (or (dir_exsist (remove-slash install-path))
		  (and (show_yes_no title (cons install-path make-dir?) yes-key no-key)
		       (if (mkdir install-path)
			   T
			 (if (show_yes_no title (cons install-path mkdir-failed) yes-key no-key)
			     nil
			   (quit)))))
	      (if (install install-path)
		  (progn
		    (go_there install-path)
		    (setq ok T)))))))

(print start-msg)
