; -------------------------------------------------------------------------
; Sample Prevail View Workstation logon script for use with Legent's 
; MVSDEMO system.

; This script performs logon & download of a Prevail View report with the ID
; 'SJT-DEMO-R2'.

; Some 3270Wait calls use the variable nTimeout.  By changing
; this variable, you can adjust the timeout value for mainframe response time.


; The next statement enables script 'tracing', which causes script commands
; to be written to a log file called SARPC.LOG as they're
; executed (provided logging is enabled).
; To enable logging, execute Prevail View with the log option on the 
; command line.  For example,
;                PVIEWW.EXE /L:B
;
; (A parameter can be added to the Prevail View command line by selecting 
; the Prevail View icon and using the File/Properties menu command of 
; Windows' Program Manager.)
; -------------------------------------------------------------------------
Trace (1)

; -------------------------------------------------------------------------
; Set timeout used in 3270 commands (in seconds).
; -------------------------------------------------------------------------
nTimeout := 30


; -------------------------------------------------------------------------
; Connect to the mainframe, will dial if async connection.
; -------------------------------------------------------------------------
SARPCConnect

; -------------------------------------------------------------------------
; sFound will be null ("") if this wait times-out.
; -------------------------------------------------------------------------
sFound := 3270WaitFor (2, "Enter logon command or MORE", , ,
                          "LARGE SYSTEMS NETWORK MENU", , ,
                          "N-VISION", , ,
                          "NVi/TPX M", , ,
                          "ENTER USERID", , ,
                          "TSO/E  LOGON", , ,
                          "READY", , ,
                          "SYSNAME=MVSDEMO", , ,
                          "ISPF")
if (sFound <> "")                       ; non-modem panel?
    goto ProcessInitialPanel            ;  yes

sFound := 3270WaitFor (45, "CONNECT")
if (sFound <> "CONNECT")
  begin
    Log ("Timeout error: Connect after dialing")
    goto Quit
  end
else
  begin
    sFound := GetTerminalTypePrompt()
    if ((sFound = "terminal type") or (sFound = "TERMINAL TYPE"))
      begin
        3270Type ("VT100")
        3270Press ("ENTER")
      end
    else
      begin
        Log ("Timeout error: waiting for protocol converter")
        goto Quit
      end
  end


; -------------------------------------------------------------------------
; Check & process various logon screens.
; This first check of screens quickly determines the current screen in case
; the user already has an active session.
; The second check, later in the script, completes a logon, screen by screen.
; -------------------------------------------------------------------------
sFound := 3270WaitFor (5, "Enter logon command or MORE", , ,
                          "LARGE SYSTEMS NETWORK MENU", , ,
                          "N-VISION", , ,
                          "NVi/TPX M", , ,
                          "ENTER USERID", , ,
                          "TSO/E  LOGON", , ,
                          "READY", , ,
                          "SYSNAME=MVSDEMO", , ,
                          "ISPF")

ProcessInitialPanel:

if (sFound = "Enter logon command or MORE")
    goto DoTPXLogon                     ; VTAM
else
if (sFound = "LARGE SYSTEMS NETWORK MENU")
    goto DoLargeSysLogon                ; VTAM main menu
else
if (sFound = "N-VISION")
    goto ProcessTPXLogon                ; TPX logon panel
else
if (sFound = "NVi/TPX M")
    goto ProcessNVIMenu                 ; TPX main menu
else
if (sFound = "ENTER USERID")
    goto ProcessTSOLogon                ; TSO logon
else
if (sFound = "TSO/E  LOGON")
    goto ProcessTSOPassword             ; TSO password
else
if (sFound = "READY")
    goto ProcessTSOReady                ; TSO READY
else
if (sFound = "SYSNAME=MVSDEMO")
    goto ProcessTSOWelcome              ; TSO welcome
else
if (sFound = "ISPF")
    goto DoPView                        ; ISPF menu
else
  begin
    ; Write error description in log file.
    Log ("Unrecognizable screen")
    goto Quit
  end

; -------------------------------------------------------------------------

DoTPXLogon:

3270Type ("TPX")
3270Press ("ENTER")
goto CheckTPXLogon


DoLargeSysLogon:

3270Type ("B")
3270Press ("ENTER")


CheckTPXLogon:

sFound := 3270WaitFor (nTimeout, "N-VISION")
if (sFound <> "N-VISION")
  begin
    Log ("Timeout error: N-VISION logon")
    goto Quit
  end

ProcessTPXLogon:

3270Type (USER1)                        ; USER1 is user id variable
3270Press ("TAB")                       ;  that user enters in PVW dialog
3270Type (SARPSWD1)                     ; SARPSWD1 is password variable
3270Press ("ENTER")                     ;  that user enters in PVW dialog


sFound := 3270WaitFor (nTimeout, "NVi/TPX M")
if (sFound <> "NVi/TPX M")
  begin
    Log ("Timeout error: NVi/TPX Menu")
    goto Quit
  end

ProcessNVIMenu:

3270Type ("/g demotso")
3270Press ("ENTER")


sFound := 3270WaitFor (nTimeout, "ENTER USERID")
if (sFound <> "ENTER USERID")
  begin
    Log ("Timeout error: TSO Logon")
    goto Quit
  end

ProcessTSOLogon:

3270Type (USER1)                        ; USER1 is user id variable
3270Press ("ENTER")                     ;  that user enters in PVW dialog


sFound := 3270WaitFor (nTimeout, "TSO/E  LOGON")
if (sFound <> "TSO/E  LOGON")
  begin
    Log ("Timeout error: TSO Password")
    goto Quit
  end

ProcessTSOPassword:

3270Type (SARPSWD1)
3270Press ("ENTER")


sFound := 3270WaitFor (nTimeout, "SYSNAME=MVSDEMO")
if (sFound <> "SYSNAME=MVSDEMO")
  begin
    Log ("Timeout error: TSO Welcome")
    goto Quit
  end

ProcessTSOWelcome:

sFound := 3270WaitFor (nTimeout, "***", 8, 2)
if (sFound <> "***")
  begin
    Log ("Timeout error: TSO Welcome, Part 2")
    goto Quit
  end


3270Press ("ENTER")


sFound := 3270WaitFor (nTimeout, "ISPF")
if (sFound <> "ISPF")
  begin
    Log ("Timeout error: ISPF")
    goto Quit
  end
goto DoPView

ProcessTSOReady:

3270Type ("ISPF")
3270Press ("ENTER")


sFound := 3270WaitFor (nTimeout, "ISPF")
if (sFound <> "ISPF")
  begin
    Log ("Timeout error: ISPF")
    goto Quit
  end


; -------------------------------------------------------------------------

DoPView:

; Start Prevail View-host.

3270Type ("L.SAR")
3270Press ("ENTER")

; Wait for Prevail View initial screen.
sFound := 3270WaitFor (nTimeout, "S Y S O U T", , ,
                                 "PRIMARY SELECTION", , ,
                                 "PC TRANSMISSION STATUS")

; Handle Prevail View logo screen.
if (sFound = "S Y S O U T")
  begin
    3270Press ("ENTER")
    sFound := 3270WaitFor (nTimeout, "PRIMARY SELECTION", , ,
                                     "PC TRANSMISSION STATUS")
  end

if (sFound = "PC TRANSMISSION STATUS")
  begin
    3270Press ("PF3")
    sFound := 3270WaitFor (nTimeout, "PRIMARY SELECTION")
  end

if (sFound <> "PRIMARY SELECTION")
  begin
    Log ("Unable to access Prevail View")
    goto Quit
  end


; Specify SYSOUT ID of 'SJT-DEMO-R2'.
3270Type ("SJT-DEMO-R2")
3270Press ("ENTER")

sFound := 3270WaitFor (nTimeout, "SYSOUT SELECTION LIST")
if  (sFound <> "SYSOUT SELECTION LIST")
  begin
    Log ("Timeout error: Prevail View primary selection")
    goto Quit
  end

; Select first report on selection list.
3270Press ("TAB")
3270Press ("TAB")
3270Type ("P")
3270Press ("ENTER")

; Process Express Delivery print panel.
sFound := 3270WaitFor (nTimeout, "EXPRESS")
if  (sFound <> "EXPRESS")
  begin
    Log ("Timeout error: Express print panel")
    goto Quit
  end

3270Type ("SAR")
3270Press ("ENTER")

sFound := 3270WaitFor (nTimeout, "PRINT ATTRIBUTE PANEL")
if  (sFound <> "PRINT ATTRIBUTE PANEL")
  begin
    Log ("Timeout error: Prevail View selection list")
    goto Quit
  end

; Queue the report for download to PC.
3270Press ("TAB")
3270Type ("PC   ")
3270Press ("ENTER")

sFound := 3270WaitFor (nTimeout, "SYSOUT QUEUED TO PC")
if (sFound <> "SYSOUT QUEUED TO PC")
  begin
    Log ("Timeout error: Prevail View print panel")
    goto Quit
  end

; -------------------------------------------------------------------------
; Do calibrate command.
; -------------------------------------------------------------------------
sResult := SARPCCalibrate()

if (sResult <> "")                      ; was calibrate successful?
  begin                                 ;  no
    Log ("Calibration error")
    goto Quit
  end

; -------------------------------------------------------------------------
; SELECTION LIST screen should appear next.
; -------------------------------------------------------------------------
sFound := 3270WaitFor (nTimeout, "SYSOUT SELECTION LIST")
if  (sFound <> "SYSOUT SELECTION LIST")
  begin
    Log ("Timeout error: Following calibration attempt")
    goto Quit
  end

; Download queued reports.
sResult := SARPCDownload ()

if  (IsNumeric (sResult) = "FALSE")     ; was download successful?
  begin                                 ;  no
    sErrorID := STRINGWord (sResult, 1)
    Log ("Download failed due to ", sErrorID)
  end
else
  Log ("Successful download")


; -------------------------------------------------------------------------

Quit:

SARPCDisconnect

; Disable tracing.
Trace (0)

Log ("End of download script")

exit


; -------------------------------------------------------------------------

; This routine is called when we dialed in through a modem, and the
; screen contains the CONNECT prompt.  It presses ENTER and waits a
; couple seconds for the terminal type prompt from the protocol
; converter, until either we get the prompt or a net of 10 tries
; elapses

GetTerminalTypePrompt:

  3270Press( "ENTER" )
  bSuccess := "F"
  nTries := 1

  while ((bSuccess = "F" ) and (nTries <= 10))
    begin
      sFound := 3270WaitFor (2, "terminal type", , ,
                                "TERMINAL TYPE")
      if (sFound <> "")
        bSuccess := "T"
      else
        begin
          3270Press ("ENTER")
          nTries := nTries + 1
        end
    end

return sFound
