@Pat
^Initially Setup Patient Balances

If you own an established practice that is just now computerizing the
dental office, or if you have changed from a different software package,
it may be necessary to set up your patient's aging balances.  An aging
balance is a dollar amount, either credit or debit, that has existed in
the patient's accounts receivable since a certain date.  Easy Dental
Plus allows you to create a starting point for these balances, giving
you the opportunity to continue to track late payments, unpaid balances,
delinquent accounts, and allows you to charge patients a finance charge
for their aging balances.

Prior to entering any transactions such as charges, payments, or
adjustments, you should enter the beginning balance for each account
into the computer.  You may enter either debit balances--patients that
owe you money--or credit balances.

You can initialize a patient's balance in one of two ways, either as a
family--through the responsible party--or on an individual patient
basis.  In addition, you can initialize a balance with expected
insurance co-payment.

Immediately after initializing all of the balances for all of the accounts,
you should print an Aged Accounts Receivable Report.  The report shows all
of the balances and a total for the entire practice that you can compare
to your own records for accuracy.

If you initialize a ~family~ balance, you enter the entire family balance
under the responsible party's account number.  Since the responsible
party is always responsible for the balance, this is an efficient way of
setting up the family's account quickly.  To initialize the family
balance as an aging balance, you need to determine how much of the
family balance existed on a certain date, and only initialize that
amount for that date.  Then, the next date a balance existed, you
initialize only that amount.  You continue this process until you have
initialized the entire balance.
   
If you initialize ~individual~ balances for the family, you are
maintaining each person's individual account.  This is useful if you
wish to keep individual family balances separated.  ~However, the
responsible party is still responsible for all charges to the family.~
When initializing individual balances, you enter only the amount that
you can attribute to the individual family member.  You then initialize
each family member in turn until you have entered the entire family
balance.  If you are aging the individual balances, you will need to
determine the date the balance first existed.

You will need to adjust the patient insurance balance if initializing
with an insurance co-payment.  You accomplish this using Utilities menu
option #4, Initialize/Edit Patient Insurance Balances.  Refer to
Patient Insurance Balances for details.

If you initialize a balance with expected insurance co-payment, you are
indicating that the insurance company pays a part of the balance.  This
is a method of separating the patient's portion from the insurance
portion without having to recreate the insurance claim.  Initializing
the balance with an insurance co-payment does not create an insurance
claim as such.  It does, however, allow you to allocate the insurance
payment to an insurance portion.  This, in turn, helps you track your
insurance payments per insurance carrier.


~Initialized balance fields~

~Family Balance.~  The family balance, found at the top right-hand corner
of the initialization screen, indicates the current family balance.  If
the balance is zero, this means that either the family currently has a
$0.00 balance, or their balance is uninitialized.

~Debit or Credit Balance.~  A balance can be either a debit or credit
balance.  If the balance is a debit balance, the patient owes money.

~Provider.~  Easy Dental Plus associates debit balances with providers.
This is because money used to pay for treatment becomes provider
collections.  This is also why the program does not associate credit
balances with providers, since you have not entered treatment or the patient
has already paid for the treatment.

~You cannot specify a provider if you are initializing a credit balance.
You may specify a provider only for debit balances.~

~Balance Forward Date.~  This is the date of the transaction amount.  The
default date is the current system date.  If you wish to age the
balance, change the date to reflect the age of the balance.

If you are initializing several balances of differing ages, you will run
the initialization process several times in order to get the entire
balance in.

~Balance Forward Total.~  The amount of the balance you are entering as of
the balance forward date is entered here.  This balance total includes
the insurance portion.

~Estimated Primary Amount.~  This is the amount the primary insurance
carrier pays.  This amount cannot be higher than the balance forward
total.

If you are not initializing insurance co-payments, the insurance fields
will not be visible.  If you mistakenly indicated that you are
initializing the balance with insurance co-payment, you may leave these
fields at $0.00.

~Estimated Secondary Amount.~  This is the amount the secondary insurance
carrier pays.  This amount cannot be higher than the balance forward
total, nor can the secondary total plus the primary total be higher than
the balance forward total. 

~Patient Balance Forward.~  The amount listed here is the total amount
owed by the patient, excluding any insurance participation.  

~Family Current Balance.~  The amount listed here is the total amount owed
by the family.  This figure is the sum of the family balance field, seen
at the top of the screen, and the balance forward total.

~Comment.~  The program displays in this field the transaction comment you
entered when initializing the balance.

~Remember, <Alt-A> allows you to enter a transaction comment.  You can
have only one transaction comment per balance forward.~



@Pat
^Initializing a Balance Forward Amount

To initialize a patient's balance forward amount:

Select 3.  Initially Setup Patient Balances.
If you wish to initialize the balance with an insurance co-payment,
indicate "Yes."
Enter the appropriate information into the fields previously described.
When finished entering your information, if the cursor is not at the
bottom of the screen, press <Esc> to move it there.
Save your changes.



@Pat
^Patient Insurance Balances

When initializing a patient's balance using expected insurance
participation, you are deducting the entire balance forward amount from
the patient's insurance coverage total.  Simply put, if you have a
maximum of $1000 coverage for the year, and you initialize a balance for
$300, you have only $700 of insurance coverage left, even though
insurance covers only $200 of the total amount.  This means the program
reduced your insurance coverage by $100 more than necessary.

To adjust your insurance participation to its true amount, you need to
edit your insurance participation by using the Initialize/Edit Patient
Insurance Balances program in the Utilities menu (Figure 114).

~If you use the patient/insurance co-billing feature of monthly
statements this can be important for correct insurance participation
estimation. This is particularly true if you enter a new patient who has
already had extensive dental work done this year.~

Select 4.  Initialize/Edit Patient Insurance Balances.
Enter the patient's name or patient number.

~If you just initialized a patient's balance you can press "=" (the equal
key) to access the same patient.~

Tab to the field(s) you need to alter.
When finished editing the insurance amounts, press <Esc>.
Save your changes.



@Pat
^Deleting Patients

Deleting a patient is an extensive process in Easy Dental Plus.  The
computer must do a considerable amount of work to delete a patient since
there is so much information you can store for each patient.  For this
reason DPI suggests you delete patients only when necessary, and in
batches of 20, if possible.  If you delete only one or two patients a
year, then naturally you will only delete one patient at a time with
this option.  On the other hand, if you delete ten to twenty patients a
month, it is best to keep a list of patients that you need to delete,
then delete all of them at the first of every month.

~If you delete patients and then re-use patient numbers, then you will
want to be sure you look up only transactions with dates later than the
new patient's anniversary date when you use the Utility Menu's View Old
Transactions on Diskettes feature.~

There are some conditions that prevent you from deleting patients.  A
patient cannot be deleted if the patient:

    ~*has a balance
    *is on a payment plan
    *is a responsible party for someone who is not deleted
    *has an unprinted insurance form
    *has had a transaction since the last time you closed the month
    *has an appointment, only if the appointment is pending or was missed
    since last close month
    *has an open transaction.~

~If you need to adjust the patient's balance, or do anything to cause a
transaction to be save during the current month, you will need to wait
until after you close the month before you can attempt to delete the
patient.~

If any of these conditions exist, the program notifies you while
attempting to delete the patient.  You will then need to correct the
patient's condition before you can delete them.

The deletion process deletes:

    *the patient's records
    *the patient from outstanding claims and pending electronic claims
    *the patient from treatment plans
    *the patient's comments
    *mention of the patient from various stored letters
    *the patient's records from transaction history.

If there were any patient connections, the program asks if you want a
list of those patients.  Press ~S~ to view the list on the screen, or ~P~
to print the list on the printer.

After deleting the patient, the program re-indexes all of your current
patients and checks to see if they had any remaining connection with the
deleted patients.  If there were no such connections, the program
returns you to the Utilities Menu.  If there were connections, these may
be:

    ~*the deleted patient provided insurance, primary or secondary, for
    another
    *the deleted patient had referred another patient.~

If the deleted patient provided insurance, the program resets the
remaining patient's insurance to "Self."  If the deleted patient
referred another patient, the program resets the remaining patient to
"Not Referred." 

~The deletion process~

To delete a patient:

Select 6.  Delete Patients.
Enter the patients you wish to delete.

If you have entered patients on this list that you realize you do not
want to delete, you must cancel the process and start over.

When finished entering the patients to delete, press <Esc>.
When prompted to "Press <Enter> to delete," press <Enter>.

You will receive the first of two warnings that you are going to delete
patients.  The first warning is ~Preparing to delete Everything about
Everybody in the above List.  Are you SURE you want to Delete?~

If you are ready to delete, press Y <Enter>.

The second warning about deleting patients now appears.  This warning
exists to ensure that you are serious about deleting the patient. 
Figure 116 indicates the items the program deletes if the deletion
process takes place.  If this is not what you want you may indicate so
and not delete any patients at this time.

If you wish to delete your patients, press Y <Enter>.

The program first searches your list of patients to delete to see if
there are conditions that prevents some patients from being deleted.  If
there are any such conditions, the program displays a list of patients
and their condition.  You must correct any condition before you can
attempt to delete the patient.  You may print this list if you need it
in order to adjust the patient's records before you can delete him.

If there are patients you cannot delete, when the listing appears press
<Enter> to print the list, or press <Esc> to continue.

This is your last chance to cancel deletions.  Press <Esc>, and the
program returns you to the Utilities Menu.

If you mark a patient for deletion, and the patient is not on the
non-deletion list, you will then see the last warning regarding deleting
patients.  You may print this list as well. 

Press <Enter> to delete the patient and print the deleted patient list,
Press N <Enter> to delete the patient but not print the deleted patient
list, or press <Esc> to abort both the list and the deletion process.



@Util
^Change Doctor's Address

The doctor's address information comes preset when you receive your Easy
Dental Plus system disks.  This information is by no means permanent. 
You may need to change it when the practice moves or when you sell the
practice to another dentist. 

Easy Dental Plus uses this information in various places in the system:

    ~*Monthly Statements
    *Insurance Forms
    *Walkout Statements
    *Phone numbers (Default area code).~

When changing this information, you need to enter a verification number. 
This is a number DPI generates at its corporate office.  You must call
DPI at 800-824-6375 in order to get a verification number.  

~If your screen and the technician's screen do not match exactly,
including punctuation, the verification number given will be invalid. 
Please be as exact as possible when indicating your changes to the
support technician.~


~Changing Address Information~

To change your practice address information:

Select 1.  Change Doctor's Address & Phone Number.

You will see the screen shown in Figure 117.

Press <Tab> until you come to a field you need to change.
Enter your changes.
When finished, if the cursor is not at the bottom of the screen press
<Esc>.
Save your changes.

It is at this point the program requires the verification number (Figure
118).  A technical support technician will verify that the information
you have entered matches the information the technician has.  If it does
not match, the technician will make the appropriate changes to his
information.  He will then supply you with a verification number.  



@Util
^System Information

System information about your computer is easily available for you to
access through the System Information option.  This provides you with
current system information that you, your local hardware technician, or
a DPI support technician can use (Figure 119).




@Util
^Fix Multiple Terminals (Locksmith)

Dental offices that use Easy Dental Plus on a network may have a need to
use the locksmith feature.  When using a network, you may occasionally
see the message ~"File In Use -- One Moment Please"~ as a normal part of
day to day business.  This is because a user at a different workstation
is using a file that you wish to use.  This is all part of the file
locking system Easy Dental Plus uses to ensure the integrity of your
data.  

~You must customize your software for network use in order to use Fix
Multiple Networks.~

There are times, however, when a file can become locked:

    ~*if work at one or more terminals of your network was interrupted
    by a power outage
    *someone tripped over a power cord
    *someone pressed <Ctrl-C> in the middle of a task.~

If another user is actively using a terminal, do not use Locksmith.

As long as the circumstance resembles these you may need to unlock your
data file so that you may have access to it.


~Unlocking Files~

You have two choices when unlocking files:  

    ~*unlock files for the current terminal--unlocks files that were
    locked by the local terminal
    *unlock all files and records--unlocks files locked on the file
    server.~

Updating information while using locksmith may cause data corruption!

This option may become necessary to use if records and/or files are
locked at either your current terminal location or on the network
server.   You receive a warning when you attempt to unlock files and/or
records (Figure 120).  This warning is to ensure that you have examined
the situation, and found the only solution is to unlock files.  If you
are unsure of how to proceed, contact the DPI Customer Technical Support
Department for assistance.

There are two possible messages that you can get when unlocking files:

    ~*No files or records are currently locked--This means that there are not
    any files locked locally.  This could indicate that the files are locked
    on the network server.

    *There is X file(s) and/or records currently locked--X is the number of
    files and/or records locked.~

As long as no one else is updating information on another terminal you
can safely unlock the file or record.

To unlock files:

Select 5.  Fix Multiple Terminals (Locksmith).
You then need to select to unlock files for either the current terminal
or the network.
Select the file unlocking option that best fits your situation.

A warning similar to that seen in Figure 120 will appear. Be sure that
you are ready.

~If you do not wish to unlock files at this time press any key other than
the <Enter> key to abort the process.~

If you wish to unlock files, press <Enter> to continue.

If there are any files locked, the program displays the number of files
locked.

Press <Enter> to continue the file unlocking process.
The program then prompts:  "Do you wish to clear all of your locked
files and records?" 
If you wish to unlock your locked files, press <Enter> at the prompt.

You will receive confirmation that the program has cleared your file
locks.



@Util
^Unlock Scheduler Database

If the scheduler acquires locked files, you can clear these also through
the Locksmith.  The process for this is similar to unlocking files for a
terminal.  The warning messages are also similar.  You should run this
utility only when a scheduler file is locked, and no one is updating
scheduler information on another terminal.

~Follow the steps for unlocking a terminal, found in the section
Fix Multiple Terminals (Locksmith).



@Util
^Report of Locked Files and Records

This report lists locked records and/or files, their date, and their
time.  You can print or view this report.


To print this report:

Select 5.  Fix Multiple Terminals (Locksmith).
Select 1. Print Report of Locked Files and Records.
When you see the report on the screen, press <Enter>.

The report will print to the selected printer.



@Util
^Color Customization

Easy Dental Plus allows you to set your color choices for your
computer's monitor.  The quality of the screen colors depend on the type
of monitor your computer uses.  The highest quality monitor, at the time
of this manual's printing, is Super VGA.  Other monitor types include
VGA, EGA, CGA, MCGA, and Monochrome.  Easy Dental Plus works with any of
these monitor types.  Your choice of monitors depend on how you would
like the screen to appear.  

~If you are using Easy Dental Plus on a network, you can customize each
workstation for either color or monochrome monitors.  Refer to Section
II, Setting Up Your Practice, for information.~

Eye strain can occur if you work long hours on a video monitor, or if
the quality of the screen is poor or less than adequate.  Depending upon
your finances, a high quality VGA or Super VGA monitor would be
preferable to an EGA or CGA monitor.  

~See your local computer dealer for information on monitor types.~


~Notes for Monochrome Monitors~

If you use a monochrome monitor, or another type of monitor other than
color, you should not set your computer to use color.  Changing
foreground and background colors, as well as emphasized colors, can
cause your screen to highlight your selections improperly.  


~Important Terms~

Video monitors use colors to help create depth and definition to the
video screen.  Since the screen is a two-dimensional display, computer
programs work to create a three-dimensional look, since the human brain
perceives shapes in three dimensions.  Monitors use foreground and
background colors to separate the displayed items in order to make
viewing easier.  Monitors use emphasized colors, both foreground and
background, to allow the eye to see what item you have selected on the
menu screen.

~Foreground.~  The foreground is the item that is nearest to you.  If you
were to look at a photograph, the object you are photographing is the
foreground, whereas the trees or house behind the object would be the
background.

~Background.~  The background, as you can determine from the above
definition, is the object that is behind the foreground object.

~Emphasized.~  This is a method of distinguishing from the other items
seen on the screen.  When a program emphasizes an object or word, it
looks different from other screen items so that you can more easily see
it. 

~Primary Foreground.~  This refers to the basic menu title and border.

~Secondary Foreground.~  This refers to menu sections, such as the
Practice Management and Accounts Receivable sections of the Master Menu.


~Color Customization Steps~

To customize your monitor's colors:

Select 8.  Set Colors for Color Monitor.
When prompted "Do you have a Color Monitor?" press <Enter>.

The program lists a screen listing of each module.  

Enter the module number you wish to alter.

The cursor defaults to Primary Foreground Color (0-15). 

Enter the color number you wish to change to.

Watch the test screen to the right.  As you make color choices the
screen reflect those changes when you tab to the next field.

Press <Tab> to move to the next field, and make changes as necessary.
When finished making your changes, press <Esc> to move the cursor to the
bottom of the screen, if it is not already there.
Save your changes.
Press <Esc> to return to the Utilities Menu.




@Util
^Passwords

Easy Dental Plus allows you to set passwords to restrict access to parts
of your program.  You have the ability to define users, giving them
their own unique password.   When using password protection, a user
without a password cannot access the Easy Dental Plus program, or any of
the restricted modules. 

Before you can begin to use the password utility the Doctor's password
must first be defined.


@Util
^Add/Change User Passwords

To add a new user you must use the Doctor's password.  This means that
only the doctor has the rights necessary to add a new user to the
system.  When you enter the Doctor's password a pop-up screen appears
with the existing users, if any, and a new user option.  

When you establish password protection for your users, the program
displays the screen seen in Figure 121.  You will notice several things
on this screen:

    *The user's name can only be one name, either first, last, nickname,
    or whichever they prefer.

    *The password line appears after you enter the user's name.  You will
    only see the password when you highlight that line.  The password for
    the new user will default to the user's name.

    *If the password you enter is already in use by another user, the system
    will not allow you to use that password.

To add a user's password:

Select 9.  Passwords.
Choose Add/Change Users
Enter the Doctor's password.

The program displays a list of previously entered passwords, if any
exist.

To add a new user press <Ins>.

~You may also select "Enter New User" to add a new user.~

Type in the user's name.
Enter a unique password.
Press Y to add password protection to the listed modules.
If you need to skip a module, press N.  This will keep the module access
to "No."
When complete, press <Esc> to move the cursor to the bottom of the
screen, if it is not already there.
Save your changes.



@Util
^Change Password

The process for changing a user's password is the same for adding a
user.  However, instead of choosing "Enter New User" you will select the
user's name.  Then, follow the same procedures for adding a new user,
found in the section Add/Change User Passwords.



@Util
^Delete User

If you need to delete a user from the system, choose the third option,
Delete User.  Again, the only person who has password rights to do this
is the Doctor.  Once the Doctor has entered his password, the program
shows you a list of the available users.  

To delete a user:

Select 9.  Passwords.
Choose "Delete User."
Enter the Doctor's password.
From the list of users displayed, highlight the user who you wish to
delete.
When prompted to delete the user, press Y <Enter>.
Press <Esc> twice to return to the Utilities Menu.




@Util
^Removing Password Protection

You may discover you do not have a need for password protecting your
system.  If this is the case you may remove password protection,
including the doctor.   

You must delete the doctor's password last.

To remove password protection from your system:

Delete all user passwords.
Delete the doctor's password.

After you eliminate the doctor's password, there will no longer be any
password protection for your system until you reestablish it again by
adding the doctor's password.



@Util
^Regenerate Indexes

Easy Dental Plus uses indexes to retrieve information quickly.  If the
indexes become misaligned, problems in retrieving the correct
information can occur.  To minimize this possibility Easy Dental Plus
allows you to regenerate several indexes.  

Certain conditions must occur before you should regenerate an index
file*.  The following table gives you a listing of the conditions and
the indexes to regenerate.  If you are unsure of the condition, consult
with technical support on how to resolve your particular situation. 

*If reindexing does not resolve your problem, call your DPI support
technician for assistance.              

#Do not confused this with cross-linked family transactions.  For this,
call your DPI support technician for assistance.      


~Symptom                                      Solution~

~Cannot pull up a patient by their last name~  Reindex Name Control Files

~Patient last names are not alphabetized~      Reindex Name Control Files

~Procedure Codes do not show up or are out~    Reindex Name Control Files
~of order~

~You have trouble printing a master fee~       Reindex Name Control Files
~schedule~

~You have trouble pulling up a doctor's~       Reindex Name Control Files
~comments~

~You have trouble printing insurance forms~    Reindex Name Control Files
                                             Reindex Insurance Index Files

~#Cross-linked family member chains~           Reindex Family Member Chains

~Comments do not  come up properly in the~     Reindex Comments
~patient's history~

~Insurance coverages have changed for~         Reindex family member chains
~dependents, but the old insurance company
or coverage prints on the form.~

~Explosion codes do not come up properly~      Reindex Explosion Code
~Links~

~Treatment Planning does not come up~          Reindex Treatment Plan Links
~correctly when you go to enter treatment~





@Util
^Automatic Diskette Installation

Enhancements and updates are available periodically with the Easy Dental
Plus system.  When disk(s) arrive from DPI, you use this utility to load
the disk(s) onto your system.  This makes installation quick and easy,
all without exiting Easy Dental Plus.

~If you are installing the system for the first time, refer to Section I,
An Introduction to Easy Dental Plus, for instruction to installing the
software.~


~Installing Enhancements and Updates~

An enhancement is a set of disks that contain a new version of the
program.  For example, if you are currently using Easy Dental Plus 7.0
and you receive a set of enhancements from DPI, the enhancements will
convert your program and data to Version 7.5.

An update is a set of disks that contain updated program files that have
changed since the last enhancement release.

To install an enhancement or update:

Put the first disk in the disk drive and press <Enter> to begin
installation.

If there is not a disk in the disk drive, if the disk is damaged, or if
the disk is not an automatic installation disk, you will receive an
error message.  If there are no such problems, you will continue. 

If there is more than one installation available on this disk, you will
see a message similar to the message displayed in Figure 125.  Select
the installation program that you need.  You will then see the name of
the installation with a brief description of it.  

To start the installation, press <Enter>.

The screen clears and the installation begins.  If there is more than
one disk, the program prompts you to place each additional disk in the
disk drive when necessary.  When the installation is complete, the
program takes you to the Master Menu.



@Util
^Loading One File

Easy Dental Plus ships its data and program files in a "zipped" format. 
This is a type of data compression that drastically reduces the size of
the files.  When DPI sends you a diskette, it may be you need to load
only one file or one group of files--files with the *.zip extension. 
Easy Dental Plus provides you with a method of extracting the file(s)
you need without installing the entire diskette.

If you need to load more than one group of files, or if you have two
different disks in two disk drives--both A: and B:--you can select which
group of files to install.  You may even select a particular file to
install.  Drive A: in Figure 126 contains three condensed files to
choose from.  All you need to do is select the file you wish to copy to
your hard drive. 

To load just one file or group of files:

Insert the floppy disk into a disk drive.
Select 11.  Automatic Diskette Installation.

The screen shown in Figure 123.  From this point the installation
process differs from automatic diskette installation.

Press F to install files.

The program displays a message similar to the message seen in Figure 126
if there is more than one file that you can load.  Once selected, the
program prompts for a filename to load.  If there is just one file on
the diskette, the program does not display the message seen in Figure
126, and prompts you to enter a file name to load.

Type in the name of the file to load.

If you are loading a particular file you must know the file name.  If
you are loading multiple files with similar names or extensions, you can
use wildcards to load these files.  Wildcards include:

    ~*.* for all files
    *. for files without extensions
    *.dat for all files with the "dat" extension
    rgs?????.* for all files that begin with rgs.~

~The "?" is a placeholder for characters.  For example, to load
rgs12345.osf and rgs22222.osf without loading each individually, you
would use rgs?????.* or rgs?????.osf.~

The file extracting program now runs.  If you typed the name
incorrectly, or if the file is not in the group you selected, you will
receive the message "No file(s) found," and control returns to Easy
Dental Plus.  If the file you are copying already exists on your hard
drive, the program prompts you: 

    ~Warning! file: rgs12345.osf already exists.  Overwrite (y/n)?~

If the purpose of loading a file is to replace a defective file, then
choose to overwrite; otherwise, you can skip this file by indicating you
do not wish to overwrite it.  If there are other files to load, the
program continues until you are given a chance to load all the available
files.


@Util
^Archiving Transactions

This program allows you to remove patient history from your hard drive
and store the data on floppy diskettes.  It also allows you to call up
or review data from the diskettes, and to print the history for a single
patient or an entire family.  You should really only archive when your
hard disk is running out of free space less, than 1 Megabyte (one
million bytes) for instance.

This program will free up space for new transactions on your hard disk
drive.  It will also attempt to free up space for other types of data,
but may not be able to do so if your hard disk has little or no free
space.

If you have completely run out of disk space you may want to call our
technical support line.
  
~Cutoff Date.~  The cutoff date is the last transaction date you wish to
remove from your hard drive.  The program defaults to a date one year
previous to today's date.  The program removes all transactions, up to
the cutoff date, from your system's hard drive, and places them onto
floppy disks. 

~Be careful not to make the cutoff date too recent, because then you will
have to use the view/print archived transactions option more often than
you would like to.~

~Disk Drive.~  You have a choice of transferring the data to either drive
A: or B:.  If you have one floppy drive, then drive A: is assumed, and
the program does not prompt you for a drive letter.

~You cannot archive data to a tape drive.~

To archive history to your floppy disks:

Select 7.  Archive/View Old Transactions on Diskette.
Choose "Automatically Archive Transactions to Diskettes."
Enter the cutoff date.
If you have more than one floppy drive, specify which drive you wish to
archive to.

~Be sure to have a sufficient amount of formatted floppy disks ready.
Since there is not a way to predict how many you will need, you can do
one of two things:  1) format the same number of diskettes you use for
your daily backup, or 2) format an entire box of diskettes.~

A message similar to the one displayed in Figure 128 appears.  You must
make a choice at this point:  if you choose to purge the patient's
summary history you will not be able to view any summary history prior
to the date indicated.  This does not affect unarchived summary history.

~Summary history is a type of history that indicates "Office Visit"
instead of individual procedures.  Summary history can also give you a
running balance total for the family.  If you wish to continue to view
archived summary history in order to see a running balance, then you
must not purge the summary history.~

Select one of the choices shown in Figure 128.

The program archives the patient's history onto the floppy disk.  If you
need more than one diskette, the program prompts you to remove the first
diskette and insert another.  You must also label your diskettes.

Label your floppy disk according to the manner as shown on your screen.

After you finish archiving, the program deletes the archived
transactions from your hard drive.  If there is enough free space left
on your hard disk at this point in time, then the program will "pack"
the transaction files so that they actually free up space for other
types of data.



@Util
^Print/View Archived Transactions

This program is similar to History Inquiry on the Patient Menu.  The
primary difference is you are searching floppy diskettes instead of your
hard drive for the patient's history, so there is no "quick" inquiry. 
Also, if you did not archive summary transactions you cannot view a
summary history.  You also cannot look up transactions for deleted
patients.  If you have deleted and then re-used patient numbers, make
sure you do not search a disk containing transactions prior to the
anniversary date of the patient.

~Disk Drive.~  This is the disk drive you insert the archive disk into.
It does not matter if you originally archived to a different drive as
long as the diskette fits into the disk drive. 

~Patient Name or Number.~  This is the person whose archived history you
wish to view.

~Entire Family or Patient.~  You can select to view all transactions for
the entire family by choosing Family; otherwise, you will view the
history of a single patient.

~Detailed or Summary.~  If you choose to view detailed history, you will
see each individual procedure entered as well as individual payments. 
Summary history will combine all treatment into "Office Visit" but will
still show payments individually.

To view archived history:

Insert the archived history diskette into a floppy drive.
Select 7.  Archive/View Old Transactions on Diskettes.
Choose "View/Print Archived Transactions for a Patient or Family."
Enter the drive letter of the diskette previously inserted.
Enter the patient's last name or number.
Specify whether you wish to view transactions for the entire family or
one patient.
Specify to view either detailed or summary history.

At this point the program searches the diskette(s) for transactions
based upon the parameters specified.  After searching the diskette, the
program prompts you to insert another diskette, or press <Esc> if there
is only one diskette.

When you see the transactions on the screen, press <Enter> to print.



@Util
^Compress and Re-Index Transaction Files

This utility reindexes the patient's history.  You should not run this
option on your own.  Call DPI for assistance.




@Util
^Automatic Backup Of Your Data

It is very important that you make a "backup" every day of all the
information you have entered into Easy Dental Plus.  A "backup" copies
information from your hard disk to another storage device.  Most of our
clients use floppy diskettes. 

~When Easy Dental Plus backs up your data, it gives control of your
computer over to a backup program.  For more information on how to
specify that program, see Section II.~

It is very likely that someday your computer will break down--for
instance, if lightning strikes nearby, or some part in your computer
wears out.    

If you have a backup from the night before the error occurred, you can
restore the previous day's data.  

~Also, floppy disks do wear out!~  Do not use the same set of backup
diskettes for more than one year.  Replace them regularly to insure the
integrity of the diskettes.  Old or worn diskettes will not hold the
information properly, and restoring a damaged or old set of diskettes
can cause more harm to your dental information than a simple computer
error.  The more often you use the diskettes, the more often you will
need to replace them.  This is a small price for safeguarding your
dental information. 

If your office uses a tape backup system, please refer to your tape
system's manual for information about backing up and restoring data to
your computer, and on the life expectancy of the backup tape.  

DPI recommend backing up your data every day and at the end of the
month.  You should have a separate set of diskettes for each day of the
week, and a separate set for the end of the month.  Additionally, you
should always have at least one extra formatted diskette available, just
in case.  If, for example, a daily backup takes five diskettes, then you
should have twenty-six diskettes in all--five for each day, plus the
extra. The reason for the extra diskette is that someday your backup
program may ask you for an additional diskette.  

To back up your data:

From the Master Menu select 8.  Automatic Data Backup.

The screen shown in Figure 130 appears.

Press <Enter> to begin the backup process.

The next steps are dependent upon the type of backup program you are
using.  Be sure to check your backup program's documentation on how its
process works.



@Util
^Backing Up Your Data Using PKZip

As a method of backing up your data, Easy Dental Plus includes a data
compression program called PKZIP.  This program compresses your data
into one compressed file that can be anywhere from 50% to 90% smaller
than the original size of your data.  This program is fast and
efficient, saving you time and disks when backing up your Easy Dental
Plus data.

~You cannot use PKZIP on a tape backup system.~


~Backing up using PKZip~

To back up your data using PKZIP:

Enter this command line as either your backup command line in System
Customization option #6, or as an application in the Run DOS Application
Programs: PKZIP  A:\DENTALBU  -&frpx*.EXE

~If you use drive B:, substitute that drive letter for drive A:, as shown
in the command line.~

This command line will compress all the files found in the current
directory, excludes executable files, and place them in on your floppy
disk in drive A:.

From either Master Menu option #8, Automatic Data Backup, or from the
Run DOS Application Programs, begin your backup process.

Once your backup is complete, place your diskettes in a safe place until
the next time you back up your data.



@Util
^Restoring your data using PKUnzip

Along with PKZIP you will find PKUNZIP.  As the name implies, this
program "unzips" your compressed backup file and restores it to your
computer's hard drive.  The process for using PKUNZIP is similar to
using PKZIP, except you must run this program from your C:\DENTAL
prompt.  Attempting to execute this program from within Easy Dental will
result in program error:  Another workstation has logged on with the
same station number.  This is not a critical error, just an
inconvenience since it will exits you from Easy Dental Plus.

To restore your compressed data using PKUNZIP:

Exit Easy Dental Plus.
Change directories to the dental directory.

~If you do not understand DOS directory structures, consult your DOS
manual or your local software vendor for information.~

Normally, the dental directory is named DENTAL.  If you are unsure of
where your dental directory is, consult the System Information program
(option #2) found in the Utilities menu.  Field #7, Current Directory,
indicates the name and location of your Easy Dental Plus directory.

~If you are using drive B: instead of drive A:, substitute B: in the
command line.~

From the C:\DENTAL prompt type: PKUNZIP  -od  A:DENTALBU

~The parameters in the above command are letters only, not numbers.~

After you have typed the command to unzip your compressed backup file,
press <Enter>.

PKUNZIP will restore you files to the correct location automatically. 
After your files are restored, you may restart Easy Dental Plus.

DISCLAIMER:  The use of PKZIP and PKUNZIP are strictly a choice of the
user.  Restoring data using PKUNZIP will overwrite your current data
without any chance of recovery.  Be sure you have a valid copy of your
current data before using PKUNZIP.



@Util
^Setting Up MSBackup

This is a simple task that is, for the most part, automated by the 
MSBackup program.  You must have at least two floppy diskettes available
to perform this process.  While setting up MSBackup, the program will
take control of your computer at points during the setup process.  The
screens you will see following are those at which you must make a
choice.

~If your computer has a mouse, you may use it while setting up MSBackup.~

Exit any computer program you are running.

You should be at a "black" screen with a prompt at the top left corner
of the screen.  The prompt should resemble something like this: C:\>DOS.
The name following the ">" sign may be another directory.  If this is the
case, change to that directory.

~If you are using a menu program, you will need to exit that program
before you see the "black" screen described.~

Type CD\.
Type CD DOS.
Type MSBACKUP.

The screen in Figure 131 appears.

~If you do not see the screen shown in Figure 131, it may be because you
have already configured MSBackup.  If so, there is no need to
reconfigure MSBackup.~

Press <Enter> on "Start Configuration."

You can change any of the options on this screen by pressing ~<Tab>~ until
you reach the item you wish to change.

The MSBackup program will analyze your system, and displays the screen
seen in Figure 132.

Press <Enter> on OK.

The program then prompts you to start the Floppy Drive Change Line Test.

Press <Enter> on Start Test.

MSBackup examines your floppy drives to determine their capacity.  When
the program finished, it displays the screen seen in Figure 134.

Press <Enter> on OK.

You will need next need to perform the Floppy Disk Compatibility Test. 
This is the test that will verify that you can reliably make a backup of
your data.

~You must perform a Floppy Disk Compatibility Test; otherwise, MSBackup
may not make reliable backups.~

Press <Enter> on Start Test.

The MSBackup program selects files to backup, and configures the backup
program to backup the files the program selects.  Once done, the program
displays the screen seen in Figure 136.

When you see the screen shown in Figure 136, press <Enter> on continue.
Select the disk drive you wish to use by pressing <Tab> until you reach
the drive letter you wish to use.

~If you wish to backup to a different drive or if you wish to use a
different density diskette, select any of the other available
selections.~

Press <Tab> until you reach the OK button.
Press <Enter> on OK.

~You may specify a different floppy drive for your backup at this point.~

The program then prompts you to insert your floppy disk into the drive
you have selected for your backup (Figure 138).

Press <Enter> on Continue.
MSBackup begins to backup the selected files onto the floppy disk you
inserted.  Once finished with the first diskette, it will prompt you for
a second diskette (Figure 139).

After you have backed up the remaining files, you will see a pop-up
summary screen (Figure 140).  This screen gives you information about
the files you just backed up.

Press <Enter> on OK.

After you complete the backup, MSBackup performs a Comparison Test. 
This test checks to see if the files on the diskette match those that
you backed up.  When the program is ready to perform this test, you will
see the screen seen in Figure 141.

Insert the first diskette of the backup set.
Press <Enter> on Continue.

The program compares the files on the hard drive to those on the
diskette.  When the program is ready for the second diskette, a screen
similar to that shown in Figure 142 appears.

~Notice in Figure 142 the program prompts you for diskette #2.  When
MSBackup requests the next disk, the disk drive does not stop while you
are changing disks.  This is normal.~

Insert the second diskette.  There is no need to press <Enter> or any
other key.

When the comparison is complete, you will see the screen shown in Figure
143.   This is another information screen that indicates information
about the backup files that MSBackup compared.

You now will see the screen shown in Figure 144.  This screen indicates
you have successfully completed the compatibility test.

~If your computer did not pass the compatibility test, you may need to
check for possible problems that you need to solve before configuring
MSBackup a second time.~

Press <Enter> on OK.

MSBackup will then prompt you to save your backup configuration (Figure
145).  

Press <Enter> on Save.

You have finished setting up MSBackup.  You are now ready to begin
backing up your data (Figure 146).



@Util
^Configuring MSBackup

Once you have set up MSBackup, you will need to configure the program to
backup your data files.

From a computer prompt type MSBackup.

The screen shown in Figure 146 appears.  If you did not exit the backup
program after its setup, you will still see the screen seen in Figure
146.

Select Backup.

You will see a screen similar to that shown in Figure 146. 

Press <Tab> until you are at the option ~Select files....~
Press <Enter>.

You must select the files you wish to backup.  To do so:

Press the down arrow key until you reach the DENTAL subdirectory
(Figure 147).

You may call your ~DENTAL~ subdirectory something else. Substitute the
correct name for ~DENTAL~.

Press <Space> on the DENTAL subdirectory to select the files in that
subdirectory (Figure 147).

~If you wish to select certain files to back up in the DENTAL directory:~

    1. Press <Tab> to move the highlight bar to the right side of the
    screen.

    2.  Press <Space> to select the current highlighted file; the highlight
    bar automatically moves down to the next file name. Use down arrow key
    to skip files.

    3.  When you finish selecting files, press <Tab> to move to OK.

Press <Enter> on OK.

The program takes you back to the screen seen in Figure 146.  It is now
time to save your settings.

Press <F10>.

A small pop-up menu appears at the top left-hand corner of the screen.

Select Save Setup As....

The screen seen in Figure 148 appears.

The program places the cursor on the file name.  You will need to save
your setup under a different name.  

Type in DENTAL.SET or any other name you prefer, but do not press
<Enter>.
Press <Tab> to move to the description field.
Type in the description of your set file, then press <Enter>.

The program returns you to the screen seen in Figure 146.  You have
completed your MSBackup configuration for your dental files.  You may
use this process to specify other types of backup configurations for any
of your other programs.  However, before you begin to backup your data,
you must first change your Easy Dental Plus backup command.

From the Easy Dental Plus Master Menu select 48.  System Customization.
Select 6.  Backup Command Line.

You will see the screen shown in Figure 149.  

Type in the MSBackup command, followed by the name of the set file you
created earlier.

You should find MSBackup in your DOS directory.  If you have named this
directory another name, substitute that name for the DOS name in path
shown in Figure 149.

Save your changes.

To back up other data, you can either change the SET file name every
time you perform a backup, or you can specify a different SET file name
when executing the backup for a DOS prompt.  For example:  MSBackup
program.set



@Util
^Restoring Your Files

Exit any programs running.

You should see a "black" screen with a prompt located at the top
left-hand side of the screen.

Type CD\.
Type CD DOS.
Type MSBACKUP.

The screen shown in Figure 150 appears.

Select your Backup Catalog.

~Notice the other catalog files.  Check your MS-DOS manual for an
explanation of these catalog files.~

The backup catalog is the ~SET~ file you created when you configured
MSBackup for your dental files.  To select the backup catalog:

    1.  With the arrow keys move the highlight bar until you highlight the
    catalog you wish to load.
    2.  Press <Space> to select the highlighted catalog.
    3.  Press <Enter>.

Press <Tab> until you highlight Select Files....
Press <Enter>.

A screen similar to that shown in Figure 151 appears.

With your down arrow key, move the highlight bar until you highlight the
DENTAL directory.
Press <Space> to restore all the files in the dental directory.
Press <Enter> to accept your choice(s).

You now must select a destination for your files.

Press <Tab> to move the highlight to ~Restore To.~
With your up arrow key move the highlight to the first choice:
~Original~ Locations (Figure 152).
Press <Space> to make the dot appear between the parentheses.
Press <Enter>.
Press <Tab> to move the highlight to ~Start Restore.~
Press <Enter> to begin the restore process.

