@Trt
^Entering Patient Treatment

When you enter treatment for a patient, you do more than note what
treatment you entered for the patient.  In addition to entering treatment,
you can accomplish the following in this order:

     ~Change treatment date
     Offer percentage discounts for everyone or Senior Citizens 
     Generate insurance forms 
     Answer insurance questions 
     Change Insurance Form Type
     Complete or delete treatment planning 
     Enter treatment in a simplified manner 
     Enter treatment with all options available 
     Edit insurance participation amounts 
     Apply treatment to future contracts 
     Provide cash discount 
     Make an account adjustment 
     Enter a payment 
     Update a patient's recall 
     Print a walkout statement~

While performing any of the previous functions you can:

     ~Perform a patient inquiry using <F2>
     Schedule appointments using <F3>
     Enter transaction comments <Alt-A>~






@Trt
^General Description of Treatment Options

Following is a general description of options available when entering
treatment.  Some options are not available when you customize particular
options.  For example, you cannot edit individual insurance amounts if
customized for simplified enter treatment.  


~Change Treatment Date~

You can enter treatment under any date desired.  This is useful when you
accidentally forgot to enter treatment, or treatment needs to be backdated
because of a busy day.  In either case, you can change the treatment date
to reflect the correct date of treatment. 


~Patient Discounts~

There are two types of patient discounts:  percentage and cash. You can
customize one, both, or no discounts to appear when entering treatment. 
You must specify that you wish to offer a percentage discount before you
can specify the percentage amount.  The default status of the percentage
discount is no discount.  Easy Dental Plus automatically  applies a senior
citizen discount to patients over the age customized.  

If the patient has insurance, the program generates a form automatically,
unless you override the default "Yes" answer.  Conversely, if the patient
does not have insurance, the program does not generate a form unless you
override the default "No" answer.

~You can print insurance forms from the Insurance menu, option #4.~

NOTE:  Don't forget to mark missing teeth if you file insurance
electronically. 


~Percentage Discount ~

If you have customized Easy Dental Plus to allow percentage discounts, the
program will display a screen similar to the one shown in Figure 33.  This
type of discount takes a specified percentage of a treatment and reduces
the treatment by that percentage amount.  For example, if a procedure is
worth $100, and you are applying a 10% discount, then Easy Dental Plus
reduces the actual cost of the procedure by 10% ($10).  

If you customized your software to allow only discounts for Senior
Citizens, the discount information will not appear on the screen until you
enter treatment on a patient who meets the minimum age requirement.


~Insurance Forms ~

Easy Dental Plus generates the insurance form when you enter patient
treatment.  Generating a form is not the same as printing a form.  The
program stores the treatment information in the insmastr file.  When it
comes time to print the insurance form, the program checks this file for
the appropriate line items to print on the insurance claim form.  If you
choose not to generate a form when entering treatment, you will have to
generate a form manually through the Create/Print Actual Insurance Forms
program in the Insurance menu.  

You may also select a different insurance form than the one specified by
the patient's coverage.  

To select a different form:

Press <Tab> or <Shift-Tab> until you reach the Insurance Form to Print
field (either Primary or Secondary).

Using your arrow keys, select the form you wish to generate.

If you file the patient's insurance electronically, the same options apply
as for paper claims; however, if you choose not to generate the form when
entering treatment you cannot use the Create/Print Actual Insurance Forms
program in the Insurance menu to generate an electronic claim.   

You must answer the insurance questions that appear on the insurance form
so that the correct answers will print on the form.  Only the questions
that deal with the form type specified in the patient's coverage will
appear on the screen.  If the patient has more than one coverage, and the
coverages uses different form types, then both sets of insurance questions
will appear on the screen.  This also includes insurance questions
for electronic claims.


To answer the insurance questions:

Press <Tab> or <Shift-Tab> to move to the question you wish to answer. 
Type in your answer. 
When finished, press <Esc>.


~Treatment Planning ~

If a patient has treatment planning pending, the procedures that are a
part of the treatment plan will appear on the screen (Figure 35) after the
insurance questions, if any, and before you enter any other treatment. 
You may, at this time, mark the treatment planning as either C (completed)
or D (deleted).  You can skip treatment planning entirely, if desired, by
pressing <Tab> while the treatment planning is visible.

The standard fee schedule is the default fee schedule for all patients,
especially those without insurance coverage.  


~Using Insurance Amounts From Treatment Plan ~

When creating a treatment plan and pre-treatment estimate you are
establishing with the client and the insurance company a method of
rendering certain treatments at a certain cost that have been pre-approved
by the insurance company.  Sometimes a patient's coverage changes, and the
percentage of coverage may change.  Easy Dental Plus allows you to
continue using the insurance amounts from the patient's treatment plan as
a basis of charges rather than any new percentages in the patient's
coverage.


~Fee Schedules~

You can use custom fee schedules in combination with a patient's coverage. 
If you specify a custom fee schedule in the patient's coverage, the
program displays the name of the fee schedule at the top of the screen.






@Trt
^Methods of Entering Treatment 

You can enter treatment in either a simplified form, or a form that uses
many treatment entry options.  Which one you use is dependent upon the
complexity of your office procedures.


~Simplified Enter Treatment~

This method of treatment entry is the fastest method.  When using
simplified treatment these are the options you have available:

     ~Enter procedure codes
     Total payment amount 
     Provider 
     Tooth and Surface 
     Add a transaction comment~

You cannot edit insurance amounts per transaction using this method of
treatment entry.  You can only edit the entire insurance amount.  As seen
in Figure 36, the program shows the insurance amount for the entire
treatment at the right hand side of the screen, close to the bottom.  You
can only edit the primary and secondary coverage fields.  You will also
notice the Before and After fields to the left of the insurance amounts. 
These fields indicate what today's treatment entry will do to the
patient's insurance coverage amounts.

To edit the patient's insurance amount using the simplified enter
treatment option:

Enter treatment as normal. 
When finished entering treatment, press <Esc> to move to the bottom of
the screen. 
Press <Shift-Tab> to reveal the insurance editing information. 
Make the needed insurance adjustments. 
When finished with editing the insurance amounts, press either <Esc> or
<Enter> to move the cursor to the bottom of the screen.
Continue with the enter treatment process.


~Treatment with full features~

This method of treatment entry gives you several more options that the
simplified treatment entry does not.  Included in this method are:

     ~Entering procedure codes
     Total treatment amount 
     Insurance amounts 
     Provider 
     Tooth and Surface 
     Transaction comments 
     Start at the top or middle of the treatment entry window 
     Show insurance amounts always or only when necessary~

The main difference between this option and simplified treatment entry is
you can edit the insurance amounts on an individual basis.  You can:  

     ~*Use <Shift-Tab> to return to the previous field.
     *Edit the insurance amounts that exist 
     *Edit insurance amounts that are zero 
     *Edit insurance amounts for patients without insurance coverage~
    
As seen in Figure 37, this patient does not have a secondary insurance
coverage.  Because the treatment method is using the option to show
insurance amounts always, then you can edit that field to include an
amount for a non-existing secondary coverage.  If you were customized to
show insurance amounts only when necessary the secondary coverage field
seen in Figure 37 would not be visible. 

If editing insurance amounts is not an important factor in your office
procedures, then you may customize your treatment to start at the middle
of the treatment window.  This bypasses the total charge and insurance
fields, taking you to the provider field.  You may press <Shift-Tab> to
move backwards and change these fields, if needed.






@Trt
^Sales Tax

When entering treatment you may calculate a sales tax for each treatment
entered.  This is applicable in states that require a sales tax.

When entering treatment using all options, you will see a screen similar
to that seen in Figure 39.

The sales tax is calculated for you, based upon the tax rate you entered
in System Customization.






@Trt
^Transaction Comments When Entering Treatment

When entering treatment, you can save a transaction comment for the
treatment completed.  You may enter one comment for each treatment.  The
number of possible comments is the same as the number of procedures
entered.  However, the way you can include a transaction comment for a
transaction when you enter treatment depends upon the treatment program in
use.  






@Trt
^Apply Charges to Future Contract

After entering treatment, if you associate any of the treatment with a
Production Through Treatment Future Contract, you can apply the current
charges to the current contract balance (Figure 39).  This reduces the
production amount remaining on the contract, but does not affect the
amount of money the patient pays.  

~These charges will not increase the patient's balance.~

Figure 39 indicates that John Q. Public had $1200.00 worth of treatment
performed by Dr. Sample.  You can apply this treatment amount against his
remaining production (future production) of his contract, which is
$1200.00.  What this means is that by applying today's charges he is
reducing the amount left on his contract.  
 
As you enter more and more treatment over a period of time, the remaining
production amount will grow smaller and smaller until the remaining
production is zero.  At this time his treatment has ended; however, his
contract may not end.  This is because what the patient owes on the
contract is not the same as the remaining production amount.  
 



@Trt
^Patient Discount 

After you enter treatment you may apply a "cash" discount that the program
applies toward the patient's treatment.  A cash discount is the same as
applying a credit adjustment to a patient's accounts receivable balance,
except you never leave the enter treatment process.  Depending upon your
payment customization, you can apply the discount directly to a particular
treatment or set of treatments.  Easy Dental Plus applies the discount to
the patient portion first; however, depending upon any open transactions,
the program could apply the discount to the insurance portion, if using
balance forward payment allocation.  

If customized for balance forward payment allocation you cannot directly
apply the discount to a particular treatment.  The program applies the
discount to the oldest transaction.  The oldest transaction would be the
first treatment you entered, unless there are unpaid transactions.  You
can enter the treatment(s) you wish to apply the discount to first, so
that the program applies the discount to it/them.  

If customized for open-item allocation, the program displays a listing of
available transactions.  You can then choose which transaction to apply
the discount to.  This will insure that the discount does not get applied
against the insurance's portion of the balance.






@Adjust
^Entering Credit Adjustments While Entering Payments

You can enter a credit adjustment at the same time you enter a payment. 
This allows the user to save steps in adjusting the account by combining
several steps into just a few.  Similar to the cash discount, the program
employs this method only when making a payment.  The way you enter a
credit adjustment depends upon the payment allocation method used.

If you customize for balance-forward allocation a credit adjustment field
appears on the payment screen (Figure 40).  The program sets the cursor at
the payment amount field.  You can move to the credit adjustment field by
pressing <Shift-Tab>, then enter the adjustment amount.  You can then
select an adjustment code to label your credit adjustment.  

If customized for open-item allocation, the adjustment field is not
present on the payment screen.  This is because this payment method allows
you to specify credits toward a specific debit charge.  When you apply the
adjustment to a particular transaction, the program reveals the adjustment
field for open-item allocation.  

To make a credit adjustment using this method:

Enter the payment amount. 
Clear payment allocations by pressing C. 
Highlight the transaction you wish to apply the credit adjustment toward,
then press <Enter>.
Press <Shift-Tab> to move to the credit adjustment field. 
Enter the adjustment amount up to the amount of the current transaction. 
Continue allocations as normal. 

In addition, you can enter a transaction comment to give further
explanation of the credit adjustment, regardless of the payment allocation
method you use.  This is useful since adjustment codes are short and not
as descriptive as a transaction comment.




@Rec
^Updating a Patient's Recall 

If you had chosen the option Enter Treatment and Change Recall when
entering treatment, the program would display the update recall screen
(Figure 41).  You can update the patient's recall by entering a new prophy
or dental recall date in the Next Recall Date fields.  The prophy recall
field associates with treatments that you or Easy Dental Plus defined as
prophies. 

The program automatically updates the Next Prophy Recall Date field the
number of months found in the recall frequency field.  User input is not
necessary.  If, however, you need a different recall date or time, you may
override the displayed date/time by entering a new date/time.

You can perform several functions when viewing the change recall screen:

     ~*Update recall frequency and visit length.
     *Update prophy and dental recall date and time. 
     *Enter recall comments. 
     *Associate the patient's recall date with a scheduled appointment.~

~Updating recall frequency and visit length~

The cursor automatically bypasses these fields initially when updating a
patient's recall.  If you need to change the recall frequency or the visit
length, you may do so by pressing <Shift-Tab> until you reach the
appropriate field.  Once changed, you can then return to the Next Prophy
Recall Date field to enter the patient's next recall date.  


~Updating Prophy and Dental Recall Date/Time~

If a procedure entered counts as a prophy, the recall program
automatically updates the recall date by the number of months specified in
the recall frequency field.  The program also updates the recall time, if
it previously existed.  However, if you update the recall using Patient
Menu Option #3, or you enter treatment without a procedure counting as a
prophy, you must update the Next Prophy Recall Date manually.


~Associating a Scheduled Appointment~

Easy Dental Plus does not consider recall date and times as scheduled
appointment unless you associate them together.  To do this, press S on
the Next Prophy/Dental Recall Date fields.  Doing this takes you to the
Appointment Scheduler where you can make an appointment for the patient. 

There are three possible situations that can occur when updating recall
and scheduling an appointment.


~Situation #1~

If a date does not appear in the Next Prophy Recall Date field but there
is a scheduled appointment, press ~S~ to update this field with the latest
scheduled appointment.


~Situation #2~

If a date does appear in the Next Prophy Recall Date field, and there is a
scheduled appointment you wish to make the same as the recall date, press
~<Space>~ to clear the recall date, then press ~S~.  The appointment date will
automatically appear in the Next Prophy Recall Date field.


~Situation #3~


If a date exists, and you want to schedule a different date for a prophy
and a scheduled appointment, press ~S~ on this field.  This will take you to
the scheduler to schedule a later appointment.




@Rec
^Recall Comments 

You can attach recall comments to a patient while updating the patient's
recall.  The process is similar to attaching a transaction comment to a
transaction.  However, recall comments are not free form in nature, and
they must exist before you can attach them to a patient.  You can
customize these comments to print on the Master Recall Report.

To attach a recall comment to a patient:  

Press <Alt-A> when the cursor is on the Next Prophy Recall Date field. 
Enter the five digit recall comment code you wish to attach to the
current patient.

If you do not know what the code is you wish to use, you may type ~?~ to
display a pop-up listing of recall comment codes.  You can enter only one
recall comment code at a time.  If you wish to enter more recall comment
codes, you will need to press ~<Alt-A>~ multiple times.

Once displayed, you may highlight the appropriate choice, then press
<Enter> to attach the highlighted recall comment code to the patient.

Once you have saved the attached recall comment codes, the phrase ~New
Recall Comments Exist~.  This verifies that the recall program
successfully attached the recall comments to the patient.     





@Trt
^The Walkout Statement

When you finish entering treatment, and you have used or skipped any
associated functions, such as credit adjustments or payments, the final
step is printing the walkout statement.  You can print up to 9 walkout
statements at one time.  Refer to Reprinting a Walkout Statement
for more information.




@TrtPln
^Treatment Planning

Treatment planning is the process of developing a schedule of
treatment to be administered to the patient over a period of
time.  The process of creating a treatment plan is similar to
that of entering treatment.  The exception is that Easy Dental
Plus does not present you with the choice of entering treatment
or changing the recall date.  Instead of this the program gives
you three other choices: 

~*enter treatment planning only,
*enter pre-treatment estimate only, 
*enter treatment planning and pre-treatment estimate.~

While entering each treatment plan procedure, you are not able
to enter the provider.  This is because the program does not
store the provider information for treatment plans.  If you
eventually complete treatment planning while entering the actual
treatment, you can select the patient's preferred dentist or
hygienist at that point in time.

You cannot add a transaction comment to treatment plan
procedures.  You add comments when you complete actual treatment.

When you finish entering a treatment plan, the program prints a
treatment plan worksheet.  The worksheet shows the total
insurance coverage and how much the insurance should pay. 
Insurance estimation will not take into account other treatment
planning you may have entered.  The basis for the insurance
estimate is the actual treatment and payments entered for this
patient.

Refer to Printing Treatment Plan Reports for reprinting a treatment
plan worksheet.

You may add new treatment to a previously existing treatment
plan by specifying this option on the treatment plan screen. 
When adding to a treatment plan, if more than one treatment plan
exists, you may choose to which treatment plan you wish to add
additional procedures to.

Refer to Adding New Procedures to a Treatment Plan for information on
how to combine new procedures to a previous existing treatment plan.

You can associate a treatment plan with a scheduled appointment
without leaving the treatment planning program.  



@TrtPln
^Treatment Plan Options

~Treatment Planning and/or Pre-treatment Estimate~

You have a choice of creating a treatment plan only, a
pre-treatment estimate only, or both.  If the patient has
insurance, the default choice is both.  If the patient does not
have insurance the default choice is treatment plan only.  You
can override any of these selections by choosing a different
option.  

If you choose ~Enter Treatment Planning Only~, you select the
treatment that you will perform at a later date.  The treatment
planning program stores this information for you to use later
when you actually enter the treatment.  This will not update the
patient's history or his account balance.  It will print a
treatment plan worksheet, and allow you to associate the
treatment plan with a scheduled appointment.

If you choose ~Enter Pre-treatment Estimate Only~ you will still
enter the procedures as though you were entering treatment;
however, the program will not print a treatment plan worksheet,
neither will you be able to associate a scheduled appointment,
since there is not a treatment plan to associate.

If you choose ~Enter Treatment Planning and Pre-treatment
Estimate~, all the available options listed above will be in
force.



@TrtPln
^Entering a Treatment Plan

Entering a treatment plan is very much like entering treatment,
with a few exceptions.  When creating a treatment plan you can:

~*combine new procedures to a previously existing treatment plan,
*enter an estimated time to complete the work,
*enter an estimated completion date.~


To enter a treatment plan:

Select 9.  Enter Treatment Planning/Pre-Treatment Estimate.
Enter the patient's last name or patient number.
Select the treatment entry you wish to perform.

You will then see a screen similar to the one seen in Figure 35.
Be sure to note the additional question at the bottom of the
screen.

~If you wish to combine this treatment plan with the most
previous uncompleted treatment plan, press <Shift-Tab> to move
to question #10.~

Using your arrow keys, change the selection to "Add To Existing
Plan."
After you change option #10, press <Esc>.

You may also, at this time, change any of the other options as
seen in Figure 35.  Press <Tab>,  <Shift-Tab>, or enter the item number
to move to an item you wish to change.

~You can press the number of the item you wish to edit, as
long as the cursor is at the bottom of the screen.~

If you are also creating a pre-treatment estimate, you next see
questions to answer.  If so:

Press <Tab> or <Shift-Tab>  to move to a question to answer.
Enter your answer.
Continue this process until all questions you wish to answer
have been answered.
Press <Esc>.

You will now see the treatment plan entry screen, as seen in
Figure 36.

Enter treatment as normal.

As you enter treatment you will notice an time estimate for the
procedure on the right side of the screen.  This time estimate
is based upon the number of units specified for the procedure
code times the number of minutes in an unit specified in the
Appointment Scheduler.

Refer to Procedure Code Fields on how to set up units of time
for a procedure code, and Setting Up The Scheduler on how to set up
units of time in the Appointment Scheduler.

~You cannot edit the estimated completion time per procedure.  
You can only adjust this for the entire treatment plan.~

When you have finished entering treatment, press <Esc>.

At this point you may alter the estimated completion time and
enter the estimated completion date for the entire treatment
plan.  To do this:

Press <Shift-Tab> until you reach either field.
Make your changes.
Press <Esc> to move the cursor to the bottom of the screen, if
not already there.
When prompted "Press <Tab> to make a change, or press <Enter> to
continue," press <Enter>.
Save your changes.

If you do not wish to associate the entire treatment plan with a
scheduled appointment, you may associate your treatment plan
later. Refer to Associating a Treatment Plan with an Appointment
for this information.



@TrtPln
^Associating a Treatment Plan with an Appointment 

After saving a treatment plan for a patient, you can associate
an appointment with a treatment plan.  This allows you to make
the appointment at that time.  Since you associated this
appointment with the treatment plan, the appointment scheduler
calculates the potential earnings of the treatment plan and
places this information on the Daily Appointment Report.  For
offices that prefer using treatment plans as a planning tool
this can be invaluable in tracking potential income generated by
their patients.  



@TrtPln
^Treatment Plan Worksheet 

The treatment plan worksheet is an agreement as to the course of
treatment to be performed by the dentist for the patient.  The
worksheet is divided into three sections:

~Section One~ contains basic patient information, including name,
address, phone numbers, last payment date and amount, birthdate,
social security number, and account balance.  

~Section Two~ contains the treatment that you perform later.  The
treatment information also includes the tooth and surface
fields, and treatment amount.

~Section Three~ contains coverage information, including the
insurance company name, coverage name, total coverage amount,
coverage remaining, amount to meet deductible, insurance
portion, and patient portion.

Refer to Printing Treatment Plan Reports for information on
reprinting a treatment plan worksheet.




@TrtPln
^Adding New Procedures to a Treatment Plan

Adding new procedures to a previously existing treatment plan is
an easy process.  All you need to do is specify you wish to do
this, and to choose which treatment plan you wish to add new
procedures to.

To add new procedures to an existing treatment plan:

Select 10.  Enter Treatment Planning/Pre-Treatment Estimate.
Enter the patient's last name or patient number.

You will now see the screen as seen in Figure 35.

Press <Shift-Tab> or enter 10 to move to the field #10.
Using the arrow keys changed the response to "Add To Existing
Plan."
If you have any insurance questions to answer, do so at this
time.

After answering insurance questions, if any, you will see a
screen similar to that shown in Figure 37.

~You may have more than one treatment plan visible.  If so, you
may choose which treatment plan to add procedures to.~

To select the treatment plan, place the highlight bar on the
treatment plan number, not the individual procedures.
Using the arrow keys, highlight the treatment plan you wish to
add procedures to.  
Press <Enter>.

The procedures associated with the treatment plan are displayed
on the screen as though you entered them.  You may now add
additional procedures to the plan.

Continue treatment planning as normal.



@TrtPln
^Working with Treatment Plans

Once you have created a treatment plan, you have several options:

~*delete procedures from the treatment plan
*delete treatment plans
*combine treatment plans
*associate appointments with treatment plans
*view pre-existing treatment plans
*print treatment plan reports
*reprint treatment plan worksheet.~

Each of these options you can carry out using the Treatment Plan
Control Center.  Most of these options are accomplished from the
menu screen seen in Figure 38.    

~Select Treatment Planning For.~  This option allows you to select
treatment planning for either an individual patient, or the
entire family.

~Select Which Plans.~  You have three options to choose from:

~*All Plans
*Scheduled Plans
*Non-Scheduled Plans Only~

~Select Which Appointments.~  This option gives you two choices: 
All Appointments, and Pending Appointments Only.

~Show Which Treatment Planning.~  You may select one of these
three choices:

~*All Treatment Planning
*Non-Deleted Treatment Planning
*Pending Treatment Planning Only~

~Start in Detailed or Summary View.~  This option determines what
you first see when viewing or printing your treatment plans.  

~Detailed~ gives you a breakdown of each procedure that comprises
the treatment plan, including procedure codes, procedure
description, tooth and surface, diagnosis date, amount, status
of procedure (completed, deleted, or pending), and
completion/deletion date.

~Summary~ gives you treatment plan number, status of treatment
plan, scheduled appointment date, estimated and actual length of
time to complete treatment plan, appointment notes, estimated
patient amount, total treatment plan cost, and provider (if an
appointment is scheduled).

~Show Patient/Insurance Amounts.~  If set to "Yes," this option
allows you to break down the charges by patient and insurance
participation.  

~Patient Name or Number.~  You may enter either the patient's last
name, or their patient number.  If viewing for a family, the
patient number does not necessarily have to be the responsible
party.  




@TrtPln
^Treatment Plan Options

When viewing or printing treatment plans you have several
options available to you:

~A~ - Add Free Form Notes.  Free form notes (comments) that you attach
to a treatment plan appear in the Report for Current Treatment
Plan, and the Report of All Treatment Plan (Detailed).

~<Ins>~ - Add Treatment Planning.  While viewing pre-existing treatment
plans you may create a new treatment plan by pressing <Ins>.

~<Del>~ - Delete Treatment Planning.  Pressing <Del> while viewing
pre-existing treatment plans allows you to delete the currently
highlighted treatment plan.  To delete an individual procedure
from a treatment plan, refer to changing status.

~D, C, <Space>~ - Changing Status.  You may change the status of a
procedure within a treatment plan.  Use one of the following keys:

~*D to change the status to deleted
*C to change the status to completed
*<Space> to change the status to pending~

~E~ - Change Estimated Date and Time.  You may enter or change the
estimated date of completion, and the estimated time to complete
the treatment plan, by pressing E while highlighting a treatment
plan.  You cannot edit the date and time if you have scheduled
an appointment for the treatment plan.

~<Enter>~ - Edit Treatment Plan.  This option allows you to add new
procedures to a pre-existing treatment plan.  Refer to 
Adding Treatment Planning on how to add to a treatment plan.

~P~ - Print Reports.  You may print one three reports, plus reprint
the Treatment Plan Worksheet.  The reports you may print are
Report for Current Treatment Plan, and Report of All Treatment
Plans (Summary and Detailed).

~S~ - Schedule an Appointment.  If a treatment plan has not been
scheduled, you may associate an appointment to the treatment
plan by pressing S while viewing pre-existing treatment plans.   

~V~ - View Summary/Detailed.  You may change from summary to detailed
view by pressing V.  Refer to Working with Treatment Plans for the
difference between summary and detailed views.

~M~ - Move Between Plans.  Pressing M while highlighting a procedure
code within a pre-existing treatment plan allows you to move
that procedure to another treatment plan.




@TrtPln
^Adding Free Form Comments

Select 10.  Treatment Plan Control Center.
Select Main Treatment Control Center.

You will now see the screen shown in Figure 38.

Enter the appropriate information to display the particular
treatment plan you wish to view.

The treatment plan(s) that match the criteria you entered in
Figure 38 appears.

Highlight the treatment plan you wish to add notes to.
Press A.

A free form comment box appears.

Type in your notes.
Press <Esc> when you are finished entering notes.
Save your changes.



@TrtPln
^Adding Treatment Planning

Select 10.  Treatment Plan Control Center.
Select Main Treatment Control Center.

You will now see the screen shown in Figure 38.

Enter the appropriate information to display a patient's
treatment plan, if any.

~The patient may or may not have a current treatment plan.  If
not, you will be alerted to this.~

Press <Ins>.

Follow the directions for Entering a Treatment Plan.




@TrtPln
^Deleting a Treatment Plan

Select 10.  Treatment Plan Control Center.
Select Main Treatment Control Center.

You will now see the screen shown in Figure 38.

Enter the appropriate information to display a patient's
treatment plan, if any.
Highlight the treatment plan you wish to delete.
Press <Del>.
When prompted "Are you sure you want to delete treatment plan
#01 and delete AND PURGE all of its associated planned treatment
(Y/N)?" press <Enter>.



@TrtPln
^Changing Status of Procedure Codes


Select 10.  Treatment Plan Control Center.
Select Main Treatment Control Center.

You will now see the screen shown in Figure 38.

Enter the appropriate information to display a patient's
treatment plan, if any.

The patient's treatment plan(s) will appear.

Highlight the procedure code whose status you wish to change.
Press C to change the status to Complete, D to Deleted, or
<Space> to change to Pending.



@TrtPln
^Changing Estimated Date and Time

Select 10.  Treatment Plan Control Center.
Select Main Treatment Control Center.

You will now see the screen shown in Figure 38.

Enter the appropriate information to display a patient's
treatment plan, if any.

The patient's treatment plan(s) will appear.

Highlight the unscheduled treatment plan whose date and time you
wish to change.
Press E.
Enter the new estimated date and time.
Save your changes.



@TrtPln
^Edit Treatment Plan

Select 10.  Treatment Plan Control Center.
Select Main Treatment Control Center.

You will now see the screen shown in Figure 38.

Enter the appropriate information to display a patient's
treatment plan, if any.

You will see the patient's treatment plan(s).

Highlight the treatment plan you wish to edit.
Press <Enter>.

Follow the directions for Entering a Treatment Plan.




@TrtPln
^Printing Treatment Plan Reports

You have three reports that you may print, plus you may reprint
the Treatment Plan Worksheet.


Select 10.  Treatment Plan Control Center.
Select Main Treatment Control Center.

You will now see the screen shown in Figure 38.

Enter the appropriate information to display a patient's
treatment plan, if any.

You will see the patient's treatment plan(s).

Press P.
Select the report you wish to print.

You will now see the report on the screen.

Press <Enter> to print the selected report.



@TrtPln
^Scheduling an Appointment


Select 10.  Treatment Plan Control Center.
Select Main Treatment Control Center.

You will now see the screen shown in Figure 38.

Highlight the treatment plan you wish to associate an
appointment with.  
Press S.

You will be taken to the Appointment Scheduler.

Select your method of scheduling.

Follow the directions for Automatic Scheduling, or 
Manual Scheduling By Date.



@TrtPln
^Moving Procedures to a Treatment Plan

Select 10.  Treatment Plan Control Center.
Select Main Treatment Control Center.

You will now see the screen shown in Figure 38.

Enter the appropriate information to display a patient's
treatment plan, if any.

The patient's treatment plan(s) will appear.

Highlight the procedure you wish to move to another treatment
plan.
Press M.
Move the highlight bar to the treatment plan that is to accept
the new procedure.
Press <Enter> to accept move.



@TrtPln
^Viewing Pre-Existing Treatment Plans

Select 10.  Treatment Plan Control Center.

You have two options for viewing treatment plans:  Main
Treatment Plan Control Center and Old Style View or Delete
Planned Treatment.  This section covers the Main Treatment
Control Center.

Select Main Treatment Control Center.

You will now see the screen shown in Figure 38.



@TrtPln
^Printing Pre-Existing Treatment Plans

Select 10.  Treatment Plan Control Center.
Select Main Treatment Control Center.

You will now see the screen shown in Figure 38.

Highlight the treatment plan you wish to print.
From the pop-up selection list choose Report for Current
Treatment Plan.

You will see a listing of the procedures and other related
information that are a part of the treatment plan.

Press <Enter> to print.

