
@Custom
^Files you can backup

Following is a list of Easy Dental Plus data files.  These are the
essential files to back up daily.

APPTCHK~(1)~      CHART          CLCONFIG.DAT         COLLECT
COM             COMCLAIM.$$$   COMMENT              CONTROL
CSZMENU         DEN.#          DENTIST              DETAIL
DETAILH         DOCTOR         EMP.#                EMPLOYER
FORMASTR        FORMDATA       GF*.*                GLMASTER
HELP.DAT        HISTORY        ICO.#                ICOMPANY
INSMASTR        INSMASTR.#     INQUEST              LASERDRV
LCOMMENT        LCOMMENT.#     LET???.LTR~(2)~        MFILE
NPLET           NS*.*          *.OSF                PAT.?~(3)~
PATIENT         PATIENT2       PRECCOM              PRINTER
PRO.#           PR2.#          PROCDESC             PROCFEES
PROCHEAD        PROVIDER       QUESTION             RECCOM
RDLET           REMINDER       *.RGS                RGSMASTR
*.RFS           RPLET          *.SSF                *.SFT
TFILE           TRANSACT       TRANSACT.DAT         TRANSCOM
TREAT           


~1.  Italicized file names are files created using certain customizing
options.
2.  Where each "?" is a number from 0 to 9.
3.  Where "?" is a letter from A through Z, or #.~



@Custom
^Data and Log Files By Group

~Log Files~

con65x70.log--Converting from ED 6.5 to 7.0 creates this.

datafix.log--This is the comprehensive log file of all utilities run
from the maintenance menu.

skdelpat.log   --This log file is created by Purgsked to list all purged
appointments.


~Doctor's Comments~


com--Contains the code and text part of doctor's comments.

comment--Contains comment codes entered on patients.  The codes come
from the com file.

lcomment--Contains general free-form comments entered on patients.  It
has an index file, lcomment.#.



~Transaction Comments~

transcom--Contains the free-form comments entered on specific
transactions.  All comments in this file must refer to a transaction in
detail or detailh.


~Recall Comments~

preccom--Contains recall comment codes entered on patients.  The codes
come from the reccom file.

reccom--Contains the code and description part of recall comments.



~Electronic Claims~

clconfig.dat--Contains essential information for Envoy's acomold program.
Some information is also used by NEIC.

comclaim.$$$--Contains prepared electronic claims that have not yet been
transmitted to Envoy or NEIC.

transact.dat   --Envoy creates this report file and NEIC appends to it.

*.dbf--NEIC data files.  

All index files are stored in the index subdirectory.

doslevel.err--NEIC related log file.

exitedt.bat--NEIC exit batch file.

script.edt--NEIC data file.

script.pas--NEIC data file.



~General Ledger~

chart--Chart of accounts.  Contains chart numbers, descriptions and some
dollar figures.

glmaster--Contains customization information for the General Ledger.

tfile--Unposted monthly activity.

mfile--Posted monthly activity.



~Index Files~

pat.?--Patient index files for looking up patients by name (?=letter).

*.#--Assorted indexes for other files.  These indexes will be noted by
each file that has one.



~Insurance Claims~

insmastr--Contains insurance claim information.  Line items come from
either the detail file (actual claims) or the treat file (estimates). 
This file also has an index file, insmastr.#.

detail--Contains the line items for actual claims.  Also see the
Transaction Files and AR section.

treat--Contains the line items for pre-treatment estimate claims.  Also
see the Treatment Planning section.


~Insurance Forms~

control--Used to store the "constants" available to insurance forms.

dpilas06.sft--A six-point font that is used for the IBM and HPII laser
generated forms.

All letters are stored in the letters subdirectory.

formastr--Contains general customization information about insurance
forms, such as form name, and form length.  Insmastr refers to this file
for its form numbers.

formdata--Contains the specific line items to appear on insurance forms. 
Associated with formastr.

gf-ins1--Laser Generated Form information for the HPIII and HPIV.

gf-ins2--Laser Generated Form information for the IBM 4019.

gf-ins3--Laser Generated Form information for the HPII compatibles.

insquest--Insurance question text.  Formastr and insmastr refer to this
file to know which questions to use.

teeth.sft--Soft font for the teeth that appear on the laser generated
forms.



~Insurance/Coverage~

icompany--Contains insurance company information.  It has an index file,
ico.#.

employer--Contains coverage/employer information.  It has an index file,
emp.#.



~Letters~

*.ltr     --Letter text.  Specific names are associated with specific
letters.

rdlet--List of referring doctors to get a referring doctor letter.

rplet--List of patients to get a referring patient letter. 

nplet--List of patients to get a new patient letter.



~Medical History Questions~

question--Text for medical/dental history questions.



~Patient Information~

patient--This and patient2 contain information about patients.  Such
items as patient name, address, coverage/employer, current balance, and
contracts are stored in these files.  Along with the pat.? index files
that contain indexes for patient names, the pat.# file serves as an
index file for patient chart numbers.

patient2--See patient.



~Printing~

printer--General printer driver information for dot matrix printers.

laserdrv--Contains general commands for laser printers, such as VMI, and
top-of-form setting.  It also contains the name of the gf-* forms
supported by this laser printer, if any.  For more information about
those files, see the insurance form and statements sections.



~Pro PC II~

acctnums--Associated with supplier file; contains account numbers per
supplier.

csscript--Contains the script file, used by EZTERM, for general
CompuServe access.

dumscrip--This script file is unused directly by ProPCII programs, but
can be used by EZTERM from a dos prompt for diagnosis purposes.

emscript--Contains the script file, used by EZTERM, for access to Schein
Customer Services.

itemclas--Contains the category or class codes and descriptions.

invcont--This is the master control file for ProPC II.  This contains
general customizing and essential client information.

invntory--Contains inventory item information, such as HSI code,
description, and cost break-downs.  Its index files are inv.# and in2.#.

invtrans--Contains inventory transaction history, such as receiving
goods and inventory usage.

modemcfg--Modem configuration information.

orddet--Contains orders' line items.

ordhead--Contains general order information.  Actual line items are in
orddet.

ordscrip--Contains the script file used for transmitting orders to
Schein.

pcscript--Contains the script file, used by EZTERM, for access to
PaperChase.

ppcorder.log--This contains the log of all of today's order transmission
sessions.

ppcorder.bak--Whenever the date changes, the old ppcorder.bak is deleted
and the old ppcorder.log is renamed to ppcorder.bak.

regenlog--This log file is created when pointers are regenerated. 
Nothing is ever deleted from this file. 

specitem--Contains list of specials electronically downloaded from Henry
Schein, Inc.

supplier--Contains supplier information.  Its index file is sup.#.


~Procedures~

procdesc--Contains procedure code descriptions and standard codes.  Its
index files are pro.# and pr2.#.

procfees--Contains procedure information per fee schedule, such as
pricing and MTD/YTD statistics.

prochead--Contains the ranges for the various procedure groups.  

procxplo--Contains explosion code information.  This also uses pro.# for
its index file.

procpays--Contains payment schedule information.



~Providers~

provider--Contains provider information.



~Referring Doctors~

dentist--Contains referring doctor information.  Its index file is
den.#.



~Reminders~

reminder--Contains all reminders.



~Report Generator~

rgsmastr--Contains the master list of all groups (data file) available
for report generator.

*.rgs--Contains the fields available for each data file that can be
reported on.

*.osf--Output script file.  Contains the specifications for what and how
to output.

*.rsf--Report script file.  Matches up a selection script file with an
output script file.

*.ssf--Selection script file.  Contains the specifications to select
items to appear on a report.



~Routing Slip~

routing.slp--Found in the letters directory, this contains the optional
additional text that may appear on a routing slip.



~Scheduler~

apptchk--This contains the list of all patients that have had treatment
entered while in the enter treatment program.  This file is cleared out
when the user returns to the patient menu.

ns*.*--The databasic files that contain all schedule (i.e.,
appointments, templates, and new patients) information.  

skedback.dpi--Created when you rebuild scheduler; this is a zipped
backup of the scheduler files from before the rebuild.



~Statements~

control--Used to store statement customization information.

gf-st3--Laser Generated Form information for statement form GF-ST3.


~System~

control--The master control file.  Contains most system customization
information, such as screen colors,  and enter treatment options.

cszmenu--City-state-zip menu customization file.

doctor--This is a double-quote/comma delimited ASCII file that contains
the doctor's name and address.

The doctor file cannot be edited or it will become corrupted.

help.dat--The help file.  

lock.dat--List of currently locked files.

username--List of user names for passwords.



~Transaction Files and Accounts Receivable~

collect--This file contains collections and allocation information, and
is cleared out by close month.  This file is essential for voiding.

detail--Detail transaction information for current and open
transactions.

detailh--Detail transaction information for closed transactions.
Contains slightly less information per transaction than detail.

history--History (past months) summary transaction file.

transact--Current month summary transaction file.



~Treatment Planning~

treat--Contains information for treatment plans.  Also contains
information for pre-treatment estimates.



@Custom
^System Customization

The System Customization menu contains many of the customizable
features you use in Easy Dental Plus.  You can customize the
program to behave in a manner more consistent with your
particular practice needs by selecting and setting any of the
many options found in the System Customization menu.  These
options can affect the behavior of payments, treatment,
daysheets, printing, and many other functions.  

System Customization is divided into nine sections, which may be
further subdivided:

~System Setup~

*Color Monitor Customization
*Networking
*Data Backup
*Setting DOS date automatically

~Printer Setup~

*Add or Change Printer Information
*Setup Printer/Port
*Select Printer
*Print Summaries After Labels or Cards
*Laser Printer Alignment Setup

~Patient Setup~

*Patient charts
*City, State, Zip Menu Customization
*Reuse old patient numbers
*Secondary retrieve patient index
*Routing Tracking
*Enter Treatment
*Walkout Statements
*Percentage Discounts
*Discount Adjustments
*Treatment Window Customization
*Insurance Amounts Customization
*Simplified Enter Treatment Customization
*Insurance Amounts and Treatment Planning
*Tooth and Surface Capitalization
*Sales Tax  
*Printing Insurance Forms When Entering Treatment
*Automatic Purging of Treatment Planning


~Enter Payment Setup~

*Use Automatic (Balance-Forward) Payment Allocation
*Enter Adjustments When Entering Treatment
*Force Redistribution of Payments
*Apply Insurance payment to Patient's portion

 
~General Accounts Receivable Setup~

*Edit User Adjustment Codes
*Print MTD Payments on Daysheets
*Update Payment Schedules During Close Month
*Bank Deposit Customization


~General Insurance Setup~

*Hold Secondary Insurance Form
*Print Last Provider of Service on Insurance Form
*Calculate Secondary Insurance as a Percentage of the Full Amount


~Screen Saver~

You can specify parameters that define how the Easy Dental
screen saver will function.


~Advanced Customization~

This option allows you to set the file paths used by Easy Dental
Plus.


@Custom
^Color Monitor

If your system uses a color monitor, you should set this option
to "Yes."  Selecting color versus monochrome affects the
highlight bars the program displays on the screen.  Since the
program is expecting a color monitor, the background,
foreground, and highlight colors will not emphasize the
selectable menu items very well. 

~In order for this feature to work properly you must assign each
work station a number, and consistently use those numbers;
otherwise, the program will not know which monitor type you are
using.~

Practices that use Easy Dental Plus on a network can customize
each work station as either monochrome or color.  This is useful
for practices that use different monitor types at various
workstations.  The process for setting this is simple:

Select System Setup.
Choose 1.  Color Monitor.
When prompted "Do you have a color monitor?" indicate "Yes" by
pressing Y <Enter>.


@Custom
^Using More Than One Computer

If you use a local area network (LAN), then you must change this
option to "Yes."  This allows Easy Dental Plus to initiate a
record locking system that prevents two users from accessing the
same patient's data at the same time; otherwise, you cannot
maintain the integrity of your data.

You must load Share.exe on all workstations when using Easy
Dental Plus on a network.

Some possible error codes that can occur if do not use the file
locking feature are:

~*Error 53 (File not found)
*Error 70 (Permission Denied)
*Error 75 (Path/file access error)
*Error 76 (Path not found)~

If these errors occur, check to ensure you have enabled this
option.




@Custom
^Backup Command Line

Easy Dental Plus does not have its own backup program.  Instead,
it calls virtually any backup program that you choose to use,
including tape backup programs.  All you need is the command
that initiates your backup program.  The command can end in
"exe," "com," or "bat."   

When you first install Easy Dental Plus it searches for the
current DOS backup program and includes the following command as
your backup command line:  C:\DOS\MSBACKUP.  You can change this
command at any time to the correct command for your backup
program.  Once you enter the backup command, you can begin your
backup process by selecting from the Master Menu option #7,
Automatic Data Backup.  

~DOS 6.2 is the most recent MS-DOS version at the time of this
printing.   The backup command for this version is MSBACKUP. 
Please check your DOS manual on the correct parameters to use
with this command.~



@Custom
^Set Date From DOS Automatically

This feature allows Easy Dental Plus to take the current DOS
date and store it for use throughout the day.  Easy Dental Plus
uses this date when you enter patient information, treatment,
payments, and other data storage functions.  When using this
feature, it is important to maintain the battery that powers the
computer's internal clock.  If this battery becomes discharged
or damaged, DOS cannot maintain the date and the date used by
Easy Dental Plus will be inaccurate.  

You must exit Easy Dental Plus at the end of the day.  This is
because the program does not reread the DOS date until you start
Easy Dental Plus again. 

~If setting date from DOS automatically...~

Check the welcome screen for the accuracy of the date and time
as retrieved from DOS each time you begin Easy Dental Plus.

If using Easy Dental Plus on a network, make sure all the
workstations' dates and times are accurate.

Do not leave Easy Dental Plus running overnight without exiting
the program.  The date will not change until you exit and begin
Easy Dental Plus again.


~If not setting the DOS date automatically...~

Enter the correct date and time each morning or session you use
Easy Dental Plus.  

If you leave Easy Dental Plus running overnight, be sure to
reset the DOS date each morning before beginning your work
session.


@Custom
^Filing Patient Charts

You can access patient records (charts) several ways.  One
method uses a chart number.  You may customize Easy Dental Plus
to use a chart number to organize your patient's charts.  Doing
so will add an additional field to the first screen of the
patient entry program (#23 Chart Number).  The chart number can
be any valid alphanumeric character up to five characters long.  

~To access a patient's record using a chart number, type #
followed by the chart number.~



@Custom
^City/State/Zip Menu

You can create a menu of city, state, and zip codes that allows
you to simplify entering this information when you add a
patient.  Once the program creates the CSZ menu,  the menu
automatically appears when you add a patient's address.


Inserting an entry

Select 1.  Insert a listing.
Highlight the selection where you want the new listing to appear
before (in front of).
Type in the city, state, and zip code for this entry.
Repeat the above steps for more entries.  


Changing a listing

Select 2.  Change a listing.
Highlight the listing you wish to change, then press <Enter>.
Type your changes.    


Deleting an entry

Select 3.  Deleting a listing.
Highlight the listing you wish to delete, then press <Enter>.
When prompted to delete the entry, indicate "Yes."



@Custom
^Reuse Old Patient Numbers  

When you add a patient to the database, the program adds a
record of a specific size to the data file.  This file will grow
by a specific number of bytes each time you add a patient.  This
can waste space if you delete patients from the system. 
Although their information is no longer present, the space for
that particular record still exists on your computer's hard
drive.  To avoid wasting disk space you can customize Easy
Dental Plus to reuse old patient numbers. 


~Archived history and old patient numbers~

If you archive patient history, and you delete a patient,  the
archived history does not contain any deletions.  This means
that if you wish to look up patient #5's history in the archived
history, you may also get another patient's history who was at
one time patient #5.



@Custom
^Secondary Retrieve Patient Index

You can specify a secondary method for retrieving a patient's
record.  Using this option, you can retrieve a patient's record
by either a chart number, or by the patient's social security
number.  You may still retrieve a patient's information by using
their last name or number, regardless of this option's setting.  

To access a patient by their social security number, enter '#'
sign (pound sign) before the social security number.



@Custom
^Keep Track of Routing

Using this option allows you to keep track of the routing slips
you printed for a day's appointments.  You can print a list for
any day during the accounts receivable month, as long as you do
not close the month.  Any information prior to the close month
date is lost.  



@Custom
^Advanced Customizing Features

When operating Easy Dental Plus on a network, or when
customizing your own directories on your computer, you can
specify the directories that Easy Dental Plus uses.  The file
paths you may set up are:

~*Program files
*Index files
*Temporary files
*Easy Dental Plus letters and Report Generator files~

Refer to Networking Easy Dental Plus for networking
information.

~If you are unfamiliar with DOS file paths, consult your DPI
support technician for assistance.~



@Custom
^Screen Saver

The Easy Dental Plus screen saver is designed to work
exclusively with Easy Dental Plus.  Many screen saves on the
market today involved memory utilization that conflicts with
Easy Dental Plus' memory requirements.  These programs can cause
system crashes, and may even contribute to data corruption.  The
Easy Dental Plus screen saver uses the same basic coding scheme
used throughout Easy Dental Plus.  It cannot harm your program
or your data.

To use the screen saver:

Select 8.  Screen Saver Setup.
When prompted "Turn Screen Savers On," press  Y <Enter>.



@Custom
^Printer Setup

Easy Dental Plus gives you the ability to use multiple printers.
This is convenient for practices that have more than one
printer port on their computer, or for practices that use a
printer switching device that routes the information to a
particular printer.  Since there are differences between printer
brands, setting up the proper printer driver is important in 
order to print reports and correspondence correctly.

~A note about laser printers:~  Only those laser printer drivers
that have a dot preceding the driver name--HP II Compatible--are
fully supported laser drivers.  While you can set up your own
laser driver, key laser printer features, such as generating
your own laser forms for insurance, will not work.



@Custom
^Add or Change Printer Information

Printers use codes known as printer or "escape" codes, indicated
by the <ESC> code in front of a decimal number.  Your printer
manual lists these codes.  You can use this option to add your
own custom printer driver to the driver listing.  This is
necessary when none of the listed drivers are sufficient for
your needs, or the generic "Any Other Printer" driver does not
work for you.  When creating your own printer driver, you will
need to add the control codes that the printer uses.  The
control codes are what indicates to the printer how to print
information, such as draft quality printing or condensed
printing.

To add a custom printer driver to your driver listing:

Select the option "Add or Change Printer Information."
Select "Add a printer" at the bottom of the right column.

The screen in Figure 6 will appear.

Type in the printer driver name.
When the cursor has moved to the Letter Quality Start line,
press <Ins> to begin adding your control codes.  Press <Ins>
to add additional control codes--up to 14 total.
Repeat the process for remaining codes.
Press <Esc> to move the cursor to the bottom of the screen.
Press <Enter> to save your information.



@Custom
^Setup Printer/Port

When you use a printer you must select a printer driver that
most closely emulates the printer you use.  To do this, you may
select from a list of stock printer drivers that comes with Easy
Dental Plus (Figure 7).

~Most computers come with at least one printer port installed.
Check your computer's manual or with a hardware technician on
how to identify a printer port.~

There may be a printer driver or drivers already selected.  To
add an additional printer driver:

Press <Ins>.
Highlight the driver that most closely emulates your printer.
Press <Enter> to select the highlighted driver.
Select the printer port as LPT1, or choose to send the output to
a DOS file.

You must specify a printer port to send the computer's output
to.  Your computer may have just one printer port.  If you have
additional printer ports, you may select LPT2 or LPT3 as
possible port assignments.  You may also send your output to a
DOS ASCII file, or to a QUE that will allow you to print in
"batch" mode.  This is a standard file format used by MS-DOS
computers.   

Repeat the above steps for additional drivers.
Once you have selected all the drivers you wish, press <Esc>.



@Custom
^Select Printer

Once you have chosen your printer drivers you may specify your
default printer, monthly statements printer, your insurance
forms printer, and your letters and labels printer.  This means
you may have a printer dedicated to a specific job.  This keeps
you from changing your printer customization before printing.

~If you print fewer cards or labels than the number specified a
summary card/label will not print.~

There are a few key combinations you can use in order to select
your printer.  

~<Alt-M>~ selects the highlighted printer as the monthly statement
printer.  

~<Alt-I>~ selects the highlighted printer as the insurance form
printer.

~<Alt-T>~ selects the highlighted printer as the letters printer.

~<Alt-L>~ selects the highlighted printer as the labels printer.

~<Enter>~ selects the highlighted printer as the default printer.



@Custom
^Print Summary After Labels and Cards

Easy Dental Plus prints a summary card or label at the end of a
printing job when printing post cards or labels.  This is useful
for large printing jobs but not for small jobs.

To enable this feature:
Press <Tab> to move to the Number of Labels field.
Type in the number of labels you wish to print before activating
a summary label or card.
When prompted to save your changes, press <Enter> to save your
changes.

To disable this feature change the number of labels to zero.



@Custom
^Laser Printer Alignment Setup

On occasion a laser printer may get out of alignment, or your
particular laser printer may not be fully HP II Compatible.  
This causes the print to not align properly on the page,
especially when printing on pre-printed forms.  To alleviate
this problem you can adjust the laser printer driver to
compensate for the alignment problem.  

~This is an advanced feature of Easy Dental Plus.  Do not use
this feature unless you are familiar with printers and printing
codes.~


To adjust your laser driver:

Select Laser Printer Driver Setup.

A screen similar to that seen in Figure 7 on page 15 appears.

Select the printer driver you wish to adjust.

You will now see the screen shown in Figure 8.

Press <Tab> until you highlight the selection you wish to
change, or press the selection's number to change the selection.
Type in the new value that field.
When you have finished entering new values, press <Esc>.
When prompted "Press <Tab>, <Shift-Tab> or Enter a number to
make a change," press either <Enter> or <Esc> to return to the
previous selection screen.



@Custom
^User Adjustment Codes

User adjustment codes are customizable adjustment codes that
appear in the code listing each time you enter a credit or debit
adjustment.  You can customize ten codes for both debits and
credits, giving you a total of 20 user adjustment codes. 
Changing the code from "User #" (where "#" is a number from 1 to
10) will activate the code.

To create an adjustment code:
Press <Tab> to move to the code you wish to change.
Type in the code you wish to use, up to 17 alphanumeric
characters.
After entering the codes you wish to use, press <Esc>.
When prompted to return to the Customization Menu, press
<Enter>.

To remove an adjustment code:

Press <Tab> to move to the code you wish to delete.
Type User #, where # is line number you are changing.
After changing the codes you wish to change, press <Esc>.
When prompted to return to the Customization Menu, press
<Enter>.



@Custom
^Print MTD Payments on Daysheets

You may include on your daysheets a total for the month-to-date
payments received during the current accounts receivable month. 
This figure indicates the total dollar amount of payments you
received during the month and not the amount of money that you
applied just to treatment.  Do not confuse this figure with
collections.

For a definition of payments and collections, refer to
Practice Management Definitions, or Glossary of Terms




@Custom
^Update Payment Schedule During Close Month

If you are using payment schedules in conjunction with your
coverages, then you have the option of updating your payment
schedules automatically once a month when you close the month. 
The program recalculates the fees charged to patients whose
coverage uses the specified payment schedule, based on what the
insurance company paid during the month.  

Refer to Creating a New Payment Schedule for more information about
payment schedules.



@Custom
^Bank Deposit Customization

The Bank Deposit Report includes the bank's address at the
bottom of the summary report.  You may enter or alter your
bank's address using this option.

Select 4.  Bank Deposit Customization.
Enter the appropriate address information in the fields seen in
Figure 10.
When prompted "Press <Enter> to continue," press <Enter>.

You are then returned to the System Customization menu.




@Custom
^Hold Secondary Insurance Forms

Using this option prevents the secondary insurance form from
printing.  This is a useful option when your practice prefers
the primary to pay its portion first before going to a secondary
coverage.  This also prevents insurance labels for the secondary
carrier from printing when you print the primary carrier's
labels.   



@Custom
^Print Last Provider of Service on the Insurance Form

In multi-provider practices patients may see more than one
provider for services.  This type of arrangement can lead to
some confusion on the insurance form.  To lessen this confusion
you may specify whose name is to appear on the insurance form: 
either the last provider of service for treatment, or the
patient's preferred provider.



@Custom
^Calculate Secondary Insurance as Percentage of Full Amount

This option gives you the choice of calculating the secondary
insurance's participation as either the remaining amount not
covered by the primary insurance carrier, or you may calculate
the secondary's portion as a percent of the full amount of
treatment. 

~The only difference between the two options is the amount of
money remaining to be paid.  It is up to the dentist to
determine whether this remaining amount is owed by the patient
or is credited to the patient's account.~


~% of Full Amount  Trt Amt  Prim Cov.- 80%  Sec Cov-50%  Remaining Portion
--------------------------------------------------------------------------
Yes              | $1000   |   $800       |  $200 (500) |    $0
                 |         |              |             |
No               |  $1000  |   $800       |  $100       |    $100~


In the above chart you see a comparison between coverage that
calculates the secondary amount based on 100% of the treatment,
and coverage that calculates the secondary amount on the
remaining amount of treatment.  You will notice that, although
if calculated at 100%, the secondary pays only $200, not $500. 
This is because out of $1000 the remaining amount not covered by
the primary insurance is only $200, which is, in this example,
all that you can charge the secondary insurance company.  

If calculated on the remaining portion, which is $200, 50%
coverage for the secondary coverage is only $100.  This means
that the patient will owe $100 for the remaining portion of the
treatment.



@Custom
^Use Automatic (Balance-Forward) payment allocation 

This option has far-reaching effects.  Depending upon your
customization, if you allocate payments to the incorrect family
member, individual patient balances could show an incorrect
amount, yet the family balance will remain accurate.  It is
important that you customize your system one way and remain
consistent with that customization.

In reality, there is only one balance stored in Easy Dental
Plus, and that is the family balance.  Individual balances are
not stored but calculated from open and current transactions     


~Balance-Forward Allocation~

This type of payment allocation closes the oldest family
transaction, regardless of the patient's record you chose to
apply a payment to.  This is the simplest method of entering a
payment.  This works fine for single or small families, and
small practices that do not care about individual balances.


~Open-item Allocation~

This type of payment allocation allows you to close specific
treatment.  Initially, this acts like balance forward
allocation, allocating the payment to the oldest family
transaction; however, you have the option of reallocating the
payment to any family member or treatment you wish.  Practices
that have many family members in a family, and practices that
wish to keep individual balances correct may chose to use this
method.




@Custom
^Enter Adjustments When Entering Payments

Although this option seems similar to a cash discount, its use
is somewhat different.  You can only enter a patient discount
when entering treatment.  You can enter a credit adjustment from
either the treatment entry program or accounts receivable.  



@Custom
^Force redistribution of payments 

When entering a payment either in Accounts Receivable or while
entering treatment, you can customize Easy Dental Plus to force
the payment (collections) to a particular provider.  This is
useful if you specify the wrong provider when entering
treatment, but you want to make sure the collections goes to the
correct provider. 

It is not recommend that you force credit balances to a
provider.  This can have detrimental effects to your collection
figures.

You can set this option to one of three settings:  Always,
Credit Balances, or Never.  

~Always.~  When set to "Always" the redistribution screen will
appear, regardless of whether the payment amount was less than,
more than, or equal to the payment amount.

~Credit Balances.~  If the payment is greater than the amount
owed, the redistribution screen could appear.  This allows you
to force the credit amount to a particular provider, even though
you did not create any production for that credit balance.  

~Never.~  Setting this option to "Never" will prevent the
redistribution screen from appearing when entering a treatment
or making a payment.  This means a patient will continue to have
a credit balance until you enter additional treatment or you
adjust the credit balance from the patient's accounts receivable
balance.

~You can still redistribute payments through Accounts Receivable,
option #2. ~



@Custom
^Prior Insurance Payments

You can customize Easy Dental Plus to apply insurance
overpayments to either the next claim's patient portion or the
insurance's portion.  The default value for this option is "No."


@Custom
^Number of walkout statements per patient 

You may set the default number of walkout statements that will
print when you finish entering treatment, regardless of whether
you make a payment at the time you enter treatment.  This does
not affect the number of receipts that prints when entering a
payment in Accounts Receivable.       

~When entering treatment, you may override this default setting
by pressing <Shift-Tab> and changing the number of walkout
statements.~



@Custom
^Give a percentage discount 

You can give a percentage discount to patients when entering
treatment.  The program takes the amount of the percentage off
the top of both the patient and insurance portions of the bill;
therefore, the program reduces each procedure in cost by the
percentage amount.  The program does not place a reference into the
patient's history.

Do not confuse this with Discount Adjustments.

A percentage discount can take three forms:  Everyone, Seniors
Only, or Never.  

~Everyone.~  This option allows you to enter a discount to all
patients, regardless of their age.  With the percentage option
set to "Everyone" you have the ability to enter a percentage
amount for the discount at the time of entering treatment.  The
default value for this option is 0%.

~Seniors Only.~  This option allows only senior citizens to
receive a percentage discount.  You may set the minimum age to
qualify for the discount, and you may set the percentage amount
of the discount.  You can override this percentage amount at the
time of entering treatment.

~Patients over 100 years old do not qualify for this discount
because Easy Dental Plus uses the last two digits of the year to
determine age; therefore, the program no longer considers a 100
year old patient a senior citizen.~

~Never.~  If you set percentage discounts to this, you cannot
enter any type of discount.  The enter treatment screen does not
indicate a percentage discount is possible when set to "Never."



@Custom
^Practice Information on walkout statement

You may customize your walkout statement to include the practice
name and address or the provider of services name and address at
the top of the walkout statement.  

~You may change the practice address through the Utilities Menu,
option #1.~  For information about his feature, refer to
Change Doctor's Address.

The program takes the practice name and address from the control
file.  When you customize to print the provider of services, the
program takes the name and address information from the provider
file, as entered through the Add/Change Provider (Entering a Provider)
option on the Provider Menu.



@Custom
^Discount Adjustments When Entering Treatment

Sometimes known as a cash discount, you can confuse this option
with a percentage discount.  When using this option, you have
the ability to enter an adjustment to the patient's account
after you enter treatment, but prior to entering a payment and
printing a walkout statement.  If you do not wish to give a
discount to the insurance portion of the treatment, you can
allocate the amount you specify to the patient's portion of the
treatment.  You must customize for open-item allocation in order
to allocate this adjustment toward specific treatment.



@Custom
^Customizing Enter Treatment Window

This is the window that appears when you enter a treatment.  You
can set four options that affect the enter treatment window. 
The first three affect the window itself, and the fourth affects
just the tooth and surface fields.      

~Start at top or middle of enter treatment window.~  Setting this
to top allows you to alter the insurance amounts, if any, in the
enter treatment window.  You may change the insurance
participation, the patient participation, or alter the amount of
the treatment entered.  If a patient does not have insurance,
you can still edit the insurance and patient participation by
setting this option to "Yes." 

~Show insurance amounts always or only when necessary.~  Normally,
you will want to show insurance amounts only when necessary. 
Setting this option displays both primary and secondary
insurance amounts, regardless of whether insurance exists for
the patient.  

~Simplify entering treatment.~  Setting this option to "Yes"
eliminates the enter treatment window.  All you get is a single
line of treatment data for each procedure code you enter.  In
addition, you cannot edit insurance amounts per procedure code
entered.  You can only edit the insurance participation for the
entire set of treatment.


To edit insurance amounts when using this option:

Move the cursor to the bottom of the screen.
Press <Shift-Tab>.
At the cursor position on the far right bottom of the screen
enter the amount of the insurance participation.
Press <Enter> to continue.


@Custom
^Use insurance amount from treatment planning

You can still use treatment planning created prior to a change
in the patient's coverage if you set this option to "Yes."  This
means you can use the dollar values set at the time of the
treatment plan instead of the current dollar values that the
patient's coverage uses if you were to create a treatment plan
today.  

Conversely, if you do not wish to use the old dollar figures in
the patient's treatment plan, you may do so by indicating "No"
to this option.  The program uses the current dollar values when
you enter treatment using the treatment plan.



@Custom
^Capitalize Tooth and Surface   

This option does not affect the enter treatment window as such,
but does allow you to enter the tooth and surface field without
having to use the <Caps-Lock> key or the <Shift> key when
entering this information.  



@Custom
^Sales Tax Percentage

You may customize Easy Dental Plus to calculate and charge a
sales tax automatically.  The program adds the sales tax as a
transaction, and updates the patient's records accordingly. 
Easy Dental Plus includes the sales tax on the walkout
statement, and on the monthly statement.



@Custom
^Show Expected From Insurance on Walkout Statement

Using this option, you may include the amount expected from
insurance on the walkout statement.  This is similar to the
amount expected from insurance that appears on the monthly
statement.




@Custom
^Print Insurance Form at Time of Entering Treatment

Instead of changing menus in order to print an insurance form,
you may specify that you have the option to print at the time of
entering treatment.  When customizing this option you have two
choices:

~Do you want "Print Insurance form" at entering treatment to be
asked?

If "Yes," do you want the default to be Yes or No?~

Setting this option to "Yes" presents the screen seen in Figure
12, when you enter treatment.  This message will also appear on
the payment allocation screen when using open-item allocation.



@Custom
^Auto Purge Completed/Deleted Treatment Planning

Normally, you should purge completed and/or deleted treatment
planning on a regular basis.  This helps to keep your treatment
plans list from getting too large.  Instead of manually
performing this task using the Treatment Plan Control Center
(Patient Menu, option #10), you can automate this task during
the close month process by setting the number of months to wait
before purging.  The range of month is 0 to 72 months.  If you
do not wish to purge at all, then you will set this to zero (0).




@Quick
^Quick Starting Easy Dental Plus

Before you can begin to use your Easy Dental Plus program you must enter
the proper information the program needs to operate.  The question is,
"How soon do you want to be operating?"  The following guidelines is
based on the assumption that you will begin using the system within a
week of installing the software.



@Quick
^Part I-- Setting Up Basic Information

Before you begin entering patient information into Easy Dental Plus you
must enter some basic information that several functions use throughout
the entire program.  This part involves three important steps:  entering
provider information, setting up medical/dental history questions, and
customizing the City/State/Zip Menu.

~Refer to ~Entering a Provider~ for the steps to adding a provider.~




@Quick
^Step One:  Entering Provider Information

You will need to enter all providers, except provider #1, into the
system before you enter any other information.  Since the program ties
patient information to a specific provider, the provider information
must come first.  To accomplish this:

Go the Provider's Menu, #47.
Choose option 1.  Add or Change Providers.
Follow the steps as outlined in Entering a Provider.

If you do not have all the information available at this time you may
return to this menu and complete it later.  However, you need to enter
items #1-7 initially.  



@Quick
^Step Two:  Medical/Dental History Questions

~If your practice does not wish to use these history questions, you may
skip this part.  However, this will affect the Patient Questionnaire and
the Patient Fact Sheet.~

For information about the Patient Questionnaire or the Patient Fact
Sheet, refer to Print Patient Fact Sheet and Questionnaire.

Before you enter patient information you should enter the questions you
will ask your patients concerning their medical and dental history. 
This is information that you use in your practice to determine treatment
for you patients.  The program uses these questions in the
Practice Demographics Report.

You may enter up to 70 questions through #44 Medical/Dental History.  Be
selective as to which questions you enter.




@Quick
^Step Three:  Customizing City, State, Zip Menu

You should enter default settings for cities and zip codes of the
surrounding communities that your practice services.  This will speed up
the process of entering patient information by giving you the choices
that are available, without you needing to manually enter this
information for each patient.

To set up your CSZ Menu:

Go to #48 System Customization.
Select 5.  Customize CSZ Menu.
Follow the steps as outlined in City/State/Zip Menu.



@Quick
^Part II--Entering Patient Information

Once you enter the basic system information you are ready to enter your
patients' information.  However, we have not stated anything about
entering coverage information and insurance company information.  This
is because you can enter this information while you enter the patient's
information, saving your several steps in the process.

~In order to get your system up and running in the least amount of time
we recommend  you concentrate only on the patients that have an accounts
receivable balance.~


~An alternative to entering coverage and insurance company
information...~

As an alternative to entering a patient's coverage and insurance
information by hand, it is possible to utilize another local dentist's
insurance and employer files.  This involves copying those files from
his system to yours.  Because of the nature of the Easy Dental Plus
database, you will need to consult the DPI Customer Technical Support
Department for assistance.



@Quick
^Step One:  Setting Up Patients/Coverages/Insurance

This step is a three-in-one process that get patient related information
into the system, and is designed with short-cuts in mind to help you
enter the most important information into Easy Dental Plus in the least
amount of time. 

~For electronic claims processing refer to Section V, Insurance Processing.~

To begin, be sure that you have all the necessary patient information
with you in an organized manner.  It will take much longer if you have
patient information scattered throughout different files.

Be sure to have the following for each patient:

    ~*accounts receivable balance
    *personal information, including address, phone number(s), social
    security number, birthdate, and age
    *preferred provider
    *insurance coverage information
    *insurance company information
    *missing teeth information (if using electronic claims processing)
    *answers to the patient's medical/dental history questions (if
    available)~


Go to the Patient Menu, option #1, to add the patient information.

Entering the patient information is straight-forward.  Pay attention to
field #12 (coverage information) on page 2 of the patient information
entry screen.  Many people mistake this for the insurance  company.  It
is not.  This field needs the coverage name or number that you specified
for the patient in the Coverages/Employers Menu.  However, there is no
need to drop what you are doing and go to that menu to add a coverage. 
By pressing the <Ins> key you can automatically go to the Add/Change
Coverage menu and enter the necessary information.  

When you are ready to enter item #5, Ins Comp. #, you may use the <Ins>
key to add an insurance company.

What if, after you have entered many patients, you come across one that
has the same coverage, but you do not remember the coverage number? 
Press "?" at item #12.  That will bring up a listing of all of the
coverages you have entered into the system.  Highlight the correct
coverage and press <Enter>.  The computer automatically inserts the
correct information.  Also, if you do not remember the number but you do
remember the name of the coverage--or at least a partial name--then type
in the name.  If there is more than one coverage that matches what you
have entered,  the program displays a pop-up listing.  All you need to
do is highlight the correct choice and press <Enter>, and the program
will insert the correct information.  

Enter medical/dental history questions.  If you do not have the answers
to these questions at this time you may come back to this later.

Finally, after you have entered all the patient information, you are
ready to save it.  When this option comes, the program will ask you some
questions:  

    ~*Send this patient a new patient letter?
    *Send Suzie Sample a referral letter?~

~Send this patient a new patient letter?~  Press Y only if the patient is
new to your practice.  If you are converting from a different software
package, or if your patients are not new, then press N.   

~Send Suzie Sample a referral letter?~  You will see this question if
another patient referred the patient you entered, or if a doctor
referred the patient.  Press Y only if the patient is a new patient into
the practice; otherwise, press N. 



@Quick
^Step Two:  Setting Up Recall

At this time it would be a good idea to enter the patient's recall date,
especially if you failed to enter it when entering patient information.
Since putting people on recall defaults to "Yes," all you need to do set
the actual recall date to put them into the recall cycle.

Refer to Patient Entry Fields Defined (Screen #1) for information
on setting up recall while entering patient information.

~If the patient does not have a current recall date, you may skip this
step.~

To set up a patient's recall:

Go to Patient Menu, option #3.
Enter the patient's name or patient number.
Enter the patient's next recall date and time.
Press <Esc>.
Press <Enter> to save the patient's recall date.

~If you are initializing balances for a family, you will want to
initialize each family member and the balance they currently owe.~



@Quick
^Step Three:  Initializing Patient Balances

The last step in setting up a patient's information is to enter the
patient's current balance.  You can initialize the patient's balance in
two ways: 

    ~*patient balance only
    *patient balance with insurance co-payment.~

If the patient does not have a current balance, you may skip this step.

Before initializing a patient's balance consider these possibilities:

    ~*Is this an individual patient or a member of a family?
    *Did the balance occur on a given date, or did the balance occur over a
    period of time.
    *Is there any outstanding insurance participation?~

To initialize a patient's balance:

Go to the 46.  Utilities.
Select option 3. Initialize Patient Balances.
Follow the initialization procedures as outlined in Section VII, System
Maintenance.



@Quick
^Now that you are done...


Nothing ever remains static.  You must continually update your data in
Easy Dental Plus to keep it current.  Your practice is a very important
part of your livelihood, and Easy Dental Plus is very important to your
practice.  Be sure to keep these ideas in mind while using Easy Dental
Plus:

    ~*Is your computer in good repair?
    *Do you have a daily, weekly, or monthly maintenance schedule to keep
    your computer hardware in good working order?
    *Do you have a set time to update patient information?
    *Have you printed all of the reports you need to operate your practice
    effectively?
    *Have you reviewed your reports to check for inaccuracies?
    *Is your office staff trained to use Easy Dental Plus?
    *Has your office staff read the User Manual?~


@Basic
^System Requirements

Easy Dental Plus software requires the following minimum configuration
and hardware:

    ~*286-based IBM compatible computer
    *640 Kb RAM
    *40 MB or larger hard disk drive
    *1 floppy drive
    *Monochrome Monitor (VGA recommended)
    *Parallel printer (dot matrix recommended)
    *Hayes compatible modem (optional)
    *MS-DOS 3.0 and higher~

DPI does not recommend other versions of DOS, such as DR DOS. Before
upgrading to a newer version of MS-DOS, please consult with a customer
technical support technician.

We do not recommend the use of any type of disk compression software,
such as Stackerr or DoubleSpacer.  DPI cannot guarantee the integrity of
your data if you use these or other types of disk compression software.



@Basic
^Installing Easy Dental Plus

You can install Easy Dental Plus on single-user systems and networks. 
The installation process is the same for both;  however, some
customizing for network use is necessary in order for the program to
function properly on a network.  Network considerations follow the
general installation instructions.

If you are installing an Easy Dental Plus Enhancement or Update, please
refer to Automatic Diskette Installation, for the steps to install an
enhancement.

There are two methods of installation: the ~easy~ method, and the ~install~
method.


~Method One:  Easy~

This method creates the default subdirectories on your computer's hard
drive.  All data and executable files reside in these directories.  The
advantage to this method is the speed of installation.  There are no
decisions for you to make.

~We will use drive A: in all examples for the purpose of clarity.
Substitute B: in the examples if you are using your B: drive.~
  
To install using the easy method:

Place the first diskette into a floppy drive.
Type EASY at the A:> prompt.

The program creates the dental directory for you and copies all the
necessary files to that directory.  

Insert the remaining disks as the program prompts you for them.


~Method Two:  Install~

The install method is for those who would like to customize the location
of the Easy Dental Plus data files.  You would do this to manage the
size of the directory, to install the program on a network, or you wish
to keep your data separate from other files to make it easier for you to
back up your data.   

To install using the install method:

Type INSTALL at the A:> prompt.
Type in the new directories and paths, if necessary (Figure 1).

The directories shown in Figure 1 are the default directories for Easy
Dental Plus.  If you wish to alter these: 

    1.  Use your <Tab> key to highlight the options you wish to change, or
    press the appropriate number to highlight that option.

    2.  Type in the new directory name, including the path.

Enter your backup command.

~Easy Dental Plus does not have a data backup routine.  Instead, Easy
Dental Plus calls the DOS backup program, currently called MSBACKUP. 
Older versions of MS-DOS call it either BACKUP.COM or BACKUP.EXE.  For
information related to the MS-DOS backup command and its parameters,
please consult your DOS manual.~

The installation program searches for the backup program your version of
MS-DOS uses (Figure 2).  You may, at this time, specify a different
backup command if you prefer a different program to perform your backup. 
Some example programs are PCTools, Fastback, Norton Utilities, or
various tape backup systems.  Easy Dental Plus "shells" to those
programs, giving control to them until the backup program has completed
the backup process.  Easy Dental Plus returns when the backup is
complete.

Customize Easy Dental Plus

After you enter your backup command, the installation program copies the
appropriate files to your hard drive.  The installation program then
displays the System Customization menu (Figure 3).  At this time, you
may accept the default settings of the installation program.  

Press <Enter> at the bottom of the screen (Figure 3).
When prompted "Enter a number to make a change or press <Enter> if above
is O.K.", press <Enter>.



@Network
^Networking Easy Dental Plus

Easy Dental Plus comes network ready.  There are just a few
customization features you need to change in order for Easy Dental Plus
to function properly on a network.

You must load share.exe on each workstation.  ~Refer to your DOS manual
on the correct parameters to use with Share.~


~Customize to use more than one computer.~

In order to use Easy Dental Plus on any network, you must let the
program know you are using multiple workstations.  In order to do this:

From the System Customization menu select System Setup.
Next, select 4. Using more than one computer.
When prompted "Will you be using more than one computer?", type Y
<Enter>.
Save your changes.


~Change your file paths for use on a network~

You must set Easy Dental Plus for network use if using the program on a
network (Figure 4).  When setting the file paths, you must specify the
full drive and path name.  You set the file paths using the Advanced
Customizing Setup (option #9) in the System Customization Menu.

To set these file paths:

From the System Customization menu select 9.  Advanced Customizing
Setup.

Figure 4 displays the Advanced Customizing Features screen.

Press <Tab> to move to the first file path.  Enter the correct drive and
file path for that option, then press <Enter> to move to the next file
path.

Repeat this process for all paths.

Press <Esc> to return to the System Customization menu.
Save your changes.



@Network
^Networking Easy Dental Plus with Lantastic Software

Normally, a simple installation is all that is necessary for Easy Dental
Plus to run on a network.  However, a Lantastic network presents a
special condition.  Many times Lantastic network uses drive E: as the
network drive.  Because the server is also a workstation, it is looking
to its own local drive--drive C:--for the program and data files.  This
causes some problems for Easy Dental Plus.

To alleviate this problem you must customize the Lantastic network to
work with Easy Dental Plus.  To do this:

    ~*Make sure that all workstations have a common drive letter mapped
    to the dental directory.

    *Disable any caching of the network drive.  Hardware level caching is
    fine.

    *Do not use any caching programs that need you to load a program at
    the workstation.

    *Make all executable program files read-only.~

~When installing an update or enhancement, you must change the executable
programs file attribute back to read-write; otherwise, you will not be
able to install the enhancement or update.~

These steps should prevent any common errors that users may experience
due to an incorrectly installed program or network.



@Network
^General Tips for Network Users

Use the following tips as guidelines to using Easy Dental Plus on a
network.  Not all networks are alike, and what works on one type of
network may not work well on another. 

Easy Dental Plus creates and deletes temporary files on a routine basis;
therefore, all users must have all rights to all files in Easy Dental
Plus directories.  

DPI recommends dedicated file servers as opposed to non-dedicated file
servers.

Easy Dental Plus operates efficiently on Novell Netware and Lantastic
networks.

As of this printing, Easy Dental Plus has encountered problems operating
on VM386, MainLan, and Netware Lite networks.



@Basic
^Function Keys

Easy Dental Plus uses a set of function keys--known as "hot keys"--to give
you access to important program functions while performing other tasks,
such as looking up another patient's data while entering another
patient's treatment.  

~<F1>~  This function key allows you to view a comprehensive on-line help
file.  The help file is context sensitive, giving you information about the
field or option you are currently using. 

~<F2>~  This function key displays patient information.  This is the same
patient inquiry function found in the Patient menu.  Using this function
key, you may access the patient's family information, account
information, insurance information, appointments, comments, and most
anything you will need to know about a patient.

~<F3>~  You may schedule an appointment from most anywhere in Easy Dental
Plus using this key.  A pop-up scheduler will appear wherever you are,
allowing you to schedule one or multiple patient appointments. 

~<F4>~  This function key adds Doctor's comments to a patient's file.

~<F5>~  This function key displays the pop-up Reminders menu.  You may add,
edit, delete, or print reminders from this menu.

~<F6>~  This function key displays coverage information.

~<F7>~  This function key activates the pop-up calculator.

~<F8>~  This function key activates the Contact Manager.

~<F9>~  This function key activates the Time Clock program.



@Basic
^Special Keys

In addition to the seven function keys, Easy Dental Plus uses special
keys and key combinations to perform specific functions.

~<Enter>~  The Enter key notifies the computer to accept the current
information and to proceed to the next field.

~<Tab>~  The tab key allows you to move from field to field.  This key
also lets you enter the current data and move to the next field.

~<Shift-Tab>~  Using this key combination allows you to move backwards
through screen fields.  This key combination also enters the current data
before moving to the previous field.

~<Esc>~  Called the "escape" key, you can use this key to move the cursor
to the bottom of a screen.  You may also use this key to cancel the entering
of data in many places in Easy Dental Plus.

~<Ctrl-P>~  If you use multiple printers, this key combination allows you
to switch from one printer to another without having to reconfigure your
system.  You must install additional printers before this key combination will
work for you.

~<Ctrl-U>~  Mistakes can be "undone" by using this key combination.  The
original information reappears.

~<Backspace>~  This key erases previously typed characters in the field
you are currently editing.   This deletes only characters to the left of the
cursor. 

~<>~  Known as the arrow keys or cursor keys, you can use this set of
keys to select screen options, or you can scroll the screen up/down or
right/left one line/column at a time if you are viewing reports.  On an
enhanced 101 keyboard there may be another set of these keys on the
number pad.  In order to use this set of keys the ~<Numlock>~ key must be
off.  

~<Home>~  This key will move the cursor to the beginning of a line.

~<End>~  This key will move the cursor to the end of a line.

~<PgUp>~  This key moves the screen upward one page (one screen's worth) of
information).

~<PgDn>~  This key moves the screen downward one page (one screen's worth) of
information). 

~<Ins>~  This key allows you to add information in different programs, such
as adding a new employer or referring doctor.

~<Del>~  This key allows you to delete information in different programs,
such as deleting a patient from a recipient listing.  This key will also
delete characters to the right of the cursor position.

~<D>~  Pressing this key while viewing patient information from Patient
Inquiry allows you to dial the patient's home or office phone numbers.



@Basic
^Entering Information Into Easy Dental Plus

Easy Dental Plus has some standard methods it uses to enter data into
the database.  There are five main types of data entry. 

~Dollar amounts and other numbers~

You can enter numbers into Easy Dental Plus with or without a decimal
point.  You do not need to enter dollar signs or commas.  Enter negative
numbers by pressing "-".   The minus sign will not appear until you
begin typing numbers.   


~Entering names and other "words"~

When you enter this type of information, all you need to do is type.  If
you type an illegal character you will hear a small "chirp."  Normally,
you do not need to capitalize the first letter of a name.  The program
will capitalize for you.  However, you must type mixed-case names, such
as ~McDonald~, as you would normally type the name.


~Either/Or Questions.~

There are only two possible answers to this type of question.  To select
"Yes" as an answer, type the letter Y.  To select "No" type the letter
N.  You may also use the arrow keys to toggle between yes and no
answers.


~Menus~

Easy Dental Plus uses two types of menus:  Pop-up and Main Menus.  Both
menu types present you with a listing of possible choices.  You can type
either the first character of the choice, or the selection number, or
you may use the arrow keys and highlight your choice with the selection
bar.

~Pressing "?" at any main menu will show you a listing of short-cut keys.~

~Main Menus~ allow you to take shortcuts to other menus.  You will find a
table of short cut keys in Appendix A.  Main Menus also use all four
arrow keys, the <Home> key, and the <End> key.

~Pop-up Menus~ utilize all four arrow keys.

    *The ~<Home>~ key takes you to the first menu choice, while the <End> key
    takes you to the last menu choice.

    *The ~<PgUp>~ and ~<PgDn>~ keys move you through multiple windows, if the
    listed items go beyond the border of the window.



~Entering Dates and Times~

~Entering Dates.~  Enter dates as either four or six digits, two digits
for each month, day, and year.  The program adds the current year for
you if you do not type it.  You must enter any number value less then 10
with a leading 0.  Example:  February would be 02.  You also may use the
"-" and "+" keys to decrease or increase the date.

~Entering Times.~  Easy Dental Plus assumes all times are between 7:00
a.m. and 6:59 p.m., unless otherwise specified.  When entering times, do
not include the colon.  The program automatically includes it.  

~Example:  02 28 61 for a date, 700 for a time.~


~Entering Patient Names or Numbers~

You can quickly access a patient's record by entering the first few
letters-- up to 8--of the patient's last name.  If the patient's last name
is shorter than 8 characters you may enter the first few letters of the
patient's first name.  Entering "A" will get a listing of all patient's
whose last name begins with the letter "A."  If more than one patient
matches your entry, a pop-up listing of matches will appear.  So, the
more letters you type, the fewer matches you will find.

~Look up John Smith as SMITHJO or SMITHJOH.~

A second method of accessing a patient's record is by entering the
patient's number.  This will give you only one match.  

A third method of accessing a patient's record is to use their chart
number.  Type # followed by the chart number.  By entering the entire
chart number you should get only one match.  However, if there is
another chart number that matches the number entered, a pop-up listing
of matches appears.  To get a listing of all of chart numbers, press
"#?"  when asked for a number.  Use the same methods above for finding
employer information, insurance company information, as well as
referring sources.   

~#110 will match 110, 1100, 110001.~

You cannot use "?" to pull a listing of patient names.


~Viewing and Printing Reports in Easy Dental Plus~

You can view most reports before you print them.  If the report is wider
or taller than the screen, you can access the "hidden" portions by using
the arrow keys, the <PgUp> <PgDn> keys, and the <Home> and <End> keys. 
To move to the top and bottom of a report quickly, you may use the
<Ctrl-PgUp> or <Ctrl-PgDn> key combinations.

~The program displays a scroll bar to the left of the report while you
are viewing it.  The scroll bar gives you your relative position within
the report.~

To print a report press ~<Enter>~ while viewing it.  A pop-up window
appears, indicating you are about to print to a specific printer.  If
this is not the correct printer, you may press ~<Ctrl-P>~ to change to a
different printer.

~Cancel printing by pressing <Esc> while printing.  The printer may not
stop immediately, especially if you are using a network.  Check your
network documentation on stopping printing on a network.~



@Comment
^Transaction Comments

You can add a transaction comment to many patient transactions.  An
additional comment can have a variety of uses:  

    ~*To explain an additional charge or credit to a patient's account
    *Note when an insurance payment was received
    *Explain a voided transaction.~

~The method for entering a transaction comment is consistent throughout
Easy Dental Plus.~

You can add a transaction comment to a payment, individual treatment,
credit and debit adjustments, contracts, and voided transactions.  If
you wish to add a transaction comment, check for the following reference
on the help bar at the bottom of the screen:  ~Comment:  <Alt-A>~.  Otherwise,
you cannot add a comment to that particular transaction.

To enter a transaction comment:

Press <Alt-A>.

The enter comment window appears (Figure 5).

Type in your transaction comment.
When finished typing, press <Esc>.
Press <Enter> to save your comment, or press C <Enter> to cancel your
comment.


~Comment Limitations~

There are just a few limitations to using transaction comments:

    *You may not enter more than one transaction comment at a time when
    entering a credit.

    *You cannot add or delete a transaction comment to a closed transaction.



@Basic
^Saving Data

Entering information is one of the basic functions of Easy Dental Plus;
so is saving information.  The prompt that you see when saving
information can take many forms:

    ~*Save or Cancel?
    *Save all data for this patient as entered, or Cancel?
    *Save Changes to Recall or Cancel?
    *Make all treatment planning Final, or Cancel.~

Regardless of the form of the message, the procedure is still the same.
In order to save information you press ~S~ followed by ~<Enter>.~

~SAVE~ is usually the default answer.  In that case, pressing ~<Enter>~ will
be sufficient.  On occasion, ~FINAL~ is the choice for saving information.
In this case you press ~"F"~ followed by ~<Enter>.~

In addition to the types of messages that prompt you to save your data,
there are several Continue prompts that prepare you for saving your
information:

~*Press <Tab> to make a change or <Enter> if above is O.K.
*To edit, press <Tab> or enter item #; To continue, press <Enter>.
*Press <Enter> to Continue, or Enter Procedure Code to Change.~

These types of prompts allow you to change information before saving it. 


@Basic
^Printing

If you want to print reports, daysheets, letters, or most any type of
printed material while viewing them, press ~<Enter>~.  You can see the
printing prompt listed on the help line located at the bottom of each
screen.

~You can add printer drivers to your system by using System Customization
option #2.~  Refer to Setup Printer/Port for more information.

When preparing to print, the program prompts you for the number of
copies you wish to print (Figure 6).  All you need to do is type in the
number of copies required--up to 9 copies.  The program also informs you
of the output's destination.  This gives you a chance to change the
destination of your printing without having to recustomize you system
for a particular printer drive.  When you see the prompt shown in Figure
6 you can change to another printer driver by pressing ~<Ctrl-P>~.  The
program displays a pop-up listing of available printer drivers (Figure
7).  Once you select the printing destination you wish to send your
output to, you are then ready to print.  

Press ~<Esc>~ to cancel printing.  This does not stop the printing process
immediately.  This is because the printer has its own memory storage,
and the information sent from the computer currently resides in the
printer's memory.  You can turn off the printer to clear its memory if
you do not want it to continue printing.

~If you are using printers on a network, you will need to use the
network's printing utility to stop printing.  For Novell networks the
utility to use is PCONSOLE.  Refer to your network documentation for
information on stopping printing on a network.~


@Util
^Autodialer

Easy Dental Plus makes it easier to contact your patients by telephone
using your computer's modem.  By using your modem as an autodialer, Easy
Dental Plus accesses the patient's phone numbers--both home and work--from
the patient's record.  It then allows you to choose the number to call,
or you may enter any other phone number manually.

In order to use your modem as an autodialer, you must follow these
guidelines:

    ~*You must have a phone attached to your modem's phone line.

    *You must turn your modem's speaker "on" in order to hear the modem dial
    (the default should be "on").~

Refer to your modem's technical manual on how to configure your modem,
or contact your local computer hardware dealer.

You can access the autodialer from within the following areas:

    *Patient Inquiry (Patient Menu option #2)
    *Dialing List (Appointment Scheduler Menu option #9)
    *Manual Scheduling By Date


~Using the Autodialer~

To use the autodialer:

Press D when you are in a program that uses the autodialer.

The screen seen in Figure 8 appears.

Using your arrow keys, highlight the number you wish to dial.

If you wish to call a number that is not listed, you may do so by enter
the number in the ~Manually Entered Number~ field.

Press <Enter>.

The modem dials the number you selected/entered (Figure 9).

When you hear "ringing" from the modem's speaker, pick up the phone that
is attached to the modem's phone line. 
Press <Esc> to abort the autodialer.

As long as you pick up the phone before you press ~<Esc>~ you will
maintain the phone connection.



@Util
^Configuring the Autodialer

You must first configure the autodialer feature before you can use it
with your modem.

Press D when you are in a program that uses the autodialer.

The screen seen in Figure 8 appears.

Press S to display the setup screen.

You will see the screen seen in Figure 10.

Press <Tab> to move to the field you need to change.

~Modem Port.~  You can select one of four ports:  Com1, Com2, Com3, and
Com4.  

~Dial Type.~  Set this to Tone.  Select Pulse only if your area only uses
pulse dialing.  Check with your local phone company  for details.

~Dial Prefix.~  This is a number or numbers you must dial in order to gain
access to an outside line.  This does not include area codes, or the
number one (1) for long distance calls.

~If your phone system pauses when accessing an outside line, you will
need to include a comma (,) after the dialing prefix.  This pauses the
modem for 1 second.  If you need to increase the pause, you may enter
more commas.~

When prompted "Press <Tab> to edit, <Enter> to Save," press <Enter>.
Save your changes.



@Util
^Calculator

You can display the pop-up calculator by pressing ~<F7>~ from virtually
any place within Easy Dental Plus.  The calculator is easy to use, and
uses the computer's keyboard as its keys.   



@Util
^Calculator Keys

~0-9~  You may use any of the number keys found on the number key pad, or the
numbered row of keys found at the top of the keyboard.

~<Del>~  This key clears the entire display.

~<>~  This key, also called <Backspace>, removes the last digit entered.

~<=>~ or ~<Enter>~  These keys give you a total.

~</>~  Division key.

~<*>~  Multiplication key.

~<->~  Subtraction key.

~<+>~  Addition key.

~<%>~  Percent key.

~<.>~  Decimal point.

~<^>~  Changes the number from positive to negative.



@Util
^Running DOS Applications

You may run many of your DOS applications (programs) directly from Easy
Dental Plus.  Easy Dental Plus gives control to your DOS program while
it runs.  When the program finishes, you are returned to Easy Dental
Plus.

In order to run DOS applications you must have the following: 

    ~*DOS 3.3 or higher
    *Application's executible file name
    *Program path
    *Working directory
    *Command line parameters (if any)~


~Application Fields~

~Program Name.~  DOS program names are made up of up to eight alphanumeric
characters, followed by an extension.  The name and extension are
separated by a dot (.).  For example "hello.exe" is the name of the
application that begins Easy Dental Plus.  Notice how the file name is
only five characters in length. 

Program names can have one of three extensions.  DOS will search for the
file name in the directory.  If there is more than one file name, but
with different extensions, DOS executes the file whose extension falls
in the following order:

    ~*.bat (batch file)
    *.com (command file)
    *.exe (executible file)~

~Pause.~  This field specifies whether or not you want a pause to occur
before Easy Dental Plus takes control after your application has ended. 
This means that DOS displays the message "Press any key to continue"
before program execution is returned to Easy Dental Plus.

~Program Path.~  The program path is the name of the directory that the
program resides in.  For example, "hello.exe" resides in the directory
"C:\DENTAL\."  The trailing backslash is added for you if left off.  

~Working Directory.~  The working directory is the directory where you
want your data saved in.  If this field is left blank, then the data is
saved in the dental directory (C:\DENTAL).  Your application may have
its own working directory specified.  If this is the case, then this
field is not used. 

~Parameters.~  Many programs use what is called a command line parameter.
A parameter is a special word or set of symbols that alter the behaviour
of the DOS application.  If your DOS program uses any command line
parameters, you must specify them in this field.



@Util
^Adding An Application


To add an application:
 
From the Master Menu select 9.  Run DOS Application Programs.

You will see a screen similar to that shown in Figure 11.

Press <Ins>.

The screen seen in Figure 12 appears.

Enter the appropriate information in to the fields shown in Figure 12.
When you have finished filling in the appropriate fields, press <Esc>.
When prompted "<Tab> to edit; <Enter> to continue," press <Enter>.

You must have the Program Name and Program Path fields filled out.



@Util
^Editing an Application

From the Master Menu select 9.  Run DOS Application Programs.

A screen similar to that found in Figure 11.

Using your arrow keys, highlight the application you wish to edit.
Press E.

A screen similar to that see in Figure 12, except there will be data
in the fields.

Press <Tab> or <Shift-Tab> to move to the field(s) you wish to edit.
Make your changes.
Continue the above steps until you have completed all your changes.
When finished, press <Esc>.
When prompted "<Tab> to edit; <Enter> to continue," press <Enter>.



@Util
^Deleting an Application

From the Master Menu select 9.  Run DOS Application Programs.

A screen similar to that found in Figure 11 appears.

Using your arrow keys, highlight the application you wish to delete.
Press <Del>.



@Basic
^Batch Printing

Many times during the day or during the close month process,
printing reports may be a difficult and/or time consuming chore.
Easy Dental Plus allows you to forgo printing until you are
ready by sending your printer output to a temporary file.  This
allows you to print this file at a time of your choosing.

It is important to note that the printer driver used when
sending the original output to the batch que must be the same or
equivalent printer driver used when printing in batch mode.

~You must first have your printer(s) set up for batch mode
printing.  Refer to System Customization on page 14 for
information on setting up your printers for batch mode printing.~

For example, if you chose to send your monthly reports to a
dot-matrix printer when sending your output to the batch que,
you cannot print to a laser printer when printing in batch mode.
The format of the page is not the same, and you will lose
information on the page.

To print a file that is set for batch mode printing:

Select 10.  Batch Printing Processor from the Master Menu.

You will see a listing of files that you may print (Figure 1).

~You may mark more than one item for printing.~

At this point you may do one of two things:

Press C next to an item to cancel printing it.
Type in a printer port number to send your output to (LPT1,
LPT2, or LPT3).
Press <Tab> to move to a listed item.
Select one of the above options by typing C, 1, 2, or 3 next to
the item.
Press <Tab> to move to the next item, and repeat the previous
step.  
Continue this process until you have marked all of the items you
wish to print or cancel.
Press <Esc> to move the cursor to the bottom of the screen.
When prompted "Press <Tab> to Continue or <Enter> to Save,"
press <Enter>.
When prompted "Do you want to Save the changes just made," press
<Enter> or Y<Enter>.

A pop-up information window informs you that you are about to
print your entries.

Press <Enter> to continue.

At this time the items selected will print to the printer port
you specified.



@Basic
^Interfacing with Quicken

If your practice owns Quicken, you may utilize Easy Dental Plus'
Quicken interface to transfer both your accounts receivable
payments and General Ledger to Quicken, using two different
export programs.  Selecting either the Accounts Receivable or
General Ledger export from the Run DOS Application Programs, the
utility creates a *.qif file that you may import into Quicken
using Quicken's import function. You may then manipulate your
accounts receivable or General Ledger data with Quicken.

You cannot import Quicken data into Easy Dental Plus.  You may
only export your accounts receivable data to Quicken.

You must import your payment information before you close the
month; otherwise, your figures will not match.

~For directions on how to operate Quicken, please refer to your
Quicken documentation, or call the Intuit technical support
department for assistance.~

Important Note:  You can only export your General Ledger to
Quicken only once.  If you run the export program more than
once, you will create duplicate entries in Quicken.


~Accounts Receivable QIF File~

The accounts QIF file created by the Quicken Interface is called
expquick.qif.  The format is in the following format:

~!Type:Bank 
D05/04/94 
T100.00 
LDeposits:Check 
PRik Pekkonen 
^~ 

~General Ledger QIF Files~

There are five General Ledger QIF files created by the Quicken
Interface.  These files are:

~expasset.qif~ -- Assets
~explib.qif~ -- Liabilities
~expinc.qif~ -- Income
~expeqty.qif~ --  Equity
~expexpen.qif~ -- Expenses

The General Ledger QIF files follow the following format:

~!TYPE:BANK 
D01-18-94 
T-1000 
P10100 
M                         
L[Asset] 
^~

DISCLAIMER:  DPI does not guarantee the reliability of Quicken
or any Intuit product.  Use of this product is at the user's
discretion.  DPI is not liable for any data loss or corruption
caused by Quicken or any Intuit product.




@Util
^Interfacing with Easy OSHA

Easy OSHA is an automated training and compliance program that you may
use to train your office staff concerning OSHA safety guidelines and
regulations.  The copy of Easy OSHA that is shipped with Easy Dental
Plus is a demonstration copy only.  You must order Easy OSHA from Henry
Schein, Inc.  When shipped with Easy Dental Plus, the program places
Easy OSHA in a directory called C:\EASYOSHA.  If you change the location
of Easy OSHA, you must change the program's parameters in the Run DOS
Application Programs utility.

DISCLAIMER:  DPI does not guarantee the reliability of Easy OSHA.  Use
of this product is at the user's discretion.  DPI is not liable for any
hardware or software problems resulting from the use of Easy OSHA.



@Util
^Interfacing with MedCash

Reduce your accounts receivable and solve your patient's payment
concerns with this special MedCash Card/Patient Funding Program from
Henry Schein Financial Services, Inc.  The MedCash card reduces
cash-flow problems with a no-recourse, "same-day" payment system.  Funds
are electronically deposited into your account within 48 hours.

For information about the Medcash Card/Patient Funding Program, call
1-800-443-2756.

DISCLAIMER:  DPI does not guarantee the reliability of MedCash.  Use of
this product is at the user's discretion.  DPI is not liable for any
hardware or software problems resulting from the use of MedCash.

