@Sked
^Setting Up The Scheduler

The first time you use the scheduler menu, whether from the Master Menu
or by using the <F3> function key, the program allows you to set up your
default scheduler values.  It is important that you decide from the
beginning the general setup of your scheduler.  Future changes may not
be possible, depending on how you set up the scheduler the first time. 
The trick is to make the default settings so broad that any sensible
schedule would fit within its boundaries.

Any changes to the scheduler that require the reconstruction of the
database will cause the scheduler to erase all of your appointments. 
Plan ahead!


~Why Broad Default Settings?~

Why should your default settings go beyond what your practice does now? 
Future expansion.  There may come a time that your practice changes its
hours, or you add another provider who likes to cater to an earlier or
later crowd.  Establishing broad default settings allows you to utilize
this "empty" space without eliminating your currently scheduled
appointments.  You can trim your default settings by using templates.

~You use templates to define certain times and days that you are not
going to use for regular appointments, but for appointments of an
emergency nature.  You can change templates at anytime without affecting
your current scheduled appointments.~
 
~Minutes in 1 unit.~  A unit is a measurement of time that you define.  A
unit can last any length of time you so desire, as long as the unit is
consistent throughout the day.  Most practices use a unit base of 15
minutes.   The available unit range is 5 to 60.  

~1st Appointment of Day.~  This is the earliest time that you will
schedule an appointment.  If you plan to open your office at 7:00 a.m.
to catch the very early birds or the late-night owls heading home, then
you may want this time to be this early.  

~Last Appointment Ends At.~  This is the time the last patient of the day
is leaving your practice.  This is not the time the last appointment
begins. 

Your practice's hours of operation can range from 12:00 a.m. to 11:59
p.m.  If you are unsure of any future changes in your operating hours,
then make your operating hours the maximum available.  You can always
use templates to block off non-operating hours.

~Number of Operatories To Schedule For.~   This is the number of rooms or
chairs that your practice uses.  If you plan to add operatories in the
future, anticipate this expansion now and enter the number of chairs you
plan to use.

~Operatory Name.~  The names of your operatories default to an operatory
number.  If you do not wish to rename your operatories at this time, you
may do so later.

~You can rename your operatories from the scheduler screen, or by
editing your default values.~


@Sked
^Setting Scheduler Defaults

To set your scheduler defaults when using the scheduler menu for the
first time:

Enter the number of minutes in a unit of time.
Enter the earliest time you will ever have an appointment in the
morning. 
Enter the time the last appointment ends.
Enter the number of operatories you plan to use.
Change your operatory's name, if desired.
Save your changes.

Easy Dental Plus warns you that you are about to activate the scheduler
(Figure 2)  If you do not see this warning but you see a different one, 
press N <Enter> to cancel.


@Sked
^Changing Scheduler Defaults

When changing the default values for your appointment schedule, you are
changing the way the scheduler works.  Anytime you change the scheduler
defaults you may erase your current scheduled appointments, templates,
and office closings.  There are two conditions that allow you to change
your scheduler defaults: increasing the beginning and ending times of
your scheduled appointments, and increasing the number of operatories. 
All other changes will cause you to erase all scheduled appointments.

~If you find that you need to decrease your available time, consider
creating a template to mark off unneeded scheduler hours.~

The process for changing your scheduler defaults is the same as creating
your scheduler defaults.


~Increase/Decrease Example~

A practice may increase its beginning and ending appointment times
without causing the appointment scheduler to erase appointments.  This
means that the first appointment of the day may begin earlier than
previously set, or the last appointment may end later than previously
set, or both.  This is because you are increasing the number of
available hours in the day for your practice to accept patients.  
Therefore, you may change the time of the first appointment from 9:00
a.m. to 8:00 a.m. without erasing appointments, templates, and office
closings.  You may also change the ending appointment time from 7:00
p.m. to 8:00 p.m. without erasing appointments, templates, and office
closings.  

However, if you decide to decrease your beginning and ending appointment
times, the appointment scheduler will erase appointments.  This means
that if you have scheduled the first of the day for 8:00 a.m., and you
wish to change the scheduler defaults to make this 9:00 a.m., this will
decrease the number of hours available to schedule appointments.  The
same holds true for allowing the last appointment to end at 7:00 p.m.
rather than 8:00 p.m.  Under either circumstance, you will have
decreased the scheduler default values, and the program will erase all
scheduled appointments.

To change your default settings:

Select 13.  Change Scheduler Defaults.
Press <Tab> until your cursor is at the field you wish to edit.
Make your edits.
When finished editing your defaults, press <Esc>.
Save your changes.

If the changes you are making cause the scheduler to erase appointments,
templates, and office closings, you will see the warning screen shown in
Figure 3. This is because you are attempting to shrink the scheduler
defaults in a manner that cannot keep appointments in their proper time
slot.  If this is not what you want to do, be sure to indicate "No" at
this point.  This is preferable to erasing all your current
appointments.

If the changes you are making enlarge the scheduler, then you should see
the message shown in Figure 4.  This message indicates you have chosen
to alter the scheduler in a way that allows all current appointments to
continue to exist at their current date and time.  Since you are adding
hours or operatories to the scheduler calendar, the scheduler program
can easily add those hours without erasing any appointments, templates,
and office closings. 


@Sked
^Methods of Scheduling

The appointment scheduler offers two methods for scheduling
appointments.  Automatic scheduling searches for available openings.
Manual scheduling allows you to enter a specific date to schedule an
appointment.  Either method is viable, depending on how your practice
handles appointment scheduling.


@Sked
^Automatic VS Manual

The method of choice does depend on your individual practice.  Automatic
scheduling allows the scheduler to search for available times, on the
basis of the information you provide it.  It gives you a listing of
times that fit the criteria you establish, and you choose whichever time
is the most convenient.  The drawback to this method is the amount of
information you need to give the program before the search can begin. 

Manual scheduling allows you to go to a specific day to make an
appointment.  You do not need to give the program a large list  of
parameters to search with.  The drawback is the time and date you wish
to make the appointment for may not be available.  You then will need to
choose another date or time slot that can accommodate the appointment.

You can use a combination of manual and automatic scheduling.  You may
want to use manual at first, until the date and times you are scheduling
for become limited, then switch to automatic scheduling to find the
available time slots, avoiding wasting time searching for openings by
hand.


@Sked
^Appointment Scheduler Options

When using the Appointment Scheduler, you have many options
available to you while you are on the add/edit appointment
screen.  The following table summarizes the available command
options:  

~<+>~ - Next Day    
~<Ctrl +>~ - Next Week 
~<->~ - Previous Day     
~<Ctrl ->~ - Previous Week 
~<C>~ - Calendar View    
~<V>~ - View Color Legend 
~<G>~ - Go to Date  
~<R>~ - Go to Resource 
~<Z>~ - Zoom to Week/Day Mode      
~<A>~ - Alter Appt. Color 
~<C>~ - Confirm/Unconfirm Appt.    
~<P>~ - Change Provider 
~<D>~ - Dial Phone Number     
~<L>~ - Change Appt. Length 
~<M>~ - Move Appt.  
~<T>~ - Treatment Planning 
~<N>~ - Change Resource Name  
~<S>~ - Search for Patient Appt. 
~<Del>~ - Delete Appt.   
~<Ins>~ - Add Appt. 
~<Enter>~ - Edit/Add Appt.         

There are fewer options available when adding an appointment
through Automatic Scheduling, although all the possible options
are listed in the previous table.  For specific options, press
~<Ctrl-O>~ on the add/edit appointment screen.


@Sked
^Color Coding Procedures

Easy Dental Plus gives you the ability to color code classes of
procedures.  Color coding procedure classes makes identification of
difficult or emergency procedures quick and easy when viewing the
scheduler screen or Month-at-a-Glance Schedule View.  There are five
color codes you can choose from:

    ~*Emergency Appointment (Red default)
    *Regular Appointment (Blue default)
    *New Patient Appointment (Light Green default)
    *User 1 (Bright White default)
    *User 2 (Yellow default)~

You can define what the User 1 and 2 class codes represent.  This is
similar to user adjustment codes, except you cannot change their names.  

Refer to Selecting Scheduler Colors for color customization instructions.

You can also change a particular appointment's color class by pressing ~A~
while viewing the appointment.


@Sked
^Selecting Scheduler Colors

In addition to selecting colors for your procedure code classes, you can
also customize your Appointment Scheduler colors.

To customize your scheduler colors:

Select 14.  Change Scheduler Colors.

You will see the screen seen in Figure 5.

Press <Tab> to move to the field you wish to change.
Type in the color code number you wish to use.

~You can also change a particular appointment's color class by pressing A
while viewing the appointment.~

When finished editing the color code numbers, press <Esc>.
When prompted "Press <Tab> to change a color, <Enter> if finished,"
press <Enter>.
Save your changes.


@Sked
^Calendar

While scheduling appointments, pressing ~C~ displays a pop-up calendar.
When you display the calendar, it defaults to the current day and month. 
You may change the date to any date you wish.

~Calendar Keys~

You can use any of the following keys when using the calendar: 

~<>~ to move about the calendar.

~<+>~ and ~<->~ to move forward and backward one day.

~<Ctrl +>~ and ~<Ctrl ->~ to move forward and backward one week.

~<PgUp>~ and ~<PgDn>~ to move backward and forward one month.

~<Ctrl-PgUp>~ and ~<Ctrl-PgDn>~ to move backward and forward one year.

~<Enter>~ changes the schedule screen to the date highlighted on the
calendar.

~<Esc>~ closes the calendar and returns you to the current date.

~<G>~ goes to a date you specify.

~<T>~ goes to the current (today's) date.


@Sked
^Determining Provider Work Load

An important function of the appointment scheduler is its ability to
assign work load levels to appointments.   Easy Dental Plus defines the
work load level by the number of operatories available to the dentist at
any particular time, plus the amount of work performed in each
operatory.  For example, if your practice has four operatories and 2
providers, provider #1 may schedule two Level II appointments at the
same time.  This equals four, the number of available operatories. 
If the provider schedules a Level III and a Level II appointment at the
same time, he will go beyond his workload.  He may schedule an
appointment if he wishes, but the program will warn him that he has
exceeded his work load.

The concept of a work load level is an arbitrary decision.  You, the
user, determine what a work load level is.  A suggested guide for
determining a work load level is to make your base level (Level I)
equivalent to a simple treatmenta prophy.  This allows you to perform
prophies in all operatories without exceeding your work load.  From
there you may decide a Level II takes twice the amount of time it takes
to perform a prophy.  The next level would then be three times a prophy,
and so forth.

The following table of provider #1's appointments illustrates work load
levels.

~Time      Operatory 1    Operatory 2    Operatory 3   Operatory 4 Total
-------------------------------------------------------------------------
8:00  |   Level I     |  Level II     |              |           |    3
      |               |               |              |           |
8:30  |   Level II    |  Level II     |              |           |    4
      |               |               |              |           |
9:00  |   Level II    |  Level I      |  Level II    |           |    5~


8:00   The dentist has two appointments, one at Level I, the other at
Level II.  His total workload is 3.  

8:30   The dentist has two appointments, both at Level II.  His total
workload is 4.  

9:00   The dentist has three appointments, one at Level II, the second
at Level I, the third at Level II.  His work load is 5.  This exceeds
his work load capacity, since there are only four operatories available.

Using work load levels to determine your ability to perform treatment
will help you to apportion your appointment schedule evenly.  In this
way you will not accidentally schedule two root canals or other similar
time-consuming treatments at the same time, especially if you
categorized them as Level IIIs. 

Inasmuch the individual practice determines its own work load levels,
use a chart to categorize your treatments into work load levels. 
Organize your treatments from the simplest to the complex.  Create a
level for each available operatory.  Example:  Four operatories would
give you four levels.  Then, separate the treatments into different work
load levels.   

~Level I~   Cleaning, child prophy, adult prophy
~Level II~  Tooth sealant, oral hygiene insturction, inlays
~Level III~ Crown repair, panaoramic film, root amputation, hemisection
~Level IV~  Complete upper, reline upper partial, ocular prothesis


@Sked
^Multiple Provider Appointments

There are times when more than one provider performs treatment on a
patient during a single appointment.  The appointment scheduler allows
you to overlap these appointments, and indicates which provider is
providing treatment. 

When viewing the sample screen shown in Figure 7, you will see that you
had made a patient appointment with provider #1.  The appointment is for
1.5 hours.  However, provider #3 also performs treatment on the patient. 
To allow provider #3 to perform treatment along with provider #1, it is
just a matter of making the appointment overlap the other, as seen in
Figure 7. 

In Figure 7 you will see in the middle of the left appointment the
numbers 1 and 3.  These numbers refer to the provider number.  Because
the two numbers are separated by a comma, both providers are scheduled
to perform treatment on the patient.  However, the appointment on the
right has only a number 3 in the middle.  This means there are actually
two separate appointments, with no overlap.

If you make overlapping appointments, then how can you tell what time
the overlapping appointment begins?  Viewing the sample screen shown in
Figure 7, you will see a time column to the left.  This time column
displays the time of day according to the number of minutes per unit, as
defined in the scheduler default values.  Whenever an appointment
begins, the program displays a provider number at the top of the
appointment next to the patient's name.  In Figure 7, the appointment on
the left begins at 2:30 p.m. for provider #3, since the program
displayed his number on the line for 2:30 p.m.  The appointment to the
right begins at 2:45.

The Appointment Scheduler allows a patient to have an appointment with
up to 2 providers at the same time.

If there is an overlapping appointment, whose information does the
program display at the bottom of the appointment screen?  In the above
example, the program displays provider #1's information.  This is
because provider #1's appointment begins first.  However, by pressing
either 1 or 2 in the overlapped section of the appointment, you can
display the other provider's information.  

For example, this is the information displayed for provider #1:~

Ĵ
 Note:                               Level:1  90 Min,10:00am 06-17-94 Rm: 1 
Ĵ
 Provider: John Sample, D.D.S.        Patient: Pekkonen, Rik                  
 Home Phone: (213) 555-1212           Work Phone:                             
Ĵ
~
By pressing 2 (for the second provider), the program displays the
following information about provider #3:
~
Ĵ
 Note:                               Level:1  90 Min,10:45am 06-17-94 Rm: 1 
Ĵ
 Provider: John Collins, D.D.S.       Patient: Pekkonen, Rik                  
 Home Phone: (213) 555-1212           Work Phone:                             
Ĵ
~


@Sked
^Recall Appointments

When making appointments, you can automatically link the appointment to
a scheduled recall date.  Doing this guarantees the scheduled
appointment date and time, and the recall appointment date and time are
the same. 

When you make an appointment--either automatically or manually--you can
choose to make the appointment:

    ~*a prophy recall appointment
    *a dental recall appointment
    *not a recall appointment.~

The screen seen in Figure 10 shows the pop-up list box when you manually
schedule an appointment.



@Sked
^Automatic Scheduling

To schedule an appointment using automatic scheduling:

Select 1. Automatic Scheduling.

The screen shown in Figure 11 will appear.

Enter the patient's name or the patient's number.

Notice how the program fills in the phone numbers, family account
balance, and other appointment fields for you.

Select the provider of services.
Enter the operatory number.
Enter any notes you wish to use.
Enter the appointment length in multiples of your default unit of time.
Enter start search date--the default is today's date.
Enter the search end date--the default is 28 days past the start search
date.

The search days default to the current date for the start date, and 28
days later for the end date.

Enter search early time--this defaults to the earliest time entered in
the default setup. 
Enter search late time--this defaults to the latest time entered in the
default setup. 
Enter search days of the week--these are the days the patient is able to
come to the office.
Choose the workload level for the provider.

You determine the work load level by the number of operatories
available that the dentist can use at any particular time.  See
Determining Provider Work Load for an explanation of determining
workload.

Select the type of recall appointment.

You can designate the appointment as a prophy recall appointment, a
dental recall appointment, or not a recall appointment.

When prompted "<Enter> if finished, <Tab> to edit," press <Enter>.

The scheduler now searches for open appointment slots, on the basis of
the search information you entered.  When the program finds any
available slots, the program displays a screen similar to that shown in
Figure 12.

Using the arrow keys highlight the choice you wish to make and press
<Enter>.

The appointment scheduling screen (Figure 13) appears.  If there are
any other appointments, these will show on this screen.  Before you
continue, you have several choices to make:  move the appointment to
another time or operatory, or move the appointment to another day.

You cannot schedule an appointment earlier than the current day's date.

To move the appointment to another time or operatory

Use the  and  arrow keys to move the appointment forward and backwards
in time.

Use the  and  arrow keys to move to a different operatory.

You may also use the same set of keys as specified in the
Keys To Be Familiar With.


To move the appointment to another day

To move the appointment forward or backward one day, press <-> and <+>.

To move the appointment forward or backward one week, press <Ctrl ->
and <Ctrl +>.

To move the appointment to a specific date press G, then enter the date
you wish to move to.

To accept the new date and/or time press <Enter>.

The program returns you to the automatic appointment scheduling screen,
and displays the newly created appointment at the bottom of the screen.



@Sked
^Manual Scheduling By Date

Manual scheduling by date is very similar in function to automatic
scheduling.  The major difference is you pick a particular date to make
the appointment for rather than let the computer choose the date.  
Also, manual scheduling does not ask for search criteria before the
search begins.  You enter a minimum of information, choose a date, then
select the operatory, time, and length of the appointment.

Select 2.  View Schedule By Date and Manual Scheduling.
Enter the date of the appointment you wish to make.

You will see a screen similar to the one pictured in Figure 13 on page
1-19, with one difference:  there is no highlighted field. 

Move the blinking marker (  ) to the time and/or operatory
for the appointment.  
When you are ready to add the appointment, press <Ins>.

The blinking marker disappears, and the screen resembles the screen
shown in Figure 14.  The information you enter here is similar to the
information needed when using Automatic Scheduling.  The difference is
you need less information here.   

Enter the patient's name or number.
Highlight the provider's name, then press <Enter>.
Enter any appointment notes as necessary.
Highlight the appropriate work load level, and press <Enter>.

The marker will return and resemble this: .

Use the  and  keys to increase/decrease the length of the bar.  This
increases and decreases the length of the appointment.  
When the appointment is the length you desire, press <Enter>.

The scheduler now saves your appointment.

Press <Esc> to return to the scheduler menu.


@Sked
^Scheduling Non-Patients

Non-patients are patients new to the practice who have not come in for
an appointment.  What makes them a non-patient is that you have not
entered their patient information into the patient database.  However,
these patients do have appointments, and must be entered into the
scheduling database in order to reserve a date and time for them.

The scheduling of non-patients is slightly different from scheduling
regular patients.  The scheduler notes non-patients on the appointment
schedule as ~New Patient~.

To schedule non-patients automatically:

Follow the first few steps for scheduling patients automatically,
beginning on page 1-17. 
When you highlight the Enter Patient Name or Number field, press
<Enter>.

A pop-up window, as seen in Figure 15, appears.  This is where you enter
the non-patient's basic information.  You will notice the program
requests only the name and phone numbers of the non-patient.  This is
because the scheduler only needs this minimum amount of information in
order to make an appointment for a non-patient.  You do not save this
information in the patient database, which requires much more detailed
information about the patient.


Enter the non-patient's name.
Enter the non-patient's home and work phone number.  The work phone
number extension is optional. 
When you have entered all fields, press <Enter> to return to the
previous screen. 
Continue with the steps outlined for automatic scheduling.
 
To schedule non-patients manually:

Follow the first few steps for scheduling patients manually.

You will now see the pop-up window as shown when entering non-patient's
automatically.   

Enter the non-patient's information.
When you have entered all fields, press <Enter> to return to the
previous screen. 
Continue with the steps for manual scheduling.


@Sked
^Altering Appointments

Once you make an appointment, you are able to alter the appointment in
several ways.  The ways included:

    *Deleting an appointment (cancelling).
    *Changing the appointment length
    *Changing the appointment date and time.
    *Moving the appointment to a different date.

The last three alterations can be found in Altering Appointments.


@Sked
^Deleting An Appointment

Select 4. Search for Patient Appointments.

If the patient has more than one scheduled appointment, you will see a
pop-up screen similar to the screen seen in Figure 16.  Using the arrow
keys, highlight the appointment you wish to delete, then press <Enter>. 
You will now see the appointment calendar for the day and time you
scheduled the appointment.

With the cursor bar blinking on the appointment, press <Del>.

The program will caution you if you want to delete this appointment: 
~Canceling Current Appointment -- ARE YOU SURE? (Y/N): No.~

Press Y <Enter> to delete the appointment.
Press <Esc> twice to return to the scheduler menu.



@Sked
^Changing Appointment Date and Length

You do not need to delete scheduled appointments in order to change the
date and time of the appointment.  You can move appointments to a
different time on the same day, a different operatory on the same day, a
different day but the same time, or you can lengthen or shorten the
appointment.

Select 4.  Search for Patient Appointments.

~Do not forget that you can press "S" from the scheduling screen to
search for a patient's appointment.~

If you have scheduled more than one appointment, you will see a pop-up
screen similar to that shown in Figure 16.

Using the arrow keys highlight the appointment you wish to change, then
press <Enter>.

You will now see the appointment calendar for the day and time that you
scheduled the appointment. You have several choices to choose from,
depending on whether you are moving, lengthening, or shortening an
appointment. 


To Move An Appointment For The Same Day

Press M to move the appointment.

The appointment changes in intensity (white).

Using your arrow keys, move the appointment to the time you wish to move
it to.
Press <Enter> to place the appointment at the new time and/or operatory,
or <Esc> to abort the move.

The program displays the appointment at the new time and/or operatory.

~The lower half of the scheduling screen indicates the change in time and
location as confirmation of the change.~


To Move An Appointment To Another Day

Press G to select the day you wish to move the appointment to.

Instead of using ~G~ to move to a specific date, you may use either the
~<Ctrl +>~ or ~<Ctrl ->~ key combinations to move forward/backward one week,
or use ~<+>~ or ~<->~ to move forward/backward one day.

The current date shows in the pop-up box.

Type in the date to move the appointment to, or use the <+> or <-> keys
to increment/decrement the date by one day. 
Follow the steps for moving an appointment on the same day as stated in
the previous section.


~To Change The Length of an Appointment~

Press L on the appointment you wish to lengthen.

~You cannot decrease the length of the appointment to less that one unit
of time.  The default scheduler values contains the amount of time
equivalent to a unit.~

The last section of the appointment changes in intensity (white).

Use the down arrow key to lengthen, or the up arrow key to shorten the
length of the appointment.
Press <Enter> to accept the new length of the appointment.


@Sked
^Editing an Appointment

When scheduling an appointment a situation may develop that
requires you to edit an appointment, such as changing the type
of appointment, or the appointment notes.  Instead of deleting
and re-entering an appointment, you can edit the appointment's
information.  You may edit:

~*Notes
*Work Level
*Recall Type
*Color of Appointment~

To edit an appointment:
Select 4.  Search for Patient Appointment.

If you already know which patient's appointment you will edit,
the skip directly to the editing step.

Enter the patient's name or number to search for.

A listing of scheduled appointments will appear.

Using the arrow keys, select the appointment you wish to edit.

You will now see the screen shown in Figure 55.  

~Notice the screen seen in Figure 55.  To the right of the
appointment level are two numbers separated by a slash (60/50E).
The number on the left indicates the actual amount of time
allocated for the appointment.  The number on the left (50E) is
an estimated amount of time it will take to complete the
appointment.~

Highlight the appointment you wish to edit.
Press <Enter> to edit the appointment.

When editing an appointment a new pop-up window appears at the
bottom of the scheduler screen (Figure 56).

Change the information, as needed.
When prompted "Press <Enter> to Save," press <Enter>.



@Sked
^Confirming Appointments

Many dental offices keep a listing of appointments that they use
to mark appointment confirmations.  Easy Dental Plus automates
this process for you by allowing you to confirm appointments
while using the Appointment Scheduler.

You can confirm appointments in one of two areas in Easy Dental
Plus:

~*while on the appointment screen
*using the Autodialer.~


~Confirming on Appointment Screen~

This method of confirming an appointment would best fit the
following scenario:

You are entering a patient's appointment when you receive a call
from another patient.  It is a few days before their appointment
and they are already confirming it.  Instead of dropping what
you are doing, you press S on the scheduler screen to search for
the patient's appointment. 

Once the patient's appointment is on the screen, you press F to
confirm the appointment, after which you return to your previous
task.   

To confirm an appointment on the scheduler screen:
Search and find the patient's appointment.
Highlight the patient's appointment, if it is not already
highlighted.

The bottom of the scheduler screen will resemble that seen in
Figure 55 on page 110.

Press F to confirm the appointment.

~If you accidently confirm an appointment, press F to unconfirm
it.~

The bottom of the scheduler screen should now resemble that seen
in Figure 57.

~You will notice the Level has changed from 1 to 1C.  The "C"
indicates that this appointment has been confirmed.~


~Confirming Using Autodialer~

Select 9.  Autodialer.

You will see a screen similar to that shown in Figure 58.

Enter the appropriate information on this screen.
When the cursor is at the bottom of the screen, press <Enter> to
see the dialing list.
Highlight the patient you wish to call to confirm their
appointment.
Press D.

~It is important that you press D instead of pressing <Enter>
when confirming appointments.  This is because the highlight bar
will move when pressing <Enter>.  If you press C to confirm the
appointment, you will be confirming the wrong appointment.~

At this point the phone will dial the patient's phone number.

After speaking with the patient, you may press C to confirm the
appointment.

~If you accidently confirm an appointment, press F to unconfirm
it.~

Refer to Autodialer for more information.



@Sked
^Treatment Planning

Easy Dental Plus provides you two methods of entering treatment
planning.  The first method is by entering your treatment planning
through the Patient Menu.  The second method is to enter the treatment
planning at the time of scheduling an appointment.  This method has some
distinct advantages over the first method:

    ~*You can schedule a few procedures at a time rather than the entire
    treatment planning, especially if the patient's treatment plan contains
    many procedures,

    *You can create the treatment planning and schedule the appointment from
    the same screen,

    *The estimated total figure found on the Daily Appointment Report would
    give you a more accurate accounting of the potential income that you
    could be earning on that day.~


To create a treatment plan while making an appointment:

First, make your appointment using either the manual or automatic
scheduling.

Even though you can make an appointment using automatic scheduling, it
is much easier to create the treatment planning using manual scheduling.

~The appointment must first exist before you can associate treatment
planning to the appointment.~

Locate and highlight the patient's appointment on the scheduler screen.

You can locate the patient's appointment by using manual scheduling, or
by using the "Search For Patient Appointments" program.

With the appointment highlighted, press T.

A screen similar to that seen in Figure 17 appears.

Enter the treatment planning as normal.
Press <Esc> when you have finished entering your treatment planning.
Save your changes.

You can view the treatment planning you entered through the
Viewing Pre-Existing Treatment Plans, or through Patient Inquiry,
section 10.


@Sked
^Viewing Ten Days at a Glance

The appointment scheduler allows you to view an operatory's scheduled
appointments for a ten day period (Figure 18).  This is a useful tool if
you schedule appointments by operatory, or by a provider who uses a
particular operatory.  This can also illustrate an operatory usage
representation.  You can use this information to compare work load per
operatory. 

When viewing your appointment schedule, pressing ~Z~ allows you to zoom in
on that operatory to view the next ten days of scheduled appointments,
along with any office closings or templates.  The screen would then
resemble the screen seen in Figure 18.  

You can use all of the functions available on the regular appointment
screen when zoomed.  You will be, however, making appointments for the
current operatory only.  Yet, you may change to a different operatory by
pressing ~R~ from the zoomed appointment screen.

To return to the regular appointment screen, press ~Z~ again.  The current
date and time while zoomed are the date and time you see when you return
to the regular appointment screen.


@Sked
^Month-at-a-Glance Schedule View

In addition to viewing an operatory for a ten day period, you may view
an operatory for an entire month.  This allows you to see any available
time slots in your schedule without resorting to automatic searches for
appointments, or searching printed detailed appointment reports for
available appointment times.  This can be a valuable diagnostic tool for
your practice to use to determine the best operating hours.

When you choose to view an operatory for an entire month, you will see
the screen displayed in Figure 19.  At first glance it does not seem
this screen is very useful.  In fact, the flexibility of this display is
impressive.  While you are viewing this screen, you may do any of the
following: 

    *Use your up/down and right/left arrow keys to move about the screen.

    *Use the ~<PgUp> <PgDn>~ keys to move forward and backwards one month at a
    time.

    *Press ~<Enter>~ to view a particular day, including other operatories
    for that day.

    *Press ~G~ to select a particular day to move the cursor to.

    *Press ~R~ to select a different operatory to view.

    *If you press <Enter> to view a particular day, you may use any of the
    available keys to do any of the following:

        ~*Make an appointment
        *Delete an appointment
        *Lengthen an appointment
        *Move an appointment
        *Change appointment notes
        *Zoom in on an operatory~

                 
To use Month-at-a-Glance:

Select 3.  Month-at-a-Glance Schedule View.
Enter the operatory number you wish to view.

You will see a screen similar to the one shown in Figure 14.

Once you are finished with this section, press <Esc> until you return to
the Appointment Scheduling menu.


@Sked
^Changing An Appointment's Status

Sometimes patients miss their scheduled appointments.  Instead of
keeping the missed appointment on the books as open, you can change the
status of the appointment by using ~Change An Appointment's Status~.

You should not use this function to mark appointments as ~missed, kept,~
or ~canceled~ unless the situation warrants such an action.  This usually
means the day before and after an appointment are the days in which you
use this option.  For example, if an appointment is "kept," it means the
patient did not meet their original appointment time and date but did
come in for treatment at a later time.  This does not mean they kept
their original appointment.  The appointment scheduler automatically
updates the patient's records to indicate when they kept their regularly
scheduled appointment.

If you schedule more than one appointment for this patient, use the
arrow keys to select the appointment that is to change.

To change a patient's appointment status:

Select 5.  Change An Appointment's Status.

You will now see the warning shown in Figure 20. 

Enter the name or number of the patient whose status has changed, or
press <Enter> to change the status of non-patients.

The program displays the patient's appointment.

Press <Enter> on the appointment you need to change.

You will now see the appointment status choices:

    ~*Missed
    *Kept
    *Canceled~

Using the arrow keys, highlight the status you wish to change the
appointment to, then press <Enter>.

The program updates the appointment scheduler.



@Sked
^Searching for Patient Appointments

Easy Dental Plus allows you to search for a patient's appointment in two
ways:  either through "Search for Patient Appointments," or by pressing
~S~ while viewing the manual scheduling screen.

To use the "Search for Patient Appointments" program:

Select 4.  Search for Patient Appointments.

The program displays the pop-up screen shown in Figure 21.

Enter the patient's last name or number.

You will then see a screen similar to that shown in Figure 22.

~If there are not any appointments, the program displays a message that
indicates that it did not find any appointments.  Be sure you entered
the correct name or patient number in this case.~

Using the arrow keys, highlight the appropriate appointment, then press
<Enter>.

The scheduler screen, as seen in Figure 14 appears.  You may now alter
the appointment in any manner desired.



@Sked
^Dialing List

To assist the receptionist in contacting patients for appointment
reminders, Easy Dental Plus gives you the ability to use your computer's
modem to ~dial~ your patient's home or work phone numbers.  This can be a
time-saving utility if your office contacts patients by phone prior to
their appointments.  

~For information on how the autodialing feature functions, refer to
Autodialer.

The dialing list allows you to:

    ~*choose the date range of names to include on the dialing list
    *choose either names for all providers, or names for an individual
    provider
    *include names of patients who do not have a phone number.~

To use dialing list:

Select 9.  Dialing List.

You will see the screen seen in Figure 23.

Enter the starting and ending dates for patients with scheduled
appointments.
Select either names for all providers (Practice) or names for an
individual provider.

~If you wish to include patients who do not have a phone number, change
this option to "Yes."  Otherwise, you may leave this set to the default
(No).~

When prompted "Press <Enter> to continue, <Tab> to edit," press <Enter>.

A screen similar to that seen in Figure 24 appears.

Using your arrow keys, highlight the name you wish to dial.
Press D.

The autodialer screen, as seen in Figure 25, appears.

Highlight the number you wish to dial.
Press <Enter>.

The modem will then dial the number you selected.  

~You must have your modem's speaker turned on in order to use the
autodialer properly.  See Volume I, Section I for information.~

When you hear ringing on the modem's speaker, pick up your telephone.
Press <Esc> to abort the autodialer.

Once you pick up your telephone, the phone will maintain the phone
connection.  This leaves you free to abort the autodialer without losing
your connection.  Otherwise, you will have two speakers, the phone and
the modem, active.

After you have completed your call, hang up your phone.
Repeat the above steps for other patient phone numbers.



@Sked
^Renaming Operatories

Easy Dental Plus gives you the opportunity to rename your operatories. 
You may do this at any time without affecting your schedule
appointments.

You can rename your operatories in one of two ways:

     *through Change Scheduler Defaults (option #13)
     *from the Manual Scheduling Screen.

Refer to Setting Scheduler Defaults for information about naming
your operatories when setting your scheduler defaults.

To change your operatory name from the Manual Scheduling Screen:

Press N.

You will see a screen similar to that shown in Figure 26.

Using your arrow keys, select the operatory name you wish to change.
Press <Enter>.
Enter the new operatory name.
When prompted "<Tab> to Edit, <Enter> to Continue", press <Enter>.

Your changes are automatically saved.



@Sked
^Scheduler Reports

The Appointment Scheduler has three reports that you can print:

    ~*Daily Appointment Report,
    *Appointment Detail Report,
    *Missed Appointments MTD~



@Sked
^Daily Appointment Report

This report prints the day's appointment for up to 3 operatories
per page.  If you have more than three operatories, you need to
print out a second report that starts with operatory #4. 
Because of the amount of information that prints on the form,
and to keep the printing to a legible size, the program prints
only three operatories on one report.

Depending upon your hours and units of time, this report should
be just one to two pages in length.  You may also limit the
number of hours printed on this report by selecting the starting
and ending appointment times.  This is useful if you wish to
separate the report into time periods during the day, or if you
close the office for part of the day and you want to print just
the appointments that you scheduled for that part of the day.

This report prints for any day that you have scheduled
appointments.  If you do not find any appointments for the day
you select, a warning alerts you that no appointments were found.

The Appointment Scheduler divides this report into three
sections:  the header section, the listing section, and the
footer section.


~Header Section:~

The header section contains the practice name, the date of the
appointments for this report, the operatories listed, the page
number of the report, the date you printed the report, and the
column headings for time and room numbers.


~Listing Section:~

The listing section contains information about the appointments:
the name of the patient, notes for the appointment, appointment
confirmation, and the provider of services.  The program
provides a generous amount of space between appointments for
additional handwritten notes or comments.  

As a customizable feature, you may also customize your report to
display the time of day on the right margin of the report.  

~If you are printing more than one operatory, you must use your
arrow keys to scroll the screen in order to see the time of day
on the right margin.~


~Footer Section:~

This section, which you see only on the last page of the
appointment report, is an estimated income figure.  This figure
is the amount of money potentially generated by patient
treatment plans that you scheduled for the day.  This figure is
only an estimate.  If you have scheduled patients that do not
have a treatment plan, then the estimated figure is lower than
the actual income that you will potentially generate from
treatment that day.



@Sked
^To print the day's appointments:

Select 6.  Print A Day's Appointments.

The program displays a screen similar to the one seen in Figure
60.  

~The report date defaults to the current day's date.~

Enter the date of the appointments you wish to print.
Using the arrow keys, choose whether you intend the report to
contain practice appointments or appointments for a provider.

If  you choose Provider, the program displays a pop-up listing
of providers to choose from.

Enter the operatory number the report begins with.  This
defaults to operatory #1. 
Enter the operatory number the report ends with.  The valid
numbers are x through y, where x is the starting number chosen
and where y is a number equal to x+2.

~If you have more than three operatories you wish to print, you
will have to print the report multiple times.  For example, you
can print for operatories 1-3, then print again for 4-5.  You
may also print for operatories 2-4, then print again for
operatory 5.~

Enter the starting time you wish to include on the report.  This
defaults to the earliest available appointment time. 
Enter the ending time you wish to include on the report.  This
defaults to the time of the latest appointment you can schedule. 
Using your arrow keys, choose whether or not you wish to include
estimated totals on your report, and if you wish to print the
time on the right margin of the report.

Refer to Daily Appointment Report (footer section) for an explanation of
estimate totals. 

When prompted "Press <Enter> to continue," press <Enter>.

The program displays the Daily Appointment Report.  You may view
it at this time, or print it.  

To print the report while viewing it, press <Enter>.



@Sked
^Appointment Detail Report

The Appointment Detail Report is a listing of the appointments that you
have scheduled for a specified period of time.  You can specify the date
range for the report.  This range can be as long a range as you wish. 
The report will search and print scheduled appointments for all
providers and all operatories.

The Appointment Scheduler divides this report into two sections:  the
header and the listing sections.


~Header Section:~

The header section contains the practice name at the top of the report. 
It also lists the page number, the date range of the appointments listed
on the report, the date you printed the report, and the column headings
for the listing section.


~Listing Section:~

The scheduler divides the listing section into eight columns. Each
column contains pertinent information about the scheduled appointment.

~Time~.  The time column lists the beginning time of the appointment.

~Length~.  The length column indicates the length of the appointment (in
minutes).

~Rm #~.  The room column indicates which operatory the scheduled
appointment is in.

~Work Level~.  This indicates the work level assigned for the appointment
listed.

~Provider~.  Lists the provider's name whom the patient has an appointment
with.

~Pat #~.  The Pat # column indicates the patient number.  If the
appointment is for a non-patient, the program lists the patient number
as ~NEW~.

~Patient~.  The Patient column indicates the patient's name.

~Age~.   The age column displays the age of the patient.  If you did not
enter the date of birth in the patient's record, the age defaults to a
blank.

~Home/Work Numbers~.  The patient's home and work number (including the
work extension).

~Notes Column~.  The notes column lists the notes entered when you
scheduled the appointment.


To print the Appointment Detail Report:

Select 7.  Print Appointment Detail Report.

The screen shown in Figure 28 appears.

Enter the starting date for the report, or press <Enter> to accept the
current date (default), repeating for the ending date. 
Using your arrow keys, select either individual provider or practice.
When prompted to "Press <Enter> to continue, <Tab> to edit," press
<Enter>.

The program displays the report on the screen.  If you wish to print the
report:

Press <Enter> to print.
Press <Esc> to return to the Appointment Scheduler menu.



@Sked
^Missed Appointments MTD

The Missed Appointments MTD report is exactly as its name implies.  This
report lists the patients who missed their appointments prior to the
report's date, and is helpful in rescheduling patients whose status you
wish to make "unkept" for patients who ran into difficulty making it
into the dentist's office.  You can also use the report to impose a
missed appointment charge because the patient missed their appointment.

The layout of the Missed Appointments MTD report is similar to the
Appointment Detail Report.  You will find the differences in the listing
section.

~Date~.  This indicates the scheduled appointment date.

~Time~.  The time column lists the beginning time of the appointment.

~Length~.  The length column indicates the length of the appointment (in
minutes).

~Rm #~.   The room column indicates which operatory the scheduled
appointment is in.

~Provider~.  Lists the provider's name whom the patient has an appointment
with.

~Pat #~.  The pat # column indicates the patient number.  If the
appointment is for a non-patient, the program lists the patient number
as ~NEW~.

~Patient~.   The Patient column indicates the patient's name.

~Age~.  The age column displays the age of the patient.  If you did not
enter a date of birth in the patient's information, the age defaults to
a blank.

~Notes Column~.  The notes column lists the notes entered when you
scheduled the appointment.


To print the Missed Appointments MTD report:

Select 8.  Print Appointment Detail Report.

The report appears on your screen.

To view the report use the arrow keys to move up/down and left/right on
the screen. 
To print the report press <Enter>.
To return to the Appointment Scheduler menu, press <Esc>.



@Sked
^Schedule Office Closings, Vacations, and Resource Closings

You can mark specific days as office closings and vacations.  The
closings can be for the entire practice or for a specific provider.  
This function requires you to specify a specific date or date range. 
This means you cannot use this to mark off lunch hours, hours of
operation, or emergency appointments.  If that is what you want, then
use a template instead.

~Refer to ~Create a Template~ for information on how to mark off
specific days and time using a template.

To schedule an office closing:

Select 10.  Schedule Office Closings/Vacations.

You will now choose to schedule an office closing or vacation for the
practice or an individual provider.


If scheduling a closing for the practice:

If there are not any closings scheduled, you will see the warning
displayed in Figure 29.

Press <Enter> to create one, or press <Ins> to add one.

You will now see the information entry screen as shown in Figure 30.    

Type in a description for the closing.
Choose the type of closing from the pop-up listing.
Choose the days the closing will be for from the pop-up listing.
Pressing Y on a day marks it as a day to include in the closing.
Press N on a day marks it as a day not to include in the closing.
When finished marking the included/excluded days, press <Enter> to
continue. 
Enter the hours the closing is in effect.

~The default hours of operation are the ones specified in the scheduler
default settings.~
  
Enter the starting date the closing takes effect.
Enter the ending date the closing is in effect.
When prompted to "Press <Enter> to continue, <Tab> to edit," press
<Enter>.
Save your changes.


If scheduling a closing for a provider or resource:

You will see a pop-up listing of providers.  Highlight the appropriate
provider, then press <Enter>.

You will see a warning similar to the warning shown in Figure 29.

Press <Enter> to create one, or <Ins> to add one.

You will now see the pop-up window shown in Figure 30.
 
Follow the procedures for creating practice closings found in
section Schedule Office Closings, Vacations, and Resource Closings.



@Sked
^Editing Closings/Vacations/Openings

Select 8.  Schedule Office Closings/Vacations.
Choose to schedule an office closing/vacation for the practice or an
individual provider.

~Before editing office closings and vacations, be sure to review the
steps for creating an office closing or vacation found in
Schedule Office Closings, Vacations, and Resource Closings.

You will see a listing of scheduled closings, as seen in Figure 31.

Using the arrow keys, highlight the closing you wish to edit, and press
<Enter>.

You will see the information entry screen similar to the screen shown in
Figure 30.  The difference is the program has filled out the fields with
the previously entered information.

Press <Tab> to move to the field you wish to edit.
Edit the field.
If you are not updating the last field, press <Esc> to move the cursor
to the bottom of the screen. 
When prompted to "Press <Enter> to continue, <Tab> to edit," press
<Enter>.



@Sked
^Scheduling Office Openings

There are times when you schedule an office closing, but discover you
wish to open the office during that time.  Instead of creating an office
closing for each day of that week, except for the day you want to keep
open, you can schedule an office opening.

To schedule an office opening:

Select 11.  Schedule Office Openings.

You will now choose to schedule an office closing or vacation for the
practice or an individual provider.

Select the type of office opening you wish to create.

You will now see a screen similar to that seen in Figure 29.

Press <Enter> to create an office opening.

If more than one office opening exists, you will see a screen similar to
that seen in Figure 31.  If this is the case, press <Ins>
to add a new office opening.

You will now see the information entry screen as shown in Figure 32.    

Type in a description for the opening.
Choose the days the opening will be for from the pop-up listing.
Pressing Y on a day marks it as a day to include in the opening.
Press N on a day marks it as a day not to include in the opening.
When finished marking the included/excluded days, press <Enter> to
continue. 
Enter the hours the opening is in effect.
Enter the starting date the opening takes effect.
Enter the ending date the opening is in effect.
When prompted to "To Edit Details, Press <Tab>," press <Enter>.
Save your changes.



@Sked
^Deleting Closings/Vacations/Openings

Deleting office closings is a simple task.  This may be necessary if
vacation plans have changed, or you no longer plan to go to a
convention, and you need to reopen the office that day for appointments.

Select 10.  Schedule Office Closings/Vacations.
Select whether the closing is a provider or a practice vacation.

You will now see a listing of scheduled office closings, as seen in
Figure 31.

Using the arrow keys, highlight the closing you wish to delete.
Press <Del> to delete the closing.

The list changes to reflect one less closing. 

Press <Esc> twice to return to the scheduler menu.



@Sked
^Add or Modify a Schedule's Template

When setting up an appointment schedule, there are times when you
schedule dental office routines during the working day.  These other
office routines include lunch, coffee breaks, billing and printing
cycles, system maintenance, office maintenance, as well as other
routines established by your office.  In order to accommodate for these
routines in the appointment scheduler, you use scheduling templates.



@Sked
^What is a Template?

A template is essentially a pattern used to mark off a section of the
scheduling calendar for use by the office.  Its function is the same as
the practice of marking large red Xs on the scheduling book to indicate
that you do not allow appointments on those particular dates and times. 
The template in the appointment scheduler functions in exactly the same
way, except you no longer have to mark off individual days to restrict
appointments.  Once you create the template the scheduler automatically
marks off those days for you.    

You use a template to mark off particular days of the week and
particular times during the day.  Your schedule repeats these days and
times each week.  For example, if you want to mark Wednesday afternoon
as a regular weekly closing, you can create a template that marks every
Wednesday afternoon from 1:00 p.m. to closing.  

Of course, the office closings/vacation template seems to be the correct
function to use, but that particular template must have a date range
specified.  If the Wednesday office closing is to be "forever" until you
decide to change the date to Friday afternoon, then why continually
create an office closing template for each date range when a scheduling
template will continue to function for you until you decide to delete
it? 


~Template Types~


A template can be one of four types:  

    ~*No Appointments Allowed
    *Emergency Appointments Only
    *End of Appointments Only
    *End of Appointments and Emergencies.~

~No Appointments Allowed~.  This template type prevents you from making
all appointments during the time the template is in use.  This includes
emergency appointments.

~Emergency Appointments Only~.  This template type allows you to schedule
only emergency appointments.  You cannot schedule any other type of
appointment during that time. 

~End of Appointments Only~.  This template type allows you to designate
when regular appointments stop, but allows emergency appointments to
continue.  Appointments may not start during this time, but can end
during this time.  

~End of Appointments and Emergencies~.  This template type marks the end
of all types of appointments.  You cannot schedule any during the time
the template is in use.  Appointments may not start during this time,
but can end during this time.


~Template Categories~

A template can be one of three types:  practice, provider, and resource. 
Each has a particular function.

~Practice Template~.  The practice template is the template used to mark
off practice wide days and times that the office does not allow
appointments.  You should consider this the "master" template for the
practice.  All other templates must conform to the practice template.

~Provider Template~.  The provider template is a template that marks off
an individual provider's schedule.  If the dental practice has more than
one provider, this can offer a way for each individual provider to have
his own set schedule without creating a totally separate schedule.  This
saves the office staff from needlessly changing from one schedule to the
next in order to make appointments for another provider in a different
schedule. 

~Resource Template~.  The resource template allows you to reserve an
operatory for use during certain times of the day or week.   By using a
resource template, you can designate an operatory as "In Use" for only
emergency appointments, "Closed" for a particular part of the day or
week, or "Open" to allow more appointments in the morning or afternoon.

~Scheduling Appointments And Templates~

When creating a template, you are not allowing the program to schedule
appointments during the times specified by the template.  There are
circumstances, however, that you want to make appointments during the
time a template is in use.  

~Appointments Scheduled Before Creating The Template~

If you scheduled an appointment before you create a template, that
appointment is still valid.  Once you cancel the appointment, the space
the appointment occupied is not available for another appointment.   The
template automatically fills that date and time.


~Appointments Scheduled After Creating The Template~

If a template allows for emergency appointments, then you can schedule
that type of appointment during the time the template is in use.  You
must designate the appointment as "emergency" for the scheduler to allow
you to make the appointment.



@Sked
^Create a Template

Select 12.  Add or Modifying  a Schedule's Template.
Select the template category you wish to use.

If no templates exist, you will see a screen similar to that shown in
Figure 29.

To create a new template, press Y <Enter>; to add an additional template
press <Ins>.

An information entry screen will appear, similar to the screen shown in
Figure 30.

Enter the description for the template.
From the pop-up listing choose the template type.
From the pop-up listing choose the days the template is in use.
Pressing Y on a day will mark it as a day to include in the closing.
Press N on a day will mark it as a day not to include in the closing.
When finished marking the included/excluded days, press <Enter> to
continue. 
Enter the hours the closing will be in effect.

~The default hours of operation are the ones specified in the scheduler
default settings.~
  
When prompted "Press <Enter> to continue, <Tab> to edit," press <Enter>.
Save your changes.



@Sked
^Editing a Template

Select 12.  Add or Modify a Schedule's Template.
Select the template category you wish to use.

You will see a listing of templates.  If not, then you have not saved a
template for this type.

Using the arrow keys, highlight the template to edit and press <Enter>.

You will see the screen shown in Figure 30.

Press <Tab> to highlight the field you wish to edit.
Make your changes.
When you finish making your changes, press <Esc> to move the cursor to
the bottom of the screen. 
When prompted "Press <Enter> to continue, <Tab> to edit," press <Enter>.



@Sked
^Deleting a Template

Select 12.  Add or Modify a Schedule's Template.
Select the template category you wish to use.

You will now see a listing of templates.  If not, then you have not
saved a template for this type.

Using the arrow keys highlight the template to edit and press <Del>.
Press <Esc> to return to the scheduler menu.


