@Rpt
^Accessing the Report Generator Menu

You can reach the Report Generator menu by typing ~RG~ from any main menu,
such as the Patient Menu.  You may also type ~RUN~ from any menu to
proceed directly to the Run a Report option.



@Rpt
^Report Generator Basics

There are many aspects of a report that you need to know about in
advance before creating a report from scratch.  The items you need to be
familiar with are:

     ~*Data Objects--What the data is about.
     *Selection Script--The criterion for finding matches.
     *Connectors--A method of expanding or restricting your search
     criteria.
     *Values, Variables, and Range Variables.
     *Relationships--Greater than, less than, or equal to a value.
     *Output Format--The information you wish to see on a report.
     *Data Fields--The information the Report Generator prints on a
     report.~


~Data Objects~

The report generator utilizes items known as data objects.  You must
select a data object as the basis of any data extraction you wish to
perform.  You will probably base most reports on the patient data
objects, indicated as "List of... Patients." 

Listed below are the areas from which you may extract information, and
the available fields:  


~Patients~

Personal patient information, such as address, phone number, age, sex,
last treatment date, responsible party information, recall information,
whether or not they need a new chart label, YTD payments and finance
charges, patient insurance information, and contract information.


~Coded Comments~

Comment dates, comment codes, and comment text.

~Coverage/Employers~

Coverage/employer's address, the insurance company specified by the
coverage, group name and number, percentages of coverage for basic,
major, and preventive, and the fee schedule used by the coverage.

~Free Form Comments~

Comment date and comment text.  

~GL:  Account~

Account number, account description, last month's ending balance,
current MTD balance, and budgeted amount for the account specified.

~GL:  Posted Transactions~

Debit transaction, transaction date, account number, reference number,
batch amount, batch amount (signed), number of entries, and batch
number.

~GL:  Unposted Transactions~

Same as Posted Transactions.


~Insurance Companies~

Address, phone, contact name, dollar submitted and received, number of
claims submitted and received, and electronic claim identification
number.

~Inventory Items~

Schein item code, description, strength, size, manufacturer's code, date
and time of last HSI update, unit name, subunit name, number of subunits
per unit, location, reorder point, critical order point, desired and
current quantity, supplier information (see Suppliers), and utilization
information for the current and previous year.

~Inventory Transactions~

Inventory item information (as seen previously),  date of transaction,
transactions:  inventory counts and adjustments, received goods; order
information:  purchase order number, supplier, working order,  printed
order, deleted order, number of items on order, print/transmission date
and time, costs, sale tax, orders received (fully or partially), invoice
number; quantity change, and resulting quantity, and special information
(see specials-inventory).

~Order Information~

Purchase order number, supplier information (see suppliers), printed
order, deleted order, number of items on order, print/transmit date and
time, order costs, orders received (partially, fully, or not received),
completion date, sales tax, delivery charge, and total order cost.

~Order Line Items~

Inventory Items (see previous entry), order information (see previous
entry), line item number on order, unit and total price, quantity
ordered, quantity backordered, quantity received, date of first receipt,
total quantity received, completion date, actual unit and total cost,
and status:  not received, partially received, fully received and
closed, deleted line item.

~Outstanding Claims~

Claim number, patient information, account information, estimate and
actual claims, insurance company information, and claim print date.

~Patient Transactions (Current)~

Name of transaction, date of transaction, whether it is a debit,
procedure, or a payment, procedure code, check number, tooth and
surface, total charges, payments applied to charges, voided
transactions, credits from prior month, and non-production.  

~These are transactions that are open and yet to be fully paid,
or transactions that were entered during the current month.~


~Patient Transactions (History)~

Same as patient transactions (current). 

~These are transactions that have been closed and cannot be voided.~


~Providers~

Provider number and name, provider address information, phone number,
license number, identification numbers, MTD and YTD procedures and
production figures.

~Recall Coded Comments~

Patient information (see patients), comment date, comment code, and
comment text.

~Referring Doctors~

Dentist number and name, address information, phone number, last contact
date, identification numbers, YTD referral production, breakdown of
referrals per month during current year, last year's total reference.

~Reminders~

Reminder date, time, and text.

~Specials (Inventory)~

Item code, description, strength, size, inventory item (see previous
entry), cost, quantity, effective date, and expiration date.

~Suppliers~

Name, address, phone number, tax rate, and account number.

~Treatment Planning~

Patient information, procedure codes and descriptions, tooth and surface
information, total charge, whether you have completed or deleted the
treatment, and the completion date.




@Rpt
^Creating the Selection Script

A selection script is essentially the guideline(s) or restriction(s) you
wish to place on the search for information.  Think of guidelines as the
banks of a river.  Anything that falls outside the banks of the river is
not part of the river.  The same thing holds true for the selection
script.  If you are searching for a certain item, then you would create
guidelines that prevent anything else but that item from being selected
for your report.

~Think of the selection script as "What to find" and the output format
as "Who matches what the program found."  So, for the selection script
"What to find" you could use crowns performed on or before January 1,
1991, and "Who matches what was found" is the patient's name and  phone
number.~



@Rpt
^A Search Example

You want to find out from your patient information all patients who had
a crown on or before January 1, 1991.  What would the selection script
be for finding out such information?  

The above information tells you that you have two guidelines
(restrictions) you must meet:  1) the procedure must be a crown, and 2)
the patient had the crown on or before January 1, 1991.  This is all you
want to look for, and nothing else.  So, your selection script would
look like the following: 
 
~[Procedure Code=02750]AND[Date of Transaction010191]~

Notice that in this selection script values are defined.  This means the
Report Generator is looking for an exact match when it searches the
database. 

This is all the selection script needs to contain.  Anything else would 
be unnecessary.  You might think, "What about the patient's name and
phone number?  How will I know which patients these are?"  You do not
need this type of information until later when you define the output
format.  All that is necessary here is the subject of the report, and
that is who had a crown on or before January 1, 1991.





@Rpt
^Connectors

The sample selection script shown above contains the word AND.  The
program uses a logical connector to connect multiple selection fields. 
You must have a connector between every selection field.  The two
connectors provided are AND and OR.  Their meaning is the same meaning
the English language uses.

~AND~ creates an additional condition that restricts the field to a
certain set of information

~OR~ widens the search for information.  

See the Logic Tables section for help with using connectors and
parentheses work.~

You can also use parenthesis to group the data fields into logical
groupings.  Doing this evaluates parts of the selection script
separately.  The report generator will then evaluate the resulting
values and continue the evaluation process further until the entire
selection script has evaluated to either TRUE or FALSE.

Taking our previous example, the procedure code must be 02750 and the
date must be before and on January 1, 1991.  If we change the selection
script slightly and make the connector an OR connector the search for
information will have changed dramatically:

~[Procedure Code=02750]OR[Date of Transaction010191]~

~Make sure that leading zeroes are in place for the procedure code.  All
procedure codes are five digits in length, with leading zeroes as
important place holders.  Otherwise, you will not be able to match any
item.~

When searching for information the report generator finds all patients
who had a crown and all patients who had a transaction before and
including January 1, 1991.  That is a major difference in what the
information the Report Generator finds just by changing from AND to OR.  



@Rpt
^Logic Tables

The net result of evaluating a selection script on any one record will
be a TRUE or FALSE value.  A TRUE value results in selecting a record, a
FALSE value means the program does not select a record. Additionally,
each field within a selection script will yield a TRUE or FALSE value. 
For example, if you have [Patient Number > 200] in a selection script,
whenever the program evaluates that item on a patient record, the
outcome is going to be TRUE for every patient whose patient number is
201 or above, and it will be FALSE for your first 200 patients.  No
outcome other than TRUE or FALSE is possible.

In order to build your selection scripts properly, you must understand
how the Report Generator evaluates multiple fields in a script, and how
the connectors affect the outcome of a script. 

~Basic Logic Tables~

These are the tables for the results between two fields using the AND
and the OR logic connectors.                            
                                   

~[Field 1]      AND       [Field 2]       Resulting Value 
---------------------------------------------------------
FALSE           |        FALSE        |     FALSE 
                |                     |
FALSE           |        TRUE         |     FALSE 
                |                     |
TRUE            |        FALSE        |      FALSE 
                |                     |
TRUE            |        TRUE         |      TRUE 

 

[Field 1]      OR        [Field 2]        Resulting Value 
---------------------------------------------------------
FALSE          |         FALSE       |       FALSE 
               |                     |
FALSE          |         TRUE        |       TRUE 
               |                     |
TRUE           |         FALSE       |       TRUE 
               |                     |
TRUE           |         TRUE        |       TRUE ~



~Multiple Fields~

What happens when you have more than two fields in a row?  For example,
what if your script has [Field1] AND [Field2] OR [Field3], what is the
result?  In cases like this, the program evaluates the first two fields,
and then combines the result with the third field.  If the first two
fields turn out to be TRUE (refer to the AND table above), the result
will be TRUE (see the OR table above).  If the first two fields turn out
to be FALSE, the result will depend on the value of the third field
(according to the OR table above).

However, you can use parentheses to change how the program evaluates the
logic.  If your script reads [Field1] AND ([Field2] OR [Field3]), then
the result is different from the result in the previous paragraph.  To
find out how the program evaluates this, you must first find the result
of the second two fields using the OR table, then plug that result into
the AND table.

For a table of relationships, refer to Relationships.

~Negating Fields~

What do you do when you want the opposite of something?  For example,
what if you want all patients who do NOT have a patient number greater
than 200?  Whenever you want the negative of a field, you change the
relationship to its opposite.  In this case, you would choose all
patients who have a patient number less than or equal to 200.   


~Speed Tip~

Now that we have introduced the logic table to you, here is a tip you
can use to make your reports run faster.  The report generator will
sometimes not evaluate later fields if it finds that it does not need
to.  For example, if the first field evaluates to FALSE, and the
connector to the next field is AND, it will not bother to evaluate the
next field.  This is because a FALSE AND anything will always yield a
FALSE.  You can take advantage of this by putting data fields earlier in
your script that the program evaluates faster.

How can you tell which fields the Report Generator evaluates faster?  It
is simple:  the more menus to the right that have fields you select, the
slower an item will take to evaluate.  If you have another item that you
are using in your search criteria, for example, [Patient Number > First
Patient], put it first.  That way, you will not have to read a
coverage/employer and insurance form for every patient that the program
searches.

The aging balances shown under the responsible party object for a
patient are much slower to evaluate than it might seem.  This is because
the program searches that family's history for each aging balance in
order to calculate the family's total aging balance.  You will want to
put any reference to an aging balance at the very end of the selection
script.



@Rpt
^Values, Variables, and Range Variables

After choosing the data field and the relationship, you must have
something to compare to.  You can either enter the value now, or put in
a "place-holder" indicating that you will enter the value whenever you
run the report.  If you enter the value now, you are entering it as a
"comparison value."  If you want to supply the value when you run the
report, you are entering a "comparison variable."  If you choose a
variable, you will need to supply a name for the variable.  Whatever
name you use will be the question you see whenever you run the report. 
In the previous example, you might name the variable "First Patient."   

A selection field will resemble this:  [Data Field = Value].  During the
selection process, every selection field will result in either a ~TRUE~
or a ~FALSE~ value.

You can make the selection script more flexible by defining the
procedure code and date of transaction as variables.  This allows you to
enter different guidelines at the time of printing.  So, instead of the
guidelines "all patients who had a crown on or before January 1, 1991,"
your guidelines could be "any patient who has had a crown since any
date" that you specify.  This selection script would look like this:

~[Procedure Code=02750]AND[Date of Transaction  Date ofTransaction]~

This selection script allows you to put in any date you choose.  The
script finds anyone who had a crown on or before the date you specified
in Date of Transaction.  That is why "3" is in between the Date of
Transaction and Date of Transaction.  The "" symbols indicate this is
a variable that you can change each time you run the report.

If you choose to do the opposite and specify a specific date, but not a
specific procedure, then you would see the following:

~[Procedure Code=Procedure Code]AND[Date of Transaction  010191]~

This allows you to choose any procedure code that you performed for the
patient on or before January 1, 1991.

You can see that the selection script is really not a difficult 
concept to understand.  You must remember, however, that the selection
script is the guideline for your report and only contains the
information to search for.


~When to use a value, variable, or range variable?~

Use a ~value~ when you need an exact match, such as a name, date,
procedure code, or dollar amount.

Use a ~variable~ when you want to make the report flexible.  In the
previous examples of searching for crowns on or before January 1, 1991,
use a variable to substitute each time you run the report so that you
can enter any procedure code or date.  This saves you from creating
separate selection scripts and reports for each code or date you search
for.  Names, dates, and dollar amounts can be used as variables.

Use a ~range variable~ when you want to create separate reports for
number designated objects, such as individual patients, or providers. 
What will happen is at print time the program prompts you for a starting
and ending number.  This designates the range.  The report generator
will find information for the first range variable, print it, then
proceed to find information on the next range variable, then prints it
on a separate report.  The range variable is great for creating separate
reports at run time, but the drawback is you may only have a couple of
lines of data per page, depending on the information the program is
searching for.

You can only designate number fields as range variables.  You cannot
use dates as number fields.



@Rpt
^Relationships

A relationship is how you want to compare a value to the data field. 
The relationships provided are: 

     ~Equal To
     Not Equal To
     Less Than 
     Greater Than 
     Less Than or Equal To
     Greater Than or Equal To~

Therefore, if you want a list of all patients with patient numbers
higher than a certain number, choose the > (greater than) relationship.  


~Relationship                  Its Opposite 
-------------------------------------------
= Equal To          |         = Equal To 
< Less Than         |         > Greater Than      
> Greater Than      |         < Less Than ~



@Rpt
^Hierarchy Flowchart

The report generator hierarchy flowchart is a visual representation of
where you may extract information from the Easy Dental Plus database,
and how the "List of..." areas relate to one another.  Before creating
your report, be sure to consult the hierarchy flowchart to assist you in
constructing your selection script.  The following hints will assist you
in using the hierarchy flowchart.

Mark each area from which you wish to gather information for your
selection script and report output.  

If you mark two boxes on the same line, then you will need start on a
row higher in order to get your search criteria included on the report.

The higher you start on the chart, the more varied the selection script
is.  Conversely, the lower you start on the chart, the less varied the
selection script is.




@Rpt
^Building the Actual Selection Script

Now that you have an understanding of the selection script, we will go
through a step-by-step process of building a selection script.  

Select 1. Create/Modify A Report.

You will see a listing of areas to choose from, as seen in Figure 36.
If the information is patient based, choose Patients.

Choose 1. Create/Edit Selection Criteria. 

You will see a listing of prepared selection scripts (Figure 40).  If
you have not seen this list before, take a moment to look at it.  The
report you wish to create may already exist.  If this is the case, there
will not be a need to create your own custom report; otherwise, you may
add or alter a  selection script to your specifications. 

Press ~<Ins>~ to add a new selection script.

Next, the selection criteria screen will appear (Figure 41).  This is
the screen that allows you to build the selection script.  You will
notice the screen contains only a line at the bottom that begins with
the word Select.  This is the beginning of the selection script.  In
Figure 41 there is not a selection script; otherwise, you would see a
line of fields and connectors.

Press ~F~ to add a new field. 

When adding a field, a screen similar to that displayed in Figure 42
appears.  Listed are the data fields you can include in the selection
script.  You will also notice some fields have this symbol: .  This
symbol indicates that another level of datafields is available to use in
the selection script. 

Highlight the appropriate field.  When selected, press <Enter>. 
Choose the relationship.

For more information about values and variables please refer to
the section Values, Variables, and Range Variables.

You have several relationships that you may choose to use, as
referred to in Relationships.

Select the value of the field.

You can make the field a value, variable, or range variable, depending
on the type of field you are using.  

Refer to Connectors for more information.

If connecting criteria, press A for AND, O for OR. 
Repeat the above process for more criteria. 
When you have finished, press <Enter>.
Save your changes.
Name your selection script.

~Be sure to use a descriptive name for your selection script.  Use as
many words as necessary.~



@Rpt
^Create/Edit Output Formats

The output format is what you want the report to look like when you print
it.  This is the part where you define the information that you want to
print on the report.  This includes names, addresses, phone numbers,
dates, procedures, and other information.  You may want to think of the
report as a shopping list.  To help illustrate this example, we will need
to employ what you understand about the selection script.

You and your friends are on a scavenger hunt, and you have money to buy
certain items at different stores.  The items can be anything you wish
them to be, but you cannot pay more than 30 for any one item.  The total
amount of money you have is $10.00.  So, your selection script will be
all items less than or equal to 30 cents, the total of which is less than
or equal to ten dollars.  You and your friends now go out and try to find
items to fit these criteria.  Once found, you then need to put them on a
list.  This list is called the output format.

~Need more information on an output format in the pop-up listing?  Just
highlight the name of that output format and press <Alt-I>.  This will
invoke a pop-up "View Output Format" that shows you the entire output
format for this item.~

What should you put on the output format?  Anything that you wish to know,
as long as it is selectable from the report generator.  In using the above
example of the scavenger hunt, your list might include the name of the
item, the cost, where you found it, and who found it.  That would be
equivalent to the output of a report that you would print.

The same holds true with the report generator output format.  

In using the previous example of finding patients who had a crown on or
before January 1, 1991, you could use the output format seen in
Figure 43.



@Rpt
^Special Keys for Output Formatting


~Function Key        Description~
----------------------------------------------------------------
~<F10> or <F12>~ |   Adds a field.
               |
~<F9>~           |   Edits the currently highlighted field.
               |
~<Tab>~          |   Moves to the next output window.
               |
~<Shift-Tab>~    |   Moves to the previous output window.
               |
~<Esc>~          |   Quit your current action and move 
               |   the cursor to the bottom of the screen.
               |
~<Alt +>~        |   Enlarge the current output window.
               |
~<Alt ->~        |   Shrink the current output window.




@Rpt
^The Output Report

The report output has three sections:

    ~*The header section
    *The listing section
    *The footer section~

Each section has a particular function in the output format.  It is
advisable to construct the listing section first when creating the
output.


~The Listing Section~

The first section you should edit is the listing section.   This is the
largest part of the report, taking up much of the page, although it does
not look very large (Figure 43).   This is because the line in the
listing section is repeated for each item that matches the selection
script.

So, if there are 10 patients who have not had a crown since January 1,
1991, then you will see only 10 lines in the listing section of the
report.

You may choose to have more information to print on the report.
The program limits you to the amount of space on the physical page. 
More detailed reports require you to specify more fields in the listing
section.  You can even stack information in the listing section if you
require more information than will fit on one line.

In the above example there are three items in the listing section.  This
is the output of the report.  

~Item 1~.  This field is patient's last and first name.  Notice how you
can center it under the heading in the header section.  This makes it
easier to read the report.  The same holds true for all other items.

~Item 2~.  This field is for the amount charged for the crown.

~Item 3~.  This field is for the amount of money applied.



~The Header Section~

The next section to be concerned with is the header section.  This
section is for titling each column of data output.  When viewing the
report, it is important to differentiate between the different columns
of data, especially if you keep reports over a period of time.

You should build the header section after creating the listing section.
This way you can line up your headings with the output in the listing
section.  It is the items in the listing section that determines the
width of the information the report generator prints.  To create and
center your header section, type the name of the category, then use the
space bar to center it over the columns in the listing section.  We
recommend you underline each title in the header section to provide a
division between the header and listing sections.

~Be sure to look at the left hand side of the horizontal scroll bar.  You
will notice numbers increasing as you go to the right, and decreasing as
you  go to the left.  This number indicates the spacing on the page.  Using
this number helps you to align your columns on the page.  You may need
to return and edit the header section after printing the first time to
realign the header and listing sections.~

You cannot save blank lines after the last written line in the header
section.  Also, there is no need to type in a title for your report in
the header section.  When it comes time to give the report a name, which
occurs in step three, the program automatically includes it when you
print the report.


~The Footer Section~

The last section to build is the footer section.  This is a section the
report generator prints at the bottom of each page.  You can use the
footer section to print notes at the bottom of the report, or you can
use it to provide totals for numeric categories, such as transactions. 
However, use only number fields that have meaning.  

~Do not try to create a total for provider numbers.  The result will not
make any sense.~

Figure 43 shows how you can calculate totals per page on a monthly
charges for prophies report.

To calculate totals per page, define the appropriate field in the footer
section in the same column as defined in the listing section.  In the
listing section in Figure 43 item #2 is the charge for the prophy, and
item #3 is the amount applied toward that charge.  In the footer section
item #1 is the charge for the crown, and item #2 is the amount applied
toward that charge. Because you define the same field in the same column
in both the footer and listing sections, the report generator calculates
the total for the page, and prints the appropriate totals in the footer
section at the time of printing.     

~The numbers between the brackets "[]" correspond only to the item number
in that particular section (Figure 43).  They do not need to match with
the same item number in any of the other sections~


@Rpt
^Sorting

Once you have completed all sections, you are ready to decide how to
sort your report.  For organizational purposes you should have your
information sorted to aid in finding entries faster when reading the
report.  You can have up to nine fields sorted on the report. 
Generally, you will only need to sort on one or two fields.  Figure 44
is an example of a sort order. 

~Ascending order is the order from A-Z or 1-10.  Descending is the
reverse order, from Z-A or 10-1.  Most reports will go in ascending
order; however, there may be times when you need a report in reversed
order.~

The sorting order goes from field #1 to field #9, with field #1 taking
precedence, field #2 the second field to sort on, and on until you
include all nine fields, if you use all nine fields.  The report
generator sorts only on the actual number of fields specified.  For
instance, you sort your report by patient number.  Then field #1 will
say Patient Number.  However, if you decide to sort on Last Name as
field #1, and First Name as field #2, then the program finds the correct
alphabetical sequence for last names in field #1.  If there is more than
one same last name, then field #2, first name, is then sorted.  

To illustrate, look at the following list of names:   

    ~Brown, Bruce
    Smith, Helen
    Smith, Carmen
    Brown, Gary
    Jones, Dwight
    Anderson, Harry
    Houdini, Harry
    Wheeler, Jennifer~

Given the last name is field #1, and the first name is field #2, then
the program sorts this list of names in this order:

~Ascending           Descending~
--------------------------------------
Field #1 | Field #2 | Field #1 | Field #2 
--------------------------------------
Anderson   Harrry   | Wheeler   Jennifer 
Brown      Bruce    | Smith     Helen 
Brown      Gary     | Smith     Carmen 
Houdini    Harry    | Jones     Dwight 
Jones      Dwight   | Houdini   Harry 
Smith      Carmen   | Brown     Gary 
Smith      Helen    | Brown     Bruce 
Wheeler    Jennifer | Anderson  Harry 



@Rpt
^Sorting Duplicates

The report generator gives you the ability to filter out duplicate
entries on your report.  This is desirable if your report is seeking
information that may have multiple entries, such as treatments or
payments.  Sorting occurs only on the first field.  If you enter more
than one field to sort on, and choose to sort duplicates, all fields,
except field #1, disappear. 


@Rpt
^Post Card and Label Output Types

You can edit post cards and labels in the same way.  The differences
are:

    ~*The size of the output area provided.  Labels are much smaller than
    post cards.

    *There is not a header and footer section for these output types. You
    must specify the size of the card or label before creating the output
    format.~

After selecting this, the program presents you with a single Output
Window.  This window resembles one of the Output Windows described in
the Report section.  Type whatever you like for text, and use <F10> and
<F9>, as described in the Command Table, to add or edit data fields.



@Rpt
^ASCII Export (Spreadsheet and Mail Merge)

Both of these formats produce identical results.  The program gives you
them separately for convenience should you want spreadsheet information
to go to one directory and mail merge to another.  Many programs will
need to know what kind of file to read.  The export file is an ASCII
text file.  Fields are TAB delimited, and records are CR/LF (carriage
return/line feed) delimited (sometimes just CR is enough).  However,
most spreadsheets are able to read the information immediately without
needing any conversion.



@Rpt
^Building The Output Format

Select 1.  Create/Modify A Report.
Choose the area from which you need the report.
Choose 2.  Create/Edit Output Formats.

You will see existing output formats.  

Press <Ins> to add a new output format.
Select Layout.

~To move from section to section in the Listing output, press <Tab> or
<Shift-Tab>.~
 
The program displays a listing of output types.

Select the output type you wish to use.

If you choose to create a listing, we recommend you start in the Listing
Section first, then the Header Section.  Otherwise, all other outputs
are only the Listing Section.

Enter and format your fields.
You may type words in any of the output sections.  The words appear on
the report just as you typed them.
When you have finished formatting your output format, press <Esc>.
With the cursor at the bottom of the screen, press <Enter>.
Select Sort.

If you wish to sort your output by name, date, age, or by some other
means, you need to select sort; otherwise, you can skip this step.

You normally will sort on one or two fields, although you may sort on
more.  This would only be necessary if there were many similar items on
the report.

Enter the number of fields to sort.
Highlight the appropriate fields to sort on, and press <Enter>.
Choose either ascending or descending order.
If you wish to filter out duplicate entries, indicate "Yes."

The program sorts duplicate entries on field #1 only.  This prevents
duplicate information from printing multiple times on your report.  For
example, if you want a report of people who had a particular treatment
during the current year, if the person had this treatment multiple times
you do not want to print each treatment on the report.  All you want to
know is if they had at least one performed.

Press <Enter> to return to the previous screen.
Press <Esc> to prompt to save the changes.
Press <Enter> to save changes.

If you are not editing an output, the program prompts you to name your
output.  This is not the name of the report.

Enter a name for your output.



@Rpt
^Changing the Output's Name

If you misspelled a word when creating the name for the output format,
or you wish to change the name, when creating your output:

Select "Change Name."
Type in the new name for your output.
When finished, press <Enter>.
When the program returns you to the previous screen, press <Esc>.
Save your changes.



@Rpt
^Creating The Report

We finally come to the point where we put the actual report together. 
So far, we have created pieces of a report:  the selection script and
the output format.  You need to think of the selection script and the
output format as modular, much like today's electronics.  You can take
out each piece, and replace it with another piece so the electronic
equipment functions.  The same holds true with the report generator. 
Each step is just a piece in the process of building a report.  Each
piece is separate from one another, but combined with other pieces you
can shape the final output--the report.

~Need more information on a report in the pop-up listing?  Highlight the
name of that report and press <Alt-I>.  This will invoke a pop-up "View
Report" that shows you the entire selection script and output format for
this item.~

For example, you may create many selection scripts that look for
patients who had a crown before a certain date, patients that are a
certain age, and patients who joined your practice between 1980 and
1990.  However, each of the outputs will contain the patient's name,
address, and home phone number.  So, why create more than one output
format?  You do not need to.  That is what makes the report generator so
flexible.  You can mix and match selection scripts and output formats to
achieve results that can be quite surprising.  Or, you may have one
selection script you can apply to several output formats:  one for
labels, one for post cards, one for reports.  

~If you chose a data object that has had no reports created for it, the
menu shown in Figure 46 will not appear.  Instead, the report editor
will appear.~

When putting together the actual report, you are combining a selection
script and an output format together to form the actual report.  As seen
in Figure 46, the program displays a list of available selection
scripts.  You can use only those scripts found on this list.  If the
selection script you wish to use is not on this list, you need to create
it.

~The key to matching a specific selection script to a specific output
format is to name both the selection script and the output format the
same name.~

Once you choose a selection script, you need to match it to an output
format (Figure 47).  You can match it to a specific selection script, or
you may choose to create a different report by taking an existing
selection script and matching it with a different output format.  This
is how you can use the same selection script for both a report and a
label.  With this type of flexibility you can quickly and easily take
the parts of the reports you like and use them to create new reports
without starting from scratch.

To create a report:

Select 3.  Create/Edit Reports.
Select the appropriate output format.
Press <Ins> to create a new report.

Figure 46 will appear. 

Choose the appropriate selection script.

After choosing the selection script, Figure 47 appears.

Next, choose the appropriate output format.

Figure 48 indicates both the selection script and output format that you
have chosen.  If any of these are incorrect, press ~<Tab>~ to change them.

Press <Enter> to continue.
Press <Enter> to save changes.
Give your new report a sensible name, one that you can easily recognize
from other reports. 



@Rpt
^Editing a Report

The process of editing a report is very similar to creating a report. 
When editing a report, you are not changing anything in the selection
script or the output format, but you are matching different scripts and
output formats together.

To edit a report:

Select 3.  Create/Edit Reports.
Select the appropriate output format.
Highlight the report you wish to edit, then press <Enter>.

Figure 46 will appear.

Choose the appropriate selection script.

Figure 47 will appear.

Next, choose the appropriate output format.

Check Figure 48 to be sure you have chosen the correct selection script
and output format.

Press <Enter> to continue.
Press <Enter> to save changes.



@Rpt
^Renaming a Report

Select 3.  Create/Edit Reports.
Select the appropriate output format.
Highlight the report you wish to rename, then press <Enter>.

Figure 46 will appear.

Press <Enter> on the current selection script and output format
selections.

Figure 48 will appear on the screen.  

Press N to change the name of the report.
Type in the name you wish to use.
Save your changes.




@Rpt
^Printing Reports

Select 2.  Run a Report.

You can run a report from virtually any main menu in Easy Dental Plus by
typing ~RUN~.  You may also run reports from Patient Menu, option #8.

A listing of data objects will appear.  This is the same list as seen in
Figure 36 on page 3-3.

Select the data object the report is under.
Choose the output type.

A listing of reports for the data object and output type will appear.  

Select the report you wish to run.

Most reports present a screen of questions you need to answer.  Make
sure you answer all the questions that appear on the screen when you run
a report.  Particular question types will have default values:

    ~*Questions with beginning or ending numbers default to 0 and 99999.
    *Questions that ask for one value default to 0.
    *Date questions will default to January 1 of the current year.
    *Questions that ask for names, phone numbers, and zip codes match all
    names if you do not specify a name or number.~

~These questions come from the variable names that are a part of the
selection script.  If you do not have any variables in your selection
script, then the program does not ask any questions before running the
report.~

The program scans all records to find which ones match the fields
specified in the selection script, and then sort the results, if you
specified sorting.  After sorting, the program displays the report.

Press <Enter> to print the report.

If printing labels or cards, when printing to a dot-matrix printer the
program prompts you for a lineup.  Once you perform the lineup, the
printing process begins.

If the output is either a Spreadsheet ASCII Export or an ASCII
MailMerge, the program displays the prompt seen in Figure 49.  The path
shown comes from your own system's customization.

~The program displays only listing output results on the screen.  The
program does not display ASCII export and MailMerge, labels, or postcard
information.~

Enter the file name that you wish to export to.

~To customize your file paths for your ASCII exports, refer to
File Path Settings.

Press <Enter>.

We suggest you end your file name with .TXT or .ASC in order to
differentiate the output file you are about to create from other files
in that directory.

If the file name you specify already exists, you may overwrite the file. 
If, however, you need to keep the data already in that file, leave the
selection at "No."  You will have to reselect the report and provide a
different file name.

When the report has finished printing, press <Esc>.

The program prompts you to view the summary page.  This is a short
report that lists the number of items matched, and the questions asked
on the report, if any.

~Only Listings have a summary page.  All other outputs formats do not
have a summary page.~

Press <Enter> to view the summary page.


@Rpt
^Post Card Settings

~Lines Per Post Card.~  You may use any post card that will print in your
dot-matrix printer.  To do so, you must set the appropriate lines per
card.  Six vertical lines are equal to 1" on the card.  Since most
dot-matrix post cards are 3-2/3" x 6," you multiply 3 (inches) by 6
(lines) to get 22 lines. 

~Left Margin of Post Cards.~  You have the option of setting a left margin
for your post card.  Since the standard print size is ten characters per
inch, a value of 5 will set a half-inch left margin.   

~Right Margin of Post Cards.~  You may also set your post card's right
margin.  A 3-2/3" x 6" card will give you a 60 character width.  If you
wish to allow for a half-inch margin here, also, you should make this
55. 


@Rpt
^Label Settings

~Lines Per Mailing Label.~  Most mailing labels have 1" between the tops
of mailing labels, although the actual vertical measure advertised will
be 15/16"--the extra sixteenth of an inch is made up in the gap between
labels.  Six lines per inch means a 6 for this field.

~Columns Per Page of Labels.~  Easy Dental Plus will print multiple
columns for labels on laser printers.  Simply enter the number of
columns.  This is almost always two, but there are three column sheets
available for 8" x 11" label sheets.

~Left Margin of Labels.~  You should keep the left margins for your labels
at a minimum.  A value of 1 allows for a slight space from the left
margin.

~Right Margin of Labels.~  Measure your labels and convert that size to
characters by allowing for ten characters to the inch.  Most labels are
4" wide, so this results in 40 characters.  If you allow for a one
character right margin, this becomes 39. 


@Rpt
^Text Answers Settings

~Text for Yes/No Answers.~  This is the default text for yes and no
answers.  While Yes and No certainly do the job, you may prefer TRUE and
FALSE to appear, or perhaps XXX for yes and spaces for no.



@Rpt
^Setting General Report Generator Options

Select 3.  Set General Report Options.

The screen as seen in Figure 51 on page 3-33 appears.

Press <Tab> to move to the number item you wish to alter.
Make your changes.
Press <Esc> to move the cursor to the bottom of the screen.
Press <Enter> to continue.
Save your changes.



@Rpt
^File Path Settings

~File Path for Spreadsheet/Mail Merge.~  Two of your options for the
report output deal with creating ASCII Export files.  While both may
produce identical output, the purpose behind having two options is that
you can indicate different directories for that output.  If you plan on
exporting to a spreadsheet, or creating a mail merge file, put in the
appropriate directory to save that information in.  For example, if you
use Excel for your spreadsheet and Ami Pro for your word processing, you
might specify the paths shown in Figure 52.



@Rpt
^Field/Record Delimiters

You may choose the field and record delimiters that best fit your word
processing software.  As seen in Figure 52, Easy Dental Plus defaults to
Tab delimited fields, with CR/LF as the record delimiter.  You may
choose from any of the following:   

~Field/Record Separators/Characters~

    Tab
    LF (line feed)
    FF (form feed)
    CR (carriage return)
    Esc (escape)
    ' (single quote)
    , (comma)
    " (double quote)

~Field separators are one character in length.  Record separators are
usually two characters in length.~



@Rpt
^Setting Report Export Options

Select 4.  Set Report Export Options.

You will see the screen shown in Figure 52.  The program positions the
cursor at the Spreadsheet ASCII Export field.

Enter the path for your Spreadsheet ASCII Export files, or press <Tab>
to move to the next field.

When you tab to any of the field/record delimiter fields, the screen
shown in Figure 53 appears.

Using your arrow keys, select the field/record delimiter that is used by
your word processing software.
Press <Enter> to accept your choice.

If you make an incorrect choice, use your arrow keys to highlight the
correct choice, and press <Enter> again.

Select the choice Done when you have chosen the correct field/record
delimiter.
Press <Enter>.
Continue the above steps for fields 1b through 1d.

After you have selected the delimiters for the Record Separator
Character(s) field, the next field queries you if you wish to trim the
end spaces from your output fields.  Each output field has a certain
number of characters that make up the field.  Many times the field has a
number of blanks (spaces) at the end of the output field.  This can
cause blanks (spaces) to print on your reports, creating spacing
problems.  You may elect to eliminate these spaces by indicating "Yes"
to Trim Spaces in Output.

When asked "Trim Spaces in Output," press Y <Enter> for "Yes," N <Enter>
for "No," or use your arrow keys to toggle between "Yes" and "No."
Continue the above steps for the remaining fields.
When prompted "Press <Enter> to Continue," press <Enter>.
Save your changes.


@Rpt
^Easy Report Maker

The Easy Report Maker is an additional tool that you can use to
generate custom Easy Dental Plus reports.  The beauty of the
report maker is its simplicity.  Many of the normal report
generator functions are done automatically for you.  All you
need to do is make a few simple decisions during the creation
process.



@Rpt
^Creating a report using Easy Report Maker

From the Report Generator menu select 1.  Easy Report Maker.

You will see a listing of areas from which to create a report. 
These areas are the most commonly used, and include:

~*Patients
*Coverages/Employers
*Insurance Companies
*Inventory Items
*Providers
*Referring Doctors~

If you do not see this list, skip to step 2.
If you select All, then skip to step 4.
Using the arrow keys, select which area to create a report from.

You will now see ~Step 1a~, only if you select Patients from the
previous list.  This step allows you to see the following list
of data objects to gather your information from:

~*Certain Transactions Entered (Current)
*Certain Transactions Entered (History)
*Certain Lab Work
*Certain Drugs Prescribed
*Certain Planned Treatments
*Certain Outstanding Claims
*Certain Information Saved~

Selected the data object you wish to gather information about.

The program displays ~Step 2~ on the screen.  It will now ask you
if you wish to select All from the data object, or Selected
items from the data object.

Select the data object that best fits the type of report you
wish to create.

~Step 3~ is displayed on the screen if you selected to gather
Selected items for the report.  On this screen you will see a
variety of data fields to select from when creating the report. 
This step is the exact same step you would perform when creating
a regular report generator report.

Using your arrow keys, highlight the field you wish to add to
the selection script.
Press <Enter>.

You will then need to decide what relationship to give this
item.  The relationships you may choose from are:

~Equal To
Not Equal To
Less Than
Greater Than
Less Than or Equal To
Greater Than or Equal To~

For example, if you are creating a report that includes
information only for a particular insurance company, then the
relationship you would choose would be "equal to."  If, however,
you are looking for information for transactions that occurred
after January 1, 1994, then you would use the  "greater than"
relationship.

Next, enter a value for the data field.

This step asks that you indicate to the report generator what to
look for.  If you are looking for a certain insurance company,
then you would place that insurance company number here (Figure
63).

If you wish to make the report more flexible, then press <Alt-V>
to create a variable.  A variable is a value that you supply at
the time of generating the report, not at the time of creating a
report.  This means that if you are creating a report for a
certain insurance company, you can enter any insurance number at
the time of generating the report.  This will keep you from
creating a special report for each insurance company.

If creating a variable, press <Alt-V>.
Type in the name of the variable.

If you wish to use a range variable, then you will press
<Alt-R>.  This allows you to enter, at the time of generating a
report, a number range (low and high).  The report generator
will then create a separate report for each of the numbers entered.  For
example, if the report is about certain insurance companies, if you create
a range variable, at the time of generating the report you will be
prompted to enter a starting and ending number.  If you enter 5
and 15 for the low and high numbers, you will get a report for
insurance company #5, a separate report for #6, another separate
report for #7, and so on until you reach #15.

If you wish to use a range variable, press <Alt-R>.
Enter the variable name.

You will next see a screen that gives you three choices: 

~*Need to find more choices,
*Need to find fewer choices,
*The selection script is fine as it is.~

All this means is that the program is allowing you to select
more data fields to include in your selection script.  You can
either do so, or accept the selection script as it is.

Once the selection script is as you wish it to be, select 3.  Is
OK.

You may see Step ~3b~.  This step allows you further define the
information on the report.  Your choices will vary according to
previous selections.

If you are in Step 3b, select restrictions you would like to
include for the report.

~Step 4~ now appears on the screen.  You will now be asked to
provide sorting information.  This is the order of items on the
page of the report.  You may add to or eliminate fields from the
sort order at this point, or accept the default values presented.

Select the sort order you wish to use on the report.
When prompted "Press <Enter> to Continue, or <Tab> to change an
item," press <Enter>.

~Step 5~ allows you to name the report (Figure 64).  This is the
name that you search for when you are ready to generate and
print the report.  Be sure to select a name that has meaning to
the report.

You will also notice in the background a layout for the report. 
This is the default layout.  You cannot change this.  

Enter the name of the report.
Save your report.

~Step 6~ now appears on the screen (Figure 65).  Here can make one
of four choices:

~*Print Instructions for running the report, then run the report,
*Print only the instructions,  
*Skip printing the instructions and just run the report,
*Return to the report generator menu.~

Select the option you wish to use.

If selecting "Print Instructions Only," or "Print Instructions
and run report," you will be asked to select the printer to
print to.  

If selecting to "Run the report," the program gathers the report
information, formats it, and displays it on the screen.  Press
<Enter> to print the report.



