@Rec
^How Recall Works

In order to utilize the Easy Dental Plus recall process to its fullest, an
explanation is in order.  You should place all active patients on recall
so you can continually keep patients on their appropriate recall
schedules.  Whenever a patient comes into the office, you should update
his next recall date to keep the recall process running smoothly.

Close to the end of each month, you should select the Recall Menu and run
Automatic Recall Processing for the next month.  That is, if it is now
March 25, you would run recall processing for April.  The program will
first print a listing of all patients expected for April, then print
recall labels or post cards if requested.  Anyone who misses their
appointment in April will print again on the May recall list.  Any patient
that keeps their April appointment, the recall process will give him
a future recall date.




@Rec
^Recall and Aging

The aging of a patient's recall is an automated process that is invisible
to you.  The program "ages" for next month any patient who misses their
recall during the present month.  What essentially happens is that a
patient has a recall level of 1.  When they miss their recall date, Easy
Dental Plus "ages" the patient.  They then become a 2.  This process
continues until the patient reaches the highest possible recall level,
after which the system resets their recall level to 1 again.


~A Detailed Recall Example~

John Q. Public is a new patient who came in for his first visit on
February 2, 1994, and you determined that he should return in three
months.  You enter the treatment into the computer and set up his next
recall for May 1994.

April 20 rolls around, and you run Automatic Recall Processing. The Master
Recall Report lists John as expected in May, and in the "#" column of the
report (Number of times scheduled for recall), the number "1" appears. 
This means this is the month you originally scheduled him to return for
his recall appointment.  If John comes in during May as scheduled, you
enter treatment on him and reschedule him for his next appointment, if
any.  After rescheduling, of course, he will not appear on the June recall
report.

However, let us say that John does not come in during May.  At the end of
the month you print the June Master Recall Report.  John once again
appears on a recall report, but this time he has a "2" in the "#" column. 
This means that he has missed his original recall date.  If he then fails
to come in during June, he will show up on the July report as a "3."  So,
you can see how this system will even remind infrequent patients that they
need to come in for a visit.



@Rec
^Setting Recall Options

Setting your recall options is the first step in customizing recall for
your particular practice.  The options are flexible so that you can
customize recall to fit your office procedures and needs.  There are three
customization options you will need to alter to fit your specific needs: 
mail formatting and sorting, recall cycle, and formatting your recall
postcard.


~Mail Format/Sort Options~

Before you begin your recall processing, you need to set your options. 
These options will make a difference in the appearance and sorting of your
master recall lists, postcards, and labels.  Your options also influence
how often the recall program reminds the patient of missed recall
appointments, or if you have left certain patients out of the recall
process.


~Mailing Format during Automatic Recall~.   

Automatic Recall Processing uses the mailing format you select here. 
After Automatic Recall Processing prints the master listing, it will
either print mailing labels, print post cards, or skip the mailing and
proceed to the next step, depending on how you answer this question.

~Print Blank Lines Between Each Patient's Listing on Master Recall
Report~.  If you answer "Yes," then the recall program prints a large
blank line between every patient listed on the Master Recall Report.  This
gives you room to write on the report between the listed patients.  

~Select Order to Print (All Formats)~.   Recall printing uses the order
you select here:  the Master Recall Report, Mailing Labels, Post Cards,
and Patients Not on Future Recall.  Here is an explanation of each choice:

     ~Recall Number Order~.  This sorting option is useful if you use
     different recall post cards, depending on whether a patient's recall
     is 1, 2, 3, or greater.  It is also useful if you use different
     recall cards for those patients scheduled for an exact time--these
     patients know exactly when to come in for their appointments, and
     those who do not have an exact time--these people need to call and
     make an appointment.  The recall printing order is:

          Recall #1's with an exact time
          Recall #1's without an exact time, 
          Recall #2's, #3's, and greater.  

     Note:  The program sorts the patients alphabetically within each
     group.

     ~Zip Code Order~.  This is for practices that use bulk mailing for
     their recall cards or labels.  It will sort your recall printing by
     the patients' zip codes.  The program sorts the patients
     alphabetically within each zip code group. 

     ~Alphabetical Order~.  The program sorts all printing alphabetically.

     ~Billing Number Order~.  This is useful in determining if multiple
     members of the same family are being mailed recall cards.  The
     program sorts all printing by the number of each patient's
     responsible party.

     ~Patient Number Order~.  No sorting will take place.

     ~Date Sort Order~.  The program sorts your printing by date order.

NOTE:  When printing all formats, do you wish to print all Recall
Numbers.  This question divides into three additional questions, depending
upon how you answer the main question.  If you do not want to print all
recall numbers, this question displays three additional questions:

     ~Print #1's?
     Print #2's?
     Print #3's and greater?~

If you answer the main question "Yes," then the program prints
all recall numbers, and does not display the additional questions.

~Pause Between Recall #1's and #2's, and #2's and #3's when printing Post
Cards~.  The program displays this question only if you select the print
order as Recall Number Order.  This question affects only Post Cards.  If
you select "Yes," whenever you print post cards the program pauses for
every new recall number that it must printup to number 3and further
divides Recall #1 into those patients who have an exact recall time and
those who do not.  That is, it will prompt:

     ~"Ready to Print Recall #1 w/Time"
     "Ready to Print Recall #1 w/out Time"
     "Ready to Print Recall #2" 
     "Ready to Print Recall #3+."~

~Print recall comments for Each Patient on the Master Recall Report~. This
option allows you to include a patient's recall comments on the master
recall list.  This prints the usual recall information, and includes
beneath each patient's name a recall code with the corresponding comment. 
The program includes all comments for the patient.  

                      
~Recall Cycle Options~

When you receive your Easy Dental Plus System, the recall system works
this way:  If a patient does not come in for his scheduled recall, the
recall program ages him forward one month to a recall #2.  If he still
does not come in, the program again ages him forward to #3.  If, after the
third month he still does not come in, the program ages him six months and
the patient's status becomes a recall #1 again.  This cycle can be altered
to your liking by changing the various recall cycle options.

~Use Automatic Aging of Recall~.  You may specify whether or not you want
to age your patients automatically.  To use automatic aging set this
option to "Yes."  After indicating "Yes" to automatic aging you will need
to set options 2-4, which affect the recall cycle.  

NOTE:  Running your recall reports will not affect the aging of your
patients.  Even if you do not run any reports, the recall program ages
your patients for the next recall cycle. You may also run your recall
reports at any time of the month and as often as you like.  

NOTE:  If you set your automatic aging to "No," the program will not
automatically age your patients in the recall cycle.  There is no manual
method of aging patients if you set this option to "No."  If you do not
use the recall module, then this is fine.  However, if you do want to use
the recall module you must change this option to "Yes" if aging is to
occur.

Also, if set to "No" items 2-4 will not apply to recall.  You may,
however, run your recall reports to get a listing of the patients that
have a scheduled recall date during the current month.  When a patient
comes in for his recall appointment, or you change his recall date before
you print the listing,  he will not appear on the list.  You could then
use this listing as a method of tracking patients who did not show for the
scheduled recall appointments for the current month.  

If you set the automatic aging of recall to "No" to get a listing of only
those patients due in for recall #1 during the current month, do not
forget to change this back to "Yes."  The following example explains:

Mary Anderson is due for recall in the month of January.  She shows up on
January's master recall list.  However, Mary did not come in for her
prophy in January.  Since you turned off automatic aging, Mary does not
show up on the February report. The receptionist thinks that is fine,
because in six months Mary Anderson will be a #1 again.  Yet, since Mary
Anderson does not have an actual recall date for June, she does not show
up on the master recall list, and will not show up on the list until you
change the automatic aging of recall to "Yes."

~Number of Months Per Recall Cycle~.  Since recall ages the patient
forward several months after Recall #3, we say that the Number of Months
Per Recall Cycle is 3.  If you want a patient to go to Recall #4 before
being aged forward more than one month, change this item to 4.

~Number of months Between Cycles~.  Since recall ages a patient forward
six months after reaching the end of a recall cycle, the actual Number of
Months Between Cycles is 5.  A patient is normally aged one month who does
not show up for their recall.  This item indicates to age the patient
forward 5 extra months. If, for example, you want to age the patient only
three months when he reaches the end of a recall cycle, change this to 2.

~Highest Count Before Restarting~.  In our current example, recall sets a
patient to #1 again after six months, we say that the Highest Count Before
Restarting is 3that is, after being a #3, he restarts as a #1.  However,
it may be useful for a patient reappearing on your recall list after six
months to be a #4, rather than a #1 again.  To do this, change Highest
Count Before Restarting to 6, 9, or even 15. 


~Post Card Options~

~Recall message~.  When you access the post card options (Figure 46), the
program positions the cursor beneath the return address.  You may enter
your own custom recall message here, up to two lines of 40 characters
each.  This message prints only when an exact recall date and time are
stored for the patient.  Pressing <F9> in this field enters a place holder
for the recall date.  <F10> enters a place holder for the recall time.

~Enter the height (in lines) of your post cards~.  Since many post cards
are 3" high, and dot matrix printers print 6 lines per inch, you would set
this to 18.  If you have recall post cards that are not this size, measure
one of the cards, in inches, and multiply the result by 6 to get the
number of lines. 

~Number of spaces to tab for Patient's Address~.  Normally the
printer will tab over to the 15th column of a post card to start
printing the patient's address.  If the width of your post cards
do not permit this, you can change this item.  

~Do you want to print Date and Time~.  If you want the patient's Recall
Date and Time printed on the recall card, indicate "Yes." The message
printed will not be the same for all recall patients since it depends on
the patient's recall date and time.

NOTE:  If the patient has an exact Date and Time, the program prints the
message you customize.  If you do not customize a message, then no message
prints on the recall card.

If the patient has an exact Date, but no Time:

     ~Your next visit is due on 12-13-93.
     Please call for an appointment.~

If the patient has no date but the month and year:

     ~Please call for an appointment.~

~Do you want the return address printed~.  Many practices order recall
cards with their names pre-printed on them.  If you have such cards, just
answer "No" to this question.  If your cards do not have the return
address pre-printed, select "Yes."

~Number of spaces to tab for Return Address~.  This item only appears if
you want a return address.  Normally the printer will start printing your
practice's return address at the very first column of the post card. 
However, if you have information pre-printed on the left part of your
card, you will want to change where your return address prints. 

~Printing a sample card~.  You may print a sample postcard to insure that
the postcard setup is appropriate.  You may reprint the sample as many
times as you wish.  Once done, you can then save your setup.  



@Rec
^Recall Print Options

~Print One Recall Card Per Family.~  If you have multiple family
members that have recall appointments during the same month, you
may choose to send just one recall card/label for the family. 
This will save time printing your recall cards/labels, as well
as postage.

~This option affects only recall cards and labels.~

~Print Recall by Preferred Provider.~  For multi-provider
practices, you may print a particular provider's recall
information.  This allows you to keep each provider's recall
printing separate from one another.

~This option also affects all reports, cards, and labels printed
through the recall menu.~

~Print Patients Without Recall Dates/Times.~  This option allows
you to focus your recall on patients who do not have a recall
appointment; specifically, the patient does not have a specific
date or time for their recall.  

By setting this option to "Yes," you can print recall cards,
labels, and a master listing for only those patients who do not
have a set date and time.



@Rec
^Recipient List

When printing recall cards and labels, you have the option to
view and/or print a recipient list.  This list contains:

~*patient name
*patient number
*current recall number
*last prophy date
*recall frequency and cleaning time
*current recall date and time~



@Rec
^Recipient List Functions

While viewing the recipient list you may perform any of the
following actions:

~*Insert a patient into the list by pressing <Ins>.~

The patient you insert must be a responsible party.

~*Delete a patient from the list by pressing <Del>.
*Print the recipient listing by pressing P.~



@Rec
^Automatic Recall Processing

For your regular monthly recall processing, we recommend that you always
choose option #1 from the recall menu.  Choosing option #1 causes the
recall module to perform all of the necessary steps for complete recall
processing each month automatically.



@Rec
^Print Monthly Master Recall Report

If run directly from the Recall Menu, you will first be asked for the
month and year of the recall list.  Then, the program will scan the
patient list for everyone on recall for the indicated month and year.  You
can include patient recall comments on the master recall report.  If there
are no patients on recall for that month, then a pop-up message will
inform you of that, and returns you directly to the Recall Menu;
otherwise, you will receive your master recall reports.

Important:  If you press <Esc> while in Automatic Recall Processing, then
the recall processing will stop and you will return directly to the Recall
Menu.

The recall process shows two reports.  The first report is the Prophy
Recall Master List, and the second is the Dental Recall Master List.  Each
list includes appropriate personal and recall information for each
patient.

It is possible to view just one report without the other, if you so
desire.  When the program prompts you to "Align Paper & Turn On Printer,"
press <Esc> to not print that report.  The program then prints a summary
page with the report, indicating how many patients are on recall for each
provider.



@Rec
^Print Labels For Recall Cards

You can print recall labels for your recall cards anytime during the
month.  The mail format/sort options will affect whether your recall
labels will print the current #1's, 2's, or 3's and higher.  Be sure to
have that set properly before printing your recall labels.

The program will print one label for each patient listed on the recall
master list.  If the patient is on both the prophy and dental master
lists, the program prints two labels for them.  Found on the label is a
recall code number.  ~P~ is the code for prophy recall, and ~D~ is the
code for dental recall.  The number following the code letter is the
recall level for the patient.  For example, John Q. Public has a ~P1~ code
on his prophy label.  This indicates he is receiving his first reminder. 
If he has a ~P2~, he is receiving his second reminder.

~Select the month and year~.  This option allows you to select which month
and year you wish to use to select the patients due for recall.  The 
month and year selected determines whether or not the program prints a
patient label.   

~Starting Patient Number~.  This is the first patient you wish to print a
label for.  The default value for this is 1.  

~Ending Patient Number~.  This is the last patient you wish to print a
label for.  The default value is the last patient number assigned by the
program.

~Show Prophy/Dental Recall Recipient List~.  These two fields indicate
which patients the program will print a recall label for.  This listing is
the same as shown when printing monthly statements or letters.  You may
add or delete patients to this list as long as you set the patient's On
Recall flag to "Yes." 

To print recall labels:

Select 3.  Print Labels For Recall Cards. 
Using your arrow keys change the month and year to the desired date.
(Using <PgDn> advances the month by six months.  <PgUp> decreases the
month by six months.
Enter the starting patient number, then press <Enter>. 
Enter the ending patient number, then press <Enter>. 
If you wish to change the status of the recipient listing for prophy
recall, use your arrow keys to change the status.  Press <Enter>. 
If you wish to change the status of the recipient listing for dental
recall, use your arrow keys to change the status.  Press <Enter>. 
Save your changes.

A recipient listing for either prophy or dental recall will appear, if
either were selected to appear.

If you wish to edit the listing:

Press <Ins> to add a recall patient to the list, or highlight a patient
you wish to delete from the list.
Press <Del> to remove the patient from the list.
Press <Enter> to move the next dental recipient listing, if set to show. 
If not, you will begin printing labels. 
Repeat this process for the dental recall recipient list, if applicable. 

Before printing you will need to perform a lineup, after which your labels
will print.



@Rec
^Print Recall Post Cards

The process of printing recall post cards is identical to printing recall
labels.  The only difference is the format--the post card itself.  Be sure
to set your post card settings before printing recall post cards.

Figure 48 shows a sample recall card.  You can include a message on the
recall card to indicate when their prophy is due. However, the date does
not mean that the patient has a scheduled appointment for that day.  This
means that the date indicated is six months (or the set recall frequency)
from the last time they came in for prophy treatment.

To print a recall postcard:

Select 4.  Print Recall Post Cards. 

You will now see a screen similar to the one shown in Figure 47.

Using your arrow keys change the month and year to the desired date.
Enter the starting patient number, then press <Enter>. 
Enter the ending patient number, then press <Enter>. 
If you wish to change the status of the recipient listing for prophy
recall, use your arrow keys to change the status.  Press <Enter>. 
If you wish to change the status of the recipient listing for dental
recall, use your arrow keys to change the status.  Press <Enter>. 
Save your changes.

A recipient listing for either prophy or dental recall will appear, if
either were selected to appear.

If you wish to edit the listing:

Press <Ins> to add a recall patient to the list, or highlight a patient
you wish to delete from the list.
Press <Del> to remove the patient from the list. 
Press <Enter> to move the next dental recipient listing, if set to show. 
If not, you will begin printing post cards.

After you edit the recipient listing, if necessary, the program prompts
you for a lineup.  Once performed, the program prints your recall cards.



@Rec
^Patients Not On Recall Report

The Patients Not On Recall report is a listing of patients who do not have
a recall date, but are flagged for recall.  You can print this report at
any time.  It is a good idea to print it at least once every three months. 

NOTE:  The report does not list patients who are Responsible Party Only
and patients who have their On Recall flag set to "No."



