@Glossary
^Practice Management Definitions

Many reports in Easy Dental Plus seem to conflict with one another in
details.  In actuality, there is not a conflict at all.  Each report may
reflect different types of data.  Generally, any type of "conflict"
between reports is due to the differences in collections, production,
and payments.

Following are some definitions that describe the data found in the Easy
Dental Plus practice management reports.

~Allocated~--  Applied to, as in a credit applied to a treatment.

~Charges~--  Treatment performed on a patient greater than $0.00 that
results in production.  A charge may also include a finance charge,
which is non-production.

~Collections~--  Money received that you apply to a patient's treatment.
Any money received that you do not apply to patient treatment Easy
Dental Plus does not consider collections.  Refer to the collections vs
payments example on the following page.

~Credit balance~--  A cash balance in the patient's favor.  This means you
received a payment that is greater than the patient's balance.  The
resulting cash balance is a credit balance.

~Credits~--  Any type of adjustment to a patient's account that reduces
the patient's balance.

~Debits~--  Any type of adjustment to a patient's account that increases
the patient's balance.

~Fees~--  The amount of money charged for a treatment.  The charging of
fees results in production.

~Income~--  Any type of money received.

~Non-production~--  A debit charge that is not a treatment.  A finance
charge is non-production.

~Payments~--  Money received that pays for treatment.  If a payment is
greater than the amount owed, the remaining portion becomes an
unallocated credit balance.

~Production~--  The charging of a fee for treatment.

~Unallocated payment~--  A payment received that did not close out (pay
for) a patient transaction (treatment).



@Provide
^A Collections vs Payments Example

You are the owner of a one patient practice.  Your only patient comes
into your office in January and makes a payment of $1000 for treatment
not yet performed.  Because of the time involved you cannot perform all
of the treatment in January.  So, during the month of January you
perform treatment that is worth $500.  When printing out your monthly
reports, you see that for the month of January you received $1000 in
payments, yet you only received $500 in collections.

In February your patient returns to complete his treatment.  You perform
treatment that is worth $500.  At the end of February you print your
monthly reports and see that your monthly payments equal zero, yet your
collections is $500! 

This short example illustrates the difference between payments and
collections.  A payment is any type of money received, whereas to be
considered collections you must apply the money received (payment) to
treatment (production).  Also, in this example, the collections for
February was $500, even though you did not receive a payment in
February.  That is because the patient had a $500 credit balance.  That
credit balance went to pay off the treatment in February, thus resulting
in collections worth $500.

Collections and production rarely ever match.  This is because
production is for the current month, whereas you can receive collections
for treatment (production) performed in a prior month.  This happens
when you have patients on a contract or payment plan, and they reduce
their balances over a period of time.



@Reports
^Year-To-Date Payment Journal

The Year-To-Date Payment Journal is the only yearly report that you must
print at the end of the calendar year.  When you close the month of
December, you print all the monthly reports at that time.  The only
additional report that you must print during the close year process is
this report.

~This report contains only patient out-of-pocket expenses.  This does not
include insurance payments.~

This report sorts the patient listing by responsible party number, and
contains these items:

    ~*Responsible party number and name.
    *Last payment amount and date.
    *Current family balance.
    *YTD Payments.
    *YTD Finance Charges.~


@Reports
^Report of Month To Date Payments and Credits

During the current accounts receivable month patient transactions occur. 
These include treatment, payments, and account adjustments.  These
transactions appear on daysheets you print on a daily basis.  At the end
of the month you should print the report of Month-To-Date Payments and
Credits as a method of checking the validity of the transactions made
during the current month.  All credit transactions that appear on the
daysheets should appear on this report. 

~You must print this report just before closing the month, which deletes
the report's information.  We strongly suggest that you keep a file of
these reports for as long as necessary for accounting and tax purposes.~

When printing this report, Easy Dental Plus sorts all of the month's
transactions in date sequence.  The report lists every payment and/or
credit you have applied to different accounts since the last time you
closed the month.  The program prints totals for each day, with grand
totals located at the bottom of the report.

~If you are not sure you have closed the month, check this report for any
transactions you may have made during the past accounts receivable
month.~

Before closing the month be sure to check this report against your
daysheets.  If there are any discrepancies between your daysheets and
this report, you may need to reprint a detailed daysheet.  This will
help indicate if you are missing any transactions.

Refer to Close Month or Items to Consider When Closing the Month
for information about the close month process.



@Reports
^Report of Month to Date Charges and Debits

The report of Month-To-Date Charges and Debits lists all patient charges
and other debit adjustments such as finance charges, late payment
charges, and voided transactions.

Concepts that apply to the report of ~Month-To-Date Payments and Credits~
apply also to this report.
   



@Reports
^Practice Demographics Report

The Practice Demographics Report is a report that is not dependent on
the close month process.  You can print this report at any time.

The information contained on this report is: 

    ~*Number of patients and their status.
    *Number of patients who are male versus female.
    *Number of patients who have zero, one, or two coverages.
    *Number of patients due for prophies for a given month.
    *Number of "Yes" answers to specific medical history questions.
    *Number and percentage of patients in a particular age group.
    *Number of patients who reside in a particular zip code.
    *Number of new patients during a particular month.
    *Number of responsible parties turned over for collections.
    *Number of responsible parties on a monthly payment plan.
    *Income generated by referrals.
    *Total finance charges for the year.
    *Number of persons whose birthday is in a particular month.
    *Number of patients per provider.~



@Reports
^Report of Fees Earned by Procedure

The Report of Fees Earned by Procedure contains month-to-date and
year-to-date information about the number of procedures performed, and
the production generated by those procedures.  For complete accuracy,
you should print this report for every fee schedule.     

~Closing the year zeros out the year-to-date data for each procedure.~

The system updates each procedure every time you enter treatment for a
patient.  The system keeps up with the number of times you perform each
procedure during the current month and year, as well as the total fees
charged to patients for each procedure.

Refer to Close Year for information about the close year process.



@Reports
^Report of Standard vs Custom Fee Schedule

The Report of Standard vs Custom Fee Schedule is similar to the
Report of Fees Earned by Procedure.  The difference is that it
is a comparison between two fee schedules, the standard fee
schedule and a fee schedule you specify.

~Like the Report of Fees Earned by Procedure, if you have multiple fee
schedules, Easy Dental Plus asks you if you want the report for the
standard or a custom fee schedule.~

The purpose of this report is to indicate the profitability of a custom
fee schedule versus the standard fee schedule.  You can use this
information to determine if the custom fee schedule generates enough
income to warrant its continued use.



@Reports
^Income by Procedure Analysis Graph

The Income by Procedure Analysis Graph is an ASCII graph that totals all
income from the year-to-date information.  It calculates the percentage
of the total income generated by each procedure, and sorts the procedure
file in procedure code order before printing the report.



@Reports
^Reports of Fees And Collections by Provider

This selection is a broad category for five types of reports: 

    ~*Summary of Production by Provider
    *Detail of Collections by Provider
    *Summary of Production and Collections by Provider
    *Undistributed Payments
    *Collections for Prior Month's Payments~




@Reports
^Summary of Production by Provider

This report lists:

    ~*Provider number and name.
    *Number of procedures performed month-to-date and year-to-date.
    *Total dollar amount of production for each provider.~

~Since closing the month closes out your collection file, it is important
to print the appropriate collection reports before you close the month.~

Refer to Close Month or Items to Consider When Closing the Month
for information about the close month process.




@Reports
^Detail of Collections by Provider

This report lists:

    *Patients seen this month, including the patients' number and name.
    *The date the patient was in for treatment.
    *The type of payment transaction made, either cash, check, or charge.
    *The amount of the payment.

~The program list separately each procedure performed and each payment
received.  The system will then break down the total amount of payments
by cash, check, or charge.~




@Reports
^Summary of Production and Collections by Provider

This report lists each provider you entered into the system, and shows
their month-to-date and year-to-date collections and production figures. 
You should print this report as a part of the close month process.



@Reports
^Undistributed Payments and Collections for Prior Month's Payments

The purpose of these reports is to reconcile your total month-to-date
payments, found in the Report of Month to Date Payments and Credits,
and your total month-to-date collections, found in the
Summary of Production and Collections by Provider.

The Undistributed Payments report prints a listing of all payments that
have not had part or all of their amounts distributed to providers for
collections.  Only payments made this month are figured into the totals
at the end of the second report.  

~This report lists the undistributed payments from prior months as a
reference.~

The Prior Month's Payments report shows all provider collections that
you distributed this month from payments that you received in previous
months.  Since you did not fully distribute these payments in the month
you entered them, collections based on these payments appear in the
current month, even though the payments themselves do not.

~The totals at the end of the second report indicates the relationship
between collection totals and payment totals.~



@Reports
^Report of Referrals & Production By Referring Doctor

The Report of Referrals & Production By Referring Doctor lists the
number of top referring sources that you specify.  This report lists
referring doctors in order of most referred patients.  You may limit the
number of doctors listed by changing the number displayed here.  The
report displays each referring source's phone number along with
appropriate referral information.

~By default, the report will list all referring doctors.~

This report may be inaccurate if one of the following conditions occurs:

    *You did not enter the referral at the time of entering the patient's
    information for the first time.

    *You entered the referral at the time you entered a new patient, but you
    did not save the patient as a new patient.

The first condition does not have a solution.  You must enter the
referral at the time of entering a new patient.  You can remedy the
second condition:

Edit the patient record.
When prompted "Do you want to count this person as a new patient?"
indicate "Yes."

As long as you enter the referral when entering the patient for the
first time, saving the patient as a new patient updates this report.



@Reports
^Reports of Referred Patients

This selection is a broad category for five referral reports:

    ~*List of All Patients Referred by a Specific Patient
    *List of All Patients Referred by a Specific Doctor
    *List of All Patients Referred by All Patients
    *Report of All Patients Referred by All Doctors
    *Report of All Referred Patients~

Each report allows you to either list all referred patients for that
report, or to list only those patients referred since a specific date.

If you wish to list all referrals, enter ~A~.  If you wish to list
patients starting on a selected date, enter ~S~.

If you had chosen either List of all Patients Referred by a Specific
Patient or List of All Patients Referred by a Specific Doctor, you need
to know the referring doctor's name or number, or the referring
patient's name or number.



@Reports
^Report of Current Member Utilization

This report gives you a detailed listing of patients who have made
payments against an open insurance claim.  You can specify either a
single insurance company or all insurance companies.  Included on this
report is: 

    ~*Insurance Company Name
    *Service Date
    *Patient Name
    *Group Number
    *Tooth/Surface
    *ADA Code
    *Description of Service
    *Fee Charged
    *Actual Fee
    *Provider Number
    *Provider Production Summary Information~

To print this report:

Select 11.  Reports of Current Member Utilization.

The screen seen in Figure 91 appears.

Press <Tab> to move the cursor to the first field.
Using your arrow keys, you may toggle between the choices of Single or
All.
If you selected Single, enter the insurance company's name or number.
Specify the beginning and ending dates for the transactions you wish to
include on the report.
When prompted "Please press <ENTER> to accept or <TAB> to modify
selection," press <Enter>.

The program displays the report on the screen.

To print the report:

Press <Enter> while viewing the report.


@PracMan
^System Statistics Inquiry 

Anytime during the month you can get a "ballpark" figure of your
accounts receivable and other important information by viewing
the system statistics inquiry.  You can use this information to
gauge how well your practice is doing in many areas:  

~*The number of referring doctor and patient letters not printed
*The number of transactions for the month
*How many contracts were created
*The number of insurance payments received this month
*If production is ahead or behind collections
*The amount of money in contracts receivable
*The number of new patients this year in comparison to last year~



@PracMan
^Viewing/Printing Statistics

There are three system statistic screens to view.  The ~first
screen~ of the statistics inquiry contains general figures of how
many items exist, the number of referral letters not printed,
and when you last closed the month and year.  

The ~second screen~ reflects your current accounts receivable
balance, including figures for the patient charges, account
adjustments, payments received, and contracts.  

You may view last month's System Statistics by pressing ~P~,
and the YTD statistics by pressing ~Y~.  Refer to
Viewing/Printing Last Month's Statistics for information on
these functions.

The ~third screen~ relates new patients for the current year vs
last year.  The anniversary date of the patient dictates what
month the patient is listed under.  This means that close month
does not affect the month the patient is listed as a new
patient.  An incorrect system date can affect this screen
adversely.



@PracMan
^Viewing/Printing Last Month's Statistics


Easy Dental Plus saves the prior Accounts Receivable totals for
you to review and compare during the current month.  This is
helpful if you wish to compare last month's totals to this
month's.  This is also helpful in the event you failed to print
all of your reports from last month.


To view last month's statistics:

Select 12. System Statistics Inquiry.
Press <Tab> to move to the second screen.
Press P to view the prior month's information.


To print last month's statistics:

While viewing last month's statistics, press <Enter>.




@PracMan
^Viewing/Printing YTD Totals

The System Statistics Inquiry also allows you to view and print
Year-To-Date figures for your practice.

Select 12. System Statistics Inquiry.
Press <Tab> to move to the second screen, as seen in Figure 15.
Press Y to view the prior month's information.


~To print YTD statistics:~

While viewing YTD statistics, press <Enter>.



@PracMan
^Graphs

Easy Dental Plus includes graphical displays to give you a ready
view of your practice information.  This type of fast visual
information makes it easy to compare figures by sight, giving
impact to your information in a way that raw figures on paper
cannot give you.  

There are three types of graphs you can view and print:  pie
chart, column chart, and bar graph.  With these three types you
can view eight specific graphs.  The following is a listing of
graphs:


~Pie Chart~

*Relative MTD Production By Provider Pie Chart
*Relative YTD Collection by Provider Pie Chart
*Relative MTD Collection by Provider Pie Chart
*Relative YTD Production by Provider Pie Chart
*MTD Production By Class Pie Chart
*YTD Production By Class Pie Chart
*Aged Receivables Pie Chart


~Column Chart~

*New Patients By Month Column Chart
*Referring Doctor Production Column Chart
*MTD Production By Class Column Chart
*YTD Production By Class Column Chart
*Relative YTD Production By Class Column Chart
*Aged Receivables Column Chart
*Receivable Breakdown Column Chart
*Referring Patient Production Column Chart


~Bar Chart~

*New Patients By Month Bar Chart
*Referring Doctor Production Bar Chart
*MTD Production By Class Bar Chart
*YTD Production By Class Bar Chart
*Relative YTD Production By Class Bar Chart
*Referring Patient Production Bar Chart



@PracMan
^Viewing Graphs

Select 12.  Graphs.

A listing of graphs now appears.

Using your arrow keys select the graph you wish to view.
Press <Enter> to view the graph.

~Depending on your computer hardware, there may be a slight
delay.  Also, faster machines may see a brief flash before the
graph appears.  This is because the machine processes
information so quickly that the status bar does not have time to
appear on the screen adequately.~

Once you have finished viewing the graph, press any key to
choose another graph to view.
After viewing all graphs, press <Esc> to return to the Practice
Management menu.


For Microsoft Windows Users

If you operate Easy Dental Plus through Microsoft Windows, be
sure to view the graphics in full screen mode.  If viewing Easy
Dental Plus "windowed," and you have high resolution graphics
running in the background, you will not be able to view the
practice management graphs.  If this occurs, press <Alt-Enter>
to return your "windowed" Easy Dental Plus to full screen mode.




@PracMan
^Printing Graphs

Printing graphs employs the same process as for viewing graphs. 
The exception is you press <Enter> while viewing the graph in
order to print the graph.

~Graphs will print on most dot-matrix and laser printers.~

Follow the instructions for viewing graphs.

While viewing the graph, press <Enter> to print the graph.

