@PatEnt
^Patient Classifications

Easy Dental Plus classifies patients as either both a patient and a
responsible party, a responsible party only, or a patient only.  Thus, a
"patient" may not actually be a patient in your practice if classified
as a responsible party only. 
 
All "families" in your system will have one (and only one) responsible
party, who may or may not be a patient. The number of patients allowed
per family is approximately 100.  A responsible party is the person who
is accountable for all family charges; there is only one balance per
family.  Easy Dental Plus stores information, such as last payment date,
by family; otherwise, the program stores all other information per
patient.  Easy Dental Plus stores insurance information per individual
patient, but each patient may have someone else--not necessarily the
responsible party-- providing the insurance.  You can view treatment
history individually or for an entire family. You can view appointments
the same way.

If you are initializing your system, and you keep separate ledger cards
for each family member, you must add up the family's entire balance
before initializing balances; after all, there is only one balance per
family.  If you must keep a separate balance for each family member,
then make every family member responsible for his or her own charges.


@PatEnt
^Keeping Patients Organized

We strongly recommended that you use option #7 on the patient menu to
print labels for patient's charts directly after you add a patient, and
that you place the labels on the outside of the charts.  This will
eliminate the need for you to write the patient's name and address on
the chart.  More importantly, the presence of a label on a chart will
help keep you from mistakenly adding a patient several times into the
computer. 

Easy Dental Plus maintains a special list to make printing chart labels
easy.  This is a list of all patients whose address has changed. 
Patients are automatically added to the list when you add them as new
patients or you change the patient's address.  

WARNING:  If you have a family to add, you must add the responsible
party first.      



@PatEnt
^Adding/Changing Patient Records

You add and edit patient information with the same program.   Easy
Dental Plus uses the term "patient" loosely, meaning a patient, or
responsible party, or both.  


~Adding A Responsible Party~

You sometimes forget to add the responsible party first when adding a
new patient.  Instead of having to start all over, you may add a
responsible party while entering the dependent's information.  You can
press <Ins> to add a responsible party (Figure 24).

Normally you would get to field ~#3, Responsible Party~, and discover
that you did not enter the responsible party.  Pressing <Ins> allows you to
enter the responsible party's critical information without leaving the
dependent's information unfinished.  You will notice there is not a
Patient Status field.  This is because you are entering a patient who is
a responsible party only.  If this is not true in your case, you can go
back and edit the patient's status to Patient and Responsible Party. 
Pressing <Ins> reveals the screen shown in Figure 25.  You can then
enter the critical information for the responsible party.  Once you have
completed this, the program returns you to the dependent's information
screen. 

While you are editing any item, you can press <Esc> to move the cursor
to the bottom of the screen.

If you pressed <Esc> by mistake and want to continue editing, just press
<Tab> to restore the screen.  To return to the previous data entry
screen, press <Shift-Tab>.


~Adding vs. Changing Patients~

You need to answer the same questions when you change an existing
patient as you would when adding a new patient.  When you add a patient,
you need to answer all of the questions.  When changing a patient's
information, you may change any or all items. Another way for you to
change an item is to press <Shift-Tab> or <Tab>.  Pressing <Tab> moves
the cursor to the first item on the screen, then to each successive
item.  When you press <Shift-Tab> the cursor moves to the previous item. 
   
If you want to change a specific item, type the item number at the
prompt at the bottom of the screen (Figure 25).  The cursor will move to
that item where you may re-enter the data.  When you press <Esc>, the
cursor will again move to the bottom of the screen.  You can change
another item or continue on to the next screen.  


@PatEnt
^Changing Responsible Party Information

Editing the responsible party's record can cause the program to make
changes in his dependent's records.  The items that prompt these changes
are:

        ~Address
        Home and Work Phone Numbers
        Insurance Coverage~

~Changing the responsible party's insurance coverage information always
affect dependents.~

Except for insurance coverage, when you save the responsible party's
record you are prompted if you wish to save the information for the
dependent's as well (Figure 26).  


@PatEnt
^Saving or Canceling the data for this Patient

When you save data the program prompts you:  ~Save all data for this
patient as entered, or Cancel (S/C):SAVE.~  Press <Enter> if you want to
save the data as entered.  If you have not finished data entry for this
patient, you must return to this program at a later time and finish
entering this patient's information.

After you have finished with the last data entry screen, a series of
questions may appear.  Each question is dependent upon what patient
information you entered.


~What saving a patient's information does.~

When you save the patient's information the program updates the
patient's record.  Along with the patient's record, Easy Dental Plus
changes other items:

        ~*A flag that indicates the patient's information has changed,
        including new patients.  This affects the printing of rolodex 
        cards and labels. 
        *Saves the patient's anniversary date. 
        *Updates the patient and doctor referral reports.
        *Updates the Practice Demographics report. 
        *Updates the control file.~



@PatEnt
^New Patient Question

You will be asked ~Do you want to count this person as a new patient?
Yes~ each time you enter a new patient into the database.  Answering
"Yes" saves the patient's Anniversary Date as the current date.  If you
answer "No," the program will not save an Anniversary Date.

~Every time you edit a patient without an anniversary date, this
question will pop up.  Always answer this question~ "Yes."


~New Patient Letter Question~

If the new patient question appeared and you answered it "Yes," then you
get the question ~Do you want to send this person a new patient letter?
Yes.~  If you answer this "Yes," then this person will be placed on a
list to receive a New Patient Letter. 

~Referring Source Question~

If you entered a referring source for a new patient, or if you changed
the status of a referring source for an existing patient, then you get
this question:  ~Send (Referring Patient or Doctor Name) a referral
letter? Yes.~  If you answer this "Yes" the program places this patient
or doctor on a list to receive either a Patient Referral Letter or
Referring Doctor Referral Letter.



@Ins
^Updating Dependent's Information

When you change the responsible party's general information, whening
saving his information you get this question:  ~This Responsible Party's
Address Or Phone Information Has Changed.  Do You Want To Update The
Rest Of This Family?~  If you wish to update the dependent's records,
indicate "Yes."


@PatEnt
^Patient Entry Fields Defined (Screen #1)

~First Name.~  Type the patient's first name and middle initial. 
You do not have to capitalize.  The program will automatically
capitalize for you.  

~Last Name.~  The second item for you to enter is the patient's
last name.  You may not save a patient without this item.  For
mixed-cased names, such as McDonald, you will need to type the
name as it should appear.

~Responsible Party.~  This is the person who is responsible for
all charges incurred by the family.  The responsible party's
status can be one of two types:  Responsible Party and Patient,
and Responsible Party Only. 

~Responsible Party and Patient~ means that he is responsible for
the family's payments and charges, and is a patient in the
practice as well.  

~Responsible Party Only~ means he is not a patient in the practice
but is responsible for the family's payments and charges. 

~Patient Status.~  This can be one of three statuses.  If the
patient entered is the responsible party, the status will be
either Responsible Party and Patient, or Responsible Party Only;
otherwise, the status is Patient Only.  

~Address Information.~  This is the patient's mailing address. 
The program prints this address on all printed reports for the
patient.  This includes letters, mailing labels, statements, and
other patient correspondence.

If the patient has the same area code as the doctor's office
telephone number, enter only the patient's 7 digit home
telephone number.  The system will automatically supply the
doctor's area code for the patient's area code.  

In order to make entering the patient address information as
efficient as possible, you may customize a table of City, State,
and Zip Codes (City/State/Zip Menu).  You can choose from that
listing the appropriate information.  All you need to do is type
in the actual address of the patient.  If you do not use the
customizing feature for cities, states and zip codes, you will
have to type the city, state and zip code for each patient.  If
the patient's location and the practice location are the same,
press <Enter> to accept the patient's default city location.  The
same is true for the patient's state and zip code.

Easy Dental Plus formats nine digit zip codes and six digit
Canadian postal codes for you--do not type any dashes or spaces. 

~Telephone Numbers.~    You can enter 7 or 10 digits for the phone
number.  If you want to type in an extension for the work phone
number, you must type the entire phone number starting with the
area code.  The home phone number does not have an extension.

~Sex.~  Press either M for male or F for female.

~Marital Status.~  This can be either Married, Single, Divorced,
or Widowed.  

~Title.~  When printing envelopes, address labels, or statements,
the program prints the person's title in front of the person's
name.  If you choose "None" then you will proceed to the next
question.  If you choose "Other," you can enter your own title. 
If the patient already has a title entered, you will not see the
pop-up menu, but you will be able to edit the title that is
there.  

~Dear.~  This item--some call it the "Nickname" field--prints in
letters to patients.  The Special code "Salutation Name" uses
this item.  It appears in letters after the "Dear."   

~Social Security Number.~  This number prints primarily on
insurance forms.  This is a nine digit number.  You cannot enter
alphabetical characters in this field.   

Some insurance carriers require a different number other than
the social security number on insurance claims.  You can add
this number to Miscellaneous Notes.

~Date of Birth.~  Easy Dental Plus calculates the patient's age
from his date of birth.  If you enter a blank date of birth, the
patient becomes zero years old.  

Electronic claims requires the date of birth for all
electronically submitted insurance claims.

~Monthly Statements.~  This item asks if you want monthly
statements printed for this patient.  The responsible party is
the only type of patient affected by this flag.  

~Charge Interest.~  If you wish to charge monthly interest on
aging patient balances, set this option to "Yes."  You can
customize your interest charges in the Accounts Receivable menu.
If you set the monthly interest flag to "No" you can override
the flag when calculating monthly interest charges.  

~On Recall.~  Setting this flag makes the patient eligible for
recall.  Patients with the status Responsible Party Only are not
eligible, setting this flag automatically to "No."  You can find
patients who have recall flags set to "Yes," but do not have a
recall date, on the report Patients Not On Future Recall.

~Recall Frequency/Cleaning Time.~  You can set the patient's
recall frequency and cleaning time with this option.  The
default information is 6 months and 30 minutes.   

~Last Prophy/Next Prophy Dates.~  If, at the time of entering the
patient's information, you know their last and next prophy
dates, you may enter them at this point.  If not, you may come
back and enter them here later, or use Change Patient's Recall,
option #3 on the Patient Menu, to put in the patient's recall
date information.

~You can edit this information when updating the patient's recall
date and time.~

~Number of Insurance Coverages.~  This is how many insurance
coverages the person has.  A person can have 0, 1 or 2.  The
default answer is 0.  You must enter this information for
patients who are responsible party only.

Do not confuse this with insurance companies.

~Chart Number.~  This will not appear on your screen if you did
not customize your system to file patient charts alphabetically.
You may type numbers and letters for the chart number.  This
information will only appear in Patient Inquiry and on rolodex
cards.  

~To access a patient by his chart number, type # followed by the chart
number.~




@PatEnt
^Patient Entry Fields Defined (Screen #2)

~Preferred Dentist/Hygienist.~  When you initially select the
patient's preferred dentist and hygienist automatically, Easy
Dental Plus puts this information on insurance forms, walkout
statements, and other related  patient-provider correspondence. 
Since you select the patient's provider information in advance,
this simplifies entering treatment by specifying the provider of
services automatically.  You can, however, override the provider
selection when you enter treatment.  

~Referral Type.~  If another patient or doctor refers this
patient, you may indicate this reference here.  Doing so will
update the Practice Management referral reports, and update MTD
and YTD referral income.  

~You may use the doctor referral for other types of referrals,
such as newspaper, Yellow Pages, or other referring sources.~

~Referred By.~  This field holds the referring person's name or
number.  If you select "Not Referred" as the referral type, then
the program will not ask you to fill in this field. 

You may press <Ins> to add a referring doctor source to your
database.  You cannot add a referring patient this way.  The
patient must already be in the database before you can add them
as a referral.

~Medical Alert.~  If you fill out the Medical Alert, the program
alerts you to the patient's medical condition when entering
treatment, scheduling appointments, or consulting the patient
inquiry.  Easy Dental Plus also prints the patient's medical
alert on Patient Fact Sheets, and patient routing slips.  

~If the Medical Alert field is too small for a particular
patient, you can type "See Doctor's Comments."  The Doctor's
Comments on any patient are always readily available by pressing
<F2>.~

The medical alert information appears when changing a patient's
recall, when using Patient Inquiry.

~Statement Message.~  Each family can have a customized message
printed on their monthly statement.  Since the responsible party
is the only family member to receive a statement, you can
customize this only for the responsible party.  

~When adding a dependent, this field does not appear on the
screen.~

~Medicaid and Medicare Numbers.~  These fields allow you to enter
the patient's Medicaid and Medicare number.  You can customize
Easy Dental Plus to print these fields on an insurance form.   

~Electronic Claims:~  You can use Item 9 (Misc. Note 3) for the
Employee Identification Number if the insurance company requires
this.  For the program to recognize this you must type I#
followed by the number.

~Miscellaneous Notes.~  These items allow you to enter any
miscellaneous notes you wish about the patient.  You may specify
their occupation, or you may want to use these fields for rank
and serial number for military patients.  You can create a
custom insurance form to print these fields, or alter an
existing form to accept these fields.  

~Patient Providing Insurance.~  This is the person who is
responsible for providing the patient with insurance coverage. 
If this is a person who is not a patient in the practice, you
still need to add them to the database as a Responsible Party
Only.  If the responsible party's coverage changes, such as
changing to a different coverage, the dependent's information
changes automatically.

~If the patient does not have insurance coverage, the coverage
questions will not appear on the screen.~

Even if the patient has an individual insurance policy, you must
first add the insurance coverage, and then connect an insurance
company to that coverage.  This is because in Easy Dental Plus
an "insurance company" is just a name and address; an "insurance
coverage" holds information about deductibles, maximum coverage,
and other employer information.

~Relationship to the Insured.~  The status of the relationship can
be one of four types:  Spouse, Child, Parent, or Other.

~If the patient being added has their insurance coverage provided
by another person and that person has only 1 insurance coverage,
the program completes the coverage field automatically. ~

~Coverage.~  This field is for the employer/coverage name.  If the
coverage does not exist in the database you may add the coverage
by pressing <Ins>.  



@PatEnt
^Patient Entry Fields Defined (Screen #3)

~Missing Teeth.~  Electronic claims uses this section of patient
information.  When adding a patient for the first time, you can
skip marking missing teeth.  If you electronically transmit the
patient's insurance information, you can specify missing teeth
by pressing <Del> while on the missing tooth.  

To mark all teeth as missing, move the highlight point to the
correct set, either permanent or primary, then press <-> to mark
them as missing.  Using the arrow keys will also change
the tooth to missing or not missing. 

~Teeth marked as missing can be changed to not missing by
pressing <Ins>.  You can mark a whole set of teeth by pressing
<+>. ~

~Medical History Questions.~  If you use medical history questions
in your practice, those questions will appear here.  You may
multiple types of questions, such as Yes/No, True/False,
Multiple Choice, Date questions, and Fill-in-the-Blank
questions.  These questions appear on the Patient Fact Sheet,
Patient Questionnaire, Practice Demographics Report, and custom
generated reports.

You are limited to 70 medical/dental history questions.



@PatEnt
^A Few Hints about Setting up Patients

1.  If you would like to start using the billing part of the system
quickly, we recommend that you initially set up only those patients that
have an outstanding accounts receivable balance. 

2.  We recommend that you add additional patients (new or existing) on a
daily basis only as the patients are coming to the office for
appointments. 

3.  We recommend that you work from the appointment scheduler or your
appointment book when entering patients in the system, and try to stay a
few days ahead of patient appointments. 

4.  If you are entering patient information from existing records, you
should have the patients' records available prior to entering them into
the database.

5.  We strongly recommend that you print labels for new patients' 
charts on a daily basis and apply the labels on the charts.  This will
prevent you from setting up the same patient twice with two different
patient numbers. 

The label program is designed to print on continuous self adhesive
labels that are 15/16" by 4."

6.  When you are initially setting up accounts with a balance, write the
patient number on the ledger cards. 


@Rec
^Patient Recall

Patient recall is a dynamic part of Easy Dental Plus.  You need
to update patient recall dates and times periodically in order
to help your dental practice keep up with this process.  This
will ensure the patient receives his recall notice on time.

~Medical Alert Information.~  Each time you update the patient's
recall, the program displays the patient's medical alert
information, if any.  This information may be critical to the
patient's recall treatment.

~Recall Frequency/Visit Length.~  The first line of the recall
screen, shown in Figure 16, shows the frequency of recall
appointments for the patient and the amount of time required for
their prophy appointment.  You normally enter this information
when you add or change a patient's information.  However, you
may edit this information from this screen if you choose to
change a particular patient's recall frequency and time.

If there is no current recall date, this means that you
previously blanked out the patient's recall date, or never
entered one.

You may press ~S~ to make the next recall date and/or time the
same as the patient's latest scheduled appointment. 

To do this:

Press <Shift-Tab> to move the cursor backwards to the field you
wish to edit. 
Make your edits, then press <Enter> to continue with changing
the patient's recall.
Enter the new recall date in the Next Recall Date field. 

~Current Recall Date/Time.~  These fields reflect the last prophy
date stored for the patient.  Normally, when updating recall
this date should be the current date.  This is because 6 months
ago you set the recall date to 6 months in the future (today's
date).  When you update the Next Prophy Recall Date field, the
next time you change the patient's recall you will see that date
in the Current Prophy Recall Date field.

~Next Recall Date/Time.~  Easy Dental Plus updates these fields,
depending upon one of the following cases:

If the prophy recall date 1) is blank, or is today or earlier,
and 2) you just entered treatment that included a prophy, then
the program automatically recalculates the date for you using
the recall frequency.  

~If that frequency is zero, the program clears the date and time.~
 
~If the dental recall date is today or earlier, the program
clears the dental recall date and time.~

If you customize your software to use balance-forward allocation
of payments, then payments are going to the oldest transaction
for the family.  This could make patient balances in section 7
inaccurate.  



@Rec
^Recall Comment Codes  

The Master Recall List can include recall comments codes.  This allows
office staff to see needed information on the Master Recall List that
concerns individual patients.  To use this feature you must access three
modules within Easy Dental Plus:

        ~*Doctor's Comments to create recall comment codes
        *Recall Processing to add recall comment codes to the master 
        recall list
        *Change Patient's Recall~

Refer to Print Monthly Master Recall Report for more information
about the recall report.

~Adding a recall comment.~  If you added recall comment codes to the
database, and customized the mail format/sort options to include recall
comments on the Master Recall List, all you need to do is add the recall
comment code to the patient's recall.  

~Be sure there is a recall date specified in the Next Prophy Recall Date
field; otherwise, the program will not save the recall comment.~

To add a comment to the patient's recall:

Press <Alt-A>. 
Highlight the option "To Add New Recall Comment, Select This And Press
<Enter>," or press <Ins>.   
With your arrow keys highlight the recall code you wish to include for
this patient's recall, then press <Enter>.

~You may select more than one comment code for a patient's recall. 
However, be selective in the number of comment codes that you do select. 
The more codes that exist for a patient, the longer your Master Recall
List will be.~


@Rec
^Associating Recall with a Scheduled Appointment

You can associate scheduled appointments with a recall appointment. 
It takes just a few keystrokes to make the recall date and an
appointment date the same.

When updating the patient's recall, you will see Figure 29.

Press ~S~ at the Next Prophy Recall Date field to make the recall date
the same as the latest scheduled appointment, following one of the following
possible scenarios:

~1.~  If a date does not appear in the Next Prophy Recall Date field but
there is a scheduled appointment, the program will update the next
prophy date field based upon the scheduled appointment date.

~2.~  If a date does appear in the Next Prophy Recall Date field, and
there is a scheduled appointment you wish to make the same as the recall
date, press ~<Space>~ to clear the recall date.  Next, press ~S.~  The
appointment date will automatically appear in the Next Prophy Recall
Date field.

~3.~  If there is a date in the field, and you want to schedule a
different date for a prophy recall and a scheduled appointment, press
~S~ while on this field.  This will take you to the scheduler to
allow you to make a later appointment.

The scheduler searches the scheduler database for an appointment for the
patient.  If the scheduler cannot find an appointment, it will prompt
you to make an appointment. 

Press <Enter> to move to the appointment scheduler. 
Schedule the appointment, as directed in the Appointment Scheduler
section of Volume II.

After you save the appointment, the program returns you to the recall
screen.



@Pat
^Patient Inquiry

When accessing patient information is important, Easy Dental
Plus gives you a tool you can use to find out almost anything
you need to know about a patient--all with just one keystroke. 
The tool you can use is the Patient Inquiry.

You can access patient inquiry in one of three ways:  as option
#4 on the patient menu, by typing ~INQ~ from almost any menu, or
by pressing <F2> from virtually anywhere within Easy Dental
Plus.  The advantage to the Pop-Up Inquiry (<F2>) is that it
does not interrupt the task at hand.  The program returns
directly to your previous task after you exit Patient Inquiry. 

Easy Dental Plus divides the patient inquiry into the following
13 sections:

~Section 1- General Information~

This section shows you all of the basic information about a
patient, including name and address, phone numbers, sex, marital
status, recall frequency, and responsible party (Figure 17).


~Section 2- Providers, References, Missing Teeth~

This section shows the preferred doctor, who referred the
patient, income generated from referrals, medical alert and
custom statement messages, medicaid/medicare numbers, and
miscellaneous notes.


~Section 3- Insurance Information~

Section 3 includes the patient's insurance coverage information
including insurance filed and insurance pending, the name of the
insurance company, and the name of the patient's employer or
coverage.

~Section 4- Account Information~

This shows the prior month end balance for the account, the
charges for the current month, the payments for the current
month, and the current balance for the family.  This section
shows other statistics, including payment plan and contract
information, the aging account balance, date of last treatment,
and date of last payment received.


~Section 5- Medical History Questions~

This section shows the answers to medical history questions, and
indicates missing teeth.  If you have more than 18 questions in
your system, press the up and down arrows to scroll through the
questions.


~Section 6- Doctors Comments~

This shows you any comments saved for the patient.  If there is
more than one screen's worth of comments, use your arrow keys to
move up and down.  You can also use <PgUp> and <PgDn> to move up
or down an entire screen's worth of comments. 


~Section 7- Family Information~

This shows you all of the members of this patient's family, and
brief information about each family member.  If there is more
than one screen's worth of family members, press the up and down
arrows to view all of them.  


~Section 8- History Inquiry~

You can view all of this patient's individual or family
transactions, using any of these available keys:

~F~ to view family transactions 
~I~ to view individual transactions 
~C~ to view history with transaction comments 
~N~ to not include transaction comments with history
~R~ to include/exclude a running balance.


~Section 9- Appointments~

If you are using the appointment scheduler, then you can view
all of this patient's individual or family appointments.  Press
F to view family appointments, or press I for individual.


~Section 10- Treatment Planning~

If a patient has uncompleted treatment planning, you may view a
listing of the treatment planning not scheduled.


~Section 11- Statement/Insurance Dates~

You can view the family's monthly statement and insurance filed
dates from this section.  This section indicates:

~*The date of the filing
*The name of the family member the filing affects
*The dollar amount related to the filing.~


~Section 12 - Prescriptions~

Displayed are the prescriptions that have been prescribed for
the patient.  Refer to Patient Prescription Writer for information on
how to add prescriptions to the patient's record.


~Section 13- Lab Information~

Section 13 includes the patient's lab sample information.  This
screen will list any lab sample currently on file for the
patient.

To view a family's balance history, that is, a daily balance,
select Family Summary inquiry.  This will show you the family's
balance as of a particular date, up until the first transaction.


@Pat
^Dialing patient phone numbers

You may dial a patient's phone number while in Patient Inquiry using
Easy Dental Plus' autodialer feature.  To use the autodialer:

Press D while viewing the patient's records.

Refer to Section I for information about how to use the Autodialer.


@Pat
^Print Patient Fact Sheet and Questionnaire

The patient fact sheet and patient questionnaire are useful tools that
the dental practice can use to keep patient information current.  Office
staff can give the Patient Questionnaire to the patient to complete when
the patient comes in for their first appointment.  Although you cannot
edit this information sheet, you can affect the nature of the
information presented on it by using medical history questions.  

The Patient Fact Sheet reflects the information provided by the patient
through the patient questionnaire.  This sheet is useful when used
periodically to keep your patient's information current.



@Pat
^Print Patient Rolodex Cards & Labels for Charts

This program allows you to print labels for patients' charts and rolodex
cards. The system is designed to print on continuous form labels that
are 15/16" x 4" and only one label wide, sometimes called "one up"
labels.  The rolodex cards to use are continuous form also, and their
size must be 3" x 5."  

~Print Option.~  You may select to print either rolodex cards only,
labels only, or both.

~Alphabetical or Numeric.~  When printing, Easy Dental Plus can sort
cards either alphabetically or by patient number.

The first time you print you must answer Yes to print all the
patients you have entered so far.  If you answer "No," the program
does not purge this list, and you will have many patients on this
list that you did not intend to stay on the list.

~Print Only Patients Whose Information Has Changed.~  Anytime you enter
a new patient, or you change an existing patient's information, the
program resets a flag in the patient's record.  This flag indicates to
the program that is needs to print a new rolodex card or label for the
patient.   

If electing to print cards or labels only for these patients, the
program resets the print flag.  The flag remains set until you change
the patient's information again.

~First/Last Patient to Print.~  If you are not printing cards and labels
for patient's whose information has changed, then you will see these
options.  You may specify either starting and ending patient number if
printing numerically, or starting and ending letter if printing
alphabetically.

~Number of Labels per Patient.~  If printing labels only, or rolodex
cards and labels, you can specify the number of labels per patient
to print.  The program prints labels as a set per patient.  This
means that patient #1's five labels prints first, then patient #2's
five labels prints next.

~Reprinting labels.~  After the program prints a set of cards and/or
labels, you have the option to print another set.  The second set will
be identical to the first.

~Purging print list.~  If printing cards or labels for patients whose
information has changed, you can purge this list after completing your
printing job.  The program then resets the print flag in the patient's
record back to a non-print status. 



@Pat
^History Inquiry

Although similar to the patient inquiry, patient history gives
you a total listing of a patient's or family's transactions. 
These transactions include treatment, payments, credit
adjustments, contract charges, and transaction comments.  When
using the audit function, voided transactions and insurance
expected and received amounts are visible.  

~Individual/Family Inquiry.~  You may view the patient's history
as an individual patient, or you may include other family
member's history.  The patient does not need to be the
responsible party in order to display family history.  

~Summarized/By Procedure.~  You can view patient history in
summarized or detailed form.  If viewing summarized history,
Office Visit represents the combined treatment for that day and
not individual treatments.  To see individual treatments, choose
By Procedure.  Press ~S~ to view summary history, or press ~B~ to
view detailed history.
  
~Show Audit Information.~   Changing audit to "Yes" allows you to
view expected and received payment amounts from the patient,
primary, and secondary insurance coverages, as well as view
voided transactions.  

~Comment/No Comment.~   You can view transaction comments in the
patient's or family's history by changing this option to "Yes."

~Show Statement/Insurance Date.~  Using this option allows you to
see when a monthly statement was last generated and when the
insurance claim was filed.  

~Since these dates are saved as transactions in the patient's
history, you will have a number of these entries.  You may wish
to view or a range of dates for a patient's transactions in
order to lessen the amount of information viewed.~

~Date Range.~  This option allows you to view all transactions, or
a selected range of dates.  If you want the selected range, the
program prompts you to enter the first and last date in that
range.  To choose a selected date range press ~S~.  For all
transactions press ~A~.

~If you plan to print a patient's transaction history, and you do
not want the patient's entire history printed, you can change
the First Date in Range and Last Date in Range fields to
restrict the transactions that the program will print.~

Whenever you view a patient's history the history may not be in
it's originally entered sequence.  Easy Dental Plus sorts the
patient history by date--normally.  However, when you conduct a
history search using the audit option, these dates may not
necessarily be in date order.  This is because there are two
transaction files:  one for open (unpaid) and current items, and
another for closed (paid) items.  When you close the month, the
program removes items from the current history files are places
the closed items into the past history files.  Therefore, older
items that are open (or were open until this month) may appear
later in the listing than some items that are newer but paid off
earlier.



@Pat
^Printing Patient History

You may print the patient's history by pressing <Enter> when
viewing the history.  If you wish to limit the amount of history
that prints, be sure to select a date range of history to
include on the printout.



@Pat
^Patient Routing Slip

The patient routing slip is printed patient information you can use on
the day of the patient's appointment.  The routing slip provides the
provider of services information about:

        ~*Patient History
        *Family Information 
        *Comments 
        *Treatment Planning 
        *Medical History Questions 
        *Next and last recall dates for family members
        *Deductible and coverage remaining information.
        *Open treatments (partially and unpaid treatment)~



@Pat
^Routing Slip Format

Easy Dental Plus divides each routing slip into three sections. 
~Section I~ includes patient information.  You can customize
~Section II~ to include additional patient information, and
family information.  ~Section III~ is additional text information
that prints at the bottom of the routing slip in either 10 cpi
Pica or 17 cpi condensed print.

~Section I~

Name 
Address 
Phone Numbers 
Sex 
Date of Birth 
Appointment/Recall Information 
Family Account Information 
Insurance Information


~Section II~

Medical History Questions 
Doctor's Comments 
Pending Treatment
Planning Family Information 
Treatment History 
Transaction Comments 
Recall Comments


~Section III~

Additional Text



@Pat
^Printing Routing Slip For One Patient

You can only print single copies of the routing slip using this option. 
The program cannot print multiple copies with this option.  



@Pat
^Print Routing Slip For Today's Patients

You can print routing slips for patients who have appointments for a
particular day.  This greatly speeds up the printing process, and allows
you to print more than one routing slip per patient.


To print routing slips:

Enter the date. 
Enter the number of copies needed per patient.

The program prints the routing slip after you set these fields.


@Pat
^Routing Slip List

To help verify that you have entered treatment for all patients seen
during the day, you may print a listing of patients that you printed a
routing slip for during the day.  This list includes:

        ~*The patient number and family number
        *The patient's name
        *If treatment was/was not entered
        *The family's current balance.~

~Recall date is not the same as a scheduled appointment.  Only patients
with recall dates associated with a scheduled appointment receive a
routing slip.~

~You may type DAY at any main menu in order to print the routing slip
list.~


To print a routing slip list:

Go to the Accounts Receivable menu.
Select 6.  Print a Day Sheet.

You will see the screen shown in Figure 32.  This screen may seem
familiar to you.  This is because this is the screen you see when you
print a daysheet.

Select 3.  Print a Routing Slip list.

The pop-up box will disappear.  You will then be prompted for a date.  

Enter the date the routing slip list is for.
When prompted "Press <Enter> to View Daysheet, or <Esc> to Quit," 
press <Enter>.

The routing slip list appears on the screen.

Press <Enter> to print.



@Pat
^Setting Routing Slip Options

You can customize routing slips to include important information about
the patient.  Sections II and III of the routing slip contain the
information that you can customize.

To customize a routing slip:
Enter the date range of treatment you want included on the routing
slip.

You can use a date limit to specify a limited amount of patient history
and treatment planning printed on the routing slip.  If a patient has
been in the practice for some years, the amount of stored history can be
quite large.  By specifying a starting date for history, any history
past that date the program includes on the routing slip.

Select the features you want present in Section II.

What you select for Section II of the routing slip determines the
overall length of the routing slip.  The more options included, the
longer the routing slip will be.  Press Y to select an item to include
in this section.  Pressing <Enter> will accept the options chosen and
move to Section III of the routing slip.  

~Medical History Questions.~  This prints all medical/dental history
questions that you answered "Yes" for the patient.

~Doctor's Comments (Codes).~  This prints the text for all doctor's
comment codes attached to this patient.  This does not print the comment
code. 

~Doctor's Comments (Free Form).~  This prints all free-form doctor's
comments that you attached to this patient.  Pending Treatment Planning. 
All uncompleted treatment planning or deleted treatment planning will
have brief information printed:  date entered, tooth, surface, procedure
code and procedure code description. 

~Family Information.~  This prints each family member's name and patient
number.

~History Inquiry.~  This presents a complete list of the patient's
individual treatment history in the same format as Pending Treatment
Planning.

~You will notice the program includes transaction comments if you
include patient history; otherwise, the answer to transaction
comments is "No."~

~Transaction Comments.~  This includes transaction comments on the
routing slip.  If you set treatment history to "No," then, the program
sets transaction comments to "No."

~Recall Comments.~  This includes patient recall comments that you
attached to the patient.

Edit additional text, if desired, for Section III.

~Additional text in Section III cannot be customized for individual
patients.~

You can add additional text to the bottom of the routing slip.   You can
use this section to create a checklist for commonly entered procedure
codes, or special treatment notes, or any type of information that is to
appear on all routing slips.  The program prints the additional text in
10 cpi Pica or 17 cpi condensed print.



@Pat
^Patient Prescription Writer

If the dentist prescribes a prescription drug to a patient, you
may enter this information into the patient's record by using
the Patient Prescription Writer.  This utility allows you to:

~*choose from a database of prescription drugs
*attach drug information to a patient's record
*print a prescription
*print prescription instructions
*print a prescription record
*refill prescriptions.~



@Pat
^Adding a Prescription

In order to choose a drug, you must first enter the drug into
the database.  Refer to Prescription Writer for this information.

From the Patient Menu select 14.  Patient Prescription Writer.
Enter the patient's last name or patient number.

You will now see a screen similar to that seen in Figure 31.

~If the patient has had more than one prescription filled, then
the order of drugs seen in Figure 31 will be in the order the
prescriptions were filled. ~

Press <Ins> to add a prescription.

~You cannot delete a prescription from the patient's record.~

Enter the name of the drug you wish to prescribe to the patient.

You will now see the screen seen in Figure 32.  

Enter the following information into the appropriate fields:

~Provider~ -- patient's dentist

~Prescription Date~ -- the date the prescription is written

~Dispense~ -- dosage; amount or number

~SIG.~ -- instructions

~Refills~ -- -1 gives unlimited refills

~Standard Information~ -- Additional Instructions

After you have filled in the above information, make sure the
cursor is at the bottom of the screen.  If not, press <Esc>.
When prompted "Press <Enter> to Continue, or <Esc> to Cancel,"
press <Enter>.

You will next be prompted to print a prescription.  You must
print the prescription in order for the program to save the
prescription into the patient's record.

When prompted "Print Prescription or Cancel," press <Enter> or
P<Enter>.
Press <Enter> to print the prescription.
Once the prescription has been printed, press <Esc>.

You may now print an instruction sheet that you can give to the
patient (Figure 33.)   

Press <Enter> to print the instruction sheet.
When the instruction sheet has finished printing, press <Esc>.

You may now print a record of the patient's prescription.

Press <Enter> to print the prescription record.
When the record has finished printing, press <Esc> to return to
the prescription writer program.



@Pat
^Refilling a Prescription

From the Patient Menu select 14.  Patient Prescription Writer.
Enter the patient's last name or patient number.

You will see a screen similar to that shown in Figure 31.

Using the arrow keys, select the prescription you wish to
refill.  
Press <Enter> to begin refilling the prescription.

You will now see a screen similar to that shown in Figure 32.

Enter the appropriate information into the fields shown.
When you have finished filling out the appropriate information,
make sure the cursor is at the bottom of the screen.  If not,
press <Esc>.  
When prompted "Press <Enter> to continue, or <Esc> to Cancel,"
press <Enter>.
When prompted to "Print Prescription or Cancel," press <Enter>
or P<Enter>.

You must print the prescription refill in order to save the
prescription to the patient's record.

Press <Enter> to print the prescription refill.
Once the prescription refill has been printed press <Esc> to
proceed.
Press <Enter> to print the instruction sheet.

~You may press <Esc> while viewing the instruction sheet and
prescription record if you do not wish to print these items.~

Once the instruction sheet has been printed, press <Esc> to
continue.
Press <Enter> to print the prescription record.
Once the prescription record has been printed, press <Esc> to
return to the Patient Prescription Writer Program.


@Pat
^Printing a Prescription Record

You do not need to enter a prescription for a patient in order
to print a prescription record.  You may print a prescription
record at any time by pressing ~I~ while highlighting a patient's
prescription.

To print a prescription record:

From the Patient Menu select 14.  Patient Prescription Writer.
Enter the patient's last name or patient number.
Using the arrow keys, select a prescription record you wish to
print.
Press 'I'.

You will see the patient's prescription record on the screen.

Press <Enter> to print the prescription record.
Once the prescription record has been printed, press <Esc> to
return to the Patient Prescription Writer screen.




@Pat
^Summary of Prescriptions

You may print a summary listing of prescriptions that have been
filled for patients.  This listing includes:

~*Prescription Name
*Date of Prescription
*Number of Refills
*Dispensing Information~

To print this list:
 
From the Patient Menu select 14. Patient Prescription Writer.
Enter the patient's last name or patient number.

You will see a screen similar to that seen in Figure 31.

Press 'P'.

You will see a listing of the prescribed drugs for the patient.

Press <Enter> to print the summary listing.



@Pat
^Reprinting a Walkout Statement

A receptionist usually prints a walkout statement at the time of
a patient's visit.  Sometimes this is not the case, yet the
patient may later desire a walkout statement.  To meet this need
you may choose option #13 on the patient menu to reprint a
walkout statement for any day during the current accounts
receivable month.

Once you close the month, you cannot print any walkout statement
that contains transactions entered prior to close month.     



~Statement Considerations~

When reprinting a walkout statement consider these items:

~*Have you closed the accounts receivable month?~

You cannot reprint transactions that are prior to the last close
date on a walkout statement.

~*Did you enter more than one set of treatment that day?~

If you entered separate treatment sessions on the same day, they
will all appear on the reprinted walkout sheet.  You cannot
limit the treatment printed on a walkout statement.

~*Do you use the walkout statement instead of an insurance form?~

The walkout statement is designed to allow the user to use it
for insurance purposes, and is accepted by most insurance
companies.  The patient should check with their insurance
company for the validity of using a walkout statement in this
manner.



@Pat
^Reprinting the Walkout Statement

Select 13.  Reprint Walkout Statement.

You will see a screen similar to that in Figure 34.

Enter the number of walkout statements you wish to print, up to
9 total.
Enter the Treatment Date that the walkout statement is for.
Select whether the walkout statement is for an individual or for
the entire family.  
Enter the name of the family member the walkout statement is for.

~If you are printing a walkout statement for the entire family,
it does not matter which family member's name is listed.~

Press <Enter> to print the walkout statement.

