@MedQuest
^Medical History Questions

A patient's medical history is an important part of the
patient's information.  This type of background information is
important in performing treatment and prescribing medication. 
Easy Dental Plus includes the medical history questions on the
New Patient Questionnaire.  You can print this and give it to
the patient to fill out.  You then add the answers to the
patient's record.

~You can access the Medical History Question menu by pressing Q
from any main menu.~

The medical history questions are a part of several Easy Dental
Plus reports:

*Patient Fact Sheet
*New Patient Questionnaire

Refer to Print Patient Fact Sheet and Questionnaire for information
about the above reports.

*Practice Demographics Report
*Custom generated reports



@MedQuest
^Question Types

There are several types of questions that you may use.  These
are:

~Informational~ --  This type of questions is really not a
question at all.  It is a placeholder for instructions,
comments, or can serve to hold a blank line.

~Yes/No Questions~ --  These are the traditional questions that
require a yes or a no response.  This type of question also
serves as a True/False question.

~General Number Questions~ --  This type of question requires
input in the form of a number.  The number must be between a
minimum and maximum value that you set.

~Date Questions~ --  Similar to the general number question, data
questions require a response that falls between a minimum and
maximum date value that you set.

~Dollar Amount Questions~ --  Similar to general number and date
questions.  This requires a dollar amount that falls between a
minimum and maximum value.

~Multiple Choice Questions~ --  This type of question is similar
to the traditional multiple choice question.  You specify the
number of choice, the text for the choices, and specify a
default answer that is always highlighted first.  This would
allow you to press <Enter> without having to move to the most
common question every time.

~Fill-In-The-Blank Questions (Short and Long)~ --  You may use
this for questions that require non-standard responses.  You are
limited to 20 characters for short answers, and 40 characters
for long answers.



@MedQuest
^Adding Questions

Easy Dental Plus does not come with stock medical history
questions installed.  You must enter the questions you wish to
use.  You can add up to 70 medical history questions to the
system.  

To add a question:

From the Medical History Questions screen press <Ins> to add a
new question.
Select the question type from the pop-up list.
Enter your question text.

At this point you may have minimum/maximum, or True/False values
to enter. 

For the type of value available, see the section on 
Question Types.

Enter any minimum/maximum values called for.
Save your changes.



@MedQuest
^Editing Questions

Although you can delete medical history questions, you may wish
to edit the question text instead.  The process for
accomplishing this is similar to that of entering a question.

WARNING:  Do not change the meaning of the medical history
question.  The change does not affect the previous answer.  For
example, changing "Do you smoke?" to "Are you HIV+" can create
false answers.

From the Medical History Questions screen press <Tab> until you
reach the question text you wish to edit.
Press <Enter>.
Select the type of question, or press <Enter> to accept the
current question type.

Make your text edits.
Save your changes.




@MedQuest
^Deleting Questions

On occasion you may have need to eliminate questions you no
longer use, or questions that are invalid.  Deleting a question
is a simple process:

From the Medical History Questions screen press, press either
<Tab>, <Shift-Tab>, or arrow keys to select the question you wish
to delete.
Press D to delete the question.



@MedQuest
^Moving Questions

In the event that you wish to rearrange your questions, you can
employ one of two methods:

~*Press <Ins> at the point you wish to add a question, or
*Use the move key to move an already exiting question to it's new
location.~

Using <Ins> only works when adding a new question.  However, if
you add the question at the wrong place, you can move the question
to it's correct location by pressing M while highlighting the question.


To move a question:

From the Medical History Question screen, press <Tab>,
<Shift-Tab>, or the arrow keys until you highlight the question
you wish to change.
Press M.
Using up down, move the question to it's new location.
Press <Enter> to confirm new location.



@MedQuest
^Printing Question List

If you wish to print a listing of your medical history questions,
you may do so by pressing P while viewing the Medical History
Questions screen.  You may print up to 9 copies.



@Provide
^Providers

You can use the provider module to enter the names of dentists,
hygienists, or other persons on your staff who provide patient services. 
When you enter your staff members into the database, the system keeps
track of the number of procedures a provider performs, and the monthly
and yearly production for each provider.



@Provide
^Provider Fields Defined

~Provider Name.~  You must enter the provider's full name:  First, Middle
(name, initial, or none), Last, followed by any other designation, such
as Jr. or Sr.

~Easy Dental Plus limits the number of providers you can enter to 99.~

~Anyone listed as a provider is able to receive credit for performing
treatment.~

~Address.~  Included here is street address, city, state, and zip code.
Phone Number.  This is the phone number of the practice.

~License Number.~  This is a 12 character field that accepts any valid
alphanumeric character.

~Tax ID or SSN.~  You may choose to enter either the provider's tax
identification number or his social security number as a reference.  You
need to set the field to the right to either Tax ID or Social Security
Number.

~Specialty Code.~  You can choose one of several specialty codes:

    ~301 General Dental Practice
    302 Independent Hygienist
    303 Endodontics
    304 Pedodontics
    305 Periodontics
    306 Prosthodontics
    307 Orthodontics
    308 Denturist
    019 Oral Surgery~

~You choose the Specialty Code from as list of choices available in the
pop-up menu.  If none of the specialties apply, choose #301 -- "General
Dental Practice."~

Many of the following fields are necessary for electronic claims processing.
Improper or incorrect information can cause errors in your electronic
claim.  You will need to enter the correct information in these fields
before you can send your  claim electronically.

Refer to Errors Encountered While Preparing Electronic Claims
for the fields that can cause errors in an electronic claim.

~Provider Location.~  You electronic claims vendor provides you with this
code.  The vendor calls this the "Site Code."

~Miscellaneous ID Number.~  This is an information field only.

~Medicaid/Medicare/Delta/Blue Cross Numbers.~  These numbers are important
numbers if sending claims to these particular carriers, especially if
you use electronic claims.

~Collections go to.~  This field identifies who gets credit for
collections.  The default setting is "Self."  You may set this to any
other provider.  Refer to Provider Production and Collections
for additional information about this field.

~MTD/YTD Figures.~  These figures are available for editing, especially if
entering a provider midway in the current calendar year.



@Provide
^Entering a Provider

A provider is anyone in your practice that performs treatment.  This
includes the dentist, hygienist, or any other individual in your
particular practice that performs treatment.  When adding providers, DPI
recommends you add the primary personnel first.  After you enter them,
you may add any other personnel or sources that you wish to list, such
as a hygienist.    

To add a provider:

Select 1.  Add or Change Provider.
When prompted to enter a provider name or number, press <Enter>.
Enter the appropriate information in the date fields previously
described.
When finished entering information, press <Esc> to move the cursor to
the bottom of the screen.
Save your changes.



@Provide
^Provider Production and Collections

~Production by Provider~

Easy Dental Plus maintains production (fees charged) by provider for
you.  You should not change items 18-22 except when initializing these
figures (Figure 108).

~Payments have no effect on production.~

Adding treatment increases the Month-To-Date figures (MTD).  Voiding
transactions and closing the month decreases these figures.

Adding treatment increases the Year-To-Date figures (YTD).  Closing the
year decreases these figures.

Adding treatment, and making some contract adjustments affect the "MTD"
and "YTD Fees Charged" figures.  Easy Dental Plus flags these
adjustments on daysheets and patient history inquiries.  No other
adjustments have any effect on production.   Closing the month and year
also zeroes out these figures.


~Collections by Provider~

Easy Dental Plus designates all debits--patient charges and debit
adjustments--as belonging to or performed by a specific provider.  This
allows the user to track production by provider.  All credits--payments
and credit or discount adjustments--are "applied against" debits.  By
tracking how much you apply of each payment to debit transactions, the
program determines collections by provider.  If you use "Open-item
Payment Allocation," you control how you apply payments.  If you use
"Balance-Forward" instead, Easy Dental Plus applies all payments to the
oldest balance first.  The program keeps collections by provider with
equal accuracy under both systems.

Refer to Use Automatic (Balance-Forward) Payment Allocation
for information about payment allocation methods.

Collections by provider has as different use if your practice has
providers who get credit for production, but not for collections.  The
typical scenario for this is when hygienists get paid according to a
percentage of the work they do (production) but are not a part of the
collections process.  If this is the case, when you enter each hygienist
you must change the Collections Go To field to the doctor they work
with.  If hygienists work with multiple doctors, then you will have to
enter each hygienist into your computer multiple times.  Thus the
provider "Mary Hygienist with Dr. Jones" has her Collections Go To field
set to Dr. Jones, and the provider "Mary Hygienist with Dr. Smith" has
her Collections Go To field set to Dr. Smith.  

~You must pay particular attention to which provider gets credit for
production when entering treatment.  Make sure the "hygienist" you use
corresponds with the doctor who will get credit for that production.~

Another way to manipulate collections by provider is to redistribute
collections.  This feature allows you to alter a provider's collections
for any particular payment, without regard to the original provider of
service.  While DPI does not suggest using this feature on a regular
basis, it can be of occasional use when you assigned the treatment to
the wrong provider.

Refer to Redistribute Provider Collections, for information about
redistributing collections.



@Provide
^Screen Inquiry

If you wish to view provider information without editing a provider's
record, you may do so by using the Screen Inquiry function found in the
Provider's menu.

To view provider information:

Choose 2.  Screen Inquiry.
Enter the provider's last name or provider number.

Figure 108 reflects the fields you can view.



@Provide
^Print Listing of Providers

You may print a listing of providers that you entered into the database. 
This program sorts the provider listing in provider number order.  To
print this listing:

Select 3.  Print Listing of Providers.
When the listing appears on the screen, press <Enter>.



@RefDent
^Referring Doctors

The Referring Doctor Menu allows you to keep up with the number of
referrals you receive from referral sources other than your patients. 
Although Easy Dental Plus calls this the Referring Doctors Menu, you may
actually put in the names and addresses of other referral sources, such
as doctors, the yellow pages, newspaper advertisements, or mass
mailings.  

~You can access the referring doctor menu by pressing D at any main menu.~

Whenever you add a patient to your system, you have the choice of
designating the referral as a doctor referral, patient referral, or not
referred.  If you select "Doctor," the program asks you for the name or
number of the referring doctor that you may enter from this menu.

After you enter the referring doctor, the system updates that referring
doctor's record each time you enter a referral.  The
Report of Referrals & Production by Referring Doctor lists the
referring doctor's referral statistics.

The Practice Management Menu has a useful option related to this menu,
called Reports of Referred Patients.



@RefDent
^Adding a Referring Doctor

You can add a referring doctor in two ways:

    *Enter the referring doctor through Add or Change Referring Doctor, found
    in the Referring Doctors menu.
    *Press <Ins> at the Referred By field when entering or editing a patient.


~Referring Doctor Fields~

~First Name and Initial.~  You do not need to include a title in this
field.

~If using another source as a referring doctor, such as Yellow Pages, you
must divide the name into a first and last name.~

~Last Name.~  This is the last name of the referring doctor, including
surnames such as Jr. or Sr. 

~Title on Labels.~  This defaults to Dr.  You may type in any title you
wish.

~Salutation.~  This field defaults to the title and last name as entered.
You may alter this.   

~Address Information.~  This is the normal address information.

~Phone Number.~  This field requires a 10 digit phone number.  If the area
code is the same as that of the practice information, you only need to
enter seven digits.  The program enters the area code automatically.

~Tax ID Number.~  Easy Dental Plus uses the tax identification number for
insurance purposes.  Electronic claims processing requires this number.

~Last Contact Date.~  This is the date you last contacted the referring
source.  You must update this manually, and is used only as a reference.

~YTD Production from Referrals.~  The program updates this dollar figure
each time you enter treatment on a referred patient.  Closing the year
resets this figure.


To add a referring doctor:

Select 1.  Add or Change a Referring Doctor.
Press <Enter> to add a new referring source.
Enter the appropriate information for the referring source.
When finished entering information, press <Esc> to move to the bottom of
the screen.
Save your changes.


~To change a referring doctor's information:~

Select 1.  Add or Change a Referring Doctor.
Enter the number or last name of the referring source.
Press <Tab> to move to the field(s) you wish to edit.
Press <Esc> to move the cursor to the bottom of the screen.
Save your changes.



@RefDent
^Printing Referral Information

There are several items that can print referring source information:

    ~*Referring doctor information
    *Referring doctor list
    *Mailing Labels
    *Rolodex Cards~


~Referring Doctor Information~

You may print or view the information entered for the referring source,
as seen in Figure 109.  To do so:

Select 2.  View/Print Information for a Referring Doctor.
Enter the referring source number.
When the program displays the information on the screen, press <Enter>
to print.


~Listing of Referring Doctors~

You can view or print a listing of all referring doctors, sorted by last
name.  To do so:

Select 3.  View/Print Listing of Referring Doctors.
Select the starting and ending referring source numbers to include on
the list.
When the program displays the list, press <Enter> to print.

You may print a detailed list of patients referred by any doctor by
choosing Practice Management Menu option #8
(Reports of Referred Patients).


~Mailing Labels~

You may print a set of mailing labels for referring sources onto either
your dot-matrix or HPII compatible laser printer.  To do so:

Select 4.  Mailing Labels.
Enter the first and last referring number you wish to include.
When prompted to print to the listed printer, press <Enter>.

~If you have a short list of referral labels to print and you use a laser
printer, you may waste more labels than you print.  You may consider
using a dot-matrix printer for your labeling needs.~


~Print Rolodex Cards~

You can maintain a rolodex listing of your referring sources by printing
a rolodex card for each of your referring sources.  To do this:

Select 5.  Rolodex Cards.
Enter the first and last referring source number you wish to print.
When prompted to print to the listed printer, press <Enter>.

~The rolodex cards must be 3 1/2" by 5" in size.~



@Remind
^Reminders/Note Pad

The reminder/note pad module provides you with an easy system of
keeping track of important meetings, dates, luncheons, or other
types of important appointments.  The reminder/note pad system
works similarly to an appointment calendar, using dates and
times as a basis of organizing your appointments.

~Completed reminders do not appear in the reminder list unless
you access the reminder menu using option #5 from the Master
Menu.  Using the <F5> key, or viewing reminders when you start
up Easy Dental Plus do not display reminders.~

As a way of reminding you of your appointments, the reminder/notepad
system displays all of your reminders for the day on the welcome
screen when each time you start Easy Dental Plus.

You can also access your reminders/note pad by pressing <F5>
anywhere in Easy Dental Plus.  For more information on this,
refer to Accessing Reminders Using <F5>.



@Remind
^Reminder Keys

There are some special keys you can use when accessing the
Reminders Menu.  

~<Ins>~ - The insert key allows you to add a reminder.

You cannot enter a reminder prior to today's date.

~R~ - The range key allows you to specify a range of reminders to view
and/or print.  The default range is the current system date.

~P~ - The print key allows you to print the selected range of
reminders.

~<Del>~ - The delete key deletes the highlighted reminder.

Completed reminders, if not deleted, will be deleted at close
month if the reminder date is greater than or equal to 60 days. 
All other reminders must be deleted by hand.

~<Esc>~ - The escape key exits the reminder menu, or stops the current
action.

~<F5>~ - This function key allows you to access the Reminders Menu from
anywhere in Easy Dental Plus.



@Remind
^Adding a Reminder

Press <Ins> while viewing the Reminder's Screen.

A screen similar to that seen in Figure 52 appears.  The program
positions the cursor in the ~Subject~ field.

If the reminder is for a different date and/or time than the
current date/time, press <Shift-Tab> to move to those fields.
When finished editing the date and time fields, press <Tab> to
return to the Subject field.
Enter a description of the subject, up to 56 characters.
Enter the reminder text.  You may add up to 200 characters, or
approximately three lines of text.
When finished entering text, press <Esc>.
Save your text.
When prompted "<Tab> to edit; <Enter> to continue," press
<Enter>.

The program displays the newly added reminder on the screen.



@Remind
^Deleting Reminders

Press R to select the date range for your reminders.
Enter your date range for your start and ending dates.

The program displays the reminders that fall with the date range
you specified.

Highlight the reminder you wish to delete.
Press <Del>.  

Refer to Reminder Keys for information about the keys available on
the Reminders Menu.



@Remind
^Editing Reminders

The process for editing reminders is similar to entering
reminders.

~You cannot edit old reminders, only reminders whose date is
equal to or greater than today's date.~

Press R to select the date range for your reminders.
Enter your date range for your start and ending dates.

The program displays the reminders that fall with the date range
you specified.

Highlight the reminder you wish to edit.
Press <Enter>.
Press <Tab> until you reach the field(s) you wish to change.
Make your changes.
When finished making your changes, press <Esc>.
When prompted "<Tab> to edit; <Enter> to continue," press
<Enter>.



@Remind
^Printing Reminders

Press R to select the date range for your reminders.
Enter your date range for your start and ending dates.

The program displays the reminders that fall with the date range
you specified.

Press P to print your reminders.




@Remind
^Accessing Reminders using <F5>

Easy Dental Plus displays a different reminder screen when you
press <F5>.  The same keys function using this option as when
going directly to the Reminder's Menu.

To exit the pop-up Reminders screen, press <Esc>.



@Remind
^Changing Reminder Status

The reminders/note pad allows you to set a status flag for a
particular reminder/note.  You may choose from:

~Reminder~ -- Normal status.

~Pending~ -- Work has not started on/for reminder.

~Active~ -- Currently working on reminder.

~Completed~ -- Reminder finished and ready to be deleted.

Completed reminders do not appear on the reminder screen  by
pressing either <F5> or at the start of Easy Dental Plus.

To change the status of a reminder:

Go to the reminder screen.
Using the arrow keys, highlight the reminder whose status you
wish to change.
Press <Enter>.
Press <Tab> until you highlight the status field.
Make your changes.
Press <Esc>.
Save your changes.



