@Letters
^Letter Basics

Once you get to creating or editing a letter, you are in a very
freeform environment.  You can put whatever you wish into your
letter until you run out of room, which is about two and a half
pages.  If you select a letter you created previously, you will
see a screen similar to that shown in Figure 54.

This screen tells you several things.  You will see the cursor
on top of a curiously reversed-color set of characters:  "100."
We call this a "Special."  The program displays a brief
explanation of whatever you are on near the bottom of the
screen, just above the help line.  In this case, the screen is
telling you that 100 represents Today's (System) Date."  To see
a similar explanation of the other Specials in the letter, move
the cursor to one of them.

Refer to page 4-6 for information about specials.

Note that many but not all of the lines end with "   ".  We
call this a "Hard Return."  We use the hard return to end a
paragraph.  When you print the letter, the program performs a
carriage return whenever the computer comes across this
character.  The actual "   " is not printed in the letter.

One character you do not see in the sample screen is "".  This
is at the very end of the letter (which is why it is not in the
sample screen) and indicates the end of the letter.  Like hard
returns, the program does not print this character.

The right border of the letter's window has a solid block at
the top, a shaded area down the right side, and a "_" at the
bottom.  This area indicates your relative position within the
letter.  Since the block is at the top, the sample screen shows
that the cursor is at or near the beginning of the letter.  If
it were in the middle, it would indicate that you were about
halfway between the start and end.  The "_" at the bottom
indicates that there is more at the end of the letter that you
currently do not see on the screen.  If there was a "-" at the
top, then that indicates more at the beginning that you
currently do not see.

Finally, the help line indicates some of your more important
options available to you while editing.  See the next
sub-section for explanations of what these keys do.

Notice that your cursor starts out in the very top left corner
of a letter, as in the above letter, unless you are creating a
new letter.  If this is the case, then everything from "100" to
"Dear 210," is provided for you, and your cursor begins at the
end so that you may start typing your letter right away.




@Letters
^Keys To Know While Editing

Editing a letter is simple.  Move to where you want to start
the letter, then start typing!  However, do not press <Enter> at
the end of every line.  The computer wraps the words to the next
line if they get too long.  You only need to press <Enter> at
the end of paragraphs so that you force the computer to start a
new line.  Notice that several special keys, such as <Tab>, have
a usage that is a different from elsewhere in Easy Dental Plus.

When typing a letter consider the following chart of key/key
combinations:

The arrow keys moves the cursor one character or line in
the appropriate direction. 

~<PgUp><PgDn>~ Page Up and Page Down moves the page 18 linesone
screen's worthup or down, unless yu get to the beginning of the
letter. 

~<Home>~ This key move the cursor to the beginning of the current
line. 

~<End>~ This moves the cursor to the end of the current line. 

~<Ctrl-Home>~ Press <Ctrl> and <Home> at the same time to move
the cursor to the beginning of the letter. 

~<Ctrl-End>~ This moves you to end of the letter. 

~<Enter>~ This places a Hard Return at the end of a line or
paragraph. 

~<Tab>~ This inserts five spaces. 

~<Esc>~ Press this key to quit editing the letter. 

~<Ins>~ This "toggles" you between Insert Mode and Overwrite
Mode. 

~<Backspace>~ This deletes the character to the left of your
cursor. 

~<Del>~ This deletes the character the cursor is on. 

~<Ctrl-D>~ or ~<Ctrl-Del>~* This deletes the current line you are
on. 

~<Ctrl-U>~ or ~<Ctrl-Ins>~* This "undoes" you last deletion. 

~<F9>~ This reformats the paragraph the cursor is currently in. 

~<F10><F12>~* These displays a pop-up menu of Specials you can
choose from. 

*The <Ctrl-Del>, <Ctrl-Ins>, and <F12> keys are alternative keys
that do the same job as the other keys mentioned with them. 
These keys or key combinations are available only on 101-key
keyboards.     




@Letters
^Insert Mode - vs - Overwrite Mode

When you begin editing a letter, you are in Insert Mode.  If
you press the <Ins> key, the program switches to Overwrite Mode,
and if you press it again, back to Insert Mode.  The program
shows what mode you are in visually by the size of the cursor. 
A small cursor means Insert Mode, a large one means Overwrite
Mode.  Insert Mode means whatever you type the program inserts
into the current paragraph, pushing the rest of the words in the
paragraph over to make room.  Overwrite Mode means that whatever you type
will replace the words in the paragraph you are typing over.



@Letters
^Reformatting a Paragraph

Sometimes while inserting or deleting words in the middle of a
paragraph, words that should actually appear at the end of a
line appear at the beginning of the next line, even though there
is plenty of room at the end of the previous line.  If this is
the case, you can correct your display by pressing <F9>.  This
has no effect on the final printed letter, however.  The
printing part of Easy Dental Plus does its own reformatting
whenever you print a letter.



@Letters
^Specials

Other word processors call a "Special" a "Merge Code."  The
program shows the special as a reversed-color set of four
characters, a box character followed by three numbers, such as
"100."  The program takes out the specials when you print the
letter, and substitutes the appropriate information.  The code
shown above represents today's date.  This means that when you
print a letter, and the program runs across "100," it will
substitute today's date in its place.  Paragraphs that have
Specials in the middle, the program reformats appropriately.

What is the purpose of a Special?  If you are sending a letter
to a large number of patients, you could type a patient's name
in the letter, print one copy of the letter, and then type
another name.  Or you could type blanks in the letter, print
several copies, and hand-write names.  Neither of these options
is easy, though.  Instead, you can put the Specials for Patient
First Name and Patient Last Name in the letter.  This way, the
program addresses each letter individually, but you will have
only typed one letter.



@Letters
^Choosing a Special

When you press <F10> or <F12> while editing a letter, you will
see a pop-up Specials menu.  There are several screens of
Specials.  A complete listing of these follow.  While viewing
the list, you can type the code for the special you want, or use
your <PgDn> and arrow keys until you find the one you want, then
press <Enter> to select.  If you press <Esc>, the program does
not insert specials into your letter.


~000~ Center This Line   The line on which this appears is centered. 

~100~ Today's (System) Date   This is the date set in the "Welcome
to Easy Dental Plus" screen, and used throughout the system as
today's date. 

~Practice/Provider Information~:  If the letter is to a patient, then the
provider used in the Provider Specials is the patient's Preferred
Provider.  Otherwise, provider #1 is used.        

~110~ Practice Name       

~111~ Practice Address #1      

~112~ Practice Address #2* (w/CR)  Refer to the note at the end
of the table. 

~113~ Practice City-State-Zip       

~114~ Practice Phone      

~150~ Provider Name       

~151~ Provider Address    

~152~ Provider City-State-Zip       

~153~ Provider Phone      

~Addressee Information~:  This is information that applies to
whomever the letter is addressed, such as patients, employers,
or insurance companies.            

~200~ Addressee First Name     

~201~ Addressee Last Name      

~202~ Addressee Address   

~203~ Addressee Address #2* (w/CR)      

~204~ Addressee City-State-Zip      

~205~ Addressee Phone     

~206~ Addressee Work Phone     

~210~ Addressee Salutation Name     

~211~ Address Title       

~220~ Employer, Insurance Company Contact Name* (w/CR)

~250~ Person Referred, First Name   

~251~ Person Referred, Last Name    

~252~ Number of Referrals by Addressee  If this is a letter to a patient,
the total number of referrals is used here.  If this is a letter to a
referring doctor, then the number of referrals this year is used. 

~253~ Number of Referrals (Last Year)   This only applies to referring
doctors 

~300~ Family Account Number    

~301~ Family A/R Balance.  The Accounts Receivable balance not include
contracts. 

~302~ Family Contract Balance.  All contracts for all individual family
members are included in this figure. 

~303~ Family Monthly Payment.  All family member's monthly payments are
added together for this figure. 

~304~ Family A/R + Contract Balance.  The sum of specials 301 and 302. 

~305~ Family Current Month Balance.  Specials 305, 306, 307, and 308
constitute the Accounts Receivable balance broken down into aging
balances. 

~306~ Family 31-60 Day Balance     

~307~ Family 61-90 Day Balance     

~308~ Family 90 Day and Over Balance    

~310~ Family Last Transaction Date.  Also known as Last Daysheet Date. 

~311~ Family Last Payment Date      

~312~ Family Last Payment Amount    

~400~ Patient Account Number   

~401~ Patient Birthday.  This prints the patient's next birthday. 

~402~ Patient Anniversary.  This prints the next anniversary date of the
patient's first visit with the practice. 

~403~ Patient Last Treatment Date   

~404~ Patient Responsible Party Name     

~405~ Patient Age    

~406~ Patient Social Security Number     

~407~ Patient Medical Alert    

~408~ Patient Responsible Party Salutation    

~409~ Patient Date of Birth.  Note the difference between this and 401. 

~410~ Patient Prophy Recall Date    

~411~ Patient Prophy Recall Time    

~412~ Patient Prophy Recall Number       

~413~ Patient Last Prophy Date      

~415~ Patient Dental Recall Date    

~416~ Patient Dental Recall Time    

~417~ Patient Dental Recall Number       

~420~ Selected Comment or History Question    

~450~ Patient Providing Insurance Name   

~451~ Coverage/Employer Name   

~452~ Insurance Company Name   

~453~ Total Pending       

~454~ Coverage Remaining       

~455~ Deductible Remaining     

~460~ Patient Providing Insurance Name   

~461~ Coverage/Employer Name   

~462~ Insurance Company Name   

~463~ Total Pending       

~464~ Coverage Remaining       

~465~ Deductible Remaining     

~500~ Coverage/Employer's Insurance Company   

~501~ Coverage/Employer's Insurance Company Address     

~502~ Coverage/Employer's  Insurance Company Address #2      

~503~ Coverage/Employer's Insurance Company City-State-Zip   

~510~ Coverage/Employer's Policy/Group Number      

~511~ Coverage/Employer's  Policy/Group Name       

~512~ Coverage/Employer's  Dependent Coverage,  Yes/No       

~513~ Coverage/Employer's Maximum Coverage/Year    

~514~ Coverage/Employer's Yearly Deductible   

~515~ Coverage/Employer's Yearly Preventive Deductible       

~516~ Coverage/Employer's  % Basic Coverage   

~517~ Coverage/Employer's  % Major Coverage   

~518~ Coverage/Employer's  % Preventive Coverage   

Note:  Anything that ends with "* (w/CR)" means that if there is anything
to substitute for this Special, the program performs a Carriage Return
after printing it.       



@Letters
^Using Word Processors and Easy Dental Plus

If you have a separate word processing package, it is possible
to edit or create the text of your letters with this software. 
There are several steps you must follow:

From the Letters Menu select Set Options.  
Select View/Change File Names. 
Look up the file name of the letter you wish to type.  You may
change it if you wish. 
After you find the file name, you can exit Easy Dental Plus and
go to your word processor. 
After you are in your word processor, load the letter.

There are several things to remember when ~loading~ or ~saving~ a
file:

*You may have to load the file as an ASCII or DOS Text file.  

*When you specify the file name to load, you must specify its
path.  If you are not using the Letter File Path option of the
Letters Menu, then this will be your DENTAL directory that, in
most cases, defaults to C:\DENTAL.  If you are using the Letter
File Path option, then the path you specify will be the same as
the path listed in the Letter File Path option.        

Example:  You are editing the Recall #2 letter, which has a file
name of let013.ltr.  Your letters file path is \dental\edlets\. 
Therefore, the file name to specify in your word processor is
\dental\edlets\let013.ltr.

*If the word processor does not allow you to specify a path, copy
the file from the DENTAL directory to the word processor's
directory before editing, and then back to the DENTAL directory
afterwards. 

When you ~edit~ the letter, there are some things to remember:    

*Word processing commands such as Bold, Right Justify, and Full
Justification do not translate over to Easy Dental Plus.    

*Word processors will not treat "Specials" the same way that Easy
Dental Plus does.  If there are already Specials in the letter
you are editing, be very careful around them.  If you change
them in any way, you then change their meaning.

*If you want to put a Special into the document you are editing,
you must be especially careful.  

First, place the "box" character in your document.  This
character has an ASCII code of 254.  You can put it in your
document by holding down the <Alt> key, typing 2 5 4 on your
number pad, and then releasing the <Alt> key.  

Next, look up the code for the Special in the table on page 4-6,
and type that code here.  Do not place any spaces between the
"box" and the three number code.  If you type the Special
incorrectly, Easy Dental Plus will not recognize it. 

After you edit the letter, save it as an ASCII or DOS Text file.
This is very important.  If you do not follow this step, then
the letter you save is unreadable by Easy Dental Plus. 
Return to Easy Dental Plus and print one letter to verify that
you have save the letter.




@Letters
^Choosing the Letter to Print

Before you can choose the letter you want to print, you must choose the
category of that letter.  There are nine categories of letters:

*New Patient Related Letters
*Account-Related Patient Letters
*Patient Recall Letters
*Date/Age-Related Letters
*Patients with Insurance Coverage Letters
*General Patient Letters
*Referring Doctor Letters
*Coverage/Employer/Insurance Company Letters
*Miscellaneous Letters

After choosing the category, another pop-up menu appears with
all of the letters within that category displayed.  If you are
printing an Account Related Letter, for example, then you would
see this list of letters:

Collection (Accounts with an Over 90 Day Balance)
Collection (Accounts with an Over 60 Day Balance)
Collection (Accounts with an Over 30 Day Balance)
Responsible Party who may receive a Finance Charge*
Responsible Party who may receive a Monthly Statement*
Responsible Party turned over to a Collection Agency*
Payment Plan Contract*

~The "*" symbol represents letters that you have not created yet.~




@Letters
^Questions about the Letter you are about to Print

Before you can print a letter, you must specify some conditions
for printing.  Since different kinds of letters print for
different conditions, this screen may have as few as the first
three questions shown, or as many as seven.  Only the first
three questions are the same for every letter.  Figure 55
represents what you typically see when you print a letter. 
Additional questions, if any, appear as needed.

~1.  Printing on~.  When printing a letter, you have the choice of
using a header or eliminating it totally.  This question gives
you three choices:

~Blank Paper~ -- Print Header
~Letterhead~ -- Print Blank Lines for Header
~Either~ -- Print No Header

How you answer this question only effects the first page of every letter.
All subsequent pages start at the top margin.

If you choose ~Blank Paper~, the program prints the ~Header for All
Letters~ on the top of the first page of each letter.  

If you choose ~Letterhead~, the program prints blank lines on the
first page of every letter to allow for a pre-printed
letterhead.  The number of blank lines the program prints
depends on how many lines are in the ~Header for All Letters~.  

~If you wish to have spaces for a header using this option, then you must
have blank lines at the top of your letter.~

~Either~ starts the letter at the very top margin of the first page and
does not print a header.


~2.  Type of paper (S/C)~.  If you answer this "Continuous Feed,"
the program prompts you once to get the printer ready.  If you
answer "Single Sheet," then the program prompts you at every
page.

If the letter you are printing has a different number of questions than
the five shown, refer to the section on Letter Types.

If you are printing on continuous feed paper that has your preprinted
letterhead on it, and you have a letter to print that is over one page in
length, then you may want to do the following:  

Go to Set Options of the Letters Menu, choose Page Format, and
change your Top Margin to allow for having your letterhead on
every page.  A top margin of 10 is sufficient in most cases.  

When you print, answer question #1 "Either--Print No Header," and
question #2 "Continuous Feed."

~3.  Printing ...~  You can choose to print letters only, letters
and envelopes, letters and labels, or either labels or envelopes
without letters.

*Letters Only prints only letters.
*Letters and Then Labels prints letters first, then print labels.
*Letters and then Envelopes prints letters first, then envelopes.
*Labels or Envelopes prints only those items and not the letters.


~4.  First to print~.  This defaults to 1 (the first patient, 
employer, etc., in your system).  You can make this a higher number in
order to limit the range of parties who will receive this letter.

~5.  Last to print~.  This defaults to the number of
patients/employers/etc., in your system.  You can change this in
order to limit the range of letters to print.


@Letters
^Listing of Letter Recipients

The program displays a list of letter recipients before you
print your letters (Figure 56).  This list indicates the
patients who will receive letters, or the patients for which you
will print envelopes or labels.  You can use this list as a
verification that the patient you intend to send correspondence
will have a letter printed for them.  Sometimes, however, a
patient may not show up on the list.  If this is the case, you
may add the patient to the list and print a letter for them. 
Conversely, if you do not wish to send correspondence to a
particular patient, you may delete the patient from this list.   

If the list of letter recipients is quite large (usually well over 700,
but it depends on the amount of memory available) then you cannot preview
the list of letter recipients.  The program informs you that this is
happening, and it then skips the preview step and proceed directly to
printing.

~Since there may be more than one screen's worth of letter recipients, in
addition to your arrow keys you can press <PgUp>, <PgDn>, <Home> and <End>
to move around this listing.~

To add or delete a patient from the recipient list:

Press <Ins> to add a patient, or
Press <Del> to remove a patient.

When adding a patient to the recipient listing, the program displays a
pop-up window similar to that shown in Figure 57.  This only appears if
you are adding a patient to the list who is already in the patient
database.  There are some letters that you can address to non-patients--
people who are not a part of your practice.  In this case, you need to
fill out the information that you see in Figure 57.

~If you are printing one of the letters where the recipients come from one
of the lists made when saving new patients (New Patient-Related letters,
the Referring Doctor Thank You letter) and you delete someone from the
Preview Listing, then that person will not be purged from the list of
people to receive the letter.  That is, if you delete Dr. John Doe from
the Preview Listing of Referring Doctor Thank You letters, then the next
time you decide to print Referring Doctor Thank You letters, the program
will again select Dr. John Doe.~



@Letters
^Miscellaneous Letters Only     

If you are printing one of the five Miscellaneous letters, then you may
change the items shown in Figure 57.  If you are adding a non-patient,
then you must fill in these items.  In addition to the fields shown, you
can insert a title the program uses in the "Title" and "Salutation Name"
Specials.  Changes made to the patient's information affect this letter
only.  The program does not save anything to the patient's file.

Refer to Adding/Changing Patient Records for information on editing a
patient's information.



@Letters
^Changing Address Information for Miscellaneous Letters

While you are moving about the preview listing for miscellaneous letters,
if you notice that someone's name or address is not correct, then you can
alter that information.  To change the person's address information:

Highlight the person's name.
Press <Ctrl-A>.
Change the patient's information.

At any of the prompts, or even while the printer is printing, you may
press <Esc> to return you to the screen where you answer questions about
this letter (Questions about the Letter you are about to Print).  

~This does not change the patient's record.  If the address is incorrect,
you need to edit the patient's record.  ~

Refer to Adding/Changing Patient Records for information on editing a
patient's information.




@Letters
^Printing The Letters

Select 1.  Print Letters.
Select the category the letter is in.
Select the letter you wish to print.

A screen similar to that shown in Figure 55 appears.  Remember:  Not all
letters ask the same questions.

Answer the questions appropriate for the letter you are printing.

After answering your questions, the letter recipient listing will appear
(Figure 56). 


If needed, you may add or delete patients from this list.
When ready to print, press <Enter> while the program displays
the recipient list.

The program prompts you to prepare to print.  If you are printing either
labels or envelopes, you need to follow these special procedures:


If printing ~labels~, the program prompts you to print a lineup. 
After the lineup is correct, answer the question "No," and the
program prints all of the labels.

If printing ~envelopes~, the program prompts you to prepare the
printer for each individual envelope.  Align the printer so that
the print head is on the line where you want to start printing
the name and address.



@Letters
^Deleting a Letter

If you wish to delete a letter, you may easily do so by using the <Del>
key.  Deleting a letter does not actually delete the filename of the
letter, as most word processors do.  It retains the letter's filename, but
removes the letter's contents.   

To delete a letter:

Select 2.  Create, Edit, Delete a Letter.
Select the category the letter is in.
Highlight the letter you wish to delete.
Press <Del>.
When prompted to delete the letter, press Y <Enter>.

An asterisk appears at the end of the letter description. This means you
need to create the letter.

                           


@Letters
^Letter Options

There are a few options you may need to set before processing letters. 
These options are:

*Changing the letter margins
*Adjusting the letter header and footer
*Changing the letters file path
*Renaming letters.



@Letters
^Changing The Page Format

This option might be useful if you are printing on non-standard sized
paper, or if you wish to print onto post cards.  Thus, assuming you are
printing on standard 8.5" x 11" paper, the defaults shown in Figure 58
yield a top margin of 0.75", a bottom margin of 1", a left and right
margin of about 1".  

If you have need of printing a postcard type letter, you can change the
margins here or create it through the report generator.  Refer to
Creating The Report.

Your margins will vary, depending on how well you align your printer.  It
may be necessary to print several letters in order to get the paper
oriented correctly in your printer.  Once set, there should not be a need
to change the paper's orientation.

~Some printers have the ability to change their margins internally.  See
your printer's documentation for information about setting margins on your
particular printer.~

To change your margins:

Select 3.  Set Options.
Select Page Format.
<Tab> to the option you wish to adjust.
Enter the amount of the adjustment.
Press <Esc> when finished entering adjustments.
Save your changes.



@Letters
^Changing File Names

There are times when you would like to have more than one draft of a
letter.  Easy Dental Plus allows you to change the names of your letters,
giving you the ability of creating and using the same letter, but with
different contents.  You should use this option only for these types of
special circumstances.  For example, if you would like to have a special
Treatment Completion letter concerning a particularly length treatment
that you perform on a regular basis, you can use this option to change the
file name from "LET005.LTR" to "LENGTHY.LTR."  You then can type a new
Treatment Completion letter.  

This is an advanced feature you should only use if you are familiar with
DOS files and file management.  This does not affect any patient data
files, only your letters.


When you print the Treatment Completion letter, the program uses
the new wording stored in "LENGTHY.LTR."  The old wording stored
in the "LET005.LTR" file remains on your disk unchanged.  You
can switch back to it at any time by renaming the letter back to
its original name.

To change a letter's name:

Select 3.  Set Options.
Select File Names.
Press <Tab> until you highlight the name you wish to change.
Type the new name.

You do not need to type the ".LTR" extension.  The program adds the
extension automatically.

~The default extension for letters is ".LTR."  You can rename a letter
with a different extension, but this may make finding the letter in the
future more difficult.  It is best you retain the ".LTR" extension.~

When you have finished making your changes, press <Esc>.
Save your changes.




@Letters
^List of Original File Names


~File Name     Kind of Letter ~

LET000.LTR     Heading for All Letters 

LET001.LTR     New Patient (Patients 13 year old and older) 

LET002.LTR     New Patient(Patients 12 years old and younger) 

LET003.LTR     Thank you for pateints who have referred New Patients 

LET005.LTR     Treatment Completion 

LET006.LTR     Collection (Accounts with an Over 90 Day Balance) 

LET007.LTR     Collection (Accounts with an Over 60 Day Balance) 

LET008.LTR     Collection (Accounts with an Over 30 Day Balance) 

LET009.LTR     Birthday (Patients 13 years old and older) 

LET010.LTR     Birthday (Patients 12 years old and younger) 

LET011.LTR     Patient's Anniversary with the Practice 

LET012.LTR     Prophy Recall #1 

LET013.LTR     Prophy Recall #2 

LET014.LTR     Prophy Recall #X and Greater 

LET015.LTR     Dental Recall #1 

LET016.LTR     Dental Recall #2 

LET017.LTR     Dental Recall #X and Greater 

LET018.LTR     Patient with a certain Doctor's Comment 

LET022.LTR     Responsible Party 

LET023.LTR     1st Patient and Responsible Party 

LETMISC2.LTR   2nd Patient and Responsible Party 

LETMISC3.LTR   3rd Patient and Responsible Party 

LET024.LTR     Patient Only 

LET025.LTR     Inactive Patient 

LET026.LTR     Patient who answered "Yes" to a Medical History Question 

LET028.LTR     Female Patient 

LET029.LTR     Male Patient 

LET030.LTR     Responsible Party who may receive a Finance Charge 

LET031.LTR     Responsible Party who may receive a Monthly Statement 

LET032.LTR     Responsible Party turned over to a Collection Agency 

LET033.LTR     Patient with Insurance Coverage 

LET034.LTR     Patient with Specific Provider 

LET035.LTR     Specific Age or Older 

LET036.LTR     Specific Age or Younger 

LET037.LTR     Patient who has referred X or more New Patients 
 
LET100.LTR     Thank you for referring doctors who have referred New
               Patients 

LET101.LTR     Referring Doctor 

LET200.LTR     Insurance Company 

LET300.LTR     Coverage/Employer regarding Insurance Data 

LET301.LTR     Coverage/Employer 

LET400.LTR     1st Miscellaneous Letter 

LET401.LTR     2nd Miscellaneous Letter 

LET402.LTR     3rd Miscellaneous Letter 

LET403.LTR     4th Miscellaneous Letter 

LET404.LTR     5th Miscellenous Letter 

LET040.LTR     Payment Plan Contract 

LET041.LTR     Coverage Remaining (Primary) 

LET042.LTR     Coverage Remaining (Secondary) 



@Letters
^Changing The Letter File Path

Normally, Easy Dental Plus stores the letters in a directory called
"EDLETS."  There may be a valid reason that you wish to store your letters
in a different directory.  If this is the case, you can use this option to
alter the letters file path.  This is an option you should use only if you
are familiar with DOS files and directories.  

Before you use this feature, you must make sure that the subdirectory to
be used in your letter file path exists, and you also must put all of your
letters into that directory.

To change your letters file path:

Make sure the directory you wish to use exists.
Select 3.  Set Options.
Select Letter File Path.

The program displays the letters file path for you.  

Press <Tab> to highlight the file path.
Type in the new letters file path.
When you see the cursor at the bottom of the screen, press <Enter>.
Save your changes.

You can change the letters file path from the System Customization menu,
Advanced Customizing Features (option #9).



@Letters
^Letter Types Explained

The purpose of the using Easy Dental Plus' letter writing utility is to
allow you to identify and communicate with certain groups of people.  If
you just want to send a letter to a particular patient (like, "Dear Mr.
Smith, I forgot to tell you the other day..."), there are three Patient
and Responsible Party letters you could use.  Should you want to send a
letter, period ("Bob, about that fishing trip next month..."), you could
use one of the five Miscellaneous letters.  The following letter
descriptions specify what qualifications, if any, places a person on a
letter recipient list.  Remember, even if a person does not "qualify" for
a particular kind of letter, you can always add them to the list of people
to receive that letter.



@Letters
^New Patient-Related Letters

When you add new patients, the program asks you specific questions before
you save their information.  The program uses these new patient related
questions for the New Patient Letter. 


~New Patient (Patients 13 years old and older)
New Patient (Patients 12 years old and younger)~

When you save a new patient, the program asks you if you wish to send a
letter to that patient.  If you answer "Yes," then the program puts that
patient on the list of people to receive a New Patient Letter.  When you
print one of these two letters, the program displays the total number of
people to receive the New Patient Letter; however, the actual number of
people who receive each kind of New Patient Letter depends on how many are
within each age group.  After you print a letter to someone who is on
this list, the program takes them off the list.  Since the people who
receive these letters come from a list, the program does not prompt you to
specify the first and last patient to print when printing letters.  


~Thank You for patients who have referred New Patients~

When you save a new patient, you may have indicated the patient referred
another patient.  When you save the new patient's information, the program
asks if you wish to send a letter to the referring patient.  If you answer
"Yes," then the program places the referring patient on a list to receive
this letter.  After you print a letter to someone on this list, the
program takes that person off the list.  Since the people who receive a
letter come from a list, the program does not prompt you to specify the
first and last patient to print when printing letters.




@Letters
^Account-Related Patient Letters

Letters in this category are financial matters that concern the patient. 
With the exception of the Payment Plan Contract Letter, only Responsible
Parties receive letters from this group.


~Collection Letters (Aging Balance Letters)~

The following table indicates which letter the patient
receives, depending on which letter you have selected to print
and the patient's oldest balance:

~Letter       31-60 Days    61-90 Days    Over 90 Days 
-----------------------------------------------------
Over 90 Days                                  XXX 

Over 60 Days                   XXX            XXX 

Over 30 Days    XXX            XXX            XXX ~


Responsible parties that have made a payment within the last thirty days
do not receive any of these letters.  Responsible Parties who have made a
family payment within the last thirty days are not selected to receive any
of these letters, as well as those you have turned over to a Collection
Agency.

Example: You are printing Collection (Accounts with an Over 60 Day
Balance) letters.  John Doe has not made any payments, and his oldest
balance is over 90 days old.  By referring to the previous table, you can
then tell that John Doe will receive the Collection (Accounts with an Over
90 Day Balance) letter.

~If you are using the Collection letters provided with Easy Dental Plus,
you will want to edit them so that the appropriate name and title appears
on the closing for each of these letters.~


~Responsible Party who may receive a Finance Charge~

On the first screen of Add/Change Patients data entry, question #18 asks
if you can charge this patient interest.  All patients who have this
question answered "Yes" receive this letter.  The program does not
consider whether or not the party has a balance.



~Responsible Party who may receive a Monthly Statement~

On the first screen of Add/Change Patients data entry, question #17 asks
if this patient is eligible to receive monthly statements.  All patients
who have answered this question "Yes" receive this letter.  The program
does not consider whether or not the party has a balance.  


~Responsible Party turned over to a Collection Agency~


Responsible Parties turned over to a Collection Agency receive this
letter.


~Payment Plan Contract~

All individual patients who have either a contract, or patients you marked
as on a payment plan receive this letter.



~Patient Recall Letters~

You can send these letters to patients scheduled for recall.  When you
print Recall letters, the program asks you a sixth question:

6. Month for Printing.

~There are several recall-related Specials (from 410 to 417) that
you can use in your letters.~

This question displays a pop-up menu that lists the months of the year. 
Use your arrow keys to select the appropriate month.

~Prophy/Dental Recall #1~ -- All patients who have a #1 Prophy or Dental
Recall scheduled for the month and year indicated, receives this letter.

~Prophy/Dental Recall #2~ -- Exactly as Recall #1, except for Recall #2.

~Prophy/Dental Recall #X and Greater~ -- Same as the other Recall letters,
except this one has an additional question:

7. Recall Including 3 and Greater.

All patients who have a Recall number greater than or equal to the recall
number you specify receive a letter, provided their recall month and year
also matches.


~Date/Age-Related Patient Letters~


Birthday (Patients 13 years old and older) and Birthday (Patients 12 years
old and younger)   These two letters have an extra question when you print
letters:

6. Month for Printing:

~You may want to replace the Special for "Today's Date" ("100) at the top
of the letter with the Special for "Patient Birthday" ("401).~

This question displays a pop-up menu that lists the months of the year. 
Patients with a birthday in the indicated month receive one of these
letters, provided they are in the correct age group.  Easy Dental Plus
uses the patient's birthdate to determine which age group to place the
patient in.

The program uses the patient's upcoming birthday to determine the
patient's age, and substitutes this information for the "Patient Age"
Special. 


~Patient's Anniversary with the Practice   ~

This letter has an extra question when you print letters:

6. Month for Printing:

~When writing this letter, you will probably want to replace the Special
for "Today's Date" at the top with "Patient Anniversary" (402).~

This question displays a pop-up menu of the months of the year. All
patients whom you saved as new patients during the month indicated receive
this letter.



~Inactive Patient~

This letter has an extra question when you print letters:

6. Last Visit Date:

All patients who never had a transaction, as well as those who have not
had a transaction since the day before the date indicated, receive this
letter.


~Specific Age or Older and Specific Age or Younger~


These two letters have an extra question when you print letters:

6. Dividing Age:

You can enter any age from 1 to 99 here.  All patients who are that age or
Older/Younger, depending on the letter, receive this letter.



@Letters
^Patients with Insurance Coverage Letters


~Patient with Insurance Coverage~

All patients who have either one or two coverages receive this letter.



~Coverage Remaining (Primary) and Coverage Remaining (Secondary)~

All patients who have coverage remaining with their Primary or Secondary
insurance coverage, depending on the letter you print, receive this
letter.  Patients who do not have the insurance coverage in question will
not, of course, receive any letters.



@Letters
^General Patient Letters


~Treatment Completion~

You typically send this letter to particular patients upon completion of
significant or lengthy treatment.  Any patient or responsible party
receives this letter.


~Patient with a certain Doctor's Comment~

When you print this letter, the program does not prompt you to specify the
first and last patient to print.  This is because it must search a list of
comments.  However, the program does ask you to specify the comment:

4. Doctor's Comment:    ____   Press <?> to list Comments.

~If you want the text for the Doctor's Comment that you have selected to
appear within the letter, use Special 420.~

If you already know the comment code that you wish to match on, just enter
it.  After you enter the comment code, the text for that comment appears
on the line below question #4.   All patients who have the Doctor's
Comment that you indicate receive this letter.

~If you do not know the comment code for the comment you wish to choose,
press "?" and a Pop-Up Menu of Doctor's Comments will appear.~


~Responsible Party~

All Responsible Parties and patients who are also responsible parties
receive this letter.


~Patient and Responsible Party (1st, 2nd and 3rd)~

These three are all general letters meant for you to send to any
patient/responsible party.  All patients and/or responsible parties
received this letter.



~Patient Only~

All patients who are not responsible for their own charges receive this
letter.  


~Patients who have answered "Yes" to a certain Medical History Question~

This has an extra question when printing letters:

6. Question Number:

After you enter the number, the program displays the text for the
corresponding History Question below this item.  All patients who have a
"Yes" saved in their file for that question receive this letter.

~If you want the text for the question that you have selected to appear
within the letter, use Special 420.~



~Female Patient~


All female patients receive this letter.


~Male Patient~

All male patients receive this letter.


~Patient with a specific Provider~


This letter also has an extra question:

6. Provider Number:

After you enter a provider number, the program displays the name of the
provider just below this question.  All patients who have that provider as
their Preferred Doctor receive this letter. 



~Patient who has referred X or more New Patients~


This has an extra question when printing letters:

6. Number of Referrals:

All patients who have referred "n" number of patients or more receive this
letter.




@Letters
^Referring Doctor Letters

~Thank You for referring doctors who have referred New Patients~


When you save a new patient's information, you may indicate that a
referring doctor referred the patient.  When you save the new patient, the
program asks you if you wish to send a letter to the referring doctor.  If
you answer "Yes," the program places the referring doctor on a list to
receive this letter.  After you print a letter to someone on this list,
the program removes the referring doctor from the list.  Since the people
who receive these letters come from a list, the program does not ask you
to specify the first and last doctor to print when printing letters.



~Referring Doctor~


This is a letter you can send to all referring doctors.




@Letters
^Coverage/Employer/Insurance Company Letters


~Insurance Company~

This is a letter you can send to all insurance companies.



~Coverage/Employer regarding Insurance Data~

While this letter should cover the topic of insurance coverage, you can
send it to all coverages/employers.  In this letter, and the "Coverage/
Employer" letter, if the coverage is an individual coverage, the program
inserts the insurance company's address in the addressee's address, city,
state, and zip Specials.


~Coverage/Employer~

This is a letter you can send to all employers.  See the previous letter's
note about addresses.


@Letters
^Miscellaneous Letters

You can address a miscellaneous letter to anybody.  You do not need to put
in any Specials if you so desire.  Easy Dental Plus uses the miscellaneous
letters as a "catch-all" for information not covered elsewhere.  A letter
to a friend, letters to patients at their work address, letters to
non-patients whom you want to attract to your practice...a miscellaneous
letter covers them all.

~If this is just a simple letter to a friend that does not contain any
Specials (or only has the "Today's Date" Special in it), when you print
this letter, you do not need to specify any Letter Recipients; you go
directly to printing.~



@Merge
^Mail Merge

Mail Merge gives you the ability to select information that is
meant only for use with your favorite word processor.  This
option allows you to access the Easy Report Maker to create
mail merge files that you then import into your word processor. 
This saves you many steps in creating mail merge data files, and
provides you with a method of including your Easy Dental Plus
data in correspondence to your patients.

~For information on merging your export file with your a document
in your word processor, you must refer to your word processor
manual.~


@Merge
^Easy Mail Merge Maker

The process for creating a mail merge file is the same as for
creating a custom report with the Easy Report Maker.  Refer to
this information for the steps in creating a report.



@Merge
^Running a Mail Merge

The process for running a mail merge is the same for running a
custom report in the Report Generator.  Refer to Printing Reports
for directions for running your mail merge.


@Merge
^Mail Merge Options

The process for setting your mail merge options is the same for
setting them in the Report Generator. Refer to
Field/Record Delimiters for directions for setting
your mail merge options.


