m@Ledger
^Account Types

There are five basic classifications of accounts used in General Ledger
accounting, each having a normal balance type (debit or credit).  


~Assets~

Assets are accounts representing things of value.  Examples of different
types of assets are checking accounts, savings accounts, accounts
receivable, furniture, and equipment.  The normal balance for asset
accounts is a debit balance, although there is one exception to this
rule.  The normal balance for depreciation under assets is a credit
balance.


~Liabilities~

Liabilities are accounts you use to track how much you owe someone else. 
Examples of liabilities are accounts payable, notes payable to banks,
and withholding taxes.  The normal balance for liability accounts is a
credit balance.


~Equity~

Equity accounts are accounts you use to track the value of your
business.  You can think of total equity as the net worth of  your
business.  All assets minus all liabilities will equal the total equity. 
Consider equities as liabilities owed to the owners of the business;
therefore, the normal balance for an equity account is a credit balance.


~Income~

Income accounts are accounts you use to track the amount of money you
earn.  Most businesses use different classification of income;
therefore, you will have several income accounts.  You consider your
income as derived from these accounts, so the normal balance for an
income account is a credit balance.


~Expenses~

Expense accounts are accounts you use to track the amount of money paid
for various expenses.  Examples of expense accounts are telephone,
postage, and salaries.  You should consider money as placed in or paid
to these accounts, so the normal balance for an expense account is a
debit balance.


@Ledger
^Easy Dental Plus Special Accounts

There are two other types of accounts that, although they are not
actually basic account types, Easy Dental Plus treats them in a special
way.  They are ~Cost of Sales~ accounts and Depreciation accounts.


~Depreciation~

In keeping a set of books for a business, you must keep up with the
reduction in value of certain types of assets.  In order to track this
reduction, you must maintain one or more depreciation accounts within
your asset accounts and within your expense accounts.  You debit the
expense depreciation account to reflect the expense of the depreciation,
while you credit the asset depreciation account to offset the value of
the depreciation against total current assets.  The asset depreciation
account contains the cumulative or total depreciation, while the expense
depreciation account contains the annual or year-to-date depreciation.

~All account numbers must be five digits long.~


~Cost of Sales~

Cost of Sales is actually a type of Expense account.  It includes
reductions in Equity that are not directly attributable to the primary
operations of the business--for example, patient discounts.  The General
Ledger system uses the Cost of Sales accounts to determine gross profit
on Income Statements. 


@Ledger
^Account Numbering

It is a standard accounting practice to assign numbers to each account. 
You may use any number you want for an account as long as you follow the
rules and conventions of the Easy Dental Plus General Ledger (the basis
of this convention is the general double-entry accounting standards):

Current Asset accounts must have account numbers between 10002 and
14998.  

~Plant, Property and Equipment~ accounts must have account numbers between
16001 and 16498.  

~Accumulated Depreciation~ accounts must have numbers between 16501 and
16998.  

~Other asset accounts~ must have numbers between 18001 and 19997.

~Current Liability~ accounts must have numbers between 20002 and 24998.

~Long Term Liability (or Debt)~ accounts must have numbers between 25001
and 29997.     

~Equity~ accounts must have numbers between 30001 and 39979.

~Income accounts~ must have numbers between 40001 and 43998.

~Cost of Sales~ accounts must have numbers between 44001 and 49999.

~Expense accounts~ must have numbers between 50001 and 59999.


@Ledger
^Creating Accounts

Easy Dental Plus comes with major accounts already established. 
However, you must enter and maintain your own personal accounts.  In
order to do this, you must enter new accounts into the database.

You cannot add or delete "Heading" accounts.  The program uses these
accounts strictly as headings in the various reports, including
View or Print List of Accounts.  You may, however, change the description of the account
number.  Example:  10000 Assets.

To create an account:

Select 6.  Change Chart of Accounts.
Select "Add Accounts."

A pop-up data entry window will appear (Figure 33).

Enter the account number for the new account.

~Remember to follow the account numbering conventions set forth earlier
in this section.  You do not need to type trailing zeroes.  If you enter
an account number that does not conform to the conventions, the program
will remind you of them through a message window.~

Enter a description for the new account.
When prompted "<Tab> to edit, <Enter> to continue," press <Enter>.
Save your changes.

The pop-up data window will stay visible until you press <Esc>.


@Ledger
^Altering/Deleting Accounts

You may wish to alter some of the accounts you have entered into the
database, or you may wish to eliminate the accounts that were already a
part of the general ledger.  

~You cannot delete Header accounts (H) and System accounts (S).~

To delete an account:

Select 6.  Change Chart of Accounts.
Select "Delete Accounts."

~The General Ledger does not actually delete the account until you close
the General Ledger Month and the account balance is zero.  The program
will mark the account for deletion in the select account window
(designated by "<D>").  At any time before the account is actually
deleted at month close, it can be unmarked by selecting the "Keep"
option at the delete prompt.~

The pop-up information entry window appears, as seen in Figure 33.

Enter the account number you wish to delete.

If you are unsure of the account number, be sure to use the
View or Print List of Accounts, or press ~"?"~ to pull up a listing
of all accounts.

If the account exists the description, if any, appears in the
description line.

When prompted to "Keep or Delete," press D <Enter> to delete.

The pop-up window will stay visible until you press <Esc>.

When viewing accounts you will discover the program still lists the
"deleted" account.  The listing does not disappear until you have closed
the month.  


To change an account:

Select 6.  Change Chart of Accounts.
Select "Change Accounts."

The pop-up information windows appears, as seen in Figure 33.

Enter the number of the account you wish to alter.

~You cannot edit the account number.  If this is what you wish to do, you
must delete the account number, then enter the correct account number.~

The account description automatically appears after you enter the
account number.

Press <Tab> to move to the description field.
Type in your new description.
When prompted "<Tab> to edit, <Enter> to continue," press <Enter>.
Save your changes.

The pop-up window will stay visible until you press <Esc>.


@Ledger
^View or Print List of Accounts

If you wish to view or print a listing of your current accounts, you may
do so by using the View Accounts option.  This option only displays or
prints the account numbers and the descriptions of the account.  This
does not include account balances.

To view or print a listing of accounts:

Select 6.  Change Chart of Accounts.
Select "View Accounts."

A listing of current accounts will appear.

To print the listing press <Enter>.
When finished viewing/print the listing of accounts, press <Esc>.


@Ledger
^Customizing Features

Before using the General Ledger, you need to customize a key feature of
your general ledger--the last month of your fiscal year.  Although you
can change this at anytime, it is best to set this and the other
customizing features before you enter any entries into the general
ledger.

The customizing features of the general ledger include: 

    ~*Account reports name
    *Current month
    *Fiscal year end (month)
    *Budget Feature~

~The budget feature is a special customizing feature that needs further
explanation.  If you customize to use the Budget Feature, then you will
be able to compare budgeted amounts with actual income and expense
amounts for the fiscal year to date.  Remember that this feature only
applies to income and expense accounts.~

To set any of these features:

Select 7.  Customizing Features.

The screen shown in Figure 34 will appear.

Press <Tab> to move to the field you wish to change.
Make your changes.
Press <Esc> when you finish making your changes.
Save your changes.


@Ledger
^Journal Entries

The core of the General Ledger is the journal entry.  Journal entries
include:

    ~*An account number
    *Entry date
    *Reference Number
    *Entry description
    *Debit and credit amounts~


@Ledger
^Changing the accounting date

Since journal entries are date related, you must be sure to change your
ledger accounting date.  The General Ledger does not update this date
automatically; you must set it each time you use the general ledger.  


You can change the account date in two ways:
 
    *Use the Change Accounting Date function
    *Change the accounting date for each journal entry batch

It would be preferable to use the ~Change Accounting Date~ function.  This
way the date consistently stays accurate.  If you change the entry date
while entering a batch of journal entries, the next batch of entries
will revert to the current accounting date, which you did not change
when you entered your journal entries.


@Ledger
^Journal Entries

Journal "entries" can contain up to 100 transactions; however, you
should restrict them to logical combinations.  For example, if you wrote
ten checks during a business trip, you might logically enter all of
those checks as one entry.  If, on the other hand, if you wrote ten
unrelated checks during a typical week, you would not logically group
them as one entry for tracking purposes.  Your only physical limit is
100 transactions per entry.

The transactions in a given journal entry must balance each other before
you can save them.  This is to ensure that the ledger never becomes
out-of-balance.

Journal "batches" are groups of entries that you post at the same time. 
The batch number increases as you post entries to your ledger. See
Posting the Journal  for further details.


@Ledger
^Entering Transactions

While entering specific transaction information, several short-cut
features are at your disposal.

When the current column is the account number field (Acc #), you can
press "?" to select an account from your chart of accounts.  The list of
accounts reflects which ones are "System Accounts," designated by an
"<S>," which are "Retained Earnings" and "Initial Earnings" account
numbers 39980 and 39989.  You should set these account balances only
when initializing all balances.  After that, the General Ledger updates
these accounts automatically every time you close the year.  Also, in
this list are "Header" accounts, designated by an "<H>," which are used
strictly in generating headings in reports.  The program marks accounts
you are deleting by a "<D>."  

~See ~Close Month/Fiscal Year~ and
~Altering/Deleting Accounts~ for more information.

As you enter new transactions, the program copies the previous
transaction's reference number and description into the current
transaction.  In the event the previous fields are no longer
appropriate, enter new information, and it will become the default.


To make a journal entry:

Select 1.  Journal Entry

A screen similar to that displayed in Figure 35 will appear.  The
only difference is the pop-up entry window will not appear until later.

Press <Enter> to enter a new batch of entries, or enter the batch number
you wish to add entries to.

The pop-up window seen in Figure 35 will appear.

Enter the appropriate information in the fields displayed.
Press <Tab> to move to additional fields.

Pay special attention to the Transaction Balance field at the bottom
right-hand side of the entry window.  This result must be zero when you
finish making journal entries.  If this is not the case, the journal
will be out of balanc and cause problems for you when closing the
general ledger month.~

You can save your entries out of balance, but you need to return later
and make additional entries into that batch in order to balance your
transactions.

When you have made all your journal entries, press <Enter> on a blank
account field.
When the cursor moves to the bottom of the screen, press <Enter> to
continue.
Save your changes.


@Ledger
^Deleting a Journal Entry

Once you make a journal entry, the General Ledger has not set that
entry...yet.  As long as you have not posted the journal, you can delete
a journal entry.  You must make sure that when deleting journal entries
that the batch remains in balance. 

To delete a journal entry:

Select 1.  Journal Entry.

Figure 35 will appear.
Enter the entry's batch number.
Press <Tab> until you highlight the entry you wish to delete.
Press <Ctrl-D> to delete the entry.
Press <Esc> to move the cursor to the bottom of the screen.
Press <Enter> to continue.
Save your changes.


@Ledger
^Posting the Journal

Once you enter all the journal entries for the current month, you are
ready to post to your ledger.  Once you post your transactions, however,
you can view that information in the General Ledger Report.  You can
only remove it through normal accounting methods; that is, you must
enter another transaction to offset a given balance.

In order to post your journal entries you must print the General Ledger
Journal Report.  If you do not print this report, the program will not
post your entries to the journal; however, you do have the option of not
posting to the journal after you print the report.  Posting will update
your General Ledger by incorporating into it the transaction information
in your current unposted batch.  The program then accurately reflects
these batch transactions in your General Ledger Report, your Balance
Sheet, and your Income Statement. 

You may post several batches of transactions during any one month.  You
do not need to post a batch immediately after data entry.  You may add
transactions to a batch over a period of several days before posting. 
You must, however, post all data for the month before you attempt to
close the month if you would like the transactions not to appear in the
"Monthly Activity" column of the General Ledger Activity report next
month.  In other words, any unposted transactions in your journal will
show up as next month's account activity on your reports.  

~We recommend that no one batch contain more than approximately 50
entries.  

Every batch posted to your ledger will have a unique batch number for
tracking purposes.~

After posting the General Ledger Report, the program displays the report
for your convenience.


@Ledger
^Close Month/Fiscal Year

Closing the month in the general ledger is an important process you need
to perform periodically.  Closing the month in the General Ledger will:

     *update each account's current balance by the total amount of the
     current month's associated activities
     *delete the current month's transactions
     *increment the Current Accounting Month

~Closing the month in the General Ledger is not the same as closing the
month in Accounts Receivable.  If you do not use the General Ledger,
then you do not need to close the month in the ledger.~

Before you begin the close month process, you must print several ledger
reports:

    *General Ledger Report
    *Balance Sheet
    *Income Statement
    *Budget Variance Report.

After you complete the close month process, the system prints a General
Ledger Report that shows the new account balances.

Close month automatically closes the year if the Current Month matches
your Fiscal Year End Month.  The close year process takes the difference
between year-to-date income and year-to-date expenses and places the
difference into "Retained Earnings," (Account number 39980).  The
program zeroes out each income and expense account in preparation for
the next year.  It does not zero out Asset, Liability and Equity
accounts.

You must set the Current Month immediately prior to the first time you
close the month.  The General Ledger will check to see if it matches the
Fiscal Year End Month each time you close the month.  The program
increments the month automatically.  If you do not wish to close the
year on the set month, you must change the Current Month so that it does
not match the Fiscal Year End Month.

You or your accountant may wish to delay your year end closing so that
you may make additional entries or adjustments.  If you do wish to delay
the year end closing, yet still close the month, you may change the
current month by using the Customizing Features.  If you do delay the
closing, do not enter any transactions for the new year.  Until you
close the year, the program considers all transactions a part of the
current accounting year. 

~Refer to ~Customizing Features~ for information about customizing
your ledger.~


@Ledger
^General Ledger Reports

The following reports are accessible from the General Ledger Reports
menu.  When you select any of these reports, the system prompts you to
enter the date you want to print as the "period ending" date.  This date
defaults to either the Easy Dental Plus system date, or the date of the
last transaction.  You can also modify this date with the Change
Accounting Date option, found on the main General Ledger menu.  

The General Ledger accounting date is independent of the system date,
and neither date affects the contents of any report.  All reports print
current information only, and prints the actual date in the upper
right-hand corner for a reference. 


~Chart of Accounts~

The Chart of Accounts is a listing of the different accounts you use. 
It lists the account number and description for all of your asset,
liability, equity, income, and expense accounts. 


~General Ledger~

The General Ledger Report lists all of your accounts and their
descriptions.  In addition, it includes a beginning balance for each
account, the detailed account activity for the month, and the current
balance for the account.


~Balance Sheet~

The Balance Sheet lists three of the five basic types of accounts.  It
includes the asset accounts, the liability accounts, and the equity
accounts.  Total assets should always equal total liabilities plus total
equity.  If total assets do not exceed total liabilities, then the
business has a negative net worth.

Minus signs (-) normally do not print on the Balance Sheet, with the
exception of asset depreciation accounts.  A minus sign on the Balance
Sheet generally indicates some abnormal situation or a mistake in your
accounting. 


~Income Statements~

Income Statements list two of the five basic types of accounts.  They
include the income accounts, and the expense accounts.  The Income
Statement adds the total income, and subtracts from it the total
expenses.  The difference is net income or net loss. 

Minus signs (-) normally do not print on the Income Statement.  A minus
sign on the Income Statement indicates some abnormal situation that
deserves immediate attention. 


~Budget Variance~

The system allows you to enter annual budget amounts for each income and
expense account.  Budget Variance reports compare the actual
year-to-date balances of each one of these accounts to the computed
year-to-date budget.  You can use this report to determine how well you
are controlling expenses. 

