@Ins
^Insurance Company Information

Insurance company information is simply a name and address.  Easy Dental
Plus needs this information when sending claims and other types of
correspondence to the insurance company.  You can operate Easy Dental
Plus without this information, but you will not be able to process
insurance claims. 

You should enter insurance company information only once.  You cannot
delete duplicate entries.  The only time you need to enter an insurance
company more than once is if you work with more than one of the
company's branch offices.  If you send your claims electronically, then
you do not need to enter branch offices.

The information that appears in Figure 78 does not need an
explanation, except for item #9, ~Electronic Claims ID~.  This field
appears when you customize the software to use electronic claims
processing.  This code uniquely identifies this insurance carrier, so
the electronic claims vendor can forward the claim to the correct
insurance company.  You will get this code from the List Of
Participating Insurance Carriers that you receive after signing up for
Electronic Claims Processing with your preferred vendor.

~A Carrier Type~ code is used to identify some carriers, such as Medicaid.
If this is the case, enter the two letter code instead of an ID.      

The default value for the Electronic Claims ID field is "MAIL."  You
will leave this field set to "MAIL" for all insurance companies that are
not currently supporting electronic claims. 



@Ins
^Sending Non-electronic claims electronically

Although an insurance company may not participate in electronic claims
processing, you can still send them an insurance claim electronically. 
The default designation "MAIL" signifies to the electronic claims vendor
that the vendor is to print and mail the claims to the insurance
company, instead of transmitting the claims electronically.  The vendor
will print and mail insurance claims for you.  The cost for this service
is comparable to electronic claims processing, and saves your office
staff time processing claims by hand.

~At the time of this writing, the charge for sending this type of
non-electronic claim to Envoy is comparable to an electronic claim.~

To send non-electronic claims electronically:

Select the coverage the insurance company is attached to.

You will need to go to the Employers/Coverages menu to modify the
coverage information.

Change the means of submission (option #6)  to "Electronic."

Easy Dental Plus sends the claim to the vendor electronically, even
though the insurance company itself will not accept electronic claims. 
However, when the vendor receives a claim for an insurance company that
does not currently support electronic claims, the vendor prints the
claim in their office and mails the printed form to the insurance
company.  Using this method, you can transmit all claims electronically
and let the vendor sort which ones to forward electronically, and which
ones to print and mail.    



@Cov
^Coverage Information

Individual and group coverages work in conjunction with insurance
companies.  An insurance coverage holds important information, such as
deductibles, maximum coverage, fee schedule name, payment schedule name,
and other important information needed to process the patient's
insurance claim.  A coverage may be a group coverage associated with an
employer, or an individual coverage for just one person.  

You cannot delete coverages.  Be sure to check for the existence of a
coverage before entering a new coverage.

Easy Dental Plus comes with one coverage already entered.  You should
select option 1 from the Coverage Menu to change the data for coverage
#1 so that data will be meaningful to you.

You should enter an employer as a coverage more than once only if
different employees within the same company have different coverage
benefits.  Easy Dental Plus assigns coverage numbers, beginning with #1. 
Every time you add a coverage, the program assigns the next available
number.  Once assigned, you can refer to the coverage by that number.  
With this design, you only select the coverage when adding a new patient
if you have already entered the coverage/insurance company.  The system
then knows that all information about the previously entered coverage
also applies to this patient.  

There is a form letter that you can print for your employers and/or
coverages.  It is a letter to ask the company to respond with their
latest benefits information.  This provides you with the means of
keeping up with current insurance coverage data for your patients.  You
may want to print this letter once or twice each year and mail it to the
different employers and coverage providers in your system.  

Refer to Patients with Insurance Coverage Letters for information about
patient coverage letters.


@Cov
^Coverage Information Fields (Screen #1)

~Employer/Coverage Name.~  For group coverages, enter the name of
the employer or HMO.  For individual coverages, enter a
description that allows you to refer to this coverage, such as
"Aetna Individual Coverage." 

~Contact Name.~  This is the name of the contact at the patient's
employer.

~Policy/Group Name and Number.~  This information is important to
have when filing insurance, particularly if you are filing
electronically.  You may obtain this from the patient's employer
or coverage.

~Insurance Company Number.~  Enter either the number or name of
the insurance company.  This information is necessary to print
insurance forms correctly.  

If you have not entered this coverage's insurance company into
the computer, you may press <Ins> while you are on this item to
display the insurance company entry screen.  After you add the
company, the program will put the company's assigned number into
the Insurance Company Number field for you.  

~Means of Submitting.~  This item only appears if you customize
the software for electronic claims submission.  Easy Dental Plus
asks you to select between mail, electronic, or both forms of
submission as the default for patients with this coverage.  If
you select electronic submission, you still are able to force
Easy Dental Plus to print paper claims for these patients when
you enter their treatment.  If you select both, the program
sends the claim electronically, and prints a form; however, the
form will have "Office Use Only" printed on it.   

~Insurance Form Number.~  There are five pre-designed insurance
forms you receive with your software that you can use to print
insurance claims:

~*ADA DP Form F1 (pre 1985)
*ADA DP Form F6
*AMA Health DP Fm F5
*New ADA Form F-L8 (Laser form)
*GF-Ins1 (Laser generated form)~

Most insurance companies will accept these forms; however, many
doctors see Medicaid patients and private insurance patients
whose insurance companies will not accept them.  For these
situations you have one of two choices: 

~*Customize your own insurance form.
*Request a customized form from DPI.~

Refer to Customizing Insurance Forms for information on how to
customize your own insurance forms.

~Calendar/Fiscal Year.~  You may specify whether the coverage
functions on a calendar or fiscal year basis.  This is a
reference field only and does not affect close month or close
year.  

~Dependent Coverage.~  The program uses this field to specify
whether the coverage is used for dependents.  This is a
reference field only and does not affect the patient's coverage.
 
~Phone Number.~  The phone number requested is for the coverage
or employer.  The phone number will default to your own area code
if you type seven digits.  You may enter ten digits for a
different area code.  You may also enter up to four additional
digits for an extension. 

~Miscellaneous Notes.~  This item is a place for you to enter
extra information that you want to print on an insurance form. 
You may enter up to 14 alphanumeric characters.     

~Fees to Bill Patient.~  Several doctors have HMO's with various
employers.  If you participate in any of these plans, you may
charge a different fee than you normally charge for private
patients.  If so, you may select a custom fee schedule.  If you
have not created the schedule you wish to use, you may create
one at this point.  This allows the system to create a duplicate
of the standard fee schedule that you can customize for this
coverage.  

Refer to Copying Fee Schedules for information on creating a
custom fee schedule.

~Group or Individual.~  The program uses this field to specify
whether the coverage is for a group or an individual.  Selecting
group displays the address fields.

~Address Information.~  This is the address of the
employer/coverage.  The program prints this information on an
insurance form.  The zip code may be either five or nine digits
in length.



@Cov
^Coverage Information Fields (Screen #2)

~Uses Payment Schedule/Schedule Name.~  If the insurance company
pays only specific dollar amounts for treatment, you will want
to use a payment schedule.  If you indicate "Yes" then field #2,
Schedule Name, becomes visible.  A pop-up box will appear that
lists currently existing payment schedules, if any, and an
option to create a new schedule.   If using coverage
percentages, you may also use a fee schedule in conjunction with
this. 

Refer to Create a New Payment Schedule for information on
creating a payment schedule.

~Coverage percentages are not applicable when using payment
schedules.~

If you set your maximums to zero, then Easy Dental Plus assumes
the patient does not have any coverage remaining for the year.

Deductibles are applied when you enter treatment that is either
preventative or orthodontic in nature.

~% Coverage.~  You may enter the percentage of coverage for three
types of coverage.  The procedure menu allows you to classify
each procedure as Basic, Major, Preventive, or Ortho.  These
fields are important for an accurate estimation of how much Easy
Dental Plus expects the insurance company to pay.   

~Maximums.~  This is the amount of coverage that an individual
patient has per year or lifetime.

~Maximums and Deductibles.~  You may specify that deductibles and
maximum are applied to an individual or for the entire family.

~Coverage Maximum.~  This is the total amount of coverage
available.  

~Ortho Maximum.~  This is the total amount of coverage available
for orthodontic procedures.

~Deductibles.~  You have two types of deductibles, preventive and
ortho.  This field accepts only whole numbers.

~Use ADA Categories to Figure Pay Amounts.~  Leaving this field
set to "No" allows you to enter the percentages for Basic,
Major, and Preventive.  Changing this field to "Yes" allows you
to enter percentages for the procedure type, such as Endodontics.


@Cov
^Adding a Coverage

Select "Add or Change Coverages."

The first information entry screen appears.

Enter the appropriate coverage information.

If you do not have all the information available, you may edit the
record later.  However, you must have a Employer/Coverage name and an
insurance company specified before you can save the record.

After entering the first screen's information, a second screen will
appear.

Enter the appropriate information for this screen.
When the cursor reaches the bottom of the screen, press
<Enter>.
Save your changes.



@Elec
^Electronic Claims Processing

If you wish to send your insurance claims electronically, you must
customize Easy Dental Plus to use electronic claims processing. 
Currently, there are two electronic claim vendors, Envoy and NEIC.  They
are customized in different ways; however,you must customize for
electronic claims using the Insurance Menu's option #10.

~You must customize for electronic claims processing, regardless of the
vendor you have chosen to handle your electronic claims.~



@Elec
^What is Electronic Claims?

Electronic claims are paperless insurance forms that you send to a
claims service, who in turn sends the information to the insurance
company.  You can send your electronic claims to the vendor by using a
modem.  Your computer can send the day's claims for you automatically at
any time, day or night.  Or, you may wish to send them during a certain
time of the day.  In either case, by the next morning the insurance
company is already processing your claims.  

The average turnaround time for receiving payments from an insurance
company that accepts electronic claims is seven to ten days.  There is a
small charge for each claim sent electronically; however, the saving in
postage, paper insurance forms, processing time, and your time outweighs
this charge.

Your computer will send all of the day's electronic claims directly to
your chosen electronic claims processing vendor.  The vendor will
inspect your claims and intercept any invalid ones.  The vendor will
inform you of any invalid claims the next time you send claims.  The
vendor then sends the good claims to the insurance companies for
immediate processing.

After the initial set up, you will find that transmitting your insurance
claims electronically will save you time and money.  The computer will
do most of the work for you.  



@Elec
^Customizing Options for Envoy

~Telephone number of Envoy's network.~  Envoy supplies you with this number.
Easy Dental Plus comes with the current number.

~Tone or Pulse.~  This will let your modem know whether to dial using
pulse or tone.  If your phone is tone, press T.  If your phone system
uses pulse dialing, press P.  The majority of phone systems use tone.

~Baud rate of your modem.~  Envoy supports baud rates (speeds) of 1200 and
2400.  You should press 2 to select 2400, or press 1 to select 1200.

Currently, only can only use Com1 and Com2 on your modem for electronic
claims.  If your computer has trouble releasing these comports for the
modem to use, check with your local hardware dealer for options.

~Communication port.~  When you install a modem, it will usually be on
communications port 1 (COM1).  However, if you have 2 communications
ports, you can set your modem to COM2.  Press 1 or 2 to select. 

~Transmit time.~  You can set up your system to wait until a specified
time to transmit your claims.  For example, if you want to transmit
every morning at 6:00 a.m. you would enter 600 for 6:00.  Enter the
transmit time in 24 hour format (military time).  If you want to
transmit immediately, enter an asterisk (*) instead of a time in this
field. 

~Login Name.~  Envoy assigns each provider who signs up for electronic
claims processing a Login Name.   You will enter the five letter code
here.  If more than one provider has signed up, you can change any of
the assigned login names here in order to send their electronic claims.

If you have chosen NEIC as your electronic claims vendor, enter "XXXXX"
as the login name.



@Elec
^Setting Up for Electronic Claims

After signing up with Envoy for electronic claims, Envoy will send you a
packet of information.  You need to enter this information into Easy
Dental Plus before you can begin to use electronic claims.

Fill out and mail the Envoy Electronic Claims Application Sheet to DPI.
They will return it in a few days with your Electronic ID code.

Purchase and install a modem.  You can buy a modem from Henry Schein,
Inc. or your local computer dealer.

Upon receiving your Startup Packet from Envoy, customize for electronic
claim using Customize Electronic Claims (option #10)on the Insurance
Menu.  Answer "Yes" to "Using Electronic Claims," and proceed into the
customizing screen.  You should only need to change Submit time and
Login Name.  You will get your login name from your Envoy Startup Packet.

Enter the supplied Provider Location # (also called a Site Code by Envoy)
into Easy Dental Plus.  You do this in Add/Change  Providers on the
Provider Menu.  While there, you need to makesure that the providers'
names follow these conventions: 

You can also send claims electronically to carriers that do not accept
electronic claims. 

If the provider's last name is not the last thing in the provider name
field, then a comma must follow the provider's last name.  

If the provider's name is now "John Doe DDS," then the program that
prepares electronic claims will believe that the last name is "DDS."  

If you change the name to "John Doe, DDS," then the program will
correctly pick "Doe" as the last name.

Print a list of your insurance companies to identify which ones
currently support electronic claims.  Use the Supported Carriers sheet
supplied with your Startup Packet for all carriers currently supporting
claims.  

For each carrier supported, enter the Insurance Company's Electronic ID
code (referred to as the Payor Identification Number by Envoy) or the
Carrier Type using the Add/Change Insurance Company option on the
Insurance Menu.  Almost all Payor Numbers end with "NOCD."  If the
carrier has a Carrier Type other than "01" or "13," then that carrier
has no Payor Number.  Instead, type that two-digit Carrier Type number
into the ID number space for that carrier.

Print a detailed listing of coverage/employers and identify which
coverages are using insurance companies that support electronic claims.

Using "Add/Change Coverage" on the Coverages/Employers Menu, select
"Electronic" or "Both" for the means of submission.  Selecting "Both"
allows you to print a paper claim in addition to the electronic claim. 
This printed claim is for your records only.  Do not send it to the
insurance company.

When you enter treatment for patients that work for these coverages, the
program creates an electronic claim instead of a paper claim.  You can
also force an electronic claim to paper if the insurance company
requires you to send something other than the claim information, such as
x-rays.  You would then mail the form and x-rays together.  

Unlike other places, errors in entering treatment may result in a claim
being rejected by Envoy.  Make sure that all codes you are entering are
Standard ADA Codes and that the tooth, surface or quadrant fields are
valid.

When processing claims electronically the NEIC screen will appear first,
even though you do not use NEIC as a claims vendor.

After accumulating electronic claims, you will go to the Insurance Menu
and use Electronic Claims Processing (option #5) to send the claims. 
You can see the number of claims to send at the top of the screen.  For
automatic processing use the first listed option, "Automatic Claims
Processing."  

Do not be surprised if you encounter errors the first few times.  You
must make sure your information is valid, such as birthdays, social
security numbers, and insurance group ID's.  All you need to do is go to
the appropriate menu and fix the named problem.  When finished repairing
any problems, return and retry sending the claims.



@Elec
^NEIC Electronic Claims

NEIC electronic claims processing is very similar to the process to
submit claims to Envoy.  In fact, the process is the same up until you
begin transmitting your claims.  It is at this time that NEIC takes over
the process.  If you customize your software to use both Envoy and NEIC,
Easy Dental Plus transmits both sets of claims at the same time.  The
program transmits NEIC claims first, then Envoy claims.



@Elec
^Signing Up With NEIC

Each individual dental practice must sign up with NEIC in order to use
their electronic claims service.  Call or write Henry Schein, Inc. for
an information packet and enrollment form if you wish to submit claims
electronically to NEIC. 



@Elec
^Configuring NEIC

The first time you send claims to NEIC, you may need to configure the
program.  Normally, when sending claims to NEIC you would pause at the
transmission screen (Figure 82) and wait until the program submits the
claims.  However, since you are configuring your system, press <F10> to
pull up the configuration screen (Figure 83).

Although you may pause at the screen seen in Figure 82 and wait a few
seconds for the claims transmission to begin, you may press <Enter> to
begin to transmit immediately.

~Activate Claims Network?~  This option activates the NEIC claims program.
Change this option to "Y" to submit claims to NEIC. 

~COM Port Information.~  This section has several fields you need to
change to fit your particular modem.  See your modem manual for these
settings.

~Port Number.~  This corresponds to the communication port your modem is
using.  Make sure that your modem's com port setting is the same as the
com port you are using.

~Modem Init String.~  The initialization string is necessary for the modem
to communicate with NEIC's modem.  Check your modem manual for the
initialization string that will work best for your particular modem.

~Baud Rate.~  The baud rate is the speed at which the modem can send and
receive data.  Although you can set this as high as 9600 baud, the
setting for this should be 2400.

~Parity, Data Bits, Stop Bits.~  Set this to "N-8-1."

~Call Retry Count.~  Set this to the number of times you wish the program
to attempt to transmit.  This is important if the NEIC number is busy
and you do not wish to stand around and manually attempt to transmit
continually until the line is available.   

~Delay Between Retries.~  This is the number of minutes you wish to wait
between attempts to submit your claims.  

~Phone Number.~  This is the local number to NEIC.  When you complete the
enrollment process, NEIC will send you a listing of local phone numbers
to use.

~Logon ID.~  HSI assigns this identification number.  The user should not
change it.

~User ID.~  HSI assigns this identification number.  The user should not
change it.

~User Password.~  The user password comes set to CLIENT when you first
enroll with NEIC.  The user can change this password if the user wishes
to use a different password than the one assigned.  See New User
Password below.

~New User Password.~  If you wish to change your current password, you may
do so by typing in a new password at this prompt.  NEIC updates the User
Password field after you transmit your next insurance claim batch.

~Call Time.~  You can specify the time you wish to submit your electronic
claims automatically to NEIC.  You must initiate the process by
selecting Transmit All Prepared Claims from the electronic claims
processing menu.  

~Leaving this field blank allows you to call at anytime.~

If you are using NEIC exclusively, then you will need to change your
Envoy login name to "XXXXX."  This will indicate to Easy Dental Plus that
you wish to use only NEIC for your electronic claims processing. 

~The login name is found in the Insurance Menu, option #10.~

~Change Destination Codes.~  This option allows you to add, delete, or
edit the carrier information.  By changing this option to "Y" you are
able to change the insurance carrier identification codes.  If the
carrier is on this list then Easy Dental Plus transmits the insurance
claims to NEIC.  If the carrier is not on the list Easy Dental Plus
transmits the insurance claims to Envoy.

To change these fields:

Use the arrow keys to select the code you wish to edit.
At the field you wish to change, type in the changes, then press
<Enter>.

To add an entry:

Press your down arrow key until you get to the line below the last
entry.  
Type the carrier identification code, then press <Enter>.
Type in the sub-identification code, then press <Enter>.
Type in the carrier name, then press <Enter>.
Move the cursor to the carrier identification field to add another
entry.

To delete an entry:

Move the cursor to the entry you wish to delete.
Press <Del>.



@Elec
^Hints About Electronic Claims

~Employee Identification Number.~  Some carriers require this number for
claims.  If this is the case, you need to go to Add or Change a Patient
on the Patient Menu and go to the second screen.  In the Misc. Note 3
field type I# followed by the employee ID number.

~Questions asked in Enter Treatment.~  The following is a list of
questions the program asks when entering treatment.  A few of these
questions need further explanation:

~Do you want to suppress SIGNATURE ON FILE?
Is treatment result of occupational illness or injury? 
Is treatment result of auto accident? 
Is treatment result of other accident? 
Is treatment for orthodontics? 
Treatment months remaining? 
Diagnosis #1? 
Diagnosis #2? 
Place of service? 
Date that treatment began? 
Date appliances placed? 
Date of prior placement? 
Date of Illness or injury? 
Is this an emergency? 
Pre-Determination Number? 
Pre-Determination Number Type? 
Is treatment the result of EPSDT screening? 
Prior Benefit Authorization Type? 
Referring Physician ID? 
Diagnosis Codes and Coding Method?
Is patient a full-time student? If full-time student:  School
Name, City, State?~

Be sure to use a comma to separate ~School Name, City, and State~.  These
are three separate fields when converted into an electronic claim.  You
must separate them by a comma in order to convert properly.     

Easy Dental Plus uses ~Diagnosis #1 and #2~ together for what Envoy calls
the "Claim Narrative."  This is a short explanation of the work you
entered, and is sometimes accepted in the place of routine X-Rays.

~Is This An Emergency?~  This is used to determine the type of service
required by some Medicaid coverages.  If this is "No," then the program
considers the type of service Preventive, if all treatment entered is
Preventive.  Otherwise, it considers the service as regular service.

~Prior Benefit Authorization Type?~  Easy Dental Plus uses only the first
letter.  Some Delta carriers may require this.

~Diagnosis Codes and Coding Method?~  Some Blue Shield carriers may
require this.  Enter the primary diagnosis code, followed by a comma,
the secondary code, a comma, and the coding method.  Example:  "123.45,
678.90, A ."

~If full-time student:  School Name, City, State?~  This field is
applicable if the patient is a full-time student.  This field can
consist of up to 20 characters, so abbreviations are necessary in order
to give complete information.  Example:  Dmnd-Hill,F.Worth,TX.

~Getting Tooth, Surface and Quadrant to set properly.~  In the Procedures
Menu, make sure you set the Applies to Individual Tooth field correctly
for codes you use often.  If you set this to "Yes," when you enter this
code for treatment the program sets the Quadrant field of the electronic
claim to blanks.  If you set this to "No," then the program places the
Surface information in the Quadrant field, and sets the tooth and
surface to blanks. 




@Ins
^Processing Claims

Insurance claims have a cycle that you must complete if you are to
process claims correctly.  Skipping any part of the process can have a
definite effect on aging claims, submitting claims, and tracking claims. 
This cycle includes:

    ~*Generating a claim
    *Printing the claim, or marking it as a claim
    *Mailing or transmitting the claim
    *Receiving payment
    *Marking the insurance payment as final~

See Outstanding Claims Processing beginning on page 5-33 for information
on how to delete claims. 


@Ins
^Generating a claim

A claim is generated automatically for patients with insurance.  The
process begins when you enter treatment.  The only way that a claim is
not automatically generated is if you indicate to Easy Dental Plus you
do not want a claim generated.  You can indicate to the program this
intention when you enter treatment. 

Refer to General Description of Treatment Options on how to change
the generating a claim option.



@Ins
^Printing Insurance Claims

When entering treatment, you have the choice of generating an insurance
form.  If you accept the default answer of "Yes," a form is available
for printing or transmitting.  In order for the claim to be aged and/or
submitted, you must print or transmit the insurance form.


~Print Insurance Forms~

You can print both estimate and actual insurance claims onto an
insurance form using the Insurance Menu's option #4.  Easy  Dental Plus
generates the claim form when you enter treatment, when you repair an
insurance claim (both actual and estimate), or when you create a
pre-treatment estimate.  You cannot delete a claim form from this menu
option.   

You may print paper claims multiple times.     

If you see the message:  ~"There are no insurance forms to print!"~ you
have not entered treatment and saved the information for insurance. 
Also, this program does not process electronic insurance claims.  Use
option #5 of the Insurance Menu, "Electronic Claims Processing."

In addition, you can customize Easy Dental Plus to hold the secondary
claim until the insurance company has paid the primary claim.  The
program will not add to the secondary claim any new procedures if you
have printed the primary claim form.



@Ins
^Selecting Claims to Print

There are three methods you may use to print or reprint an insurance
form:  Unprinted Claims Listed, All Claims Listed, and Print All
Unprinted Paper Claims.  

~Unprinted Claims Listed.~  This option displays only unprinted paper
claims.  

~All Claims Listed.~  This option displays both unprinted and printed
paper claims.  You would use this option to reprint a paper claim.

~Print All Unprinted Paper Claims.~  This searches all of your paper
claims and selects all unprinted ones for printing.  You cannot select
individual claims to print using this option.

You can further define the type of claim you wish to print when choosing
either of the first two options.

~Select Claim Description.~  This allows you to print either the actual
insurance claim form, the estimated claim form, or both.

~Select Claims for Whom.~ This option allows you to select how to restrict
the listing of claims.  Your choices are:

    ~*All patients and insurance companies
    *Patient to be specified
    *Family to be specified
    *Insurance company to be specified
    *Claim number to be specified.~

If you wish to track your insurance claims, but your office does not
wish to handle the claims themselves, or you do not wish to print the
claim, you may mark the claims with a ~C~.  This allows the claim to age,
and also updates insurance company statistics.

~If you want to move quickly to the bottom of the long list of forms,
first press <Esc> which will take you to the bottom of the screen, and
then press  <Shift-Tab> which will take you directly to the last item on
the list.~

Skipping claims does not remove them from the unprinted claims list.



@Ins
^Selecting Individual Claims to Print

There are times when you selectively print insurance claims instead of
printing all of the unprinted claims, or you may wish to reprint an
individual insurance claim.  In either case, Easy Dental Plus gives you
the ability to selectively print claims.  You may even choose to print
either a primary claim, a secondary claim, or both.

When you have selected the types of claims to list, the program presents
a screen similar to that shown in Figure 86.  To select your claims you
will use one of five keys:  ~P, 1, 2, C, or <Space>.~

Pressing ~P~ selects both primary and secondary claims, if both are
available to print.  If there is just one claim to print, pressing P
causes either a ~1~ or ~2~ to appear, depending if the claim is a primary
claim (1) or a secondary claim (2).  Pressing 1 prints only the primary
claim, and pressing 2 prints the secondary claim.  Pressing ~C~ marks the
selection as an insurance claim.  If you mark a claim incorrectly, press
~<Space>~ to correct the mistake.



@Ins
^Printing Insurance Forms

Once you have selected the claims to print, or have elected to print all
unprinted claims, you have the opportunity to print your claims, or skip
claims that you do not wish to print.

The system is ready to print all selected forms on the insurance form
listed.   If you do not have the listed form, and want to skip printing
the listed form, select "Skip" by pressing ~S <Enter>~, and the program
will go on to the next form.

If you have selected claims using another form type, after you finish
printing the current claims, the computer will "beep" to alert you that
it is ready.  The program again prompts you to ~"Print"~ or ~"Skip"~ the
next form.

~Lineups.~  Each time you print your insurance forms, or change the form
type while printing, Easy Dental Plus asks you to perform a lineup.  You
need this to align the form properly on the printer.  Take as many
lineups as you need to get your form aligned, adjusting the form in the
printer until the X's print in the proper boxes.  Upon finishing with
lineups, the program prints all claims using the form name displayed.

~Stopping The Printing Process.~  While the forms are printing, the system
displays a small window asking you to "Please wait."  The system also
shows you which patient's claim is printing at the current time, and
which form it is printing on.  If you need to cancel, you can press
<Esc>.  After the current form has finished printing, the program will
stop.  

If you are printing on a network, pressing <Esc> will not immediately
stop printing.  Refer to your network documentation on how to stop
printing on a network.

~Labels.~  After you print all the selected forms, you may print the
labels for the insurance claims printed.  You may print up to 99 labels
per claim.



@Elec
^Electronic Claims Processing

This is your daily electronic claims processing program.  You will use
it to view, prepare, and submit electronic claims.  You must, however,
customize Easy Dental Plus for electronic claims processing.

Which vendor you transmit to depends on your electronic claims
customization.  Refer to Electronic Claims Processing for setting
up electronic claims.

If you customize to send claims at a certain time, the computer will
wait until that time to transmit; therefore, you will want to select
this option at the end of the day.



@Elec
^How electronic claims work

Processing electronic claims is very similar to processing paper claims. 
The only difference is the format.  The processing of an electronic
claim is the same as printing a paper claim.  The transmission of an
electronic claim is the same as mailing a paper claim.

After you enter treatment for patients whose insurance carriers accept
electronic claims, you need to prepare and transmit the claims.  When
you prepare a claim, you are scanning the claim to verify that all of
the information that the insurance company needs is in the correct
format.  Examples are the patient's social security number or birthdate,
or the insurance coverage group identification number.  Easy Dental Plus
places the claim in a claim file that you transmit.

You can always tell how many claims you have entered and have not
prepared by looking at the first line on the screen shown in Figure 87:
"Number of Claims Entered and Not Prepared."  Just below that number
you will see  "Number of Claims Prepared and Not Sent."  This number
indicates how many claims you prepared and are ready to send.

Transmitting a claim is the step that actually uses the phone line to
send the prepared claims to the insurance company.  Easy Dental Plus
will execute the communications program that dials and connects to the
computer at Envoy or NEIC, and then send all of the claims that you have
prepared. 

After transmitting the batch of claims, the electronic claim vendor
uploads the Acceptance/Rejection Report that indicates the status of the
claims from the previous transmission.  From this report you will see
which of your claims the insurance company accepted.

If you are tracking outstanding claims (actual and estimates claims),
you will see a third number at the top of the screen:  "Number of Claims
Sent and Not Reported."  This tells you how many claims you have sent to
the electronic claims vendor that have not been reported on the report.



@Elec
^Automatic Electronic Claims Processing

You can perform all of the steps, mentioned in How electronic claims work,
automatically by selecting "Automatic Electronic Claim Transmission."
It will first prepare all claims, then proceed to transmitting, and
finally print the claim acceptance/rejection report, if one is available.
If there are any invalid claims, the automatic processing stops to allow
you to correct them.  After fixing the problems, you can return to Automatic
Electronic Claim Transmission.  



@Elec
^Select Claims to Prepare

Selecting the electronic claims you wish to print is the same process as
selecting a paper claim.  The only difference is you cannot mark a claim
with the C option.  In this case, to eliminate an electronic claim you
must force it to paper (Force Claims to Paper).

If you send claims to both Envoy and NEIC, claims will first be sent to
NEIC.  



@Elec
^Preparing Electronic Claims

After selecting individual claims, the program checks all selected
claims for validity, and puts the claim into a file of claims that you
are ready to transmit.  This step catches most errors so you can correct
them before transmission.  This is important because 1) the claim vendor
will charge you for a claim they accept or reject, and 2) you will have
to fix a rejected claim and resend it in the next batch.

If the claim preparation program detects an error, it pauses to let you
record the patient and the error.  If you find errors in more than one
claim, then the program pauses once for each error.  Easy Dental Plus
detects only one error at a time in each claim.  You may have to prepare
claims several times in order to detect and correct all errors.  Once
you transmit an error-free claim for a patient, all subsequent claims
for that patient should be error free, taking very little time to
process.



@Elec
^Transmitting Prepared Claims

Once you successfully prepare your claims, you are ready to transmit the
claims to the electronic claims vendor.  Easy Dental Plus will execute
the vendor's communications program, attempt to initiate the call, send
the claims, and pick up the previous batch's Acceptance/Rejection
Report.  Your computer cannot do anything else in the interim, so
transmitting will usually be the last thing you do before you leave for
the day.  

If you do not use NEIC, the NEIC submission screen will still appear
before you transmit to Envoy.  You can do one of two things:

    *Press <Enter> to immediately go to the Envoy transmission program, or

    *Wait approximately 15 seconds for the program to initiate the Envoy
    transmission.

~Transmission time.~  You can customize electronic claims submission to
transmit your prepared claims at a prearranged time.  To transmit your
claims at the prearranged time: 


Select "Transmit All Prepared Claims."
When you start the transmission process, turn off your monitor.

~Turning off your monitor while waiting to transmit electronic claims
will reduce your electrical costs.~

When you get back the next morning, Easy Dental Plus has transmitted the
claims and the Acceptance/Rejection Report is ready to print.  If you do
not have any claims to transmit and you select the transmit option, you
will connect with the claims vendor, and you will receive the
Acceptance/Rejection Report, if one is available.



@Elec
^Acceptance/Rejection Report.

After the transmission is complete, the program prompts you:
"Print acceptance/rejection report? (Y/N)."  You should print the
report and keep it in a file with all other reports for the electronic
vendor.  If you are not able to print at this time, you can skip the
report; however, you cannot transmit again until you print the
Acceptance/Rejection Report.

~Claims listed as "rejected" on your report will be set back to
"unprinted" status.  This way you can make the required changes, if
possible, and resubmit the claim, or force it to paper and mail it.~



@Elec
^Force Claims to Paper

This option is useful if you enter treatment for a patient and have
since decided that you need the claim on paper.  The forced paper claim
will look almost exactly like a true paper claim.  The only difference
is in place of "Signature on File" the phrase "For office use only"
appears.  If you do not wish this phrase to appear on the insurance
form, you need to force the claim to paper at the time of entering
treatment. 

You cannot force to paper ~prepared~ electronic claims.  You can only
force unprepared claims.



@Elec
^Submitting Claims to NEIC

The process for submitting claims to NEIC is identical to transmitting
claims to Envoy.  The differences are in the program's execution, and
does not require any new steps for the user to accomplish in order to
send electronic claims to NEIC. 

~If you are using NEIC exclusively, then you will need to change your
Envoy login name to "XXXXX."  This indicates to Easy Dental Plus that you
wish to use only NEIC for your electronic claims processing.  You can
find this option in the Insurance Menu, option #10.~

To submit electronic claims to NEIC:

Select "Transmit All Prepared Claims."
At this moment you will wait for the communication process to begin, or
press <Enter> to begin immediately.

If you had customized the NEIC network to transmit at a particular time,
you may want to turn off your monitor to prevent screen burn-in.  Once
the computer clock reaches the transmission time, the process begins.

Once the communication process begins, you will see your computer
communicating with NEIC.

If you are using both Envoy and NEIC to transmits claims electronically,
after you transmit the claims to NEIC, the program transmits claims to
Envoy.  If there are no claims ready to send to Envoy, then your
transmission session will end here.  

After the communication process has ended, the program prompts you to
print the Acceptance/Rejection Report.  To do so, press Y.

You cannot transmit again without printing the acceptance/rejection
report.  It is best to print this report at this time.



@Elec
^Errors Encountered While Preparing Electronic Claims

There are several "errors" that may occur while preparing a claim for
electronic submission.  The following is a list of these errors, their
cause, and the steps to take to fix them.


~Patient Errors~

These errors concern the patient who received the treatment. They are:

    *Patient First Name
    *Patient Last Name
    *Patient Address
    *Patient City, State, Zip
    *Patient Date of Birth
    *Patient Sex
    *Patient Phone Number.


Go to the program "Add a New Patient or Change Patient's Records" on the
Patient Menu to fix these.  If the error occurred in a name, check to
see that the name is at least one letter, and that no quotation marks or
dashes appear in the name.  If it is the address, then check to see if
you filled out the address.  If it is in City, State, Zip, then make
sure you have filled out these fields, and the city and state do not
have any numbers in them.  If it is Date of Birth, it means that the
date is blank.

Refer to Adding/Changing Patient Records for information on
changing patient information.


~Patient Providing Insurance Errors~

These errors concern the patient who is providing the insurance
coverage.  They are:

    *Pat Prov Ins Last Name
    *Pat Prov Ins First Name
    *Pat Prov Ins Social Security
    *Pat Prov Ins Date of Birth
    *Pat Prov Ins Address
    *Pat Prov Ins City, State, Zip
    *Pat Prov Ins Phone Number.

If the error occurred in a name, check for dashes or quotation marks in
the name.  If the error occurred in the Social Security Number, Date of
Birth, or Address, check to make sure you have filled out these fields. 
An error in City, State, Zip could mean that you have not filled out
these fields, or that something other than letters appears in the City
or State field. 

Refer to Insurance Company Information for information on
changing insurance company information.


~Practice Error~

There is only one possible practice error:  Practice Phone.  If it
occurs, just go to the Utility Menu program and select "Change Doctor's
Address and Phone Number" to make sure you have filled out the phone
number. 

Refer to Change Doctor's Address for information on changing the
practice information.


~Provider Errors~

These errors concern the patient's preferred doctor.  They are:

    *Provider Name
    *Provider Address
    *Provider City, State, Zip
    *Provider Tax ID/SSN
    *Provider License Number
    *Provider Tax ID/SSN Determinator
    *Provider Specialty Code
    *Provider Location (Site Code)
    *Provider Medicaid Number
    *Provider Blue Shield Number
    *Provider Delta Number.

Go to the Provider Menu program "Add/Change Provider Information" to fix
these.  If the error is in Address, City, State, Zip, Specialty Code, or
Tax ID/SSN Determinator, check to make sure you have filled out these
fields.  License Number and Tax ID/SSN should each be nine (9)
characters in length.  If the error occurs in the name, make sure the
provider's name follows the convention described in
Setting Up for Electronic Claims.  If the error is in Provider Location
(Site Code), you must go to the Provider Menu and fill in the Provider
Location with the four character Site Code given to you by Envoy.

Also, refer to Provider Fields Defined for more information.


~Coverage/Employer Errors~

These errors concern the patient providing insurance coverage/employer
information.  They are:

    *Coverage/Employer Name
    *Coverage Group/Employer Number
    *Coverage/Employer Address
    *Coverage/Employer City, State, Zip
    *Coverage/Employer Plan Name.

You fix these errors in the Coverages/Employers Menu program "Add/Change
Coverage."  If the error is in Group Number, make sure that the group
number is at least five characters in length and that only letters and
numbers are in it.  If the error is in one of the other items, make sure
that only letters appear in the name, city and state; only numbers in
the zip code; and that only letters and numbers appear in the rest;
these items can be blank if you wish.  ~Addresses may contain such
characters as "#", "/", etc., but not "-".~

Refer to Coverage Information Fields (Screen #1) for more information.


~Insurance Company Errors~

These errors concern the patient providing insurance insurance company
information.  They are:


    *Insurance Co Address
    *Insurance Co City, State  Zip.

If one of these errors occurs, make sure that these fields follow the
same conventions described for Coverages.

Refer to Insurance Company Information for more information.


~Referring Doctor Errors~

Referring Doctor First Name, Referring Doctor Last Name, Referring
Doctor State, Referring Doctor Tax ID.

Go to the Referring Doctor Menu to correct these errors.  Refer to
Adding a Referring Doctor for more information.



@Ins
^Outstanding Claims Processing

The life of a claim begins when you enter treatment for a patient who
has insurance.  It is at this time Easy Dental Plus generates the claim
that you can mail or electronically submit.  Although your claim may be
electronic, the claim's status is "unprinted."

If you print the form you create an outstanding claim.  If you send the
form electronically, then when you prepare the form for transmission you
create a pending electronic claim.  When you receive your
Acception/Rejection Report, the program changes the status of the
accepted pending electronic claims into outstanding claims.  The program
resets rejected pending claims to "unprinted" status.      

The life of the claim typically ends when you receive the insurance
check associated with that claim.  If you mark that claim as Final, the
program deletes the claim.  There is also a way to delete claims using
this program.  The life of a claim can also end when you pay off all
items on the claim.  The next time you close the month, Easy Dental Plus
automatically deletes the claim.

Refer to Entering Insurance Payments or Entering Bulk Payments
for information on making insurance payments

The provided "claim numbers" remain constant for the life of the claim. 
The first part of a claim number is the patient's account number, while
the second three digit number uniquely identifies this claim.



@Ins
^List Claims On Screen/Print Aged Report

Periodically you should print the ~Aged Insurance Claims~ report.  This
report lists any pending insurance claim, the age of the claim, the
procedures associated with the claim, the total amount of the claim, the
expected amount from insurance,  the amount already paid on the claim,
and the name of the insurance company that is handling the claim.

~Select claim description.~  The first question asks you to select the
claim description.  Your choices are:  

    ~*Estimate Claims Only
    *Actual Claims Only
    *Both Estimate and Actual Claims
    *Pending Electronic Claims Only
    *All Claims (default).~


~Select claims for whom?~  This question asks you if you want to limit the
claims that you can view.  This question asks if you just want to see
the claims belonging to a particular patient, family, insurance company,
or claim number.  This can be particularly useful if you plan on
printing a "Detailed" report.

~List only claims aged X days or more~.  At times, only very old claims
concern you, since these claims might indicate a problem with receiving
a payment.  Type in the age of the youngest claim you would like to view
or print.  If you want to look at all claims regardless of age, leave
this number as zero.  

~When you choose zero, unprinted claims are also included.  Any claim age
above that excludes unprinted claims, since Easy Dental Plus determines
the age of a claim from the date you printed the claim.~

~Detailed or Summary?~  If you choose ~Summary~ you will receive a report
with one claim listed per line, yielding about 60 claims per page.  The
program prints this report in condensed print because of the amount of
information the program prints per line.  If you choose ~Detailed~, you
receive all of the information that appears in the summary report, plus
each individual procedure associated with that claim.  Each claim can
have 9 lines or more printed, so this report will only yield four or
five claims per page.  

~If you have a large number of claims, you will probably want to limit
the number of claims listed using the prior questions.~



@Ins
^Delete Outstanding Claims/Estimates

Easy Dental Plus normally deletes outstanding claims when you mark an
insurance payment as final.  This does not always happen, especially if
you mark the insurance payment as a partial payment.  If this should
happen, you can delete the outstanding claim by using this utility.  

You can narrow your search for claims to delete by using the same
options used for viewing/printing the Aged Insurance Claims report. 
There are, however, two differences:

    ~*Claim Description can only be either Actual or Estimate.
    *Only a summary listing will appear.~

~If you wish to delete unprinted claims, change the minimum age of the
claim to zero.~

To mark a claim for deletion:

Press <Tab> until you reach the claim you want to delete.
Press D to mark the claim for deletion.
Continue this process until all claims you wish to delete have been
marked.
When finished marking your claims, press <Esc> to move to the bottom of
the screen.
Press <Enter>.

~If you mistakenly mark a claim, press <Space> to unmark the claim.~

When prompted to delete the marked claims, press <Enter>.


@Ins
^Alter Amount Expected from Insurance

Sometimes it is necessary to alter the insurance company's participation
amount.  This situation may occur when the insurance company makes a
change in its payment schedule for a particular set of procedures, or
because the patient's insurance coverage has run out.  In either case,
you can change the amount of participation from the insurance company
using this function. 

Easy Dental Plus automatically figures the amount the insurance company
should pay by adding up the insurance participation for each item on the
insurance claim form.  If any of the claim amounts are incorrect:

Press <Tab> or <Shift-Tab> until you are at the claim that you want to
adjust.
Enter the correct amount.
Continue this process until you adjust all the claims amounts you wish
to adjust.
When finished adjusting claim amounts, press <Esc> to move to the bottom
of the screen.
Save your changes as normal.



@Ins
^Repairing Insurance Claims

There are times when the insurance company does not accept a claim, or
you placed too many procedures on the claim and it needs to be separated
into two or more claims.  For these and other reasons Easy Dental Plus
gives you the ability to recreate and repair claims that can be sent to
the insurance company. 



@Ins
^Recreate and Print Actual Insurance Forms

This is strictly a printing program only.  This option allows you to
enter information as if you were entering treatment, and then print an
actual paper insurance form.  You should only use this if you cannot
reprint the actual claim.    

~This does not update files, and this will not send an Electronic Claim.~

The process for recreating an insurance claim resembles that of entering
treatment; however, this does not affect the patient's history or their
accounts receivable balance.  

For information on how to create an insurance claim, refer to
General Description of Treatment Options.


@Ins
^Create or Repair Insurance Claims

Whereas you use the Recreate and Print Actual Insurance Forms program to
reproduce an insurance claim that no longer exists, you use the Create
or Repair Insurance Claims program to fix problems with a patient's
insurance claim.

Some reasons for creating or repairing an insurance claim are:

    ~*You change the form type after you entered treatment.
    *You need to separate the procedures on the insurance claim into separate
    claims.
    *You need to combine the separate claims into one claim.
    *You need to change the answers to insurance questions.
    *You need to delete certain procedures from the claim form.
    *Certain procedures do not need to appear on the secondary coverage's
    insurance claim form, or do not need to appear on the primary coverage's
    insurance form.~


~Claim types that can be repaired~

You can repair both actual and pre-treatment estimate claims using this
utility.  Additionally, you can choose to change only the answers to the
insurance questions.  You can select these options by pressing ~A~ for
actual insurance claims, ~E~ for pre-treatment estimates, or ~Q~ for
insurance questions.


@Ins
^Repairing Insurance Questions

If you wish to only repair insurance questions, a pop-up window similar
to Figure 88 appears.  You have the option of choosing a claim whose
insurance answers need changing.  Select the claim by its claim number,
then a listing of questions will appear.  You may then select different
answers to these questions.


@Ins
^Repairing An Estimated or Actual Claim

If you are repairing an estimate or actual claim, the program displays a
screen similar to the one seen in Figure 89.  This screen tells you
several things.  First, you can tell that John Q. Public has two
outstanding claims presently, which are claim numbers 001 and 002. 
Since the program lists Mr. Public's patient number as 00018, the
Outstanding Claims Report lists these claims as claim numbers 00018-001
and 00018-002.  All the procedures seen in Figure 89 will print on both
primary and secondary insurance forms because the program has marked the
last two columns with "Yes" answers.  Also, not all the procedures are
on the same claim.  The first four procedures are part of claim number
001.  You can do several things at this point:  

~Remove a procedure from a claim.~  If you wish to remove an item from a
claim, move to that claim using your up or down arrow keys, and press
<Space>.  

~Add a procedure to a claim.~  If you wish to add an item to a claim, move
to it and enter the number of that claim.  For example, you can change
Complete Lower from claim 001 to 002 by typing a ~2~ next to the
procedure.

~Create a new claim.~  If you forgot to create a claim, or you need to
remove all the procedures so you can place them on a new form type, you
can create it here by moving your cursor to each item, then press ~C~ to
create a new claim.  

~If you create a new claim you are removing procedures from the old claim
number and putting them on a new claim number.  The old claim number now
has no procedures attached to it.  It is essentially a blank insurance
form.  When this occurs, the program prompts you to delete this claim. 
You should delete the empty claim.  If not, the claim will remain on the
list to print, even though there will not be any procedures on it to
print.~

~Specify a procedure to not print on a claim.~  If there is a procedure
that you do not want printed on an insurance form:

Move to that procedure
Press <Tab> to move to the Prim. Print? or Sec. Print? columns.
You may press Y or N to flag a procedure appropriately.


@Ins
^Insurance Company Inquiry

The information displayed is the insurance company's name, address,
contact name, and electronic claims identification number.  In addition
to this information, the program displays four additional fields.

~$ Amount Submitted~ is the total dollar amount of all actual claims
submitted to this insurance company for all patients this year.  

~$ Amount Received~ is the total insurance payments received for all
patients from this insurance company this year.  

~# Claims Submitted~ is the total number of claims submitted to this
insurance company for all patients for the current year.  

~# Payments Received~ is the total number of payments received from this
company this year. 

~The program updates the $ Amount Submitted field and the # Claims
Submitted field when you either print or mark a claim.  The program
updates the $ Amount Received field and # Payments Received field when
you receive a payment and mark it as an insurance payment.~


@Cov
^Coverage Inquiry

The information displayed in the coverage inquiry is the same
information as entered for the coverage/employer you wish to view. 
Refer to Coverage Information Fields (Screen #1) and
Coverage Information Fields (Screen #2) for the information displayed.

You may also access the coverage information by pressing <F6> from
virtually anywhere in Easy Dental Plus.


@Ins
^Print Insurance Alphabetical List

After selecting Alphabetical List, the program gives you two options:

    ~*Print a short list, which includes the insurance company's name and city
    on one line.
    *Print a long list, which includes the company name, street address, the
    city, state, zip code, the name of the contact person and phone number
    on three or four lines.~

After selecting the list type, the program sorts the stored information
and displays it on the screen.  To print this list, press <Enter> while
the program displays the list.


@Ins
^Print Insurance Mailing Labels

Printing labels for insurance companies is a simple process.  All that
is necessary is to enter the appropriate numbers in the fields presented
in Figure 90.  

To print labels for your insurance companies:

Enter the first insurance company number you wish to print.
Enter the last insurance company number you wish to print.
Enter up to 99 labels to print.
Perform a lineup.
Print your labels.

The program prints each insurance company label the number of times
specified in the last question before printing the next insurance
company.


@Cov
^Print Coverage/Employer Alphabetical List

There are two types of lists you can print:

    ~*A short list, which prints the name and phone number of the coverage,
    along with their associated insurance company's name and number.
    *A long list, which prints all the information about the coverage,
    including the name, phone number, insurance company, the insurance
    company number, the amount of coverage, and deductibles.~



@Cov
^Print Coverage/Employer Rolodex Cards

If you like to maintain a rolodex card file of coverages, choose option
#4 from the Coverage Menu.  This program allows you to print a rolodex
card for each coverage in the system.  

~The program requires continuous 3" x 5" rolodex cards.  You can obtain
these cards from Henry Schein, Inc..~

To print rolodex cards for your coverages:

Enter the first coverage number to print.
Enter the last coverage number to print.
Perform a lineup.
Print your rolodex cards.


@Cov
^Print Coverage/Employer Mailing Labels

The process for printing coverage mailing labels is the same for
printing insurance company labels.

Refer to Print Insurance Mailing Labels for information on how
to print labels.


@Ins
^Customizing Insurance Forms

There are many steps to follow when you customize an insurance form. 
This section is divided into four parts:

     ~*Form Preparation
     *Defining Questions and Constants
     *Lineup Information
     *Placing Insurance Information~

Each part has several steps to accomplish as you design your custom
insurance form.  Skipping any of these steps can cause problems later
on.  You must verify that you have accomplished each step before moving
on to the next.


@Ins
^Form Preparation

Before you begin creating your custom insurance form, you must have a
method of identifying where you are to place information on the form. 
You can accomplish this in one of two ways:

     ~Print a row/column grid on an insurance form.
     Use a ruler to find your rows and columns on the form.~


@Ins
^Step One:  Find your coordinates

~Row/Column Grid Method~

To find the correct coordinates you can print a row/column grid on your
insurance form.  What this does is print a row of numbers from 1 to 0
(10) on the top line of the form, a column of numbers from 3 to 60 in
the first (left) column, and fills the remaining rows and columns with X
marks.  You then use the top and left numbers to determine the exact
location of where you want an item to print on the insurance form (X
marks the spot!).

Do NOT start the grid on the very top row of the form.

~When using the ruler method, be sure to start at the first line that is
to contain printed information.~ Do not start at the top row of the
form.

~Laser forms must use row/column grid for best accuracy.~


To print a row/column grid:

From the Insurance menu select 9.  Generate Custom Insurance Form.
Select Print a Row/Column Grid on Form.
Insert a blank continuous feed insurance form into the printer, and
position the print head on the first row you want to print insurance
information. 
When prompted "PRINT alignment grid, or CANCEL," press <Enter>.

The printer prints a grid on your insurance form.


~Ruler Method~

Another way you can find the correct coordinates for your custom
insurance form is to use a ruler that has both horizontal and vertical
page measurements.  The horizontal measure has a scale of 10 characters
per inch,  and the vertical measure has a scale of 6 lines per inch. 
Using this type of ruler, you can easily find the coordinates for your
form items.

~You can find this type of ruler at most business supply stores.~


@Ins
^Defining Form Information

The next step in creating a custom insurance form is to define some
basic information for this form.  This basic information includes:

        ~*Constants
        *New insurance questions
        *The form's name and its measurements
        *Defining Constants~

A ~constant~ is any type of information that remains the same.  A
constant can be a number, a symbol, or even the doctor's tax identification
number.  You use a constant because you want that particular information
to stay the same on all insurance forms that you include the constant
on.  For example, if you have more than one provider in your office, and
you want the owner's tax identification number to appear on all
insurance forms, regardless of which provider performed the treatment,
then you can specify a the owner's tax identification number as a
constant.  Once defined, you can include on any insurance form you use
with Easy Dental Plus.


@Ins
^Defining a constant

To define a constant:

From the insurance menu select 9.  Generate Custom Insurance Form.

You see a pop-menu of five choices (Figure 60).

Select "Define Constants Available for All Forms."

You will see a screen similar to that shown in Figure 61.  The cursor
defaults to the top left-hand character:  $.  

Using your arrow keys, find a blank line that looks as though it is
large enough for the constant you wish to add.

As you use your arrow keys, you will notice the length of the highlight
bar changes as you move to the right column.  The further down and to
the right you move, the longer the constants (Figure 61).

When you find a long enough constant field, press <Enter>.

The constant entry field appears, similar to the one shown in Figure 62.

Type in the constant, then press <Enter>.

The program returns you to the constants screen, as seen in Figure 61. 
If you have more constants to enter, follow the previous steps.

Press <Esc>.
When prompted "Do you want to SAVE or CANCEL changes made to constants
(S/C)," press <Enter>.



@Ins
^Defining New Insurance Questions

When you create your own custom insurance forms, there may be questions
asked on the form that are not part of the set of insurance questions
that come with Easy Dental Plus.  If this is the case, you need to add
these questions.

The stock insurance questions that come with Easy Dental Plus are:

~Do you want to suppress SIGNATURE ON FILE?
Are x-rays being sent?
Is treatment result of occupational illness or injury?
Is treatment result of auto accident?
Is treatment result of other accident?
Are any services covered by another plan?
Is treatment for orthodontics?
Was laboratory work performed outside office?
Has patient ever had same or similar symptoms?
Is this an emergency?
Date appliances placed?
Date of prior placement?
Date of Illness or injury?
Date able to return to work?
Date of total disability (ending)?
Date of partial disability (beginning)?
Date of partial disability (ending)?
Give hospitalization date (beginning)?
Give hospitalization date (ending)?
Date of total disability (beginning)?
Date first consulted?
Date of service (beginning)?
Date of service (ending)?
Insured ID #?
Description of other accident?
Description of occupational illness or injury?
Description of automobile accident?
Reason for replacement of prosthesis?
Brief description of other plan?
Remarks?
Diagnosis #1?
Diagnosis #2?
Diagnosis #3?
Diagnosis #4?
Name/add. service performed?
Number of X-Rays?
Treatment months remaining?
number?~

To add a new insurance question:

From the insurance menu select 9.  Generate Custom Insurance Form.
Select Edit Insurance Question Text.

A screen similar to that shown in Figure 63 appears.

You will find there are several categories of insurance questions listed
with their abbreviations:

        ~Date~ -- Requires a date
        ~Dollar~ -- Requires a dollar amount
        ~FITB~ -- Fill in the blank
        ~Mult Ch~ -- Multiple Choice
        ~Number~ -- Requires a number
        ~Y/N~ -- Yes/No

Press <Tab> until you move to the first available line and category.
Type in your question.
Repeat the above steps for more questions.
When you have finished entering your questions, press <Esc>.
When prompted "Press <Tab> to make a change, <Enter> when finished,"
press <Enter>.
Save your changes.


@Ins
^Creating A New Insurance Form

In order for you to complete the remaining steps, you must now go into
the actual form creation process.  

From the Insurance menu select 9.  Generate Custom Insurance Form.

You will see the screen shown in Figure 60.

Select Create/Modify an Insurance Form Layout.

You will see the screen as seen in Figure 64.

Select Add A New Form.

You will then see the screen as shown in Figure 65.  All references to
the remaining steps begin from this screen.

Warning:  Once you begin creating a form, it is best to limit the
number of times you save the form.  If you continually edit and save
the form, the possibility of you corrupting the form increases.  For
best results, only save your data when prompted to do so by the
instructions.


@Ins
^Defining Form Name and Measurements

The next step is to define your form name and measurements.

~Form Name.~  Give your form a name that best describes it, such as Blue
Cross/Shield.  You may enter up to 20 alphanumeric characters.

~Total Length of Form (In Lines).~  This is the number of lines from the
top edge to the bottom edge of the form.  An 11" form is 66 lines in
length, based on 6 lines per inch.  The default value for this field is
66.

~First Line of Procedure Listing Section.~  The number required here is
the vertical coordinate of where the procedure listing begins.  You can
find this from your row/column grid, or by using your ruler.  You
determine this number by measuring from the form's first printed line.

~Total Lines Available for Procedure Listing Section.~  You determine
this number by counting the available lines.

You may not wish to print the entire procedure code description.  If
this is the case,  then enter a figure that would permit less of the
description to print.

~Minimum Lines Taken Up By One Procedure.~  The number of lines
requested here is 1.  Unless your insurance form specifically divides the
procedure information into multiple lines, then this should remain at 1.

~Maximum Number Of Extra Description Lines.~  The length of the
description determines this number.  Procedure code descriptions do not
exceed 80 characters.  To determine the number of extra description
lines, measure across that particular section of the form.  Divide the
number 80 by the number of spaces you count to find the number of extra
description lines.

~Want this form printed in all Upper Case.~  Although Easy Dental Plus
stores the information in mixed case, you can specify to print all of
your information in upper case.

~Remove all Non-AlphaNumerics.~  You can prohibit non alphanumeric
characters from printing on the insurance form.  Non-alphanumeric
characters include "-", "/", ".", as well as other similar characters.

~Dollar Format.~  You can specify how the program prints dollar amounts
on the insurance form.  The default value for this field is "$$$$.."
Other values you may choose from are "$$$$ " and "$$$$."

~Number of Copies (Laser Printers Only).~  You may set your laser
printer to print multiple copies of your insurance forms.  The extra forms
function as a carbon copy of the original.  You may specify from 1 to 99
copies.  The default value is 2.

~If you do not wish to print multiple copies, set this field to 1.~

~Generate Laser form (Laser Printers Only).~  This option allows you to
generate the entire insurance form on the laser printer.  DPI reserves
this option to custom designed forms from DPI.


@Ins
^Entering Data Field Information

The following steps are repetitive in nature.  You must perform these
steps multiple times in order to select all of your data fields for your
custom insurance form.  The steps you are to take are:

        Select Questions To Be Asked When Entering Treatment
        Listing Questions
        Selecting Items to Print on form
        Saving the form
        Viewing Items on Form
        Print a Test Form/Lineup
        
~You can find a listing of the available data fields in Appendix A.~



@Ins
^Selecting Questions To Be Asked When Entering Treatment

These are the questions that appear when you enter patient treatment. 
If you do not specify any questions here, no questions appear when you
enter patient treatment.

Choose "Select Questions To Be Asked When Entering Treatment."

     The screen shown in Figure 67 appears.

Select the type of question you wish to include on the insurance form.

When you choose a question type, a screen similar to that shown in
Figure 68 appears.

Highlight the question you want to use, then press <Enter>.

Lines that contain "yn#" where "#" is a number, are placeholders for
questions you define.  Refer to Defining New Insurance Questions
for information on defining questions.

~Unlike many lists, you cannot print this list of data fields.~

When prompted "Do you want to ask this question for insurance?" press
<Enter> (Figure 68).

You will be taken back to a screen similar to that show in Figure 67.   

Continue the above steps for the remaining questions.


@Ins
^Viewing Your Questions List

When you have finished selecting the questions that you wish to ask when
entering treatment, you should check to be sure you have not left out
any questions.  To do this:

Select "List Questions To Be Asked When Entering Treatment."

The program displays the questions you have selected to ask when
entering treatment (Figure 70).

If there is more than screen's worth of questions, you may use your
arrow keys or <PgUp> <PgDn> keys to view the remaining questions.

Press <Esc> to return to the previous menu.



@Ins
^Selecting Items to Print on Form

Once you have selected the questions to ask when you enter treatment,
you are ready to specify the fields that you wish to print on the
insurance form.  There are some restrictions for specifying your data
fields:

There must be a data field specified in row one of the insurance form. 
You must select at least one item to print in row #1 for both the lineup
form and for the actual form.  If you design your form without anything
on row one, then you must enter something to print on the form with a
length of 0, on both the actual and lineup versions of the form.

~Row #1 is the first row where the program prints information.  This
does not mean this is the very top of the form.~

You must specify at least one field specified on the first line (row)
where you list the procedures codes.  This may be a procedure code
number, procedure description, or tooth/surface field.

You must specify at least one field specified below the procedure
description area.  This may be the total fee charged, the percentage of
coverage, total payment, or any of the available fields below the
procedure section.

To select the items to put on your insurance form:

Choose "Select Items To Print On Form."

The screen shown in Figure 71 appears.

Select a data field category.

A listing of data fields, similar to that shown in Figure 72, appears.

Using your arrow keys, move to the data field you wish to include.
Press <Enter>.

Be sure you have entered a data field for the first line of the form, a
data field for the first line of the procedure section, and a data field
for the section below the procedure section.  If you do not do this, you
can corrupt your form.

The screen shown in Figure 73 appears.

Enter the row, column, and maximum character information.

~Row.~   The row number determines where the information starts printing
vertically on the form.  

~Column.~  The column number determines where the information starts
printing horizontally on the form.

~Maximum Characters to Print.~  This number determines how many Xs the
program prints on the lineup.  You should enter a number large enough to
accommodate the field you are using as a lineup.  Fields that are single
boxes require just 1 character.

When prompted "Tab to re-enter an item, Enter to cont.," press
<Enter>.
Repeat the above steps for other data fields.



@Ins
^Keep vs Replace

When adding the same item multiple times, such as Lineup Data, the
program presents the screen as seen in Figure 74.  This screen indicates
to you that you already have that item located at a particular location. 
You then have a choice to make:

        You may keep item listed in the bottom screen (row 1, column 1 as
        seen in Figure 74), or replace the data field with the new location
        (row 2,column 1).

        Keeping the new item location means the program prints the data
        field information at more than once location on the insurance form.
        Replacing the new item location means the program prints the data
        field information only once on the insurance form. There will be 
        times you will need to print a data field at more than one location.



@Ins
^Deleting a data field

If you make an error and specify the wrong data field, or you need to
remove a data field from a form, you may very easily delete the data
field.

Choose Select Items To Print On Form.

You will see the screen shown in Figure 71 on page 5-16.

Select the category you are working in.

The screen shown in Figure 72 on page 5-16 appears.

Press <Enter> on the data field you wish to add.

The screen seen in Figure 73 on page 5-17 appears.

Press <Enter> on the row, column, and maximum character fields without
entering any data.
When prompted "Tab to re-enter an item, Enter to cont.," press
<Enter>.

The screen shown in Figure 75 appears.  The default choice is ~DELETE.~

Press <Enter> to delete the data field.



@Ins
^Saving Your Data

At this point it will be good to save your data.  To do this:

Press <Esc> until the screen shown in Figure 76 appears.
Press <Enter> to add the form.
     
You will receive confirmation that you have added a new form.

After you save your data once, the next time you save your data the
procedure is slightly different.

Press <Esc> until you see the screen shown in Figure 77.
Press <Enter>.

You will then receive confirmation that you saved the form as the form
number indicated.


@Ins
^Viewing Items on Form

Once you have specified a location for your items, you can verify that
you have not missed any items by viewing those items already selected
for your insurance form.

~Unlike many lists, you cannot print these questions.~

Select List Items Already Selected For The Current Form.

The screen similar to that shown in Figure 78 appears.

Use your arrow keys, and your <PgUp> <PgDn> keys to view more of the
data fields.
Press <Esc> to return to the previous screen.



@Ins
^Specifying Lineup Information

The next step in creating a custom insurance form is to set up your
lineup information.  You use lineup information when you perform a
lineup before you print the insurance form.  The lineup data insures
that you inserted the insurance form correctly into the printer, and
that the horizontal and vertical lines match-up with the insurance
information you will be printing on the form.

~Lineups are valid only for dot-matrix printers.  Laser printers do not
require a lineup.~

Be sure you select at least one line from the three areas described
previously.


~Selecting lineup information~

The same restrictions for specifying a data field apply to lineup data. 
You must specify at least three lineup data fields:  a field on the
first line of the form, a field on the first line of the procedure
section, and a field below the procedure section.

To select your lineup data:

Using either a row/column grid or a ruler, select at least three lines
to use as lineup data lines.
Choose "Select Items To Print On Form."

The screen seen in Figure 71 appears.

Select Lineup Data.

The screen seen in Figure 72 appears.

Enter the row, column, and length information.
When prompted "Tab to re-enter an item, Enter to cont.," press <Enter>.
Continue the above steps until you have entered all of your lineup
data. 



@Ins
^Print a Test Lineup/Test Form

Once you have entered your lineup data, you should print a test lineup
and a test form to ensure your form is correct.  To do this:

Select "Print a Test Form."
When prompted "Test the ACTUAL or LINEUP form," press L to change the
option to LINEUP.
Press <Enter>.

At this time the program indicates it is preparing to print to a
specific printer.  

If you have selected the correct printer, press <Enter> to print the
lineup form.

After you have verified that your lineup is correct, you need to print a
test form on an actual insurance form.  This will be the final
verification before you begin to use the insurance form for your
practice.

When the lineup is correct, at the "Test the ACTUAL or LINEUP form,"
press A to print an actual form.
Press <Enter>.

The program will again indicate it is preparing to print to a specific
printer.

If you have selected the correct printer, press <Enter> to print the
actual form.

If anything is wrong with the form, you can go back and edit any of the
data fields that are on the form.

