@Comment
^Doctor's Comment

The Doctor's Comments menu gives you utilities you can use to set up a
data base (collection) of comments that you can "tag" patients with. 
For example, if you want to keep track of which patients like morning
appointments, you could enter the comment "This patient likes morning
appointments" and assign a four character code for it, such as "MORN." 
When a patient expresses that he likes morning appointments, you can tag
the patient with the "MORN" code.  Afterwards, any time you look at the
patient's comments you will see the message "This patient likes morning
appointments."

In addition, you can create "free form" comments for any individual
patient.  This is a comment that does not use a comment code.  If you
need to save a comment for a specific patient, and that comment is not
in the database, you may enter a comment specifically for that patient.

You can customize doctor's comments to print on the patient routing
slip.  Refer to Setting Routing Slip Options.



@Comment
^Adding Comments

In order to use comment codes within Easy Dental Plus you must first
create the comment code.  A comment code is any alphanumeric code up to
four characters in length.  These comment codes are case sensitive. 
This means that "Golf" is different from "golf," which is also different
from "GOLF." This way you can use the "same" code to mean different
things. The comment itself can be any valid alphanumeric character, and
can be 60 characters in length.

~If a comment code is less than four digits long, the program places a
leading "0" in front of the code you enter.~

To add a new comment:

Select 1.  Add or Change Comments In Data Base.
Enter up to four alphanumeric characters for the comment.
Enter up to 60 alphanumeric characters for the description.
Save your changes.

You cannot edit the comment code itself.  Attempting to do so will only
create a new comment code, leaving the old comment code intact.



@Comment
^Editing a Comment

You can edit a comment as easily as entering a comment.  CAUTION:  If
you are changing the text for an existing comment, we recommend that you
do not substantially change the meaning of that comment.  This is
because you may have already saved that comment's wording for some of
your patients.  

To edit a comment:

Select 1.  Add or Change Comments in Data Base.
Type in the comment code whose comment you wish to edit.
Type in your changes to the comment.
Save your changes.

You can associate free form doctor's comments--comments without comment
codes--with patients as well.  This type of comment is not the same as
transaction comments.



@Comment
^View/Print Comments in Data Base

You may view and/or print any comment in the comment data base.  All
this option does is present you with a list sorted by one of two
methods:  by comment code or by comment text.   

To print the comment code list:

Select 2.  View/Print Comments in Data Base.
Choose the method of sorting you wish to use.

When the program displays the list on the screen, press <Enter> to print
the list.



@Comment
^Associating Comments to Patients

You must associate comments with patients before you can print them on
such reports as Patient Routing Slips, or display them in the
Patient Inquiry <F2>.  You associate doctor's comments by either selecting
Doctor's Comments menu option #3 (Enter/Save Comments for Patients), or
by pressing <F4> from virtually any menu.  You may enter as many
comments as desired for any patient.  If you suspect that more than one
patient will use a particular comment, then you should first enter it in
the comment database and assign it a comment code.

~Comment Date.~  The date saved with the comment will default to the
current date, but you can change it by pressing <Shift-Tab> to move the
cursor to the date field.

~Comment Code.~  This is the code you wish to associate with the patient.
You may also press <Enter> on this field to associate a free form
comment with the patient.

~Comment Text.~  The program displays the comment you attached to the
comment code.  If associating a free form comment, the program displays
that comment here.

~You cannot perform a database search on a free form comment.  This is
because the search function uses the four character comment code to
search for comments.  Free form comments do not have a comment code.~

To associate a comment code with a patient:

Choose 3.  Enter (Save) Comments for Patients.
Enter the patient's name or number to associate the comment with.
Type in the comment code to associate.
Press <Enter> to save your comment association.

~To associate a free form comment with a patient:~

Select 3.  Enter (Save) Comments for Patients.
Enter the patient's name or number to associate the comment with.
Press <Enter> while the cursor is in the Comment Code field.
Type in the free form comment.
Press <Esc> when finished entering the free form comment.
Save your changes.



@Comment
^Removing Patient Comments

While you cannot delete comment codes, you can remove their association
to patients.  This is necessary when the need for the patient comment is
no longer necessary, or you no longer wish to use that particular
comment code.  You can do this for both comment codes and free form
comments.  Keep in mind that if you remove a free form comment,
you will have to retype the entire comment in order to associate
it again with the patient.

If this report has more than one screen's worth of comments saved, use
<PgDn> and <PgUp> to page through all of them.  Use your arrow keys or
<Tab> and <Shift-Tab> to move up and down one comment at a time.  

To remove a comment:

Select 4.  Patient Comment Inquiry and Deletion.
Enter the patient's name or number.
Press <Tab> until you reach the comment you wish to delete.
Press D to mark the comment.
When you mark all of the comments you wish to delete, press <Esc> to
move the cursor to the bottom of the screen.
Save you changes.



@Comment
^Comment Data Base Search

You may perform a search for patients who are associated with a certain
comment.  This is useful if you are using comments as a method of
tracking patients or for keeping patient lists, such as a list of
patients who want the next available appointment, as seen in Figure 104. 
You may also print this list to keep by the computer for use during the day,
or you may instead use the list to print mailing labels.

~If you backdate an entry, it will appear as if it is out of order.~

You will also notice in Figure 104 the list is not in any particular
order.  The program displays the list in the order you made the entries. 
This is a useful function if you are creating a "first-come,
first-served" type of list.

To print the comment data base search list:

Select 5.  Data Base Search.
Select View/Print Listing.
Enter the comment code.
When the list appears on the screen, press <Enter> to print.


~To print mailing labels:~

Select 5.  Data Base Search.
Select Print Mailing Labels.
Enter the comment code.

The program prompts you to begin printing your labels.  If you are
printing to a dot-matrix printer, the program asks if you want to
perform a lineup.  After the lineup, the program prints your labels.   



@Comment
^Recall Comments

Recall comment codes are special codes you use in order to help keep
track of recall patients.  The program prints the recall comments on the
master recall lists.  The recall comment code must be a five
alphanumeric character code.  You can use letters and/or numbers to
create this code.  The comment code is not case sensitive.  This means
that "Late" is the same as "late" or "LATE."  The comment code will
access a 55 alphanumeric description of what the code means.  You can
use these codes for any patient on recall, whether they are on prophy
recall or dental recall.  You cannot associate a recall code with a
patient's recall until you enter the code into the database.

You can associate a recall comment code with a patient when updating a
patient's recall.  Refer to Recall Comment Codes.

To add a recall comment code to the database:

Choose 6.  Recall Comments.
Choose "Add or Change Recall Comments Data Base."

The screen, as displayed in Figure 105, is similar to the screen seen
when adding a doctor's comment code.  The difference is the recall
comment code must be five digits in length.

Enter a five character alphanumeric code.
Enter up to a 55 character alphanumeric description of the recall code.
Save your changes.




@Comment
^Editing Recall Comments

The process for editing a recall comment is similar to adding a recall
comment, with a few differences.

Choose 6.  Recall Comments.
Choose Add or Change Recall Comments.

You cannot delete the recall comment from the database, but, you can
remove a recall comment's association to a patient.

Enter a five character alphanumeric code whose comment you wish to edit.

Just like doctor's comments, you cannot edit the recall comment code.
Attempting to do so will create a new code.

Edit the comment code.

If you mark a comment by mistake, tab up to that comment and press
<Space> to remove the marking.

Save your changes.



@Comment
^Removing Recall Comments

Choose 6.  Recall Comments.
Select "View or Delete Patient Recall Comments."
Enter the patient's name or number.
Press <Tab> until you highlight the recall comment you wish to delete.
Press D <Enter> to mark this comment.
After marking the comments you wish to delete, press <Esc>.
Save your changes.

~Only transactions during the current accounts receivable month and
transactions that are open can have comments added or removed.  Once you
close the month, you can no longer alter the closed transactions.~



@Comment
^Viewing Recall Comments

You can view patient recall comments on the screen; however, you cannot
print the recall comments associated with the patient.

~If the far left column includes a "C," this means that transaction
contains a comment.~

To view a patient's recall comments:

Select 6.  Recall Comments.
Choose View or Delete Patient Recall Comments.
Enter the patient's name or number.

The program displays on the screen the recall comments associated with
the patient.




@Comment
^Transaction Comments

You can add transaction comments to a patient's transactions when
entering patient treatment, entering payments, when
applying a credit adjustment, voided transactions, and when
creating contracts.  When you add a transaction comment to a
patient's transaction, this does not mean that it has yet become
permanently a part of the patient's transaction record.  You may at
any time during the current accounts receivable month change, add,
or delete a transaction comment from a patient's current month's history.




@Comment
^Adding A Transaction Comment

Choose 7. Transaction Comments.
Enter the patient's last name or patient number.

You will now see a screen similar to the screen as shown in Figure 107.

Press <Tab> to move the cursor to the transaction you wish to add a
comment to.
Press <Atl-A> to add a transaction comment.
Type in your transaction comment.
Press <Esc> when you finish typing a comment for that particular
transaction.
Press <Enter> at the prompt to save the transaction comment.



@Comment
^Deleting A Transaction Comment

Choose 7. Transaction Comments.
Enter the patient's last name or patient number.

You will now see a screen similar to the screen shown in Figure 107.

Press <Tab> to move the cursor to the transaction you wish to delete.
Press <Space> <Enter> to delete the comment.
When prompted to delete, press <Enter>.



@Comment
^Editing a Transaction Comment

The process for editing a transaction comment is virtually the same as
adding a transaction comment.

Choose 7. Transaction Comments.
Enter the patient's last name or patient number.

You will now see a screen similar to the screen shown in Figure 107.

Press <Tab> to move the cursor to the transaction you wish to add a
comment to.
Press <Enter> to edit the comment.
Make your edits.
Press <Esc> when you finish typing a comment for that particular
transaction.
Press <Enter> at the prompt to save the transaction comment.


