@Pay
^Entering Payments

Easy Dental Plus uses this function primarily for checks
received in the mail--especially insurance checks--since you can
enter payments when entering treatment.

You can also access the payment program by typing ~PAY~ at any
menu prompt.

If you enter a payment for treatment performed on a patient who
is not responsible for his own charges, enter the payment on the
patient, not the responsible party.  This ensures that the
patient's history is correct and that, more importantly,
insurance estimation for this patient remains accurate;
otherwise, it will be difficult to track payments and insurance
participation for the patient and the family.



@Pay
^Balance-Forward vs Open-Item Allocation

When you apply a credit to a family's balance you can use one of two
methods to apply the credit to open transactions: open-item allocation
and balance-forward allocation.  Either of these allocation methods
applies the credit to open transactions.  The difference is how you
apply the credit.

Easy Dental Plus stores only family balances.  There are no individual
balances.


~Balance-Forward Payment Allocation~

This method of payment allocation is the simplest way of applying a
credit to a family's account.  Balance-forward applies the credit to the
oldest family transaction.  This means that if a family of four--father,
mother, son, and daughter--all have open transactions, Easy Dental Plus
applies the credit to the transaction that is first (oldest).  If there
is any remaining credit amount, the program applies it to the next
oldest transaction, and so forth until the program applies the entire
credit, or until there are no more open transactions. 

Easy Dental Plus normally applies insurance payments against an
individual patient's insurance balance.  This may not be the case if you
incorrectly applied prior payments.

Clearing and reapplying a credit, if necessary, will insure a correct
family and individual history.  However, if the computer's allocation of
your credit was correct, then there is not a need to clear and reapply
credit


~Open-Item Allocation~

When using open-item payment allocation, you apply the credit to the
family's open transactions.  In fact, when using this method of payment
allocation Easy Dental Plus applies the credit to the oldest
transaction(s) first.  Then, what is the difference?  

To clear the payment allocation, press ~C~ while on the payment allocation
screen.

Open-item allocation gives you the choice to reallocate the credit to
the transaction(s) of your choice.  If a family of four all had
open-transactions, the program automatically applies the credit to the
oldest transaction.  However, you can clear the computer's credit
allocation and allocate the payment to a different transaction. 
Balance-forward would not allow you to do this.   



@Pay
^Applying Credits Using Open-Item Payment Allocation

When applying a credit using this method, a special screen appears
(Figure 49).  This screen lists patient information in the top portion
of the screen, and open-transactions for the family for the remainder of
the screen.  Figure 49 indicates the user, or Easy Dental Plus,
allocated $100 worth of credit to the first few transactions (oldest). 
It is irrelevant that you wanted to apply the credit to the patient, Boy
Public; the program applied the credit to the oldest transactions, in
this case John and Mary Public.

~You can autoapply your credit by pressing ~A~ while on the payment
allocation screen.  You must first clear allocations by pressing
C.~

"This" patient is the name displayed at the top left corner of the
payment allocation screen (Figure 50).  

If you clear the credit allocation a screen similar to Figure 50 would
appear.  This screen indicates the program cleared the previously
applied credits.  You may then allocate the credit toward any open
transactions shown. 



@Pay
^Auto-applying Credits

When you clear the computer's credit allocation you can choose to
autoapply the credit amount.  What this means is that you can apply the
credit to whomever you wish, or you can specify where to start applying
the credit.  You have a choice when autoapplying credits.

~This Patient's Transaction.~  You can autoapply to "this" patient's
transactions.  This means you apply the payment only to transactions
owned by the patient whose number you entered.  The autoapply feature
does not apply any remaining credits to any other family member.

~Entire Family's Transactions.~  You can apply the credit to the entire
family using this option.  The credit is first applied to the patient's
portion, with any remaining credit applied to the insurance portion.

~This Transaction.~  You can begin applying your credit beginning at a
particular transaction.  This means you can start at the middle of the
listed transactions and begin paying at that point. 

You can only use this method of credit application when customized for
open-item payment allocation.

You cannot make a credit adjustment to a transaction that you or Easy
Dental Plus has already allocated a credit toward.  Be sure to clear
allocations prior to applying a credit adjustment, or apply the credit
adjustment to a treatment that you have not applied a credit to.

~Oldest Transaction.~  This option allows you to begin paying transactions
with the oldest transaction.  



@Pay
^Manually Applying Credits

Instead of auto-applying credit, you may select a particular transaction
to credit, and the amount to credit that transaction.  

To apply a credit to a specific transaction manually:

Press ~C~ to clear the computer's allocation.
Highlight the appropriate transaction.
Press ~<Enter>~.

You will then see the screen shown in Figure 51.  The flashing ""
characters indicate the participation expected according to the type of
check you are entering.

Enter the amount to allocate to this transaction.

Your cursor will begin at the ~Amount to Apply~ field.  This can be any
amount up to the Prior Balance amount.  

Press ~<Enter>~ from this field to move to the prompt at the bottom of the
window. 
Repeat this process for other transactions.

~If there is not an adjustment code appropriate for the adjustment made,
you may want to consider adding your own adjustment code to this list. 
Refer to Section II for this information.~




@Adjust
^Applying a Credit Adjustment

You can apply a credit adjustment when manually allocating a credit.  A
special field is available on the manual allocation window for you to
enter the adjustment amount.  This will save you a step by allowing you
to enter the credit adjustment at the same location as the payment
amount.  To access the Credit Adjustment field, press ~<Shift-Tab>~.  You
may now enter the amount of the adjustment, up to the dollar amount of
the transaction.  

After you make the credit adjustment and you are ready to finalize your
payment allocations, a pop-up list of credit adjustment types will
appear (Figure 52).  Choose the correct adjustment choice by using the
arrow keys to highlight your choice.  From this point continue with the
payment process as normal.



@Pay
^Entering Date of Service

When entering an insurance payment, you may also include a Date
of Service that is attached to the payment transaction.  This
helps you, when viewing the patient's history, to determine when
the treatment was performed that the payment was for.

The ~Date of Service~ field only appears when making insurance
payments or bulk payments.  It does not appear when entering
payments while entering treatment.


To enter a Date of Service:

Select Insurance Payment

After entering the insurance check number enter the date of
service in the ~Date of Service~ field.

~When entering an insurance payment the Date of Service field
appears at the bottom right side of the payment screen.~

Continue making the payment as normal.



@Pay
^Payment Types

There are several payment types.  Each one affects how you enter a
payment.  These payment types are:

    ~*Prior Payments
    *Zero Dollar Payments
    *Insurance Payments~

Since entering a $0.00 payment saves a transaction in the patient's
history, if you need to reprint a walkout statement you must do so from
the Patient Menu, Item #13 Reprint Walkout Statement.   



@Pay
^Allocating Prior Payments

If you customize your software for open-item payment allocation, and you
have unallocated payments or credits--that is, payments that you made
previously that resulted in a credit balance for this account--then the
program asks you ~"Do you wish to allocate prior payments? Yes."~  Press
~<Enter>~ and you will proceed directly to the payment allocation screen
as shown in Figure 53.  After you allocate the prior payment, you will
see the payment screen.  




@Pay
^Entering $0.00 Payments

If you need to indicate that insurance has denied coverage on a certain
claim, saving a $0.00 payment saves an actual transaction in the
patient's history. This transaction also appears on monthly statements. 
Since insurance has denied coverage, when you enter a $0.00 payment, and
indicate the payment type to be ~Insurance Check~, the program displays a
pop-up selection list of outstanding claims.  Once you mark the claim as
final, the program deletes the claim.

This displays only the patient's claims, not claims for the entire
family.

If the insurance company does not pay the entire insurance portion, and
there will not be any more payments on the claim from the insurance
company, then Easy Dental Plus considers it a final payment and not a
partial payment.     

To clear the claim's status, press <Space>.  You may press <Enter> to
view more information about this claim.  The same F, P, and <Space> keys
apply in this window.




@Pay
^Insurance Payments And Tracking Outstanding Claims

A list of outstanding claims for the patient may appear when you enter
an insurance payment, giving you the opportunity to apply the insurance
payment to the correct insurance claim.  


~Claim Status~

An insurance claim's status can be one of two types, either partial or
final.  A partial payment from an insurance company means the insurance
company will send another insurance claim payment.  This could mean you
receive one or more checks from the insurance company in order to pay
the insurance claim.

A final payment is a payment in full from the insurance company.  This
means the insurance company is not sending any other payments,
regardless of whether the insurance payment covered the entire expected
insurance amount.  



@Pay
^Entering insurance payments

Enter the amount of the insurance payment.
Select the payment type as Insurance Check.

If more than one claim is pending for the patient, a listing of
applicable claims will appear.

Use the arrow keys to select the appropriate claim.
Press P for a partial payment or F for a final payment.
Press <Tab>, then <Enter> to continue.
Depending upon your payment customization, apply the payment as
normal.



@Provide
^Redistribute Provider Collections

When entering payments you have the ability to redistribute the payment
to a provider who did not perform the patient's treatment.  This is
appropriate if you inadvertently specified the wrong provider when you
entered treatment, and it is too late to void the transaction.   

If you customize your software to force redistribution only for credit
balances, you will only see the redistribution screen (Figure 54) when
the payment you enter causes the patient or family to have a credit
balance.  There is one possible exception:  Any unallocated payment or
credit will always cause the ~Force Redistribution Screen~ to appear, even
though the payment entered may not have caused a credit balance.  This
can happen if you customize the software for open-item payment
allocation and you do not fully apply the payment to the charges shown
on the Payment Allocations Screen (Figure 50, page 4-5).   


~Important Redistribution Facts~

Redistribution of payments is customized in System Customization, Enter
Payments Setup, option #5.

If you customize the software to force redistribution of payments
always, the redistribution screen will always appear.  
    
If you customize the software for balance-forward payment allocation,
you do not need to redistribute provider collections.

The ~Aged Accounts Receivable Report by Provider~ does not and cannot
recognize "fully distributed" payments.  The reason for this is that
collection figures are month-to-date. When you close the month, you wipe
out collection figures for that month and start a new month.  Therefore,
it is impossible to determine how the program allocated payments from
prior months.  If you plan to use the force redistribution of payments
options, we recommend that you always print the ~Aged Accounts Receivable
Report for all Providers~.



@Pay
^Manual Allocations and Redistribution of Collections

If you customize the software to force redistribution of payments and
you are using open-item payment allocation, when entering a payment if
you have unallocated payments or credits, the program prompts you ~"Do
you wish to allocate prior payments? Yes."~  If you previously forced the
distribution of a credit balance or unallocated credit to a provider,
when you reach the payment allocation screen, the program displays a
screen similar to that shown in Figure 53 on page 4-8.

If you need a listing of the treatment, you will need to reprint a
walkout statement instead of printing a receipt.     

WARNING:  You should compute finance charges only once a month; however,
you may print the finance charge report without updating accounts as
many times as you want.     

The message in Figure 53 indicates the provider has already received
credit for his collections.  By applying this payment to the charges,
you are only doing so in order to close out those charges.  The
application of this payment to the charges shown will not affect
collections, since you already forced that entire payment to a provider. 



@Pay
^Printing a Receipt

You may print a receipt after you enter a payment, either for an
individual or for the entire family.  A receipt is technically
the same as a walkout statement except you print a receipt after
a payment rather than after treatment.  The default number of
receipts is zero.  

If you need a listing of the treatment, you will need to reprint
a walkout statement instead of printing a receipt.

~You may also include comments and service dates when entering
bulk payments.~


To print a receipt:
 
When at the Payment Amount field, press <Shift-Tab> until you
highlight the Family/Individual field.
Using the arrow keys, change this field to the value you wish to
use, then press <Enter>.
Enter the number of receipts you wish to print.
Continue the payment process as normal.


@Pay
^Entering Bulk Payments

HMOs and other health maintenance plans many times sends a bulk
payment to cover the cost of several patient's insurance
participation.  While this is convenient for the HMO, it can
cause some problems for you when you need to divide and enter a
payment for each individual patient.  To solve this type of
problem you can enter the insurance payment as a bulk payment.

To enter the bulk payment:

Select 2.  Enter Bulk Insurance Checks.

The screen seen in Figure 41 appears.

Enter the appropriate information as seen in Figure 41.
When prompted "Press <Tab> to Edit; <Enter> to Continue," press
<Enter>.

The program displays a listing of patients with outstanding
claims for the insurance company you specified (Figure 42), and
positions the cursor at the ~Amount to Apply~ field.

Enter the amount that is due for the patient's account.
Using the arrow keys, select the payment type as Partial or
Final.

~If you need to skip a patient whose account you do not need to
credit, press <Tab> to move past that patient.~

While entering the bulk payment, you may also enter a
transaction comment, or you may assign a "Date of Service" date
to the payment transaction.  Refer to Transaction Comments, or
Entering Date of Service for more information.

To do this, while the cursor is on the transaction line:

Press <Alt-A> to add a comment, or
Press <Alt-D> to assign a Date of Service.
Repeat the above steps until you have fully allocated the
payment.

~As you enter payment amounts, you may view the amount remaining
for allocation by looking at the Remaining Amount field seen at
the top right-hand side of Figure 42.~

When prompted "Press <Tab> to Edit; <Enter> to Continue," press
<Enter>.
Apply your payments.

The program displays a payment allocation screen for each
patient that you applied a payment to.  This screen resembles
the screen seen in Figure 43.

When prompted "<Enter> to Continue or <Shift-Tab> to Edit
previous item," press <Enter> to apply the allocated payment to
each patient's account.
When you have finalized each patient's payment the program
presents you with an Insurance Bulk Payment report that you may
print or view. 
To print the report, press <Enter> while viewing the report on
the screen.
Press <Esc> to enter another bulk check.



@Finance
^Automatically Compute Monthly Finance Charges

Many dental office charge their patients a finance charge based on the
patient's outstanding balance.  Easy Dental Plus gives you a flexible
utility that allows you to select the way your office charges finance
charges.  

This utility will allow you to:

    *customize your charge calculations
    *print a listing of responsible parties to receive a charge
    *print a test listing of responsible parties to receive a charge,
    without updating the patient's account



@Finance
^Customizing Finance Charges

You can tailor your finance charges to fit your specific needs.  You may
restrict the charges to certain people, or charge everyone a finance
charge.  You may restrict the charges to balances of a particular age or
greater, or charge all balances, regardless of their age.  In addition,
you can customize the credits for finance charges to go to the provider
of services, or to the owner of the practice.   

~A finance charge is a non-production debit.~

~Monthly Finance Charge Percentage.~  This is the percentage that you
charge on a monthly basis.  The program displays an interest rate
calculation screen when you enter the percentage rate.  This is useful
if you are unsure of what the monthly rate would need to be in order to
get the desired yearly rate.

~Minimum Charge.~  This is the minimum amount of money that you charge an
account.

For example, if you charge an account 1.00% (12% APR) on their $100
balance, they would receive a $1.00 charge.  If, however, you specify a
minimum charge of $2.00, the program will charge the account $2.00.  

If the patient owes money to two or more providers, the program divides
the finance charge proportionately among those providers.  Example: 
John Q. Public owes Dr. Doe $40.00 and Dr. Roe $10.00.  One percent of
that is 40 cents for Dr. Doe and 10 cents for Dr. Roe.  If the minimum
finance charge is one dollar, then Mr. Public will get a 80 cent finance
charge owed to Dr. Doe and a 20 cent charge for Dr. Roe.  

~Although a patient may receive multiple finance charges because
he owes money to multiple providers, only one charge for the sum
of the separate charges will appear on the monthly statement.

Only responsible parties, who hold the family balance, need to have the
Charge Interest flag in the patient information set.  Easy Dental Plus
ignores all others.~

~Restrict Charges To.~  You can restrict your charges to specific types of
accounts:

~All accounts.~  If you specify all accounts, you charge all responsible
parties, regardless of whether you set their Charge Interest flag to
"Yes."

~Only accounts on a payment plan.~  If you have any patients on a payment
plan--this is not a contract--then you charge only these patients a
finance charge.

~Only accounts specifying monthly interest.~  If you set the responsible
party's Charge Interest flag to "Yes," then the program charges only
those patients a finance charge.  Easy Dental Plus ignores all other
patients.

~Charge accounts that have.~  This option allows you to specify the age a
balance should be in order to generate a finance charge.  You may select
balances greater than 30 days, balances greater than 60 days, balances
greater than 90 days, or any balance regardless of age.  The minimum
balance you specify refers only to that portion of the balance that
meets the age you specified.  Example:  A patient may have a balance of
$100, but if you specify balances greater than 60 days, and only $40 was
past due, the program charges interest only on $40.

You should computer finance charges once a month.  This program does not
automatically run them for you.

~Minimum balance to charge.~  This is the minimum amount of money to
charge a patient.  Although the amount is preferential, you should enter
a token amount, such as 50 cents.  You should always set this if you are
also setting the Minimum Charge field.  You do not want to charge a
$1.00 finance charge on an account that owes you 50 cents.

~Compute charge on.~  You can charge an account based on the patient's
balance only, or the entire balance, including insurance.  Many
practices do not want to compute a finance charge on insurance portions. 
If this is true about your practice, then choose to charge only on the
patient's portion.

~Finance charges go to.~  Enter which provider is to receive credit for
the finance charge:  the provider of services, or one particular
provider.  If selecting a particular provider, a listing of all
providers will appear.


@Finance
^Compute Finance Charges

The process of computing finance charges is a simple process.  All
patients you charge will have their accounts debited the amount of their
particular finance charge.  After the program updates accounts you can
print the ~Finance Charges Report~.  This report lists the patients whom
you charged, how much you charged them, and which provider received the
credit.


~Setting up for charge calculation~

In order to make calculating your finance charges as easy as possible,
please consider the following steps:

    ~*Customizing your finance charges.~

You should customize your finance charges prior to calculating.  If you
do not customize the charge calculations to your liking, the finance
charges may not reflect your needs.

    ~*Set the charge calculation date.~

The date to calculate finance charges defaults to the current date,
although you may set this date to whatever you wish by pressing <Tab>. 
Easy Dental Plus uses this date to determine the age of each
transaction. 

~A back-dated charge date will make your transactions older.  A
post-dated charge date will make your transactions more recent.~

Altering this date can change the amount of your finance charges, and
can change who receives a finance charge.  Be careful when altering this
date.

    ~*Select the finance charge mode.~

You can access this field by pressing <Tab> or <Shift-Tab> on the
finance charge calculation screen.  You have one of three modes to
choose from:    

~Print Test Listing of Finance Charges - Do Not Update Accounts.~  This
mode gives you only a listing of responsible parties who would receive a
finance charge, and the amount of the charge.  Selecting this mode is
useful as a test mode to insure the process is correct before actually
charging the patients' accounts.

DPI strongly recommends you use this option the first few times
you compute finance charges.

~Compute Actual Finance Charges, Update Accounts & Print Test Listing.~
This is the default mode.  This updates the patients' accounts and print
a test listing of whom you charged a finance charge.  

~Compute Actual Finance Charges and Update Accounts - No Listing.~  This
option updates accounts only.  No listing will print for you to view.

You are now ready to begin calculating finance charges.


@Collect
^Collection Agency

Sometimes patients are slow to pay their dental bills, or may fail to
pay them.  Usually this involves turning their account over to a
collection agency.  Although you cannot simply hit a key and let Easy
Dental Plus do this for you, you may mark a patient as though you had
turned them over to a collection agency.  

You can use this option to put the patient back into good standing.



@Collect
^Change Patient's Collection Status

Use this option to toggle a patient's collection status between "Good"
and "Turned Over to a Collection Agency."   

To change a patient's collection status:

Select Change Patient's Collection Status.
Enter the patient's last name or patient number.
Using your arrow keys, toggle the answer to "Yes" to mark them as on
collections, or "No" to mark them as in good standing.



@Collect
^Collection Report

If you need to view or print a listing of patients who you turned over
to a collection agency, you can either view or print the report Patients
Turned Over to a Collection Agency.  This report contains the patient's
account number, patient name, last treatment date, last payment date,
and current balance. 



@Adjust
^Adjusting Accounts

Sometimes it is necessary to adjust a patient's account.  This can be
due to an error:  you entered the wrong treatment, the payment date was
incorrect, the check amount was too low, or you wish to give a patient a
discount or write off a debt due to non-payment.  Easy Dental Plus gives
you the ability to adjust a patient's account for these reasons and
more. 

When adjusting a patient's account, you can use four options: ~debit
adjustments, credit adjustments, voids~, and ~redistribute collections~.



@Adjust
^Debit/Credit Adjustments

There are several reasons for using adjustments other than voiding.
Refer to Voided Transactions for more information about voids.
Here are just a few of them:

1.  The patient overpaid their account and you want to write a refund
check to the patient or responsible party.  Make a "Balance Refund"
debit adjustment in this case.  If Insurance overpaid, use the "Insurance
Refund" debit adjustment instead.

2.  Insurance has underpaid, but you do not wish to bill the patient for
the remaining balance.  Use the "Insurance Credit" adjustment.

3.  The bank returns a patient's check for non-sufficient funds.   For
this, you will want to do two adjustments: one for an "NSF (Returned)
Check" for the amount of the check, and another for "Returned Check
Charge" for the amount that you charge for this. 

4.  If a payment is past due you can either use the "Finance Charge" or
"Late Payment Charge" adjustments. 

5.  You wish to give a patient a "cash discount."  Use the "Patient
Discount Credit" adjustment, or design a "Cash Discount Credit" of your
own to use.

6.  If you have given up on ever receiving payment from a patient use
the "Bad Debt Charge Off."  If you use this type of adjustment, you
permanently mark the patient's record as a bad debt.  This cannot be
changed.




@Adjust
^Increase Patient's Balance (Debit)

If the patient's balance is too low you can select the debit adjustment
option.  This will add a charge to the patient's accounts receivable
balance. 

To increase the patient's balance:

Select the appropriate adjustment type.

If you have more than one provider, select the appropriate provider.

Enter the adjustment amount.

~The process of making a credit adjustment is virtually the same
as making a debit adjustment, except there may be additional
steps, depending upon your payment customization.~



@Adjust
^Decrease Patient's Balance (Credit)

If the patient's balance is too high, that is, he owes more than he
should, or you wish to give the patient a discount, you would choose to
give him a credit adjustment.  This reduces what the patient owes the
dental practice.  The screen shown in Figure 60 is almost identical to
Figure 59 (page 4-19), except there is not a provider field.  This is
because the program automatically selects the provider, depending on
what transactions you apply the credit adjustment against.

If you wish to make the adjustment date different from the current
date:

Press <Shift-Tab> to move to the Adjustment Date field.
Select the appropriate adjustment type.
Enter the adjustment amount.

~The next step is dependent upon your payment customization. If you
customize your software to use balance-forward payment allocation:~

When prompted "Make this adjustment final?" press <Enter>.

~To avoid using an adjustment instead of a void, please check all your
reports before closing the month.  Once you close the month, you cannot
use a void to correct an error for the past accounts receivable month.~

If you customize your software to use open-item payment allocation, the
credit allocation screen will appear.  You may select which transaction
to apply the credit adjustment to.



@Adjust
^Voided Transactions  

Voided payments do not show up on bank deposit reports.  Voiding
adjustments will even affect provider production.  Be aware that all
voids will affect patient balances appropriately, and the voided transactions
will not appear on monthly statements or even walkout statements. 
However, Easy Dental Plus does not delete voided transactions.  This
provides for an accountability and complete audit trail.  If you make a
mistake when entering treatment, entering a payment, or even when
entering an adjustment, you can use this option to "undo" the actions
performed by the transaction(s) in question.  

When you void treatment, the following figures are "unupdated":

    *MTD/YTD Procedures Performed (by procedure code and by
    provider)insurance forms
    *insurance claims
    *daysheets
    *MTD Payments and Credits

When you void a payment, you will see these figures change: 

    *collections-by-provider
    *amounts expected from patient or insurance, depending on the type
    of payment
    *daysheets
    *MTD Payments and Credits
    *Bank Deposit Report


~To void a transaction:~

Select Void Transactions.

A listing of transactions will appear.

A transaction may not appear for the family for various
reasons: 

    ~*The transaction has already been voided.
    *You entered the transaction prior to close month.
    *You specified the wrong family.
    *A change in responsible party occurred.
    *The transaction was a contract charge or contract initialization.~

You need to check out these possibilities if you cannot find a
transaction to void.  If one of the previous five situations occur, you
need to use an adjustment instead of a void.  Refer to
Decrease Patient's Balance (Credit) and
Increase Patient's Balance (Debit) for more information.

If you need more information on any particular transaction, move to it
and press <Enter>.  The program displays a screen similar to that seen in
Figure 62.  You may also mark a transaction as voided or unvoided in
this screen by selecting "Yes" or "No" at the "Void this Transaction?"
prompt.
 
Press <Enter> again to return to the previous screen.



@Adjust
^Redistribute Collections

This feature allows you to redistribute the collections for any payment
entered during the current month to any provider in your system.  This
is useful if you gave the provider the credit that you intended to give to
a different provider.  Redistributing collections will affect provider
collections but not provider production.

To redistribute provider collections:

Select Redistribute Collections.

Upon selecting this option, the program presents you with a list of all
the payments entered for this patient in the current month, or possibly
unallocated payments from prior months.  If you enter only one payment,
the program takes you to the ~Redistribution Screen~.  If you see more
than one payment, select the payment that needs to redistributed.  The
program then takes you to the Redistribution Screen (Figure 63).
 
Edit or zero out the collection figure for the provider listed.
Redistribute the collections to another provider.

Redistributing a payment to a different provider may result in the
provider of the services not receiving funds for his services.  If you
need to distribute this payment to a different provider, or divide the
payment among more than one provider:

     Press <Tab> or <Shift-Tab> until the highlight bar is on the
     payment. 
     You must then press 0 (zero) to "Undistributed" the payment from
     the provider highlighted.
     Press <Tab> or <Shift-Tab> to move the highlight bar next to the
     desired provider and enter the amount to distribute to that
     provider.

     You must distribute the entire payment.

     Press <Esc> after redistributing provider collections.
     Save your changes.




@Adjust
^Example of Forced Redistribution of Collections

Patient Jane Doe comes in for treatment.  You determine she needs a root
canal and a crown.  She currently has a $0 balance.  Doctor #1 will
perform the root canal. Doctor #2 will perform the crown.

You tell the patient that the total charge for both procedures will be
$800.00.  The root canal will be $300.00 and the Crown will be $500.00. 
Doctor #1 performs the root canal today, and you enter the $300.00
charge into the computer.

The patient decides to go ahead and pay the entire $800.00 today.  You
enter and save the check payment for $800.00.  At this point in time,
Doctor #1 has $300 of collections saved, matching the amount of his
production.

Since you customized the software to force redistribution of payments
for Credit Balances, the program takes you to the Redistribute Provider
Collections Screen.

Since Doctor #1 is the patient's preferred provider, you will see the
entire $800.00 payment next to provider #1  ($300 already allocated,
plus the unallocated $500 given to the preferred provider).  At this point,
you would have to know in advance that Doctor #2 will be performing the
crown at some point in the future, and you will have to divide the allocation
up between the two providers; $300.00 to provider #1 and the remaining
$500.00 to provider #2.

If you do not divide the allocation and give the entire $800.00 to
provider #1, then when provider #2 performs the crown and you enter the
$500.00 charge, the program will prompt you "Do you want to Allocate
Prior Payment and Credits."  If you respond "Yes," the program will display
the message found in Figure 64.

Since you Forced the distribution of the entire $800.00 to provider #1,
this means that provider #2 will not receive the funds for the treatment
that he performed.

If you discover this error, and you have not closed the month since you
entered the $800.00 payment, there is a solution.  Remember, since
collection figures are month-to-date, when you close the month you wipe
out the collection information for that month and you start a new month. 
If you select option #2 Enter Adjustments/Void Transactions from the
Accounts Receivable Menu, go to the fourth option:  Redistribute
Collections.  By selecting this option, the program shows you all of the
payments that you had entered for that patient or family in the current
month.  If you select the $800.00 payment, the program will take you to
the Redistribute Collections screen.  

~If you discover the error after you have closed the month, there is no
way to correct the error.~

This is the exact screen as the Force Redistribution Screen when enter
payments.  You may then edit the allocation to give $300.00 to provider
#1 and the remaining $500.00 to provider #2.  If, however, you discover the
error after you have closed the month, there is no way to correct the
error.  Remember, since collection figures are Month-to-Date, when you
close the month you wipe out the collection information for that month
and you start a new month.


@Contrc
^Process Payment Plan Contracts

Many dental offices require full payment for services up front.  
However, there are times when a patient has extensive dental work performed, or a
large family is in need of dental care, but cannot afford to pay all the
up front charges.  Easy Dental Plus helps to solve this problem by
providing the dentist the ability to create contracts for his patients.

There are three types of contracts you can use:

        *Future Treatment (Production Through Monthly Posting)
        *Future Treatment (Production Through Treatment)
        *Treatment That Has Already Been Entered.

If you ever need to see one patient's contracts receivable balance,
press <F2> for the pop-up Patient Inquiry and select section 4.


~Contracts Receivable vs Accounts Receivable~

When you create a contract, the program puts the amount taken from the 
patient's accounts receivable balance into a "Contracts Receivable." 
This is a "bucket" for money that is separate from the regular Accounts
Receivable.  Money in Contracts Receivable does not age, and is not
included in a patient's accounts receivable balance.  Since regular aging
balances do not include Contract balances, when you print your
Aged Accounts Receivable Report, you may also want to print your
Payment Plan Report.



@Contrc
^Entering a Contract for a Patient

When you choose to create a contract for a patient you will be presented 
with these three choices:  Future Treatment (Production Through Monthly 
Posting), Future Treatment (Production Through Treatment), and Treatment 
That Has Already Been Entered.

~Remember, production is treatment that you perform.~


~Future Treatment (Production Through Monthly Posting)~

This type of contract creates the production at the time you create the 
contract; however, the program does not post production until you post 
contract amounts at the end of the month.  This means you do not need to 
enter the treatment in order for the patient's balance to reflect
treatment.  However, the patient's history will not reflect the type of
treatment you perform.  To overcome this obstacle you can enter treatment
with a $0.00 charge.  This allows the patient's history to reflect the
treatment, yet does not allow the dentist to "double charge" the patient.
If you wish the history to reflect the actual dollar amount charged for
treatment, you may wish to consider the production through treatment future
contract option.

When deleting this type of contract, or reducing the contract amount,
the program moves the entered dollar amount to the patient's accounts
receivables.  Since this dollar amount did not originate from the
patient's accounts receivable, you need to adjust it off the patient's
account. You may create a user adjustment code called Delete Contract in
order to help keep track of this type of adjustment, or use a transaction
comment that indicates why you adjusted the patient's account.  It is possible
to enter all treatment and still have an amount remaining on the contract.
If this is the case, you will need to reduce the remaining contract to
$0, then adjust the contract balance off of the patient's accounts
receivable balance.

When viewing the ~Payment Plan Report~, the future production amount will
always match the amount remaining for the contract.  This is because the 
program does not create the production until you post the monthly
contract amount to the patient's account.  Entering a treatment at $0.00
value is not production.

~Production Through Monthly Posting Example~:  John Doe is a patient who 
needs an extensive amount of dental work performed over a period of
several months.  The dentist creates a Production Through Monthly Posting
contract for Mr. Doe.  The amount of the contract is $1500, with Mr. Doe paying
monthly payments of $100.  During the current month the dentist performs 
several procedures on Mr. Doe.  Since the dentist wants to track the 
treatment, he enters each procedure with a $0.00 charge.  At the end of 
the month the dentist posts contract amounts.  The dentist will note in 
his production report that $100 of this month's production is due to Mr. 
Doe's contract (you have yet to post the  remaining $1400).  This
process continues until Mr. Doe has made his last $100 payment.  The program
terminates the contract at this time.


~Future Treatment (Production Through Treatment)~

This type of contract is very similar to the self-producing future
contract.  The major difference is you enter treatment at its normal charge.
When creating a production through treatment future contract, the program
sets aside the potential production.  This potential production is equal to
the amount of the contract.  Posting the contract at the end of the month
does not affect provider production.  You can only affect production by
entering treatment.  Each time you enter treatment the program reduces the
future production.  When you have entered all treatment the future production
should reach zero, if you entered all dollar amounts accurately.

If tracking production by provider, you must specify the correct
provider when entering treatment.  Entering the wrong provider will credit the
wrong provider with the production, and the charge will not reduce the future
production amount.  You may, however, void the treatment to return the 
patient's balance to its correct amount.

When using this type of contract, the entering of treatment does not
increase the patient's balance.  This is because Easy Dental Plus puts the
contract amount into the separate "bucket," as described on page 4-28.  As you
post contract amounts each month, the program removes the monthly payment
amount from the "bucket," increasing the patient's accounts receivable balance.

When the patient pays his monthly payment amount, it will reduce his
accounts receivable balance.

If you reduce or delete the contract, the program places the amount of
the contract into the patient's accounts receivable.  Since this dollar
amount did not originate from the patient's account, you must adjust it off
the patient's account.

When deleting a contract, the ~Payment Plan Report~ may still indicate
there is a contract pending for the patient.  This is because Easy Dental Plus
updates the field used to store the dollar figure for the Production
Through Treatment type of future contract when you post contracts at the end
of the month.   Since this is the case, at the end of the month after monthly
contract amounts have been posted, review the report again.  You should
see the patient's name is no longer on the report.

When viewing the ~Payment Plan Report~, the future production listed will
not be the same as the remaining contract amount.   This is because the
amount of treatment entered may be greater than the amount remaining on the
contract.  This means you are completing treatment faster than you are 
paying off the contract.  This is normal.  Also, if the amount remaining 
on the contract is less than the future production, this means you are
posting your contracts more often than you are entering treatment for
that patient.  This can also be normal.  However, this does not mean that you
must post your contracts more than once a month.  Never post more than
once a month!  

~Production Through Treatment Example~:  John Q. Public needs extensive 
dental care over a long period of time.  The dentist creates a
Production Through Treatment contract for Mr. Public.  The contract amount is
$1500, with monthly payments of $100.  Mr. Public has treatment performed that
is equal to  $750.  The dentist enters the treatment as normal and applies
the amount of treatment to the contract.  At this time the dentist views 
the Summary of Production By Provider report.  He will see his
production has increased by $750.  At the end of the month the dentist posts
contract amounts.  If looking at this new production report, the dentist will
not see his production change due to the posting of Mr. Public's contract.

This process continues until you pay off the original contract amount. 
The program deletes the contract automatically.  Next month, Mr. Public does
not come in for treatment (he is in Hawaii enjoying himself).  The
dentist will see Mr. Public's contract does not affect his production, even
though the dentist posted contract amounts.


~Treatment That Has Already Been Entered~

This type of contract is the simplest of all three contracts.  When a 
patient receives all the treatment that the dentist performs, you can
create a contract that allows the patient to pay for the treatment over several
months.  Although the steps used to create this type of contact are
virtually the same for future contracts, the effect is different.  This type of
contract does not affect production because you have already entered the 
production.  If you reduce or delete the contract, the program moves the 
amount of the contract reduction over to the patient's accounts
receivables.  Since the money did come from the patient's account, you do not
need to adjust the patient's account.

You can create contracts for one provider at a time only.  You cannot
put more than one provider on the same contract.

If the patient does not have a balance, then option 3 in Figure 66 does 
not appear.




@Contrc
^Creating Contracts

Although the steps for creating any type of contract are similar, there
are some differences that warrant separate directions for each contract
type.  You may also encounter some situations wherein a contract currently
exists.

~No Contracts Exist~.  If there are not any contracts for the family the 
program displays a screen similar to that shown in Figure 66.

~A Contract Exists~.  If a family already has one contract, the program 
displays a screen similar to that seen in Figure 67.

If you choose to start an additional contract for this family, then
selecting ~Start New Contract~ will display Figure 66.


~If creating a Future Contract~

Choose option 1.  Enter a Contract for a Patient.

You will see a pop-up window that may have varying options as seen in 
Figures 53 and 54. 

Select either Production Through Monthly Posting or Production Through
Treatment contract.
A pop-up window of providers will appear.  Use your arrow keys to
select the provider.
Enter the contract amount.
Enter the amount of the first payment if the payment is being made on
the current date (manual posting).

~Suppress first month's posting means that when you post monthly
contract amounts, you do not charge a contract that is suppressing the posting.
This can be true if 1) the patient has already paid the first month's
installment, or 2) you are creating a contract within a few days of your next monthly
posting.  This occurs only for the first month of the contract's life.~

Enter or change the monthly interest, if applicable.
Enter the number of months the contract is for (the amount of each
monthly payment will be automatically calculated), or press <Tab> to move to the
monthly payment field and fill in the monthly payment amount (the number of
months the contract is for will be automatically filled in).
If you had filled out the initial amount due field, indicate "Yes" to 
suppress the first month's posting.
If you wish to print a contract, press <Enter> (the default value is
"Yes.")
When prompted "Press <A> to see Amortization, or press <Enter> if OK," 
press <Enter> if you wish to view the contract amortization.
When prompted "<Enter> to Continue or <Shift-Tab> to Edit previous item,"
press <Enter> to continue with processing the contract.
When prompted "Save or Cancel?" press <Enter> to save the contract.


~If creating a contract for Past Treatment~

Choose option 1.  Enter a Contract for a Patient.

You will see a pop-up window that may have varying options.  See the previous
section for these options.

Select 3.  Treatment That Has Already Been Entered.

A pop-up window of providers will appear.  Use your arrow keys to select the
provider.

Enter the contract amount.

~Some restrictions for placing an amount on a contract are 1) the amount of
money that is currently in the patients' accounts receivable and 2) the 
amount of money owed to the provider the contract is for.  For example,
if the patient's accounts receivable balance is $500, and provider #1 
provides $350 worth of treatment, then you can put only $350 on the
contract.~

Enter the amount of the first payment if the payment is being made on the
current date (manual posting).
Enter or change the monthly interest, if applicable.
Enter the number of months the contract is for (the amount of each monthly
payment will be automatically calculated), or press <Tab> to move to monthly
payment field and fill in the monthly payment amount (the number of months
the contract is for will be automatically filled in).
If there is an initial amount due, indicate "Yes" to suppress the first 
month's posting.

~Suppress first month's posting means when you post monthly contract amounts,
the program does not charge the contract a monthly contract charge.  This can
be true if 1) the patient has already paid the first month's installment,
or 2) you are creating a contract within a few days of your next monthly 
posting.  This occurs only for the first month of the contract's life.  After
the first month the program charges the contract amount as normal.~

If you wish to print a contract, press <Enter> (the default value is
"Yes.")
When prompted "Press <A> to see Amortization, or press <Enter> if OK," 
press <Enter>.
When prompted "Apply Charges?" press <Enter>.
When prompted "<Enter> to Continue or <Shift-Tab> to Edit previous item,"
press <Enter>.
When prompted "Make this Contract Final, or Return to the Previous Screen?"
press <Enter>.


@Contrc
^Adding to/Altering a Contract

You may add to a currently existing contract if you need to add new 
treatment.  This affects the current contract by lengthening the amount of
time remaining on the contract, or by adding to the sum of the contract.
Keep in mind, however, that you cannot combine another provider's production
with that of another's.

You may add to or alter any of the following information on a contract:

     *Any accounts receivable balance produced by the provider of the
     current contract (past treatment contract only).
     *The amount of the monthly payment.
     *The number of months the contract is in force.
     *An interest charge percentage.


To alter a contract:

Choose option 1.  Enter a Contract for a Patient.

If the patient has a current contract you will see the screen shown in
Figure 67.

Select the first option.
Press <Tab> until you highlight the appropriate field.
Edit the highlighted field.
When finished editing, press <Esc> to move the cursor to the bottom of the
screen.
When prompted "Press <A> to see Amortization, or press <Enter> if OK," 
press <Enter>.
Continue as you would normally enter a contract.


@Contrc
^Reducing or Deleting a Contract

On occasion you might create the wrong type of contract, or a patient pays
off his contract earlier than anticipated.  Easy Dental Plus makes dealing
with these possibilities easy.  

When reducing or deleting a future contract, you must credit the patient's
account the amount you reduced the contract by.  This is because the
contract amount did not originate from the patient's account, and should not
be added to the patient's account.  Failure to adjust the patient's account
balance will result in an incorrect patient account balance.  If reducing a
contract for treatment already entered, you will need to enter a payment, if
any, or make a credit adjustment to that patient's account. 

~Reducing future contracts is slightly different from reducing a contract for
treatment already entered.~


~Reducing a contract~

You can reduce a contract by entering the amount you wish to reduce the 
contract by.  This may be due in part because 1) you give the patient a 
credit for part of the treatment, 2) you have received the insurance portion
of the patient's balance, or 3) the patient wishes to make more than one 
payment to help reduce his finance charge, if any.  If reducing a future 
contract, you need to make a credit adjustment to the patient's account. 


~Deleting a contract~

You can delete a contract because you created the wrong contract type, or
you created a contract for the wrong family member.  The process for deleting
a contract is the same as reducing a contract, except you eliminate the 
entire contract amount from the contract.  You delete contracts for future
treatment in a slightly different way than contracts for treatment already
entered. 

If you are charging interest for contracts, when posting your contract 
amounts the interest charge will be a part of the total monthly payment 
amount.  This means that the principal will be only part of the monthly 
payment, with the remaining amount of the monthly payment being made up by
the interest charged.  If you are not charging interest the principal is
the same as the monthly payment amount.


To reduce or delete a contract:

Select 2.  Reduce a Contract.

You will see a screen similar to the one seen in Figure 68. 

Enter the amount to reduce the contract by:

        If deleting a contract, enter the entire amount as seen under the
        first line of the contract column.
        If reducing a contract, enter the amount you wish to reduce the 
        contract by.

Press <Esc> to move the cursor to the bottom of the screen.
When prompted "If OK, press <Enter>," press <Enter>.
When prompted "Save or Cancel," press <Enter> to save your changes.


@Contrc
^Post Contract Amounts for This Month

Each month as part of the close month process you should post contract 
amounts.  This charges each patient who has a contract the amount of the 
contract monthly payment.  Since each patient may have a different monthly
payment amount, the program charges each patient only that amount.  This 
does not affect patients whom you have marked as on a payment plan.

~Posting Example~:  You have three patients with contracts.   Patient One has
a monthly payment of $100.  Patient Two has a monthly payment of $75.00. 

Patient Three has a monthly payment of $50.00.  When you post contracts, the
program charges the amount of each patient's monthly payment to the patient's
accounts receivable account.  If you have already made a contract payment,
then the patient's balance should return to $0.00, as long as you do not 
add any other debits to the patient's account.  If you have not made a 
payment, then the patient will have a debit balance that will remain until
the patient makes his monthly contract payment.  If you do not receive the
payment before you print the statements, the patient will receive a bill.

If the patient wishes to have a printout of his payment schedule, or if the
dentist needs to view the current balance, interest or principal paid for a
patient's contract, he may do so through this option.  


To post your monthly contracts:

Select 3.  Post Contract Amounts For This Month.

The last posting date will appear at the top of the screen.  

~Please look at the last posting date carefully.  If you are posting 
contract amounts a second time within the last month, you will receive a 
warning indicating this.  If you accidentally post contract charges more
than once, you will need to either void the finance charge, or adjust the
patient's account.~

When prompted "Are you ready to Post Monthly Charges?" press <Enter>.

Easy Dental Plus now posts the contract amounts for all patients on a 
contract.  Once completed, the program returns you to the Process Payment
Plan Contracts menu.



@Contrc
^Contract Amortization

The contract amortization begins at the current contract balance, and 
calculates the number of payments remaining and interest paid, if the 
contract runs its natural life.  If you reduce the contract by any amount,
the amortization will change accordingly.  You may wish to reprint an 
amortization sheet in this case. 


@Contrc
^Payment Coupons

Easy Dental Plus provides you with the ability to print payment coupons for
patients on contracts and for patients marked as on a payment plan.  The 
overall size of the coupon form is ~8" wide by 3" high~, and prints on a
dot-matrix printer.  

The process for printing payment plan coupons is simple.  However, the 
process for printing coupons for a payment plan is slightly different.

You will notice the program calculates the number of coupons and the amount
for each coupon.


If printing for a contract:

Select 5.  Print Payment Coupons.

If the patient has more than one contract, you will see both of them 
displayed.  Select the appropriate choice.

You will now see a screen similar to that displayed in Figure 69.

Enter the date for the first coupon.

You are now ready to print your coupons.


~If printing for a payment plan:~

Select 5.  Print Payment Coupons.

You will now see a screen similar to the screen displayed in Figure 69.

Enter the number of coupons to print.
Enter the amount to print on each coupon if different from the amount shown.
Enter the last coupon amount if the amount is different from the monthly
payment amount.

The Payment Plan Report indicates payment plan patients by a space in the
contract column.  If you do not want this patient on this report, you will
need to remove them from the payment plan option.     

Also see the amortization report for interest paid.

Enter the date for the first coupon.

You are now ready to print your coupons.


@Contrc
^Payment Plan Report

This report is a listing of patients whom you have created a contract for,
or marked as on a payment plan.  This report indicates several things about
the patients listed:

        ~*It indicates the contract type; FM for Future Treatment (Production
        Through Monthly Posting), FT for Future Treatment (Production 
        Through Treatment), and P for Past Treatment.
        *The interest rate, if any.
        *The amount of the future production, if you are using a future 
        contract.
        *The amount of the contract and the remaining number of payments.
        *The patient's monthly payment.
        *The provider number for the contract.~



@Contrc
^Set Contract Options

Presetting your contract options allows you to simplify entering a contract.
This also affects the printing of the patient's contract and the payment 
plan coupons.  You can set these options at any time, but they should be set
before you create a contract or print payment coupons. 

~Default Monthly Interest Rate~.  This sets the interest rate the contract
defaults to when you create it.  You may set this to zero if you do not 
wish to charge interest for a contract.  You can override this option when
you create the contract, if you choose to charge interest for a particular
contract, or if you wish to use a different interest rate. 

~Also see the amortization report for interest paid.~

~Print Interest Paid on Coupons~.  When setting this option, the program 
prints the amount of interest paid on the payment coupons.  This interest is
cumulative and increases for each coupon.  The patient can view the last
coupon for an indication of how much interest he pays over the life of the
contract.   This information is useful for tax purposes.

~Use Provider or Doctor's Practice Name on Coupons/Contract~.  This is the
name that prints on the patient's contract or the payment coupon book.  
If you select Provider, coupons printed for patients who are not on a
contract will have the patient's preferred dentist printed on them.


@Contrc
^Mark Patients as "On a Payment Plan"

For various reasons you may elect to place a patient on a payment plan 
instead of a contract.  Refer to Creating Contracts for information on how
to create a contract.  There are several differences between a contract
and a payment plan:

        *The program does not move the patient's balance out of accounts 
        receivable.
        *The program ages the patient's balance normally, unlike a contract's
        balance, which does not age.

Initially, you will not see the Monthly Payment Amount field.  You access
this when you actually mark the patient as on a payment plan.

The program charges the patient a finance charge if you set up the charge
calculation using Accounts Receivable option #3.

The program flags the patient on the Aged Accounts Receivables Report as
on a payment plan.


To mark a patient as on a payment plan:

Select 8.  Mark Patient as "On a Payment Plan."

You will now see a screen similar to the screen shown in Figure 71.

Press <Tab> to move the cursor to the This patient is On a Payment Plan
field.
Press Y <Enter> to change their status to "Yes."
Enter the amount of the payment per month. 
When prompted "Press <Enter> to Continue," press <Enter>.
When prompted to "Save or Cancel?" press <Enter>.
The program returns you to the Process Payment Plan Contracts menu.




@Reports
^Accounts Receivable Reports

There are several accounts receivable reports you can print.  These
reports include ~Summary Daysheet, Detailed Daysheet, Bank Deposit
Report, Accounts Receivable Report~, and the ~Delinquent Accounts Report~.

In addition to these, you can print some minor reports.  These reports
include Test Listing of Finance Charges (Compute Finance Charges),
List of Patients Turned Over to Collections (Collection Report),
and Payment Plan Report.



@Reports
^DaySheets

You can print daysheets for any day during the month, until you run the
close month program.  Easy Dental Plus stores the data for the daysheet
in the detail and transact files.  When you close the month, the program
clears out these files to prepare for next month's transactions.  Even
"open items" you entered before you closed the month are not available
to print on daysheets.  Be sure to print all of your daysheets for the
month before you close the month.

Remember:  A summary daysheet gives you the day's total activity.  This
includes voided transactions.     

The daysheet prints each procedure performed on the patient separately. 
The daysheet lists payments separately as cash, check, charge card, or
insurance payments.  It lists the provider production separately at the
bottom.

Also, at the bottom of your daysheet are totals for each type of
transaction, yesterday's accounts receivable balance, month-to-date
patient charges, and month-to-date patient payments.  You may also get a
breakdown of payments and a total of "non-production" transactions, if
these items are applicable.

We recommend you fill out the bank deposit slip in duplicate and staple
the copy to the bottom of the daysheet.  You should fill out a bank
deposit form for each day's business regardless of whether or not you
actually go to the bank and make a deposit that day.  The total payments
on the detailed daysheet should agree with the amount of the deposit.




@Reports
^Printing or Viewing the Daysheet

~Style of Daysheet.~  There are three styles of daysheets:  summary,
detailed, and routing slip list.  The summary style summarizes all
procedures entered for a patient in one visit into a single transaction
called Office Visit.  It lists payments separately.  The detailed
daysheet shows each procedure entered, and it also lists detailed
provider production and collection information at the bottom of the
detailed daysheet (Figure 76).  

There are also more important differences between daysheet styles:

    *Summary daysheet contains unmarked voided transactions.

    *The daysheet prints only current month transactions.  Backdated
    transactions are still a part of the current accounts receivable month.

    *The summary daysheet lists all transactions for the day.  This includes
    voided transactions.  It does not mark the voided transactions in any
    way, unlike the detailed daysheet which marks a void transaction with a
    "V."

    *The total dollar amount for the day will be higher due to voided
    transactions.

    *Since voided transactions are included on a summary daysheet, the total
    dollar figure for the day may be higher.  This is the because the
    daysheet includes voided transactions in the calculation of the daily
    total.  Detailed daysheets take the voided transactions into account and
    give you a more "accurate" figure for your daily total.

    *The routing slip list is a listing of patients for whom you printed a
    routing slip on any given day during the current accounts receivable
    month.  This listing indicates the patient's name and number, the
    patient's family number, if treatment was/was not entered, and the
    current family balance.




@Reports
^DaySheet Options

~Daysheet Date.~  Easy Dental Plus automatically fills in today's date for
you.  You may change this date to any date you wish, as long as there
are transactions for that date.  If you close the month, then you cannot
print a daysheet for any date prior to close month, unless you backdate
a transaction to a date prior to the close month date.

~Provider.~  This item is only available for detailed daysheets.  You may
select a provider from a pop-up listing.  Select All Providers to view a
complete daysheet of all activities.  

~Transaction Comments.~  You can include transaction comments on the
daysheet by changing this option to "Yes."  This does not include
doctor's comments.

~Patient Listing.~  After you view the daysheet, the program asks if you
want a listing of patients that you treated during the day.  This report
lists the patients' names, birthdates, and telephone numbers.  The
doctor may want to carry the list home if it is desirable to follow up
on patients seen that day.  After you view this listing, the program
returns you to the initial daysheet screen.

Voided payments do not appear on the Bank Deposit Report.



@Reports
^Bank Deposit Report

The Bank Deposit Report is a report of all payments received for the
range of dates you specify.  This report includes all payment types,
including cash, personal checks, insurance checks (individual and bulk),
and charge card payments.  The program searches through the transactions
in the transaction file and prints all payments with dates that fall
within the date range you specify.  The date range specified must fall
in the current accounts receivable month.  Once you close the month you
cannot print a bank deposit report for dates prior to close month,
unless the payment date was backdated.

The Bank Deposit Report takes two forms:  a summary deposit report, and
a detailed deposit report.

~The summary report:~

    *lists the payor's name
    *indicates the payment amount
    *indicates the check number, if any
    *separates each payment type


~The detailed report:~

    *lists the payor's name and number
    *indicates the check number, if any
    *lists the patient name and number (the owner of the transaction)
    *indicates the payment amount
    *separates each payment type
    *separates the bulk payments into the insurance company name, check
    *number, the patient's name and number, and the payment amount.


To print a the Bank Deposit Report:

Select 7.  Bank Deposit Report.

The screen seen in Figure 77 appears.

Select the date range of payments to include on the report.
If you wish to include a detailed report, change this field to "Yes."
When prompted "Press <Enter> for Report(s) or <Esc> to cancel," press
<Enter>.

The program displays either one or two reports.  The program displays
the detailed report first, if you elected to include the detailed
report; otherwise, the program only displays the summary report.  If you
chose to view both reports, to move from the detailed report to the
summary report press <Esc>.

To print a report, press <Enter> while viewing the report.



@Reports
^Aged Accounts Receivable Report

This report prints in smaller print than most Easy Dental Plus
reports.  It automatically causes your printer to print in the
smaller print mode.  This will work with dot matrix and laser
printers.  It does not work with a daisy wheel type printer.  

~You may print this report at any time.  However, we recommend
that you print this report at least once per month, and keep
that copy for several years.  Because aging is based on the date
of the transactions, the data can be different each time you
print the report.  We recommend that you print this report on
the same day each month.~

If for any reason there is a problem with your printer and this
report:

~*Check to see if you have selected the correct printer in the
System Customization module.~

If the printing display does not list your printer, you can add
it through ~System Customization, option #3.~

~*Determine what print mode your printer is in.~

You will need to set the printer to ~"Draft"~ mode.  See your
printer manual for instructions on how to set your particular
printer to draft mode printing.  


@Reports
^Accounts Receivable Report Options

~Alphabetical, Numerical, or Amount Sort Order.~  This option
allows you to sort the report by either the patient number, the
patient's last name, or the amount owed by the patient.

~All Accounts or By Provider.~  Choosing All Accounts allows you
to print your complete accounts receivable report.  By Provider
prints only an individual provider's report.

~Show Contract Amount or Insurance Portion.~  This option allows
you to choose to either list the amount remaining on a family's
contract(s), or to list the current amount of pending insurance
claims for a family.

~Include/Exclude Unallocated Payments.~  When printing the Aged
Accounts Receivable Report for an individual provider, you may
specify whether or not to include/exclude unallocated payments. 
Normally, this report does not include any unallocated payments
in the dollar amount owed to the provider.  If you choose to
include unallocated payments, the dollar amount owed to the
because an unallocated payment is a payment that you have not
applied to treatment.  If you take this amount into account, it
will lower any remaining balance the patient may owe.
provider will appear lower.

~Show Credits on Report.~  Sometimes your patients may have a
credit balance.  Since you may be interested in only those
patients who have a debit balance, you may set this option to
"No" in order to see only those patients who owe you money.  If
you exclude credits, the amount shown in the Total Due column
may be lower, depending upon the amount of credit a particular
patient has. 

~Credit balances are signified by a negative sign (-) preceding
the number value.~

~Include Insurance on Report.~  This option allows you to include
or exclude the amount of insurance expected.  If you exclude the
insurance amount on the report, the Total Due column will report
a smaller amount of money owed by the patient.  




@Reports
^Delinquent Accounts Report

This report prints the name of each responsible party who has not made a
payment within the last 30 days, and who has a balance greater than 30
days old.  You should print this report on a monthly basis.




@CloseMon
^Close Month

Closing the month is a very important part of the overall Easy Dental
Plus system.  You may elect to close the month any time you desire. 
Closing the month has nothing to do with the calendar month, although
you ought to do this as close to the end of the month as possible.  You
may elect to close the month on the 25th one month and on the 28th the
next.  If you do not close on the last day of the month, Easy Dental
Plus will include in the next month's transactions all the transactions
entered between the closing and the first of the month.

Be sure to view and use the close month checklist in Appendix C.



@CloseMon
^Important Steps That Occur When Closing the Month

Close Month zeros out the monthly activity for each provider.  It does
not affect the year-to-date activity for each provider.  Therefore, if
you want to know how many procedures and how much production each
provider is responsible for, you should print the Summary of Production
By Provider report, located in the Practice Management menu, before you
close the month. 

Close Month looks at each procedure code in your procedure file and
zeros out month-to-date information.  It does not affect year-to-date
data.  It is important, therefore, to print the Report of Fees Charged
by Procedure Code and the Graph of Income by Procedure Code, found in
the Practice Management menu, before you close the month;  otherwise,
the data on the two reports will not reflect the month's activity by
procedure.  Remember that activity for the month is activity since the
last time you closed the month, not the calendar month. 

Close Month moves the prior month's activity to past history 

1.  You need to print the MTD Credits and Payments, and MTD Charges and
Debits reports before you close the month.  This is because these two
reports print the data that Easy Dental Plus considers current.  If you
already closed the month, you will not get accurate information on the
reports.

2.  Since your daysheets contain the current month's transactions, be
sure you have printed daysheets for every day since the last time you
closed the month.  Closing the month clears out the current transactions,
and you will not be able to print your daysheets after you close the month.

3.  Past month's transactions may still be available under certain
circumstances:  

    i.  All open transactions remain open to apply payments and
    adjustments against, but you cannot void them.

    ii.  All undeleted insurance form transactions (see below) remain
    available for printing on that insurance form.

    iii.  Statements still print all open transactions regardless of
    their date or when you last closed the month.  However, you must set
    your monthly statements options appropriately to have this feature.


~Easy Dental Plus deletes insurance claims if:~

*You printed an insurance claim or generated an electronic claim that the
insurance company has accepted

*If you have closed all items that were printed on that claim

*If you have received all payments for that claim, resulting in
no outstanding balance for it.

Close month sets to zero patients' month-to-date credits and debits
figures, and does some "housekeeping" work on the patient files.

Closing the month updates your system control file.  You may want to
look at the Systems Statistics Inquiry in the Practice Management menu
before you close the month.

It updates the scheduler files.

Close month sorts all index files.



@CloseMon
^Items to Consider When Closing The Month

You should close the month approximately every thirty days or so.  If
you never close the month, your system will fail to function properly
when it is time to print statements and other reports mentioned above.

You should perform a backup of your data before you actually close the
month.

Once Close Month is in progress, DO NOT interrupt the program.  This
will create inconsistencies in your system and possibly destroy data.

If you are using multiple terminals, DO NOT enter data of any type when
you are closing the month, including while you print reports before
running Close Month.  Entering data updates many files, and the Close
Month program updates many of the same files.  This could   make your
month-end reports inaccurate.  More importantly, you could lose data.  

~If you have multiple terminals, it is OK to use all of the terminals for
printing the various month end reports before you actually run the Close
Month program.  This will shorten the amount of clock time required.  It
is also OK to be using one terminal to print month end reports while
using another terminal for inquiries or things such as printing labels. 
Just do not enter data from other terminals while closing the month.~
 
If you receive an error during close month, call the DPI technical
support staff at 214-497-1050.

You should set aside as much time as necessary to print all of your
month end reports and close the month.  The amount of time it takes to
print all of your month end reports will vary from one office to
another.  There are many variables that determine the amount of time
required.  An average office should be able to print all reports,
including statements, and close the month in 2 to 6 hours.




@CloseMon
^Steps for Close Month

Backup your data!
Post finance charges (if you charge finance charges).
Post contracts (if you have contracts).
Print monthly reports from the Practice Management menu.  (If this is
the first time you have closed the month, print all the reports out of
this menu. You can then decide which ones to print on a monthly basis
after that.) 
Print monthly reports from accounts receivable (same as above).
Print and/or check daysheets for the month.
Check deposits slips against daysheets.

~At this point be sure to make any corrections necessary for the month.~

REMEMBER:  Once you close the month you cannot void transactions for the
current month.

Print monthly statements.
Close the month.



@CloseYr
^Close Year

The close year process is an important year-end routine that you must
complete before entering the new year's information.  When closing the
year you are:

    *Zeroing all year-to-date totals contained on various reports.
    *Zeroing year-to-date procedures.
    *Resetting patient insurance coverage.
    *Zeroing the Year-to-Date Payment Journal.

This process is in addition to closing the accounts receivable month at
the end of December.  You should close the year before you enter any
more data.

The close year process does not close out the fiscal year, neither does
close year close out the General Ledger.  

You must immediately close the year after closing the month. Refer to
Steps for Close Month for the steps used to close the month.

The Year-To-Date Payment Journal is necessary for your patient's taxes;
the others need only be printed if you need the information.  After you
close the year, Easy Dental Plus sets all items on these reports to
zero.



@CloseYr
^Steps for closing the year

The steps used to close the year are essentially the same as those taken
when closing the month:

Close the month of December.
Print these Practice Management Menu reports:

    *Year-To-Date Payment Journal
    *Report of Fees Earned by Procedure Code
    *Income by Procedure Code Analysis Graph
    *Report of Collections by Provider

Close the Year.

You will then be ready to start the next year's business in January.
 
Please remember, after you have closed the year you cannot "back-date" a
transaction into the previous year's business.  Once you have closed the
year, everything done after that--no matter the date--Easy Dental Plus
considers part of the next year.




@State
^Monthly Statements

You should always print your statements just before you close
the month.  Only persons set up as "Responsible Party" receive
monthly statements.  For those patients who are "Patient Only,"
the program lists their transactions on their responsible
party's statement.   

The system does not print monthly statements for accounts you
turned over to collection agencies, or accounts that have a
balance less than the minimum amount specified on the options
screen.  These accounts do not get a statement even though they
may have had some activity during the preceding month.  In
addition, voided transactions do not appear on monthly
statements.

Be sure to set your statement options before you print your
statements for the first time.  Once you set and save your
statement options, Easy Dental Plus will default to those values.



@State
^Electronic Billing Service

You have the option of having your monthly statements printed,
stuffed, and mailed for you by Charter Data Systems (CDS).  Easy
Dental Plus will put your monthly statements on a diskette that
you can mail to CDS.  No enrollment is necessary because an
invoice prints when you prepare the diskette.  You select the
diskette billing option using the first option on the Monthly
Statement Options Screen:  Form Type to be used.   

~For information about CDS, call them at 1-800-669-0231.~

Also refer to Statements on Diskette.



@State
^Select Options for Monthly Statements

~Statement Form to be used.~  You may select from a list of form
types when printing monthly statements.  The forms that are
available are Form F-3 (9.5 x 11), FL-3 (laser), Old Style (6.5
x 8.5), Diskette (Billing Service), Tops Mailer Form, or you may
generate the entire insurance form on your laser printer.

If you select ~Form F-3~, this prints on 9 by 7 inch continuous
feed form.  Dot-matrix printers use this type of form most
often.  You will need to perform a lineup each time you print
using this form type. 

You cannot customize some of the options for the ~Old Style~
statement.  These options, along with their set values, are:

~*Transaction Type~ -- Summary
~*Print summary Totals~ -- No
~*Bill patients with outstanding claims~ -- Yes
~*Print statements Numerically or Alphabetically~ -- Numerical
~*Show recipient list before printing statements~ -- No
~*Print title on statements~ -- No

If you select ~Form FL-3~, this prints your statements on a laser
form.  This form is an 8 by 11 inch page.  When using this
form, the program will not ask for a lineup.  If it asks for a
lineup, then you have not selected the correct form type.
 
In order to print statements on Form FL-3, or to generate an
insurance form, you must have an HPII compatible laser printer.

If you are using the ~Billing Service~ (CDS) you will not have the
option of changing the answers concerning Summary Totals and
printing the doctor's name and address on the statement. 

~If you select Diskette (Billing Service), and have more than one
floppy diskette drive, the program will prompt you to select the
diskette drive.  Use your arrow keys to toggle between drive A
and B.  If you only have one floppy diskette drive, then it will
automatically select A.~

If you select ~Generate Laser Form~, Easy Dental Plus utilizes the
graphics capability of your HP II compatible laser printer to
generate an entire monthly statement on your laser printer. 

Printing a self-generating monthly statement on the laser
printer increases the printing time because of the amount of
time the laser printer takes to generate the entire form.  Also,
the cost per form will be higher than if you purchased the FL-3
form.  This is due to the amount of toner the laser printer uses
when generating the laser statement. 

~Mailer (Tops Form #1007)~.  The mailer form is a mailer and
monthly statement combined into one form.  The form prints only
on dot-matrix printers.

~Transaction Type to be printed~.  You have two types of
statements you can print.  Detail will print all current
transactions for each patient.  Summary will total charges for
each office visit. 

~You must set this option to Detail in order to print
transactions from the history file (mentioned below).~

~Print transactions from History File~.  This option allows you to
include closed transactions contained in the detailh file
(detailed history).  This means that these transactions are 1)
payments made in the prior month, and 2) treatments fully paid
for.

~You must have this option set to "Yes" in order to include
closed transactions on your monthly statements.  If set to
"Yes," then the option Print Prior Month's Open Transactions is
automatically set to "Yes."~

~Print Prior Month's Open Transactions~.  You can use this option
to print unpaid transactions from prior months onto your current
month's statements.  This does not include payments.  If you
wish to include closed transactions, including payments, you
must set the Print Transactions from History File to "Yes."

~Number of days to include in transactions~.  You can limit the
amount of closed transactions on the statement by selecting a
cut-off point for these transaction types.  You may choose
either:

~*30 days
*60 days
*90 days
*All Transactions~

~Print Running Balance.~  This option allows you to include a
running balance on each statement.  A running balance is a
column that indicates the patient's balance as of a certain
date.  

Running balance only appears on laser forms.

~Send statements only to patients with a balance greater than.~
This option allows you to set a minimum balance for patients. 
Only patient's whose balance is greater than the minimum will
receive a statement.  This will not change a patient's billing
amount.  It will suppress statements for any patient with an
outstanding balance less than or equal to the minimum amount you
enter.   

Example: If you do not want to send statements to patients with
a balance less than $5.00, then enter 4.99.  If you wish to
print statements for all balances, no matter how small, enter
0.00. 

~Send statements only if expected from patient is greater than.~
Using this option allows you to send statements to patients who
owe for their portion of the charges.  Here you may specify the
minimum dollar amount the patient owes.  The program will not
print a statement for any patient under that minimum.

~Be sure to set this value to at least $0.01 (one cent).  If set
to $0.00, the program sends a bill to all patients (responsible
parties) who owe money.~

~Send statements if patient has credit balance less than~.  This
option allows you to send a statement to a family that currently
has a credit balance.  If you desire to use this option, you
must insert the responsible party's name into the recipient list
in order to print a statement.

~Use Co-patient/Insurance billing, and Bill patients with
outstanding claims.~  If you do not wish to send statements to
patients with insurance, select "No."  If you are tracking
insurance claims, you must decide if you would like to use
CoPatient/Insurance Billing.  If you select "Yes," the statement
will reflect the expected insurance participation and the
minimum payment due, calculated by subtracting the expected
insurance participation from the patient's outstanding balance. 
If you do select "Yes," the next question, "Bill patients with
outstanding claims," is automatically set to "Yes."  

~Combine treatment on outstanding claims.~  If you wish to send a
statement to a family that has an outstanding claim, change this
option to "Yes."  



@State
^Select General Options for Statements

~Print Doctor Name and Address.~  This option allows you to either
print the doctor's practice name and address at the top of the
statement, or to use preprinted statements.  

You can change the doctor's address information from the
utilities menu, option #1.

~Print title on statement.~  This option allows you to print a
title for the statement recipient.  This is the title specified
in the patient's information.  Choose "Yes" if you want this
title to appear on the statement.  If  the patient does not have
a title, the program will print the name as usual.

~Print Summary Totals.~  This option prints out a summary total
report.  This report prints after the last statement, and lists
the total aging balances from the printed statements.  These
figures do not represent actual aged accounts receivable.  This
will not affect your statements. 

~All or Individual Provider.~  In a multi-provider practice, you
can use this option to print statements for just one provider,
or for all providers at the same time.  Selecting Individual
allows you to choose the provider to print at the time of
printing your statements.

~Print statements Numerically or Alphabetically.~  This option
allows you to choose the method to use when you print monthly
statements.  Choosing either option allows you to select a
starting and stopping patient number when printing statements. 

When printing statements alphabetically, be sure to show a
recipient listing before you begin printing.  In case of a paper
jam, or you choose to print only a portion of your statements at
that time, you can delete patients from the recipient listing
and begin printing where you stopped.

~Show recipient listing before printing statements.~  If you are
in need of editing your list to avoid sending some patients a
monthly statement, select "Yes." When you are ready to print
statements, a listing will appear on the screen. You will delete
those patients whom you do not want to receive a statement.  You
may also insert patients into this list.  However, these pa-
tients cannot be dependents.  Also, all previously set printing
options will not affect newly added patients.

You may print the recipient listing by pressing P while viewing
this list.

~Print Amount Due at the Top of the Form.~  You may include an
"Amount Due" amount at the top of the statement if you set this
option to "Yes."  The amount printed depends upon your
customization.

If you have customized your statements to ~include~ Co-Patient
Insurance Billing, then the dollar amount in the "Amount Due"
box is equal to the amount of the patient's insurance portion.

If you are ~not using~ Co-Patient Insurance Billing, then the
dollar amount in the "Amount Due" box is the entire portion of
treatment, including the insurance's portion.

~Print last statement sent date on monthly statements.~  This
option allows you to print on the monthly statement the date you
last printed the family a monthly statement.

~Print last insurance filed dates on monthly statements.~  This
option allows you to print the last insurance claim filed date
on the monthly statement.

~Print recall dates on monthly statements.~  Using this option
allows you to print each family member's recall date on the
monthly statement.  The recall date appears as a transaction.

~Print comments on monthly statements.~  If you wish to print
transaction comments on monthly statements, set this option to
"Yes."



@State
^Messages for Monthly Statements


~Messages For Monthly Statements.~  You may include messages on
your monthly statements.  Your message options include messages
for:

~*balances greater than 30 days, 60 days, and 90 days
*payment plans
*a standard statement message.~

You can print a custom message instead of the standard statement
message.  Refer to Patient Entry Fields Defined (Screen #2).

These messages apply only to statements that match those
options, and can only be one line in length.  So, if a patient's
balance is greater than 90 days, and is not on a contract, he
will receive only the over 90 days balance message, and the
standard statement message.



@State
^Printing Monthly Statements

Monthly statement is a somewhat misleading term.  You can print
a statement any time during the month.  You can even print
multiple times during the month; however, once a month is the
norm for printing statements.  The important idea to remember is
this:  You must print statements before closing the month in
order to include on the statement any payments made during the
current month.   This is because any closed transaction will not
appear on a monthly statement after you close the month.  Easy
Dental closes out payments when you close the month.

If you are using the Electronic Billing Service, refer to that section.



@State
^Selecting Print Range 

You may restrict the number of statements you print by selecting
a patient range.  You do not need to start at the beginning of
your patient list, or print to the end of your patient list. 
You may select a starting and ending point anywhere within your
patient database (Figure 47).  The print range is only by
patient number and not alphabetical.  This means that if you  
begin printing at patient number 500,  patient number 500 could
be Mr.  Jones or Mrs. Ambercrombe.  The alphabetical reference
is irrelevant.

~Changing your print option from numerical to alphabetical does
not affect the print range.   ~




@State
^Printing One Statement

You may print a particular patient's statement by changing the
starting and ending patient number to the same value.  For
example, if you wish to print a statement only for patient
number 500, Mr. Jones, change the starting and ending patient
number to 500.  If you wish to print multiple statements for Mr.
Jones, you will need to run the print process multiple times.



@State
^Selecting Preferred Provider

When you move to this field, a pop-up listing of providers
appears.  You may either type the provider's number, or you may
use your arrow keys to select the provider you wish to print
statements for.  If you wish to print for all providers, you can
then select the first option:  All Providers.



@State
^Date To Be Printed on Statements

The statement date is simply the date you are printing the
statement.  You can change this date to any date you wish. 
Changing the date does not affect the aging of transactions;
neither does it affect what transactions the program prints on
the statement.



@State
^Payment Due Date

You can specify a due date for payments by changing the date in
this field.  The date defaults to the current date.



@State
^Standard Message

You can override the standard message from the print statements
screen (Figure 47).  You can also set this message from the
monthly statement options.  If the responsible party has a
customized message, the standard message will not print on the
statement.  



@State
^Statements on Diskette

If you are processing your statements through the Electronic
Billing Service, Easy Dental Plus does not print your statements
onto paper but sends the statement information to a DOS file on
your hard drive.  It then takes this information and places it
onto a floppy disk that you mail to the Electronic Billing
Service.  To send statements to the billing service:

Print statements as though you are printing onto the statement
form.

At this point, the program writes the statement information to a
DOS file.  After the statements are on the hard drive, the
program compresses the file.

Insert a floppy disk into the drive specified in the statement
options screen (Figure 45, page 78).

Easy Dental Plus writes the billing information to the floppy
diskette. 

Load your printer with plain white paper.

Once your printer is ready, the program prints an invoice onto
the plain white paper.

Fill out the invoice and send it with the floppy diskette to
CDS.  



@State
^Billable Accounts Log

After you print statements, Easy Dental Plus presents you with a
report detailing all responsible parties who have a balance
greater than zero.  This report will detail patients:

~*who received a statement, 
*their aged balances,
*their expected insurance and contract balance.~

The Billable Accounts Log does not list patients who do not meet
the above criteria.  

If you have added patients to the recipient listing they will
not appear on the Billable Accounts Log.



@State
^Recipient List

When printing monthly statements you have the option to view
and/or print a recipient list.  This list contains:

~*patient name
*patient number
*current balance
*expected amount from primary and secondary insurance
*last statement sent date.~

Refer to Select Options for Monthly Statements for information on how
to set the recipient list option.



@State
^Recipient List Functions

While viewing the recipient list you may perform any of the
following actions:

~*Insert a patient into the list by pressing <Ins>.~

The patient you insert must be a responsible party.

~*Delete a patient from the list by pressing <Del>.
*Print the recipient listing by pressing P.~




