@Proc
^Procedure Codes

The standard fee schedule contains the procedure codes that describe the
work that you do in the operatory.  In addition to the standard fee
schedule, you may create custom fee schedules for coverages in your
system.  This feature is useful for those coverages that have insurance
through HMO plans.  If you are a participating provider for an HMO, and
you have agreed to charge patients only the amount the HMO will pay, then
you may want to have a different fee schedule for the patients covered
under the HMO plan.  Custom fee schedules are also useful for state
programs that may use set fees and even non-standard codes to describe
procedures.  

The Easy Dental Plus system automatically uses your standard fee schedule
for patients that do not have insurance coverage.  The only time the
system automatically uses a custom fee schedule is when you have met the
following conditions: 

     *You have created a custom fee schedule

     *You have indicated to Easy Dental Plus that a patient does have
     insurance coverage

     *The patient's primary coverage uses a custom fee schedule.

Refer to Copying Fee Schedules for information on creating custom
fee schedules.


@Proc
^Fee Schedules

Easy Dental Plus utilizes fee schedules to process patient treatment  and
insurance claims.  The purpose of a fee schedule is to specify a 
particular dollar amount for treatment that you charge the patient and/or 
insurance carrier.  The treatment is listed under one of three 
categories: Basic, Major, and Preventive.  The patient's coverage uses 
these categories to determine how much insurance participation occurs.  

Refer to Copying Fee Schedules for information on creating custom
fee schedules.

              

@Proc
^Add or Change Procedures and Fees

Adding procedures and fees or changing current procedures and fees allows
you to customize your system to use specific fees and procedures when
entering treatment.  The procedures and fees that come with Easy Dental
Plus are generic.  You should change them to fit the needs of your
practice.

You may add any procedure you wish, or change any fee that you desire;
however, please keep in mind the following guidelines when making any
changes to a fee schedule:

     *You can only add procedures to the standard fee schedule.  The
     new procedure code will then appear in all custom fee schedules
     and payment schedules, if any.  Once entered there, you may edit
     the procedure in the custom fee schedule.

     *Make sure the procedure code is a five digit code, if you wish
     to keep your fees categorized properly. 

     *Use leading zeroes to make a procedure code five digits in
     length. 

     *If you wish to use a lookup code that is similar to the code you
     are adding or editing, be sure to enter that code in; otherwise,
     the lookup code defaults to the first 8 characters of the
     description.  

     *Be sure to exit all the way to the procedure code menu to allow
     the program to sort any newly entered procedures.

     *Do not try to look back at newly created procedure codes unless
     the program has sorted them. 



@Proc
^Procedure Code Fields

~Standard Procedure Code.~  A procedure code is a five digit code that
represents a treatment.  If the code is less than five digits, the program
does not categorize it as expected, and lists it under the Miscellaneous
category.  If the code to enter is less than five digits, enter leading
zeroes in front of the code to make it five digits long.

     Example:  "110"  is an invalid procedure code, whereas "00110"
     is valid.
     
~Procedure Description.~  This is a 78 character field that describes the
procedure code.  
     
~Lookup Code~.  The lookup code is a special code you create that you use
to access a procedure when entering treatment or changing codes.  This
code defaults to the first eight characters of the description.  

~Insurance Code~.  This is the code the program prints on insurance forms. 
Some HMO's may require that this be different from the standard code.

~Units of Time~.  A unit of time is the amount of time a procedure
normally takes for you to perform.  The basis for a unit is whatever time
frame the user wishes to use.  

~Standard Fee~.  The fee normally charged for a procedure.  You may
override this fee when entering treatment.   

~Apply to Individual Teeth~.  This field asks if you can apply this
procedure to individual teeth. This field is important if you use
Electronic Claims.  If you set this option to "Yes," then whenever you
enter treatment, the program prompts you to enter the tooth and surface.

~Coverage Classification~.  There are four coverage classifications: 
Preventive, Basic, Major, and Not Covered.  This question is strictly for
insurance purposes, and is particularly important if you use Co-Patient/
Insurance Billing.

~Print on Insurance Form~.  If you want this procedure to not print on an
insurance form, select N for "No."

~Count this as a prophy~.  You may select a procedure that is to count as
a prophy by setting this option to "Yes."  The enter treatment process
uses this information to determine whether the program needs to update the
next recall date.

~Procedure invalid for this fee schedule~.  The program uses this flag to
prohibit the use of a procedure code for a particular fee schedule.  If
you use a certain procedure in only one fee schedule, then set this option
to "Yes" in all other fee schedules to prevent those fee schedules from
using this procedure.  

~Revenue~.  Shown as fields 20 through 22, this information indicates how
much production you completed for the current month, the current year, and
compares this year's figures with those of last year's.

~Units Performed~.  Shown as fields 23 and 24, this is a breakdown of the
number of times you performed that procedure during the current month and
the current year.



@Proc
^Edit All Fees on a Fee Schedule

Easy Dental Plus allows you to edit all your fees in a fee schedule
quickly and easily by displaying all fees on the screen at one time.  The
program will display:

     ~*the standard code 
     *the insurance code
     *the procedure description
     *whether it prints on an insurance form
     *the coverage classification
     *the fee to be altered.~


To edit procedure fees:

Choose 2.  Edit All Fees on a Fee Schedule. 

If you have more than one fee schedule use the arrow keys to
highlight the appropriate choice, then press <Enter>. 

Press <Tab> or <Enter> to move to the fee you wish to change. 
Type in the fee change, then press <Enter>. 
Repeat the above steps until you make all your changes. 
Press <Esc> to move the cursor to the bottom of the screen. 
Save your changes.


@Proc
^Automatically Change All Fees

Changing fees one at a time can be a time consuming task if the changes
you need to make are essentially similar.  If your practice wishes to
change all fees by a set dollar amount or by a set percentage, then you
may do so by using option #3, Automatically Change All Fees.

When changing your fees using this method, consider the following before
beginning:

     *When changing your fees by percentage, be sure of the changes. 
     Changing fees by 15% does not mean that changing them back by
     15% will return them to their original amount.

     *Make a backup of your data before changing any fees, whether by
     dollar or percentage.

     *If you are rounding to the nearest $10, and one of your fees is
     less than $5, then the computer will round down to $0.
     

To change all your fees:

Select 3.  Automatically Change All Fees. 

     If you are using more than one fee schedule, use the arrow keys
     to select the appropriate fee schedule. 

Using the arrow keys, select either Percentage or Dollar amount.
Enter either the percentage or dollar amount to change your fees
by.
Save your changes.



@Proc
^Change Fee Schedule's Name

If you use custom fee schedules, you may change the name of any of these
schedules.  DPI does not recommended, however, that you change the name of
the Standard Fee Schedule.

Changing the name of a fee schedule does not create a fee schedule.  You
create a fee schedule in the employers/coverages menu.  

The steps to change a fee schedule's name are:

Select 4.  Change Fee Schedule's Name.    
Select the fee schedule name you wish to change.
Type in the new name of the fee schedule.
Save your changes.



@Proc
^Copying Fee Schedules

In the event you need a new fee schedule that is almost exactly like
another fee schedule that you currently have, instead of creating a new
schedule through normal means, you can copy your fee schedule into either
an existing fee schedule or a new fee schedule.  

To copy a fee schedule:

From the Employer Menu select 1.  Add or Change Coverages.
With the cursor at the bottom of the screen, type 17 (Fees to
Bill Patient field).
Press <Enter>.
Using the arrow keys, highlight Create a New Schedule.
Press <Enter>.
Press <Esc> to move the cursor to the bottom of the screen.
When prompted "To edit, <Tab> or enter Item #; To continue,
press <Enter>," press <Enter>.

Depending upon the options set for this particular employer, you may see a
screen similar to that seen in Figure 80.  If so, press <Enter> while
the cursor is at the bottom of this screen.  Figure 97 now appears.

You now have a choice to make.  You can either copy the Standard Fee
Schedule into the new fee schedule, or you can select another fee schedule
to copy from into the new fee schedule.


If copying from the Standard Fee Schedule:

Type the new fee schedule's name.
Save your changes.


If copying from a different fee schedule:

Press <Shift-Tab> to access the Fee Schedule to Copy From field.
Using your arrow keys, select the fee schedule to copy from.
Press <Enter>.
Type the new fee schedule's name.
Save your changes.


@Proc
^Screen Inquiry

You may view the procedure code information at any time by performing a
screen inquiry.  The information you can view is exactly the same as you
see when creating or editing a procedure code.  You cannot print or edit
these fields.

To view a procedure code:

From the Procedures menu select 5.  Screen Inquiry.
Enter the lookup code of the procedure you wish to view. 

The program displays the information on the screen.

Press any key to return to the previous screen. 


@Proc
^Print Master Fee Schedule
 
You can view or print a list of fees for any fee schedule.  This list
resembles the list found in Figure 98.

To print a fee schedule:

From the Procedures menu select 6.  Print Master Fee Schedule. 

A listing of procedures, descriptions, and fees will appear on the screen. 

To print the list press <Enter>. 



@Proc
^Edit Payment Schedule

If your office uses a method to keep track of current fees charged to
clients using a PPO, HMO, or other health plans, you may change those fees
to reflect the correct fees you apply to patient treatment.  The process
for changing these fees is identical to changing fees for a fee schedule.
Refer to Edit All Fees on a Fee Schedule for editing a fee schedule.

Choose 7.  Edit Payment Schedule. 

If you have more than one payment schedule use the arrow keys to highlight
the appropriate choice, then press <Enter>.   

You will now see a screen that lists your procedures.

Press <Tab> or <Enter> to move to the fee you wish to change.
Type in the fee change, then press <Enter>. 
Repeat the above steps until you make all your changes.
Press <Esc> to move the cursor to the bottom of the screen. 
Save your changes.




@Proc
^Automatically Change a Payment Schedule's Amounts

When changing your fees using this method, consider the following before
beginning:

     *When changing your fees by percentage, be sure of the changes. 
     Changing fees by 15% does not mean that changing them back by
     15% will return them to their original amount.

     *Make a backup of your data before changing any fees, whether by
     dollar or percentage.  

     *If you round to the nearest $10 and one of your fees is less
     than $5, then the computer will round down to $0.

     *You will lose your accumulated payment history on your coverage
     amounts if you change the amounts covered.

      
To change payment schedule amounts automatically:

Select 8.  Automatically Change A Payment Schedule's Amounts. 

If you are using more than one fee schedule, use the arrow keys to select
the appropriate fee schedule.  Press <Enter>.

Using the arrow keys, select either Percentage or Dollar amount.
Enter either the percentage or dollar amount to change your fees by.  
Press <Enter> to continue. 
When prompted "Press <Tab> to make a change or <Enter> to change
fees,"  press <Enter>.
Save your changes.



@Proc
^Change Payment Schedule's Name

Changing the name of a payment schedule does not create a payment
schedule.  You create a payment schedule in the Employers/Coverages menu.
Refer to Creating a New Payment Schedule for this information.

The steps to change a payment schedule's name are simple:

Select 9. Change Payment Schedule's Name. 

If you are using more than one payment schedule, use the arrow keys to
select the appropriate payment schedule. 

Enter the new payment schedule name.
Press <Esc> to accept the new name and move the cursor to the bottom of
the screen.          
Save your changes.



@Proc
^Creating a New Payment Schedule

You create a payment schedule in the employers/coverage menu when adding
or editing a patient's coverage.  

Choose 42.  Coverages/Employers.
Select 1.  Add or Change Coverages. 
Select the patient's coverage that will use the new fee schedule.
From the bottom of the screen press 8 <Enter>.  This will highlight the
User Payment Schedule field. 
Press Y <Enter> to change this field to "Yes."   

A pop-up box appears containing a listing of currently existing payment
schedules, or just one entry that says "Create A New Schedule." 

Using your arrow keys highlight Create A New Schedule, then press
<Enter>. 
Press <Esc> to move the cursor to the bottom of the screen. 
Press <Enter> to continue. 
Save your changes.
Type in the new name of the new payment schedule, then press <Enter>. 
Enter the percentages for fields 2 through 4 as the basis for the new
payment schedule.
Save your changes.



@Proc
^Printing Payment Schedule

7To print a payment schedule:

Select 10.  Print Payment Schedule. 
If using more than one payment schedule, use your arrow keys to select
the payment schedule list your wish to print. 

A listing of procedures, descriptions, and fees will appear on the screen. 

To print the list, press <Enter>.


@Proc
^Deleting Procedures

You can delete procedures in all fee schedules using this option.  Unlike
other programs that ask for a fee schedule to use, when deleting
procedures you are removing them from all fee schedules at the same time. 
This is because when you create a new procedure code, you create it in the
Standard Fee Schedule. This makes is accessible to all fee schedules. 
Once deleted from the Standard Fee Schedule, the procedure code is no
longer accessible to any custom fee schedule.  

To delete a procedure code:

Select 11.  Delete Procedures.
Press <Tab> until you highlight the procedure you wish to delete.
Mark the procedure you wish to delete by pressing D.
When finished marking procedures to delete, press <Esc>. 
Press <Enter>.
Save your changes.





@Proc
^Explosion Codes

If you find that you enter certain procedure codes in groups,
you can create special codes called Explosion Codes to group
these codes together.  Explosion Codes are master codes that
consist of ADA codes that you commonly enter together during
treatment.  This will create for you a short-cut during
treatment entry.

There are three parts to this screen:  Explosion Code,
Description, and Procedures Included.


~Explosion Code~

This is the "master" code that you use to group together your
ADA codes into a "common" list.  You may designate this code any
way that you wish, using either numbers, letters, or
alphanumeric characters.  Whatever you use, make sure the code
you create is meaningful to you.  You may not have duplicate
explosion codes.  The system will warn you if you attempt to use
a duplicate code.  This also applies to using a code that you
have already designated as a procedure code.


~Description~

This is strictly for assisting you in selecting the correct
explosion code when your memory fails you.  The description does
not become integrated within the lookup code, as it does when
you create a procedure code.  Be sure to describe your explosion
code to reflect what your code does.  For example, if you create
an explosion code that combines procedures that you normally
chose for a child's dental examination, you may describe this
code as "Normal Child Examination."  

If you create an explosion code that includes some "unusual"
procedures for a child's dental examination, you may describe
this as "Child Examination- XXX," where "XXX" is a descriptive
word or phrase that identifies the difference between it and a
"normal" child's examination.  


~Procedures Included~

When entering procedure codes, select only those codes that you
commonly enter during a particular treatment session. For
example, when seeing a patient for the first time, and the
patient is having an oral exam, what procedures would you
normally use for such a situation?  

You may, at the time of entering treatment, delete a procedure
code from treatment entry, but this will not eliminate the
procedure code from the explosion code.  You can only do that
from Add or Change Explosion Codes.  



@Proc
^Restrictions

There are some restrictions when using explosion codes:

~*You must have at least one procedure code in the explosion code.

*You may enter only 30 procedures in the explosion codes.   When
entering treatment, if you have 25 procedures and you choose an 
explosion code that has seven procedures, then the program
accepts only five of those procedures.~

You can enter only 30 procedures at one time when entering
treatment.

~*Be aware that if you use number codes for your explosion codes
they can become confused with ADA codes.

*The lookup code for the explosion code cannot be the same as a
lookup code.

*You cannot use an explosion code within an explosion code.

*Explosion codes are not fee schedule specific.  You cannot
create an explosion code for a specific fee schedule.     

*If a procedure in the explosion code is invalid for the fee
schedule you have selected, then the program excludes that
procedure code when entering treatment.~



@Proc
^Creating an Explosion Code

Choose option 12.  Add or Change Explosion Codes.  
To enter a new explosion code press <Enter>.  
Type in the lookup code you wish to use for the explosion code.
Type in the description of the explosion code.
Press <Ins> to add a procedure code to the explosion code.
Enter the procedure code.

This process continues until you have entered all the procedure
codes you wish to associate with the explosion code.

Press <Esc> when finished entering the procedure codes.
Save your changes.



@Proc
^Editing an Explosion Code

The process for editing an explosion code is virtually the same
for creating an explosion code, with a few minor differences:

~*Instead of pressing <Enter> when creating an explosion code,
enter the explosion code's lookup code instead.

*Use the <Del> key to remove procedures from the explosion code.~

If you eliminate all procedure codes from the explosion code,
you can delete the explosion code.



@Proc
^Deleting Explosion Codes

Deleting an explosion code is a simple process.  All you need to
do is delete the procedures associated with the explosion code.

Choose option 12.  Add or Change Explosion Codes.  
Enter the explosion code you want to delete.  
After the explosion codes appear on the screen, press <Tab> to
highlight the first procedure code.
Press <Del> to delete the procedure code.  
Continue to delete the procedure codes until you remove all
codes.
Press <Esc> to get to the bottom of the screen.
Save your changes.



@Proc
^Viewing Explosion Codes

Explosion codes are similar to procedure codes, but not similar
enough for you to view them as part of a listing of procedure
codes.  You can, however, view your explosion codes separately. 
When viewing explosion codes you will see these elements:

~*explosion code
*explosion code description
*related procedure codes
*procedure code description~

Remember, an explosion code can be made up of numbers, letters,
or a combination of both.

If you press ~?~ to get a listing of explosion codes, you will get
a listing of all procedure codes.  Simply use the up arrow to
get to the bottom of this list.  You will find your explosion
codes there.


To view explosion codes:

Select Print Explosion Code List.

You will then see a pop-up listing of choices:  View All
Explosion Codes, or View Specific Explosion Code.

Select either of the above choices.
If viewing a specific explosion code, enter the explosion code
number.

You will now see a listing of all your explosion codes, unless
you chose to view a selected explosion code.

When you have finished viewing the list, press <Esc>.



@Custom
^Printing Explosion Codes

The process for printing explosion codes is the same as for
viewing these codes.  The difference is that you press <Enter>
while Viewing Explosion Codes.


