/* This command file creates diskettes from images */
ADDRESS CMD 
'@ECHO OFF'

/* Define disks */
Disks = 9
Disk.1.Name = 'INET21.DSK'
Disk.1.Text = 'IBM Internet Connect Server V1 for OS/2 Warp (1/2)'
Disk.2.Name = 'INET22.DSK'
Disk.2.Text = 'IBM Internet Connect Server V1 for OS/2 Warp (2/2)'
Disk.3.Name = 'INETA1.DSK'
Disk.3.Text = 'IBM Internet Connect Server V1 for AIX (1/3)'
Disk.4.Name = 'INETA2.DSK'
Disk.4.Text = 'IBM Internet Connect Server V1 for AIX (2/3)'
Disk.5.Name = 'INETA3.DSK'
Disk.5.Text = 'IBM Internet Connect Server V1 for AIX (3/3)'
Disk.6.Name = 'INETW1.DSK'
Disk.6.Text = 'IBM Internet Connect Server V3 for Windows (1/4)'
Disk.7.Name = 'INETW2.DSK'
Disk.7.Text = 'IBM Internet Connect Server V3 for Windows (2/4)'
Disk.8.Name = 'INETW3.DSK'
Disk.8.Text = 'IBM Internet Connect Server V3 for Windows (3/4)'
Disk.9.Name = 'INETW4.DSK'
Disk.9.Text = 'IBM Internet Connect Server V3 for Windows (4/4)'

do while key \= 'Q'
   say ''
   say 'Choose one of the following diskettes to create:'
   say '------------------------------------------------'

   do I = 1 to Disks
      say I' - 'Disk.I.Text
      end /* do */
   say 'Enter F to format a diskette or Q to quit'
   say ''
   call charout , 'Choose a diskette: '

   PULL key

   select
      when key = 'F' then DO
         say 'Please make sure a scratch 1.44MB diskette is in drive A:'
         'PAUSE'
         'FORMAT A:'
         END
      when key = 'Q' then
         say 'Goodbye!'
      when \DATATYPE(key, 'N') then
         say 'Please enter 1 through 'Disks', F, or Q.'
      when (key >= 1) & (key <= Disks) then DO
         say ''
         say 'Please make sure a blank, formatted 1.44MB diskette is in drive A:'
         'PAUSE'
         say ''
         'LOADDSKF 'Disk.key.Name' A:'
         'PAUSE'
         END
      otherwise
         say 'Please enter 1 through 'Disks', F, or Q.'
      END /* select */
   end /* do */

EXIT
