Program TestDoor; {Example of DDK commands found in v1.00sc}
{$M 65000,0,650000} {this is overkill in size, but I always use it in my exe!}

Uses DDK,      {Non-OOP Door Developers Interface}
     DDK_OS,   {Operating System Detection - And TimeSlice Routine}
     DDK_Glob, {DOOR DROP FILES}                                   
     DDK_Stat, {Status Bar OBJECT}
     DDK_Logs, {Logging System}
     WGPrompt, {implemented in v1.00sc [Multilingual Prompting]}
     WGBFile,  {implemented in v1.00sc (Buffer File I/O)}
     WGScreen; {For Window Command and LOCAL I/O - DDK Does not manage this!}

Var
   Loop:Byte;
   Ws:String;
   Language:PromptObj;  {WgPrompt.TPU}
   BFH:FFileObj;        {WGBFile.TPU}
   WhichStatus:Byte;

Const
   LastShow:Longint=91000;
   Expired:Boolean=False;  {if true - user has been online too long!}

{$F+}
Function  DoStatus:Boolean;
Var
   Calc:Longint;
Begin
   If LastShow<>TimeLeft(DDKInfo.GetTimeLeft) then Begin
      LastShow:=TimeLeft(DDKInfo.GetTimeLeft);
      Case WhichStatus of
	 0:Begin
	   StatusBar.Show1(Pad2Right(DDKInfo.GetUsrFName+' '+
			   DDKInfo.GetUsrLName,' ',35)+
			   '@X4ENode '+Pad2Left(Long2Str(DDKInfo.GetNode),' ',3)+
			   '@X1F Time (Left '+
			   LongTimeStr(TimeLeft(DDKinfo.GetTimeLeft))+
			   ') (On '+LongTimeStr(TimeOn)+')');
	   StatusBar.Show2(Pad2Right('Security: '+
			   Pad2Right(Long2Str(DDKInfo.GetSecLvl),' ',7)+
			   'COM'+Long2Str(DDKInfo.Getcomport)+' BAUD: '+
			   Pad2Right(CommaStr(DDKInfo.Getbaudrate),' ',7),' ',60)+
			   '@X5F Memory Left: '+Long2Str(MemAvail div 1024)+'k ');
	   End;
      End;
   End;
   Expired:=(LastShow<=0);
   DoStatus:=Expired;
End;
{$F-}

Procedure Introduce;
Begin
   _TextBackground(0);
   _ClrScr;
   FBox(1,1,80,3,15,3,1);
   _FastWrite(3,2,$3B,'Welcome to the');
   _FastWrite(WhereX+1,2,$3A,'Info System Technology, Inc.');
   _FastWrite(WhereX+1,2,$3B,'Door Development Kit');
   _FastWrite(WhereX+5,2,$3E+128,'DEMO');
   _FastWrite(1,12,14,Pad2Center('Unregistered Demo Evaluation',' ',80));
   Box(25,11,56,13,3,0,2);
   _GotoXy(1,22);
   _TextColor(9);
   DoPause;
End;

Procedure Colors;
Var
   F,B:Byte;

Begin
   _ClrScr;
   For F:=0 to 15 do
      For B:=0 to 15 do
	 _FastWrite(17+(B*4),5+F,((B shl 4) or F),' '+HexByte((B shl 4) or F)+' ');
   _GotoXY(1,22);
   _TextBackground(0);
   _TextColor(10);
   DoPause;
End;

Procedure _System;
Var
   Ws:String;
   OffSet:Byte;

Begin
   _ClrScr;
   FBox(10,5,70,12,15,1,4);
   _GotoXY(12,6);
   _Write('COMSPEC');
   _GotoXY(12,7);
   _Write('SHARE.EXE');
   _GotoXY(12,8);
   _Write('PATH');
   _GotoXy(30,6);
   _Write(GetComSpec);
   _GotoXy(30,7);
   If ShareLoaded then _Write('YES')
   Else _Write('NO');
   _GotoXy(30,8);
   _Write(WWrap(GetEnvironment('PATH'),38,Ws));
   OffSet:=0;
   While Ws<>'' do Begin
      Inc(OffSet);
      _GotoXy(30,8+OffSet);
      _Write(WWrap(Ws,38,Ws));
   End;
   _TextBackground(0);
   _TextColor(11);
   _GotoXy(1,22);
   DoPause;
End;

Procedure DropInfo;
Begin
   _ClrScr;
   _Write(Pad2Center(Language.GetString(21),' ',80));
   _FastWrite(1, 2,12,Language.GetString(22)+DDKInfo.GetDropPath+'  '+
      Language.GetString(23)+Long2Str(DDKInfo.AI^.DoorType));
   _FastWrite(1, 3,14,Language.GetString(24)+DDKInfo.GetBBSName);
   _FastWrite(1, 4,14,Language.GetString(25)+DDKInfo.GetSysFName);
   _FastWrite(1, 5,14,Language.GetString(26)+DDKInfo.GetSysLName);
   _FastWrite(1, 6,15,Language.GetString(27)+Long2Str(DDKInfo.GetComport));
   _FastWrite(1, 7,15,Language.GetString(28)+Long2Str(DDKInfo.GetComport));
   _FastWrite(1, 8,15,Language.GetString(29)+Long2Str(DDKInfo.GetNode));
   _FastWrite(1, 9,15,Language.GetString(30)+Boostr(DDKInfo.isLocal));
   _FastWrite(1,10,15,Language.GetString(31)+Long2Str(DDKInfo.getLockBaud));
   _FastWrite(1,11,15,Language.GetString(32)+Long2Str(DDKInfo.GetMaxTime)+' ('+LongTimeStr(DDKInfo.GetMaxTime)+') ');
   _FastWrite(1,12,11,Language.GetString(33)+DDKInfo.GetUsrFName);
   _FastWrite(1,13,11,Language.GetString(34)+DDKInfo.GetUsrLName);
   _FastWrite(1,14,11,Language.GetString(35)+Long2Str(DDKInfo.GetSeclvl));
   _FastWrite(1,15,11,Language.GetString(36)+Long2Str(DDKInfo.GetTimeLeft)+' ('+LongTimeStr(DDKInfo.GetTimeLeft)+') ');
   _FastWrite(1,16,10,Language.GetString(37)+Boostr(DDKInfo.isASCII));
   _FastWrite(1,17,10,Language.GetString(38)+Boostr(DDKInfo.isANSI));
   _FastWrite(1,18,10,Language.GetString(39)+Boostr(DDKInfo.isAVATAR));
   _FastWrite(1,19,10,Language.GetString(40)+Boostr(DDKInfo.isRIP));
   _FastWrite(1,20,10,Language.GetString(41)+Boostr(DDKInfo.isNAPLPS));
   _Writeln('');
   DoPause;
End;

Procedure Process;
Var
   Ch:Char;
   I:Byte;
   Max:byte;

Begin
   Repeat
      _TextBackground(0);
      _ClrScr;
      _TextColor(15);
      _Write(Pad2Center(Language.GetString(15),' ',80));
      _GotoXy(1,2);
      _Write(Pad2Right('','',80));
      Max:=18;
      For I:=1 to 4 do
         If Length(Language.GetString(15+I))>Max then 
         Max:=Length(Language.GetString(15+I));
      FBox(20,5,Max+22,10,15,1,1);
      For I:=1 to 4 do _FastWrite(22,5+I,TAttr,Language.GetString(15+I));
      _FastWrite(1,22,12,Language.GetString(20));
      Repeat
	 DoStatus;
      Until _Keypressed or Expired or Not _ModemCarrier;
      Ch:=Upcase(_ReadKey);
      _TextColor(15);
      _Write(Ch);
      Case Ch of
	 'C': Begin
		LogEntry.WriteEntry('Showing Color Chart');
		Colors;
	      End;
	 'S': Begin
		LogEntry.WriteEntry('Showing "SYSTEM" Information');
		_System;
	      End;
	 'D': Begin
		LogEntry.WriteEntry('Showing "DROP FILE" Information');
		DropInfo;
	      End;
      End;
   Until (Ch='Q') or Not _ModemCarrier or Expired;
   If Expired then Begin
      LogEntry.WriteEntry('Time limit has expired!');
      LogEntry.WriteEntry('Automatically Shutting Down...');
   End;
End;

Procedure ShutDown;
Var
   Ws:String;
   NR:Word;

Begin
   BFH.Init(8192); {8k Buffer}
   BFH.Open('TESTDOOR.DSP',66);  {shared i/o}
   If BFH.MyIOResult=0 then Begin {no error opening!}
      While (BFH.FilePos<BFH.RawSize) and
         (BFH.MyIOResult=0) and
         (_ModemCarrier) {and not aborted!} do Begin
         BFH.BlkRead(Ws[1],255,NR);
	 Ws[0]:=Chr(NR);
         _Write(Ws); {dump it to the video/port - for speed!}
                     {could do Replace(WS,MetaCode,RealString) then write!}
      End;
      BFH.CloseFile;
   End
   Else Begin
      _Writeln(Language.GetString(42));   
      {Delay(1000);}
      DDKInfo.Done;
      Language.Done;
      Halt;
   End;
End;

Procedure Usage;                  
Var
   I:Byte;

Begin
   LogEntry.WriteEntry('No Command Line Parameters - Showed Help Screen');
   ClrScr;
   Writeln(Language.GetString(1));
   Writeln;
   Writeln(Language.GetString(2));
   Writeln(Language.GetString(3));
   Writeln;
   For I:=4 to 14 do
      Writeln(Language.GetString(I));
   DDKInfo.Done;
   Language.Done;
   LogEntry.Done;
   HALT;
End;

Begin
   LogEntry.Init;
   LogEntry.SetlogName('\TESTDOOR.LOG');
   LogEntry.Set4DigitPID('DDK1');
   LogEntry.Format_dd_mmm_yy_hh_mm_ss_pid;
   LogEntry.WriteRawEntry('***> TESTDOOR DDK DEMOSTRATION STARTUP <***');
   Language.Init;
   Language.Load('TESTDOOR.LNG'); {error checking?}
   If not Language.StrInfo^.Loaded then Begin
      Writeln(' Unknown Error Occured accessing TESTDOOR.LNG');
      LogEntry.WriteEntry(' Unknown Error Occured accessing TESTDOOR.LNG');
      Language.Done;
      LogEntry.Done;
      Halt;
   End;
   DDKInfo.Init;
   If Paramcount=0 then Usage;
   For Loop:=1 to Paramcount do Begin
      Ws:=Upper(Paramstr(Loop));
      If Ws[1] in ['/','-'] then Begin
	 Ws:=Copy(Ws,2,255);
	 If Language.GetChar(43)=Ws[1] then DDKInfo.SetDoorType(0) else
	 If Language.GetChar(44)=Ws[1] then DDKInfo.SetDoorType(1) else
	 If Language.GetChar(45)=Ws[1] then DDKInfo.SetDoorType(2) else
	 If Language.GetChar(46)=Ws[1] then DDKInfo.SetDoorType(3) else
	 If Language.GetChar(47)=Ws[1] then DDKInfo.SetDoorType(4) else
	 If Language.GetChar(48)=Ws[1] then DDKInfo.SetDoorType(5) else
	 If Language.GetChar(49)=Ws[1] then DDKInfo.SetDoorType(6) else
	 If Language.GetChar(50)=Ws[1] then DDKInfo.SetDoorType(7) else
	 If Language.GetChar(51)=Ws[1] then DDKInfo.SetDoorType(8) else
	 If Language.GetChar(52)=Ws[1] then DDKInfo.SetDoorType(9) else
	 If Language.GetChar(53)=Ws[1] then DDKInfo.SetDoorType(10) else
	 Usage;
	 If (DDKInfo.GetDoorType<>0) and (Length(Ws)>1) then
	    DDKInfo.SetDropPath(WithBackSlash(Copy(Ws,2,255)));
      End
      Else Usage;
   End;
   DDKInfo.LoadAllInfo;
   If DDKInfo.GetDoorType=0 then Begin {you could prompt on the screen for this!}
      DDKInfo.SetSysFName('SYSOP');
      DDKInfo.SetusrFName('JOHN');
      DDKInfo.SetusrLName('DOE');
      DDKInfo.SetNode(1);
      DDKInfo.SetLocal(True);
      DDKInfo.SetBaudRate(115200);
      DDKInfo.SetMaxTime(200*60);  {in seconds, so multiply minutes!}
      DDKInfo.SetSecLvl(65000);
      DDKInfo.SetTimeLeft(195*60);  {in seconds, so multiple minutes!}
      DDKInfo.SetAnsi;
   End;
   If Not DDKInfo.IsLocal then Begin    {the modem thang!}
      If Not _Modemopen(False, {use fossil=TRUE}
	 DDKInfo.GetComPort,DDKInfo.GetLockBaud,0,8,1,0) then Begin
	 Writeln(Language.GetString(54));
	 LogEntry.WriteEntry(Language.GetString(54));
	 {Delay(5000);}
	 Language.Done;
	 LogEntry.Done;
	 DDKInfo.Done;
	 Halt;
      End;
      _ModemDTROn; {Some BBS's lower DTR w/o loosing CARRIER on shell to door!}
   End;
   LogEntry.WriteEntry('USER: '+DDKInfo.GetUsrFName+' '+DDKInfo.GetUsrLName);
   StatusBar.Init(True);   {true=2 line status, false=1 line status}
   Statusbar.SetDefaultColor($1F);
   CurrentInteractiveProc:=DoStatus;
   WhichStatus:=0;
   Introduce;
   Process;
   StatusBar.Done;
   Shutdown;
   If Not DDKInfo.IsLocal then _ModemClose;
   LogEntry.BlankLine;
   DDKInfo.Done; 
   Language.Done;
   LogEntry.Done;
End.
