/****************************************************************************

	SPT.C

	Code for the PipeTool server side.  Currently only runs on OS/2 and is
	character mode only.

	Copyright (C) 1992 Microsoft Corporation.

	This code sample is provided for demonstration purposes only.
	Microsoft makes no warranty, either express or implied,
	as to its usability in any given situation.

****************************************************************************/

#define INCL_DOSMEMMGR
#define INCL_DOSNMPIPES
#define INCL_DOSPROCESS
#define INCL_DOSFILEMGR
#define INCL_DOSERRORS
#include <os2.h>			// OS/2 Includes

#include <stdio.h>		// C Runtime Includes
#include <stdlib.h>
#include <string.h>
#include <process.h>
#include <stddef.h>

#include "..\ptlib.h"	// Inlude for PipeTool common routines


/*** Forward Declarations ***/

VOID		main( int, char ** );
USHORT	PipeClosing( HPIPE );
VOID		GetArgs( int, char ** );
VOID		Usage( VOID );


/*** Global Data, set with command line switches ***/

CHAR		pszPipeName[256] = "\\pipe\\pt";
USHORT	fsPipeOpenMode = NP_ACCESS_DUPLEX;
USHORT	fsPipeMode = 0;
USHORT	usBufSize = 0;
USHORT	usDataSize = 0;

UCHAR		fRead = 1;
UCHAR		fWrite = 1;
UCHAR		fReset = 0;


/*** Function: main ***/

VOID main( int argc, char * argv[] )
{
	CHAR 		* pcbInData, * pcbOutData;

	HPIPE		hPipe;

	USHORT	fsPipeModeTest = 0;

	UCHAR		cbInfoBuf[ 300 ];
	USHORT	usInfoBufSize = 300;

	USHORT	cbRead, usTotalRead = 0;
	USHORT	cbWritten, usTotalWritten = 0;

	USHORT	OS2RC;

	GetArgs( argc, argv );

	MakeData( &pcbInData, &pcbOutData );

	printf( "Making: %s...", pszPipeName );
	if ( OS2RC = DosMakeNmPipe( pszPipeName,
	                            &hPipe,
	                            fsPipeOpenMode,
	                            fsPipeMode,
	                            usBufSize,
	                            usBufSize,
	                            0L ) )
	{
		printf( "Aborted, DosMakeNmPipe returned %u\n", OS2RC );
		exit(1);
	}
	else
	{
		printf( "OK\n" );
	}
	
	printf( "DosQNmPHandState reports..." );
	if ( OS2RC = DosQNmPHandState( hPipe,
	                               &fsPipeModeTest ) )
	{
		printf( "Error, returned %u\n", OS2RC );
	}
	else
	{
		printf( "\n   pipe mode: 0x%x\n", fsPipeModeTest );
	}

	printf( "Connecting pipe..." );
	while ( (OS2RC = DosConnectNmPipe( hPipe )) )
	{
		DosSleep( 1000 );
		printf( "." );
		if ( OS2RC != ERROR_PIPE_NOT_CONNECTED )
		{
			printf( "Aborted, DosConnectNmPipe returned %u\n", OS2RC );
			exit(1);
		}
	}
	printf( "OK\n" );

	printf( "DosQNmPipeInfo reports..." );
	if ( OS2RC = DosQNmPipeInfo( hPipe,
	                             1,
	                             cbInfoBuf,
	                             usInfoBufSize ) )
	{
		printf( "Error, returned %u\n", OS2RC );
	}
	else
	{
		printf( "\n   Outgoing buff size: %u\n", ((PIPEINFO *)cbInfoBuf)->cbOut );
		printf( "   Incoming buff size: %u\n", ((PIPEINFO *)cbInfoBuf)->cbIn );
		printf( "   Maximum instances:  %u\n", ((PIPEINFO *)cbInfoBuf)->cbMaxInst );
		printf( "   Current instances:  %u\n", ((PIPEINFO *)cbInfoBuf)->cbCurInst );
		printf( "   Length of Name:     %u\n", ((PIPEINFO *)cbInfoBuf)->cbName );
		printf( "   Pipe Name:          %s\n", ((PIPEINFO *)cbInfoBuf)->szName );
	}

	if ( fRead )
	{
		do {
			printf( "Reading: %u...", usDataSize - usTotalRead );
			OS2RC = DosRead( hPipe,
			                 pcbInData + usTotalRead,
			                 usDataSize - usTotalRead,
			                 &cbRead );
			printf( "Read: %u,  Returned: %u\n", cbRead, OS2RC );

			usTotalRead += cbRead;

			if ( !cbRead && !OS2RC && PipeClosing(hPipe) )
			{
				printf( "Client closed pipe, cannot continue reading\n" );
				fWrite = 0;
				break;
			}
		} while ( (usTotalRead < usDataSize) &&
		          ( (OS2RC == NERR_Success) || (OS2RC == ERROR_MORE_DATA) ) );

		CheckData( pcbInData, pcbOutData, usTotalRead );
	}

	if ( fWrite )
	{
		do {
			printf( "Writing: %u...", usDataSize - usTotalWritten );
			OS2RC = DosWrite( hPipe,
			                  pcbOutData + usTotalWritten,
			                  usDataSize - usTotalWritten,
			                  &cbWritten );
			printf( "Wrote: %u,  Returned: %u\n", cbWritten, OS2RC );

			usTotalWritten += cbWritten;

			if ( !cbWritten && !OS2RC && PipeClosing(hPipe) )
			{
				printf( "Client closed pipe, cannot continue writing\n" );
				break;
			}
		} while ( usTotalWritten < usDataSize );


		if ( fReset )
		{
			printf( "Resetting buffer..." );
			if ( OS2RC = DosBufReset( hPipe ) )
			{
				printf( "Error, DosBufReset returned %u\n", OS2RC );
			}
			else
			{
				printf( "OK\n" );
			}
		}
	}

	printf( "Disconnecting pipe..." );
	if ( OS2RC = DosDisConnectNmPipe( hPipe ) )
	{
		printf( "Aborted, DosDisConnectNmPipe returned %u\n", OS2RC );
		exit(1);
	}
	else
	{
		printf( "OK\n");
	}

	printf( "Closing pipe..." );
	if ( OS2RC = DosClose( hPipe ) )
	{
		printf( "Aborted, DosClose of pipe returned %u", OS2RC );
		exit(1);
	}
	else
	{
		printf( "OK\n" );
	}
} /* main */


/*** Function: PipeClosing ***/

USHORT PipeClosing( HPIPE hPipe )
{
	CHAR		cbPeekBuf[256];
	USHORT	usPeekBufSize = 256, usRead, usAvail, usStatus;

	USHORT	OS2RC;

	OS2RC = DosPeekNmPipe( hPipe,
	                       cbPeekBuf,
	                       usPeekBufSize,
	                       &usRead,
	                       (PAVAILDATA) &usAvail,
	                       &usStatus );

	if ( ( (OS2RC == NERR_Success) || (OS2RC == ERROR_ACCESS_DENIED) ) &&
	     ( usStatus == NP_CLOSING ) )
	{
		return(1);
	}
	else
	{
		return(0);
	}
} /* PipeClosing */


/*** Function: GetArgs ***/

VOID GetArgs( int argc, char * argv[] )
{
	int i = 1;

	while ( i < (argc - 1) )
	{
		if ( strcmp( "-b", argv[i] ) == 0 )
		{
			usBufSize = atoi( argv[i+1] );
		}
		else if ( strcmp( "-d", argv[i] ) == 0 )
		{
			usDataSize = atoi( argv[i+1] );
		}
		else if ( strcmp( "-n", argv[i] ) == 0 )
		{
			strcpy( pszPipeName, argv[i+1] );
		}
		else if ( strcmp( "-o", argv[i] ) == 0 )
		{
			fsPipeOpenMode = h_atou( argv[i+1] );
		}
		else if ( strcmp( "-p", argv[i] ) == 0 )
		{
			fsPipeMode = h_atou( argv[i+1] );
		}
		else if ( strcmp( "-t", argv[i] ) == 0 )
		{
			if ( *argv[i+1] == 'X' )
			{
				fReset = 1;
			}
			else if ( *argv[i+1] == 'w' )
			{
				fRead = 0;
			}
			else if ( *argv[i+1] == 'W' )
			{
				fRead  = 0;
				fReset = 1;
			}
			else if ( *argv[i+1] == 'r' )
			{
				fWrite = 0;
			}
		}
		else
		{
			Usage();
		}

		i += 2;
	}

	if ( (fsPipeMode & 0xff) == 0 )
	{
		fsPipeMode |= 1;
	}

	if ( (usBufSize == 0) || (usDataSize == 0) )
	{
		Usage();
	}
} /* GetArgs */


/*** Function: Usage ***/

VOID Usage( VOID )
{
	printf( "Usage:\n" );
	printf( "spt -b <n> -d <n> [-n <s>] [-o <x>] [-p <x>] [-t <c>]\n" );
	printf( "Where:\n" );
	printf( "-b <n>: Buffer sizes requested in DosMakeNmPipe.\n" );
	printf( "-d <n>: Size of data going across pipe.\n" );
	printf( "-n <s>: Pipe name, ie. \\pipe\\pt (default)\n" );
	printf( "-o <x>: Open mode, a combination of:\n" );
	printf( "          Access:\n" );
	printf( "            Duplex       (NP_ACCESS_DUPLEX)    = 0x%x (default) or\n", NP_ACCESS_DUPLEX );
	printf( "            Inbound      (NP_ACCESS_INBOUND)   = 0x%x or\n", NP_ACCESS_INBOUND );
	printf( "            Outbound     (NP_ACCESS_OUTBOUND)  = 0x%x\n", NP_ACCESS_OUTBOUND );
	printf( "          Inherit:\n" );
	printf( "            Yes          (NP_INHERIT)          = 0x%x (default) or\n", NP_INHERIT );
	printf( "            No           (NP_NOINHERIT)        = 0x%x\n", NP_NOINHERIT );
	printf( "          Writebehind:\n" );
	printf( "            No           (NP_NOWRITEBEHIND)    = 0x%x (default) or\n", NP_NOWRITEBEHIND );
	printf( "            Yes          (NP_WRITEBEHIND)      = 0x%x\n", NP_WRITEBEHIND );
	printf( "-p <x>: Pipe mode, a combination of:\n" );
	printf( "          Wait:\n" );
	printf( "            Blocking     (NP_WAIT)             = 0x%x (default) or\n", NP_WAIT );
	printf( "            Non blocking (NP_NOWAIT)           = 0x%x\n", NP_NOWAIT );
	printf( "          Read mode:\n" );
	printf( "            Byte         (NP_READMODE_BYTE)    = 0x%x (default) or\n", NP_READMODE_BYTE );
	printf( "            Message      (NP_READMODE_MESSAGE) = 0x%x\n", NP_READMODE_MESSAGE );
	printf( "          Type (write mode):\n" );
	printf( "            Byte         (NP_TYPE_BYTE)        = 0x%x (default) or\n", NP_TYPE_BYTE );
	printf( "            Message      (NP_TYPE_MESSAGE)     = 0x%x\n", NP_TYPE_MESSAGE );
	printf( "          Instance count:\n" );
	printf( "            1 to 0xff, 1 is default and 0xff means unlimited\n" );
	printf( "-t <c>: Type of transaction, one of:\n" );
	printf( "          Read/write    = x (default)\n" );
	printf( "            w/ BufReset = X\n" );
	printf( "          Write         = w\n" );
	printf( "            w/ BufReset = W\n" );
	printf( "          Read          = r\n" );
	exit(1);
} /* Usage */

