/****************************************************************************

	PTLIB.C

	Code for common functions of the PipeTool program family.

	Copyright (C) 1992 Microsoft Corporation.

	This code sample is provided for demonstration purposes only.
	Microsoft makes no warranty, either express or implied,
	as to its usability in any given situation.

****************************************************************************/

#define INCL_DOSMEMMGR
#define INCL_DOSFILEMGR
#define INCL_DOSERRORS
#include <os2.h>		// OS/2 Includes

#include <stdio.h>	// C Runtime Includes
#include <stdlib.h>
#include <process.h>


/*** Function: MakeData ***/

VOID MakeData( CHAR ** pcbInBuf, CHAR ** pcbOutBuf )
{	
	SEL		selData;
	USHORT *	pDataIndex;
	USHORT	usIndex;
	USHORT	usRC;

	if ( usRC = DosAllocSeg( 0, /* size of segment = 64K (65,536 bytes) */
	                         &selData,
	                         SEG_NONSHARED ) )
	{
		printf( "abort: DosAllocSeg returned %u getting memory for output data.", usRC);
		exit(1);
	}

	*pcbOutBuf = (char *)MAKEP( selData, 0 );

	for ( pDataIndex = (USHORT *)*pcbOutBuf, usIndex = 0;
	      usIndex <= 32767;
	      usIndex++, pDataIndex++ )
	{
		*pDataIndex = usIndex;
	}

	if ( usRC = DosAllocSeg( 0, /* size of segment = 64K (65,536 bytes) */
	                         &selData,
	                         SEG_NONSHARED ) )
	{
		printf( "abort: DosAllocSeg returned %u getting memory for input data.", usRC);
		exit(1);
	}

	*pcbInBuf = (char *)MAKEP( selData, 0 );

	for ( pDataIndex = (USHORT *)*pcbInBuf, usIndex = 0;
	      usIndex <= 32767;
	      pDataIndex++, usIndex++ )
	{
		*pDataIndex = 0;
	}
} /* MakeData */


/*** Function: CheckData ***/

VOID CheckData( CHAR * pcbInBuf, CHAR * pcbOutBuf, USHORT usBufSize )
{
	CHAR *	pInDataIndex;
	CHAR *	pOutDataIndex;

	printf( "Checking data..." );
	for ( pInDataIndex = pcbInBuf, pOutDataIndex = pcbOutBuf;
	      pInDataIndex < pcbInBuf + usBufSize;
	      pInDataIndex++, pOutDataIndex++ )
	{
		if ( *pInDataIndex != *pOutDataIndex )
		{
			printf( "Aborted, corruption found at %x\n", pInDataIndex );
			exit(1);
		}
	}
	printf( "OK\n" );
} /* CheckData */


/*** Function: h_atou ***/

unsigned h_atou( char * pszHex )
{
	USHORT	usTotal = 0;
	USHORT	usDigit;

	if ( ( *pszHex == '0' ) &&
	     ( ( *(pszHex+1) == 'X' ) || ( *(pszHex+1) == 'x' ) ) )
	{
		pszHex += 2;
	}

	while ( *pszHex )
	{
		switch ( *pszHex )
		{
			case '0': usDigit = 0;  break;
			case '1': usDigit = 1;  break;
			case '2': usDigit = 2;  break;
			case '3': usDigit = 3;  break;
			case '4': usDigit = 4;  break;
			case '5': usDigit = 5;  break;
			case '6': usDigit = 6;  break;
			case '7': usDigit = 7;  break;
			case '8': usDigit = 8;  break;
			case '9': usDigit = 9;  break;
			case 'A':
			case 'a': usDigit = 10; break;
			case 'B':
			case 'b': usDigit = 11; break;
			case 'C':
			case 'c': usDigit = 12; break;
			case 'D':
			case 'd': usDigit = 13; break;
			case 'E':
			case 'e': usDigit = 14; break;
			case 'F':
			case 'f': usDigit = 15; break;

			default:   return (0);
		}

		usTotal = ( 16 * usTotal ) + usDigit;

		pszHex++;
	}

	return ( usTotal );
} /* h_atou */
