/****************************************************************************

    WINCPT.H

    Header for the PipeTool Windows client.
	
    Copyright (C) 1992 Microsoft Corporation.

    This code sample is provided for demonstration purposes only.
    Microsoft makes no warranty, either express or implied,
    as to its usability in any given situation.

****************************************************************************/

/*** Defined Constants ***/

// Menu Selections for MainWndProc

#define IDM_CALL       100	// Transaction type selections.
#define IDM_TRANSACT   101	// NOTE: these must be numbered sequentially due
#define IDM_READ       102	// to the constants used to define their upper        */
#define IDM_WRITE      103	// and lower limit.
#define IDM_READWRITE  104	

#define IDM_ABOUT      105	// Other menu selection IDs
#define IDM_EXIT       106
#define IDM_PIPENAME   107
#define IDM_DATASIZES  108
#define IDM_OPENMODE   109
#define IDM_PIPEMODE   110
#define IDM_READASYNC  111
#define IDM_WRITEASYNC 112
#define IDM_TOGGLESTEP 113
#define IDM_SAVE       114
#define IDM_RESET      115
#define IDM_STEP       116

// Transaction Type boundaries

#define TT_LOW  100
#define TT_HIGH 104

// Selections for dialog controls

// Pipe Name
#define IDD_PIPENAME      10

// Data Sizes
#define IDD_DATASIZE      10
#define IDD_READSIZE      11
#define IDD_WRITESIZE     12

// Open Mode
#define IDD_OPENMODE      10
#define IDD_WRITEONLY     20
#define IDD_READONLY      21
#define IDD_READWRITE     22
#define IDD_DENYCOMPAT    30
#define IDD_DENYNONE      31
#define IDD_DENYREAD      32
#define IDD_DENYWRITE     33
#define IDD_DENYREADWRITE 34

// Pipe Mode
#define IDD_PIPEMODE      10
#define IDD_WAIT          20
#define IDD_NOWAIT        21
#define IDD_MESSAGE       30
#define IDD_BYTE          31

// Save
#define IDD_FILENAME      10

// Default pipe parameters

#define DEF_PIPENAME   "\\\\Server\\pipe\\pt"
#define DEF_DATASIZE   5000
#define DEF_OPENMODE   OF_READWRITE | OF_SHARE_DENY_NONE
#define DEF_PIPEMODE   0
#define DEF_AREADFLAG  FALSE
#define DEF_AWRITEFLAG FALSE

// Mode Masks

#define OM_SHARE_MASK  0xff8f
#define OM_ACCESS_MASK 0xfffc
#define PM_WAIT_MASK   0x7fff
#define PM_READ_MASK   0xfeff

// Data Size and control defines

#define MAXLEN_RESULT_LINE 100
#define MAXNUM_RESULT_LINE 200

#define NUM_HEADER_LINE 9

// String buff sizes

#define PIPENAME_LEN 257
#define FILENAME_LEN 257

// Timer Setup Constants

#define TIMER_ID    1
#define TIMER_DELAY 1000  /* msec */

// States names

#define WAIT_STATE             0
#define START_STATE            1
#define CALL_STATE             2
#define OPEN_STATE             3
#define QPIPEHANDSTATE_STATE   4
#define SETPIPEHANDSTATE_STATE 5
#define QPIPEINFO_STATE        6
#define TRANSACT_STATE         7
#define WRITE_STATE            8
#define WRITEASYNC_WAIT_STATE  9
#define READ_STATE            10
#define READASYNC_WAIT_STATE  11
#define CHECKDATA_STATE       12
#define END_STATE             13


/*** Function Prototypes ***/

int PASCAL			WinMain( HANDLE, HANDLE, LPSTR, int );
long FAR PASCAL	MainWndProc( HWND, unsigned, WORD, LONG );
VOID					DoState( VOID );
VOID					StartTransaction( VOID );
VOID					ResetTransaction( VOID );
VOID					ttyOut( char *, ... );
VOID					UpdateLine( int );
BOOL FAR PASCAL	About( HWND, unsigned, WORD, LONG );
BOOL FAR PASCAL	Options( HWND, unsigned, WORD, LONG );
BOOL FAR PASCAL	PipeName( HWND, unsigned, WORD, LONG );
BOOL FAR PASCAL	DataSizes( HWND, unsigned, WORD, LONG );
BOOL FAR PASCAL	OpenMode( HWND, unsigned, WORD, LONG );
VOID					ResetOMButtons( HWND, unsigned short );
BOOL FAR PASCAL	PipeMode( HWND, unsigned, WORD, LONG );
VOID					ResetPMButtons( HWND, unsigned short );
BOOL FAR PASCAL	SaveToFile( HWND, unsigned, WORD, LONG );
VOID FAR PASCAL	WaitAsync( unsigned long );

											
/*** Display Type Definitions ***/

typedef struct
{
	int          iLen;
	LOCALHANDLE  hBuff;
} HeaderLineType;

typedef struct
{
	int   iLen;
	char  acBuff[ MAXLEN_RESULT_LINE ];
} ResultLineType;


/*** Definitions of Global Data ***/

extern HANDLE          hInst;             // Current instance
extern HMENU           hMenu;             // Needed to manipulate menu
extern HWND            hWnd;              // Main window handle.

extern char            pszSaveFileName[]; // Filename/path for saved results

extern HeaderLineType  Header[];          // Array for header lines
extern ResultLineType  Result[];          // Circular result array

extern char            pszPipeName[];     // Pipe control parameters passed
extern unsigned short  usDataSize;        //   to the pipe and file IO api.
extern unsigned short  usWriteSize;       //   All have default values that
extern unsigned short  usReadSize;        //   are defined in wincpt.h and
extern unsigned short  usOpenMode;        //   are changed via parameter
extern unsigned short  usPipeMode;        //   dialog boxes.
extern BOOL            fAsyncRead;        // Control parameters set by
extern BOOL            fAsyncWrite;       //   checking a menu item	

extern int             hPipe;             // Pipe handle
extern HANDLE          hInBuff;           // Handles to globally allocated
extern HANDLE          hOutBuff;          //   data buffers

extern BOOL            fAsyncComplete;    // Async callback simply sets this

extern char            pszAsyncRead[];    // Strings that async flag values
extern char            pszAsyncWrite[];   //   translate to.

extern short           cxChar;            // Average text width (pixel)
extern short           cyChar;            // Total text height (pixel)

extern short           cxClient;          // Horizontal size of client area (pixel)
extern short           cyClient;          // Vertical size of client area (pixel)

extern short           nMaxWidth;         // Width of longest line (char)
extern short           nNumLines;         // Number of lines (char)

extern int             iResultNext;       // Index of next line to use
extern BOOL            fResultWrapped;    // Has Result wrapped around?

extern short           nVscrollPos;       // Position of vertical and
extern short           nHscrollPos;       //   horizontal scrollbar thumb.

extern short           nVscrollMax;       // Max position of scrollbar thumbs based
extern short           nHscrollMax;       //   on window displayed vs. used.

extern WORD            wTransType;        // ie. Call, Transact, etc.
extern unsigned short  uCurState;         // Place in state machine.

extern BOOL            fStep;             // Single step option toggle

extern BOOL            fModeSet;          // Has Pipe mode been set yet?
extern BOOL            fPipeOpened;       // Some things disabled after this

