/****************************************************************************

	CPT.C

	Code for the PipeTool character mode client side. Supported platforms are
	OS/2 and DOS via bind.
	
	Copyright (C) 1992 Microsoft Corporation.

	This code sample is provided for demonstration purposes only.
	Microsoft makes no warranty, either express or implied,
	as to its usability in any given situation.

****************************************************************************/

#define INCL_DOSMEMMGR
#define INCL_DOSNMPIPES
#define INCL_DOSFILEMGR
#define INCL_DOSERRORS
#define INCL_DOSPROCESS
#include <os2.h>				// OS/2 Includes

#include <stdio.h>			// C Runtime Includes
#include <stdlib.h>
#include <string.h>
#include <process.h>
#include <stddef.h>

#include "..\..\ptlib.h"	// Include for PipeTool common routines


/*** Forward Declarations ***/

VOID	main( int, char ** );
VOID	GetArgs( int, char ** );
VOID	Usage( VOID );


/*** Global Data, set with command line switches ***/

CHAR		pszPipeName[256] = "\\pipe\\pt";
USHORT	usOpenMode = 66;  /* duplex, deny none */
USHORT	fsPipeMode = 0;

USHORT	usDataSize = 0;
USHORT	usWriteSize = 0;
USHORT	usReadSize = 0;

CHAR		fCall = 0;
CHAR		fTransact = 0;
CHAR		fWrite = 1;
CHAR		fRead = 1;
CHAR		fReset = 0;


/**** Function: main ***/

VOID main ( int argc, char * argv[] )
{
	CHAR		* pcbOutData, * pcbInData;

	ULONG		ulTimeOut = 1000;

	HFILE		hPipe;
	USHORT	usAction;

	USHORT	fsPipeModeTest = 0;

	UCHAR		cbInfoBuf[ 300 ];
	USHORT	usInfoBufSize = 300;

	USHORT	cbRead, usTotalRead = 0;
	USHORT	cbWritten, usTotalWritten = 0;
	USHORT	usRWBuffSize;

	USHORT	OS2RC;

	GetArgs( argc, argv );

	MakeData( &pcbInData, &pcbOutData );

	if ( fCall )
	{
		printf( "Calling %s: %u...", pszPipeName, usDataSize );
		OS2RC = DosCallNmPipe( pszPipeName,
		                       pcbOutData,
		                       usDataSize,
		                       pcbInData,
		                       usDataSize,
		                       &usTotalRead,
		                       ulTimeOut );
		printf( "Read: %u,  Returned: %u\n", usTotalRead, OS2RC );
	}
	else
	{
		printf( "Opening: %s...", pszPipeName );
		if ( OS2RC = DosOpen( pszPipeName,
		                      &hPipe,
		                      &usAction,
		                      0L,
		                      FILE_NORMAL,
		                      FILE_CREATE | FILE_OPEN,
		                      usOpenMode,
		                      0L ) )
		{
			printf( "Aborted, DosOpen returned %u\n", OS2RC );
			exit(1);
		}
		else
		{
			printf( "OK\n" );
		}

		if ( fsPipeMode )
		{
			printf( "Setting pipe mode...");
			if ( OS2RC = DosSetNmPHandState( hPipe,
			                                 fsPipeMode ) )
			{
				printf( "Error, DosSetNmPHandState returned %u\n", OS2RC );
			}
			else
			{
				printf( "OK\n" );
			}
		}

		printf( "DosQNmPHandState reports..." );
		if ( OS2RC = DosQNmPHandState( hPipe,
		                               &fsPipeModeTest ) )
		{
			printf( "Error, returned %u\n", OS2RC );
		}
		else
		{
			printf( "\n   pipe mode: 0x%x\n", fsPipeModeTest );
		}

		printf( "DosQNmPipeInfo reports..." );
		if ( OS2RC = DosQNmPipeInfo( hPipe,
		                             1,
		                             cbInfoBuf,
		                             usInfoBufSize ) )
		{
			printf( "Error, returned %u\n", OS2RC );
		}
		else
		{
			printf( "\n   Outgoing buff size: %u\n", ((PIPEINFO *)cbInfoBuf)->cbOut );
			printf( "   Incoming buff size: %u\n", ((PIPEINFO *)cbInfoBuf)->cbIn );
			printf( "   Maximum instances:  %u\n", ((PIPEINFO *)cbInfoBuf)->cbMaxInst );
			printf( "   Current instances:  %u\n", ((PIPEINFO *)cbInfoBuf)->cbCurInst );
			printf( "   Length of Name:     %u\n", ((PIPEINFO *)cbInfoBuf)->cbName );
			printf( "   Pipe Name:          %s\n", ((PIPEINFO *)cbInfoBuf)->szName );
		}

		if ( fTransact )
		{
			printf( "Transacting: %u...", usDataSize );
			OS2RC = DosTransactNmPipe( hPipe,
			                           pcbOutData,
			                           usDataSize,
			                           pcbInData,
			                           usDataSize,
			                           &usTotalRead );
			printf( "Read: %u,  Returned: %u\n", usTotalRead, OS2RC );
		}
		else
		{
			if ( fWrite )
			{
				do {
					usRWBuffSize = (usWriteSize > (usDataSize - usTotalWritten))
					               ? (usDataSize - usTotalWritten) : usWriteSize;
					printf( "Writing: %u...", usRWBuffSize );
					OS2RC = DosWrite( hPipe,
					                  pcbOutData + usTotalWritten,
					                  usRWBuffSize,
					                  &cbWritten );
					usTotalWritten += cbWritten;
					printf( "Wrote: %u,  Returned: %u\n", cbWritten, OS2RC );
				} while ( usTotalWritten < usDataSize );

				if ( fReset )
				{
					printf( "Resetting buffer..." );
					if ( OS2RC = DosBufReset( hPipe ) )
					{
						printf( "Error, DosBufReset returned %u\n", OS2RC );
					}
					else
					{
						printf( "OK\n" );
					}
				}
			}

			if ( fRead )
			{
				do {
					usRWBuffSize = (usReadSize > (usDataSize - usTotalRead))
					               ? (usDataSize - usTotalRead) : usReadSize;
					printf( "Reading: %u...", usRWBuffSize );
					OS2RC = DosRead( hPipe,
					                 pcbInData + usTotalRead,
					                 usRWBuffSize,
					                 &cbRead );
					usTotalRead += cbRead;
					printf( "Read: %u,  Returned: %u\n", cbRead, OS2RC );
				} while ( usTotalRead < usDataSize );
			}
		}

		if ( ( fCall || fTransact || fRead ) && ( usTotalRead == usDataSize ) )
		{
			CheckData( pcbInData, pcbOutData, usDataSize );
		}

		printf( "Closing pipe..." );
		if ( OS2RC = DosClose( hPipe ) )
		{
			printf( "Aborted: DosClose of pipe returned %u", OS2RC );
			exit(1);
		}
		else
		{
			printf( "OK\n" );
		}
	}
	exit(0);
} /* main */


/*** Function GetArgs ***/

VOID GetArgs( int argc, char * argv[] )
{
	int i = 1;

	while ( i < (argc - 1) )
	{
		if ( strcmp( "-d", argv[i] ) == 0 )
		{
			usDataSize = atoi( argv[i+1] );
		}
			else if ( strcmp( "-n", argv[i] ) == 0 )
		{
			strcpy( pszPipeName, argv[i+1] );
		}
		else if ( strcmp( "-o", argv[i] ) == 0 )
		{
			usOpenMode = h_atou( argv[i+1] );
		}
		else if ( strcmp( "-p", argv[i] ) == 0 )
		{
			fsPipeMode = h_atou( argv[i+1] );
		}
		else if ( strcmp( "-t", argv[i] ) == 0 )
		{
			if ( *argv[i+1] == 'c' )
			{
				fCall = 1;
			}
			else if ( *argv[i+1] == 't' )
			{
				fTransact = 1;
			}
				else if ( *argv[i+1] == 'r' )
			{
				fWrite = 0;
			}
			else if ( *argv[i+1] == 'w' )
			{
				fRead = 0;
			}
			else if ( *argv[i+1] == 'W' )
			{
				fRead = 0;
				fReset = 1;
			}
			else if ( *argv[i+1] == 'X' )
			{
				fReset = 1;
			}
		}
		else if ( strcmp( "-r", argv[i] ) == 0 )
		{
			usReadSize = atoi( argv[i+1] );
		}
		else if ( strcmp( "-w", argv[i] ) == 0 )
		{
			usWriteSize = atoi( argv[i+1] );
		}
		else
		{
			Usage();
		}

		i += 2;
	}

	if ( usDataSize == 0 )
	{
		Usage();
	}
	else
	{
		if ( usReadSize == 0 )
		{
			usReadSize = usDataSize;
		}

		if ( usWriteSize == 0 )
		{
			usWriteSize = usDataSize;
		}
	}
} /* GetArgs */


/*** Function: Usage ***/

VOID Usage( VOID )
{
	printf( "Usage:\n" );
	printf( "cpt -d <n> [-n <s>] [-o <x>] [-p <x>] [-t <c>] [-r <n>] [-w <n>]\n" );
	printf( "Where:\n" );
	printf( "-d <n>: Size of data going across pipe\n" );
	printf( "-n <s>: Pipe name, ie. \\pipe\\pt (default), include server name if remote\n" );
	printf( "-o <x>: Open mode, a combination of:\n" );
	printf( "          Access:\n");
	printf( "            Duplex       (OPEN_ACCESS_READWRITE)    = 0x%x (default) or\n", OPEN_ACCESS_READWRITE );
	printf( "            Inbound      (OPEN_ACCESS_READONLY)     = 0x%x or\n", OPEN_ACCESS_READONLY );
	printf( "            Outbound     (OPEN_ACCESS_WRITEONLY)    = 0x%x\n", OPEN_ACCESS_WRITEONLY );
	printf( "          Sharing mode: deny?\n" );															
	printf( "            None         (OPEN_SHARE_DENYNONE)      = 0x%x (default) or\n", OPEN_SHARE_DENYNONE );
	printf( "            Read         (OPEN_SHARE_DENYREAD)      = 0x%x or\n", OPEN_SHARE_DENYREAD );
	printf( "            Write        (OPEN_SHARE_DENYWRITE)     = 0x%x or\n", OPEN_SHARE_DENYWRITE );
	printf( "            Both         (OPEN_SHARE_DENYREADWRITE) = 0x%x\n", OPEN_SHARE_DENYREADWRITE );
	printf( "-p <x>: Pipe mode, a combination of:\n" );
	printf( "          Wait:\n");
	printf( "            Blocking     (NP_WAIT)                  = 0x%x (default) or\n", NP_WAIT );
	printf( "            Non blocking (NP_NOWAIT)                = 0x%x\n", NP_NOWAIT );
	printf( "          Read mode:\n");
	printf( "            Byte         (NP_READMODE_BYTE)         = 0x%x (default) or\n", NP_READMODE_BYTE );
	printf( "            Message      (NP_READMODE_MESSAGE)      = 0x%x\n", NP_READMODE_MESSAGE );
	printf( "-t <c>: Type of transaction, one of:\n" );
	printf( "          Write/read    = x (default)\n" );
	printf( "            w/ BufReset = X\n" );
	printf( "          Write         = w\n" );
	printf( "            w/ BufReset = W\n" );
	printf( "          Read          = r\n" );	
	printf( "          Call          = c\n" );
	printf( "          Transact      = t\n" );
	printf( "-r <n>: Size of each read  (default = data size), ignored by call or transact\n" );
	printf( "-w <n>: Size of each write (default = data size), ignored by call or transact\n" );
	exit(1);
} /* Usage */
