/*
 * LMWIN.C
 * 
 * This example windows program demostrates the ability to call Microsoft 
 * LAN Manager 2.0 APIs from within a Microsoft Windows 3.0 application.
 * The application obtains general workstation information and displays 
 * it in a window (similar to the Microsoft LAN Manager 2.0 DOS Enhanced 
 * command NET CONFIG WORKSTATION).
 * 
 * Copyright (C) 1990 Microsoft Corporation 
 *
 * This code sample is provided for demonstration purposes only. Microsoft 
 * makes no warranty, either express or implied, as to its usability in 
 * any given situation.
 * 
 */

/* ------------------------------------------------------------------------ */

/* Header files */

/*
 * To help reduce the amount of memory required by the C compiler's
 * preprocessor pass, reduce the amount of preprocessor work as much
 * as possible. The various NO* #defines for the Windows SDK include
 * file (WINDOWS.H) help cut down on memory usage by the preprocessor.
 * In addition, the removal of the COMM functions of Windows will 
 * eliminate some warnings generated by the Microsoft C Compiler at
 * warning levels 3 and 4 (due to the bitfield structures in WINDOWS.H).
 */

/* Windows 3.0 toolkit */
#define NOCOMM            /* to eliminate lint warnings in windows.h */
#define NOGDICAPMASKS     /* CC_*, LC_*, PC_*, CP_*, TC_*, RC_ */
#define NOSYSMETRICS      /* SM_* */
#define NOKEYSTATES       /* MK_* */
#define NOSYSCOMMANDS     /* SC_* */
#define NORASTEROPS       /* Binary and Tertiary raster ops */
#define NOSHOWWINDOW      /* SW_* */
#define NOATOM            /* Atom Manager routines */
#define NOCLIPBOARD       /* Clipboard routines */
#define NOCOLOR           /* Screen colors */
#define NODRAWTEXT        /* DrawText() and DT_* */
#define NOMEMMGR          /* GMEM_*, LMEM_*, GHND, LHND, associated routines */
#define NOMETAFILE        /* typedef METAFILEPICT */
#define NOOPENFILE        /* OpenFile(), OemToAnsi, AnsiToOem, and OF_* */
#define NOSOUND           /* Sound driver routines */
#define NOWH              /* SetWindowsHook and WH_* */
#define NOWINOFFSETS      /* GWL_*, GCL_*, associated routines */
#define NOCOMM            /* COMM driver routines */
#define NOKANJI           /* Kanji support stuff. */
#define NOHELP            /* Help engine interface. */
#define NOPROFILER        /* Profiler interface. */
#define NODEFERWINDOWPOS  /* DeferWindowPos routines */
#undef OEMRESOURCE        /* OEM Resource values */
#undef NOLSTRING          /* using lstrlen() */
#include <windows.h>

/* LAN Manager 2.0 toolkit */
#define INCL_NETWKSTA
#define INCL_NETERRORS
#include <lan.h>

/* C run-time library */
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>

/* Application-specific */
#include "lmwin.h"

/* ------------------------------------------------------------------------ */

/* global variables */

HANDLE vhInst;           /* Application's instance handle */

XY vxyDraw = {0, 0};     /* Text location (row/column) */

XY vxySpacing = {0, 0};  /* Character font spacing (horiz/vertical) */

WKSTAINFO vastrWkstaInfo[] =
{
    /* mnemonic id #,    title,              value format */
    { WKI_computername,  "computer name:  ", "%s"               },
    { WKI_username,      "user name:      ", "%s"               },
    { WKI_langroup,      "lan group:      ", "%s"               },
    { WKI_logon_domain,  "logon domain:   ", "%s"               },
    { WKI_oth_domains,   "other domain(s):", "%s"               },
    { WKI_root,          "lanman root:    ", "%s"               },
    { WKI_charwait,      "char wait:      ", "%u seconds"       },
    { WKI_chartime,      "char time:      ", "%lu milliseconds" },
    { WKI_charcount,     "char count:     ", "%u bytes"         },
    { WKI_numcharbuf,    "char bufs:      ", "%u"               },
    { WKI_sizcharbuf,    "char buf size:  ", "%u bytes"         },
    { WKI_numworkbuf,    "work bufs:      ", "%u"               },
    { WKI_sizworkbuf,    "work buf size:  ", "%u bytes"         },
    { WKI_numdgrambuf,   "datagram bufs:  ", "%u"               },
    { WKI_keepconn,      "keep connection:", "%u seconds"       },
    { WKI_keepsearch,    "keep search:    ", "%u seconds"       },
    { WKI_maxcmds,       "max driver cmds:", "%u"               },
    { WKI_numservices,   "max services:   ", "%u"               },
    { WKI_mailslots,     "mailslots:      ", "%s"               }
};

#define MAX_WKSTAINFO_ENTRIES \
    (sizeof(vastrWkstaInfo) / sizeof(vastrWkstaInfo[0]) )

/* ------------------------------------------------------------------------ */

/*
 * WinMain()
 *
 * This function is the Windows equivalent to main(). It initializes 
 * the process, receives all of the messages, and dispatches them.
 * 
 * Note that the argument LPSTR lpCmdLine is unused by this
 * application, and thus may cause 'unused parameter' warnings
 * by the C compiler (or lint).
 * 
 * Functions referenced:
 *     InitApplication()
 *     InitInstance()
 *     GetMessage()
 *     TranslateMessage()
 *     DispatchMessage()
 *
 */

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpCmdLine, 
    int nCmdShow)
{

    MSG msg; /* a windows message */

    /* if no previous instance running, initialize the application */
    if (!hPrevInstance)
    {
        /* initialize the app, exiting if not able to */
        if (!InitApplication(hInstance))
        {
            return FALSE;
        }
    }

    /* initialize this instance of this app, exiting if not able to */
    if (!InitInstance(hInstance, nCmdShow))
    {
        return FALSE;
    }

    /* get, translate, and dispatch all messages */
    while (GetMessage(&msg, NULL, NULL, NULL)) 
    {
        (void)TranslateMessage(&msg);
        (void)DispatchMessage(&msg);
    }
    return msg.wParam;

} /* WinMain */

/* ------------------------------------------------------------------------ */

/*
 * InitApplication()
 * 
 * This function initializes window data and registers the window
 * class of this application.
 * 
 * Functions referenced:
 *     RegisterClass()
 */

BOOL InitApplication(HANDLE hInstance)
{

    WNDCLASS wndclass;   /* the window class structure */

    wndclass.style         = NULL;
    wndclass.lpfnWndProc   = WndProc;
    wndclass.cbClsExtra    = 0;
    wndclass.cbWndExtra    = 0;
    wndclass.hInstance     = hInstance;
    wndclass.hIcon         = LoadIcon(NULL, IDI_APPLICATION);
    wndclass.hCursor       = LoadCursor(NULL, IDC_ARROW);
    wndclass.hbrBackground = GetStockObject(WHITE_BRUSH); 
    wndclass.lpszMenuName  = (LPSTR)MENU_NAME;
    wndclass.lpszClassName = (LPSTR)CLASS_NAME;
    return RegisterClass(&wndclass);

} /* InitApplication */

/* ------------------------------------------------------------------------ */

/*
 * InitInstance()
 * 
 * This function creates the main window and displays it. It also 
 * saves the instance handle to the global variable vhInst.
 * 
 * Functions referenced:
 *     CreateWindow()
 *     ShowWindow()
 *     UpdateWindow()
 */

BOOL InitInstance(HANDLE hInstance, int nCmdShow)
{

    HWND hwnd;

    /* save the instance handle to the global variable */
    vhInst = hInstance;

    /* create the window */
    hwnd = CreateWindow((LPSTR)CLASS_NAME, /* class name */
        (LPSTR)WINDOW_NAME,                /* title bar text */
        WS_OVERLAPPEDWINDOW,               /* window style */
        CW_USEDEFAULT,                     /* default horizontal position */
        CW_USEDEFAULT,                     /* default vertical position */
        CW_USEDEFAULT,                     /* default width */
        CW_USEDEFAULT,                     /* default height */
        (HWND)NULL,                        /* no parent window */
        (HMENU)NULL,                       /* default menu */
        (HANDLE)hInstance,                 /* instance handle */
        (LPSTR)NULL);                      /* no MDI stuff */

    /* if unable to create the window, return the error */
    if (!hwnd)
    {
        return FALSE;
    }

    /* display the window */
    (void)ShowWindow(hwnd, nCmdShow);
    UpdateWindow(hwnd);

    /* return success */
    return TRUE;

} /* InitInstance */

/* ------------------------------------------------------------------------ */

/*
 * WndProc()
 * 
 * This function processes the various messages. The specific
 * messages which this app cares about (i.e., doesn't pass
 * on to DefWindowProc()) are:
 *
 *   WM_COMMAND - the about dialog box of the application menu
 *   WM_DESTROY - destroying the window
 *   WM_PAINT   - display the window contents
 * 
 * Functions referenced:
 *     MakeProcInstance()
 *     DialogBox()
 *     FreeProcInstance()
 *     PostQuitMessage()
 *     BeginPaint()
 *     GetTextMetrics()
 *     WkstaInfo()
 *     EndPaint()
 *     DefWindowProc()
 */

LONG FAR PASCAL WndProc(HWND hwnd, unsigned usMsg, WORD wParam, LONG lParam)
{

    FARPROC lpProcAbout; /* function pointer to AboutBox dlgbox handler */

    /* determine if the message is one we handle */
    switch (usMsg)
    {

        case WM_COMMAND:
            /* call the about dialog box */
            if (wParam == IDM_ABOUT) 
            {
                lpProcAbout = MakeProcInstance(About, vhInst);
                (void)DialogBox(vhInst, (LPSTR)ABOUT_BOX_DLG, hwnd, 
                    lpProcAbout);
                FreeProcInstance(lpProcAbout);
            }
            break;

        case WM_DESTROY:
            /* termination time... */
            PostQuitMessage(0);
            return 0;
            break;

        case WM_PAINT:
            /* display the window text and repaint */
            {
            PAINTSTRUCT ps;  /* paint structure */
            HDC hdc;         /* display context handle */
            TEXTMETRIC tm;   /* text metrics structure */

            /* reset the text line/column counters */
            vxyDraw.x = vxyDraw.y = 0;

            /* set up a display context to begin painting */
            hdc = BeginPaint (hwnd, &ps);

            /* 
             * Get the size characteristics of the current font.
             * This information will be used for determining the
             * vertical and horizontal spacing of text on the screen.
             */
            (void)GetTextMetrics(hdc, &tm);
            vxySpacing.y = tm.tmHeight + tm.tmExternalLeading;
            vxySpacing.x = tm.tmMaxCharWidth + tm.tmOverhang;

            /* display the workstation information */
            WkstaInfo(hwnd, hdc);

            EndPaint(hwnd, &ps);
            return 0;
            break;
            } /* WM_PAINT */

        } /* switch */

    /* let Windows handle all other messages in the default manner */
    return DefWindowProc(hwnd, usMsg, wParam, lParam);

} /* WndProc */

/* ------------------------------------------------------------------------ */

/*
 * About()
 * 
 * This function processes messages for the "About" dialog box. The
 * specific messages processed are:
 * 
 *   WM_INITDIALOG - initializing the dialog box
 *   WM_COMMAND    - receiving input (OK or CANCEL) from the user
 * 
 * Note that the argument LONG lParam is unused by this application, 
 * and thus may cause 'unused parameter' warnings by the C compiler
 * (or lint).
 * 
 * Functions referenced:
 *     EndDialog()
 */

BOOL FAR PASCAL About(HWND hDlg, unsigned usMsg, WORD wParam, LONG lParam)
{

    /* look at what kind of message it is */
    switch (usMsg) 
    {
        case WM_INITDIALOG:
            return TRUE;
            break;

        case WM_COMMAND:
            if (wParam == IDOK || wParam == IDCANCEL) 
            {
                EndDialog(hDlg, TRUE);
                return TRUE;
            }
            break;
    }

    /* don't process any other messages */
    return FALSE;

} /* About */

/* ------------------------------------------------------------------------ */

/* 
 * ErrorMsgBox()
 * 
 * This function displays an error message box.
 * 
 * Functions referenced:
 *     MessageBox()
 */

void ErrorMsgBox(HWND hwnd, LPSTR lpszMsg)
{

    static char *pszError = "error!";

    (void)MessageBox(hwnd, lpszMsg, (LPSTR)pszError, MB_OK | MB_ICONSTOP);
    return;

} /* ErrorMsgBox */

/* ------------------------------------------------------------------------ */

/* 
 * WkstaInfo()
 *
 * This function displays the LAN Manager workstation information,
 * obtained from the LAN Manager NetWkstaGetInfo() API, using
 * the level 1 workstation data structure (wksta_info_1).
 * 
 * Functions referenced:
 *     NetWkstaGetInfo()
 *     sprintf()
 *     ErrorMsgBox()
 *     malloc()
 *     free()
 *     SetWindowText()
 *     WkstaLine()
 */

void WkstaInfo(HWND hwnd, HDC hdc)
{
 
    API_RET_TYPE usReturnCode; /* API return code */
    char *pbBuffer;            /* pointer to data buffer */
    unsigned short cbBuflen;   /* count of bytes */
    unsigned short cbAvail;    /* count of bytes available */
    struct wksta_info_1 *p1;   /* workstation info; level 1 */
    char szMsgBuf[BUFSIZ];     /* message buffer */
    char szTitleBuffer[80];    /* window title bar buffer */
    static char *pszTitleFmt = "lanman %i.%i workstation info";

    /* call NetWkstaGetInfo() with NULL buffer to get buffer size */
    usReturnCode = NetWkstaGetInfo(NULL, 1, NULL, 0, &cbBuflen);
    if (usReturnCode != NERR_BufTooSmall)
    {
        (void)sprintf(szMsgBuf, "NetWkstaGetInfo() returned error %u", 
            usReturnCode);
        ErrorMsgBox(hwnd, (LPSTR)szMsgBuf);
        return;
    }

    /* allocate buffer for actual call to NetWkstaGetInfo() */
    if ((pbBuffer = malloc(cbBuflen)) == NULL)
    {
        (void)sprintf(szMsgBuf, "malloc(%i) failed", cbBuflen);
        ErrorMsgBox(hwnd, (LPSTR)szMsgBuf);
        return;
    }

    /* get the actual workstation information */
    usReturnCode = NetWkstaGetInfo(NULL, 1, pbBuffer, cbBuflen, &cbAvail);

    /* examine the NetWktaGetInfo() return code */
    switch (usReturnCode)
    {
        case NERR_Success:
            /* success */
            p1 = (struct wksta_info_1 *)pbBuffer;
            /* display all the information outside this switch() */
            break;

        case NERR_WkstaNotStarted:
        case NERR_NetNotStarted:
            /* failure: wksta not started */
            (void)sprintf(szMsgBuf, "the workstation has not been started");
            ErrorMsgBox(hwnd, (LPSTR)szMsgBuf);
            free(pbBuffer);
            return;
            break;

        default:
            /* failure */
            (void)sprintf(szMsgBuf, "NetWkstaGetInfo() returned error %u", 
                usReturnCode);
            ErrorMsgBox(hwnd, (LPSTR)szMsgBuf);
            free(pbBuffer);
            return;
            break;
    }

    /* now that we have the version, update the window title */
    (void)sprintf(szTitleBuffer, pszTitleFmt, p1->wki1_ver_major, 
        p1->wki1_ver_minor);
    SetWindowText(hwnd, (LPSTR)szTitleBuffer);

    /* display the main window text, showing some workstation stats */
    WkstaLine(hdc, WKI_computername,  p1->wki1_computername);
    WkstaLine(hdc, WKI_username,      p1->wki1_username);
    WkstaLine(hdc, WKI_langroup,      p1->wki1_langroup);
    WkstaLine(hdc, WKI_logon_domain,  p1->wki1_logon_domain);
    WkstaLine(hdc, WKI_oth_domains,   p1->wki1_oth_domains);
    WkstaLine(hdc, WKI_root,          p1->wki1_root);
    WkstaLine(hdc, WKI_charwait,      p1->wki1_charwait);
    WkstaLine(hdc, WKI_chartime,      p1->wki1_chartime);
    WkstaLine(hdc, WKI_charcount,     p1->wki1_charcount);
    WkstaLine(hdc, WKI_numcharbuf,    p1->wki1_numcharbuf);
    WkstaLine(hdc, WKI_sizcharbuf,    p1->wki1_sizcharbuf);
    WkstaLine(hdc, WKI_numworkbuf,    p1->wki1_numworkbuf);
    WkstaLine(hdc, WKI_sizworkbuf,    p1->wki1_sizworkbuf);
    WkstaLine(hdc, WKI_numdgrambuf,   p1->wki1_numdgrambuf);
    WkstaLine(hdc, WKI_keepconn,      p1->wki1_keepconn);
    WkstaLine(hdc, WKI_keepsearch,    p1->wki1_keepsearch);
    WkstaLine(hdc, WKI_maxcmds,       p1->wki1_maxcmds);
    WkstaLine(hdc, WKI_numservices,   p1->wki1_numservices);
    WkstaLine(hdc, WKI_mailslots,     p1->wki1_mailslots == 0 ? "no" : "yes");

    /* free up the NetWkstaGetInfo() level 1 structure buffer */
    free(pbBuffer);

    return;

} /* WkstaInfo */

/* ------------------------------------------------------------------------ */

/*
 * WkstaLine()
 * 
 * This function displays one of the lines (each of which contain one
 * item of information about the lanman workstation) to the window. 
 * The Windows TextOut() function is used to send text to the window.
 * The C runtime variable arguments package is used, so that multiple
 * parameters can be displayed on the line, similar to printf()-style
 * output.
 * 
 * Functions referenced:
 *     TextOut()
 *     lstrlen()
 *     va_start()
 *     vsprintf()
 *     va_end()
 */

void WkstaLine(HDC hdc, int iMsg, ...)
{

    va_list vargs;               /* variable argument list */
    char szMsgBuf[BUFSIZ];       /* message buffer */

    /* display the first column (the title) */
    (void)TextOut(hdc, vxyDraw.x, vxyDraw.y, 
        (LPSTR)vastrWkstaInfo[iMsg].pszName,
        lstrlen(vastrWkstaInfo[iMsg].pszName));

    /* display the second column (the value) */
    va_start(vargs, iMsg);
    (void)vsprintf(szMsgBuf, vastrWkstaInfo[iMsg].pszFmt, vargs);
    (void)TextOut(hdc, vxyDraw.x + lstrlen(vastrWkstaInfo[iMsg].pszName) 
        * vxySpacing.x, vxyDraw.y, (LPSTR)szMsgBuf, lstrlen(szMsgBuf));
    vxyDraw.y += vxySpacing.y;
    va_end(vargs);

    return;

} /* WkstaLine */

/* ------------------------------------------------------------------------ */
