/*
   NETACCT.C -- a sample program demonstrating the NetAccountsReplicate API

   This program requires that you have admin or accounts operator privilege
   on the specified server.

      usage: netacct [-s \\server]
         where \\server = Name of the server. A servername must be preceded by
                          two backslashes (\\).

   API                  Used to...
   ================     ================================================
   NetAccountsReplicate Begin replication of the UAS in two ways:
			   1) If the server is the PDC for the domain,
			      replication will begin at all Backup and Member
			      controllers.
			   2) If the server is a BDC or Member, the UAS at
			      that server only will begin replicating.

   This code sample is provided for demonstration purposes only.
   Microsoft makes no warranty, either express or implied, 
   as to its usability in any given situation.
*/

#define     INCL_BASE
#include    <os2.h>        // MS OS/2 base header files

#define     INCL_NETACCOUNTS
#define     INCL_NETERRORS
#include    <lan.h>        // LAN Manager header files

#include    <stdio.h>      // C run-time header files
#include    <stdlib.h>
#include    <string.h>

#include    "samples.h"    // Internal routine header file

void Usage (char * pszProgram);

void main(int argc, char *argv[])
{
   API_RET_TYPE uReturnCode;              // API return code
   char * pszServer = NULL;               // Servername
   int            iArgv;                  // Index for arguments
                                       
   for (iArgv = 1; iArgv < argc; iArgv++)
   {
      if ((*argv[iArgv] == '-') || (*argv[iArgv] == '/'))
      {
         switch (tolower(*(argv[iArgv]+1)))    // Process switches
         {
            case 's':                          // -s server
               pszServer = argv[++iArgv];
               break;
            case 'h':
            default:
               Usage(argv[0]);
         }
      }
      else
         Usage(argv[0]);
   }

//========================================================================
// NetAccountsReplicate
//
// This API may be called to initiate UAS replication. When it is
// called on a Primary Domain Controller, it begins replication at all
// Backup Domain Controllers and Members in that domain.  If this API is
// called at a Backup of Member, replication will begin on that server only.
//
//========================================================================

   uReturnCode = NetAccountsReplicate (pszServer,	// Servername
			                     0L);	// Reserved, must be 0

   printf("NetAccountsReplicate returned %u\n", uReturnCode);

   if (uReturnCode != NERR_Success) {
      switch (uReturnCode) {
         case NERR_NetlogonNotStarted:
            printf ("Netlogon is not started at the specified server, %s\n",
                    pszServer);
            break;
         case NERR_DCNotFound:
            printf ("Domain controller not found by specified server.\n");
            break;
      }
   }

   exit(0);
}

void Usage (char * pszProgram)
{
   fprintf(stderr, "Usage: %s [-s \\\\server]\n", pszProgram);
   exit(1);
}
