Option Explicit

Global UserName$
Global Password$
Global Connect$
Global DatabaseName$

Global OraSession As Object
Global OraDatabase As Object

' Show parameters
Global Const MODAL = 1
Global Const MODELESS = 0

Sub CenterForm (f As Form)

' Center the specified form within the screen

    f.Move (Screen.Width - f.Width) \ 2, (Screen.Height - f.Height) \ 2

End Sub

Sub FillLists ()

Dim SQL$

    Dim mydyn As Object
    
    ' load the categories list box

    ' create a dynaset of the quote categories
    SQL$ = "select category from qcats order by category"
    Set mydyn = OraDatabase.DbCreateDynaset(SQL$, 0&)
    mydyn.DbMoveFirst

    ' start with an "any"
    frmQuote.catlist.AddItem "any"
    frmQuote.catlist.ListIndex = 0

    While (0 = mydyn.EOF)
        frmQuote.catlist.AddItem mydyn.Fields("category")
        mydyn.DbMoveNext
    Wend

    
    ' load the person list box

    ' create a dynaset of the quote categories
    SQL$ = "select pname from qpersons order by pname"
    Set mydyn = OraDatabase.DbCreateDynaset(SQL$, 0&)
    mydyn.DbMoveFirst

    ' start with an "any"
    frmQuote.perlist.AddItem "any"
    frmQuote.perlist.ListIndex = 0

    While (0 = mydyn.EOF)
        frmQuote.perlist.AddItem mydyn.Fields("pname")
        mydyn.DbMoveNext
    Wend

End Sub

Sub QueryQuotes ()
    
 Dim where$, SQL$

    ' construct a new sql statement

    where$ = ""       ' where clause

    ' when we have a constraint we enforce it by using a where clause
    ' the where clause uses sub-queries to translate the constraints from
    ' the user-friendly information (such as category name) to the numeric index
    ' that is used as a key between the tables

    If frmQuote.catlist.ListIndex <> -1 And frmQuote.catlist <> "any" Then
        ' category constraint
        where$ = " where quotes.catnum = (select catnum from qcats where category = '"
        where$ = where$ + frmQuote.catlist
        where$ = where$ + "')"
    End If
    If frmQuote.perlist.ListIndex <> -1 And frmQuote.perlist <> "any" Then
        ' person constraint
        If Len(where$) = 0 Then
            ' first where clause
            where$ = " where "
        Else
            ' subsequent where clause
            where$ = where$ + " and "
        End If
        where$ = where$ + "quotes.pnum = (select pnum from qpersons where pname = '"
        where$ = where$ + frmQuote.perlist
        where$ = where$ + "')"
    End If

    ' now put together the sql statement
    SQL$ = "select * from quotes" + where$

    ' Refresh the data control
    ' form2.TheQuote = ""
    frmQuote.quotedata.RecordSource = SQL$
    frmQuote.quotedata.Refresh

    If frmQuote.quotedata.Recordset.RecordCount < 1 Then
        frmQuote.TheQuote.Visible = False
        frmQuote.cmdDeleteQuote.Enabled = False
    Else
        frmQuote.TheQuote.Visible = True
        frmQuote.cmdDeleteQuote.Enabled = True
    End If

End Sub

