Option Explicit

Global GraphDyn As Object

' routine to draw a simple graph (a value vector & a label vector)
'   SGraph is the graph control
'   rscl is the recordset object (we sugggest using a clone)
'   labeln is the name of the label field
'   valn is the name of the value field
'
' we assume that the graph control is set up as follows:
'   autoinc off
'
' we leave the graph visible & drawn if there is data,
'   invisible if there is no data
'
Sub SimpleGraph (SGraph As Control, rscl As Object, labeln As String, valn As String)

 Dim i%, nrows%

 SGraph.AutoInc = 0

 'Figure out how many rows there are
 nrows% = rscl.RecordCount

 'Set up for drawing a bar chart
 If nrows% <= 0 Then
  'SGraph.Visible = False  '  no data
 Else
  rscl.DbMoveFirst
  SGraph.NumPoints = nrows%
  For i% = 1 To nrows%

   SGraph.ThisPoint = i%
   SGraph.LegendText = rscl.Fields(labeln$)

   If Not IsNull(rscl.Fields(valn$)) Then
    SGraph.GraphData = rscl.Fields(valn$)
   Else
    SGraph.GraphData = 0
   End If

   rscl.DbMoveNext

  Next i%

  'SGraph.Visible = True
  SGraph.DrawMode = 2
 End If

 Exit Sub


End Sub

