/* Copyright (c) Oracle Corporation 1994.  All Rights Reserved */

/*
  DESCRIPTION
      A class to bind OValues.  This allows an OValue to automatically
      track the value of a dynaset field.
  MODIFIED
      kwhitley    10/24/94    Created
*/

#ifndef BOUNDVAL_ORACLE
#define BOUNDVAL_ORACLE

#ifndef ORACL_ORACLE
#include "oracl.h"
#endif

#ifndef OBOUND_ORACLE
#include "obound.h"
#endif

class OBoundVal : public OBound, public OValue
{ 
public:
    // routines to implement OBound functionality
    oresult Refresh(const OValue &val);  // database -> bound
    oresult SaveChange(void);  // bound -> database
    
    /*
        We must override all the ways that the OValue can have it's
        value changed.  Otherwise the OValue could be changed and the
        OBoundVal would't know about it.
    */
    oresult Clear(void);
    oresult SetValue(int val);     // sets to int value
    oresult SetValue(long val);
    oresult SetValue(double dval); // sets to double value
    oresult SetValue(const char *val); // sets string value (copies text)
    oresult SetValue(const OValue &val);

    // and some overridden operator= for convenience
    OBoundVal &operator=(const OBoundVal &other); // only copies value
    OBoundVal &operator=(const OValue &val);
    OBoundVal &operator=(const int val);    
    OBoundVal &operator=(const long val);    
    OBoundVal &operator=(const double val);    
    OBoundVal &operator=(const char *val);    
};

#endif // BOUNDVAL_ORACLE
