/* Copyright (c) Oracle Corporation 1994.  All Rights Reserved */

/*
  DESCRIPTION
      A class to bind OValues.  This allows an OValue to automatically
      track the value of a dynaset field.
  MODIFIED
      kwhitley    10/24/94    Created
*/

#ifndef BOUNDVAL_ORACLE 
#include "boundval.h"
#endif


oresult OBoundVal::Refresh(const OValue &val)
{
    OValue::operator=(val);  // use OValue assignment to get new value
    
    return(OSUCCESS);
}

oresult OBoundVal::SaveChange(void)
{
    return(OBound::SetValue(*this));
}

oresult OBoundVal::Clear(void)
{
    if (!Changed())
        return(OFAILURE); // couldn't start change
    OValue::Clear();
    
    return(OSUCCESS);
}

oresult OBoundVal::SetValue(int val) 
{
    if (!Changed())
        return(OFAILURE); // couldn't start change
    OValue::SetValue(val);
    return(OSUCCESS);
}

oresult OBoundVal::SetValue(long val)
{
    if (!Changed())
        return(OFAILURE); // couldn't start change
    OValue::SetValue(val);
    return(OSUCCESS);
}

oresult OBoundVal::SetValue(double val)
{
    if (!Changed())
        return(OFAILURE); // couldn't start change
    OValue::SetValue(val);
    return(OSUCCESS);
}

oresult OBoundVal::SetValue(const char *val)
{
    if (!Changed())
        return(OFAILURE); // couldn't start change
    OValue::SetValue(val);
    return(OSUCCESS);
}

oresult OBoundVal::SetValue(const OValue &val)
{
    if (!Changed())
        return(OFAILURE); // couldn't start change
    OValue::operator=(val);
    return(OSUCCESS);
}

OBoundVal &OBoundVal::operator=(const OBoundVal &other)
{
    if (&other == this)
        return(*this); // self assignment - do nothing

    if (Changed())
    { // we are able to change the value
        OValue::operator=(other); // just copy the value
    }
    return(*this);    
}

OBoundVal &OBoundVal::operator=(const OValue &val)
{
    if (Changed())
    { // we are able to change the value
        OValue::operator=(val);
    }
    return(*this);
}
    
OBoundVal &OBoundVal::operator=(const int val)    
{
    SetValue(val);  // if we can't StartEdit on dynaset, this does nothing
    return(*this);
}
    
OBoundVal &OBoundVal::operator=(const long val)    
{
    SetValue(val);  // if we can't StartEdit on dynaset, this does nothing
    return(*this);
}
    
OBoundVal &OBoundVal::operator=(const double val)    
{
    SetValue(val);  // if we can't StartEdit on dynaset, this does nothing
    return(*this);
}
    
OBoundVal &OBoundVal::operator=(const char *val)
{
    SetValue(val);  // if we can't StartEdit on dynaset, this does nothing
    return(*this);
}
    
