/*  Project bltest
	 
	 Copyright  1994. All Rights Reserved.

	 SUBSYSTEM:    bltest.exe Application
	 FILE:         bltstdlg.cpp
	 AUTHOR:       Geraldine Kuo


	 OVERVIEW
	 ========
	 Source file for implementation of bltestDlg (TDialog).      
*/

#include <owl\owlpch.h>

#pragma hdrstop
#include <ver.h>

#include "bltstapp.h"
#include "bltstdlg.h"



DEFINE_RESPONSE_TABLE1(bltestDlg, TDialog)
  EV_COMMAND(IDC_FIRST, HandleFirst),
  EV_COMMAND(IDC_PREV, HandlePrev),
  EV_COMMAND(IDC_NEXT, HandleNext),
  EV_COMMAND(IDC_LAST, HandleLast),
  EV_COMMAND(IDC_CONNECT, HandleConnect),
END_RESPONSE_TABLE;

//////////////////////////////////////////////////////////
// bltestAboutDlg
// ==========
// Construction/Destruction handling.
bltestDlg::bltestDlg (TWindow *parent, TResId resId, TModule *module)
	 : TDialog(parent, resId, module)
{
	 // INSERT>> Your constructor code here.
	 m_e1 = new OBoundEdit(this, IDC_EMPNO);
	 m_e2 = new OBoundEdit(this, IDC_JOB);
	 m_s1 = new OBoundStatic(this, IDC_ENAME);   
	 m_c1 = new OBoundCheckBox(this, IDC_B1);
	 m_c2 = new OBoundCheckBox(this, IDC_B2);
	 m_r1 = new OBoundRadioButton(this, IDC_RADIO1);
	 m_r2 = new OBoundRadioButton(this, IDC_RADIO2);
	 m_r3 = new OBoundRadioButton(this, IDC_RADIO3);
	 m_r4 = new OBoundRadioButton(this, IDC_RADIO4);
	 m_r5 = new OBoundRadioButton(this, IDC_RADIO5);

	 m_gauge = new OBoundGauge(this, "", IDC_GAUGE, 200, 450, 340, 20);
	 m_slider = new OBoundHSlider(this, IDC_SLIDER, 200, 400, 340, 40);
}

bltestDlg::~bltestDlg ()
{
	 Destroy();
	 // INSERT>> Your destructor code here.
}


void bltestDlg::SetupWindow ()
{
	 TDialog::SetupWindow();
}	

void bltestDlg::HandleConnect()
{
	 char con[256], db[256];
	 GetDlgItemText(IDC_CONSTRING, con, 256);
	 GetDlgItemText(IDC_DATABASE, db, 256);
	 
	 // open a database object
	 m_database.Open(db, con, 0);   

	 // open a dynaset
	 m_binder.Open(m_database, "select * from emp2");

	 m_s1->BindToBinder(&m_binder, "ename");		
	
	 m_e1->BindToBinder(&m_binder, "empno");
	 m_e1->SetProperty(OBOUND_READONLY);
	 m_e2->BindToBinder(&m_binder, "job");
	 
	 m_c1->BindToBinder(&m_binder, "vacation");
	 m_c1->SetProperty((OValue)1, (OValue)0, OBOUND_READWRITE);
	 m_c2->BindToBinder(&m_binder, "vacation");
	 m_c2->SetProperty((OValue)1, (OValue)0, OBOUND_READONLY);
	 
	 m_r1->BindToBinder(&m_binder, "hobby");
	 m_r1->SetProperty((OValue)"Bowling");
	 m_r2->BindToBinder(&m_binder, "hobby");
	 m_r2->SetProperty((OValue)"Fishing");
	 m_r3->BindToBinder(&m_binder, "hobby");
	 m_r3->SetProperty((OValue)"Shopping");
	 m_r4->BindToBinder(&m_binder, "hobby");
	 m_r4->SetProperty((OValue)"Swimming");
	 m_r5->BindToBinder(&m_binder, "hobby");
	 m_r5->SetProperty((OValue)"Windsurfing");

	 m_gauge->BindToBinder(&m_binder, "comm");
	 m_gauge->SetProperty((OValue)0, (OValue)3000);

	 m_slider->BindToBinder(&m_binder, "sal");
	 m_slider->SetProperty((OValue)100, (OValue)7000);
	 
	 m_binder.MoveFirst();

	 ::EnableWindow(GetDlgItem(IDC_FIRST), TRUE);
	 ::EnableWindow(GetDlgItem(IDC_PREV), TRUE);
	 ::EnableWindow(GetDlgItem(IDC_NEXT), TRUE);
	 ::EnableWindow(GetDlgItem(IDC_LAST), TRUE);
}

void bltestDlg::HandleFirst()
{
	m_binder.MoveFirst();
}

void bltestDlg::HandlePrev()
{
	m_binder.MovePrev();
}

void bltestDlg::HandleNext()
{
	m_binder.MoveNext();
}

void bltestDlg::HandleLast()
{
	m_binder.MoveLast();
}
