/*  Project bltest
    
    Copyright  1994. All Rights Reserved.

    SUBSYSTEM:    bltest.exe Application
    FILE:         bltstapp.cpp
    AUTHOR:       


    OVERVIEW
    ========
    Source file for implementation of bltestApp (TApplication).      
*/


#include <owl\owlpch.h>
#pragma hdrstop


#include "bltstapp.h"
#include "bltstabd.h"                        // Definition of about dialog.       
#include "bltstdlg.h"
#include <oracl.h> 

//{{bltestApp Implementation}}


//
// Build a response table for all messages/commands handled
// by the application.
//
DEFINE_RESPONSE_TABLE1(bltestApp, TApplication)
//{{bltestAppRSP_TBL_BEGIN}}
    EV_COMMAND(CM_FILENEW, CmFileNew),
	 EV_COMMAND(CM_HELPABOUT, CmHelpAbout),
//{{bltestAppRSP_TBL_END}}
END_RESPONSE_TABLE;


//
// FrameWindow must be derived to override Paint for Preview and Print.
//
class SDIDecFrame : public TDecoratedFrame {
public:
	 SDIDecFrame (TWindow *parent, const char far *title, TWindow *clientWnd, BOOL trackMenuSelection = FALSE, TModule *module = 0) :
				TDecoratedFrame(parent, title, clientWnd, trackMenuSelection, module)
		{  }
	 ~SDIDecFrame ()
		{  }
};


//////////////////////////////////////////////////////////
// bltestApp
// =====
//
bltestApp::bltestApp () : TApplication("bltest")
{

	 // Common file file flags and filters for Open/Save As dialogs.  Filename and directory are
	 // computed in the member functions CmFileOpen, and CmFileSaveAs.
	 FileData.Flags = OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT;
	 FileData.SetFilter("All Files (*.*)|*.*|");

	 // INSERT>> Your constructor code here.
	 OStartup();
}


bltestApp::~bltestApp ()
{
	 // INSERT>> Your destructor code here.
		 OShutdown();
}


//////////////////////////////////////////////////////////
// bltestApp
// =====
// Application intialization.
//
void bltestApp::InitMainWindow ()
{
	 Client = new TWindow(0, "");
	 SDIDecFrame *frame = new SDIDecFrame(0, GetName(), Client, FALSE);

	 nCmdShow = nCmdShow != SW_SHOWMINIMIZED ? SW_SHOWNORMAL : nCmdShow;

	 //
	 // Assign ICON w/ this application.
	 //
	 frame->SetIcon(this, IDI_SDIAPPLICATION);

	 //
	 // Menu associated with window and accelerator table associated with table.
    //
	 frame->AssignMenu(SDI_MENU);
    
	 //
    // Associate with the accelerator table.
	 //
    frame->Attr.AccelTable = SDI_MENU;

  
	 MainWindow = frame;

}


//////////////////////////////////////////////////////////
// bltestApp
// ===========
// Menu File New command
void bltestApp::CmFileNew ()
{
	bltestDlg(MainWindow).Execute();
}

//////////////////////////////////////////////////////////
// bltestApp
// ===========
// Menu Help About bltest.exe command
void bltestApp::CmHelpAbout ()
{
	 //
	 // Show the modal dialog.
	 //
	 bltestAboutDlg(MainWindow).Execute();
}


int OwlMain (int , char* [])
{
	 bltestApp     App;
	 int             result;

	 result = App.Run();

	 return result;
}
