VERSION 2.00
Begin Form frmObjTest 
   BorderStyle     =   3  'Fixed Double
   Caption         =   "Oracle Objects versus Visual Basic Data Access"
   ClientHeight    =   6540
   ClientLeft      =   1155
   ClientTop       =   1800
   ClientWidth     =   9120
   Height          =   7230
   Left            =   1095
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   6540
   ScaleWidth      =   9120
   Top             =   1170
   Width           =   9240
   Begin CheckBox chkNoCache 
      Caption         =   "NoCache?"
      Height          =   255
      Left            =   6600
      TabIndex        =   30
      Top             =   2160
      Width           =   2175
   End
   Begin CheckBox chkRefColumnData 
      Caption         =   "Reference Column Data?"
      Height          =   255
      Left            =   6480
      TabIndex        =   29
      Top             =   5280
      Width           =   2415
   End
   Begin OptionButton optTType 
      Caption         =   "VB Snapshot"
      Height          =   255
      Index           =   2
      Left            =   6480
      TabIndex        =   28
      Top             =   840
      Width           =   2055
   End
   Begin CheckBox chkSQLPassthrough 
      Caption         =   "SQLPassthrough?"
      Height          =   255
      Left            =   6600
      TabIndex        =   3
      Top             =   1920
      Width           =   2175
   End
   Begin CheckBox chkReadOnly 
      Caption         =   "ReadOnly?"
      Height          =   255
      Left            =   6600
      TabIndex        =   26
      Top             =   1680
      Width           =   2175
   End
   Begin Frame Frame3 
      Caption         =   "CreateDynaset Options"
      Height          =   1215
      Left            =   6360
      TabIndex        =   27
      Top             =   1320
      Width           =   2655
   End
   Begin ComboBox comOperator 
      Height          =   300
      Left            =   6720
      Style           =   2  'Dropdown List
      TabIndex        =   8
      Top             =   4080
      Width           =   2055
   End
   Begin TextBox txtParam1 
      Height          =   285
      Left            =   6720
      TabIndex        =   9
      Text            =   "10"
      Top             =   4440
      Width           =   2055
   End
   Begin TextBox txtParam2 
      Height          =   285
      Left            =   6720
      TabIndex        =   10
      Text            =   "20"
      Top             =   4800
      Width           =   2055
   End
   Begin CheckBox chkParameter 
      Caption         =   "Parameter?"
      Height          =   255
      Left            =   6600
      TabIndex        =   4
      Top             =   3000
      Width           =   1455
   End
   Begin CheckBox chkLogOutput 
      Caption         =   "Log Traversal?"
      Height          =   255
      Left            =   6480
      TabIndex        =   11
      Top             =   5520
      Width           =   1695
   End
   Begin OptionButton optTType 
      Caption         =   "VB Dynaset"
      Height          =   255
      Index           =   1
      Left            =   6480
      TabIndex        =   2
      Top             =   600
      Width           =   2055
   End
   Begin OptionButton optTType 
      Caption         =   "OO Dynaset"
      Height          =   255
      Index           =   0
      Left            =   6480
      TabIndex        =   1
      Top             =   360
      Width           =   2175
   End
   Begin TextBox txtMSOutput 
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   4935
      Left            =   3240
      MultiLine       =   -1  'True
      ScrollBars      =   3  'Both
      TabIndex        =   13
      Top             =   1560
      Width           =   3015
   End
   Begin TextBox txtSQL 
      Height          =   615
      Left            =   1320
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   0
      Top             =   480
      Width           =   4935
   End
   Begin TextBox txtOraOutput 
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   4935
      Left            =   120
      MultiLine       =   -1  'True
      ScrollBars      =   3  'Both
      TabIndex        =   14
      Top             =   1560
      Width           =   3015
   End
   Begin CommandButton cmdExecuteTest 
      Caption         =   "Execute Test"
      Height          =   495
      Left            =   6600
      TabIndex        =   12
      Top             =   6000
      Width           =   2175
   End
   Begin Frame Frame1 
      Caption         =   "Test Type"
      Height          =   1095
      Left            =   6360
      TabIndex        =   18
      Top             =   120
      Width           =   2655
   End
   Begin Frame Frame2 
      Caption         =   "Options"
      Height          =   3255
      Left            =   6360
      TabIndex        =   19
      Top             =   2640
      Width           =   2655
      Begin TextBox txtColumn 
         Height          =   285
         Left            =   1080
         TabIndex        =   5
         Text            =   "deptno"
         Top             =   720
         Width           =   1455
      End
      Begin OptionButton optDataType 
         Caption         =   "Number"
         Height          =   255
         Index           =   1
         Left            =   480
         TabIndex        =   6
         Top             =   1080
         Width           =   975
      End
      Begin OptionButton optDataType 
         Caption         =   "String"
         Height          =   255
         Index           =   0
         Left            =   1560
         TabIndex        =   7
         Top             =   1080
         Width           =   975
      End
      Begin Label Label7 
         AutoSize        =   -1  'True
         Caption         =   "2."
         FontBold        =   -1  'True
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   9.75
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   240
         Left            =   120
         TabIndex        =   20
         Top             =   2160
         Width           =   195
      End
      Begin Label Label6 
         AutoSize        =   -1  'True
         Caption         =   "1."
         FontBold        =   -1  'True
         FontItalic      =   0   'False
         FontName        =   "MS Sans Serif"
         FontSize        =   9.75
         FontStrikethru  =   0   'False
         FontUnderline   =   0   'False
         Height          =   240
         Left            =   120
         TabIndex        =   22
         Top             =   1800
         Width           =   195
      End
      Begin Label Label5 
         AutoSize        =   -1  'True
         Caption         =   "Column:"
         Height          =   195
         Left            =   360
         TabIndex        =   21
         Top             =   720
         Width           =   690
      End
   End
   Begin Label lblOConnection 
      BorderStyle     =   1  'Fixed Single
      Height          =   255
      Left            =   3840
      TabIndex        =   25
      Top             =   120
      Width           =   2415
   End
   Begin Label Label4 
      AutoSize        =   -1  'True
      Caption         =   "Visual Basic"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   12
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   300
      Left            =   3960
      TabIndex        =   24
      Top             =   1200
      Width           =   1485
   End
   Begin Label Label2 
      AutoSize        =   -1  'True
      Caption         =   "Oracle Objects"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   12
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   300
      Left            =   720
      TabIndex        =   23
      Top             =   1200
      Width           =   1785
   End
   Begin Label Label3 
      Caption         =   "SQL Statement:"
      Height          =   495
      Left            =   240
      TabIndex        =   17
      Top             =   480
      Width           =   990
   End
   Begin Label lblConnection 
      BorderStyle     =   1  'Fixed Single
      Height          =   255
      Left            =   1320
      TabIndex        =   16
      Top             =   120
      Width           =   2415
   End
   Begin Label Label1 
      AutoSize        =   -1  'True
      Caption         =   "Connections:"
      Height          =   195
      Left            =   120
      TabIndex        =   15
      Top             =   120
      Width           =   1125
   End
   Begin Menu Exit 
      Caption         =   "Exit!"
   End
End
Option Explicit

Sub BuildMSDynaset (SQL As String)

    Dim start As Variant
    Dim finish As Variant
    Dim opt

    opt = 0

    If chkReadOnly <> 0 Then
       opt = opt + 4   'ReadOnly
    End If

    If chkSQLPassthrough <> 0 Then
       opt = opt + 64   'SQLPassthrough
    End If

    start = Time
    Call PutStartLog(txtMSOutput, start)

    Set MSDynaset = Nothing
    Set MSDynaset = MSDatabase.CreateDynaset(SQL, opt)

    finish = Time
    Call PutLog(txtMSOutput, "   MSDatabase.CreateDynaset(" & SQL & "," & opt & ")" & NL)
    If MSDynaset.Updatable = False Then
      Call PutLog(txtMSOutput, "   MSDynaset.Updatable = FALSE" & NL)
    Else
      Call PutLog(txtMSOutput, "   MSDynaset.Updatable = TRUE" & NL)
    End If
    Call PutFinishLog(txtMSOutput, start, finish)

End Sub

Sub BuildMSSnapshot (SQL As String)

    Dim start As Variant
    Dim finish As Variant
    Dim opt

    opt = 0

    If chkSQLPassthrough <> 0 Then
       opt = opt + 64   'SQLPassthrough
    End If

    start = Time
    Call PutStartLog(txtMSOutput, start)

    Set MSSnapshot = Nothing
    Set MSSnapshot = MSDatabase.CreateSnapshot(SQL, opt)

    finish = Time
    Call PutLog(txtMSOutput, "   MSDatabase.CreateSnapshot(" & SQL & "," & Str$(opt) & ")" & NL)
    Call PutLog(txtMSOutput, "   MSSnapshot.Updatable = FALSE" & NL)
    Call PutFinishLog(txtMSOutput, start, finish)

End Sub

Function BuildMSSQL (ctl As Control) As String

    Dim tsql As String
    Dim op As String

    If (chkParameter.Value <> 0) And (txtColumn.Text <> "") And (txtParam1.Text <> "") And (txtParam2.Text <> "") Then
     Select Case (comOperator.ListIndex)
       Case 0
          op = " = "
       Case 1
          op = " <> "
       Case 2
          op = " > "
       Case 3
          op = " < "
       Case 4
          op = " like "
     End Select

     tsql$ = txtSQL.Text & " where " & txtColumn.Text & op
     If (optDataType(0).Value <> 0) Or (comOperator.ListIndex = 4) Then
      tsql$ = tsql$ & "'" & ctl.Text & "'"
     Else
      tsql$ = tsql$ & ctl.Text
     End If
     BuildMSSQL$ = tsql$
    Else
     BuildMSSQL$ = txtSQL.Text
    End If

End Function

Sub BuildOraDynaset (SQL As String)

    Dim start As Variant
    Dim finish As Variant
    Dim opt

    opt = 0

    If chkReadOnly <> 0 Then
       opt = opt + 4   'ReadOnly
    End If

    If chkNoCache <> 0 Then
       opt = opt + 8   'NoCache
    End If

    start = Time
    Call PutStartLog(txtOraOutput, start)
    
    Set OraDynaset = Nothing
    Set OraDynaset = OraDatabase.DbCreateDynaset(SQL, opt)

    finish = Time
    Call PutLog(txtOraOutput, "   OraDatabase.DbCreateDynaset(" & SQL & "," & opt & ")" & NL)
    If OraDynaset.Updatable = False Then
      Call PutLog(txtOraOutput, "   OraDynaset.Updatable = FALSE" & NL)
    Else
      Call PutLog(txtOraOutput, "   OraDynaset.Updatable = TRUE" & NL)
    End If
    Call PutFinishLog(txtOraOutput, start, finish)

End Sub

Function BuildOraSQL () As String

 Dim pvalue As String
 Dim op As String

 If (chkParameter.Value <> 0) And (txtColumn.Text <> "") And (txtParam1.Text <> "") And (txtParam2.Text <> "") Then
  Select Case (comOperator.ListIndex)
   Case 0
     op = " = "
   Case 1
     op = " <> "
   Case 2
     op = " > "
   Case 3
     op = " < "
   Case 4
     op = " like "
  End Select

  pvalue = txtParam1.Text
  OraDatabase.Parameters.Add "foo", pvalue, 1
  BuildOraSQL$ = txtSQL.Text & " WHERE " & txtColumn.Text & op & ":foo"
  
 Else
  BuildOraSQL$ = txtSQL.Text
 End If

End Function

Sub chkRefColumnData_Click ()

 If chkRefColumnData <> 0 Then
  chkLogOutput.Enabled = True
 Else
  chkLogOutput.Enabled = False
 End If

End Sub

Sub ClearLog (ctl As Control)

    ctl.Text = ""

End Sub

Sub cmdExecuteTest_Click ()

 RefColumnData = chkRefColumnData.Value
 LogOutput = chkLogOutput.Value

 If optTType(0) <> 0 Then
  Call OraObjTest
 ElseIf optTType(1) <> 0 Then
  Call MSDynasetTest
 Else
  Call MSSnapshotTest
 End If

End Sub

Sub Exit_Click ()
 MSDatabase.Close
 Unload frmObjLogin
 End
End Sub

Sub Form_Load ()
        
 NL = Chr$(13) & Chr$(10)

 txtSQL = "Select * from emp"
 lblConnection = OraDatabase.Connect & "@" & OraDatabase.DatabaseName
 lblOConnection = UserName$ & "@" & ODBCDatabaseName$

 optTType(0).Value = True
 optDataType(1).Value = True
 chkSQLPassthrough.Enabled = False
 chkLogOutput.Enabled = False

 comOperator.AddItem "=   (Equal to)"
 comOperator.AddItem "<>  (Not Equal to)"
 comOperator.AddItem ">   (Greater than)"
 comOperator.AddItem "<   (Less than)"
 comOperator.AddItem "like(similar to)"

 comOperator.ListIndex = 0

 Call CenterForm(frmObjTest)


End Sub

Sub MSDynasetTest ()

    Dim i As Integer
    Dim flimit As Integer
    Dim var As Variant
    Dim flds() As field
    Dim start As Variant
    Dim finish As Variant
    Dim Row

    Screen.MousePointer = HOURGLASS
    On Error GoTo ErrMSDynasetTest
    Call ClearLog(txtMSOutput)

    'create the dynaset
    MSsql = BuildMSSQL(txtParam1)
    Call BuildMSDynaset(MSsql)
    
    start = Time
    Call PutStartLog(txtMSOutput, start)

    'get the field count, and output the names
    flimit = MSDynaset.Fields.Count - 1

    'If I'm going to reference the column data....
    If RefColumnData <> 0 Then
        ReDim flds(0 To flimit)
        For i = 0 To flimit
            Set flds(i) = MSDynaset.Fields(i)
        Next i

        If LogOutput <> 0 Then
            For i = 0 To flimit
                If i = flimit Then
                    Call PutLog(txtMSOutput, flds(i).Name & NL)
                Else
                    Call PutLog(txtMSOutput, flds(i).Name & ",")
                End If
            Next i
        End If
    End If

    'get each field
    While Not MSDynaset.EOF
        If RefColumnData <> 0 Then
            For i = 0 To flimit
                var = flds(i)
                If LogOutput <> 0 Then
                    If i = flimit Then
                        Call PutLog(txtMSOutput, var & NL)
                    Else
                        Call PutLog(txtMSOutput, var & ",")
                    End If
                End If
            Next i
        End If
        MSDynaset.MoveNext
        DoEvents
    Wend

    finish = Time

    Call PutLog(txtMSOutput, "   SQL=" & MSsql & NL)
    If RefColumnData <> 0 Then
        Call PutLog(txtMSOutput, "   Referencing Column Data=TRUE" & NL)
    End If
    Call PutLog(txtMSOutput, "   Fields.Count =" & Str$(flimit + 1) & NL)
    Call PutLog(txtMSOutput, "   Fields.RecordCount =" & Str$(MSDynaset.RecordCount) & NL)

    Call PutFinishLog(txtMSOutput, start, finish)

    If (chkParameter.Value <> 0) And (txtColumn.Text <> "") And (txtParam1.Text <> "") And (txtParam2.Text <> "") Then
     MSsql = BuildMSSQL(txtParam2)
     Call BuildMSDynaset(MSsql)
    End If

    ReDim flds(0)
    MSDynaset.Close
    Screen.MousePointer = Default
    Exit Sub
              
ErrMSDynasetTest:
    Call PutLog(txtMSOutput, "Error performing MS VB Dynaset Test" & NL)
    ReDim flds(0)
    'If Not IsNull(MSDynaset) Then
    '  MSDynaset.Close
    'End If
    Screen.MousePointer = Default
    frmObjVBError.Show MODAL
    Exit Sub

End Sub

Sub MSSnapshotTest ()

    Dim i As Integer
    Dim flimit As Integer
    Dim var As Variant
    Dim flds() As field
    Dim start As Variant
    Dim finish As Variant
    Dim Row

    Screen.MousePointer = HOURGLASS
    On Error GoTo ErrMSSnapshotTest
    Call ClearLog(txtMSOutput)

    'create the dynaset
    MSsql = BuildMSSQL(txtParam1)
    Call BuildMSSnapshot(MSsql)
    
    start = Time
    Call PutStartLog(txtMSOutput, start)

    'get the field count, and output the names
    flimit = MSSnapshot.Fields.Count - 1

    'If I'm going to reference the column data....
    If RefColumnData <> 0 Then
        ReDim flds(0 To flimit)
        For i = 0 To flimit
            Set flds(i) = MSSnapshot.Fields(i)
        Next i

        If LogOutput <> 0 Then
            For i = 0 To flimit
                If i = flimit Then
                    Call PutLog(txtMSOutput, flds(i).Name & NL)
                Else
                    Call PutLog(txtMSOutput, flds(i).Name & ",")
                End If
            Next i
        End If

    End If

    'get each field
    While Not MSSnapshot.EOF
        If RefColumnData <> 0 Then
            For i = 0 To flimit
                var = flds(i)
                If LogOutput <> 0 Then
                    If i = flimit Then
                        Call PutLog(txtMSOutput, var & NL)
                    Else
                        Call PutLog(txtMSOutput, var & ",")
                    End If
                End If
            Next i
        End If
        MSSnapshot.MoveNext
        DoEvents
    Wend

    finish = Time

    Call PutLog(txtMSOutput, "   SQL=" & MSsql & NL)
    If RefColumnData <> 0 Then
        Call PutLog(txtMSOutput, "   Referencing Column Data=TRUE" & NL)
    End If
    Call PutLog(txtMSOutput, "   Fields.Count =" & Str$(flimit + 1) & NL)
    Call PutLog(txtMSOutput, "   Fields.RecordCount =" & Str$(MSSnapshot.RecordCount) & NL)

    Call PutFinishLog(txtMSOutput, start, finish)

    If (chkParameter.Value <> 0) And (txtColumn.Text <> "") And (txtParam1.Text <> "") And (txtParam2.Text <> "") Then
     MSsql = BuildMSSQL(txtParam2)
     Call BuildMSSnapshot(MSsql)
    End If

    ReDim flds(0)
    MSSnapshot.Close
    Screen.MousePointer = Default
    Exit Sub
              
ErrMSSnapshotTest:
    Call PutLog(txtMSOutput, "Error performing MS VB Snapshot Test" & NL)
    ReDim flds(0)
    'If Not IsNull(MSDynasetSnapshot) Then
    '  MSSnapshot.Close
    'End If
    Screen.MousePointer = Default
    frmObjVBError.Show MODAL
    Exit Sub

End Sub

Sub optTType_Click (Index As Integer)

    If (Index = 0) Then
     chkSQLPassthrough.Enabled = False
     chkReadOnly.Enabled = True
     chkNoCache.Enabled = True
     ElseIf (Index = 1) Then
     chkSQLPassthrough.Enabled = True
     chkReadOnly.Enabled = True
     chkNoCache.Enabled = False
    Else
     chkSQLPassthrough.Enabled = True
     chkNoCache.Enabled = False
     chkReadOnly.Enabled = False
    End If

End Sub

Sub OraObjTest ()

    Dim i As Integer
    Dim flimit As Integer
    Dim var As Variant
    Dim flds() As Object
    Dim start As Variant
    Dim finish As Variant
    Dim Row
    Dim orasql As String

    Screen.MousePointer = HOURGLASS
    On Error GoTo ErrObjectTest
    Call ClearLog(txtOraOutput)
    
    'create the dynaset
    orasql = BuildOraSQL()
    Call BuildOraDynaset(orasql)

    start = Time
    Call PutStartLog(txtOraOutput, start)

    'get the field count, and output the names
    flimit = OraDynaset.Fields.Count - 1

    'If I'm going to reference the column data....
    If RefColumnData <> 0 Then
        ReDim flds(0 To flimit)
        For i = 0 To flimit
            Set flds(i) = OraDynaset.Fields(i)
        Next i

        If LogOutput <> 0 Then
            For i = 0 To flimit
                If i = flimit Then
                    Call PutLog(txtOraOutput, flds(i).Name & NL)
                Else
                    Call PutLog(txtOraOutput, flds(i).Name & ",")
                End If
            Next i
        End If
    End If

    'get each field
    While Not OraDynaset.EOF
        If RefColumnData <> 0 Then
            For i = 0 To flimit
                var = flds(i)
                If LogOutput <> 0 Then
                    If i = flimit Then
                        Call PutLog(txtOraOutput, var & NL)
                    Else
                        Call PutLog(txtOraOutput, var & ",")
                    End If
                End If
            Next i
        End If

        OraDynaset.DbMoveNext
        DoEvents
    Wend
    
    finish = Time

    Call PutLog(txtOraOutput, "   SQL=" & OraDynaset.SQL & NL)
    If RefColumnData <> 0 Then
        Call PutLog(txtOraOutput, "   Referencing Column Data=TRUE" & NL)
    End If
    Call PutLog(txtOraOutput, "   Fields.Count =" & Str$(flimit + 1) & NL)
    Call PutLog(txtOraOutput, "   Fields.RecordCount =" & Str$(OraDynaset.RecordCount) & NL)

    Call PutFinishLog(txtOraOutput, start, finish)
    
    ReDim flds(0)

    If (chkParameter.Value <> 0) And (txtColumn.Text <> "") And (txtParam1.Text <> "") And (txtParam2.Text <> "") Then
      start = Time
      Call PutStartLog(txtOraOutput, start)
      var = txtParam2.Text
      OraDatabase.Parameters("foo").Value = var
      OraDynaset.DbRefresh
      Call PutLog(txtOraOutput, "   RecordSet.DbRefresh" & NL)
      finish = Time
      Call PutFinishLog(txtOraOutput, start, finish)
      OraDatabase.Parameters.Remove "foo"
    End If

    Set OraDynaset = Nothing
    Screen.MousePointer = Default
    Exit Sub

ErrObjectTest:
    Call PutLog(txtOraOutput, "Error performing an Oracle Test" & NL)
    ReDim flds(0)
    Set OraDynaset = Nothing
    Screen.MousePointer = Default
    frmObjOraError.Show MODAL
    Exit Sub

End Sub

Sub PutFinishLog (ctl As Control, start As Variant, finish As Variant)

    Call PutLog(ctl, "Time Finished: " & finish & NL)
    Call PutLog(ctl, "Time Elapsed: " & DateDiff("s", start, finish) & " seconds" & NL & NL)

End Sub

Sub PutLog (ctl As Control, msg As String)

    ctl.SelStart = Len(ctl.Text)
    ctl.SelText = msg

End Sub

Sub PutStartLog (ctl As Control, start As Variant)

    Call PutLog(ctl, "Time Started: " & start & NL)
    
End Sub

