PROGRAM QTXT; {v1.10 - Free DOS utility: Converts .QWK packets to text files.}
{$M 5120,0,0}  { 5k reserved for data }
{$N-,E- no math support needed}
{$X- function calls may not be discarded}
{$I- disable I/O checking (trap errors by checking IOResult)}

{===========================================================================}
                    (** Global declarations ... **)
{===========================================================================}

USES
  DOS, ARCID;

CONST
  cursorState : BYTE = 1;  {0..3}
  cursorData : ARRAY [0..3] OF CHAR = (#179, #47, #196, #92);
  MaxConfs = 5240;
  ConfNameLength = 12;

TYPE
  ConfNameArray = ARRAY [0..MaxConfs] OF ARRAY [1..ConfNameLength] OF CHAR;
  STRING6 = STRING [6];
  STRING12 = STRING [12];

VAR
  unQWK, unARC, unARJ, unHAP, unLHA,
  unPAK, unRAR, unUC2, unZIP, unZOO : PATHSTR;
  BBSid    : STRING12;
  CNames   : ConfNameArray;

{===========================================================================}
                (** Custom help & exit procedure ... **)
{===========================================================================}

VAR SavedExitProc: POINTER;
PROCEDURE cursorOn; FORWARD;
FUNCTION WordToHex (i: WORD): STRING; FORWARD;

PROCEDURE CustomExit; FAR;
{---- Always exit through here ----}
CONST
  NL = #13#10;
VAR
  message: STRING [79];
BEGIN
  ExitProc := SavedExitProc;
  cursorOn;
  IF (ExitCode > 0) THEN BEGIN
    WriteLn ('QTXT v1.10 - Free DOS utility: Converts .QWK packets to text files.');
    WriteLn ('September 29, 1995. Copyright (c) 1995 by David Daniel Anderson - Reign Ware.'+NL);
    WriteLn ('Usage:    QTXT <QWKpacket(s)>');
    WriteLn ('Example:  QTXT c:\qwks\*.qwk'+NL);
    WriteLn ('Note: DOS wildcards may be used when specifying the QWKpackets.'+NL);
  END;
  IF ErrorAddr <> NIL THEN {If an unanticipated run-time error occured...}
  BEGIN
    WriteLn ('An unanticipated error occurred, please contact DDA with the following data:');
    WriteLn ('Address = ', WordToHex (Seg (ErrorAddr^)), ':', WordToHex (Ofs (ErrorAddr^)));
    WriteLn ('Code    = ', ExitCode);
    ErrorAddr := NIL; {IMPORTANT!!!}
  END
  ELSE
    IF (ExitCode IN [1..254]) THEN BEGIN
      CASE ExitCode OF
        1 : message := 'Invalid parameter on command line or parameter missing.';
        7 : message := 'File handling error.  File may have been corrupted or deleted!';
        ELSE  message := 'Unknown error.';
      END;
      WriteLn (#7, 'Error encountered (#', ExitCode, '):'); WriteLn (message);
    END;
END;

{===========================================================================}
                   (** Supporting subroutines ... **)
{===========================================================================}

FUNCTION WordToHex (i: WORD): STRING; {Convert a WORD variable to STRING}
CONST
  HexLetters : ARRAY [0..15] OF CHAR = '0123456789ABCDEF';
BEGIN
  WordToHex := Concat (HexLetters [Hi (i) SHR 4], HexLetters [Hi (i) AND 15],
                       HexLetters [Lo (i) SHR 4], HexLetters [Lo (i) AND 15]);
END;

PROCEDURE CheckIO;
BEGIN
  IF IOResult <> 0 THEN Halt (7);
END;

PROCEDURE cursorOn; ASSEMBLER; ASM
  mov AH, 3; mov BH, 0; Int $10; AND CH, NOT $20; mov AH, 1; Int $10;
END;

PROCEDURE cursorOff; ASSEMBLER; ASM
  mov AH, 3; mov BH, 0; Int $10; OR CH, $20; mov AH, 1; Int $10;
END;

PROCEDURE updateCursor;
BEGIN
  cursorState := Succ (cursorState) AND 3;
  Write (cursorData [cursorState], ^H);
END;

FUNCTION WhereX: BYTE; ASSEMBLER;
(* Routine from SWAG *)
ASM
  MOV AH, 3     {Ask For current cursor position}
  MOV BH, 0     { On page 0 }
  Int 10h       { Return inFormation in DX }
  Inc DL        { Bios Assumes Zero-based. Crt.WhereX Uses 1 based }
  MOV AL, DL    { Return X position in AL For use in Byte Result }
END;

FUNCTION WhereY: BYTE; ASSEMBLER;
(* Routine from SWAG *)
ASM
  MOV AH, 3    {Ask For current cursor position}
  MOV BH, 0    { On page 0 }
  Int 10h      { Return inFormation in DX }
  Inc DH       { Bios Assumes Zero-based. Crt.WhereY Uses 1 based }
  MOV AL, DH   { Return Y position in AL For use in Byte Result }
END;

PROCEDURE GotoXY (X, Y: BYTE); ASSEMBLER;
(* Routine from SWAG *)
ASM
  MOV DH, Y    { DH = Row (Y) }
  MOV DL, X    { DL = Column (X) }
  Dec DH       { Adjust For Zero-based Bios routines }
  Dec DL       { Turbo Crt.GotoXY is 1-based }
  MOV BH, 0    { Display page 0 }
  MOV AH, 2    { Call For SET CURSOR POSITION }
  Int 10h
END;

PROCEDURE WriteCharAtCursor (X: CHAR);
(* Routine from SWAG *)
VAR
  reg: REGISTERS;
BEGIN
  reg. AH := $0A;
  reg. AL := Ord (X);
  reg. BH := $00;    {* Display Page Number. * for Graphics Modes! *}
  reg. CX := 1;      {* Word for number of characters to write *}
  Intr ($10, reg);
END;

PROCEDURE ClrEol;
(* Routine by DDA *)
VAR
  NumCol: WORD ABSOLUTE $0040: $004A; { Number of CRT columns (1-based) }
  X, Y, DistanceToRight: BYTE;
BEGIN
  X := WhereX;
  Y := WhereY;
  DistanceToRight := NumCol - X;
  Write ('': DistanceToRight);
  WriteCharAtCursor (#32);
  GotoXY (X, Y);
END;

FUNCTION LeadingZero (w : WORD) : STRING;
VAR
  s : STRING;
BEGIN
  Str (w: 0, s);
  IF Length (s) = 1 THEN
    s := '0' + s;
  LeadingZero := s;
END;

PROCEDURE UpFast (VAR Str: STRING);  {** from SWAG **}
INLINE ($8C/$DA/$5E/$1F/$FC/$AC/$30/$E4/$89/$C1/$E3/$12/$BB/Ord('a')/Ord('z')/
        $AC/$38/$D8/$72/$08/$38/$F8/$77/$04/$80/$6C/$FF/$20/$E2/$F1/$8E/$DA);

FUNCTION Upper (lstr : STRING): STRING;
BEGIN
  upfast (lstr);
  Upper := lstr;
END;

FUNCTION RPad (bstr: STRING; CONST len: BYTE): STRING;
BEGIN
  WHILE (Length (bstr) < len) DO
    bstr := bstr + #32;
  RPad := bstr;
END;

FUNCTION RTrim (InStr: STRING): STRING;
BEGIN
  WHILE (Length (InStr) > 0) AND (InStr [Length (InStr)] IN [#0, #9, #32]) DO
    system. Dec (InStr [0]);
  RTrim := InStr;
END;

FUNCTION LTrim (InStr: STRING): STRING;
BEGIN
  WHILE (Length (InStr) > 0) AND (InStr [1] IN [#0, #9, #32]) DO
    Delete (InStr, 1, 1);
  LTrim := InStr;
END;

FUNCTION Trim (InStr: STRING): STRING;
BEGIN
  Trim := RTrim (LTrim (InStr));
END;

FUNCTION IsFile (CONST FileName: PATHSTR): BOOLEAN;
VAR
  Attr  : WORD;
  cFile : FILE;
BEGIN
  Assign (cFile, FileName);
  GetFAttr (cFile, Attr);
  IF (DosError = 0) AND ((Attr AND Directory) <> Directory)
    THEN IsFile := TRUE
    ELSE IsFile := FALSE;
END;

PROCEDURE EraseFile (CONST MSGFile : PATHSTR);
VAR
  df : FILE;
BEGIN
  IF IsFile (MSGFile) THEN BEGIN
    Assign (df, MSGFile);
    Erase (df); CheckIO;
  END;
END;

FUNCTION IsDir (CONST FileName: PATHSTR): BOOLEAN;
VAR
  Attr  : WORD;
  cFile : FILE;
BEGIN
  Assign (cFile, FileName);
  GetFAttr (cFile, Attr);
  IF (DosError = 0) AND ((Attr AND Directory) = Directory)
    THEN IsDir := TRUE
    ELSE IsDir := FALSE;
END;

FUNCTION GetFilePath (CONST PSTR: STRING; VAR sDir: DIRSTR): PATHSTR;
VAR
  jPath     : PATHSTR;  { file path,       }
  jDir      : DIRSTR;   {      directory,  }
  jName     : NAMESTR;  {      name,       }
  jExt      : EXTSTR;   {      extension.  }
BEGIN
  jPath := PSTR;
  IF jPath = '' THEN jPath := '*.*';
  IF (NOT (jPath [Length (jPath)] IN [':', '\'])) AND IsDir (jPath) THEN
    jPath := jPath + '\';
  IF (jPath [Length (jPath)] IN [':', '\']) THEN
    jPath := jPath + '*.*';

  FSplit (FExpand (jPath), jDir, jName, jExt);
  jPath := jDir + jName+ jExt;

  sDir := jDir;
  GetFilePath := jPath;
END;

{===========================================================================}
                    (** Primary subroutines ... **)
{===========================================================================}

PROCEDURE InitArcQWK;
VAR
  cpath : PATHSTR; {cpath, etc fully qualified pathnames of *.cfg files}
  cdir  : DIRSTR;
  cname : NAMESTR;
  cext  : EXTSTR;
  CfgFile: TEXT;
  CfgLine,
  CfgVar, CfgVal: PATHSTR;
  equalPos: BYTE;

BEGIN
  FSplit (FExpand (ParamStr(0)), cdir, cname, cext); { break up path into components }
  cpath := cdir + cname + '.cfg';

  unQWK := 'gus';

  unARC := 'pkxarc';
  unARJ := 'arj e -y';
  unHAP := 'pah e';
  unLHA := 'lha e';
  unPAK := 'pak e /wa';
  unRAR := 'rar e';
  unUC2 := 'uc e -f';
  unZIP := 'pkunzip -# -o';
  unZOO := 'zoo -extract';

  IF IsFile (cpath) THEN
  BEGIN
    Assign (CfgFile, cpath);
    Reset (CfgFile); CheckIO;
    WHILE NOT SeekEoF (CfgFile) DO
    BEGIN { find vars }
      ReadLn (CfgFile, CfgLine);
      equalPos := Pos ('=', CfgLine);
      IF (equalPos > 1) AND (Length (CfgLine) > 8) THEN BEGIN

        CfgVar := Trim (Upper (Copy (CfgLine, 1, equalPos - 1)));
        CfgVal := Trim (Copy (CfgLine, equalPos + 1, Length (CfgLine) - equalPos));

        IF (CfgVar = 'UNQWK') THEN
          unQWK := CfgVal
        ELSE IF (CfgVar = 'UNARC') THEN
          unARC := CfgVal
        ELSE IF (CfgVar = 'UNARJ') THEN
          unARJ := CfgVal
        ELSE IF (CfgVar = 'UNHAP') THEN
          unHAP := CfgVal
        ELSE IF (CfgVar = 'UNLHA') THEN
          unLHA := CfgVal
        ELSE IF (CfgVar = 'UNPAK') THEN
          unPAK := CfgVal
        ELSE IF (CfgVar = 'UNRAR') THEN
          unRAR := CfgVal
        ELSE IF (CfgVar = 'UNUC2') THEN
          unUC2 := CfgVal
        ELSE IF (CfgVar = 'UNZIP') THEN
          unZIP := CfgVal
        ELSE IF (CfgVar = 'UNZOO') THEN
          unZOO := CfgVal
      END;
    END; { loop back to read another line }
    Close (CfgFile);
  END;
END;
{===========================================================================}

FUNCTION IsArchive (CONST SomeFile: PATHSTR): PATHSTR;
VAR
  ExCMD : PATHSTR;
  ArcType : STRING [6];
BEGIN
  ExCMD := '';
  ArcType := IsArc (SomeFile);
  IF ArcType <> 'Error' THEN BEGIN

     IF ArcType = 'ARC' THEN ExCMD := unARC ELSE
     IF ArcType = 'ARJ' THEN ExCMD := unARJ ELSE
     IF ArcType = 'LHA' THEN ExCMD := unLHA ELSE
     IF ArcType = 'PAH' THEN ExCMD := unHAP ELSE
     IF ArcType = 'PAK' THEN ExCMD := unPAK ELSE
     IF ArcType = 'RAR' THEN ExCMD := unRAR ELSE
     IF ArcType = 'UC2' THEN ExCMD := unUC2 ELSE
     IF ArcType = 'ZIP' THEN ExCMD := unZIP ELSE
     IF ArcType = 'ZOO' THEN ExCMD := unZOO
        ELSE
        BEGIN
          ArcType := 'UserType';
          ExCMD := unQWK;
        END;
     Write ('(ID is: ', ArcType, ') ');
  END;
  IsArchive := ExCMD;
END;

FUNCTION ExtractFile (CONST ArchiveFile, FileToEx: PATHSTR; ExCMD: PATHSTR): BOOLEAN;
VAR
  X, Y, newX: BYTE;
BEGIN
  X := WhereX;
  Y := WhereY;

  ExCMD := ExCMD + #32 + ArchiveFile + #32 + FileToEx;
  SwapVectors;
    Exec (GetEnv ('COMSPEC'), ' /c '+ExCMD+' >nul');
  SwapVectors;

  newX := WhereX;
  IF (Y = WhereY) and (WhereX >= newX) THEN
  BEGIN  {If we haven't moved to a new line... }
    GotoXY (X, Y);  {return to where we were at start of procedure}
    ClrEol;
  END;
  cursorOff;
  ExtractFile := IsFile (FileToEx)
END;
{===========================================================================}

FUNCTION InitConfNamesArray (CONST QWKpath, CNFFileName, EXCMD: PATHSTR): STRING12;
VAR X, Y: WORD;
  CNFFile  : TEXT;
  CNameStr : PATHSTR;
  CNumb,
  CNameInt : WORD;
  BBSname  : STRING12;
  VErr     : INTEGER;
BEGIN
  BBSname := 'unknown' + #32#32#32#32#32#32#32;
  FOR X := 0 TO (MaxConfs - 1) DO
    FillChar (CNames [X], 12, #32);

  IF ExtractFile (QWKpath, CNFFileName, ExCMD) THEN BEGIN
    Assign (CNFFile, CNFFileName);
    Reset (CNFFile); CheckIO;

    FOR X := 1 TO 5 DO                    { advance to BBSid }
      IF NOT EoF (CNFFile) THEN
        ReadLn (CNFFile, CNameStr);

    IF NOT EoF (CNFFile) AND (Pos (',', CNameStr) > 0) THEN BEGIN
      Delete (CNameStr, 1, Pos (',', CNameStr));
      BBSname := RPad (Trim (CNameStr), 12);         { extract BBSname }
    END;

    FOR X := 1 TO 5 DO      { advance to just before number of conferences }
      IF NOT EoF (CNFFile) THEN
        ReadLn (CNFFile, CNameStr);

    IF NOT EoF (CNFFile) THEN BEGIN
      ReadLn (CNFFile, CNameStr);           { get number of conferences }
      Val (Trim (CNameStr), CNameInt, VErr);
      IF (VErr = 0) THEN
        FOR X := 0 TO CNameInt DO           { walk through conf names }
          IF NOT EoF (CNFFile) THEN BEGIN
            ReadLn (CNFFile, CNameStr);       { read conference number }
            Val (Trim (CNameStr), CNumb, VErr);
            IF (VErr = 0) AND (NOT EoF (CNFFile)) THEN BEGIN
              ReadLn (CNFFile, CNameStr);     { read conference name }
              FOR Y := 1 TO Length (CNameStr) DO
                IF (Y <= ConfNameLength) THEN
                  CNames [CNumb] [Y] := CNameStr [Y];
            END;
          END;
    END;
    Close (CNFFile);
    EraseFile (CNFFileName);
  END;
  InitConfNamesArray := BBSname;
END;
{===========================================================================}

FUNCTION AdjustTime (Time: STRING6): STRING6;
VAR
  ampm : CHAR;
  Hour : BYTE;
  VErr : INTEGER;
BEGIN
  ampm := 'a';
  Val (Copy (Time, 1, 2), Hour, VErr);

  IF (Hour >= 12) THEN BEGIN
    ampm := 'p';
    IF (Hour >= 13) THEN
      Dec (Hour, 12);
  END;
  AdjustTime := LeadingZero (Hour) + Copy (Time, 3, 3) + ampm;
END;

PROCEDURE ProcessHeader (VAR MSGFile: FILE; VAR TXTfile: TEXT; VAR NumChunks: INTEGER);
CONST
  herald    = '===============================================================================';
  Separator = '-------------------------------------------------------------------------------';
  space = #32;

(* Note: the meaning of the status flag (byte 1) in the header of the QWK
   format specification is interpreted differently by different products.

   According to Robomail v1.30, an asterisk ('*') apparently means private
   and received, and the plus sign ('+') means private but NOT received.

   Most every other program and document I have encountered seem to agree
   that the meaning of those two symbols is reversed.  Therefore, in this
   program, the private and received flags will be translated into the
   following symbols:

       public, unread   =  ' '  (#32)
       public, read     =  '-'  (#45)
       private, unread  =  '*'  (#42)
       private, read    =  '+'  (#43)
*)
TYPE
  MSGDATHdr = RECORD
                Status   : CHAR;
                MSGNum   : ARRAY [1..7] OF CHAR;
                Date     : ARRAY [1..8] OF CHAR;
                Time     : ARRAY [1..5] OF CHAR;
                WhoTo    : ARRAY [1..25] OF CHAR;
                WhoFrom  : ARRAY [1..25] OF CHAR;
                Subject  : ARRAY [1..25] OF CHAR;
                PassWord : ARRAY [1..12] OF CHAR;
                ReferNum : ARRAY [1..8] OF CHAR;
                NumChunk : ARRAY [1..6] OF CHAR;
                Alive    : BYTE;
                ConfNumb : WORD;
                Reserved : ARRAY [1..3] OF CHAR;
              END;
VAR
  VErr : INTEGER;
  MessageHeader : MSGDATHdr;
BEGIN
  updateCursor;
  BlockRead (MSGFile, MessageHeader, 1);
  Val (Trim (MessageHeader. NumChunk), NumChunks, VErr);
  IF (VErr <> 0) THEN NumChunks := 0;
  IF NumChunks <> 0 THEN
    WITH MessageHeader DO BEGIN
      WriteLn (TXTfile, herald);
      WriteLn (TXTfile, space: 5, 'Date: ', Date,
      space: 4, 'Time: ', AdjustTime (Time),
      space: 5, 'Number: ', MSGNum);
      WriteLn (TXTfile, space: 5, 'From: ', WhoFrom,
      space: 5, 'Refer: ', ReferNum);
      Write   (TXTfile, space: 7, 'To: ', WhoTo,
      space: 2, 'Board ID: ', BBSid,
      space: 4, 'Recvd: ');
      IF Status IN [#32, #42, #126, #37, #33, #36] {unread symbols}
        THEN WriteLn (TXTfile, 'No')
        ELSE WriteLn (TXTfile, 'Yes');
      Write   (TXTfile, space: 2, 'Subject: ', Subject,
      space: 4, ConfNumb: 6, ': ', CNames [ConfNumb],
      space: 3, 'Status: ');
      IF Status IN [#43, #42, #126, #96, #33, #35] {private symbols}
        THEN WriteLn (TXTfile, 'Private')
        ELSE WriteLn (TXTfile, 'Public');
      WriteLn (TXTfile, Separator);
    END;
END;
{===========================================================================}

PROCEDURE ProcessMessage (VAR MSGFile: FILE; VAR TXTfile: TEXT; NumChunks: INTEGER);
VAR
  Buff     : ARRAY [1..128] OF CHAR;
  BuffStr  : STRING;
  QRecs    : INTEGER;
  BuffByte : BYTE;
  LastSpace : BYTE;
BEGIN
  BuffStr := '';
  FOR QRecs := 1 TO Pred (NumChunks) DO BEGIN
    BlockRead (MSGFile, Buff, 1);
    FOR BuffByte := 1 TO 128 DO
      IF Buff [BuffByte] = #227
      THEN BEGIN
        WriteLn (TXTfile, RTrim (BuffStr));
        BuffStr := '';
      END
      ELSE BEGIN
        IF (Length (BuffStr) = 255) THEN BEGIN    {dump full string buffer}
          BuffStr := RTrim (BuffStr);
          LastSpace := Length (BuffStr);
          IF Pos (#32, BuffStr) = 0 THEN BEGIN
            WriteLn (TXTfile, BuffStr); {if no space in string, dump it all}
            BuffStr := '';
          END
          ELSE BEGIN  {if space found, dump all except chars after space}
            REPEAT
              Dec (LastSpace)
            UNTIL (BuffStr [LastSpace] = #32);
            WriteLn (TXTfile, RTrim (Copy (BuffStr, 1, LastSpace)));
            BuffStr := Copy (BuffStr, LastSpace+1, Length (BuffStr) - LastSpace);
          END;
        END;
        BuffStr := BuffStr + Buff [BuffByte];
      END;
  END;
  WriteLn (TXTfile, RTrim (BuffStr));
END;
{===========================================================================}

PROCEDURE ProcessFiles (VAR MSGFile: FILE; VAR TXTfile: TEXT);
VAR
  QWKrecs,
  Chunks    : INTEGER;
BEGIN
  QWKrecs := 2;                         { start at RECORD #2 }
  WHILE QWKrecs < FileSize (MSGFile) DO BEGIN
    Seek (MSGFile, QWKrecs - 1);
    ProcessHeader (MSGFile, TXTfile, Chunks);
    IF Chunks <> 0
      THEN ProcessMessage (MSGFile, TXTfile, Chunks)
      ELSE Chunks := 1;
    Inc (QWKrecs, Chunks);
  END;
END;

{===========================================================================}
                        (** Main program ... **)
{===========================================================================}

CONST
  MSGFileName = 'MESSAGES.DAT';
  CNFFileName = 'CONTROL.DAT';

VAR
  MSGFile : FILE;
  TXTfile : TEXT;

  QWKpath  : PATHSTR;    { QWK file path. }
  QWKdir   : DIRSTR;     { QWK file dir.  }
  TXTpath  : PATHSTR;    { TXT file path. }
  fileinfo : SEARCHREC;
  ExCMD    : PATHSTR;

BEGIN
  SavedExitProc := ExitProc;
  ExitProc := @CustomExit;
  cursorOff;

  IF ParamCount <> 1 THEN Halt (255);
  InitArcQWK;

  QWKpath := GetFilePath (ParamStr (1), QWKdir);

  FindFirst (QWKpath, Archive, fileinfo); IF DosError <> 0 THEN Halt (1);
  WriteLn ('QTXT v1.10 - Free QWK to TXT convertor is now working.');
  WHILE DosError = 0 DO
  BEGIN
    QWKpath := QWKdir + fileinfo. Name;
    TXTpath := fileinfo. Name;
    IF (Pos ('.', TXTpath) > 0) AND (Pos ('.', TXTpath) < Length (TXTpath))
      THEN TXTpath [1 + Pos ('.', TXTpath)] := 'T'
      ELSE TXTpath := TXTpath + '.T';

    Write ('Checking ', QWKpath, ' and ', TXTpath);
    IF IsFile (TXTpath)
    THEN WriteLn (' ... text file exists - skipping.')
    ELSE BEGIN
      WriteLn (' done!');
      EraseFile (MSGFileName);

      Write ('Extracting MESSAGES.DAT from ', QWKpath, ' ... ');
      ExCMD := IsArchive (QWKpath);
      IF ExtractFile (QWKpath, MSGfileName, ExCMD) THEN
      BEGIN
        WriteLn ('done!');
        BBSid := InitConfNamesArray (QWKpath, CNFFileName, ExCMD);
        Assign (MSGFile, MSGFileName);
        Reset (MSGFile, 128); CheckIO;
        Assign (TXTfile, TXTpath);
        Rewrite (TXTfile); CheckIO;
        Write ('Translating messages to ', TXTpath, #32);
        ProcessFiles (MSGFile, TXTfile);
        WriteLn (#8, ', done!');
        Close (MSGFile); CheckIO;
        Close (TXTfile); CheckIO;
        EraseFile (MSGFileName);
      END
      ELSE
        WriteLn (' - skipping.');
    END;
    FindNext (fileinfo);
  END;
  WriteLn ('Mission accomplished!');
END.
