                            SCHEMATICS README

This file describes the enhancements and modifications for the 5.1 
release of the Design Center - System 3 with schematic capture.  The
information provided in this file is extracted from the Genesis User's
Guide.  Any information which did not make it into the 5.1 version of 
the Genesis User's Guide is included in this file as well.


1.0)   GENERAL MODIFICATIONS

       1.  When one or more of the MicroSim Design Center Windows 
           programs is run a program called the Design Manager is 
           automatically run also.  You will see its icon in the 
           lower left corner of the screen.  This program is a 
           background task that provides file and message 
           coordination between the various MicroSim programs.  If 
           you restore the Design Manager icon to a window you will
           notice that it keeps a list of all the other MicroSim 
           programs running and the files they are using.  

           The Design Manager will automatically quit when there are
           no other MicroSim programs running.  You should not try
           to delete or otherwise manipulate the Design Manager,
           since it is necessary for the proper execution of the 
           other MicroSim programs and provides no functionality to
           the user.             

       2.  You can specify the commands used to invoke PSpice and 
           Probe by editing the 
                     
                        PSPICECMD=
                        PROBECMD=
                              
           lines in the [SCHEMATICS] section of your "msim.ini" 
           file.

                 
2.0)   NEW FEATURES

       1.  The marker interface feature allows you to place one or 
           more markers on your schematic and view the corresponding
           analog or digital waveform associated with the marked 
           wire, pin, or device using Probe.
        
           The Markers Menu provides commands which allow you to 
           place and manipulate special objects called "markers."
           After a schematic is simulated and the Probe waveform 
           analyzer is invoked, markers enable you to visually 
           indicate points on the schematic where you wish to see
           voltages, currents, and digital signals shown in Probe.        
        
           Information regarding the newly added Markers Menu can be 
           found in the Genesis User's Guide, Chapter Five, Section 
           5.3.8.  The following commands allow you to place one or
           more markers on the current page of the schematic.  If 
           Probe is running and the schematic is current, Probe will
           be updated to show the specified waveform as each marker 
           is placed.
           
           Mark Voltage/Level
           
           Mark Voltage Differential
              
           Mark Current Into Pin
       
           Clear All
       
           Show All
       
           Show Selected


       2.  Auto-run Probe has been added to the Analysis Menu.  This 
           allows you to specify whether or not Probe is to be run 
           automatically after the simulation has been successfully 
           completed.


3.0)   KNOWN PROBLEMS

       1.  To change the default title block symbol, you will need to 
           directly change the "msim.ini" file.  The Title Block menu 
           item in the Configuration Menu will not save a newly named 
           title block.  The functionality of the dialog box is not 
           yet implemented.  Instead, use Notepad or any text editor,
           to change the default value in the TITLEBLOCKSYM item 
           from "titleblk" to the name of your title block symbol.  
           Remove the TITLEBLOCKSYM line entirely if you do not wish 
           a title block to be automatically added to new pages.
       
       2.  You must first initialize the printer by selecting 
           Printer Setup under the File Menu after you have installed
           Schematics.  After this is done, Schematics will remember
           the printer setup and any further changes made to it.

       3.  Arcs do not draw properly on HP plotters (this is a 
           problem with the driver - HP may have a newer version 
           available).

       4.  Changing pin names on symbols used in schematic files may
           cause problems when attempting to read in the schematic.

4.0)   SYMBOL LIBRARIES

       Table 6 on page 33 of the Genesis User's Guide provides 
       a list of all the symbol libraries included in the 
       5.1 release of the Design Center - System 3.  The following 
       symbol libraries are missing from the list on page 3:
       
       burr_brn.slb -  operational amplifiers
       dig_ecl.slb  -  10K and 100K ECL parts
       opto.slb     -  optocouplers 
       misc.slb     -  voltage controlled cap, resistor, inductor,
                       admittance, 555 timers
       special.slb  -  simulation psuedo-devices (IC, NODESET, etc.)
       swit_rav.slb -  switch mode power supply models
       swit_reg.slb -  switch mode power supply models
       thyristr.slb -  SCR's and Triacs
       xtal.slb     -  quartz crystals

       The following symbol libraries listed below are new for
       the 5.1 release:

       dig_pal.slb  -  Programmable array logic devices
       dig_gal.slb  -  Generic array logic devices
       europe.slb   -  European bipolar, power bipolar and diode 
                       devices
       marker.slb   -  Probe markers


4.1)   SYMBOL LIBRARY CHANGES

       A number of symbols have been modified in order to correct 
       certain problems.  These modifications have resulted in 
       changes to pin names, pin locations, and/or part size.  
       Schematic drawings using these parts will need to be updated 
       when using the modified symbols.  Pin name changes are handled
       automatically.  Other changes will require some action on your 
       part.

       For any parts whose pin names have changed, Schematics will 
       automatically replace the "old" instances (i.e. what you had 
       originally placed on your schematic) with the "new" ones.  You 
       will get some messages when you read in your schematic (File/
       Open):
             [8009]  Invalid connection(s) during readin:

       You can then select Analysis/Current Errors to see which pin
       names on which devices have changed:
       
             Pin not found:  pin 3 on symbol ua741
             Invalid connection(s) during readin: [p.1] deleting 
             junction @ [230,160]
             .
             .
             .
             Reconnecting due to possible pinname change(s): U1

       The part is automatically disconnected and reconnected for you.  
       No further action is necessary.

       For those parts whose size and/or pin locations have changed, 
       you will need to delete and then undelete each part, and 
       rewire (in most cases) to re-establish connectivity.  This is
       accomplished using the following steps:

           1) Click on the part to select it
           2) Edit/Cut to delete (or strike the Delete key on your
	      keyboard)
	   3) Edit/Undelete to undelete (or use the Ctrl-U 
	      accelerator key).
           4) Draw/Rewire and click on the wire segment to rewire to
	      the pin

       or

           4) Click on the hanging wire to select it
           5) Edit/Cut to delete (or strike the Delete key on your 
	      keyboard)
           6) Draw/Wire to reconnect the wire


4.1.1) PIN NAME CHANGES

       In all symbol libraries containing 5-, 6-, and 7-terminal
       opamps, the names of the + and - power supply pins have been 
       changed to V+ and V- (from 3 and 4, originally).

       Pin names on the T device ("analog.slb") were changed from 
       1,2,3,4 to A+, A-, B+, B-.

       In "dig_1.slb," the 85 part has pins whose names were changed
       from A<B_OUT, A>B_OUT, and A=B_OUT to A<B, A>B, and A=B.  All
       parts which reference this base part will also be affected; 
       for example, the 7485, 54L85, 74LS85, and 74S85.


4.1.2) SYMBOL SIZE/PIN LOCATION CHANGES

       In "abm.slb," the sizes of all of the symbols have changed, 
       and hence most of the pin locations also.  The part names 
       are EFREQ, ELAPLACE, EMULT, ESUM, ETABLE, EVALUE, and the 
       Gxxx equivalents.

       In the digital symbol libraries, the following parts have 
       changed size and/or pin location(s):

             DIG_1.SLB - 148, 150, 157, 158
             DIG_2.SLB - 175, 190
             DIG_3.SLB - 299, 576
             DIG_4.SLB - 757, 842, 874

       Keep in mind that since these are all base parts, any parts 
       which reference these (by way of the AKO mechanism) will also
       be affected, hence requiring you to delete, undelete, and 
       rewire each such part.

4.1.3) MISCELLANEOUS CHANGES TO SYMBOL LIBRARIES

       Several parts have been removed from "analog.slb":  
       D, D3, DCR, DVV, DZ, GAASFETD, GAASFETE, MOSD, MOSE, NJD, 
       NJE, NMOSD, NMOSE, PJD, PJE, PMOSD, PMOSE, QNPN, QPNP, S, 
       SCR, TRIAC, W, XTAL.  These parts all require an associated
       model name, and hence are mostly represented in 
       "breakout.slb," where such parts are kept.  The table below 
       indicates which breakout part should be used in place of the
       "old" part (that used to be in "analog.slb"):

             Old                                New
             ---                                ---

             D, DCR, DVV, DZ                    Dbreak
             D3                                 D3break
             GAASFETD, GAASFETE                 Bbreak
             MOSD,MOSE                           ---
             NJD, NJE                           JbreakN
             NMOSD, NMOSE                       MbreakN, 
	                                        MbreakN3, 
	                                        MbreakN4
             PJD, PJE                           JbreakP
             PMOSD, PMOSE                       MbreakP, 
	                                        MbreakP3, 
	                                        MbreakP4
             QNPN                               QbreakN, 
	                                        QbreakN3, 
	                                        QbreakN4
             QPNP                               QbreakP, 
	                                        QbreakP3, 
                                                QbreakP4
             S                                  Sbreak
             SCR, TRIAC                         (see THYRISTR.SLB 
	                                        for parts)
             W                                  Wbreak
             XTAL                               (see XTAL.SLB
	                                         for parts)

       The YX and ZX parts have been moved from "analog.slb" into 
       "misc.slb."

       In "analog.slb," MAGNETIC has been superseded by Xfrm_Linear.  
       There is also a nonlinear equivalent in "breakout.slb" 
       (Xfrm_Nonlinear), since this symbol requires an associated 
       model name.


4.2)   EUROPEAN SYMBOLS AND COMPONENTS

       The symbol library "europe.slb" contains definitions for a 
       number of European-made devices (diodes, small-signal 
       transistors, and power transistors).  The corresponding model/
       subcircuit definitions for PSpice are contained in model 
       library "europe.lib."

       Note that some of the symbols in "europe.slb" have names 
       identical to some of the symbols in "diode.slb."  In order 
       for Schematics to find the correct symbol definition, you 
       must ensure that the appropriate library is specified first
       in the [SCHEMATICS LIBS] section of "msim.ini."

       If "europe.slb" is specified before another symbol library
       containing duplicate names, none of the duplicate devices
       in the second library will be accessible.  Therefore, since
       D1N4148 and D1N4149 exist in both "europe.slb" and 
       "diode.slb," Schematics would take both the D1N4148 and 
       D1N4149 symbol definitions from "europe.slb" if it is listed 
       before "diode.slb" in the [SCHEMATICS LIBS] section of 
       "msim.ini."  You should ensure that the order of model 
       libraries specified for PSpice in NOM.LIB reflects the order
       of symbol libraries specified in "msim.ini."


5.0)   CREATING NEW PARTS/SYMBOLS

       If the part you want is not in our library, and you do not 
       have a model or subcircuit definition of the part, then one
       will need to be created.  You can
       
       1.  create the definition "manually" if you know, or can 
           generate, the appropriate SPICE model parameters which
           characterize your device (sometimes this can be 
           accomplished by simply copying the .model statement of 
           a device which closely resembles the one you would like 
           to add and editing its parameters appropriately), or you
           can 

       2.  use our Parts program to automatically create the 
           model/subcircuit definition for you, or
             
       3.  contact the part manufacturer and request the SPICE 
           model for the part.  


5.1)   EXAMPLE 1: CREATING A SYMBOL FOR A NEW MODEL

       For this example, let's say you have saved your .model or 
       .suckt statement in a model library called "mydiodes.lib."
       
       Note that model libary files are different from symbol 
       library files.  Model library files typically have .LIB 
       extensions and contain .model and/or .subckt definitions 
       of devices; whereas symbol library files typically have 
       .SLB extensions and contain graphical representations of 
       devices.  Once you have a model/subcircuit definition for 
       your part, you will need to create a symbol which will 
       represent your part on a schematic.  You can use the Symbol
       Editor within Schematics either to create an entirely new 
       symbol, or to reference another symbol as an AKO ("A Kind Of")
       part.

       If you want to create a symbol for a new diode model that you
       have added, you could simply copy the "d" symbol from 
       "diode.slb" into your <new> symbol library, and modify its 
       PART attribute to reflect the name of the diode you have 
       added.  The steps to accomplish this are enumerated below.

       1. File/Edit Library (to invoke the Symbol Editor in 
          Schematics).
          
	  Note that when you first enter the Symbol Editor, your 
          library will be <new> and your part will be <new>, as 
          indicated in the title bar: <new>:<new>.

       2. Part/Copy (New=D1NXXXX; Existing=d from "diode.slb")
            Click on the Select Lib button; double click on DIODE.SLB
            Click on d in part selection box (near bottom)
            Click in the New Part Name field and enter D1NXXXX
            Click on OK to complete the dialog

       3. Part/Attributes (edit the PART attribute to be D1NXXXX)                Click on the PART attribute and change its value to D1NXXXX
            Click on the Save Attr button to save changes
            Click on OK to complete change attribute session

       4. Part/Save (to save the edits locally - optional step)

       5. File/Save (you will be prompted for a name, type: 
          mydiodes.slb)


5.2)   EXAMPLE 2: CREATING A SYMBOL BY DEFINING AN "AKO" PART

       You can also copy "d" from "diode.slb" into your <new> symbol
       library and create a new part which is defined as "A Kind Of" 
       (AKO) d.  The steps to accomplish this are enumerated below.

       1. File/Edit Library (to invoke the Symbol Editor in 
          Schematics)

       2. Part/Copy (New=d; Existing=d from "diode.slb")
            Click on the Select Lib button; double click on DIODE.SLB
            Click once on d in part selection box (near bottom)
            Click in the New Part Name field and enter d
            Click on OK to complete the dialog
       
       3. Part/Save (to save the edits locally - optional step)

       4. File/Save (you will be prompted for a name, type: 
	  mydiodes.slb)

       5. Part/New
            Description: diode
            Part Name: D1NXXXX
            AKO Name: d
            Click on OK to complete the dialog

       6. Part/Attributes (edit the PART attribute to be D1NXXXX)
            Click on the PART attribute and change its value to 
            D1NXXXX
            Click on the Save Attr button to save changes
            Click on OK to complete change attribute session

       7. Part/Save (to save the edits locally - optional step)

       8. File/Save


5.3)   SETTING UP LIBRARY PATHS

       Once you have both the model/subcircuit definition, and the 
       symbol, for your new part, you will need to tell Schematics 
       where to find the appropriate libraries.
       
       Schematics expects to find the symbol libraries in LIBPATH 
       (as specified in the [SCHEMATICS] section of "msim.ini").  
       The symbol libraries that will get loaded into the schematic
       editor are listed in the [SCHEMATICS LIBS] section of 
       "msim.ini" in numerical order.  
       
       LIB1=abm.slb
            .
            .
            .
       LIB31=xtal.slb

       You will need to add your newly-created symbol library, 
       "mydiodes.slb," to this list such that:

       LIB32=mydiodes.slb

       Then, the next time you invoke Schematics, "mydiodes.slb"
       will load along with the other symbol libraries.  This will 
       enable you to select Draw/Get New Part within Schematics and 
       specify D1NXXXX as the part you would like to get.
       
       Assuming you saved the .model definition of your diode in a 
       model library file called "mydiodes.lib," you now need a way
       to tell Schematics where to find this model library file.  
       One way to do this is to simply edit the [SCHEMATICS NETLIST]
       section of "msim.ini" to include a line which refers to 
       "mydiodes.lib":

       LINE1=.lib
       LINE2=.lib "mydiodes.lib"

       Keep in mind that, before invoking Schematics, you must set 
       the PSPICELIB environment variable to indicate the directory
       path containing all of your PSpice model libraries.  
       Additionally, you can indicate the path explicitly in 
       "msim.ini":

       LINE2=.lib "c:\msim\lib\mydiodes.lib"               (PC)
       LINE2=.lib "/home/pspice/sun4/lib/mydiodes.lib"     (Sun)

       There are two other ways to indicate the existence and/or 
       location of a model library file (in this case, 
       "mydiodes.lib").  One is to place a LIB symbol 
       (Draw/Get New Part... LIB) somewhere on your schematic, and 
       edit its FILENAME attribute to be MYDIODES.LIB.  The other 
       is to place an INCLUDE symbol (Draw/Get New Part... INCLUDE)
       somewhere on your schematic, and edit its FILENAME attribute 
       to be MYDIODES.LIB.
       
       Using the INCLUDE symbol causes the netlist simply to include
       the contents of the specified file (in this case, 
       "mydiodes.lib")	in the simulation circuit file.  Using the 
       LIB symbol causes the simulator to treat the specified file 
       as a library and, hence, create an index file for this 
       library.  If any changes are made to this library file, then 
       a new index file will be generated automatically.  Depending 
       on the size of the library file, this could take a while.  
       The simulator uses the index file to find parts quickly, 
       and improves the speed of your simulation.  However, if you 
       change the library often, it might be more efficient to use 
       the INCLUDE symbol.

       Having done all this, you can now invoke Schematics, place 
       a D1NXXXX on your schematic (since Schematics now loads 
       "mydiodes.slb"), and run a simulation (since you have 
       indicated the directory path where "mydiodes.lib" can be
       found).


6.0)   SYMBOL EDITOR TUTORIAL

       A Symbol Editor tutorial has been added to the Genesis User's
       Guide to assist you in using the Symbol Editor.  Both the 
       Symbol Editor and the Schematic Editor tutorials can be found
       in Chapter Four.  

        
7.0)   PRINTER SETUP

       Printer setup information is recorded in the "msim.ini" file 
       for use by Schematics.  If you wish to make hard copies, you
       must set up the printer by invoking File/Printer Setup from 
       within Schematics.  Choosing Printer Setup from the Windows 
       control panel or elsewhere will not set it up for use by 
       Schematics.


8.0)   USING THE 'STMED' PROGRAM WITH 'SCHEMATICS'

       The Stimulus Editor (StmEd) is a DOS program which allows you
       to quickly set up and verify the input waveforms for a 
       transient analysis.  You can create/edit voltage sources, 
       current sources and digital stimuli for your circuit.  Using
       StmEd is an ALTERNATIVE to placing source parts such as VSRC
       on the schematic and editing the attributes that define the 
       transient specification. 

       StmEd will produce a file containing the sources with their
       transient specifications.  Since StmEd is not yet fully 
       integrated with the Schematic Editor, there are some special
       steps you must follow in order to use it with Schematics:

       Within 'SCHEMATICS':

       1)  Connect a global port to the node(s) where the source is
           to be connected.
         
                .  Choose Get Part from the Draw Menu
                .  Enter GLOBAL for the part name
                .  Click OK
                .  Place one or more on the page

       2)  Label each global port.  These labels will serve as 
           node names, specified in StmEd, to which the source 
           is to be connected.  
	     
	        .  Select the port
                .  Choose Label from the Edit Menu
                .  Enter a name
                .  Click OK
    
       3)  Place an INCLUDE part on your schematic.  The stimulus 
           specfications you will be creating in StmEd will be 
           written to a file which will be included in your circuit
           file by this mechanism.  You will only need one of these
           per schematic, independent of the number of sources you 
           will be creating in StmEd.

                .  Choose Get Part from the Draw Menu
                .  Enter INCLUDE for the part name
                .  Click OK
                .  Place the INCLUDE symbol on the page

       4)  Change the FILENAME attribute of the INCLUDE part to 
           indicate the name of the file which will contain your 
           stimulus specifications.  We suggest you name the file 
           "<schematic name>.stm."  Prefix it with the directory in 
           which the schematic is being created: "c:\msim\mycir.stm."
        
                .  Select the INCLUDE part
                .  Choose Attributes from the Edit Menu
                .  Select the FILENAME attribute
                .  Click the CHANGE button
                .  Enter the filename
                .  Click OK to end the Change Attribute dialog
                .  Click OK to return to the schematic
        

       Within the Stimulus Editor:

       1)  When prompted for a file name, enter the file name used 
           in Step 4 above.

       2)  Create one or more stimuli to be used in your schematic.

           For each stimulus,

           a)  name it whatever you want, making sure the first 
	       letter is one of (V,I,U), depending on the type 
	       of source you are creating.

           b)  provide the transient specification as prompted.

           c)  change the connections to the stimulus device 
               to match the name of the global ports in the 
	       schematic where the stimulus is to be connected:

               .  Choose Other_info before exiting the Modify_stimulus 
	          menu
               .  Choose nOdes (or Output_nodes for digital)
               .  Change the node names to match the labels of the 
                  corresponding global ports to which they are to be 
                  connected.  If connected to ground, use "0".
                   
       3)  Save the session by exiting StmEd.

              
