	page	,132
	title	Overlay linkage to Microsoft 'C' tiny model programs.

	.model	tiny,c

;*	OVERLAY LINKING MICROSOFT/BORLAND TINY MODEL PROGRAMS.
;	------------------------------------------------------
;
;	Copyright 1993, Sydex.	All rights reserved.
;
;	Notes:
;
;	    1.	This overlay is written for the assembly by the
;		Microsoft MASM 6.0 assembler.  Other versions of
;		MASM or other vendors' assemblers may require
;		modification of this program.
;
;	    2.	The code in this overlay must be contained in
;		a single segment and created as an absolute overlay
;		origined at 0.	No segment address constants are
;		permitted.
;
;	    3.	The overlay is called by CopyQM/SyDupe in the
;		following manner:
;
;		a.  A far (doubleword) address which points to a
;		    structure used for communication (detailed
;		    below).
;
;		b.  A far CALL is made to this segment, offset 0.
;
;		Any and all registers may be used by this overlay.
;
;	To use this overlay with your Borland or Microsoft 'C' code:
;	------------------------------------------------------------
;
;	1.	Declare your main routine as follows:
;
;		#include "ovpacket.h"
;
;		void OverlayEntry( OVERLAY_PACKET _far *CQP_Packet)
;		{
;			...body of code...
;		}
;
;
;		All static data structures should be initialized.  That is,
;		uninitialized data is not allocated space by CopyQM and
;		attempts to write to uninitialized cells will most likely
;		result in a program crash.
;
;		A statically-allocated stack is set up here.  By default,
;		we make it 2,048 bytes, but this can be changed by re-
;		assembling this code with the value of STATIC_STACK set
;		to a different value.
;
;		You must compile your code OMITTING any stack-limit
;		checking code.	(Microsoft /Gs option).
;
;
;	2.	Link it with this code, using the /T LINK switch, or
;		use EXE2BIN to create a .COM file.
;
;	3.	Rename the executable file to have a .OVR extension.
;
;	You should avoid using 'C' library routines that require the
;	environment set up by the normal 'C' entry code.  These include
;	most stdio.h functions and systems requests.  If you need to do
;	file I/O, use either the I/O primitives (open, close, write, etc.),
;	or direct DOS calls via INT86.	If you end up with a pile of un-
;	defined externals in your LINK map, you'll need to look for what's
;	causing the problem.
;

OVERLAY_PACKET	struc
Drive		db	?		; letter of drive used for copying
SFFlag		db	?		; success/fail/initialize flag:
					;  255 - drive just selected
					;    0 - copy complete; failed
					;    1 - copy complete; success
SerialType	db	?		; serial number type:
					; 0 - ASCII, 1 - Binary
SerialLength	db	?		; length of serial number in bytes
ThisCopy	dw	?		; current number of this copy
TotalCopies	dw	?		; total copies requested
VolumeName	dd	?		; pointer to volume/label name,
					; ASCII with null terminator
SerialNo	dd	?		; pointer to current serial number
DriveAddr	dd	?		; pointer to drive table for this unit
BufferAddr	dd	?		; one-track buffer area for use
					; by this overlay
DiskOpFunction	dd	?		; pointer to disk operation function
					; for use in reading or writing
					; sectors on the current drive
Refresh		db	?		; * if set nonzero on return to CopyQM,
					; * the display is re-painted
DiskFunction	db	?		; * disk function to perform:
					; *   1 = Read sectors into buffer
					; *   2 = Write sectors from buffer
					; *   3 = Verify sectors
DiskStatus	db	?		; status of last disk function
Cylinder	db	?		; * cylinder number for disk functions
Side		db	?		; * side (0 or 1) for disk functions
Sector		db	?		; * starting sector number for function
SectorLength	db	?		; * sector length code: 1 = 256, 2 = 512
Count		db	?		; * count of sectors to transfer
OVERLAY_PACKET	ends

;	Items in the above structure whose comments contain a "*" are
;	cells the overlay code may modify.  All other cells should be
;	left undisturbed.
;
;	A few words are necessary concerning the diskette read, write and
;	verify functions provided by CopyQM.  If diskette accesses are
;	required, they must be performed by means of this interface;
;	using any other method will probably result in a system crash.
;
;	Performing a diskette function is simple.  Just place the
;	Cylinder, Side, Sector, Sector length code and transfer count
;	in the appropriate cells within the overlay packet, then
;	set the DiskFunction byte ( 1 - read, 2 - write, 3 - verify)
;	and issue a far CALL to the routine pointed to by DiskOpFunction.
;	The disk operation will take place using the buffer pointed to
;	by BufferAddr, and the status of the operation will be returned
;	in the DiskStatus byte:
;
;		00h - No error
;		01h - Parameter error
;		02h - Data address mark not found
;		03h - Drive is write-protected
;		04h - Sector not found
;		10h - Data CRC error
;		20h - General failure
;		40h - Seek Error
;		80h - Drive not ready
;

STATIC_STACK	equ	1024		; size, in words of static stack

	.data

Stack_Save	dd	0		; stack pointer save area

	.stack
	dw	STATIC_STACK dup (0)
StackArea	label	word
	.code

	extrn	OverlayEntry:near


	org	0000h

;	At entry, the request pointer is just below the far return address
;	on the stack.  We needn't worry about cleaning the stack up; CQ+
;	will handle that.  What is important here is to get the stack set
;	up, along with a default data segment.

Entry	proc	far
	mov	ax,cs
	mov	ds,ax
	mov	word ptr Stack_Save,sp	; save stack pointer
	mov	word ptr Stack_Save+2,ss
	cli
	lea	sp,StackArea		; establish the stack
	mov	ss,ax
	sti
	mov	bp,sp			; frame our stack
	les	bx,Stack_Save		; back to stack pointer
	push	es:[bx+6]		; push segment of overlay packet
	push	es:[bx+4]		; push offset
	call	OverlayEntry		; call the user routine
 
;	Re-establish the original stack.

	cli
	mov	ss,word ptr Stack_Save+2
	mov	sp,word ptr Stack_Save
	sti
	retf				; exit to CopyQM
Entry	endp

	end	Entry
