	page	,132
	title	OVSAMPLE - CopyQM Plus Overlay Sample

	.model	tiny,syscall

	.code

;*	SAMPLE OVERLAY ILLUSTRATING COPYQM PLUS/SYDUPE LINKAGE
;	------------------------------------------------------
;
;	Copyright 1993, Sydex.	All rights reserved.
;
;	Notes:
;
;	    1.	This overlay is written for the assembly by the
;		Microsoft MASM 6.0 assembler.  Other versions of
;		MASM or other vendors' assemblers may require
;		modification of this program.
;
;	    2.	The code in this overlay must be contained in
;		a single segment and created as an absolute overlay
;		origined at 0.	No segment address constants are
;		permitted.
;
;	    3.	The overlay is called by CopyQM/SyDupe in the
;		following manner:
;
;		a.  A far (doubleword) address which points to a
;		    structure used for communication (detailed
;		    below).
;
;		b.  A far CALL is made to this segment, offset 0.
;
;		Any and all registers may be used by this overlay.
;
;	    4.	This particular overlay produces morse code messages
;		for the operator.
;

OVERLAY_PACKET	struc
Drive		db	?		; letter of drive used for copying
SFFlag		db	?		; success/fail/initialize flag:
					;  255 - drive just selected
					;    0 - copy complete; failed
					;    1 - copy complete; success
SerialType	db	?		; serial number type:
					; 0 - ASCII, 1 - Binary
SerialLength	db	?		; length of serial number in bytes
ThisCopy	dw	?		; current number of this copy
TotalCopies	dw	?		; total copies requested
VolumeName	dd	?		; pointer to volume/label name,
					; ASCII with null terminator
SerialNo	dd	?		; pointer to current serial number
DriveAddr	dd	?		; pointer to drive table for this unit
BufferAddr	dd	?		; one-track buffer area for use
					; by this overlay
DiskOpFunction	dd	?		; pointer to disk operation function
					; for use in reading or writing
					; sectors on the current drive
Refresh		db	?		; * if set nonzero on return to CopyQM,
					; * the display is re-painted
DiskFunction	db	?		; * disk function to perform:
					; *   1 = Read sectors into buffer
					; *   2 = Write sectors from buffer
					; *   3 = Verify sectors
DiskStatus	db	?		; status of last disk function
Cylinder	db	?		; * cylinder number for disk functions
Side		db	?		; * side (0 or 1) for disk functions
Sector		db	?		; * starting sector number for function
SectorLength	db	?		; * sector length code: 1 = 256, 2 = 512
Count		db	?		; * count of sectors to transfer
OVERLAY_PACKET	ends

;	Items in the above structure whose comments contain a "*" are
;	cells the overlay code may modify.  All other cells should be
;	left undisturbed.
;
;	A few words are necessary concerning the diskette read, write and
;	verify functions provided by CopyQM.  If diskette accesses are
;	required, they must be performed by means of this interface;
;	using any other method will probably result in a system crash.
;
;	Performing a diskette function is simple.  Just place the
;	Cylinder, Side, Sector, Sector length code and transfer count
;	in the appropriate cells within the overlay packet, then
;	set the DiskFunction byte ( 1 - read, 2 - write, 3 - verify)
;	and issue a far CALL to the routine pointed to by DiskOpFunction.
;	The disk operation will take place using the buffer pointed to
;	by BufferAddr, and the status of the operation will be returned
;	in the DiskStatus byte:
;
;		00h - No error
;		01h - Parameter error
;		02h - Data address mark not found
;		03h - Drive is write-protected
;		04h - Sector not found
;		10h - Data CRC error
;		20h - General failure
;		40h - Seek Error
;		80h - Drive not ready
;


	assume	ds:nothing, es:nothing, ss:nothing
	org	0000h

	jmp	Main			; OVERLAY IS ENTERED HERE

RequestPtr	dd	?		; pointer to request packet

;	Table of Morse code characters.

mcode	macro	letter,morse
	db	letter			;; what letter
??mlen	sizestr <morse>
	db	??mlen			;; give the length in bits
??mpos	=	1			;; iterate through the string
??macc	=	0			;; bit accumulator
	rept	??mlen
??mchr	substr	<morse>,??mpos,1	;; get a character
%	ifidn	<??mchr>,<->		;; see if a DAH
??macc	=	??macc OR (256 SHR ??mpos)
	endif
??mpos	=	??mpos+1
	endm
	db	??macc			;; 1's are dahs
	endm

MorseTable	label	byte
	mcode	'A',<.->
	mcode	'B',<-...>
	mcode	'C',<-.-.>
	mcode	'D',<-..>
	mcode	'E',<.>
	mcode	'F',<..-.>
	mcode	'G',<--.>
	mcode	'H',<....>
	mcode	'I',<..>
	mcode	'J',<.--->
	mcode	'K',<-.->
	mcode	'L',<.-..>
	mcode	'M',<-->
	mcode	'N',<-.>
	mcode	'O',<--->
	mcode	'P',<.--.>
	mcode	'Q',<--.->
	mcode	'R',<.-.>
	mcode	'S',<...>
	mcode	'T',<->
	mcode	'U',<..->
	mcode	'V',<...->
	mcode	'W',<.-->
	mcode	'X',<-..->
	mcode	'Y',<-.-->
	mcode	'Z',<--..>
	mcode	'0',<----->
	mcode	'1',<.---->
	mcode	'2',<..--->
	mcode	'3',<...-->
	mcode	'4',<....->
	mcode	'5',<.....>
	mcode	'6',<-....>
	mcode	'7',<--...>
	mcode	'8',<---..>
	mcode	'9',<----.>
	db	0			; terminator

;	Morse time constants.

DIT_TICKS	equ	2		; about 55 msec/tick
TONE_FREQ	equ	1330		; a nice medium pitch

Failure_Msg	db	' BAD DISK',0

Success_Msg	db	' GOOD',0

Ready_Msg	db	' READY',0

;*	Main routine to put out messages.
;	---------------------------------
;
;	You could do serial numbers and all sorts of things.
;

Main	proc	far
	mov	bx,sp
	mov	ax,ss:[bx+4]		; get offset
	mov	word ptr cs:RequestPtr,ax
	mov	ax,ss:[bx+6]		; and segment
	mov	word ptr cs:RequestPtr+2,ax	; save the packet address
	lds	bx,cs:RequestPtr
	mov	al,ds:[bx].OVERLAY_PACKET.Drive
	call	MorseChar		; output the drive letter
	lea	si,Ready_Msg
	mov	al,ds:[bx].OVERLAY_PACKET.SFFlag
	test	al,al
	js	Main4			; if just loaded
	lea	si,Success_Msg
	test	al,al
	jnz	Main4
	lea	si,Failure_Msg
Main4:
	call	MorseString		; send the string
Main20:
	retf				; exit to caller
Main	endp



;*	MorseChar - Send a single Morse Character from (AL)
;	===================================================
;
;	(AX) destroyed.
;

MorseChar	proc	near uses si cx
	cmp	al,' '			; space is special case
	je	MorseChar12		; do two dit times
	lea	si,MorseTable
MorseChar2:
	mov	ah,cs:[si]		; get a letter
	test	ah,ah
	jz	MorseChar14		; if end of table, just skip
	cmp	al,ah
	je	MorseChar4		; if got a hit
	inc	si
	inc	si			; skip over letter and code
	inc	si
	jmp	MorseChar2		; loop for next entry

;	Got a hit, fetch and send it.

MorseChar4:
	inc	si
	mov	cx,cs:[si]		; get the length and code
MorseChar6:
	shl	ch,1
	jnc	MorseChar8		; if not dah
	call	Dah			; send a dah
	jmp	short MorseChar10

MorseChar8:
	call	Dit		      ; send a dit
MorseChar10:
	call	Space			; a bit space
	dec	cl
	jnz	MorseChar6		; loop for rest of code
MorseChar12:
	call	Space
	call	Space			; another bit space
MorseChar14:
	ret				; exit
MorseChar	endp

;*	MorseString - Send a string of morse.
;	-------------------------------------
;
;	On entry, (cs:si) = ASCIIZ string.
;

MorseString	proc	near
MorseString2:
	mov	al,cs:[si]
	inc	si
	test	al,al
	jz	MorseString4		; if end of string
	call	MorseChar
	jmp	MorseString2		; loop for next one

MorseString4:
	ret				; exit
MorseString	endp

;*	Dah, Dit and Space - Basic elements of code formation.


Dah	proc	near			; form a 3-dit dah
	push	ax
	call	ToneOn			; turn the tone on
	call	DitTime
	call	DitTime
	call	DitTime			; wait 3 dits
	call	ToneOff			; turn it off
	pop	ax
	ret
Dah	endp

Dit	proc	near			; form a dit
	push	ax
	call	ToneOn			; turn the tone on
	call	DitTime
	call	ToneOff			; turn it off
	pop	ax
	ret
Dit	endp

Space	proc	near			; do a dit space
	push	ax
	call	DitTime
	pop	ax
	ret
Space	endp


;*	DitTime - Time for a Dit.
;	-------------------------
;
;	Delays exactly one dit time.
;	All other timings are derived from this.
;

DitTime		proc	near
	push	es
	sti
	xor	ax,ax
	mov	es,ax
	mov	dx,es:[046ch]		; get the initial count
Tick2:
	mov	ax,es:[46ch]		; get this count
	sub	ax,dx
	cmp	ax,DIT_TICKS		; see if elapsed
	jb	Tick2			; if not
	pop	es
	ret
DitTime		endp


;*	ToneOn - Turn the Tone On.
;	--------------------------
;
;	Paired with "ToneOff".
;

ToneOn		proc	near
	mov	al,0b6h			; timer mode
	out	43h,al			; set it
	mov	ax,TONE_FREQ		; tone frequency
	out	42h,al
	mov	al,ah
	out	42h,al			; set the count
	in	al,61h			; get current port setting
	or	al,03h			; gate speaker on...
	out	61h,al			; do it...
	ret
ToneOn	endp

;*	ToneOff - Turn the Tone off.
;	----------------------------
;
;	De-gates the timer from the speaker.
;

ToneOff		proc	near
	in	al,61h
	and	al,0fch			; degate the speaker
	jmp	ToneOff2
ToneOff2:				; kill some time
	out	61h,al
	ret
ToneOff		endp

	end
