//  Structure of Overlay communication packet used by CopyQM Plus.
//  --------------------------------------------------------------
//
//  For discussion, consult the commentary in OVTOC.ASM.
//

#pragma pack(1)

typedef struct
{
  char Drive;				// drive name
  char SFFlag;				// success/fail
  unsigned char SerialType;		// type of serial number
  unsigned char SerialLength;		// length of serial number
  unsigned int ThisCopy;
  unsigned int TotalCopies;		// copy counters

  char _far *VolumeName;		// volume name
  char _far *SerialNo;			// serial number
  void _far *DriveAddr;			// drive table address
  unsigned char _far *BufAddr;		// track buffer address
  void ( _far *FuncAddr)( void);	// Disk request function address

  unsigned char Refresh;		// if nonzer, refresh display
  unsigned char Function;		// what disk function to do
  unsigned char Status;			// status of disk operation
  unsigned char Cylinder;		// cylinder number
  unsigned char Side;			// side number
  unsigned char Sector;			// sector number
  unsigned char Length;			// length code
  unsigned char Count;			// sector count
} OVERLAY_PACKET;
