/************************************************/
/*  This file uses the INTERSOLV dbase driver   */
/************************************************/
/*
     File:       v2blobs5.CPP
    
    Revision:   2.0 release
    
    Date:       29-Aug-1994

    Author:     Dale Hunscher
    
    Description:

    Studying this QuickWin file will give you insight into BLOB
    handling features in version 2. This module shows "automatic"
    use of odbcBLOB objects (i.e. with automatic binding of columns
    and parameters). It reads the MMBLOBS table (assuming it exists)
    which should have been created by running the V2BLOBS4 sample
    program, which should have put some bitmaps and/or metafiles
    into the database via the Clipboard.

    As this runs, it reads each record in the database, and if it is
    either a bitmap or metafile, it retrieves the object and puts
    it in the Clipboard.  During the getchar() call between each
    read from the database, you can use the Clipboard viewer, Clipbook,
    or Paintbrush to see what is in the Clipboard from the database.


    
    /////////////////////////////////////////////////////////////
    ///////////////////// NOTICE ////////////////////////////////
    /////////////////////////////////////////////////////////////

    Copyright (c) 1994 by INTERSOLV, Inc. All rights reserved.
    
    Information in this document is subject to change without
    notice and does not represent a commitment on the part of
    INTERSOLV, Inc. This software is provided under
    a license agreement or non-disclosure agreement. The software
    may be used and/or copied only in accordance with the terms
    of the governing agreement. It is against the law to copy
    the software on any medium except as specifically allowed
    in the governing agreement. No part of this software may be 
    reproduced or transmitted in any form or by any means, 
    electronic or mechanical, including photocopying, recording,
    or information storage and retrieval systems, for any purpose
    other than the licensee's personal use, without the express
    written permission of INTERSOLV, Inc.
    
    /////////////////////////////////////////////////////////////
*/
#define VERBOSE

#include <sql.hpp>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include <malloc.h>

#include <windows.h>

#define SIZEOF_BINARY  135000L

// odbcBLOB items


typedef struct {
    double dKeyField;
    podbcBLOB pBlob;
    } sMMBLOBS;

// sCOLBIND array definition

static sCOLBIND QueryResultSet[] = 
{
{ 	1,
	SQL_C_DOUBLE,
	FIELDOFFSET( sMMBLOBS, dKeyField ),
	8,
	0,
	FALSE,
	"KEYFIELD",
	SQL_NUMERIC,
	0,
	0,
	NULL,
},
{ 	2,
	SQL_C_BINARY,
	FIELDOFFSET( sMMBLOBS, pBlob ),
	135000L,
	0,
	FALSE,
	"BLOB",
	SQL_LONGVARBINARY,
	0,
	0,
	NULL,
},
};
const int QueryResultSetCount
	= sizeof(QueryResultSet) / sizeof(QueryResultSet[ 0 ]);


#if defined( WIN32 )
// this error routine will be called automatically when 
// an error occurs (see odbcbase.hpp for details).
void CALLBACK PrintErr(
    RETCODE         lastRet,
    UCHAR FAR *     szSqlState,
    SDWORD          fNativeError,
    UCHAR FAR *     szErrorMsg,
    odbcBASE FAR *  pObj
    )
    {
    char buf[ 80 ];

    MessageBeep( MB_ICONEXCLAMATION );
    fprintf( stderr, "Ret: %ld\nMsg: %s\nSQL: %s\n Nat: %ld\n\n"
    			"Press Enter to continue...\n",
                lastRet,
                (LPSTR)szErrorMsg,
                (LPSTR)szSqlState,
                fNativeError);
                
    gets(buf);
    }

#endif

void main(int , char *[])
    {
    // instantiate an environment.  This allocates
	// an ODBC environment handle for the app.
	odbcENV env;

	//buffer for input
    char buf[ 80 ];

	// useful huge ptr
	HBITMAP hBitmap = NULL;

	// for DriverConnectPrompt
	static char szConnBuf[ 512 ];

	// structure for making records for insertion into table.
	sMMBLOBS sTestV2;

	// temp pointer for BLOBs
	podbcBLOB pBlob = NULL;

	// cursor object pointer
	podbcCURSOR pCursor = NULL;

	// for getting metafiles from Blob and storing in clipboard
	HGLOBAL hGMemMFP;
	METAFILEPICT* pMFP;

	env.AutoRetrieve(odbcREPSUCCESSWITHINFO);
    env.AutoReport(odbcREPERRS);
#if !defined( WIN32 )
    env.SetWnd( GetActiveWindow()) ;
#else
	env.SetErrHandler( PrintErr ) ;
#endif

	// enable cursor library in connections if it's needed.
	env.nCursorLibUsage = SQL_CUR_USE_IF_NEEDED;

	if (env.sqlsuccess())
	    {
		// prepare to connect to sample data source
		odbcCONNECT connect(&env);

		fprintf( stderr, "\nConnecting\n" );

        connect.Connect(
               "dBASEFile",
               "",
               ""
               );

		if (connect.sqlsuccess())
		    {
			// create a cursor
			pCursor
				 = new odbcCURSOR(&connect);

			pCursor->ExecDirect( "SELECT * FROM MMBLOBS" );
			if ( !pCursor->sqlsuccess())
				 {
				 fprintf( stderr, "\nExecDirect() failed.\n");
				 goto bypass;
				 }

			// bind columns using BindCol() with a data dictionary.
			pCursor->SetColBindings(
							QueryResultSet,
							QueryResultSetCount,
							&sTestV2
							);

			pCursor->BindCol();

			if ( !pCursor->sqlsuccess())
				 {
				 fprintf( stderr, "\nBindCol() failed.\n");
				 goto bypass;
				 }

			for ( pCursor->Fetch(); pCursor->sqlsuccess(); pCursor->Fetch() )
			    {
				pBlob = sTestV2.pBlob;
				if ( !pBlob)
				    {
					fprintf( stderr, "\nBlob expected but not found.\n");
					}
                else
					{
                    OpenClipboard( GetActiveWindow() );
                    EmptyClipboard();

			    	if (pBlob->HasFormat( FMT_BITMAP ))
			            {
						pBlob->GetBitmapFromBlob( &hBitmap );
						SetClipboardData( CF_BITMAP, hBitmap );
						fprintf( stderr, "\nRetrieved Bitmap record - any key to continue");
                		CloseClipboard();
                        Yield();
                        getchar();
					    continue;
						}

					else if (pBlob->HasFormat( FMT_METAFILEPICT ))
					    {
						hGMemMFP = GlobalAlloc(GHND, sizeof(METAFILEPICT));
						pMFP = (METAFILEPICT*) GlobalLock( hGMemMFP );
						pBlob->GetMetaFilePictFromBlob( pMFP );
						GlobalUnlock( hGMemMFP );
						SetClipboardData( CF_METAFILEPICT, hGMemMFP );
						fprintf( stderr, "\nRetrieved Metafile record - any key to continue");
                		CloseClipboard();
                        Yield();
                        getchar();
						continue;
						}
                    } // else if ( !pBlob)
                } // end for ( pCursor->Fetch(); pCursor->sqlsuccess(); . . .

            // commit
			connect.Commit();

bypass:
			; // Microsoft VC++ is unhappy without at least
              // an empty statement here.

				// cursor object will be freed as it goes out of
				// scope on this next closing brace.

			} // end if (connect.sqlsuccess())

			else
				{
				fprintf( stderr, "\nCould not connect!\n" );
				gets( buf );
				}

			// disconnection occurs in the connect destructor,
			// and so is the freeing of the connection handle

        } // if (env.sqlsuccess())

    fprintf( stderr, "\nExecution complete!\n" );
	}
