/************************************************/
/*  This file uses the INTERSOLV dBASE driver.  */
/************************************************/
/*
     File:       v2blobs3.CPP
    
    Revision:   2.0 release
    
    Date:       29-Aug-1994

    Author:     Dale Hunscher
    
    Description:

    Studying this QuickWin file will give you insight into BLOB
    handling features in version 2. This module shows "automatic"
    use of odbcBLOB objects (i.e. with automatic binding of columns
    and parameters).
    
    /////////////////////////////////////////////////////////////
    ///////////////////// NOTICE ////////////////////////////////
    /////////////////////////////////////////////////////////////

    Copyright (c) 1994 by INTERSOLV, Inc. All rights reserved.

    Information in this document is subject to change without
    notice and does not represent a commitment on the part of
    INTERSOLV, Inc. This software is provided under
    a license agreement or non-disclosure agreement. The software
    may be used and/or copied only in accordance with the terms
    of the governing agreement. It is against the law to copy
    the software on any medium except as specifically allowed
    in the governing agreement. No part of this software may be 
    reproduced or transmitted in any form or by any means, 
    electronic or mechanical, including photocopying, recording,
    or information storage and retrieval systems, for any purpose
    other than the licensee's personal use, without the express
    written permission of INTERSOLV, Inc.
    
    /////////////////////////////////////////////////////////////
*/
/*
    Basics of BLOB usage with AutoBind()
    ------------------------------------

    If a table contains a column of type SQL_LONGVARCHAR or
    SQL_LONGVARBINARY, AutoBind() will treat these columns
    as BLOBs and will allocate an odbcBLOB object for handling
    the BLOB. An odbcINSERTER object also allocates a BLOB
    in its rowset as part of the construction.

    The BLOB can be accessed using one of the ColResultAsBLOB
    variations, which work like all the other ColResultAsxxxx
    functions.  <<Never delete an odbcBLOB object created by
    AutoBind() on your own!>> The BLOB objects are destroyed
    as part of normal FreeColBindings() processing.

    You can also retrieve the record using MoveRowsetRowToRecord
    and access the BLOB pointer in the resultant structure. If
    you copy the structure, don't forget that the BLOB was created
    by AutoBind() and will be poisoned after any action is taken
    that will change the column bindings, including closing the
    cursor or destroying it.

    Using the BLOB object
    ---------------------

    Once a SELECT statement is executed and Fetch() or an ExtFetchxxx
    variant called, the BLOB contains any data stored in the columns.
    (Note that it is inadvisable to have big rowsets containing BLOBs
    if the BLOB columns contain big chunks of data, since the fetch
    will bring all the BLOBs in the rowset into memory.)

    Once data is in the BLOB and you have a pointer to the data, use
    the BLOB's GetMem member function to obtain access to a void huge
    pointer to the data (Under 32-bit the pointer is just a void *).
    Call GetMem() with no argument or a zero argument to get the
    current pointer.

    To change the BLOB's contents before updating, resize the
    BLOB and obtain a pointer to the resized memory by calling
    GetMem() with the new size (unsigned long) as the argument.
    Copy the new content into the allocated memory through the
    pointer. Remember in the 16-bit world that the pointer is
    a HUGE pointer; for loops with byte-by-byte copying are the
    safe method of transferring data.

    During Execute and ExecDirect, if BLOBs are bound and
    an INSERT or UPDATE is performed, the BLOB's pointer
    is retrieved and used to put the data. On odbcRECINSERTER
    and odbcRECUPDATER operations, parm binding occurs automatically;
    if using the BLOB manually you will have to call its BindParameter()
    function at the same time you are binding other parameters for
    inserting or updating data.

    odbcBLOB Error Handling
    -----------------------

    All errors that occur on a cursor are registered on that cursor.

    If memory allocation errors occur on the BLOB, the error will be
    registered on the owning cursor object. (If there are
    separate get and put cursors, as when performing positioned
    updates, the error is registered on both cursors.)

*/
#define VERBOSE

#include <sql.hpp>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include <malloc.h>

#include <windows.h>

#define SIZEOF_BINARY  135000L

// odbcBLOB items


typedef struct {
    double dKeyField;
    podbcBLOB pBlob;
    } sBLOBS;

static char szStmtOut[ 5000 ] ;

// sCOLBIND array definition

static sCOLBIND QueryResultSet[] = 
{
{ 	1,
	SQL_C_DOUBLE,
	FIELDOFFSET( sBLOBS, dKeyField ),
	8,
	0,
	FALSE,
	"KEYFIELD",
	SQL_NUMERIC,
	0,
	0,
	NULL,
},
{ 	2,
	SQL_C_BINARY,
	FIELDOFFSET( sBLOBS, pBlob ),
	135000L,
	0,
	FALSE,
	"BLOB",
	SQL_LONGVARBINARY,
	0,
	0,
	NULL,
},
};
const int QueryResultSetCount
	= sizeof(QueryResultSet) / sizeof(QueryResultSet[ 0 ]);


BOOL CreateATable( podbcCONNECT pConnect )
    {
    char *szStmtIn = "CREATE TABLE BLOBS (\n"
                    "\tKEYFIELD <NUMERIC(12,0)>,\n"
                    "\tBLOB <LONGVARBINARY(135000)>)\n\n";
    UWORD uStmtSize = sizeof(szStmtOut);

    // create a table-creator
    podbcTABLECREATOR pCreator
        = new odbcTABLECREATOR(pConnect);

    if ( !pCreator )
        return FALSE;

    else
        {
        if ( !pCreator->sqlsuccess())
            {
            pCreator->Report();
            delete pCreator;
            return FALSE;
            }
        }

    // drop table if it already exists
    pCreator->ExecDirect("DROP TABLE BLOBS");

    if ( pCreator->sqlsuccess())
        pCreator->Close();
        
    // automatically retrieve error info when return code
    // is SQL_ERROR or SQL_SUCCESS_WITH_INFO
    pCreator->AutoRetrieve(odbcREPSUCCESSWITHINFO);
    pCreator->AutoReport(odbcREPSUCCESSWITHINFO);

    // create a table
    pCreator->CreateTable
                (
                szStmtIn,
                szStmtOut,
                &uStmtSize,
                FALSE // actually create a table this time.
                );

#if defined(VERBOSE)
    fprintf(stderr, "\ncreate table statement:\n'%s'\n", szStmtOut);
#endif
    // if we failed, we already reported; just get out.
    if ( !pCreator->sqlsuccess())
        {
        // delete the table creator
        delete pCreator;
        pCreator = NULL;
        fprintf(stderr, "\nCreate table failed.\n");
        return FALSE;
        }
    else
        fprintf(stderr, "\nCreate table succeeded.\n");

    // drop table if it already exists
    pCreator->ExecDirect("CREATE UNIQUE INDEX BLOBS ON BLOBS"
                        "(KEYFIELD)");

    // if we failed to create an index, note and continue on.
    if ( !pCreator->sqlsuccess())
        fprintf(stderr, "\nCreate index failed.\n");
    else
        fprintf(stderr, "\nCreate index succeeded.\n");

    // delete the table creator
    delete pCreator;
    pCreator = NULL;
    return TRUE;
    }
#if defined( WIN32 )
// this error routine will be called automatically when 
// an error occurs (see odbcbase.hpp for details).
void CALLBACK PrintErr(
    RETCODE         lastRet,
    UCHAR FAR *     szSqlState,
    SDWORD          fNativeError,
    UCHAR FAR *     szErrorMsg,
    odbcBASE FAR *  pObj
    )
    {
    char buf[ 80 ];

    MessageBeep( MB_ICONEXCLAMATION	);
    fprintf( stderr, "Ret: %ld\nMsg: %s\nSQL: %s\n Nat: %ld\n\n"
    			"Press Enter to continue...\n",
                lastRet,
                (LPSTR)szErrorMsg,
                (LPSTR)szSqlState,
                fNativeError);
                
    gets(buf);
    }

#endif
void main(int , char *[])
    {
    // instantiate an environment.  This allocates
    // an ODBC environment handle for the app.
    odbcENV env;

	//buffer for input
    char buf[ 80 ];

    // for loop index
    long i, j;

    // longs for record IDs
    long l, lKey;

    // useful huge ptr
    char HUGE *pData = NULL;

    // for DriverConnectPrompt
    static char szConnBuf[ 512 ];

    // structure for making records for insertion into table.
    sBLOBS sTestV2;

    // temp pointer for BLOBs
    podbcBLOB pBlob = NULL;

    // character for loop
    char ch1;

    // for MoveRowsetRowToRecord
    size_t uBytesCopied;

    // cursor object pointer
    podbcCURSOR pCursor = NULL;

    // inserter
    podbcRECINSERTER pInserter = NULL;

    // updater object pointer
    podbcRECUPDATER pUpdater = NULL;

    // for saving SQL type of our key field, for BindParameter
    SWORD fSqlType;

    BOOL bKeysetsSupported = FALSE;
    UDWORD ScrollOptions = 0;

    env.AutoRetrieve(odbcREPSUCCESSWITHINFO);
    env.AutoReport(odbcREPERRS);
#if !defined( WIN32 )
    env.SetWnd( GetActiveWindow()) ;
#else
	env.SetErrHandler( PrintErr ) ;
#endif
    // enable cursor library in connections if it's needed.
    env.nCursorLibUsage = SQL_CUR_USE_IF_NEEDED;

    if (env.sqlsuccess())
        {
        // prepare to connect to sample data source
        odbcCONNECT connect(&env);

#if defined(VERBOSE)
        fprintf(stderr, "\nConnecting ");
#endif
        connect.Connect(
               "dBASEFile",
               "",
               "");

        if (connect.sqlsuccess())
            {

            if ( !CreateATable(&connect))
                {
                fprintf( stderr, "\nCreateTable failed.\n");
                goto bypass;
                }

            // creater inserter
            pInserter = new odbcRECINSERTER
                                (
                                &connect,
                                "BLOBS"
                                );

            if ( !pInserter || !pInserter->sqlsuccess())
                {
                fprintf( stderr, "\ninserter constructor or allocation failed.\n");
                goto bypass;
                }

            // save SQL type of KEYFIELD column for later use.
            fSqlType = pInserter->ColResultInfo("KEYFIELD")->fSqlType;


            // now set up a loop to insert 5 records
            for ( l = 1, ch1 = 'a';
                    pInserter->sqlsuccess() && l <= 5;
                    l++, ch1++ )
                {
                pInserter->MoveRowsetRowToRecord(
                        1,
                        &sTestV2,
                        sizeof(sTestV2),
                        &uBytesCopied );

                // set up key field
                sTestV2.dKeyField = (double)l;

                pData = (char HUGE *)sTestV2.pBlob->GetMem( SIZEOF_BINARY );

                if ( !pData )
                    {
                    fprintf( stderr, "\nmemory allocation failed.\n");
                    goto bypass;
                    }

                // fill array with character for this record
                for ( i = 0; i < SIZEOF_BINARY; i++)
                    pData[ i ] = ch1;

                pInserter->InsertRecord(
                        &sTestV2,           // rec address
                        sizeof(sTestV2)     // rec size
                        );

                if ( pInserter->sqlsuccess())
                    {
#if defined(VERBOSE)
                    fprintf( stderr, "\nInserted record "
                                    "for key #%f...",
                        sTestV2.dKeyField
                        );
#endif
                    pInserter->Close();
                    }
                } // end for loop on insertions

            if ( !pInserter->sqlsuccess())
                {
#if defined(VERBOSE)
                fprintf( stderr, "\nInsert failed.\n");
#endif
                goto bypass;
                }

            delete pInserter;

            // create a cursor
            pCursor
                = new odbcCURSOR(&connect);

            pCursor->ExecDirect( "SELECT * FROM BLOBS" );
            if ( !pCursor->sqlsuccess())
                {
                fprintf( stderr, "\nExecDirect() failed.\n");
                goto bypass;
                }

            // bind columns using AutoBind().
            pCursor->AutoBind();
            if ( !pCursor->sqlsuccess())
                {
                fprintf( stderr, "\nAutoBind() failed.\n");
                goto bypass;
                }

            for ( pCursor->Fetch(); pCursor->sqlsuccess(); pCursor->Fetch() )
                {
                pBlob = pCursor->ColResultAsBLOB("BLOB");
                if ( !pBlob)
                    break;
                else
                    pData = (char HUGE *)pBlob->GetMem();

                fprintf( stderr, "\nRetrieved record "
                                "for %10.10s (%f)...",
                    !pData ?
                        "?" :
                        (char *)pData,
                    pCursor->ColResultAsDouble("KEYFIELD")
                    );
                }

            // now let's do some random updates
            pCursor->Close();
            pCursor->Unbind();
            pCursor->ResetParams();

            connect.GetInfo( SQL_SCROLL_OPTIONS,
                            &ScrollOptions,
                            sizeof( UDWORD ),
                            NULL );

            bKeysetsSupported = ( ScrollOptions & SQL_SO_KEYSET_DRIVEN );
            
            if ( connect.PosStmtSupport() )
                {
                pUpdater = new odbcRECUPDATER(
                                &connect,
                                "BLOBS",
                                "SELECT * FROM BLOBS "
                                  "WHERE KEYFIELD = ? "
                                  "FOR UPDATE OF BLOB",
                                NULL, //
                                0,    /////// not using data dictionary
                                NULL, //
                                FALSE,// prepare, don't exec direct
                                SQL_CONCUR_VALUES,
                                bKeysetsSupported ?
                                    SQL_CURSOR_KEYSET_DRIVEN :
                                    SQL_CURSOR_STATIC
                                );
                }
            else
                {
                pUpdater = new odbcRECUPDATER(
                                &connect,
                                "BLOBS",
                                "SELECT * FROM BLOBS "
                                  "WHERE KEYFIELD = ? ",
                                NULL, //
                                0,    /////// not using data dictionary
                                NULL, //
                                FALSE, // prepare, don't exec direct
                                SQL_CONCUR_VALUES,
                                bKeysetsSupported ?
                                    SQL_CURSOR_KEYSET_DRIVEN :
                                    SQL_CURSOR_STATIC
                                );
                }

            if ( !pUpdater || !pUpdater->sqlsuccess())
                {
                fprintf( stderr, "\nupdater constructor or allocation failed.\n");
                goto bypass;
                }

            // bind the key field parameter
            pUpdater->BindParameter(
                    1,              // col number
                    SQL_PARAM_INPUT,// parm bind type - input only
                    SQL_C_LONG,     // C type of our storage location
                    fSqlType,       // SQL type of the column
                    12,              // precision and scale are
                    0,              // not used for integral types
                    &lKey,          // address of our storage location
                    0,              // max length
                    NULL            // address of actual length buffer,
                                    //  which could also be used to
                                    //  indicate NULL data or data to
                                    //  be provided at execution time.
                                    //  left NULL, since the length is
                                    //  fixed and the data is not NULL.
                    );

            if ( !pUpdater->sqlsuccess())
                {
                fprintf( stderr, "\nBindParameter() failed.\n");
                goto bypass;
                }

            // do a couple of random updates
            for ( i = 0, ch1 = 'x'; pUpdater->sqlsuccess() && i < 2; i++, ch1++ )
                {
                // generate a random number
                lKey = (long)(rand() % 5) + 1;

                // execute
                pUpdater->Execute();

                if ( pUpdater->sqlsuccess())
                    {
                    pUpdater->ExtFetchFirst(); // first and only
                    }

                if ( pUpdater->sqlsuccess())
                    {
                    // get record from rowset row
                    pUpdater->MoveRowsetRowToRecord( 1,
                        &sTestV2,
                        sizeof(sTestV2),
                        &uBytesCopied );

                    }

                if ( pUpdater->sqlsuccess())
                    {
#if defined(VERBOSE)
                    fprintf( stderr, "\nRetrieved record "
                                    "for #%f...",
                        sTestV2.dKeyField
                        );
#endif

                    pData = (char HUGE *)sTestV2.pBlob->GetMem();

                    if ( !pData )
                        {
                        fprintf( stderr, "\nBLOB has no content.\n");
                        break;
                        }
                    else
                        l = sTestV2.pBlob->GetcbValue();

                    if ( l <= 0 )
                        {
                        fprintf( stderr, "\nBLOB has no content.\n");
                        break;
                        }

                    // fill array with character for this record
                    for ( j = 0; j < l; j++)
                        pData[ j ] = ch1;

#if defined(VERBOSE)
                    // update
                    fprintf( stderr, "\nNew value is "
                                    "are %10.10s (%f).",
                        (char *)pData,
                        sTestV2.dKeyField
                        );
#endif
                    pUpdater->UpdateRecord(
                            1,
                            &sTestV2,
                            sizeof(sTestV2)
                            );

                    // a result set was obtained and has been
                    // updated.  Close() must be called before
                    // another query can be executed.
                    
                    if ( pUpdater->sqlsuccess())
                        pUpdater->Close();
                    } // end if
                } // end for loop

            // now let's look at it again
            delete pUpdater;
            pCursor->Close();
            pCursor->Unbind();
            pCursor->ResetParams();

            pCursor->ExecDirect( "SELECT * FROM BLOBS" );
            if ( !pCursor->sqlsuccess())
                {
                fprintf( stderr, "\nExecDirect() failed.\n");
                goto bypass;
                }

            // bind columns using BindCol() with a data dictionary.
            pCursor->SetColBindings(
                        QueryResultSet,
                        QueryResultSetCount,
                        &sTestV2
                        );

            pCursor->BindCol();
            
            if ( !pCursor->sqlsuccess())
                {
                fprintf( stderr, "\nBindCol() failed.\n");
                goto bypass;
                }

            for ( pCursor->Fetch(); pCursor->sqlsuccess(); pCursor->Fetch() )
                {
                pBlob = sTestV2.pBlob;
                if ( !pBlob)
                    {
                    fprintf( stderr, "\nBlob expected but not found.\n");
                    continue;
                    }
                else
                    pData = (char HUGE *)pBlob->GetMem();

                fprintf( stderr, "\nRetrieved record "
                                "for %10.10s (%f)...",
                    !pData ?
                        "?" :
                        (char *)pData,
                    sTestV2.dKeyField
                    );
                }

            // commit
            connect.Commit();
            
bypass:
            // cursor object will be freed as it goes out of
            // scope on this next closing brace.

            ; // Microsoft VC++ is unhappy without an empty statement here.

            } // end if (connect.sqlsuccess())

			else
				{
				fprintf( stderr, "\nCould not connect!\n" );
				gets( buf );
				}

            // disconnection occurs in the connect destructor,
            // and so is the freeing of the connection handle

        } // if (env.sqlsuccess())

    fprintf( stderr, "\nExecution complete!\n" );
    }
