/************************************************/
/*  This file uses the INTERSOLV dBASE driver.  */
/************************************************/
/*
    File:       v2blobs1.CPP
    
    Revision:   2.0 release
    
    Date:       29-Aug-1994

    Author:     Dale Hunscher
    
    Description:

    Studying this QuickWin file will give you insight into BLOB
    handling features in version 2. This version shows how the
    GetData and PutData calls are done "manually" (i.e., without
    use of an odbcBLOB object).
    
    /////////////////////////////////////////////////////////////
    ///////////////////// NOTICE ////////////////////////////////
    /////////////////////////////////////////////////////////////
                                                                     
    Copyright (c) 1994 by INTERSOLV, Inc. All rights reserved.

    Information in this document is subject to change without
    notice and does not represent a commitment on the part of
    INTERSOLV, Inc. This software is provided under
    a license agreement or non-disclosure agreement. The software
    may be used and/or copied only in accordance with the terms
    of the governing agreement. It is against the law to copy
    the software on any medium except as specifically allowed
    in the governing agreement. No part of this software may be 
    reproduced or transmitted in any form or by any means, 
    electronic or mechanical, including photocopying, recording,
    or information storage and retrieval systems, for any purpose
    other than the licensee's personal use, without the express
    written permission of INTERSOLV, Inc.
    
    /////////////////////////////////////////////////////////////
*/

#define VERBOSE

#include <sql.hpp>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include <malloc.h>

#include <windows.h>

#define SIZEOF_BINARY  135000L

// odbcBLOB items
#if !defined( WIN32 )
	typedef void huge * HPTR;
#else
	typedef void * HPTR;
#endif
#define BLOB_CHUNK_PUT_SIZE 65536L
#define BLOB_CHUNK_GET_SIZE 32768L


typedef struct {
    double dKeyField;
#if !defined( WIN32 )
    char huge *pData;
#else
	char *pData;
#endif
    } sBLOBS;

static char szStmtOut[ 5000 ] ;

// sCOLBIND array definition

static sCOLBIND QueryResultSet[] = 
{
{ 	1,
	SQL_C_DOUBLE,
	FIELDOFFSET( sBLOBS, dKeyField ),
	8,
	0,
	FALSE,
	"KEYFIELD",
	SQL_NUMERIC,
	4,
	1,
	NULL,
},
};
const int QueryResultSetCount
	= sizeof(QueryResultSet) / sizeof(QueryResultSet[ 0 ]);


BOOL CreateATable( podbcCONNECT pConnect )
    {
    char *szStmtIn = "CREATE TABLE BLOBS (\n"
                    "\tKEYFIELD <NUMERIC(12,0)>,\n"
                    "\tBLOB <LONGVARBINARY(135000)>)\n\n";
    UWORD uStmtSize = sizeof(szStmtOut);

    // create a table-creator
    podbcTABLECREATOR pCreator
        = new odbcTABLECREATOR(pConnect);

    if ( !pCreator )
        return FALSE;

    else
        {
        // set window in case we need to report
        pCreator->SetWnd(GetActiveWindow());

        if ( !pCreator->sqlsuccess())
            {
            pCreator->Report();
            delete pCreator;
            return FALSE;
            }
        }

    // drop table if it already exists
    pCreator->ExecDirect("DROP TABLE BLOBS");

    if ( pCreator->sqlsuccess())
        pCreator->Close();
        
    // automatically retrieve error info when return code
    // is SQL_ERROR or SQL_SUCCESS_WITH_INFO
    pCreator->AutoRetrieve(odbcREPSUCCESSWITHINFO);
    pCreator->AutoReport(odbcREPSUCCESSWITHINFO);

    // create a table
    pCreator->CreateTable
                (
                szStmtIn,
                szStmtOut,
                &uStmtSize,
                FALSE // actually create a table this time.
                );

#if defined(VERBOSE)
    fprintf(stderr, "\ncreate table statement:\n'%s'\n", szStmtOut);
#endif
    // if we failed, we already reported; just get out.
    if ( !pCreator->sqlsuccess())
        {
        // delete the table creator
        delete pCreator;
        pCreator = NULL;
        fprintf(stderr, "\nCreate table failed.\n");
        return FALSE;
        }
    else
        fprintf(stderr, "\nCreate table succeeded.\n");

    // drop table if it already exists
    pCreator->ExecDirect("CREATE UNIQUE INDEX BLOBS ON BLOBS"
                        "(KEYFIELD)");

    // if we failed to create an index, note and continue on.
    if ( !pCreator->sqlsuccess())
        fprintf(stderr, "\nCreate index failed.\n");
    else
        fprintf(stderr, "\nCreate index succeeded.\n");

    // delete the table creator
    delete pCreator;
    pCreator = NULL;
    return TRUE;
    }

#if defined( WIN32 )
// this error routine will be called automatically when 
// an error occurs (see odbcbase.hpp for details).
void CALLBACK PrintErr(
    RETCODE         lastRet,
    UCHAR FAR *     szSqlState,
    SDWORD          fNativeError,
    UCHAR FAR *     szErrorMsg,
    odbcBASE FAR *  pObj
    )
    {
    char buf[ 80 ];

    MessageBeep( MB_ICONEXCLAMATION );
    fprintf( stderr, "Ret: %ld\nMsg: %s\nSQL: %s\n Nat: %ld\n\n"
    			"Press Enter to continue...\n",
                lastRet,
                (LPSTR)szErrorMsg,
                (LPSTR)szSqlState,
                fNativeError);
                
    gets(buf);
    }

#endif


void main(int , char *[])
    {
    // instantiate an environment.  This allocates
    // an ODBC environment handle for the app.
    odbcENV env;

    // for loop index
    long i;

    // longs for record IDs
    long l, lKey;

    // for return from ParamData
    PTR pRet;

    // for BLOB output and input
    SDWORD cbValue, cbRemaining;

    char c[1];  // for placeholder purposes in GetData call
                // to get data length.

    // for DriverConnectPrompt
    static char szConnBuf[ 512 ];

    // structure for making records for insertion into table.
    sBLOBS sTestV2;

    // character for loop
    char ch1;

    // for return from GetInfoString
    char szValue[ 5 ];
    SWORD iValueReturned;

    // return code
    RETCODE ret;

    // save auto report value
    BOOL bSaveAutoReport;

    // cursor object pointer
    podbcCURSOR pCursor = NULL;

    // allocate some huge memory
#if !defined( WIN32 )
    sTestV2.pData = (char huge *)halloc( SIZEOF_BINARY, 1 );
#else
	sTestV2.pData = halloc( SIZEOF_BINARY, 1 );
#endif
    env.AutoRetrieve(odbcREPSUCCESSWITHINFO);
    env.AutoReport(odbcREPSUCCESSWITHINFO);
#if !defined( WIN32 )
    env.SetWnd( GetActiveWindow()) ;
#else
	env.SetErrHandler( PrintErr ) ;
#endif

    // enable cursor library in connections if it's needed.
    env.nCursorLibUsage = SQL_CUR_USE_IF_NEEDED;

    if (env.sqlsuccess())
        {
        // prepare to connect to sample data source
        odbcCONNECT connect(&env);

        if ( sTestV2.pData == NULL )
            {
            fprintf( stderr, "\nHuge memory allocation failed.\n");
            goto bypass;
            }

        // make library collect and report error info automatically.
        // this is handled by odbcBASE class.

        connect.AutoRetrieve(odbcREPSUCCESSWITHINFO);
        connect.AutoReport(odbcREPSUCCESSWITHINFO);
        connect.SetWnd( GetActiveWindow());

#if defined(VERBOSE)
        fprintf(stderr, "\nConnecting ");
#endif
        connect.Connect(
                        "dBASEFile",
                        "",
               			"");

        if (connect.sqlsuccess())
            {

            if ( !CreateATable(&connect))
                {
                    fprintf( stderr, "\nCreateTable failed.\n");
                    goto bypass;
                }
            // create a cursor
            pCursor
                = new odbcCURSOR(&connect);

            // automatically retrieve error info when return code
            // is SQL_ERROR or SQL_SUCCESS_WITH_INFO

            pCursor->AutoRetrieve( odbcREPSUCCESSWITHINFO );
            pCursor->AutoReport( odbcREPERRS );
            pCursor->SetWnd(GetActiveWindow());

            // bind the key field parameter
            pCursor->BindParameter(
                    1,              // col number
                    SQL_PARAM_INPUT,// parm bind type - input only
                    SQL_C_LONG,     // C type of our storage location
                    SQL_NUMERIC,    // SQL type of the column
                    12,              // precision and scale are
                    0,              // not used for integral types
                    &lKey,          // address of our storage location
                    0,              // max length
                    NULL            // address of actual length buffer,
                                    //  which could also be used to
                                    //  indicate NULL data or data to
                                    //  be provided at execution time.
                                    //  left NULL, since the length is
                                    //  fixed and the data is not NULL.
                    );

            if ( !pCursor->sqlsuccess())
                {
                    fprintf( stderr, "\nBinding 1st parameter failed.\n");
                    goto bypass;
                }

            // bind the BLOB parameter
            cbValue = SQL_DATA_AT_EXEC;

            // don't have error reporting temporarily...
            bSaveAutoReport = connect.AutoReport( odbcNOREPORT );

            // if the driver doesn't have to have the data length up
            // front, use SQL_DATA_AT_EXEC. Otherwise we must use the
            // SQL_LEN_DATA_AT_EXEC macro to pass the entire length.
            connect.GetInfoString(
                        SQL_NEED_LONG_DATA_LEN,
                        szValue,
                        sizeof(szValue),
                        &iValueReturned );

            if ( !connect.sqlsuccess()
                || strcmpi( szValue, "Y"))
                {
                // bind the BLOB parameter
                cbValue = SQL_DATA_AT_EXEC;
                }
            else
                {
                // bind the BLOB parameter
                cbValue = SQL_LEN_DATA_AT_EXEC( SIZEOF_BINARY );
                }

            connect.AutoReport( bSaveAutoReport );

            pCursor->BindParameter(
                    2,              // col number
                    SQL_PARAM_INPUT,// parm bind type - input only
                    SQL_C_BINARY,   // C type of our storage location
                    SQL_LONGVARBINARY,
                                    // SQL type of the column
                    SIZEOF_BINARY,  // precision and scale are
                    0,              // not used for integral types
                    (PTR)2,         // address of our storage location
                    SIZEOF_BINARY,  // max length
                    &cbValue        // data to be passed at execution
                                    //   time.
                    );

            if ( !pCursor->sqlsuccess())
                {
                    fprintf( stderr, "\nBinding 2d parameter failed.\n");
                    goto bypass;
                }

            pCursor->Prepare( "INSERT INTO BLOBS VALUES (?, ?)");

            if ( !pCursor->sqlsuccess())
                {
                    fprintf( stderr, "\nPrepare() for insert failed.\n");
                    goto bypass;
                }

            // now set up a loop to insert 5 records
            for ( l = 1, ch1 = 'a';
                    pCursor->sqlsuccess() && l <= 5;
                    l++, ch1++, pCursor->Close() )
                {
                // set up parameter for input.
                lKey = l;

                // fill array with character for this record
                for ( i = 0; i < SIZEOF_BINARY; i++)
                    sTestV2.pData[ i ] = ch1;

                // do the insert
                ret = pCursor->Execute();

                if ( ret == SQL_NEED_DATA )
                    {
                    i = 0;

                    // this call also returns SQL_NEED_DATA...
                    ret = pCursor->ParamData( &pRet );
                    if ( ret == SQL_NEED_DATA )
                        do
                            {
                            pCursor->PutData(
                                &sTestV2.pData[ i ],
                                min( BLOB_CHUNK_PUT_SIZE,
                                     SIZEOF_BINARY - i ));
                            } while
                                (
                                  ((i += BLOB_CHUNK_PUT_SIZE)
                                        < SIZEOF_BINARY)
                                  && pCursor->sqlsuccess()
                                ) ;

                    if ( pCursor->sqlsuccess())
                        {
                        // tell 'em you're done.
                        pCursor->ParamData( &pRet );
                        }

                    } // end if passing more data
                } // end for loop on insertions

            // free huge memory
            hfree( sTestV2.pData );
            sTestV2.pData = NULL;

            if ( !pCursor->sqlsuccess())
                {
#if defined(VERBOSE)
                fprintf( stderr, "\nInsert failed.\n");
#endif
                goto bypass;
                }

            pCursor->Close();
            pCursor->ResetParams();

            pCursor->ExecDirect( "SELECT * FROM BLOBS" );
            if ( !pCursor->sqlsuccess())
                {
                fprintf( stderr, "\nExecDirect() failed.\n");
                goto bypass;
                }

            // bind columns using data dictionary, which just binds
            // a column for the keyfield.
            pCursor->BindCol(
                        QueryResultSet,
                        QueryResultSetCount,
                        &sTestV2
                        );

            pCursor->AutoReport( odbcREPERRS );

            for ( pCursor->Fetch(); pCursor->sqlsuccess(); pCursor->Fetch() )
                {

                // do GetData on the BLOB.
                cbValue = 0;
                i = 0;

                pCursor->GetData(
                            2,
                            SQL_C_BINARY,
                            &c,
                            0,  // to find out how much there is.
                            &cbValue
                            );

                if ( !pCursor->sqlsuccess())
                    {
                    continue;
                    }

                if ( cbValue == SQL_NULL_DATA )
                    {
#if !defined( WIN32 )
                    sTestV2.pData = (char huge *)halloc( strlen( "<null data>" ) + 1, 1);
#else
                    sTestV2.pData = halloc( strlen( "<null data>" ) + 1, 1);
#endif
                    if ( sTestV2.pData )
                        strcpy( (char *)sTestV2.pData, "<null data>" );
                    }
                else if ( cbValue == 0 )
                    {
#if !defined( WIN32 )
                    sTestV2.pData = (char huge *)halloc( strlen( "<no data>" ) + 1, 1);
#else
                    sTestV2.pData = halloc( strlen( "<no data>" ) + 1, 1);
#endif
                    if ( sTestV2.pData )
                        strcpy( (char *)sTestV2.pData, "<no data>" );
                    }
                else
#if !defined( WIN32 )
                    sTestV2.pData = (char huge *)halloc( cbValue, 1);
#else
					sTestV2.pData = halloc( cbValue, 1);
#endif

                if ( cbValue > 0 && !sTestV2.pData )
                    {
                    fprintf( stderr, "\nmemory allocation failed.\n");
                    goto bypass;
                    }

                if ( cbValue != SQL_NULL_DATA && cbValue > 0 )
                    {
                    // do get data loop
                    for (
                        i = 0,
                        cbRemaining = cbValue;

                        pCursor->lastRC() == SQL_SUCCESS_WITH_INFO
                             && i < cbValue;

                        i += BLOB_CHUNK_GET_SIZE,
                        cbRemaining -= BLOB_CHUNK_GET_SIZE
                        )
                        {
                        pCursor->GetData(
                                2,
                                SQL_C_BINARY,
                                &sTestV2.pData[ i ],
                                min (
                                    BLOB_CHUNK_GET_SIZE,
                                    cbRemaining ),
                                &cbRemaining
                                );
                        }

                    if ( !pCursor->sqlsuccess())
                        continue;
                    }

#if defined(VERBOSE)

                // guarantee our bogus data is null-terminated.
                sTestV2.pData[ cbValue - 1 ] = 0;

                fprintf( stderr, "\nRetrieved record "
                                "for %15.15s %10.10s (%f)...",
                    !sTestV2.pData ?
                        "?" :
                        (char *)sTestV2.pData,
                    !sTestV2.pData ?
                        "?" :
                        (char *)&sTestV2.pData[ cbValue - 11 ],
                    sTestV2.dKeyField
                    );

                if ( sTestV2.pData )
                    {
                    hfree( sTestV2.pData );
                    sTestV2.pData = NULL;
                    }
#endif
                }

                // updating BLOBs is not shown here, but the operations
                // are fundamentally the same as insertion in any case.
bypass:
            // cursor object will be freed as it goes out of
            // scope on this next closing brace.

            ; // Microsoft VC++ is unhappy without an empty statement here.

            } // end if (connect.sqlsuccess())

            // disconnection occurs in the connect destructor,
            // and so is the freeing of the connection handle

        } // if (env.sqlsuccess())

    fprintf( stderr, "\nExecution complete!\n" );
    }
