/************************************************/
/*  This file uses the INTERSOLV dBASE driver.  */
/************************************************/
/*
    File:       TYPEINFO.CPP
    
    Revision:   1.0 Release
    
    Date:       17-Apr-1994

    Author:     Dale Hunscher
    
    Description:

    Studying this EasyWin/QuickWin file will give you insight into the use
    of the library's features to use the system catalog functions.
    The output of the program is also useful in building SQL state-
    ments for creating tables.

    To use this program, run it; enter a filename for the output,
    and select a data source.
       
    /////////////////////////////////////////////////////////////
    ///////////////////// NOTICE ////////////////////////////////
    /////////////////////////////////////////////////////////////
                                                                     
    Copyright (c) 1994 by INTERSOLV, Inc. All rights reserved.

    Information in this document is subject to change without
    notice and does not represent a commitment on the part of
    INTERSOLV, Inc. This software is provided under
    a license agreement or non-disclosure agreement. The software
    may be used and/or copied only in accordance with the terms
    of the governing agreement. It is against the law to copy
    the software on any medium except as specifically allowed
    in the governing agreement. No part of this software may be 
    reproduced or transmitted in any form or by any means, 
    electronic or mechanical, including photocopying, recording,
    or information storage and retrieval systems, for any purpose
    other than the licensee's personal use, without the express
    written permission of INTERSOLV, Inc.
    
    /////////////////////////////////////////////////////////////
*/


#include <sql.hpp>
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <memory.h>

#include <windows.h>


/*
  GetTypeName takes a SQL type and returns the name as
  a string.
*/
LPSTR GetTypeName( SWORD fSqlType )
  {
  switch ( fSqlType )
    {
      case  SQL_CHAR          : //  1
        return "SQL_CHAR" ;

      case  SQL_NUMERIC       : //  2
        return "SQL_NUMERIC" ;

      case  SQL_DECIMAL       : //  3
        return "SQL_DECIMAL" ;

      case  SQL_INTEGER       : //  4
        return "SQL_INTEGER" ;

      case  SQL_SMALLINT      : //  5
        return "SQL_SMALLINT" ;

      case  SQL_FLOAT         : //  6
        return "SQL_FLOAT" ;

      case  SQL_REAL          : //  7
        return "SQL_REAL" ;

      case  SQL_DOUBLE        : //  8
        return "SQL_DOUBLE" ;

      case  SQL_DATE          : //  9
        return "SQL_DATE" ;

      case  SQL_TIME          : // 10
        return "SQL_TIME" ;

      case  SQL_TIMESTAMP     : // 11
        return "SQL_TIMESTAMP" ;

      case  SQL_VARCHAR       : // 12
        return "SQL_VARCHAR" ;

      case  SQL_LONGVARCHAR   : // (-1)
        return "SQL_LONGVARCHAR" ;

      case  SQL_BINARY        : // (-2)
        return "SQL_BINARY" ;

      case  SQL_VARBINARY     : // (-3)
        return "SQL_VARBINARY" ;

      case  SQL_LONGVARBINARY : // (-4)
        return "SQL_LONGVARBINARY" ;

      case  SQL_BIGINT        : // (-5)
        return "SQL_BIGINT" ;

      case  SQL_TINYINT       : // (-6)
        return "SQL_TINYINT" ;

      case  SQL_BIT           : // (-7)
        return "SQL_BIT" ;

      default :
        break ;
    } // end switch
  return "?" ;
  }

#if defined( WIN32 )
// this error routine will be called automatically when 
// an error occurs (see odbcbase.hpp for details).
void CALLBACK PrintErr(
    RETCODE         lastRet,
    UCHAR FAR *     szSqlState,
    SDWORD          fNativeError,
    UCHAR FAR *     szErrorMsg,
    odbcBASE FAR *  pObj
    )
    {
    char buf[ 80 ];

    MessageBeep( MB_ICONEXCLAMATION );
    fprintf( stderr, "Ret: %ld\nMsg: %s\nSQL: %s\n Nat: %ld\n\n"
    			"Press Enter to continue...\n",
                lastRet,
                (LPSTR)szErrorMsg,
                (LPSTR)szSqlState,
                fNativeError);
                
    gets(buf);
    }

#endif

void main(int , char **)
    {
    // instantiate an environment.  This allocates
    // an ODBC environment handle for the app.
    odbcENV env;

	//buffer for input
    char buf[ 80 ];

    // for fopen() and DriverConnectPrompt()
    char buffer[255] ; 

    FILE *fd = stderr ;
    static char *opening[] = {
    "                           TYPEINFO\n\n",
    "This program will allow you to connect to an ODBC driver\n",
    "and will then information on the data types supported by that\n",
    "driver to a file of your choice.\n\n",
    } ;
    static int nOpenings = sizeof(opening)/sizeof(opening[0]);
    for ( int i = 0 ; i < nOpenings ; i++ )
        fprintf( stderr, opening[ i ]);
        
    fprintf( stderr, "Enter filename for output (Enter for stderr):\n" );

    if (gets(buffer) == NULL )
       {
       fprintf( stderr, "filename get failed, or you pressed ctrl-Z.\n");
       goto afterwards;
       }

    if (lstrlen(buffer) > 0)
        if ((fd = fopen(buffer, "w")) == NULL)
           {
           fprintf(stderr, "open failed.\n");
           goto afterwards;
           }

    env.AutoRetrieve(odbcREPSUCCESSWITHINFO);
    env.AutoReport(odbcREPSUCCESSWITHINFO);
#if !defined( WIN32 )
    env.SetWnd( GetActiveWindow() );
#else
	env.SetErrHandler( PrintErr ) ;
#endif
    if (env.sqlsuccess())
        {
        // use Cursor Library if needed
        env.nCursorLibUsage = SQL_CUR_USE_IF_NEEDED;
        // or uncomment this to always use the C.L.
        //env.nCursorLibUsage = SQL_CUR_USE_ODBC;
        
        // using environment constructed in WinMain(),
        // instantiate a connection. This does not perform the
        // connection.
        odbcCONNECT connect( &env ) ;

        // use the default error handling mechanism to report
        // errors; ignore success-with-info returns.

        connect.AutoRetrieve(odbcREPERRS);
        connect.AutoReport(odbcREPERRS);
#if !defined( WIN32 )
        connect.SetWnd( GetActiveWindow() );
#endif

        fprintf(fd, "\nConnecting...\n\n");
        connect.Connect(
                        "dBASEFile",
                        "",
                        "");

        // if we fail, we already talked to the user, so close
        // up and go home.
        if ( !connect.sqlsuccess() )
          {
          fprintf( stderr, "\nConnection failed.\n") ;
		  gets( buf );
          goto afterwards ;
          }

        // instantiate a type info iterator. This executes the
        // query, so we need to do after construction is begin
        // using the result set.

        odbcTypeInfoIterator iter(&connect);

        // if we fail, we already talked to the user, so close
        // up and go home.
        if ( !iter.sqlsuccess())
          {
          fprintf( stderr, "\nodbcTypeInfoIterator constructor"
                           " failed.\n") ;
          goto afterwards ;
          }

        // get a pointer to the result set structure:
        /*
        const int STRING1_MAX               = 128;

        struct odbcEXPORTED sSQLTYPEINFORESULTSET {
          UCHAR szTypeName[STRING1_MAX];
          SWORD fDataType;
          SDWORD fPrecision;
          UCHAR szLiteralPrefix[STRING1_MAX];
          UCHAR szLiteralSuffix[STRING1_MAX];
          UCHAR szCreateParams[STRING1_MAX];
          SWORD fNullable;
          SWORD fCaseSensitive;
          SWORD fSearchable;
          SWORD fUnsigned;
          SWORD fMoney;
          SWORD fAutoIncrement;
          UCHAR szLocalTypeName[STRING1_MAX];
          };
        */
        cpsSQLTYPEINFORESULTSET pResult = iter.pTypeInfoResultSet();
        int i;
        const SDWORD *pValue;
        for ( i = 1,
              iter.GetFirst() ;
              iter.sqlsuccess() ;
              iter.GetNext(),
              i = 1
            )
          {
            pValue = iter.ColResultSizeArray( i++ );
            fprintf( fd,
                      "szTypeName:\t%s\n",
                     // *pValue == SQL_NULL_DATA ? "<null>" :
                      pResult->szTypeName
                      );

            // append next line of text
            pValue = iter.ColResultSizeArray( i++ );
            fprintf( fd,
                      "  fDataType:\t%s\n",
                      *pValue == SQL_NULL_DATA ? "<null>" :
                      GetTypeName(pResult->fDataType)
                      );

            // append next line of text
            pValue = iter.ColResultSizeArray( i++ );
            fprintf( fd,
                      "  fPrecision:\t%ld\n",
                      *pValue == SQL_NULL_DATA ? 0L :
                      pResult->fPrecision
                      );

            // append next line of text
            pValue = iter.ColResultSizeArray( i++ );
            fprintf( fd,
                      "  szLiteralPrefix:\t%s\n",
                      //*pValue == SQL_NULL_DATA ? "<null>" :
                      pResult->szLiteralPrefix
                      );

            // append next line of text
            pValue = iter.ColResultSizeArray( i++ );
            fprintf( fd,
                      "  szLiteralSuffix:\t%s\n",
                     // *pValue == SQL_NULL_DATA ? "<null>" :
                      pResult->szLiteralSuffix
                      );

            // append next line of text
            pValue = iter.ColResultSizeArray( i++ );
            fprintf( fd,
                      "  szCreateParams:\t%s\n",
                     // *pValue == SQL_NULL_DATA ? "<null>" :
                      pResult->szCreateParams
                      );

            // append next line of text
            pValue = iter.ColResultSizeArray( i++ );
            fprintf( fd,
                      "  fNullable:\t%s\n",
                      *pValue == SQL_NULL_DATA ? "<null>" :
                      (pResult->fNullable ? "Yes" : "No")
                      );

            // append next line of text
            pValue = iter.ColResultSizeArray( i++ );
            fprintf( fd,
                      "  fCaseSensitive:\t%s\n",
                      *pValue == SQL_NULL_DATA ? "<null>" :
                      (pResult->fCaseSensitive ? "Yes" : "No")
                      );

            // append next line of text
            pValue = iter.ColResultSizeArray( i++ );
            fprintf( fd,
                      "  fSearchable:\t%s\n",
                      *pValue == SQL_NULL_DATA ? "<null>" :
                      (pResult->fSearchable ? "Yes" : "No")
                      );

            // append next line of text
            pValue = iter.ColResultSizeArray( i++ );
            fprintf( fd,
                      "  fUnsigned:\t%s\n",
                      *pValue == SQL_NULL_DATA ? "<null>" :
                      (pResult->fUnsigned ? "Yes" : "No")
                      );

            // append next line of text
            pValue = iter.ColResultSizeArray( i++ );
            fprintf( fd,
                      "  fMoney:\t%s\n",
                      *pValue == SQL_NULL_DATA ? "<null>" :
                      (pResult->fMoney ? "Yes" : "No")
                      );

            // append next line of text
            pValue = iter.ColResultSizeArray( i++ );
            fprintf( fd,
                      "  fAutoIncrement:\t%s\n",
                      *pValue == SQL_NULL_DATA ? "<null>" :
                      (pResult->fAutoIncrement ? "Yes" : "No")
                      );

            // append next line of text
            pValue = iter.ColResultSizeArray( i++ );
            fprintf( fd,
                      "  szLocalTypeName:\t%s\n",
                     // *pValue == SQL_NULL_DATA ? "<null>" :
                      pResult->szLocalTypeName
                      );

            fprintf( fd, "\n" ) ;

            if ( fd == stderr )
                {
                fprintf( stderr, "More...");
                gets(buffer);
                fprintf( stderr, "\n\n");
                }

          } // end for loop

        if ( fd == stderr )
            {
            fprintf( stderr, "And now, backwards...");
            gets(buffer);
            fprintf( stderr, "\n\n");
            }
        // now go through backward, if scrolling is supported
        for ( i = 1,
              iter.GetLast() ;
              iter.sqlsuccess() ;
              iter.GetPrev(),
              i = 1
            )
          {
            fprintf( fd,
                      "szTypeName:\t%s\n",
                      //iter.IsColValueNull( i++ ) ? "<null>" :
                      pResult->szTypeName
                      );

            // append next line of text
            pValue = iter.ColResultSizeArray( i++ );
            fprintf( fd,
                      "  fDataType:\t%s\n",
                      iter.IsColValueNull( i++ ) ? "<null>" :
                      GetTypeName(pResult->fDataType)
                      );

            // append next line of text
            pValue = iter.ColResultSizeArray( i++ );
            fprintf( fd,
                      "  fPrecision:\t%ld\n",
                      iter.IsColValueNull( i++ ) ? 0L :
                      pResult->fPrecision
                      );

            // append next line of text
            pValue = iter.ColResultSizeArray( i++ );
            fprintf( fd,
                      "  szLiteralPrefix:\t%s\n",
                      //iter.IsColValueNull( i++ ) ? "<null>" :
                      pResult->szLiteralPrefix
                      );

            // append next line of text
            pValue = iter.ColResultSizeArray( i++ );
            fprintf( fd,
                      "  szLiteralSuffix:\t%s\n",
                      //iter.IsColValueNull( i++ ) ? "<null>" :
                      pResult->szLiteralSuffix
                      );

            // append next line of text
            pValue = iter.ColResultSizeArray( i++ );
            fprintf( fd,
                      "  szCreateParams:\t%s\n",
                      //iter.IsColValueNull( i++ ) ? "<null>" :
                      pResult->szCreateParams
                      );

            // append next line of text
            pValue = iter.ColResultSizeArray( i++ );
            fprintf( fd,
                      "  fNullable:\t%s\n",
                      iter.IsColValueNull( i++ ) ? "<null>" :
                      (pResult->fNullable ? "Yes" : "No")
                      );

            // append next line of text
            pValue = iter.ColResultSizeArray( i++ );
            fprintf( fd,
                      "  fCaseSensitive:\t%s\n",
                      iter.IsColValueNull( i++ ) ? "<null>" :
                      (pResult->fCaseSensitive ? "Yes" : "No")
                      );

            // append next line of text
            pValue = iter.ColResultSizeArray( i++ );
            fprintf( fd,
                      "  fSearchable:\t%s\n",
                      iter.IsColValueNull( i++ ) ? "<null>" :
                      (pResult->fSearchable ? "Yes" : "No")
                      );

            // append next line of text
            pValue = iter.ColResultSizeArray( i++ );
            fprintf( fd,
                      "  fUnsigned:\t%s\n",
                      iter.IsColValueNull( i++ ) ? "<null>" :
                      (pResult->fUnsigned ? "Yes" : "No")
                      );

            // append next line of text
            pValue = iter.ColResultSizeArray( i++ );
            fprintf( fd,
                      "  fMoney:\t%s\n",
                      iter.IsColValueNull( i++ ) ? "<null>" :
                      (pResult->fMoney ? "Yes" : "No")
                      );

            // append next line of text
            pValue = iter.ColResultSizeArray( i++ );
            fprintf( fd,
                      "  fAutoIncrement:\t%s\n",
                      iter.IsColValueNull( i++ ) ? "<null>" :
                      (pResult->fAutoIncrement ? "Yes" : "No")
                      );

            // append next line of text
            pValue = iter.ColResultSizeArray( i++ );
            fprintf( fd,
                      "  szLocalTypeName:\t%s\n",
                      //iter.IsColValueNull( i++ ) ? "<null>" :
                      pResult->szLocalTypeName
                      );

            fprintf( fd, "\n" ) ;

            if ( fd == stderr )
                {
                fprintf( stderr, "More...");
                gets(buffer);
                fprintf( stderr, "\n\n");
                }
          } // end for loop

      } // env.sqlsuccess()

afterwards:
    if (fd != NULL && fd != stderr)
        fclose(fd);

    fprintf( stderr, "\nExecution complete!\n" );
    gets(buf);
  }
    
