/****************************************************/
/*  This file uses the INTERSOLV SQLServer driver.  */
/****************************************************/
/*
    File:       PROCEDRS.CPP
    
    Revision:   1.0 Release
    
    Date:       17-Apr-1994

    Author:     Dale Hunscher
    
    Description:

    Studying this EasyWin/QuickWin file will give you insight into the use
    of the library's features to use the system catalog functions.
    The output of the program is also useful in building SQL state-
    ments for creating tables.

    To use this program, run it; enter a filename for the output,
    and select a data source.
       
    /////////////////////////////////////////////////////////////
    ///////////////////// NOTICE ////////////////////////////////
    /////////////////////////////////////////////////////////////
                                                                     
    Copyright (c) 1994 by INTERSOLV, Inc. All rights reserved.

    Information in this document is subject to change without
    notice and does not represent a commitment on the part of
    INTERSOLV, Inc. This software is provided under
    a license agreement or non-disclosure agreement. The software
    may be used and/or copied only in accordance with the terms
    of the governing agreement. It is against the law to copy
    the software on any medium except as specifically allowed
    in the governing agreement. No part of this software may be 
    reproduced or transmitted in any form or by any means, 
    electronic or mechanical, including photocopying, recording,
    or information storage and retrieval systems, for any purpose
    other than the licensee's personal use, without the express
    written permission of INTERSOLV, Inc.
        
    /////////////////////////////////////////////////////////////
*/


#include <sql.hpp>
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <memory.h>

#include <windows.h>


/*
  GetTypeName takes a SQL type and returns the name as
  a string.
*/
LPSTR GetTypeName( SWORD fSqlType )
  {
  switch ( fSqlType )
    {
      case  SQL_CHAR          : //  1
        return "SQL_CHAR" ;

      case  SQL_NUMERIC       : //  2
        return "SQL_NUMERIC" ;

      case  SQL_DECIMAL       : //  3
        return "SQL_DECIMAL" ;

      case  SQL_INTEGER       : //  4
        return "SQL_INTEGER" ;

      case  SQL_SMALLINT      : //  5
        return "SQL_SMALLINT" ;

      case  SQL_FLOAT         : //  6
        return "SQL_FLOAT" ;

      case  SQL_REAL          : //  7
        return "SQL_REAL" ;

      case  SQL_DOUBLE        : //  8
        return "SQL_DOUBLE" ;

      case  SQL_DATE          : //  9
        return "SQL_DATE" ;

      case  SQL_TIME          : // 10
        return "SQL_TIME" ;

      case  SQL_TIMESTAMP     : // 11
        return "SQL_TIMESTAMP" ;

      case  SQL_VARCHAR       : // 12
        return "SQL_VARCHAR" ;

      case  SQL_LONGVARCHAR   : // (-1)
        return "SQL_LONGVARCHAR" ;

      case  SQL_BINARY        : // (-2)
        return "SQL_BINARY" ;

      case  SQL_VARBINARY     : // (-3)
        return "SQL_VARBINARY" ;

      case  SQL_LONGVARBINARY : // (-4)
        return "SQL_LONGVARBINARY" ;

      case  SQL_BIGINT        : // (-5)
        return "SQL_BIGINT" ;

      case  SQL_TINYINT       : // (-6)
        return "SQL_TINYINT" ;

      case  SQL_BIT           : // (-7)
        return "SQL_BIT" ;

      default :
        break ;
    } // end switch
  return "?" ;
  }

#if defined( WIN32 )
// this error routine will be called automatically when 
// an error occurs (see odbcbase.hpp for details).
void CALLBACK PrintErr(
    RETCODE         lastRet,
    UCHAR FAR *     szSqlState,
    SDWORD          fNativeError,
    UCHAR FAR *     szErrorMsg,
    odbcBASE FAR *  pObj
    )
    {
    char buf[ 80 ];

    MessageBeep( MB_ICONEXCLAMATION );
    fprintf( stderr, "Ret: %ld\nMsg: %s\nSQL: %s\n Nat: %ld\n\n"
    			"Press Enter to continue...\n",
                lastRet,
                (LPSTR)szErrorMsg,
                (LPSTR)szSqlState,
                fNativeError);
                
    gets(buf);
    }

#endif


void main(int , char **)
    {
    // instantiate an environment.  This allocates
    // an ODBC environment handle for the app.
    odbcENV env;
	// buffer for input
    char buf[80], UID[80], PWD[80];
    // for fopen() 
    char buffer[255] ; 

    FILE *fd = stderr ;
    static char *opening[] = {
    "                           PROCEDRS\n\n",
    "This program will allow you to connect to an ODBC driver\n",
    "and will then information on the data types supported by that\n",
    "driver to a file of your choice.\n\n",
    } ;
    static int nOpenings = sizeof(opening)/sizeof(opening[0]);
    for ( int i = 0 ; i < nOpenings ; i++ )
        fprintf( stderr, opening[ i ]);
        
    fprintf( stderr, "Enter filename for output (Enter for stderr):\n" );

    if (gets(buffer) == NULL )
       {
       fprintf( stderr, "filename get failed, or you pressed ctrl-Z.\n");
       goto afterwards;
       }

    if (lstrlen(buffer) > 0)
        if ((fd = fopen(buffer, "w")) == NULL)
           {
           fprintf(stderr, "open failed.\n");
           goto afterwards;
           }

    env.AutoRetrieve(odbcREPSUCCESSWITHINFO);
    env.AutoReport(odbcREPSUCCESSWITHINFO);
#if !defined( WIN32 )
    env.SetWnd( GetActiveWindow()) ;
#else
	env.SetErrHandler( PrintErr ) ;
#endif
    if (env.sqlsuccess())
        {
        // use Cursor Library if needed
        env.nCursorLibUsage = SQL_CUR_USE_IF_NEEDED;
        
        // using environment constructed in WinMain(),
        // instantiate a connection. This does not perform the
        // connection.
        odbcCONNECT connect( &env ) ;

        // use the default error handling mechanism to report
        // errors; ignore success-with-info returns.

        connect.AutoRetrieve(odbcREPERRS);
        connect.AutoReport(odbcREPERRS);
#if !defined( WIN32 )
        connect.SetWnd( GetActiveWindow() );
#endif  
        fprintf(stderr, "\nConnecting to target...\n");
            fprintf( stderr, "\nEnter your SQLServer User ID: " );

        	if (gets(UID) == NULL )
           		{
           		fprintf( stderr, "get failed, or you pressed ctrl-Z.\n");
           		return;
           		}

        	fprintf( stderr, "\nEnter your SQLServer password: " );

        	if (gets(PWD) == NULL )
           		{
           		fprintf( stderr, "get failed, or you pressed ctrl-Z.\n");
           		return;
           		}
            connect.Connect(
                   "SQLServer",
                   UID,
                   PWD
                   );

        // if we fail, we already talked to the user, so close
        // up and go home.
        if ( !connect.sqlsuccess() )
          {
          fprintf( stderr, "\nConnection failed.\n") ;
		  gets( buf );
          goto afterwards ;
          }

        // instantiate a type info iterator. This executes the
        // query, so we need to do after construction is begin
        // using the result set.

        odbcProceduresIterator iter(&connect,NULL_LPSTR,NULL_LPSTR,NULL_LPSTR);
        // if we fail, we already talked to the user, so close
        // up and go home.
        if ( !iter.sqlsuccess())
          {
          fprintf( stderr, "\nodbcProceduresIterator constructor"
                           " failed.\n") ;
          goto afterwards ;
          }

        // get a pointer to the result set structure:
        /*
        const int STRING1_MAX               = 128;

         struct odbcEXPORTED sPROCEDURESRESULTSET {
 		 char                 szProcedure_qualifier[ PROCEDURE_QUALIFIER_SIZE ];
 		 char                 szProcedure_owner[ PROCEDURE_OWNER_SIZE ];
 		 char                 szProcedure_name[ PROCEDURE_NAME_SIZE ];
 		 long                 lNum_input_params;
 		 long                 lNum_output_params;
 		 long                 lNum_result_sets;
 		 char                 szRemarks[ REMARKS_SIZE ];
		 };
        */
        cpsPROCEDURESRESULTSET pResult = iter.pProceduresResultSet();

        for ( iter.GetFirst() ;
              iter.sqlsuccess() ;
              iter.GetNext()
            )
          {
            fprintf( fd,
                      "szProcedure_qualifier:\t%s\n",
                      pResult->szProcedure_qualifier
                      );
            fprintf( fd,
                      "szProcedure_owner:\t%s\n",
                      pResult->szProcedure_owner
                      );
            fprintf( fd,
                      "szProcedure_name:\t%s\n",
                      pResult->szProcedure_name
                      );          
            
            // append next line of text
            fprintf( fd,
                      "  lNum_input_params:\t%ld\n",
                      pResult->lNum_input_params
                      );
            fprintf( fd,
                      "  lNum_output_params:\t%ld\n",
                      pResult->lNum_output_params
                      );  
            fprintf( fd,
                      "  lNum_result_set:\t%ld\n",
                      pResult->lNum_result_sets
                      );          
            // append next line of text
            fprintf( fd,
                      "  szRemarks:\t%s\n",
                      pResult->szRemarks
                      );

           
            fprintf( fd, "\n" ) ;

            if ( fd == stderr )
                {
                fprintf( stderr, "More...");
                getchar();
                fprintf( stderr, "\n\n");
                }

          } // end for loop

        // now go through backward, if scrolling is supported
        for ( iter.GetLast() ;
              iter.sqlsuccess() ;
              iter.GetPrev()
            )
          {
            fprintf( fd,
                      "szProcedure_qualifier:\t%s\n",
                      pResult->szProcedure_qualifier
                      );
            fprintf( fd,
                      "szProcedure_owner:\t%s\n",
                      pResult->szProcedure_owner
                      );
            fprintf( fd,
                      "szProcedure_name:\t%s\n",
                      pResult->szProcedure_name
                      );          
            
            // append next line of text
            fprintf( fd,
                      "  lNum_input_params:\t%ld\n",
                      pResult->lNum_input_params
                      );
            fprintf( fd,
                      "  lNum_output_params:\t%ld\n",
                      pResult->lNum_output_params
                      );  
            fprintf( fd,
                      "  lNum_result_set:\t%ld\n",
                      pResult->lNum_result_sets
                      );          
            // append next line of text
            fprintf( fd,
                      "  szRemarks:\t%s\n",
                      pResult->szRemarks
                      );

            fprintf( fd, "\n" ) ;

            if ( fd == stderr )
                {
                fprintf( stderr, "More...");
                getchar();
                fprintf( stderr, "\n\n");
                }

          } // end for loop

      } // env.sqlsuccess()

afterwards:
    if (fd != NULL && fd != stderr)
        fclose(fd);

    fprintf( stderr, "\nExecution complete!\n" );
	gets( buf );

  }
    
