/****************************************************/
/*  This file uses the INTERSOLV SQLServer driver.  */
/****************************************************/
/*
    File:       POSUPDAT.CPP
    
    Revision:   1.0 release
    
    Date:       14-Mar-1994

    Author:     Dale Hunscher
    
    Description:

    Studying this QuickWin/EasyWin file will give you insight into the use
    of the library's features to perform positioned updates. Positioned
    deletes are performed in a similar fashion, but more simply.
    
    This example program takes advantage of the library's AutoBind()
    mechanism.  AutoBind() must be called after calling ExtFetchSetup()
    to establish the number of result set rows to fetch in the block
    cursor's rowset.
    
    /////////////////////////////////////////////////////////////
    ///////////////////// NOTICE ////////////////////////////////
    /////////////////////////////////////////////////////////////
                                                                     
    Copyright (c) 1994 by INTERSOLV, Inc. All rights reserved.

    Information in this document is subject to change without
    notice and does not represent a commitment on the part of
    INTERSOLV, Inc. This software is provided under
    a license agreement or non-disclosure agreement. The software
    may be used and/or copied only in accordance with the terms
    of the governing agreement. It is against the law to copy
    the software on any medium except as specifically allowed
    in the governing agreement. No part of this software may be 
    reproduced or transmitted in any form or by any means, 
    electronic or mechanical, including photocopying, recording,
    or information storage and retrieval systems, for any purpose
    other than the licensee's personal use, without the express
    written permission of INTERSOLV, Inc.
    
    /////////////////////////////////////////////////////////////
*/


#include <sql.hpp>
#include <stdio.h>
#include <string.h>
#include <memory.h>

#include <windows.h>

// number of rows of data in our rowset.
const int ROWS = 4;
// sizes for structure definition for parameters.
// structure of accounts table is
// acctno       char(10)
// accttype     char(1)
// acctname     char(5)
// openbal      numeric(10,2)

const int ACCTNOSIZE = 11;
const int ACCTTYPESIZE = 2;
const int ACCTNAMESIZE = 6;
const int OPENBALSIZE = sizeof(double);
const int OPENBALPRECISION = 10;
const int OPENBALSCALE = 2;

// block result storage structure.  SQL expects addresses of 
// arrays of storage locations when binding multiple result
// rows.                

struct ACCTSPARMS {
        UCHAR   AcctNos[ROWS][ACCTNOSIZE];
        UCHAR   AcctTypes[ROWS][ACCTTYPESIZE];
        UCHAR   AcctNames[ROWS][ACCTNAMESIZE];
        double  OpenBals[ROWS];
        } FAR *pAcctParms = NULL;

#if defined( WIN32 )
// this error routine will be called automatically when 
// an error occurs (see odbcbase.hpp for details).
void CALLBACK PrintErr(
    RETCODE         lastRet,
    UCHAR FAR *     szSqlState,
    SDWORD          fNativeError,
    UCHAR FAR *     szErrorMsg,
    odbcBASE FAR *  pObj
    )
    {
    char buf[ 80 ];

    MessageBeep( MB_ICONEXCLAMATION );
    fprintf( stderr, "Ret: %ld\nMsg: %s\nSQL: %s\n Nat: %ld\n\n"
    			"Press Enter to continue...\n",
                lastRet,
                (LPSTR)szErrorMsg,
                (LPSTR)szSqlState,
                fNativeError);
                
    gets(buf);
    }

#endif


void main(int , char *[])
    {
    // instantiate an environment.  This allocates
    // an ODBC environment handle for the app.
    odbcENV env;
	// buffer for input
    char buf[ 80 ], UID[80], PWD[80];
    // we'll use the return code from time to time
    RETCODE ret;
    // for loop index
    int i;
    // number of returned rows
    UDWORD nReturnedRows;
    
    env.AutoRetrieve(odbcREPSUCCESSWITHINFO);
    env.AutoReport(odbcREPSUCCESSWITHINFO);
#if !defined( WIN32 )
    env.SetWnd( GetActiveWindow()) ;
#else
	env.SetErrHandler( PrintErr ) ;
#endif

    // set cursor lib usage as desired
    env.nCursorLibUsage = SQL_CUR_USE_IF_NEEDED;

    if (env.sqlsuccess())
        {
        // prepare to connect to sample data source
        odbcCONNECT connect(&env);
        
        // make library collect and report error info automatically.
        // this is handled by odbcBASE class.
                        
        connect.AutoRetrieve(odbcREPSUCCESSWITHINFO);
        connect.AutoReport(odbcREPSUCCESSWITHINFO);
        fprintf(stderr, "\nConnecting to target...\n");
            fprintf( stderr, "\nEnter your SQLServer User ID: " );

        	if (gets(UID) == NULL )
           		{
           		fprintf( stderr, "get failed, or you pressed ctrl-Z.\n");
           		return;
           		}

        	fprintf( stderr, "\nEnter your SQLServer password: " );

        	if (gets(PWD) == NULL )
           		{
           		fprintf( stderr, "get failed, or you pressed ctrl-Z.\n");
           		return;
           		}
            connect.Connect(
                   "SQLServer",
                   UID,
                   PWD
                   );
        
        if (connect.sqlsuccess())
            {                      
            // create a cursor 
            odbcCURSOR cursor(&connect);
            char szStmt[128];
            char szCursorName[40];
            SWORD cbCursorNameSize;
            double dNewValue;
            BOOL bPrepared = FALSE;

            // automatically retrieve error info when return code
            // is SQL_ERROR or SQL_SUCCESS_WITH_INFO
            cursor.AutoRetrieve(odbcREPSUCCESSWITHINFO);
            cursor.AutoReport(odbcREPSUCCESSWITHINFO);

            fprintf(stderr, "\nConnection succeeded.\n");
        
            cursor.ExecDirect("SELECT COUNT(*) FROM ACCOUNTS");
            cursor.AutoBind();
            cursor.Fetch();
            switch ( cursor.ColResultInfo(1)->fCType )
                {
            case SQL_C_DOUBLE :
                fprintf( stderr, "\nCount: %f\n", cursor.ColResultAsDouble(1));
                break;

            case SQL_C_LONG :
                fprintf( stderr, "\nCount: %ld\n", cursor.ColResultAsLong(1));
                break;

                }

            cursor.Close();
            if (!cursor.sqlsuccess())
                {
                cursor.Report();
                goto after_select;
                }

            // does driver support scrolling/block cursors?
            
            if (connect.GetFunctions(SQL_API_SQLSETSCROLLOPTIONS))  
                {
                
                fprintf(stderr, "\ninvoking ExtFetchSetup...\n");   
                ret = cursor.ExtFetchSetup
                                    (
                                    SQL_CONCUR_VALUES,
                                    SQL_CURSOR_DYNAMIC,
                                    ROWS
                                    );
                if (!cursor.sqlsuccess())
                    {
                    cursor.Report();
                    goto after_select;
                    }
                    
                if (!cursor.sqlsuccess())
                    {
                    cursor.Report();
                    goto after_select;
                    }
                    
                strcpy(szStmt, "SELECT * FROM ACCOUNTS "
                               "FOR UPDATE OF OPENBAL");

                fprintf(stderr, "Executing select statement:\n%s\n",
                                szStmt);

                // perform the select
                cursor.ExecDirect(szStmt);
                if (!cursor.sqlsuccess())
                    {
                    cursor.Report();
                    goto after_select;
                    }
                     
                cbCursorNameSize = 40;

                cursor.GetCursorName(
                                     szCursorName,
                                     cbCursorNameSize,
                                     &cbCursorNameSize
                                     );
  
                // bind columns automatically
                
                fprintf(stderr, "binding columns on cursor '%s'...\n",
                                szCursorName);

                cursor.AutoBind();
                if (!cursor.sqlsuccess())
                    {
                    cursor.Report();
                    goto after_select;
                    }

                pAcctParms = (ACCTSPARMS FAR *)cursor.pResultSet();
                                                                
                // prepare update statement text
                wsprintf( szStmt,
                          "UPDATE ACCOUNTS "
                          "SET OPENBAL = ? "
                          "WHERE CURRENT OF %s",
                          szCursorName
                          );
                fprintf(stderr, "Creating update "
                                "odbcSTMT with statement"
                                "\n%s\n",
                                szStmt);
                // declare a second statement to perform the update 
                odbcSTMT update(&connect);
                if (!update.sqlsuccess())
                   update.Report();
                else
                    {
                    // automatically retrieve error info when return code
                    // is SQL_ERROR or SQL_SUCCESS_WITH_INFO
                    update.AutoRetrieve(odbcREPSUCCESSWITHINFO);
                    update.AutoReport(odbcREPSUCCESSWITHINFO);

                    // use the address of the double dValue as parameter.
                    update.SetParam(
                               1,
                               SQL_C_DOUBLE,
                               SQL_NUMERIC,
                               OPENBALPRECISION,
                               OPENBALSCALE,
                               &dNewValue,
                               NULL
                               );

                    if (!update.sqlsuccess())
                        update.Report();

                    for (
                        nReturnedRows = cursor.ExtFetchFirst();
                        cursor.sqlsuccess()
                            && update.sqlsuccess()
                            && nReturnedRows > 0;
                        nReturnedRows = cursor.ExtFetchNext()
                        )
                        {
                        if (!bPrepared)
                           {
                           update.Prepare(szStmt);
                           if (!update.sqlsuccess())
                               continue;
                           else
                               bPrepared = TRUE;
                           }
                        fprintf(stderr, "\n\n%s rowset, %lu of %u possible rows:\n\n",
                                cursor.GetExtFetchType() == SQL_FETCH_FIRST
                                    ? "First" : "Next",
                                cursor.GetExtFetchRow(),
                                cursor.GetExtFetchRowCount()
                                );

                        for (i = 0; update.sqlsuccess()
                                    && i < nReturnedRows;
                                    i++)
                            {
                            fprintf(stderr, "before update:\n");
                            fprintf(stderr, "row %u: %s %s %s %10.2f (status: %u)\n",
                                i+1,
                                cursor.ColResultAsLPSTR("ACCTNO",i+1),
                                cursor.ColResultAsLPSTR( 2, i+1),
                                cursor.ColResultAsLPSTR("ACCTNAME",i+1),
                                cursor.ColResultAsDouble( 4, i+1),
                                cursor.GetExtFetchStatus(i+1)
                                );
                            if (cursor.GetExtFetchStatus(i+1) != SQL_ROW_DELETED)
                               {
                               // get existing balance and compute new balance
                               // by adding five per cent interest.
                               dNewValue = cursor.ColResultAsDouble
                                               (
                                               "OPENBAL",
                                               i+1
                                               );
                               // add five per cent interest
                               dNewValue *= 1.05;
                               // the drivers that use the Cursor Library
                               // reguire that we update the rowset buffers
                               // in order for the Library to keep track of
                               // the update in its cache.  We use the column
                               // result address as a pointer to assign the new
                               // value to the appropriate location in the
                               // rowset buffer.  We must cast to a pointer
                               // of the appropriate type since the pointer is
                               // a void pointer.

                               *((double *)cursor.ColResultAddr( "OPENBAL",
                                                                 i+1))
                                 = dNewValue;
                               // set position

                               cursor.SetPos(i+1, SQL_POSITION, SQL_LOCK_NO_CHANGE);
                               if (!cursor.sqlsuccess())
                                   {
                                   continue;
                                   }

                               // just do it.
                               update.Execute();
                               if (!update.sqlsuccess())
                                   continue;
                               fprintf(stderr, "after update:\n");
                               fprintf(stderr, "row %u: %s %s %s %10.2f (status: %u)\n",
                                   i+1,
                                   cursor.ColResultAsLPSTR("ACCTNO",i+1),
                                   cursor.ColResultAsLPSTR( 2, i+1),
                                   cursor.ColResultAsLPSTR("ACCTNAME",i+1),
                                   cursor.ColResultAsDouble( 4, i+1),
                                   cursor.GetExtFetchStatus(i+1)
                                   );
                               } // end inner for loop

                            // reposition to start of rowset
                            cursor.SetPos(1, SQL_POSITION, SQL_LOCK_NO_CHANGE);
                            } // end outer for loop
                        } // end else
                    }
                    
                }
                
                
                
after_select:
            fprintf(stderr, "\n\nComplete.\n");
            fprintf(stderr, "\nPress enter to end.\n");
			gets( buf );
            } // if (connect.sqlsuccess())

        connect.Commit();
        
        // disconnection occurs in the destructor,
        // and so does the freeing of the connection handle
        
        } // if (env.sqlsuccess())
    } // end of main

