/************************************************/
/*  This file uses the INTERSOLV dBASE driver.  */
/************************************************/
/*
    File:       CREDROP.CPP
    
    Revision:   1.0 Release
    
    Date:       17-Apr-1994

    Author:     Dale Hunscher
    
    Description:

    Studying this QuickWin file will give you insight into the use
    of the library's features to create and drop tables and indexes.

    To use this file:

    1) Create a data source matching the name in the Connect()
       statements below for the driver you want to test.

    2) Uncomment the constant below that matches the data source
       you want to test out.

    3) Rebuild the project and run to test it. If the table is being
       created for the first time, the DROP TABLE will fail, of
       course.

    There is currently a problem with the Btrieve desktop driver. If
    we create a table, then drop it, the data dictionary will then go
    into limbo-land; the table cannot be created because it exists (which
    it does, in the DDF), and cannot be dropped because it doesn't exist
    (which it doesn't, or at least the Btrieve file that was originally
    created doesn't exist).
       
    /////////////////////////////////////////////////////////////
    ///////////////////// NOTICE ////////////////////////////////
    /////////////////////////////////////////////////////////////
                                                                     
    Copyright (c) 1994 by INTERSOLV, Inc. All rights reserved.

    Information in this document is subject to change without
    notice and does not represent a commitment on the part of
    INTERSOLV, Inc. This software is provided under
    a license agreement or non-disclosure agreement. The software
    may be used and/or copied only in accordance with the terms
    of the governing agreement. It is against the law to copy
    the software on any medium except as specifically allowed
    in the governing agreement. No part of this software may be 
    reproduced or transmitted in any form or by any means, 
    electronic or mechanical, including photocopying, recording,
    or information storage and retrieval systems, for any purpose
    other than the licensee's personal use, without the express
    written permission of INTERSOLV, Inc.
    
    /////////////////////////////////////////////////////////////
*/


#include <sql.hpp>
#include <stdio.h>
#include <string.h>
#include <memory.h>

#include <windows.h>

#if defined( WIN32 )
// this error routine will be called automatically when 
// an error occurs (see odbcbase.hpp for details).
void CALLBACK PrintErr(
    RETCODE         lastRet,
    UCHAR FAR *     szSqlState,
    SDWORD          fNativeError,
    UCHAR FAR *     szErrorMsg,
    odbcBASE FAR *  pObj
    )
    {
    char buf[ 80 ];

    MessageBeep( MB_ICONEXCLAMATION );
    fprintf( stderr, "Ret: %ld\nMsg: %s\nSQL: %s\n Nat: %ld\n\n"
    			"Press Enter to continue...\n",
                lastRet,
                (LPSTR)szErrorMsg,
                (LPSTR)szSqlState,
                fNativeError);
                
    gets(buf);
    }

#endif

void main(int , char **)
    {
    // instantiate an environment.  This allocates
    // an ODBC environment handle for the app.
    odbcENV env;
	//buffer for input
    char buf[ 80 ];
    // for loop index
    int i;
	 char j[3]= {'1',' ',NULL};
    
    // flag for unique index
    int index = 1;
    //create table statement
    static char szCreateStmt[5000];
    //create unique index
    static char szUniqueIndex[5000];
    
    env.AutoRetrieve(odbcREPSUCCESSWITHINFO);
    env.AutoReport(odbcREPSUCCESSWITHINFO);
#if !defined( WIN32 )
    env.SetWnd( GetActiveWindow()) ;
#else
	env.SetErrHandler( PrintErr ) ;
#endif

    if (env.sqlsuccess())
        {
        // prepare to connect to sample data source
        odbcCONNECT connect(&env);
        
        // make library collect and report error info automatically.
        // this is handled by odbcBASE class.
        LPCSTR lpszQuote = connect.GetIdentifierQuoteMark();                
        connect.AutoRetrieve(odbcREPSUCCESSWITHINFO);
        connect.AutoReport(odbcREPSUCCESSWITHINFO);
#if !defined( WIN32 )
        connect.SetWnd(GetActiveWindow());
#endif

        fprintf(stderr, "\nConnecting ");
        static char szConnBuf[ 256 ];
        connect.Connect(
                   "dBASEFile",
                   "",
                   ""
                   );

        if (connect.sqlsuccess())
            {                      
            // create a statement 
            odbcSTMT stmt(&connect);
            
            fprintf(stderr, "\nConnection succeeded, attempting to drop table TEST1...\n"
                            "(failure is OK if the table has already been dropped or never created!)\n");
        
            // automatically retrieve error info when return code
            // is SQL_ERROR or SQL_SUCCESS_WITH_INFO
            stmt.AutoRetrieve(odbcREPSUCCESSWITHINFO);
            stmt.AutoReport(odbcREPSUCCESSWITHINFO);
#if !defined( WIN32 )
            stmt.SetWnd(GetActiveWindow());
#endif            
            //if the table does not exist this will fail
            stmt.ExecDirect("DROP TABLE test1");
            // if we succeeded, commit the transaction
            if (stmt.sqlsuccess())
               {
               fprintf(stderr, "\ndrop succeeded.\n");
               connect.Commit();
               }
            
            //get all of the types supported by the driver   
             odbcCURSOR cursor(&connect);
             psSQLTYPEINFORESULTSET pTypeInfoSet = new sSQLTYPEINFORESULTSET;
             cursor.GetTypeInfo(SQL_ALL_TYPES);
             cursor.SetNoExtraByteOnStrings(TRUE);
             
             // set column bindings and bind column
             cursor.SetColBindings(
                       connect.SQLTypeInfoRSB(),
                       connect.SQLTypeInfoRSBCount(),
                       pTypeInfoSet
                       ) ;
    		 cursor.BindCol();  
    		 
    		 //build create statement
    		 if (cursor.sqlsuccess())
    		 {
    		 	strcpy(szCreateStmt, lpszQuote);
    		 	strcpy(szUniqueIndex, lpszQuote);
    		 	strcpy(szCreateStmt, "CREATE TABLE test1(");
                strcpy(szUniqueIndex, "CREATE UNIQUE INDEX idx1 ON test1(");
                
                                      
           	 	for (cursor.GetFirst(); cursor.sqlsuccess(); )
    		 	{  //begin for loop
    		    	i=0;
    		    	fprintf(stderr, "%s\n", pTypeInfoSet->szTypeName);
    		    	
    		    	
    		    	
    		    	// add column name and a space
    		    	if (pTypeInfoSet->fDataType != SQL_LONGVARCHAR)
    		    	{
    		    		strcat(szCreateStmt, "col");
    		        	strcat(szCreateStmt, j);
    		    	
    		    		//increase j
    		    		if ((j[0] != '9') && (j[1] == ' '))
    		    	   		j[0]=j[0]+1;
	    		    	else
	    		    		{
	    		    		if (j[0] == '9')
	    		    			{
	    		    			j[0] = '1';
	    		    			j[1] = '0';
	    		    			}
	    		    		else
	    		    			{
	    		    			if(j[1] == '9')
	    		    				{
	    		    				j[1] = '0';
	    		    				j[0] = j[0]+1;
	    		    				}
	    		    			else
	    		    				j[1] = j[1]+1;
	    		    			strcat(szCreateStmt, " ");
	    		    			}    		    	
	    		    	    }
	    		    	//add column type
	    		    	strcat(szCreateStmt, (LPCSTR)pTypeInfoSet->szTypeName);
	    		    	
	    		    	//determine what if any parameters are needed
	    		    	if (pTypeInfoSet->szCreateParams[i] != '\0')
	    		    	{ //begin if szCreateParams != Null
	    		    		if (pTypeInfoSet->fDataType != SQL_CHAR)
	    		    		{ //begin if fDataType != SQL_CHAR
	    		    			while ((pTypeInfoSet->szCreateParams[i] != ',')
	    		    				&& (pTypeInfoSet->szCreateParams[i] != '\0'))
	    		    				i++;
	    		    			if (pTypeInfoSet->szCreateParams[i] != '\0')
	    		    	    		strcat(szCreateStmt, "(5,2)");
	    		    	    	else
	    		    	    		strcat(szCreateStmt, "(5)");
	    		    	    } //end if fDataType != SQL_CHAR
	    		    	    else
	    		    	     	strcat(szCreateStmt, "(10)");
	    		    	} //end if szCreateParams !=Null
	    		    	 
	    		    	if (index)
	    		    	  	{
	    		    	  		if ((pTypeInfoSet->fDataType != SQL_BIT)
	    		    	  		     && (pTypeInfoSet->fDataType != SQL_BINARY)
	    		    	  		     && (pTypeInfoSet->fDataType != SQL_VARBINARY)
	    		    	  		     && (pTypeInfoSet->fDataType != SQL_LONGVARBINARY)
	    		    	  		     && (pTypeInfoSet->fDataType != SQL_LONGVARCHAR)
	    		    	  		     && (pTypeInfoSet->fDataType != SQL_TINYINT))
	    		    	  		     {
	    		    	  		     index = 0;
	    		    	  		     strcat(szUniqueIndex, "col");
	    		    				 strcat(szUniqueIndex, j);
	    		    				 }
	    		    		}		  
	    		    	//get the next record
	    		    	cursor.GetNext();
	    		    	
	    		    	//if there is another record add a comma
	    		    	if (cursor.sqlsuccess())
	    		    		strcat(szCreateStmt, ", ");
    		    	}//end if != SQL_LONGVARCHAR
    		    	else
    		    		cursor.GetNext();
    		    	    		    	
    		 	} //end for loop 
    		 	
    		 	//add ending parathesis and quote mark
    		 	strcat(szCreateStmt, ")");
    		 	strcat(szCreateStmt, lpszQuote);
    		 	strcat(szUniqueIndex, ")");
    		 	strcat(szUniqueIndex, lpszQuote);
    		 	
    		 	//execute the statement
    		 	cursor.Close();
    		 	cursor.ExecDirect(szCreateStmt);
    		 	
    		 	if (cursor.sqlsuccess())
    		 	    {
    		 		fprintf(stderr, "\ncreate succeeded.\n");
    		 		cursor.ExecDirect(szUniqueIndex);
    		 		if (cursor.sqlsuccess())
    		 			{
    		 			fprintf(stderr, "\nunique index created.\n");
    		 			connect.Commit();
    		 			}
    		 		else
    		 			fprintf(stderr, "\ncreate index failed.\n");
    		 		}	
    		 	else
    		 		fprintf(stderr, "\ncreate failed.\n"); 

    		 	gets( buf );
    		  }
    		}
    	} 	
  }
    
