/*************************************************/
/*  This file uses the INTERSOLV dBASE driver.   */
/*************************************************/
/*
    File:       AUTOCRE2.CPP
    
    Revision:   1.0 Release
    
    Date:       17-Apr-1994

    Author:     Dale Hunscher
    
    Description:

    Studying this QuickWin file will give you insight into the use
    of the library's features to create tables automatically using the
    in-place translation method. This version attempts to build a
    table using all possible driver-independent data types; it will
    show you quickly which data types are not supported for a given
    data source.

    To use this file:

    1) Choose a data source.

    2) Examine the translated SQL statement to spot types that are not
       supported.

    NOTE:

    There is currently a problem with the Btrieve desktop driver. If
    we create a table, then drop it, the data dictionary will then go
    into limbo-land; the table cannot be created because it exists (which
    it does, in the DDF), and cannot be dropped because it doesn't exist
    (which it doesn't, or at least the Btrieve file that was originally
    created doesn't exist).

    /////////////////////////////////////////////////////////////
    ///////////////////// NOTICE ////////////////////////////////
    /////////////////////////////////////////////////////////////
                                                                     
    Copyright (c) 1994 by INTERSOLV, Inc. All rights reserved.

    Information in this document is subject to change without
    notice and does not represent a commitment on the part of
    INTERSOLV, Inc. This software is provided under
    a license agreement or non-disclosure agreement. The software
    may be used and/or copied only in accordance with the terms
    of the governing agreement. It is against the law to copy
    the software on any medium except as specifically allowed
    in the governing agreement. No part of this software may be 
    reproduced or transmitted in any form or by any means, 
    electronic or mechanical, including photocopying, recording,
    or information storage and retrieval systems, for any purpose
    other than the licensee's personal use, without the express
    written permission of INTERSOLV, Inc.
    
    /////////////////////////////////////////////////////////////
*/


#include <sql.hpp>
#include <stdio.h>
#include <conio.h>
#include <string.h>
#include <memory.h>

#include <windows.h>

#if defined( WIN32 )
// this error routine will be called automatically when 
// an error occurs (see odbcbase.hpp for details).
void CALLBACK PrintErr(
    RETCODE         lastRet,
    UCHAR FAR *     szSqlState,
    SDWORD          fNativeError,
    UCHAR FAR *     szErrorMsg,
    odbcBASE FAR *  pObj
    )
    {
    char buf[ 80 ];

    MessageBeep( MB_ICONEXCLAMATION );
    fprintf( stderr, "Ret: %ld\nMsg: %s\nSQL: %s\n Nat: %ld\n\n"
    			"Press Enter to continue...\n",
                lastRet,
                (LPSTR)szErrorMsg,
                (LPSTR)szSqlState,
                fNativeError);
                
    gets(buf);
    }

#endif

void main(int , char **)
    {
    // instantiate an environment.  This allocates
    // an ODBC environment handle for the app.
    odbcENV env;
    RETCODE ret;

	//buffer for input
    char buf[ 80 ];

    env.AutoRetrieve(odbcREPSUCCESSWITHINFO);
    env.AutoReport(odbcREPSUCCESSWITHINFO);
#if !defined( WIN32 )
    env.SetWnd( GetActiveWindow()) ;
#else
	env.SetErrHandler( PrintErr ) ;
#endif
    
    // enable cursor library in connections if it's needed.
    env.nCursorLibUsage = SQL_CUR_USE_IF_NEEDED;

    if (env.sqlsuccess())
        {
        // prepare to connect to sample data source
        odbcCONNECT connect(&env);

        // make library collect and report error info automatically.
        // this is handled by odbcBASE class.

        connect.AutoRetrieve(odbcREPSUCCESSWITHINFO);
        connect.AutoReport(odbcREPSUCCESSWITHINFO);
#if !defined( WIN32 )
        connect.SetWnd(GetActiveWindow());
#endif
            static char szConnBuf[ 256 ];
            fprintf(stderr, "\nConnecting...\n");
            connect.Connect(
                  "dBASEFile",
                   "",
                   ""
                   );


            if (connect.sqlsuccess())
                {
                // create a statement
                odbcTABLECREATOR   cursor(&connect);
                cursor.AutoRetrieve(odbcREPSUCCESSWITHINFO);
                cursor.AutoReport(odbcREPSUCCESSWITHINFO);
#if !defined( WIN32 )
                cursor.SetWnd( GetActiveWindow());
#endif

                static char szStmtOut[ 5000 ] ;
                static char szStmtIn[ 5000 ] ;

                UWORD uStmtSize = sizeof(szStmtOut);
                // try to create a table with all possible types
                strcpy( szStmtIn,
                        "CREATE TABLE t1\n"
                        "    (\n"
                        "    c1 <char(20)>,\n"
                        "    c2 <integer>,\n"
                        "    c3 <smallint>,\n"
                        "    c4 <real>,\n"
                        "    c5 <float>,\n"
                        "    c6 <double>,\n"
                        "    c7 <date>,\n"
                        "    c8 <time>,\n"
                        "    c9 <timestamp>,\n"
                        "    cA <varchar(200)>,\n"
                        "    cB <binary(20)>,\n"
                        "    cC <varbinary(2000)>,\n"
                        "    cD <longvarbinary(20000)>,\n"
                        "    cD2 <longvarchar(20000)>,\n"
                        "    cE <bigint>,\n"
                        "    cF <tinyint>,\n"
                        "    cG <bit>,\n"
                        "    cH <numeric(10,2)>,\n"
                        "    cI <decimal(10,2)>\n"
                        "    )\n"
                        );

                fprintf( stderr,
                         "Processing '%s'\n",
                         szStmtIn);

                ret = cursor.CreateTable(
                        szStmtIn,
                        szStmtOut,
                        &uStmtSize,
                        TRUE        // just parse for now.
                        ) ;

                fprintf( stderr,
                         "Ret=%ld, translated as:\n '%s'\n",
                         (long)ret,
                         szStmtOut);
                // if we succeeded, test the statement out
                //    by preparing it on a second cursor.
                if (cursor.sqlsuccess())
                   {
                   odbcCURSOR cursor2(&connect);
                   cursor2.AutoRetrieve(odbcREPERRS);
                   fprintf(stderr, "\ncreate parsing succeeded.\n");
                   if ( !cursor2.sqlsuccess())
                       fprintf( stderr,
                                "Unable to create second cursor"
                                " to try Prepare() call.\n");
                   else
                       {
                       ret = cursor2.Prepare( szStmtOut );
                       if ( cursor2.sqlsuccess() )
                           {
                           fprintf(stderr,
                                    "\nstatement preparation "
                                    "succeeded.\n\n");
                           }
                       else
                           fprintf(stderr, "\nCreate failed, status:"
                                            " %s\n"
                                        "Message: %s.\n",
                                        cursor2.SqlState(),
                                        cursor2.ErrMsg());
                       }
                   }
					 else
                   {
                   fprintf(stderr, "\nCreate failed, status: %s\n"
                                    "Message: %s.\n",
                                    cursor.SqlState(),
                                    cursor.ErrMsg());
                   }
                } // if connect.sqlsuccess()
            else
				{
				fprintf( stderr, "\nCould not connect!\n" );
				gets( buf );
                }

            // disconnect
            connect.Disconnect();
        } // if (env.sqlsuccess())

    fprintf( stderr, "\nExecution complete, use the System Menu to shut down!\n" );
    gets(buf);
  }
